/*********************************************************************/
/* from regdef.v by regdef2h auto-generated C-header file            */
/* please see the regdef.html file for detailed register description */
/*********************************************************************/

#ifndef __regdef_NX10_h
#define __regdef_NX10_h


/* ===================================================================== */

/* Area of ARMiTCM_memarea */

/* ===================================================================== */

#define Addr_NX10_ARMiTCM_memarea 0x00000000U

/* ===================================================================== */

/* AREA intram0_start4 */
/* Area of intram0_mirror_itcm */

/* ===================================================================== */

#define Addr_NX10_intram0_mirror_itcm 0x00000000U

/* --------------------------------------------------------------------- */
/* Register intram0_base_start4 */
/* => internal SRAM AHBL slave 0 start address */
/*    Area size: 64kB */
/*    Read accesses in this memory area: 0WS, byte accessable */
/*    Write accesses in this memory area: 0WS, byte accessable */
/*    Offset 0x0 is ROM Boot-vector */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX10_intram0_base_start4                 0x00000004U
#define Adr_NX10_intram0_mirror_itcm_intram0_base_start4 0x00000004U
#define Adr_NX10_intram0_base_start4                     0x00000004U

/* --------------------------------------------------------------------- */
/* Register intram0_end_start4 */
/* => internal SRAM AHBL slave 0 end address */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX10_intram0_end_start4                 0x0000FFFCU
#define Adr_NX10_intram0_mirror_itcm_intram0_end_start4 0x0000FFFCU
#define Adr_NX10_intram0_end_start4                     0x0000FFFCU


/* ===================================================================== */

/* Area of arm_boot_vector */

/* ===================================================================== */

#define Addr_NX10_arm_boot_vector 0x00000000U

/* --------------------------------------------------------------------- */
/* Register arm_boot_vector */
/* => ARM boot vector. */
/*    This address is mirrored to ROM base address Adr_rom_base. */
/* => Mode: R */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX10_arm_boot_vector             0x00000000U
#define Adr_NX10_arm_boot_vector_arm_boot_vector 0x00000000U
#define Adr_NX10_arm_boot_vector                 0x00000000U


/* ===================================================================== */

/* AREA intram1 */
/* Area of intram1_mirror_itcm, intram1_mirror_dtcm, intram1, intram1_mirror_dpm, intram1_mirror_hi */

/* ===================================================================== */

#define Addr_NX10_intram1_mirror_itcm  0x00010000U
#define Addr_NX10_intram1_mirror_dtcm  0x04010000U
#define Addr_NX10_intram1              0x08010000U
#define NX10_NETX_MEM_INTRN_SRAM1_AREA 0x08010000U
#define Addr_NX10_intram1_mirror_dpm   0x10010000U
#define Addr_NX10_intram1_mirror_hi    0xFFF10000U

/* --------------------------------------------------------------------- */
/* Register intram1_base */
/* => internal SRAM AHBL slave 1 start address */
/*    Area size: 64kB */
/*    Read accesses in this memory area: 0WS, byte accessable */
/*    Write accesses in this memory area: 0WS, byte accessable */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX10_intram1_base                 0x00000000U
#define Adr_NX10_intram1_mirror_itcm_intram1_base 0x00010000U
#define Adr_NX10_intram1_mirror_dtcm_intram1_base 0x04010000U
#define Adr_NX10_intram1_intram1_base             0x08010000U
#define Adr_NX10_intram1_mirror_dpm_intram1_base  0x10010000U
#define Adr_NX10_intram1_mirror_hi_intram1_base   0xFFF10000U

/* --------------------------------------------------------------------- */
/* Register intram1_end */
/* => internal SRAM AHBL slave 1 end address */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX10_intram1_end                 0x0000FFFCU
#define Adr_NX10_intram1_mirror_itcm_intram1_end 0x0001FFFCU
#define Adr_NX10_intram1_mirror_dtcm_intram1_end 0x0401FFFCU
#define Adr_NX10_intram1_intram1_end             0x0801FFFCU
#define Adr_NX10_intram1_mirror_dpm_intram1_end  0x1001FFFCU
#define Adr_NX10_intram1_mirror_hi_intram1_end   0xFFF1FFFCU


/* ===================================================================== */

/* AREA intram2 */
/* Area of intram2_mirror_itcm, intram2_mirror_dtcm, intram2, intram2_mirror_dpm, intram2_mirror_hi */

/* ===================================================================== */

#define Addr_NX10_intram2_mirror_itcm  0x00020000U
#define Addr_NX10_intram2_mirror_dtcm  0x04020000U
#define Addr_NX10_intram2              0x08020000U
#define NX10_NETX_MEM_INTRN_SRAM2_AREA 0x08020000U
#define Addr_NX10_intram2_mirror_dpm   0x10020000U
#define Addr_NX10_intram2_mirror_hi    0xFFF20000U

/* --------------------------------------------------------------------- */
/* Register intram2_base */
/* => internal SRAM AHBL slave 2 start address */
/*    Area size: 64kB */
/*    Read accesses in this memory area: 0WS, byte accessable */
/*    Write accesses in this memory area: 0WS, byte accessable */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX10_intram2_base                 0x00000000U
#define Adr_NX10_intram2_mirror_itcm_intram2_base 0x00020000U
#define Adr_NX10_intram2_mirror_dtcm_intram2_base 0x04020000U
#define Adr_NX10_intram2_intram2_base             0x08020000U
#define Adr_NX10_intram2_mirror_dpm_intram2_base  0x10020000U
#define Adr_NX10_intram2_mirror_hi_intram2_base   0xFFF20000U

/* --------------------------------------------------------------------- */
/* Register intram2_end */
/* => internal SRAM AHBL slave 2 end address */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX10_intram2_end                 0x0000FFFCU
#define Adr_NX10_intram2_mirror_itcm_intram2_end 0x0002FFFCU
#define Adr_NX10_intram2_mirror_dtcm_intram2_end 0x0402FFFCU
#define Adr_NX10_intram2_intram2_end             0x0802FFFCU
#define Adr_NX10_intram2_mirror_dpm_intram2_end  0x1002FFFCU
#define Adr_NX10_intram2_mirror_hi_intram2_end   0xFFF2FFFCU


/* ===================================================================== */

/* AREA intram3 */
/* Area of intram3_mirror_itcm, intram3_mirror_dtcm, intram3, intram3_mirror_dpm, intram3_mirror_hi */

/* ===================================================================== */

#define Addr_NX10_intram3_mirror_itcm  0x00030000U
#define Addr_NX10_intram3_mirror_dtcm  0x04030000U
#define Addr_NX10_intram3              0x08030000U
#define NX10_NETX_MEM_INTRN_SRAM3_AREA 0x08030000U
#define Addr_NX10_intram3_mirror_dpm   0x10030000U
#define Addr_NX10_intram3_mirror_hi    0xFFF30000U

/* --------------------------------------------------------------------- */
/* Register intram3_base */
/* => internal SRAM AHBL slave 3 start address */
/*    Area size: 64kB */
/*    Read accesses in this memory area: 0WS, byte accessable */
/*    Write accesses in this memory area: 0WS, byte accessable */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX10_intram3_base                 0x00000000U
#define Adr_NX10_intram3_mirror_itcm_intram3_base 0x00030000U
#define Adr_NX10_intram3_mirror_dtcm_intram3_base 0x04030000U
#define Adr_NX10_intram3_intram3_base             0x08030000U
#define Adr_NX10_intram3_mirror_dpm_intram3_base  0x10030000U
#define Adr_NX10_intram3_mirror_hi_intram3_base   0xFFF30000U

/* --------------------------------------------------------------------- */
/* Register intram3_end */
/* => internal SRAM AHBL slave 3 end address */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX10_intram3_end                 0x0000FFFCU
#define Adr_NX10_intram3_mirror_itcm_intram3_end 0x0003FFFCU
#define Adr_NX10_intram3_mirror_dtcm_intram3_end 0x0403FFFCU
#define Adr_NX10_intram3_intram3_end             0x0803FFFCU
#define Adr_NX10_intram3_mirror_dpm_intram3_end  0x1003FFFCU
#define Adr_NX10_intram3_mirror_hi_intram3_end   0xFFF3FFFCU


/* ===================================================================== */

/* AREA intram4 */
/* Area of intram4_mirror_itcm, intram4_mirror_dtcm, intram4, intram4_mirror_dpm, intram4_mirror_hi */

/* ===================================================================== */

#define Addr_NX10_intram4_mirror_itcm  0x00040000U
#define Addr_NX10_intram4_mirror_dtcm  0x04040000U
#define Addr_NX10_intram4              0x08040000U
#define NX10_NETX_MEM_INTRN_SRAM4_AREA 0x08040000U
#define Addr_NX10_intram4_mirror_dpm   0x10040000U
#define Addr_NX10_intram4_mirror_hi    0xFFF40000U

/* --------------------------------------------------------------------- */
/* Register intram4_base */
/* => internal SRAM AHBL slave 4 start address */
/*    Area size: 32kB */
/*    Read accesses in this memory area: 0WS, byte accessable */
/*    Write accesses in this memory area: 0WS, byte accessable */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX10_intram4_base                 0x00000000U
#define Adr_NX10_intram4_mirror_itcm_intram4_base 0x00040000U
#define Adr_NX10_intram4_mirror_dtcm_intram4_base 0x04040000U
#define Adr_NX10_intram4_intram4_base             0x08040000U
#define Adr_NX10_intram4_mirror_dpm_intram4_base  0x10040000U
#define Adr_NX10_intram4_mirror_hi_intram4_base   0xFFF40000U

/* --------------------------------------------------------------------- */
/* Register intram4_end */
/* => internal SRAM AHBL slave 4 end address */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX10_intram4_end                 0x00007FFCU
#define Adr_NX10_intram4_mirror_itcm_intram4_end 0x00047FFCU
#define Adr_NX10_intram4_mirror_dtcm_intram4_end 0x04047FFCU
#define Adr_NX10_intram4_intram4_end             0x08047FFCU
#define Adr_NX10_intram4_mirror_dpm_intram4_end  0x10047FFCU
#define Adr_NX10_intram4_mirror_hi_intram4_end   0xFFF47FFCU


/* ===================================================================== */

/* AREA handshake */
/* Area of handshake_mirror_itcm, handshake_mirror_dtcm, handshake, handshake_mirror_dpm, handshake_mirror_hi */

/* ===================================================================== */

#define Addr_NX10_handshake_mirror_itcm 0x00048000U
#define Addr_NX10_handshake_mirror_dtcm 0x04048000U
#define Addr_NX10_handshake             0x08048000U
#define Addr_NX10_handshake_mirror_dpm  0x10048000U
#define Addr_NX10_handshake_mirror_hi   0xFFF48000U

/* --------------------------------------------------------------------- */
/* Register handshake_base */
/* => internal Handshake AHBL slave 5 start address */
/*    Area size: 32kB */
/*    INTRAM5 is mirrored inside this area 4 times for handshake Interrupt purpose. */
/*    For details view 'adr_intram5_base' and HANDSHAKE_CTRL area. */
/*    Read accesses in this memory area: 0WS, byte accessable */
/*    Write accesses in this memory area: 0WS, byte accessable */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX10_handshake_base                   0x00000000U
#define Adr_NX10_handshake_mirror_itcm_handshake_base 0x00048000U
#define Adr_NX10_handshake_mirror_dtcm_handshake_base 0x04048000U
#define Adr_NX10_handshake_handshake_base             0x08048000U
#define Adr_NX10_handshake_mirror_dpm_handshake_base  0x10048000U
#define Adr_NX10_handshake_mirror_hi_handshake_base   0xFFF48000U

/* --------------------------------------------------------------------- */
/* Register handshakeend */
/* => internal SRAM AHBL slave 5 end address */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX10_handshakeend                   0x00007FFCU
#define Adr_NX10_handshake_mirror_itcm_handshakeend 0x0004FFFCU
#define Adr_NX10_handshake_mirror_dtcm_handshakeend 0x0404FFFCU
#define Adr_NX10_handshake_handshakeend             0x0804FFFCU
#define Adr_NX10_handshake_mirror_dpm_handshakeend  0x1004FFFCU
#define Adr_NX10_handshake_mirror_hi_handshakeend   0xFFF4FFFCU


/* ===================================================================== */

/* AREA intram5 */
/* Area of intram5_mirror_itcm, intram5_mirror_itcm_dpm_mirror, intram5_mirror_itcm_arm_mirror, intram5_mirror_itcm_xpic_mirror, intram5_mirror_dtcm, intram5_mirror_dtcm_dpm_mirror, intram5_mirror_dtcm_arm_mirror, intram5_mirror_dtcm_xpic_mirror, intram5, intram5_dpm_mirror, intram5_arm_mirror, intram5_xpic_mirror, intram5_mirror_dpm, intram5_mirror_dpm_dpm_mirror, intram5_mirror_dpm_arm_mirror, intram5_mirror_dpm_xpic_mirror, intram5_mirror_hi, intram5_mirror_hi_dpm_mirror, intram5_mirror_hi_arm_mirror, intram5_mirror_hi_xpic_mirror */

/* ===================================================================== */

#define Addr_NX10_intram5_mirror_itcm             0x00048000U
#define Addr_NX10_intram5_mirror_itcm_dpm_mirror  0x0004A000U
#define Addr_NX10_intram5_mirror_itcm_arm_mirror  0x0004C000U
#define Addr_NX10_intram5_mirror_itcm_xpic_mirror 0x0004E000U
#define Addr_NX10_intram5_mirror_dtcm             0x04048000U
#define Addr_NX10_intram5_mirror_dtcm_dpm_mirror  0x0404A000U
#define Addr_NX10_intram5_mirror_dtcm_arm_mirror  0x0404C000U
#define Addr_NX10_intram5_mirror_dtcm_xpic_mirror 0x0404E000U
#define Addr_NX10_intram5                         0x08048000U
#define Addr_NX10_intram5_dpm_mirror              0x0804A000U
#define Addr_NX10_intram5_arm_mirror              0x0804C000U
#define Addr_NX10_intram5_xpic_mirror             0x0804E000U
#define Addr_NX10_intram5_mirror_dpm              0x10048000U
#define Addr_NX10_intram5_mirror_dpm_dpm_mirror   0x1004A000U
#define Addr_NX10_intram5_mirror_dpm_arm_mirror   0x1004C000U
#define Addr_NX10_intram5_mirror_dpm_xpic_mirror  0x1004E000U
#define Addr_NX10_intram5_mirror_hi               0xFFF48000U
#define Addr_NX10_intram5_mirror_hi_dpm_mirror    0xFFF4A000U
#define Addr_NX10_intram5_mirror_hi_arm_mirror    0xFFF4C000U
#define Addr_NX10_intram5_mirror_hi_xpic_mirror   0xFFF4E000U

/* --------------------------------------------------------------------- */
/* Register intram5_base */
/* => internal INTRAM5 start address */
/*    INTRAM5 is mirrored inside this area 4 times for handshake Interrupt purpose. */
/*    'dpm_mirror' must be used for DPM IRQ handshake request and acknowledge access. */
/*    'arm_mirror' must be used for ARM IRQ handshake request and acknowledge access. */
/*    'xpic_mirror' must be used for xPIC IRQ handshake request and acknowledge access. */
/*    Access to 'intram5' area without one oth these suffixes never effect handshake IRQs. */
/*    For details view 'adr_intram5_base' and HANDSHAKE_CTRL area. */
/*    Area size: 8kB */
/*    Read accesses in this memory area: 0WS, byte accessable */
/*    Write accesses in this memory area: 0WS, byte accessable */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX10_intram5_base                             0x00000000U
#define Adr_NX10_intram5_mirror_itcm_intram5_base             0x00048000U
#define Adr_NX10_intram5_mirror_itcm_dpm_mirror_intram5_base  0x0004A000U
#define Adr_NX10_intram5_mirror_itcm_arm_mirror_intram5_base  0x0004C000U
#define Adr_NX10_intram5_mirror_itcm_xpic_mirror_intram5_base 0x0004E000U
#define Adr_NX10_intram5_mirror_dtcm_intram5_base             0x04048000U
#define Adr_NX10_intram5_mirror_dtcm_dpm_mirror_intram5_base  0x0404A000U
#define Adr_NX10_intram5_mirror_dtcm_arm_mirror_intram5_base  0x0404C000U
#define Adr_NX10_intram5_mirror_dtcm_xpic_mirror_intram5_base 0x0404E000U
#define Adr_NX10_intram5_intram5_base                         0x08048000U
#define Adr_NX10_intram5_dpm_mirror_intram5_base              0x0804A000U
#define Adr_NX10_intram5_arm_mirror_intram5_base              0x0804C000U
#define Adr_NX10_intram5_xpic_mirror_intram5_base             0x0804E000U
#define Adr_NX10_intram5_mirror_dpm_intram5_base              0x10048000U
#define Adr_NX10_intram5_mirror_dpm_dpm_mirror_intram5_base   0x1004A000U
#define Adr_NX10_intram5_mirror_dpm_arm_mirror_intram5_base   0x1004C000U
#define Adr_NX10_intram5_mirror_dpm_xpic_mirror_intram5_base  0x1004E000U
#define Adr_NX10_intram5_mirror_hi_intram5_base               0xFFF48000U
#define Adr_NX10_intram5_mirror_hi_dpm_mirror_intram5_base    0xFFF4A000U
#define Adr_NX10_intram5_mirror_hi_arm_mirror_intram5_base    0xFFF4C000U
#define Adr_NX10_intram5_mirror_hi_xpic_mirror_intram5_base   0xFFF4E000U

/* --------------------------------------------------------------------- */
/* Register intram5_end */
/* => internal SRAM AHBL slave 5 end address */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX10_intram5_end                             0x00001FFCU
#define Adr_NX10_intram5_mirror_itcm_intram5_end             0x00049FFCU
#define Adr_NX10_intram5_mirror_itcm_dpm_mirror_intram5_end  0x0004BFFCU
#define Adr_NX10_intram5_mirror_itcm_arm_mirror_intram5_end  0x0004DFFCU
#define Adr_NX10_intram5_mirror_itcm_xpic_mirror_intram5_end 0x0004FFFCU
#define Adr_NX10_intram5_mirror_dtcm_intram5_end             0x04049FFCU
#define Adr_NX10_intram5_mirror_dtcm_dpm_mirror_intram5_end  0x0404BFFCU
#define Adr_NX10_intram5_mirror_dtcm_arm_mirror_intram5_end  0x0404DFFCU
#define Adr_NX10_intram5_mirror_dtcm_xpic_mirror_intram5_end 0x0404FFFCU
#define Adr_NX10_intram5_intram5_end                         0x08049FFCU
#define Adr_NX10_intram5_dpm_mirror_intram5_end              0x0804BFFCU
#define Adr_NX10_intram5_arm_mirror_intram5_end              0x0804DFFCU
#define Adr_NX10_intram5_xpic_mirror_intram5_end             0x0804FFFCU
#define Adr_NX10_intram5_mirror_dpm_intram5_end              0x10049FFCU
#define Adr_NX10_intram5_mirror_dpm_dpm_mirror_intram5_end   0x1004BFFCU
#define Adr_NX10_intram5_mirror_dpm_arm_mirror_intram5_end   0x1004DFFCU
#define Adr_NX10_intram5_mirror_dpm_xpic_mirror_intram5_end  0x1004FFFCU
#define Adr_NX10_intram5_mirror_hi_intram5_end               0xFFF49FFCU
#define Adr_NX10_intram5_mirror_hi_dpm_mirror_intram5_end    0xFFF4BFFCU
#define Adr_NX10_intram5_mirror_hi_arm_mirror_intram5_end    0xFFF4DFFCU
#define Adr_NX10_intram5_mirror_hi_xpic_mirror_intram5_end   0xFFF4FFFCU


/* ===================================================================== */

/* AREA rom */
/* Area of rom_mirror_itcm, rom_mirror_dtcm, rom, rom_mirror_dpm, rom_mirror_hi */

/* ===================================================================== */

#define Addr_NX10_rom_mirror_itcm   0x00070000U
#define Addr_NX10_rom_mirror_dtcm   0x04070000U
#define Addr_NX10_rom               0x08070000U
#define NX10_NETX_MEM_BOOT_ROM_AREA 0x08070000U
#define Addr_NX10_rom_mirror_dpm    0x10070000U
#define Addr_NX10_rom_mirror_hi     0xFFF70000U

/* --------------------------------------------------------------------- */
/* Register rom_base */
/* => internal ROM start address */
/*    Area size: 64kB */
/*    Read accesses in this memory area: 0WS, byte accessable */
/*    ROM-content will be mirrored any 64kB between 0x00200000 and 0x002ffffc or mirrored AHBL_s4-areas */
/* => Mode: R */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX10_rom_base             0x00000000U
#define Adr_NX10_rom_mirror_itcm_rom_base 0x00070000U
#define Adr_NX10_rom_mirror_dtcm_rom_base 0x04070000U
#define Adr_NX10_rom_rom_base             0x08070000U
#define Adr_NX10_rom_mirror_dpm_rom_base  0x10070000U
#define Adr_NX10_rom_mirror_hi_rom_base   0xFFF70000U

/* --------------------------------------------------------------------- */
/* Register rom_end */
/* => internal ROM end address */
/* => Mode: R */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX10_rom_end             0x0000FFFCU
#define Adr_NX10_rom_mirror_itcm_rom_end 0x0007FFFCU
#define Adr_NX10_rom_mirror_dtcm_rom_end 0x0407FFFCU
#define Adr_NX10_rom_rom_end             0x0807FFFCU
#define Adr_NX10_rom_mirror_dpm_rom_end  0x1007FFFCU
#define Adr_NX10_rom_mirror_hi_rom_end   0xFFF7FFFCU


/* ===================================================================== */

/* Area of ARMdTCM_memarea */

/* ===================================================================== */

#define Addr_NX10_ARMdTCM_memarea 0x04000000U

/* ===================================================================== */

/* AREA intram0 */
/* Area of intram0_mirror_dtcm, intram0, intram0_mirror_dpm, intram0_mirror_hi */

/* ===================================================================== */

#define Addr_NX10_intram0_mirror_dtcm  0x04000000U
#define Addr_NX10_intram0              0x08000000U
#define NX10_NETX_MEM_INTRN_SRAM0_AREA 0x08000000U
#define Addr_NX10_intram0_mirror_dpm   0x10000000U
#define Addr_NX10_intram0_mirror_hi    0xFFF00000U

/* --------------------------------------------------------------------- */
/* Register intram0_base */
/* => internal SRAM AHBL slave 0 start address */
/*    Area size: 64kB */
/*    Read accesses in this memory area: 0WS, byte accessable */
/*    Write accesses in this memory area: 0WS, byte accessable */
/*    Offset 0x0 is ROM Boot-vector */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX10_intram0_base                 0x00000000U
#define Adr_NX10_intram0_mirror_dtcm_intram0_base 0x04000000U
#define Adr_NX10_intram0_intram0_base             0x08000000U
#define Adr_NX10_intram0_mirror_dpm_intram0_base  0x10000000U
#define Adr_NX10_intram0_mirror_hi_intram0_base   0xFFF00000U

/* --------------------------------------------------------------------- */
/* Register intram0_end */
/* => internal SRAM AHBL slave 0 end address */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX10_intram0_end                 0x0000FFFCU
#define Adr_NX10_intram0_mirror_dtcm_intram0_end 0x0400FFFCU
#define Adr_NX10_intram0_intram0_end             0x0800FFFCU
#define Adr_NX10_intram0_mirror_dpm_intram0_end  0x1000FFFCU
#define Adr_NX10_intram0_mirror_hi_intram0_end   0xFFF0FFFCU


/* ===================================================================== */

/* Area of ARM_buf_area */

/* ===================================================================== */

#define Addr_NX10_ARM_buf_area 0x08000000U

/* ===================================================================== */

/* Area of intlogic_motion_mirror_buf */

/* ===================================================================== */

#define Addr_NX10_intlogic_motion_mirror_buf 0x08100000U

/* ===================================================================== */

/* Area of intlogic_sys_mirror_buf */

/* ===================================================================== */

#define Addr_NX10_intlogic_sys_mirror_buf 0x08180000U

/* ===================================================================== */

/* Area of sqirom */

/* ===================================================================== */

#define Addr_NX10_sqirom 0x09000000U

/* ===================================================================== */

/* Area of ARM_nbuf_area */

/* ===================================================================== */

#define Addr_NX10_ARM_nbuf_area 0x10000000U

/* ===================================================================== */

/* Area of dpm_full_window */

/* ===================================================================== */

#define Addr_NX10_dpm_full_window 0x10000000U

/* ===================================================================== */

/* Area of intlogic_motion */

/* ===================================================================== */

#define Addr_NX10_intlogic_motion 0x10100000U

/* ===================================================================== */

/* AREA sr */
/* Area of sr_motion */

/* ===================================================================== */

#define Addr_NX10_sr_motion 0x10125640U

/* --------------------------------------------------------------------- */
/* Register sr_sr0 */
/* => Shared Work Register 0 accessed over motion intlogic. */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX10_sr_sr0       0x00000000U
#define Adr_NX10_sr_motion_sr_sr0 0x10125640U
#define Adr_NX10_sr_sr0           0x10125640U
#define DFLT_VAL_NX10_sr_sr0      0x00000000U

#define MSK_NX10_sr_sr0_val      0x0000ffffU
#define SRT_NX10_sr_sr0_val      0
#define DFLT_VAL_NX10_sr_sr0_val 0x00000000U

enum {
	BFW_NX10_sr_sr0_val       = 16, /* [15:0] */
	BFW_NX10_sr_sr0_reserved1 = 16  /* [31:16] */
};

typedef struct NX10_SR_SR0_BIT_Ttag {
	unsigned int val       : BFW_NX10_sr_sr0_val;       /* Shared Register                                                     */
	                                                    /* This register is writable but can also be changed by hardware. (XC) */
	unsigned int reserved1 : BFW_NX10_sr_sr0_reserved1; /* reserved                                                            */
} NX10_SR_SR0_BIT_T;

typedef union {
	unsigned int      val;
	NX10_SR_SR0_BIT_T bf;
} NX10_SR_SR0_T;

/* --------------------------------------------------------------------- */
/* Register sr_sr1 */
/* => Shared Work Register 1 accessed over motion intlogic. */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX10_sr_sr1       0x00000004U
#define Adr_NX10_sr_motion_sr_sr1 0x10125644U
#define Adr_NX10_sr_sr1           0x10125644U
#define DFLT_VAL_NX10_sr_sr1      0x00000000U

#define MSK_NX10_sr_sr1_val      0x0000ffffU
#define SRT_NX10_sr_sr1_val      0
#define DFLT_VAL_NX10_sr_sr1_val 0x00000000U

enum {
	BFW_NX10_sr_sr1_val       = 16, /* [15:0] */
	BFW_NX10_sr_sr1_reserved1 = 16  /* [31:16] */
};

typedef struct NX10_SR_SR1_BIT_Ttag {
	unsigned int val       : BFW_NX10_sr_sr1_val;       /* Shared Register                                                     */
	                                                    /* This register is writable but can also be changed by hardware. (XC) */
	unsigned int reserved1 : BFW_NX10_sr_sr1_reserved1; /* reserved                                                            */
} NX10_SR_SR1_BIT_T;

typedef union {
	unsigned int      val;
	NX10_SR_SR1_BIT_T bf;
} NX10_SR_SR1_T;

/* --------------------------------------------------------------------- */
/* Register sr_sr2 */
/* => Shared Work Register 2 accessed over motion intlogic. */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX10_sr_sr2       0x00000008U
#define Adr_NX10_sr_motion_sr_sr2 0x10125648U
#define Adr_NX10_sr_sr2           0x10125648U
#define DFLT_VAL_NX10_sr_sr2      0x00000000U

#define MSK_NX10_sr_sr2_val      0x0000ffffU
#define SRT_NX10_sr_sr2_val      0
#define DFLT_VAL_NX10_sr_sr2_val 0x00000000U

enum {
	BFW_NX10_sr_sr2_val       = 16, /* [15:0] */
	BFW_NX10_sr_sr2_reserved1 = 16  /* [31:16] */
};

typedef struct NX10_SR_SR2_BIT_Ttag {
	unsigned int val       : BFW_NX10_sr_sr2_val;       /* Shared Register                                                     */
	                                                    /* This register is writable but can also be changed by hardware. (XC) */
	unsigned int reserved1 : BFW_NX10_sr_sr2_reserved1; /* reserved                                                            */
} NX10_SR_SR2_BIT_T;

typedef union {
	unsigned int      val;
	NX10_SR_SR2_BIT_T bf;
} NX10_SR_SR2_T;

/* --------------------------------------------------------------------- */
/* Register sr_sr3 */
/* => Shared Work Register 3 accessed over motion intlogic. */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX10_sr_sr3       0x0000000CU
#define Adr_NX10_sr_motion_sr_sr3 0x1012564CU
#define Adr_NX10_sr_sr3           0x1012564CU
#define DFLT_VAL_NX10_sr_sr3      0x00000000U

#define MSK_NX10_sr_sr3_val      0x0000ffffU
#define SRT_NX10_sr_sr3_val      0
#define DFLT_VAL_NX10_sr_sr3_val 0x00000000U

enum {
	BFW_NX10_sr_sr3_val       = 16, /* [15:0] */
	BFW_NX10_sr_sr3_reserved1 = 16  /* [31:16] */
};

typedef struct NX10_SR_SR3_BIT_Ttag {
	unsigned int val       : BFW_NX10_sr_sr3_val;       /* Shared Register                                                     */
	                                                    /* This register is writable but can also be changed by hardware. (XC) */
	unsigned int reserved1 : BFW_NX10_sr_sr3_reserved1; /* reserved                                                            */
} NX10_SR_SR3_BIT_T;

typedef union {
	unsigned int      val;
	NX10_SR_SR3_BIT_T bf;
} NX10_SR_SR3_T;

/* --------------------------------------------------------------------- */
/* Register sr_sr4 */
/* => Shared Work Register 4 accessed over motion intlogic. */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX10_sr_sr4       0x00000010U
#define Adr_NX10_sr_motion_sr_sr4 0x10125650U
#define Adr_NX10_sr_sr4           0x10125650U
#define DFLT_VAL_NX10_sr_sr4      0x00000000U

#define MSK_NX10_sr_sr4_val      0x0000ffffU
#define SRT_NX10_sr_sr4_val      0
#define DFLT_VAL_NX10_sr_sr4_val 0x00000000U

enum {
	BFW_NX10_sr_sr4_val       = 16, /* [15:0] */
	BFW_NX10_sr_sr4_reserved1 = 16  /* [31:16] */
};

typedef struct NX10_SR_SR4_BIT_Ttag {
	unsigned int val       : BFW_NX10_sr_sr4_val;       /* Shared Register                                                     */
	                                                    /* This register is writable but can also be changed by hardware. (XC) */
	unsigned int reserved1 : BFW_NX10_sr_sr4_reserved1; /* reserved                                                            */
} NX10_SR_SR4_BIT_T;

typedef union {
	unsigned int      val;
	NX10_SR_SR4_BIT_T bf;
} NX10_SR_SR4_T;

/* --------------------------------------------------------------------- */
/* Register sr_sr5 */
/* => Shared Work Register 5 accessed over motion intlogic. */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX10_sr_sr5       0x00000014U
#define Adr_NX10_sr_motion_sr_sr5 0x10125654U
#define Adr_NX10_sr_sr5           0x10125654U
#define DFLT_VAL_NX10_sr_sr5      0x00000000U

#define MSK_NX10_sr_sr5_val      0x0000ffffU
#define SRT_NX10_sr_sr5_val      0
#define DFLT_VAL_NX10_sr_sr5_val 0x00000000U

enum {
	BFW_NX10_sr_sr5_val       = 16, /* [15:0] */
	BFW_NX10_sr_sr5_reserved1 = 16  /* [31:16] */
};

typedef struct NX10_SR_SR5_BIT_Ttag {
	unsigned int val       : BFW_NX10_sr_sr5_val;       /* Shared Register                                                     */
	                                                    /* This register is writable but can also be changed by hardware. (XC) */
	unsigned int reserved1 : BFW_NX10_sr_sr5_reserved1; /* reserved                                                            */
} NX10_SR_SR5_BIT_T;

typedef union {
	unsigned int      val;
	NX10_SR_SR5_BIT_T bf;
} NX10_SR_SR5_T;

/* --------------------------------------------------------------------- */
/* Register sr_config_shared0 */
/* => XC Shared Config/Status Register 0 */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX10_sr_config_shared0       0x00000018U
#define Adr_NX10_sr_motion_sr_config_shared0 0x10125658U
#define Adr_NX10_sr_config_shared0           0x10125658U
#define DFLT_VAL_NX10_sr_config_shared0      0x08500000U

#define MSK_NX10_sr_config_shared0_config         0x0000ffffU
#define SRT_NX10_sr_config_shared0_config         0
#define DFLT_VAL_NX10_sr_config_shared0_config    0x00000000U
#define MSK_NX10_sr_config_shared0_status_ro      0xffff0000U
#define SRT_NX10_sr_config_shared0_status_ro      16
#define DFLT_VAL_NX10_sr_config_shared0_status_ro 0x08500000U

enum {
	BFW_NX10_sr_config_shared0_config    = 16, /* [15:0] */
	BFW_NX10_sr_config_shared0_status_ro = 16  /* [31:16] */
};

typedef struct NX10_SR_CONFIG_SHARED0_BIT_Ttag {
	unsigned int config    : BFW_NX10_sr_config_shared0_config;    /* Config Register                                                     */
	                                                               /* This register is writable but can also be changed by hardware. (XC) */
	unsigned int status_ro : BFW_NX10_sr_config_shared0_status_ro; /* Status Register                                                     */
} NX10_SR_CONFIG_SHARED0_BIT_T;

typedef union {
	unsigned int                 val;
	NX10_SR_CONFIG_SHARED0_BIT_T bf;
} NX10_SR_CONFIG_SHARED0_T;


/* ===================================================================== */

/* Area of cordic */

/* ===================================================================== */

#define Addr_NX10_cordic 0x10140000U

/* --------------------------------------------------------------------- */
/* Register cordic_ctrl */
/* => CORDIC control register. */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX10_cordic_ctrl    0x00000000U
#define Adr_NX10_cordic_cordic_ctrl 0x10140000U
#define Adr_NX10_cordic_ctrl        0x10140000U
#define DFLT_VAL_NX10_cordic_ctrl   0x00000fc2U

#define MSK_NX10_cordic_ctrl_start            0x00000001U
#define SRT_NX10_cordic_ctrl_start            0
#define DFLT_VAL_NX10_cordic_ctrl_start       0x00000000U
#define MSK_NX10_cordic_ctrl_mode             0x0000000eU
#define SRT_NX10_cordic_ctrl_mode             1
#define DFLT_VAL_NX10_cordic_ctrl_mode        0x00000002U
#define MSK_NX10_cordic_ctrl_target_axis      0x00000070U
#define SRT_NX10_cordic_ctrl_target_axis      4
#define DFLT_VAL_NX10_cordic_ctrl_target_axis 0x00000040U
#define MSK_NX10_cordic_ctrl_iterations       0x00000f80U
#define SRT_NX10_cordic_ctrl_iterations       7
#define DFLT_VAL_NX10_cordic_ctrl_iterations  0x00000f80U

enum {
	BFW_NX10_cordic_ctrl_start       = 1,  /* [0] */
	BFW_NX10_cordic_ctrl_mode        = 3,  /* [3:1] */
	BFW_NX10_cordic_ctrl_target_axis = 3,  /* [6:4] */
	BFW_NX10_cordic_ctrl_iterations  = 5,  /* [11:7] */
	BFW_NX10_cordic_ctrl_reserved1   = 20  /* [31:12] */
};

typedef struct NX10_CORDIC_CTRL_BIT_Ttag {
	unsigned int start       : BFW_NX10_cordic_ctrl_start;       /* 1: start calculation.  is reset to zero by cordic.                                                      */
	                                                             /* This bit is writable but can also be changed by hardware.                                               */
	unsigned int mode        : BFW_NX10_cordic_ctrl_mode;        /* Mode:                                                                                                   */
	                                                             /* 001: circular mode                                                                                      */
	unsigned int target_axis : BFW_NX10_cordic_ctrl_target_axis; /* Axis of the coordinate system (or component of the Vecor) to drive to the value of adr_cordic_c_reg.    */
	                                                             /* 001: drive X to C (only used for inverse mode)                                                          */
	unsigned int iterations  : BFW_NX10_cordic_ctrl_iterations;  /* Number of iterations to perform.  If not using inverse mode, two iterations will be executed per cycle. */
	                                                             /* 0x0:   8 iterations                                                                                     */
	unsigned int reserved1   : BFW_NX10_cordic_ctrl_reserved1;   /* reserved                                                                                                */
} NX10_CORDIC_CTRL_BIT_T;

typedef union {
	unsigned int           val;
	NX10_CORDIC_CTRL_BIT_T bf;
} NX10_CORDIC_CTRL_T;

/* --------------------------------------------------------------------- */
/* Register cordic_x_reg */
/* => CORDIC argument input register X */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX10_cordic_x_reg    0x00000004U
#define Adr_NX10_cordic_cordic_x_reg 0x10140004U
#define Adr_NX10_cordic_x_reg        0x10140004U
#define DFLT_VAL_NX10_cordic_x_reg   0x00000000U

#define MSK_NX10_cordic_x_reg_argument      0xffffffffU
#define SRT_NX10_cordic_x_reg_argument      0
#define DFLT_VAL_NX10_cordic_x_reg_argument 0x00000000U

enum {
	BFW_NX10_cordic_x_reg_argument = 32  /* [31:0] */
};

typedef struct NX10_CORDIC_X_REG_BIT_Ttag {
	unsigned int argument : BFW_NX10_cordic_x_reg_argument; /* x-component of input vector */
} NX10_CORDIC_X_REG_BIT_T;

typedef union {
	unsigned int            val;
	NX10_CORDIC_X_REG_BIT_T bf;
} NX10_CORDIC_X_REG_T;

/* --------------------------------------------------------------------- */
/* Register cordic_y_reg */
/* => CORDIC argument input register Y */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX10_cordic_y_reg    0x00000008U
#define Adr_NX10_cordic_cordic_y_reg 0x10140008U
#define Adr_NX10_cordic_y_reg        0x10140008U
#define DFLT_VAL_NX10_cordic_y_reg   0x00000000U

#define MSK_NX10_cordic_y_reg_argument      0xffffffffU
#define SRT_NX10_cordic_y_reg_argument      0
#define DFLT_VAL_NX10_cordic_y_reg_argument 0x00000000U

enum {
	BFW_NX10_cordic_y_reg_argument = 32  /* [31:0] */
};

typedef struct NX10_CORDIC_Y_REG_BIT_Ttag {
	unsigned int argument : BFW_NX10_cordic_y_reg_argument; /* y-component of input vector */
} NX10_CORDIC_Y_REG_BIT_T;

typedef union {
	unsigned int            val;
	NX10_CORDIC_Y_REG_BIT_T bf;
} NX10_CORDIC_Y_REG_T;

/* --------------------------------------------------------------------- */
/* Register cordic_z_reg */
/* => CORDIC argument input register Z */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX10_cordic_z_reg    0x0000000CU
#define Adr_NX10_cordic_cordic_z_reg 0x1014000CU
#define Adr_NX10_cordic_z_reg        0x1014000CU
#define DFLT_VAL_NX10_cordic_z_reg   0x00000000U

#define MSK_NX10_cordic_z_reg_argument      0xffffffffU
#define SRT_NX10_cordic_z_reg_argument      0
#define DFLT_VAL_NX10_cordic_z_reg_argument 0x00000000U

enum {
	BFW_NX10_cordic_z_reg_argument = 32  /* [31:0] */
};

typedef struct NX10_CORDIC_Z_REG_BIT_Ttag {
	unsigned int argument : BFW_NX10_cordic_z_reg_argument; /* input angle */
} NX10_CORDIC_Z_REG_BIT_T;

typedef union {
	unsigned int            val;
	NX10_CORDIC_Z_REG_BIT_T bf;
} NX10_CORDIC_Z_REG_T;

/* --------------------------------------------------------------------- */
/* Register cordic_c_reg */
/* => CORDIC argument input register C */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX10_cordic_c_reg    0x00000010U
#define Adr_NX10_cordic_cordic_c_reg 0x10140010U
#define Adr_NX10_cordic_c_reg        0x10140010U
#define DFLT_VAL_NX10_cordic_c_reg   0x00000000U

#define MSK_NX10_cordic_c_reg_argument      0xffffffffU
#define SRT_NX10_cordic_c_reg_argument      0
#define DFLT_VAL_NX10_cordic_c_reg_argument 0x00000000U

enum {
	BFW_NX10_cordic_c_reg_argument = 32  /* [31:0] */
};

typedef struct NX10_CORDIC_C_REG_BIT_Ttag {
	unsigned int argument : BFW_NX10_cordic_c_reg_argument; /* target value to compare x/y/z value against */
} NX10_CORDIC_C_REG_BIT_T;

typedef union {
	unsigned int            val;
	NX10_CORDIC_C_REG_BIT_T bf;
} NX10_CORDIC_C_REG_T;

/* --------------------------------------------------------------------- */
/* Register cordic_fsm_state */
/* => CORDIC FSM state register.  Readable for debugging purposes. */
/* => Mode: R */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX10_cordic_fsm_state    0x00000014U
#define Adr_NX10_cordic_cordic_fsm_state 0x10140014U
#define Adr_NX10_cordic_fsm_state        0x10140014U

#define MSK_NX10_cordic_fsm_state_state 0x0000003fU
#define SRT_NX10_cordic_fsm_state_state 0
#define MSK_NX10_cordic_fsm_state_x_ovf 0x00000040U
#define SRT_NX10_cordic_fsm_state_x_ovf 6
#define MSK_NX10_cordic_fsm_state_y_ovf 0x00000080U
#define SRT_NX10_cordic_fsm_state_y_ovf 7
#define MSK_NX10_cordic_fsm_state_z_ovf 0x00000100U
#define SRT_NX10_cordic_fsm_state_z_ovf 8
#define MSK_NX10_cordic_fsm_state_c_ovf 0x00000200U
#define SRT_NX10_cordic_fsm_state_c_ovf 9

enum {
	BFW_NX10_cordic_fsm_state_state     = 6,  /* [5:0] */
	BFW_NX10_cordic_fsm_state_x_ovf     = 1,  /* [6] */
	BFW_NX10_cordic_fsm_state_y_ovf     = 1,  /* [7] */
	BFW_NX10_cordic_fsm_state_z_ovf     = 1,  /* [8] */
	BFW_NX10_cordic_fsm_state_c_ovf     = 1,  /* [9] */
	BFW_NX10_cordic_fsm_state_reserved1 = 22  /* [31:10] */
};

typedef struct NX10_CORDIC_FSM_STATE_BIT_Ttag {
	unsigned int state     : BFW_NX10_cordic_fsm_state_state;     /* state of FSM               */
	                                                              /* 0 - 19 : current iteration */
	unsigned int x_ovf     : BFW_NX10_cordic_fsm_state_x_ovf;     /* x overflow                 */
	unsigned int y_ovf     : BFW_NX10_cordic_fsm_state_y_ovf;     /* y overflow                 */
	unsigned int z_ovf     : BFW_NX10_cordic_fsm_state_z_ovf;     /* z overflow                 */
	unsigned int c_ovf     : BFW_NX10_cordic_fsm_state_c_ovf;     /* c overflow                 */
	unsigned int reserved1 : BFW_NX10_cordic_fsm_state_reserved1; /* reserved                   */
} NX10_CORDIC_FSM_STATE_BIT_T;

typedef union {
	unsigned int                val;
	NX10_CORDIC_FSM_STATE_BIT_T bf;
} NX10_CORDIC_FSM_STATE_T;

/* --------------------------------------------------------------------- */
/* Register cordic_lin_39_to_8 */
/* => CORDIC linear corfficient register (= number system scale register) */
/*    This is used as a starting point for calculating the angles for the linear mode.  It represents the number 1 in the utilized number system. */
/*    The default value is designed for use with the daggett angle representation in 40 bit fixed point ([-pi .. +pi] == [-2^39 .. 2^39-1]). */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX10_cordic_lin_39_to_8    0x00000018U
#define Adr_NX10_cordic_cordic_lin_39_to_8 0x10140018U
#define Adr_NX10_cordic_lin_39_to_8        0x10140018U
#define DFLT_VAL_NX10_cordic_lin_39_to_8   0x28be60dbU

#define MSK_NX10_cordic_lin_39_to_8_L0_MSDW      0xffffffffU
#define SRT_NX10_cordic_lin_39_to_8_L0_MSDW      0
#define DFLT_VAL_NX10_cordic_lin_39_to_8_L0_MSDW 0x28be60dbU

enum {
	BFW_NX10_cordic_lin_39_to_8_L0_MSDW = 32  /* [31:0] */
};

typedef struct NX10_CORDIC_LIN_39_TO_8_BIT_Ttag {
	unsigned int L0_MSDW : BFW_NX10_cordic_lin_39_to_8_L0_MSDW; /* Most Significant DWord of first linear coefficient: */
	                                                            /* coeff_linear_0[39:8] == 1[39:8].                    */
} NX10_CORDIC_LIN_39_TO_8_BIT_T;

typedef union {
	unsigned int                  val;
	NX10_CORDIC_LIN_39_TO_8_BIT_T bf;
} NX10_CORDIC_LIN_39_TO_8_T;

/* --------------------------------------------------------------------- */
/* Register cordic_lin_7_to_0 */
/* => CORDIC linear corfficient register (= number system scale register) */
/*    This is used as a starting point for calculating the angles for the linear mode.  It represents the number 1 in the utilized number system. */
/*    The default value is designed for use with the daggett angle representation in 40 bit fixed point ([-pi .. +pi] == [-2^39 .. 2^39-1]). */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX10_cordic_lin_7_to_0    0x0000001CU
#define Adr_NX10_cordic_cordic_lin_7_to_0 0x1014001CU
#define Adr_NX10_cordic_lin_7_to_0        0x1014001CU
#define DFLT_VAL_NX10_cordic_lin_7_to_0   0x94000000U

#define MSK_NX10_cordic_lin_7_to_0_L0_LSB      0xff000000U
#define SRT_NX10_cordic_lin_7_to_0_L0_LSB      24
#define DFLT_VAL_NX10_cordic_lin_7_to_0_L0_LSB 0x94000000U

enum {
	BFW_NX10_cordic_lin_7_to_0_reserved1 = 24, /* [23:0] */
	BFW_NX10_cordic_lin_7_to_0_L0_LSB    = 8   /* [31:24] */
};

typedef struct NX10_CORDIC_LIN_7_TO_0_BIT_Ttag {
	unsigned int reserved1 : BFW_NX10_cordic_lin_7_to_0_reserved1; /* reserved                                            */
	unsigned int L0_LSB    : BFW_NX10_cordic_lin_7_to_0_L0_LSB;    /* Least Significant Byte of first linear coefficient: */
	                                                               /* coeff_linear_0[7:0] == 1[7:0].                      */
} NX10_CORDIC_LIN_7_TO_0_BIT_T;

typedef union {
	unsigned int                 val;
	NX10_CORDIC_LIN_7_TO_0_BIT_T bf;
} NX10_CORDIC_LIN_7_TO_0_T;

/* --------------------------------------------------------------------- */
/* Register cordic_coeff_ram_start_circ_39_to_8 */
/* => Start of CORDIC coefficient RAM containing Most Significant DWords of circular coefficients. */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX10_cordic_coeff_ram_start_circ_39_to_8    0x00000100U
#define Adr_NX10_cordic_cordic_coeff_ram_start_circ_39_to_8 0x10140100U
#define Adr_NX10_cordic_coeff_ram_start_circ_39_to_8        0x10140100U
#define DFLT_VAL_NX10_cordic_coeff_ram_start_circ_39_to_8   0x00000000U

#define MSK_NX10_cordic_coeff_ram_start_circ_39_to_8_C0_MSDW      0xffffffffU
#define SRT_NX10_cordic_coeff_ram_start_circ_39_to_8_C0_MSDW      0
#define DFLT_VAL_NX10_cordic_coeff_ram_start_circ_39_to_8_C0_MSDW 0x00000000U

enum {
	BFW_NX10_cordic_coeff_ram_start_circ_39_to_8_C0_MSDW = 32  /* [31:0] */
};

typedef struct NX10_CORDIC_COEFF_RAM_START_CIRC_39_TO_8_BIT_Ttag {
	unsigned int C0_MSDW : BFW_NX10_cordic_coeff_ram_start_circ_39_to_8_C0_MSDW; /* Address of Most Significant Double Word of first circular coefficient: */
	                                                                             /* coeff_circular_0[39:8] == arctan(2^-0)[39:8].                          */
} NX10_CORDIC_COEFF_RAM_START_CIRC_39_TO_8_BIT_T;

typedef union {
	unsigned int                                   val;
	NX10_CORDIC_COEFF_RAM_START_CIRC_39_TO_8_BIT_T bf;
} NX10_CORDIC_COEFF_RAM_START_CIRC_39_TO_8_T;

/* --------------------------------------------------------------------- */
/* Register cordic_coeff_ram_end_circ_39_to_8 */
/* => End of CORDIC coefficient RAM containing Most Significant DWords of circular coefficients (arctan(2^-1)) */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX10_cordic_coeff_ram_end_circ_39_to_8    0x0000019CU
#define Adr_NX10_cordic_cordic_coeff_ram_end_circ_39_to_8 0x1014019CU
#define Adr_NX10_cordic_coeff_ram_end_circ_39_to_8        0x1014019CU
#define DFLT_VAL_NX10_cordic_coeff_ram_end_circ_39_to_8   0x00000000U

#define MSK_NX10_cordic_coeff_ram_end_circ_39_to_8_C39_MSDW      0xffffffffU
#define SRT_NX10_cordic_coeff_ram_end_circ_39_to_8_C39_MSDW      0
#define DFLT_VAL_NX10_cordic_coeff_ram_end_circ_39_to_8_C39_MSDW 0x00000000U

enum {
	BFW_NX10_cordic_coeff_ram_end_circ_39_to_8_C39_MSDW = 32  /* [31:0] */
};

typedef struct NX10_CORDIC_COEFF_RAM_END_CIRC_39_TO_8_BIT_Ttag {
	unsigned int C39_MSDW : BFW_NX10_cordic_coeff_ram_end_circ_39_to_8_C39_MSDW; /* Address of Most Significant Double Word of last circular coefficient: */
	                                                                             /* coeff_circular_39[39:8] == arctan(2^-39)[39:8].                       */
} NX10_CORDIC_COEFF_RAM_END_CIRC_39_TO_8_BIT_T;

typedef union {
	unsigned int                                 val;
	NX10_CORDIC_COEFF_RAM_END_CIRC_39_TO_8_BIT_T bf;
} NX10_CORDIC_COEFF_RAM_END_CIRC_39_TO_8_T;

/* --------------------------------------------------------------------- */
/* Register cordic_coeff_ram_start_hyp_39_to_8 */
/* => Start of CORDIC coefficient RAM containing Most Significant DWords of hyperbolic coefficients (arctanh(2^-1)) */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX10_cordic_coeff_ram_start_hyp_39_to_8    0x00000200U
#define Adr_NX10_cordic_cordic_coeff_ram_start_hyp_39_to_8 0x10140200U
#define Adr_NX10_cordic_coeff_ram_start_hyp_39_to_8        0x10140200U
#define DFLT_VAL_NX10_cordic_coeff_ram_start_hyp_39_to_8   0x00000000U

#define MSK_NX10_cordic_coeff_ram_start_hyp_39_to_8_H0_MSDW      0xffffffffU
#define SRT_NX10_cordic_coeff_ram_start_hyp_39_to_8_H0_MSDW      0
#define DFLT_VAL_NX10_cordic_coeff_ram_start_hyp_39_to_8_H0_MSDW 0x00000000U

enum {
	BFW_NX10_cordic_coeff_ram_start_hyp_39_to_8_H0_MSDW = 32  /* [31:0] */
};

typedef struct NX10_CORDIC_COEFF_RAM_START_HYP_39_TO_8_BIT_Ttag {
	unsigned int H0_MSDW : BFW_NX10_cordic_coeff_ram_start_hyp_39_to_8_H0_MSDW; /* Address of Most Significant Double Word of first hyperbolic coefficient: */
	                                                                            /* coeff_hyperbolic_0[39:8] == arctanh(2^-0)[39:8].                         */
} NX10_CORDIC_COEFF_RAM_START_HYP_39_TO_8_BIT_T;

typedef union {
	unsigned int                                  val;
	NX10_CORDIC_COEFF_RAM_START_HYP_39_TO_8_BIT_T bf;
} NX10_CORDIC_COEFF_RAM_START_HYP_39_TO_8_T;

/* --------------------------------------------------------------------- */
/* Register cordic_coeff_ram_end_hyp_39_to_8 */
/* => End of CORDIC coefficient RAM containing Most Significant DWords of hyperbolic coefficients (arctanh(2^-1)) */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX10_cordic_coeff_ram_end_hyp_39_to_8    0x0000029CU
#define Adr_NX10_cordic_cordic_coeff_ram_end_hyp_39_to_8 0x1014029CU
#define Adr_NX10_cordic_coeff_ram_end_hyp_39_to_8        0x1014029CU
#define DFLT_VAL_NX10_cordic_coeff_ram_end_hyp_39_to_8   0x00000000U

#define MSK_NX10_cordic_coeff_ram_end_hyp_39_to_8_H39_MSDW      0xffffffffU
#define SRT_NX10_cordic_coeff_ram_end_hyp_39_to_8_H39_MSDW      0
#define DFLT_VAL_NX10_cordic_coeff_ram_end_hyp_39_to_8_H39_MSDW 0x00000000U

enum {
	BFW_NX10_cordic_coeff_ram_end_hyp_39_to_8_H39_MSDW = 32  /* [31:0] */
};

typedef struct NX10_CORDIC_COEFF_RAM_END_HYP_39_TO_8_BIT_Ttag {
	unsigned int H39_MSDW : BFW_NX10_cordic_coeff_ram_end_hyp_39_to_8_H39_MSDW; /* Address of Most Significant Double Word of last hyperbolic coefficient: */
	                                                                            /* coeff_hyperbolic_39[39:8] == arctanh(2^-39)[39:8].                      */
} NX10_CORDIC_COEFF_RAM_END_HYP_39_TO_8_BIT_T;

typedef union {
	unsigned int                                val;
	NX10_CORDIC_COEFF_RAM_END_HYP_39_TO_8_BIT_T bf;
} NX10_CORDIC_COEFF_RAM_END_HYP_39_TO_8_T;

/* --------------------------------------------------------------------- */
/* Register cordic_coeff_ram_start_circ_7_to_0 */
/* => Start of CORDIC coefficient RAM containing Least Significant Bytes of circular coefficients */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX10_cordic_coeff_ram_start_circ_7_to_0    0x00000300U
#define Adr_NX10_cordic_cordic_coeff_ram_start_circ_7_to_0 0x10140300U
#define Adr_NX10_cordic_coeff_ram_start_circ_7_to_0        0x10140300U
#define DFLT_VAL_NX10_cordic_coeff_ram_start_circ_7_to_0   0x00000000U

#define MSK_NX10_cordic_coeff_ram_start_circ_7_to_0_C1_LSB      0x00ff0000U
#define SRT_NX10_cordic_coeff_ram_start_circ_7_to_0_C1_LSB      16
#define DFLT_VAL_NX10_cordic_coeff_ram_start_circ_7_to_0_C1_LSB 0x00000000U
#define MSK_NX10_cordic_coeff_ram_start_circ_7_to_0_C0_LSB      0xff000000U
#define SRT_NX10_cordic_coeff_ram_start_circ_7_to_0_C0_LSB      24
#define DFLT_VAL_NX10_cordic_coeff_ram_start_circ_7_to_0_C0_LSB 0x00000000U

enum {
	BFW_NX10_cordic_coeff_ram_start_circ_7_to_0_reserved1 = 16, /* [15:0] */
	BFW_NX10_cordic_coeff_ram_start_circ_7_to_0_C1_LSB    = 8,  /* [23:16] */
	BFW_NX10_cordic_coeff_ram_start_circ_7_to_0_C0_LSB    = 8   /* [31:24] */
};

typedef struct NX10_CORDIC_COEFF_RAM_START_CIRC_7_TO_0_BIT_Ttag {
	unsigned int reserved1 : BFW_NX10_cordic_coeff_ram_start_circ_7_to_0_reserved1; /* reserved                                               */
	unsigned int C1_LSB    : BFW_NX10_cordic_coeff_ram_start_circ_7_to_0_C1_LSB;    /* Least Significant Byte of second circular coefficient: */
	                                                                                /* coeff_circular_1[7:0] == arctan(2^-1)[7:0].            */
	unsigned int C0_LSB    : BFW_NX10_cordic_coeff_ram_start_circ_7_to_0_C0_LSB;    /* Least Significant Byte of first circular coefficient:  */
	                                                                                /* coeff_circular_0[7:0] == arctan(2^-0)[7:0].            */
} NX10_CORDIC_COEFF_RAM_START_CIRC_7_TO_0_BIT_T;

typedef union {
	unsigned int                                  val;
	NX10_CORDIC_COEFF_RAM_START_CIRC_7_TO_0_BIT_T bf;
} NX10_CORDIC_COEFF_RAM_START_CIRC_7_TO_0_T;

/* --------------------------------------------------------------------- */
/* Register cordic_coeff_ram_end_circ_7_to_0 */
/* => End of CORDIC coefficient RAM containing Least Significant Bytes of circular coefficients */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX10_cordic_coeff_ram_end_circ_7_to_0    0x0000034CU
#define Adr_NX10_cordic_cordic_coeff_ram_end_circ_7_to_0 0x1014034CU
#define Adr_NX10_cordic_coeff_ram_end_circ_7_to_0        0x1014034CU
#define DFLT_VAL_NX10_cordic_coeff_ram_end_circ_7_to_0   0x00000000U

#define MSK_NX10_cordic_coeff_ram_end_circ_7_to_0_C39_LSB      0x00ff0000U
#define SRT_NX10_cordic_coeff_ram_end_circ_7_to_0_C39_LSB      16
#define DFLT_VAL_NX10_cordic_coeff_ram_end_circ_7_to_0_C39_LSB 0x00000000U
#define MSK_NX10_cordic_coeff_ram_end_circ_7_to_0_C38_LSB      0xff000000U
#define SRT_NX10_cordic_coeff_ram_end_circ_7_to_0_C38_LSB      24
#define DFLT_VAL_NX10_cordic_coeff_ram_end_circ_7_to_0_C38_LSB 0x00000000U

enum {
	BFW_NX10_cordic_coeff_ram_end_circ_7_to_0_reserved1 = 16, /* [15:0] */
	BFW_NX10_cordic_coeff_ram_end_circ_7_to_0_C39_LSB   = 8,  /* [23:16] */
	BFW_NX10_cordic_coeff_ram_end_circ_7_to_0_C38_LSB   = 8   /* [31:24] */
};

typedef struct NX10_CORDIC_COEFF_RAM_END_CIRC_7_TO_0_BIT_Ttag {
	unsigned int reserved1 : BFW_NX10_cordic_coeff_ram_end_circ_7_to_0_reserved1; /* reserved                                                    */
	unsigned int C39_LSB   : BFW_NX10_cordic_coeff_ram_end_circ_7_to_0_C39_LSB;   /* Least Significant Byte of last circular coefficient:        */
	                                                                              /* coeff_circular_39[7:0] == arctan(2^-39)[7:0].               */
	unsigned int C38_LSB   : BFW_NX10_cordic_coeff_ram_end_circ_7_to_0_C38_LSB;   /* Least Significant Byte of penultimate circular coefficient: */
	                                                                              /* coeff_circular_38[7:0] == arctan(2^-38)[7:0].               */
} NX10_CORDIC_COEFF_RAM_END_CIRC_7_TO_0_BIT_T;

typedef union {
	unsigned int                                val;
	NX10_CORDIC_COEFF_RAM_END_CIRC_7_TO_0_BIT_T bf;
} NX10_CORDIC_COEFF_RAM_END_CIRC_7_TO_0_T;

/* --------------------------------------------------------------------- */
/* Register cordic_coeff_ram_start_hyp_7_to_0 */
/* => Start of CORDIC coefficient RAM containing Least Significant Bytes of hyperbolic coefficients */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX10_cordic_coeff_ram_start_hyp_7_to_0    0x00000350U
#define Adr_NX10_cordic_cordic_coeff_ram_start_hyp_7_to_0 0x10140350U
#define Adr_NX10_cordic_coeff_ram_start_hyp_7_to_0        0x10140350U
#define DFLT_VAL_NX10_cordic_coeff_ram_start_hyp_7_to_0   0x00000000U

#define MSK_NX10_cordic_coeff_ram_start_hyp_7_to_0_H1_LSB      0x00ff0000U
#define SRT_NX10_cordic_coeff_ram_start_hyp_7_to_0_H1_LSB      16
#define DFLT_VAL_NX10_cordic_coeff_ram_start_hyp_7_to_0_H1_LSB 0x00000000U
#define MSK_NX10_cordic_coeff_ram_start_hyp_7_to_0_H0_LSB      0xff000000U
#define SRT_NX10_cordic_coeff_ram_start_hyp_7_to_0_H0_LSB      24
#define DFLT_VAL_NX10_cordic_coeff_ram_start_hyp_7_to_0_H0_LSB 0x00000000U

enum {
	BFW_NX10_cordic_coeff_ram_start_hyp_7_to_0_reserved1 = 16, /* [15:0] */
	BFW_NX10_cordic_coeff_ram_start_hyp_7_to_0_H1_LSB    = 8,  /* [23:16] */
	BFW_NX10_cordic_coeff_ram_start_hyp_7_to_0_H0_LSB    = 8   /* [31:24] */
};

typedef struct NX10_CORDIC_COEFF_RAM_START_HYP_7_TO_0_BIT_Ttag {
	unsigned int reserved1 : BFW_NX10_cordic_coeff_ram_start_hyp_7_to_0_reserved1; /* reserved                                                 */
	unsigned int H1_LSB    : BFW_NX10_cordic_coeff_ram_start_hyp_7_to_0_H1_LSB;    /* Least Significant Byte of second hyperbolic coefficient: */
	                                                                               /* coeff_hyperbolic_1[7:0] == arctanh(2^-1)[7:0].           */
	unsigned int H0_LSB    : BFW_NX10_cordic_coeff_ram_start_hyp_7_to_0_H0_LSB;    /* Least Significant Byte of first hyperbolic coefficient:  */
	                                                                               /* coeff_hyperbolic_0[7:0] == arctanh(2^-0)[7:0].           */
} NX10_CORDIC_COEFF_RAM_START_HYP_7_TO_0_BIT_T;

typedef union {
	unsigned int                                 val;
	NX10_CORDIC_COEFF_RAM_START_HYP_7_TO_0_BIT_T bf;
} NX10_CORDIC_COEFF_RAM_START_HYP_7_TO_0_T;

/* --------------------------------------------------------------------- */
/* Register cordic_coeff_ram_end_hyp_7_to_0 */
/* => End of CORDIC coefficient RAM containing Least Significant Bytes of hyperbolic coefficients */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX10_cordic_coeff_ram_end_hyp_7_to_0    0x0000039CU
#define Adr_NX10_cordic_cordic_coeff_ram_end_hyp_7_to_0 0x1014039CU
#define Adr_NX10_cordic_coeff_ram_end_hyp_7_to_0        0x1014039CU
#define DFLT_VAL_NX10_cordic_coeff_ram_end_hyp_7_to_0   0x00000000U

#define MSK_NX10_cordic_coeff_ram_end_hyp_7_to_0_H39_LSB      0x00ff0000U
#define SRT_NX10_cordic_coeff_ram_end_hyp_7_to_0_H39_LSB      16
#define DFLT_VAL_NX10_cordic_coeff_ram_end_hyp_7_to_0_H39_LSB 0x00000000U
#define MSK_NX10_cordic_coeff_ram_end_hyp_7_to_0_H38_LSB      0xff000000U
#define SRT_NX10_cordic_coeff_ram_end_hyp_7_to_0_H38_LSB      24
#define DFLT_VAL_NX10_cordic_coeff_ram_end_hyp_7_to_0_H38_LSB 0x00000000U

enum {
	BFW_NX10_cordic_coeff_ram_end_hyp_7_to_0_reserved1 = 16, /* [15:0] */
	BFW_NX10_cordic_coeff_ram_end_hyp_7_to_0_H39_LSB   = 8,  /* [23:16] */
	BFW_NX10_cordic_coeff_ram_end_hyp_7_to_0_H38_LSB   = 8   /* [31:24] */
};

typedef struct NX10_CORDIC_COEFF_RAM_END_HYP_7_TO_0_BIT_Ttag {
	unsigned int reserved1 : BFW_NX10_cordic_coeff_ram_end_hyp_7_to_0_reserved1; /* reserved                                                */
	unsigned int H39_LSB   : BFW_NX10_cordic_coeff_ram_end_hyp_7_to_0_H39_LSB;   /* Least Significant Byte of first hyperbolic coefficient: */
	                                                                             /* coeff_hyperbolic_39[7:0] == arctanh(2^-39)[7:0].        */
	unsigned int H38_LSB   : BFW_NX10_cordic_coeff_ram_end_hyp_7_to_0_H38_LSB;   /* Least Significant Byte of first circular coefficient:   */
	                                                                             /* coeff_hyperbolic_38[7:0] == arctanh(2^-38)[7:0].        */
} NX10_CORDIC_COEFF_RAM_END_HYP_7_TO_0_BIT_T;

typedef union {
	unsigned int                               val;
	NX10_CORDIC_COEFF_RAM_END_HYP_7_TO_0_BIT_T bf;
} NX10_CORDIC_COEFF_RAM_END_HYP_7_TO_0_T;


/* ===================================================================== */

/* Area of mpwm */

/* ===================================================================== */

#define Addr_NX10_mpwm 0x10140500U

/* --------------------------------------------------------------------- */
/* Register mpwm_config_counter */
/* => PWM counter config register: */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX10_mpwm_config_counter  0x00000000U
#define Adr_NX10_mpwm_mpwm_config_counter 0x10140500U
#define Adr_NX10_mpwm_config_counter      0x10140500U
#define DFLT_VAL_NX10_mpwm_config_counter 0x00000000U

#define MSK_NX10_mpwm_config_counter_run_cnt0           0x00000001U
#define SRT_NX10_mpwm_config_counter_run_cnt0           0
#define DFLT_VAL_NX10_mpwm_config_counter_run_cnt0      0x00000000U
#define MSK_NX10_mpwm_config_counter_waveform_cnt0      0x00000002U
#define SRT_NX10_mpwm_config_counter_waveform_cnt0      1
#define DFLT_VAL_NX10_mpwm_config_counter_waveform_cnt0 0x00000000U
#define MSK_NX10_mpwm_config_counter_dual_edge0         0x00000004U
#define SRT_NX10_mpwm_config_counter_dual_edge0         2
#define DFLT_VAL_NX10_mpwm_config_counter_dual_edge0    0x00000000U
#define MSK_NX10_mpwm_config_counter_run_cnt1           0x00000008U
#define SRT_NX10_mpwm_config_counter_run_cnt1           3
#define DFLT_VAL_NX10_mpwm_config_counter_run_cnt1      0x00000000U
#define MSK_NX10_mpwm_config_counter_waveform_cnt1      0x00000010U
#define SRT_NX10_mpwm_config_counter_waveform_cnt1      4
#define DFLT_VAL_NX10_mpwm_config_counter_waveform_cnt1 0x00000000U
#define MSK_NX10_mpwm_config_counter_dual_edge1         0x00000020U
#define SRT_NX10_mpwm_config_counter_dual_edge1         5
#define DFLT_VAL_NX10_mpwm_config_counter_dual_edge1    0x00000000U

enum {
	BFW_NX10_mpwm_config_counter_run_cnt0      = 1,  /* [0] */
	BFW_NX10_mpwm_config_counter_waveform_cnt0 = 1,  /* [1] */
	BFW_NX10_mpwm_config_counter_dual_edge0    = 1,  /* [2] */
	BFW_NX10_mpwm_config_counter_run_cnt1      = 1,  /* [3] */
	BFW_NX10_mpwm_config_counter_waveform_cnt1 = 1,  /* [4] */
	BFW_NX10_mpwm_config_counter_dual_edge1    = 1,  /* [5] */
	BFW_NX10_mpwm_config_counter_reserved1     = 26  /* [31:6] */
};

typedef struct NX10_MPWM_CONFIG_COUNTER_BIT_Ttag {
	unsigned int run_cnt0      : BFW_NX10_mpwm_config_counter_run_cnt0;      /* Run counter0                                                */
	                                                                         /* 0: stop counter0 after the actual cycle                     */
	unsigned int waveform_cnt0 : BFW_NX10_mpwm_config_counter_waveform_cnt0; /* Waveform of counter0:                                       */
	                                                                         /* 0: Triangle                                                 */
	unsigned int dual_edge0    : BFW_NX10_mpwm_config_counter_dual_edge0;    /* Dual Edge Mode for shadow registers references on counter0  */
	                                                                         /* 1: update Shadow registers at mpwm_cnt==0 and mpwm_cnt==max */
	unsigned int run_cnt1      : BFW_NX10_mpwm_config_counter_run_cnt1;      /* Run counter1                                                */
	                                                                         /* 0: stop counter1 after the actual cycle                     */
	unsigned int waveform_cnt1 : BFW_NX10_mpwm_config_counter_waveform_cnt1; /* Waveform of counter1:                                       */
	                                                                         /* 0: Triangle                                                 */
	unsigned int dual_edge1    : BFW_NX10_mpwm_config_counter_dual_edge1;    /* Dual Edge Mode for shadow registers references on counter1  */
	                                                                         /* 1: update Shadow registers at mpwm_cnt==0 and mpwm_cnt==max */
	unsigned int reserved1     : BFW_NX10_mpwm_config_counter_reserved1;     /* reserved                                                    */
} NX10_MPWM_CONFIG_COUNTER_BIT_T;

typedef union {
	unsigned int                   val;
	NX10_MPWM_CONFIG_COUNTER_BIT_T bf;
} NX10_MPWM_CONFIG_COUNTER_T;

/* --------------------------------------------------------------------- */
/* Register mpwm_config_pins */
/* => PWM pins config register: */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX10_mpwm_config_pins  0x00000004U
#define Adr_NX10_mpwm_mpwm_config_pins 0x10140504U
#define Adr_NX10_mpwm_config_pins      0x10140504U
#define DFLT_VAL_NX10_mpwm_config_pins 0xccccccccU

#define MSK_NX10_mpwm_config_pins_cfg_0        0x00000007U
#define SRT_NX10_mpwm_config_pins_cfg_0        0
#define DFLT_VAL_NX10_mpwm_config_pins_cfg_0   0x00000004U
#define MSK_NX10_mpwm_config_pins_shadow0      0x00000008U
#define SRT_NX10_mpwm_config_pins_shadow0      3
#define DFLT_VAL_NX10_mpwm_config_pins_shadow0 0x00000008U
#define MSK_NX10_mpwm_config_pins_cfg_1        0x00000070U
#define SRT_NX10_mpwm_config_pins_cfg_1        4
#define DFLT_VAL_NX10_mpwm_config_pins_cfg_1   0x00000040U
#define MSK_NX10_mpwm_config_pins_shadow1      0x00000080U
#define SRT_NX10_mpwm_config_pins_shadow1      7
#define DFLT_VAL_NX10_mpwm_config_pins_shadow1 0x00000080U
#define MSK_NX10_mpwm_config_pins_cfg_2        0x00000700U
#define SRT_NX10_mpwm_config_pins_cfg_2        8
#define DFLT_VAL_NX10_mpwm_config_pins_cfg_2   0x00000400U
#define MSK_NX10_mpwm_config_pins_shadow2      0x00000800U
#define SRT_NX10_mpwm_config_pins_shadow2      11
#define DFLT_VAL_NX10_mpwm_config_pins_shadow2 0x00000800U
#define MSK_NX10_mpwm_config_pins_cfg_3        0x00007000U
#define SRT_NX10_mpwm_config_pins_cfg_3        12
#define DFLT_VAL_NX10_mpwm_config_pins_cfg_3   0x00004000U
#define MSK_NX10_mpwm_config_pins_shadow3      0x00008000U
#define SRT_NX10_mpwm_config_pins_shadow3      15
#define DFLT_VAL_NX10_mpwm_config_pins_shadow3 0x00008000U
#define MSK_NX10_mpwm_config_pins_cfg_4        0x00070000U
#define SRT_NX10_mpwm_config_pins_cfg_4        16
#define DFLT_VAL_NX10_mpwm_config_pins_cfg_4   0x00040000U
#define MSK_NX10_mpwm_config_pins_shadow4      0x00080000U
#define SRT_NX10_mpwm_config_pins_shadow4      19
#define DFLT_VAL_NX10_mpwm_config_pins_shadow4 0x00080000U
#define MSK_NX10_mpwm_config_pins_cfg_5        0x00700000U
#define SRT_NX10_mpwm_config_pins_cfg_5        20
#define DFLT_VAL_NX10_mpwm_config_pins_cfg_5   0x00400000U
#define MSK_NX10_mpwm_config_pins_shadow5      0x00800000U
#define SRT_NX10_mpwm_config_pins_shadow5      23
#define DFLT_VAL_NX10_mpwm_config_pins_shadow5 0x00800000U
#define MSK_NX10_mpwm_config_pins_cfg_6        0x07000000U
#define SRT_NX10_mpwm_config_pins_cfg_6        24
#define DFLT_VAL_NX10_mpwm_config_pins_cfg_6   0x04000000U
#define MSK_NX10_mpwm_config_pins_shadow6      0x08000000U
#define SRT_NX10_mpwm_config_pins_shadow6      27
#define DFLT_VAL_NX10_mpwm_config_pins_shadow6 0x08000000U
#define MSK_NX10_mpwm_config_pins_cfg_7        0x70000000U
#define SRT_NX10_mpwm_config_pins_cfg_7        28
#define DFLT_VAL_NX10_mpwm_config_pins_cfg_7   0x40000000U
#define MSK_NX10_mpwm_config_pins_shadow7      0x80000000U
#define SRT_NX10_mpwm_config_pins_shadow7      31
#define DFLT_VAL_NX10_mpwm_config_pins_shadow7 0x80000000U

enum {
	BFW_NX10_mpwm_config_pins_cfg_0   = 3, /* [2:0] */
	BFW_NX10_mpwm_config_pins_shadow0 = 1, /* [3] */
	BFW_NX10_mpwm_config_pins_cfg_1   = 3, /* [6:4] */
	BFW_NX10_mpwm_config_pins_shadow1 = 1, /* [7] */
	BFW_NX10_mpwm_config_pins_cfg_2   = 3, /* [10:8] */
	BFW_NX10_mpwm_config_pins_shadow2 = 1, /* [11] */
	BFW_NX10_mpwm_config_pins_cfg_3   = 3, /* [14:12] */
	BFW_NX10_mpwm_config_pins_shadow3 = 1, /* [15] */
	BFW_NX10_mpwm_config_pins_cfg_4   = 3, /* [18:16] */
	BFW_NX10_mpwm_config_pins_shadow4 = 1, /* [19] */
	BFW_NX10_mpwm_config_pins_cfg_5   = 3, /* [22:20] */
	BFW_NX10_mpwm_config_pins_shadow5 = 1, /* [23] */
	BFW_NX10_mpwm_config_pins_cfg_6   = 3, /* [26:24] */
	BFW_NX10_mpwm_config_pins_shadow6 = 1, /* [27] */
	BFW_NX10_mpwm_config_pins_cfg_7   = 3, /* [30:28] */
	BFW_NX10_mpwm_config_pins_shadow7 = 1  /* [31] */
};

typedef struct NX10_MPWM_CONFIG_PINS_BIT_Ttag {
	unsigned int cfg_0   : BFW_NX10_mpwm_config_pins_cfg_0;   /* Configuration for PWM Pin0     */
	                                                          /* 000: set output to 1           */
	unsigned int shadow0 : BFW_NX10_mpwm_config_pins_shadow0; /* Shadow Mode                    */
	                                                          /* 0: set mpwm_t0_shadow directly */
	unsigned int cfg_1   : BFW_NX10_mpwm_config_pins_cfg_1;   /* Configuration for PWM Pin1     */
	                                                          /* 000: set output to 1           */
	unsigned int shadow1 : BFW_NX10_mpwm_config_pins_shadow1; /* Shadow Mode                    */
	                                                          /* 0: set mpwm_t1_shadow directly */
	unsigned int cfg_2   : BFW_NX10_mpwm_config_pins_cfg_2;   /* Configuration for PWM Pin2     */
	                                                          /* 000: set output to 1           */
	unsigned int shadow2 : BFW_NX10_mpwm_config_pins_shadow2; /* Shadow Mode                    */
	                                                          /* 0: set mpwm_t2_shadow directly */
	unsigned int cfg_3   : BFW_NX10_mpwm_config_pins_cfg_3;   /* Configuration for PWM Pin3     */
	                                                          /* 000: set output to 1           */
	unsigned int shadow3 : BFW_NX10_mpwm_config_pins_shadow3; /* Shadow Mode                    */
	                                                          /* 0: set mpwm_t3_shadow directly */
	unsigned int cfg_4   : BFW_NX10_mpwm_config_pins_cfg_4;   /* Configuration for PWM Pin4     */
	                                                          /* 000: set output to 1           */
	unsigned int shadow4 : BFW_NX10_mpwm_config_pins_shadow4; /* Shadow Mode                    */
	                                                          /* 0: set mpwm_t4_shadow directly */
	unsigned int cfg_5   : BFW_NX10_mpwm_config_pins_cfg_5;   /* Configuration for PWM Pin5     */
	                                                          /* 000: set output to 1           */
	unsigned int shadow5 : BFW_NX10_mpwm_config_pins_shadow5; /* Shadow Mode                    */
	                                                          /* 0: set mpwm_t5_shadow directly */
	unsigned int cfg_6   : BFW_NX10_mpwm_config_pins_cfg_6;   /* Configuration for PWM Pin6     */
	                                                          /* 000: set output to 1           */
	unsigned int shadow6 : BFW_NX10_mpwm_config_pins_shadow6; /* Shadow Mode                    */
	                                                          /* 0: set mpwm_t6_shadow directly */
	unsigned int cfg_7   : BFW_NX10_mpwm_config_pins_cfg_7;   /* Configuration for PWM Pin7     */
	                                                          /* 000: set output to 1           */
	unsigned int shadow7 : BFW_NX10_mpwm_config_pins_shadow7; /* Shadow Mode                    */
	                                                          /* 0: set mpwm_t7_shadow directly */
} NX10_MPWM_CONFIG_PINS_BIT_T;

typedef union {
	unsigned int                val;
	NX10_MPWM_CONFIG_PINS_BIT_T bf;
} NX10_MPWM_CONFIG_PINS_T;

/* --------------------------------------------------------------------- */
/* Register mpwm_config_failure */
/* => PWM failure config register: */
/*    MPWM unit has a failure input pin, which is configured here. */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX10_mpwm_config_failure  0x00000008U
#define Adr_NX10_mpwm_mpwm_config_failure 0x10140508U
#define Adr_NX10_mpwm_config_failure      0x10140508U
#define DFLT_VAL_NX10_mpwm_config_failure 0x00000000U

#define MSK_NX10_mpwm_config_failure_cfg_0        0x00000003U
#define SRT_NX10_mpwm_config_failure_cfg_0        0
#define DFLT_VAL_NX10_mpwm_config_failure_cfg_0   0x00000000U
#define MSK_NX10_mpwm_config_failure_cfg_1        0x0000000cU
#define SRT_NX10_mpwm_config_failure_cfg_1        2
#define DFLT_VAL_NX10_mpwm_config_failure_cfg_1   0x00000000U
#define MSK_NX10_mpwm_config_failure_cfg_2        0x00000030U
#define SRT_NX10_mpwm_config_failure_cfg_2        4
#define DFLT_VAL_NX10_mpwm_config_failure_cfg_2   0x00000000U
#define MSK_NX10_mpwm_config_failure_cfg_3        0x000000c0U
#define SRT_NX10_mpwm_config_failure_cfg_3        6
#define DFLT_VAL_NX10_mpwm_config_failure_cfg_3   0x00000000U
#define MSK_NX10_mpwm_config_failure_cfg_4        0x00000300U
#define SRT_NX10_mpwm_config_failure_cfg_4        8
#define DFLT_VAL_NX10_mpwm_config_failure_cfg_4   0x00000000U
#define MSK_NX10_mpwm_config_failure_cfg_5        0x00000c00U
#define SRT_NX10_mpwm_config_failure_cfg_5        10
#define DFLT_VAL_NX10_mpwm_config_failure_cfg_5   0x00000000U
#define MSK_NX10_mpwm_config_failure_cfg_6        0x00003000U
#define SRT_NX10_mpwm_config_failure_cfg_6        12
#define DFLT_VAL_NX10_mpwm_config_failure_cfg_6   0x00000000U
#define MSK_NX10_mpwm_config_failure_cfg_7        0x0000c000U
#define SRT_NX10_mpwm_config_failure_cfg_7        14
#define DFLT_VAL_NX10_mpwm_config_failure_cfg_7   0x00000000U
#define MSK_NX10_mpwm_config_failure_enable       0x00010000U
#define SRT_NX10_mpwm_config_failure_enable       16
#define DFLT_VAL_NX10_mpwm_config_failure_enable  0x00000000U
#define MSK_NX10_mpwm_config_failure_failure      0x00020000U
#define SRT_NX10_mpwm_config_failure_failure      17
#define DFLT_VAL_NX10_mpwm_config_failure_failure 0x00000000U

enum {
	BFW_NX10_mpwm_config_failure_cfg_0     = 2,  /* [1:0] */
	BFW_NX10_mpwm_config_failure_cfg_1     = 2,  /* [3:2] */
	BFW_NX10_mpwm_config_failure_cfg_2     = 2,  /* [5:4] */
	BFW_NX10_mpwm_config_failure_cfg_3     = 2,  /* [7:6] */
	BFW_NX10_mpwm_config_failure_cfg_4     = 2,  /* [9:8] */
	BFW_NX10_mpwm_config_failure_cfg_5     = 2,  /* [11:10] */
	BFW_NX10_mpwm_config_failure_cfg_6     = 2,  /* [13:12] */
	BFW_NX10_mpwm_config_failure_cfg_7     = 2,  /* [15:14] */
	BFW_NX10_mpwm_config_failure_enable    = 1,  /* [16] */
	BFW_NX10_mpwm_config_failure_failure   = 1,  /* [17] */
	BFW_NX10_mpwm_config_failure_reserved1 = 14  /* [31:18] */
};

typedef struct NX10_MPWM_CONFIG_FAILURE_BIT_Ttag {
	unsigned int cfg_0     : BFW_NX10_mpwm_config_failure_cfg_0;     /* Configuration for PWM Pin0 in case of failure                                                                 */
	                                                                 /* 00: set output to 0                                                                                           */
	unsigned int cfg_1     : BFW_NX10_mpwm_config_failure_cfg_1;     /* Configuration for PWM Pin1 in case of failure                                                                 */
	                                                                 /* 00: set output to 0                                                                                           */
	unsigned int cfg_2     : BFW_NX10_mpwm_config_failure_cfg_2;     /* Configuration for PWM Pin2 in case of failure                                                                 */
	                                                                 /* 00: set output to 0                                                                                           */
	unsigned int cfg_3     : BFW_NX10_mpwm_config_failure_cfg_3;     /* Configuration for PWM Pin3 in case of failure                                                                 */
	                                                                 /* 00: set output to 0                                                                                           */
	unsigned int cfg_4     : BFW_NX10_mpwm_config_failure_cfg_4;     /* Configuration for PWM Pin4 in case of failure                                                                 */
	                                                                 /* 00: set output to 0                                                                                           */
	unsigned int cfg_5     : BFW_NX10_mpwm_config_failure_cfg_5;     /* Configuration for PWM Pin5 in case of failure                                                                 */
	                                                                 /* 00: set output to 0                                                                                           */
	unsigned int cfg_6     : BFW_NX10_mpwm_config_failure_cfg_6;     /* Configuration for PWM Pin6 in case of failure                                                                 */
	                                                                 /* 00: set output to 0                                                                                           */
	unsigned int cfg_7     : BFW_NX10_mpwm_config_failure_cfg_7;     /* Configuration for PWM Pin7 in case of failure                                                                 */
	                                                                 /* 00: set output to 0                                                                                           */
	unsigned int enable    : BFW_NX10_mpwm_config_failure_enable;    /* Failure input enable                                                                                          */
	                                                                 /* 0: failure input is disabled (ignored)                                                                        */
	unsigned int failure   : BFW_NX10_mpwm_config_failure_failure;   /* To set failure mode by software.                                                                              */
	                                                                 /* Setting this bit generates the irq_raw-failure. To reset, first reset this bit, then clear failure interrupt. */
	unsigned int reserved1 : BFW_NX10_mpwm_config_failure_reserved1; /* reserved                                                                                                      */
} NX10_MPWM_CONFIG_FAILURE_BIT_T;

typedef union {
	unsigned int                   val;
	NX10_MPWM_CONFIG_FAILURE_BIT_T bf;
} NX10_MPWM_CONFIG_FAILURE_T;

/* --------------------------------------------------------------------- */
/* Register mpwm_irq_config */
/* => MPWM IRQ config register */
/*    This register configures source and delay of 2 interrupts */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX10_mpwm_irq_config  0x0000000CU
#define Adr_NX10_mpwm_mpwm_irq_config 0x1014050CU
#define Adr_NX10_mpwm_irq_config      0x1014050CU
#define DFLT_VAL_NX10_mpwm_irq_config 0x00000000U

#define MSK_NX10_mpwm_irq_config_delay0      0x000007ffU
#define SRT_NX10_mpwm_irq_config_delay0      0
#define DFLT_VAL_NX10_mpwm_irq_config_delay0 0x00000000U
#define MSK_NX10_mpwm_irq_config_nr0         0x0000f800U
#define SRT_NX10_mpwm_irq_config_nr0         11
#define DFLT_VAL_NX10_mpwm_irq_config_nr0    0x00000000U
#define MSK_NX10_mpwm_irq_config_delay1      0x07ff0000U
#define SRT_NX10_mpwm_irq_config_delay1      16
#define DFLT_VAL_NX10_mpwm_irq_config_delay1 0x00000000U
#define MSK_NX10_mpwm_irq_config_nr1         0xf8000000U
#define SRT_NX10_mpwm_irq_config_nr1         27
#define DFLT_VAL_NX10_mpwm_irq_config_nr1    0x00000000U

enum {
	BFW_NX10_mpwm_irq_config_delay0 = 11, /* [10:0] */
	BFW_NX10_mpwm_irq_config_nr0    = 5,  /* [15:11] */
	BFW_NX10_mpwm_irq_config_delay1 = 11, /* [26:16] */
	BFW_NX10_mpwm_irq_config_nr1    = 5   /* [31:27] */
};

typedef struct NX10_MPWM_IRQ_CONFIG_BIT_Ttag {
	unsigned int delay0 : BFW_NX10_mpwm_irq_config_delay0; /* Delay from event to generation of interrupt 1 in steps of 20ns */
	                                                       /* TDB: exact times                                               */
	unsigned int nr0    : BFW_NX10_mpwm_irq_config_nr0;    /* select PWM pin for interrupt 0                                 */
	                                                       /* 00000: disable interrupt                                       */
	unsigned int delay1 : BFW_NX10_mpwm_irq_config_delay1; /* Delay from event to generation of interrupt 1 in steps of 20ns */
	                                                       /* TDB: exact times                                               */
	unsigned int nr1    : BFW_NX10_mpwm_irq_config_nr1;    /* select PWM pin for interrupt 1                                 */
	                                                       /* 00000: disable interrupt                                       */
} NX10_MPWM_IRQ_CONFIG_BIT_T;

typedef union {
	unsigned int               val;
	NX10_MPWM_IRQ_CONFIG_BIT_T bf;
} NX10_MPWM_IRQ_CONFIG_T;

/* --------------------------------------------------------------------- */
/* Register mpwm_irq_raw */
/* => MPWM Raw IRQ register */
/*    Write access with '1' resets the appropriate IRQ */
/*    Write access with '0' does not influence this bit */
/*    Read access shows status of unmasked IRQs */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX10_mpwm_irq_raw  0x00000010U
#define Adr_NX10_mpwm_mpwm_irq_raw 0x10140510U
#define Adr_NX10_mpwm_irq_raw      0x10140510U
#define DFLT_VAL_NX10_mpwm_irq_raw 0x00000000U

#define MSK_NX10_mpwm_irq_raw_interrupt0      0x00000001U
#define SRT_NX10_mpwm_irq_raw_interrupt0      0
#define DFLT_VAL_NX10_mpwm_irq_raw_interrupt0 0x00000000U
#define MSK_NX10_mpwm_irq_raw_interrupt1      0x00000002U
#define SRT_NX10_mpwm_irq_raw_interrupt1      1
#define DFLT_VAL_NX10_mpwm_irq_raw_interrupt1 0x00000000U
#define MSK_NX10_mpwm_irq_raw_failure         0x00000004U
#define SRT_NX10_mpwm_irq_raw_failure         2
#define DFLT_VAL_NX10_mpwm_irq_raw_failure    0x00000000U

enum {
	BFW_NX10_mpwm_irq_raw_interrupt0 = 1,  /* [0] */
	BFW_NX10_mpwm_irq_raw_interrupt1 = 1,  /* [1] */
	BFW_NX10_mpwm_irq_raw_failure    = 1,  /* [2] */
	BFW_NX10_mpwm_irq_raw_reserved1  = 29  /* [31:3] */
};

typedef struct NX10_MPWM_IRQ_RAW_BIT_Ttag {
	unsigned int interrupt0 : BFW_NX10_mpwm_irq_raw_interrupt0; /* interrupt 0 as defined in irq_config */
	unsigned int interrupt1 : BFW_NX10_mpwm_irq_raw_interrupt1; /* interrupt 1 as defined in irq_config */
	unsigned int failure    : BFW_NX10_mpwm_irq_raw_failure;    /* interrupt if failure input is active */
	unsigned int reserved1  : BFW_NX10_mpwm_irq_raw_reserved1;  /* reserved                             */
} NX10_MPWM_IRQ_RAW_BIT_T;

typedef union {
	unsigned int            val;
	NX10_MPWM_IRQ_RAW_BIT_T bf;
} NX10_MPWM_IRQ_RAW_T;

/* --------------------------------------------------------------------- */
/* Register mpwm_irq_masked */
/* => MPWM Masked IRQ register */
/*    Shows status of masked IRQs (as connected to ARM/xPIC) */
/* => Mode: R */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX10_mpwm_irq_masked  0x00000014U
#define Adr_NX10_mpwm_mpwm_irq_masked 0x10140514U
#define Adr_NX10_mpwm_irq_masked      0x10140514U

#define MSK_NX10_mpwm_irq_masked_interrupt0 0x00000001U
#define SRT_NX10_mpwm_irq_masked_interrupt0 0
#define MSK_NX10_mpwm_irq_masked_interrupt1 0x00000002U
#define SRT_NX10_mpwm_irq_masked_interrupt1 1
#define MSK_NX10_mpwm_irq_masked_failure    0x00000004U
#define SRT_NX10_mpwm_irq_masked_failure    2

enum {
	BFW_NX10_mpwm_irq_masked_interrupt0 = 1,  /* [0] */
	BFW_NX10_mpwm_irq_masked_interrupt1 = 1,  /* [1] */
	BFW_NX10_mpwm_irq_masked_failure    = 1,  /* [2] */
	BFW_NX10_mpwm_irq_masked_reserved1  = 29  /* [31:3] */
};

typedef struct NX10_MPWM_IRQ_MASKED_BIT_Ttag {
	unsigned int interrupt0 : BFW_NX10_mpwm_irq_masked_interrupt0; /* interrupt 0 as defined in irq_config */
	unsigned int interrupt1 : BFW_NX10_mpwm_irq_masked_interrupt1; /* interrupt 0 as defined in irq_config */
	unsigned int failure    : BFW_NX10_mpwm_irq_masked_failure;    /* interrupt if failure input is active */
	unsigned int reserved1  : BFW_NX10_mpwm_irq_masked_reserved1;  /* reserved                             */
} NX10_MPWM_IRQ_MASKED_BIT_T;

typedef union {
	unsigned int               val;
	NX10_MPWM_IRQ_MASKED_BIT_T bf;
} NX10_MPWM_IRQ_MASKED_T;

/* --------------------------------------------------------------------- */
/* Register mpwm_irq_msk_set */
/* => MPWM interrupt mask enable: */
/*    Write access with '1' sets interrupt mask bit (enables interrupt request for corresponding interrupt source) */
/*    Write access with '0' does not influence this bit */
/*    Read access shows actual interrupt mask */
/*    Attention: Before activating interrupt mask, delete old pending interrupts by writing the same value to adr_mpwm_irq_raw */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX10_mpwm_irq_msk_set  0x00000018U
#define Adr_NX10_mpwm_mpwm_irq_msk_set 0x10140518U
#define Adr_NX10_mpwm_irq_msk_set      0x10140518U
#define DFLT_VAL_NX10_mpwm_irq_msk_set 0x00000000U

#define MSK_NX10_mpwm_irq_msk_set_interrupt0      0x00000001U
#define SRT_NX10_mpwm_irq_msk_set_interrupt0      0
#define DFLT_VAL_NX10_mpwm_irq_msk_set_interrupt0 0x00000000U
#define MSK_NX10_mpwm_irq_msk_set_interrupt1      0x00000002U
#define SRT_NX10_mpwm_irq_msk_set_interrupt1      1
#define DFLT_VAL_NX10_mpwm_irq_msk_set_interrupt1 0x00000000U
#define MSK_NX10_mpwm_irq_msk_set_failure         0x00000004U
#define SRT_NX10_mpwm_irq_msk_set_failure         2
#define DFLT_VAL_NX10_mpwm_irq_msk_set_failure    0x00000000U

enum {
	BFW_NX10_mpwm_irq_msk_set_interrupt0 = 1,  /* [0] */
	BFW_NX10_mpwm_irq_msk_set_interrupt1 = 1,  /* [1] */
	BFW_NX10_mpwm_irq_msk_set_failure    = 1,  /* [2] */
	BFW_NX10_mpwm_irq_msk_set_reserved1  = 29  /* [31:3] */
};

typedef struct NX10_MPWM_IRQ_MSK_SET_BIT_Ttag {
	unsigned int interrupt0 : BFW_NX10_mpwm_irq_msk_set_interrupt0; /* interrupt 0 as defined in irq_config */
	unsigned int interrupt1 : BFW_NX10_mpwm_irq_msk_set_interrupt1; /* interrupt 1 as defined in irq_config */
	unsigned int failure    : BFW_NX10_mpwm_irq_msk_set_failure;    /* interrupt if failure input is active */
	unsigned int reserved1  : BFW_NX10_mpwm_irq_msk_set_reserved1;  /* reserved                             */
} NX10_MPWM_IRQ_MSK_SET_BIT_T;

typedef union {
	unsigned int                val;
	NX10_MPWM_IRQ_MSK_SET_BIT_T bf;
} NX10_MPWM_IRQ_MSK_SET_T;

/* --------------------------------------------------------------------- */
/* Register mpwm_irq_msk_reset */
/* => MPWM interrupt mask disable: */
/*    Write access with '1' resets interrupt mask bit (disables interrupt request for corresponding interrupt source) */
/*    Write access with '0' does not influence this bit */
/*    Read access shows actual interrupt mask */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX10_mpwm_irq_msk_reset  0x0000001CU
#define Adr_NX10_mpwm_mpwm_irq_msk_reset 0x1014051CU
#define Adr_NX10_mpwm_irq_msk_reset      0x1014051CU
#define DFLT_VAL_NX10_mpwm_irq_msk_reset 0x00000000U

#define MSK_NX10_mpwm_irq_msk_reset_interrupt0      0x00000001U
#define SRT_NX10_mpwm_irq_msk_reset_interrupt0      0
#define DFLT_VAL_NX10_mpwm_irq_msk_reset_interrupt0 0x00000000U
#define MSK_NX10_mpwm_irq_msk_reset_interrupt1      0x00000002U
#define SRT_NX10_mpwm_irq_msk_reset_interrupt1      1
#define DFLT_VAL_NX10_mpwm_irq_msk_reset_interrupt1 0x00000000U
#define MSK_NX10_mpwm_irq_msk_reset_failure         0x00000004U
#define SRT_NX10_mpwm_irq_msk_reset_failure         2
#define DFLT_VAL_NX10_mpwm_irq_msk_reset_failure    0x00000000U

enum {
	BFW_NX10_mpwm_irq_msk_reset_interrupt0 = 1,  /* [0] */
	BFW_NX10_mpwm_irq_msk_reset_interrupt1 = 1,  /* [1] */
	BFW_NX10_mpwm_irq_msk_reset_failure    = 1,  /* [2] */
	BFW_NX10_mpwm_irq_msk_reset_reserved1  = 29  /* [31:3] */
};

typedef struct NX10_MPWM_IRQ_MSK_RESET_BIT_Ttag {
	unsigned int interrupt0 : BFW_NX10_mpwm_irq_msk_reset_interrupt0; /* interrupt 0 as defined in irq_config */
	unsigned int interrupt1 : BFW_NX10_mpwm_irq_msk_reset_interrupt1; /* interrupt 1 as defined in irq_config */
	unsigned int failure    : BFW_NX10_mpwm_irq_msk_reset_failure;    /* interrupt if failure input is active */
	unsigned int reserved1  : BFW_NX10_mpwm_irq_msk_reset_reserved1;  /* reserved                             */
} NX10_MPWM_IRQ_MSK_RESET_BIT_T;

typedef union {
	unsigned int                  val;
	NX10_MPWM_IRQ_MSK_RESET_BIT_T bf;
} NX10_MPWM_IRQ_MSK_RESET_T;

/* --------------------------------------------------------------------- */
/* Register mpwm_cnt0_period */
/* => PWM period of counter 0: */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX10_mpwm_cnt0_period  0x00000020U
#define Adr_NX10_mpwm_mpwm_cnt0_period 0x10140520U
#define Adr_NX10_mpwm_cnt0_period      0x10140520U
#define DFLT_VAL_NX10_mpwm_cnt0_period 0x00000000U

#define MSK_NX10_mpwm_cnt0_period_val      0x000ffffcU
#define SRT_NX10_mpwm_cnt0_period_val      2
#define DFLT_VAL_NX10_mpwm_cnt0_period_val 0x00000000U

enum {
	BFW_NX10_mpwm_cnt0_period_reserved1 = 2,  /* [1:0] */
	BFW_NX10_mpwm_cnt0_period_val       = 18, /* [19:2] */
	BFW_NX10_mpwm_cnt0_period_reserved2 = 12  /* [31:20] */
};

typedef struct NX10_MPWM_CNT0_PERIOD_BIT_Ttag {
	unsigned int reserved1 : BFW_NX10_mpwm_cnt0_period_reserved1; /* reserved                                                              */
	unsigned int val       : BFW_NX10_mpwm_cnt0_period_val;       /* PWM period of counter 0:                                              */
	                                                              /* Sawtooth mode: period length in steps of 10ns = cnt0_period[19:2] + 1 */
	unsigned int reserved2 : BFW_NX10_mpwm_cnt0_period_reserved2; /* reserved                                                              */
} NX10_MPWM_CNT0_PERIOD_BIT_T;

typedef union {
	unsigned int                val;
	NX10_MPWM_CNT0_PERIOD_BIT_T bf;
} NX10_MPWM_CNT0_PERIOD_T;

/* --------------------------------------------------------------------- */
/* Register mpwm_cnt0 */
/* => PWM counter 0 value: */
/* => Mode: R */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX10_mpwm_cnt0  0x00000024U
#define Adr_NX10_mpwm_mpwm_cnt0 0x10140524U
#define Adr_NX10_mpwm_cnt0      0x10140524U

#define MSK_NX10_mpwm_cnt0_val 0x000ffffcU
#define SRT_NX10_mpwm_cnt0_val 2

enum {
	BFW_NX10_mpwm_cnt0_reserved1 = 2,  /* [1:0] */
	BFW_NX10_mpwm_cnt0_val       = 18, /* [19:2] */
	BFW_NX10_mpwm_cnt0_reserved2 = 12  /* [31:20] */
};

typedef struct NX10_MPWM_CNT0_BIT_Ttag {
	unsigned int reserved1 : BFW_NX10_mpwm_cnt0_reserved1; /* reserved                      */
	unsigned int val       : BFW_NX10_mpwm_cnt0_val;       /* actual value of PWM counter 0 */
	unsigned int reserved2 : BFW_NX10_mpwm_cnt0_reserved2; /* reserved                      */
} NX10_MPWM_CNT0_BIT_T;

typedef union {
	unsigned int         val;
	NX10_MPWM_CNT0_BIT_T bf;
} NX10_MPWM_CNT0_T;

/* --------------------------------------------------------------------- */
/* Register mpwm_cnt0_systime */
/* => Captured Systime at start point of counter 0 period: */
/* => Mode: R */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX10_mpwm_cnt0_systime  0x00000028U
#define Adr_NX10_mpwm_mpwm_cnt0_systime 0x10140528U
#define Adr_NX10_mpwm_cnt0_systime      0x10140528U

#define MSK_NX10_mpwm_cnt0_systime_val 0x000fffffU
#define SRT_NX10_mpwm_cnt0_systime_val 0

enum {
	BFW_NX10_mpwm_cnt0_systime_val       = 20, /* [19:0] */
	BFW_NX10_mpwm_cnt0_systime_reserved1 = 12  /* [31:20] */
};

typedef struct NX10_MPWM_CNT0_SYSTIME_BIT_Ttag {
	unsigned int val       : BFW_NX10_mpwm_cnt0_systime_val;       /* Captured lower bits of systime at cnt0==0 */
	unsigned int reserved1 : BFW_NX10_mpwm_cnt0_systime_reserved1; /* reserved                                  */
} NX10_MPWM_CNT0_SYSTIME_BIT_T;

typedef union {
	unsigned int                 val;
	NX10_MPWM_CNT0_SYSTIME_BIT_T bf;
} NX10_MPWM_CNT0_SYSTIME_T;

/* --------------------------------------------------------------------- */
/* Register mpwm_cnt0_watchdog */
/* => Counter 0 Watchdog: */
/*    The watchdog counter will decrease with every zero-crossing of PWM counter. */
/*    If the watchdog counter reaches 0, the MPWM module will go to failure state. */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX10_mpwm_cnt0_watchdog  0x0000002CU
#define Adr_NX10_mpwm_mpwm_cnt0_watchdog 0x1014052CU
#define Adr_NX10_mpwm_cnt0_watchdog      0x1014052CU
#define DFLT_VAL_NX10_mpwm_cnt0_watchdog 0x00000000U

#define MSK_NX10_mpwm_cnt0_watchdog_val      0x0000000fU
#define SRT_NX10_mpwm_cnt0_watchdog_val      0
#define DFLT_VAL_NX10_mpwm_cnt0_watchdog_val 0x00000000U

enum {
	BFW_NX10_mpwm_cnt0_watchdog_val       = 4,  /* [3:0] */
	BFW_NX10_mpwm_cnt0_watchdog_reserved1 = 28  /* [31:4] */
};

typedef struct NX10_MPWM_CNT0_WATCHDOG_BIT_Ttag {
	unsigned int val       : BFW_NX10_mpwm_cnt0_watchdog_val;       /* Watchdog counter value:          */
	                                                                /* Set any value != 0 to retrigger. */
	unsigned int reserved1 : BFW_NX10_mpwm_cnt0_watchdog_reserved1; /* reserved                         */
} NX10_MPWM_CNT0_WATCHDOG_BIT_T;

typedef union {
	unsigned int                  val;
	NX10_MPWM_CNT0_WATCHDOG_BIT_T bf;
} NX10_MPWM_CNT0_WATCHDOG_T;

/* --------------------------------------------------------------------- */
/* Register mpwm_cnt1_period */
/* => PWM period of counter 1: */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX10_mpwm_cnt1_period  0x00000030U
#define Adr_NX10_mpwm_mpwm_cnt1_period 0x10140530U
#define Adr_NX10_mpwm_cnt1_period      0x10140530U
#define DFLT_VAL_NX10_mpwm_cnt1_period 0x00000000U

#define MSK_NX10_mpwm_cnt1_period_val      0x000ffffcU
#define SRT_NX10_mpwm_cnt1_period_val      2
#define DFLT_VAL_NX10_mpwm_cnt1_period_val 0x00000000U

enum {
	BFW_NX10_mpwm_cnt1_period_reserved1 = 2,  /* [1:0] */
	BFW_NX10_mpwm_cnt1_period_val       = 18, /* [19:2] */
	BFW_NX10_mpwm_cnt1_period_reserved2 = 12  /* [31:20] */
};

typedef struct NX10_MPWM_CNT1_PERIOD_BIT_Ttag {
	unsigned int reserved1 : BFW_NX10_mpwm_cnt1_period_reserved1; /* reserved                                                              */
	unsigned int val       : BFW_NX10_mpwm_cnt1_period_val;       /* PWM period of counter 1:                                              */
	                                                              /* Sawtooth mode: period length in steps of 10ns = cnt1_period[19:2] + 1 */
	unsigned int reserved2 : BFW_NX10_mpwm_cnt1_period_reserved2; /* reserved                                                              */
} NX10_MPWM_CNT1_PERIOD_BIT_T;

typedef union {
	unsigned int                val;
	NX10_MPWM_CNT1_PERIOD_BIT_T bf;
} NX10_MPWM_CNT1_PERIOD_T;

/* --------------------------------------------------------------------- */
/* Register mpwm_cnt1 */
/* => PWM counter 1 value: */
/* => Mode: R */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX10_mpwm_cnt1  0x00000034U
#define Adr_NX10_mpwm_mpwm_cnt1 0x10140534U
#define Adr_NX10_mpwm_cnt1      0x10140534U

#define MSK_NX10_mpwm_cnt1_val 0x000ffffcU
#define SRT_NX10_mpwm_cnt1_val 2

enum {
	BFW_NX10_mpwm_cnt1_reserved1 = 2,  /* [1:0] */
	BFW_NX10_mpwm_cnt1_val       = 18, /* [19:2] */
	BFW_NX10_mpwm_cnt1_reserved2 = 12  /* [31:20] */
};

typedef struct NX10_MPWM_CNT1_BIT_Ttag {
	unsigned int reserved1 : BFW_NX10_mpwm_cnt1_reserved1; /* reserved                      */
	unsigned int val       : BFW_NX10_mpwm_cnt1_val;       /* actual value of PWM counter 1 */
	unsigned int reserved2 : BFW_NX10_mpwm_cnt1_reserved2; /* reserved                      */
} NX10_MPWM_CNT1_BIT_T;

typedef union {
	unsigned int         val;
	NX10_MPWM_CNT1_BIT_T bf;
} NX10_MPWM_CNT1_T;

/* --------------------------------------------------------------------- */
/* Register mpwm_cnt1_systime */
/* => Captured Systime at start point of counter 1 period: */
/* => Mode: R */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX10_mpwm_cnt1_systime  0x00000038U
#define Adr_NX10_mpwm_mpwm_cnt1_systime 0x10140538U
#define Adr_NX10_mpwm_cnt1_systime      0x10140538U

#define MSK_NX10_mpwm_cnt1_systime_val 0x000fffffU
#define SRT_NX10_mpwm_cnt1_systime_val 0

enum {
	BFW_NX10_mpwm_cnt1_systime_val       = 20, /* [19:0] */
	BFW_NX10_mpwm_cnt1_systime_reserved1 = 12  /* [31:20] */
};

typedef struct NX10_MPWM_CNT1_SYSTIME_BIT_Ttag {
	unsigned int val       : BFW_NX10_mpwm_cnt1_systime_val;       /* Captured lower bits of systime at cnt1==0 */
	unsigned int reserved1 : BFW_NX10_mpwm_cnt1_systime_reserved1; /* reserved                                  */
} NX10_MPWM_CNT1_SYSTIME_BIT_T;

typedef union {
	unsigned int                 val;
	NX10_MPWM_CNT1_SYSTIME_BIT_T bf;
} NX10_MPWM_CNT1_SYSTIME_T;

/* --------------------------------------------------------------------- */
/* Register mpwm_cnt1_watchdog */
/* => Counter 1 Watchdog: */
/*    The watchdog counter will decrease with every zero-crossing of PWM counter. */
/*    If the watchdog counter reaches 0, the MPWM module will go to failure state. */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX10_mpwm_cnt1_watchdog  0x0000003CU
#define Adr_NX10_mpwm_mpwm_cnt1_watchdog 0x1014053CU
#define Adr_NX10_mpwm_cnt1_watchdog      0x1014053CU
#define DFLT_VAL_NX10_mpwm_cnt1_watchdog 0x00000000U

#define MSK_NX10_mpwm_cnt1_watchdog_val      0x0000000fU
#define SRT_NX10_mpwm_cnt1_watchdog_val      0
#define DFLT_VAL_NX10_mpwm_cnt1_watchdog_val 0x00000000U

enum {
	BFW_NX10_mpwm_cnt1_watchdog_val       = 4,  /* [3:0] */
	BFW_NX10_mpwm_cnt1_watchdog_reserved1 = 28  /* [31:4] */
};

typedef struct NX10_MPWM_CNT1_WATCHDOG_BIT_Ttag {
	unsigned int val       : BFW_NX10_mpwm_cnt1_watchdog_val;       /* Watchdog counter value:          */
	                                                                /* Set any value != 0 to retrigger. */
	unsigned int reserved1 : BFW_NX10_mpwm_cnt1_watchdog_reserved1; /* reserved                         */
} NX10_MPWM_CNT1_WATCHDOG_BIT_T;

typedef union {
	unsigned int                  val;
	NX10_MPWM_CNT1_WATCHDOG_BIT_T bf;
} NX10_MPWM_CNT1_WATCHDOG_T;

/* --------------------------------------------------------------------- */
/* Register mpwm_t0 */
/* => PWM channel 0 treshold: */
/*    A threshold value does not exactly desribe the PWM output behaviour, */
/*    as it depends on mode (triangle or sawtooth) and other symmetry and accuracy factors. */
/*    To better describe the exact behaviour of PWM outputs, we use the low phase width, */
/*    which can easily be set in relation with counter period. */
/*    The hardware will automatically choose the exact threshold compare values from the programmed low phase width. */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX10_mpwm_t0  0x00000040U
#define Adr_NX10_mpwm_mpwm_t0 0x10140540U
#define Adr_NX10_mpwm_t0      0x10140540U
#define DFLT_VAL_NX10_mpwm_t0 0x000fffffU

#define MSK_NX10_mpwm_t0_val      0x000fffffU
#define SRT_NX10_mpwm_t0_val      0
#define DFLT_VAL_NX10_mpwm_t0_val 0x000fffffU

enum {
	BFW_NX10_mpwm_t0_val       = 20, /* [19:0] */
	BFW_NX10_mpwm_t0_reserved1 = 12  /* [31:20] */
};

typedef struct NX10_MPWM_T0_BIT_Ttag {
	unsigned int val       : BFW_NX10_mpwm_t0_val;       /* Width of channel 0 low phase in steps of 2,5ns */
	unsigned int reserved1 : BFW_NX10_mpwm_t0_reserved1; /* reserved                                       */
} NX10_MPWM_T0_BIT_T;

typedef union {
	unsigned int       val;
	NX10_MPWM_T0_BIT_T bf;
} NX10_MPWM_T0_T;

/* --------------------------------------------------------------------- */
/* Register mpwm_t1 */
/* => PWM channel 1 treshold: */
/*    A threshold value does not exactly desribe the PWM output behaviour, */
/*    as it depends on mode (triangle or sawtooth) and other symmetry and accuracy factors. */
/*    To better describe the exact behaviour of PWM outputs, we use the low phase width, */
/*    which can easily be set in relation with counter period. */
/*    The hardware will automatically choose the exact threshold compare values from the programmed low phase width. */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX10_mpwm_t1  0x00000044U
#define Adr_NX10_mpwm_mpwm_t1 0x10140544U
#define Adr_NX10_mpwm_t1      0x10140544U
#define DFLT_VAL_NX10_mpwm_t1 0x000fffffU

#define MSK_NX10_mpwm_t1_val      0x000fffffU
#define SRT_NX10_mpwm_t1_val      0
#define DFLT_VAL_NX10_mpwm_t1_val 0x000fffffU

enum {
	BFW_NX10_mpwm_t1_val       = 20, /* [19:0] */
	BFW_NX10_mpwm_t1_reserved1 = 12  /* [31:20] */
};

typedef struct NX10_MPWM_T1_BIT_Ttag {
	unsigned int val       : BFW_NX10_mpwm_t1_val;       /* Width of channel 1 low phase in steps of 2,5ns */
	unsigned int reserved1 : BFW_NX10_mpwm_t1_reserved1; /* reserved                                       */
} NX10_MPWM_T1_BIT_T;

typedef union {
	unsigned int       val;
	NX10_MPWM_T1_BIT_T bf;
} NX10_MPWM_T1_T;

/* --------------------------------------------------------------------- */
/* Register mpwm_t2 */
/* => PWM channel 2 treshold: */
/*    A threshold value does not exactly desribe the PWM output behaviour, */
/*    as it depends on mode (triangle or sawtooth) and other symmetry and accuracy factors. */
/*    To better describe the exact behaviour of PWM outputs, we use the low phase width, */
/*    which can easily be set in relation with counter period. */
/*    The hardware will automatically choose the exact threshold compare values from the programmed low phase width. */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX10_mpwm_t2  0x00000048U
#define Adr_NX10_mpwm_mpwm_t2 0x10140548U
#define Adr_NX10_mpwm_t2      0x10140548U
#define DFLT_VAL_NX10_mpwm_t2 0x000fffffU

#define MSK_NX10_mpwm_t2_val      0x000fffffU
#define SRT_NX10_mpwm_t2_val      0
#define DFLT_VAL_NX10_mpwm_t2_val 0x000fffffU

enum {
	BFW_NX10_mpwm_t2_val       = 20, /* [19:0] */
	BFW_NX10_mpwm_t2_reserved1 = 12  /* [31:20] */
};

typedef struct NX10_MPWM_T2_BIT_Ttag {
	unsigned int val       : BFW_NX10_mpwm_t2_val;       /* Width of channel 2 low phase in steps of 2,5ns */
	unsigned int reserved1 : BFW_NX10_mpwm_t2_reserved1; /* reserved                                       */
} NX10_MPWM_T2_BIT_T;

typedef union {
	unsigned int       val;
	NX10_MPWM_T2_BIT_T bf;
} NX10_MPWM_T2_T;

/* --------------------------------------------------------------------- */
/* Register mpwm_t3 */
/* => PWM channel 3 treshold: */
/*    A threshold value does not exactly desribe the PWM output behaviour, */
/*    as it depends on mode (triangle or sawtooth) and other symmetry and accuracy factors. */
/*    To better describe the exact behaviour of PWM outputs, we use the low phase width, */
/*    which can easily be set in relation with counter period. */
/*    The hardware will automatically choose the exact threshold compare values from the programmed low phase width. */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX10_mpwm_t3  0x0000004CU
#define Adr_NX10_mpwm_mpwm_t3 0x1014054CU
#define Adr_NX10_mpwm_t3      0x1014054CU
#define DFLT_VAL_NX10_mpwm_t3 0x000fffffU

#define MSK_NX10_mpwm_t3_val      0x000fffffU
#define SRT_NX10_mpwm_t3_val      0
#define DFLT_VAL_NX10_mpwm_t3_val 0x000fffffU

enum {
	BFW_NX10_mpwm_t3_val       = 20, /* [19:0] */
	BFW_NX10_mpwm_t3_reserved1 = 12  /* [31:20] */
};

typedef struct NX10_MPWM_T3_BIT_Ttag {
	unsigned int val       : BFW_NX10_mpwm_t3_val;       /* Width of channel 3 low phase in steps of 2,5ns */
	unsigned int reserved1 : BFW_NX10_mpwm_t3_reserved1; /* reserved                                       */
} NX10_MPWM_T3_BIT_T;

typedef union {
	unsigned int       val;
	NX10_MPWM_T3_BIT_T bf;
} NX10_MPWM_T3_T;

/* --------------------------------------------------------------------- */
/* Register mpwm_t4 */
/* => PWM channel 4 treshold: */
/*    A threshold value does not exactly desribe the PWM output behaviour, */
/*    as it depends on mode (triangle or sawtooth) and other symmetry and accuracy factors. */
/*    To better describe the exact behaviour of PWM outputs, we use the low phase width, */
/*    which can easily be set in relation with counter period. */
/*    The hardware will automatically choose the exact threshold compare values from the programmed low phase width. */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX10_mpwm_t4  0x00000050U
#define Adr_NX10_mpwm_mpwm_t4 0x10140550U
#define Adr_NX10_mpwm_t4      0x10140550U
#define DFLT_VAL_NX10_mpwm_t4 0x000fffffU

#define MSK_NX10_mpwm_t4_val      0x000fffffU
#define SRT_NX10_mpwm_t4_val      0
#define DFLT_VAL_NX10_mpwm_t4_val 0x000fffffU

enum {
	BFW_NX10_mpwm_t4_val       = 20, /* [19:0] */
	BFW_NX10_mpwm_t4_reserved1 = 12  /* [31:20] */
};

typedef struct NX10_MPWM_T4_BIT_Ttag {
	unsigned int val       : BFW_NX10_mpwm_t4_val;       /* Width of channel 4 low phase in steps of 2,5ns */
	unsigned int reserved1 : BFW_NX10_mpwm_t4_reserved1; /* reserved                                       */
} NX10_MPWM_T4_BIT_T;

typedef union {
	unsigned int       val;
	NX10_MPWM_T4_BIT_T bf;
} NX10_MPWM_T4_T;

/* --------------------------------------------------------------------- */
/* Register mpwm_t5 */
/* => PWM channel 5 treshold: */
/*    A threshold value does not exactly desribe the PWM output behaviour, */
/*    as it depends on mode (triangle or sawtooth) and other symmetry and accuracy factors. */
/*    To better describe the exact behaviour of PWM outputs, we use the low phase width, */
/*    which can easily be set in relation with counter period. */
/*    The hardware will automatically choose the exact threshold compare values from the programmed low phase width. */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX10_mpwm_t5  0x00000054U
#define Adr_NX10_mpwm_mpwm_t5 0x10140554U
#define Adr_NX10_mpwm_t5      0x10140554U
#define DFLT_VAL_NX10_mpwm_t5 0x000fffffU

#define MSK_NX10_mpwm_t5_val      0x000fffffU
#define SRT_NX10_mpwm_t5_val      0
#define DFLT_VAL_NX10_mpwm_t5_val 0x000fffffU

enum {
	BFW_NX10_mpwm_t5_val       = 20, /* [19:0] */
	BFW_NX10_mpwm_t5_reserved1 = 12  /* [31:20] */
};

typedef struct NX10_MPWM_T5_BIT_Ttag {
	unsigned int val       : BFW_NX10_mpwm_t5_val;       /* Width of channel 5 low phase in steps of 2,5ns */
	unsigned int reserved1 : BFW_NX10_mpwm_t5_reserved1; /* reserved                                       */
} NX10_MPWM_T5_BIT_T;

typedef union {
	unsigned int       val;
	NX10_MPWM_T5_BIT_T bf;
} NX10_MPWM_T5_T;

/* --------------------------------------------------------------------- */
/* Register mpwm_t6 */
/* => PWM channel 6 treshold: */
/*    A threshold value does not exactly desribe the PWM output behaviour, */
/*    as it depends on mode (triangle or sawtooth) and other symmetry and accuracy factors. */
/*    To better describe the exact behaviour of PWM outputs, we use the low phase width, */
/*    which can easily be set in relation with counter period. */
/*    The hardware will automatically choose the exact threshold compare values from the programmed low phase width. */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX10_mpwm_t6  0x00000058U
#define Adr_NX10_mpwm_mpwm_t6 0x10140558U
#define Adr_NX10_mpwm_t6      0x10140558U
#define DFLT_VAL_NX10_mpwm_t6 0x000fffffU

#define MSK_NX10_mpwm_t6_val      0x000fffffU
#define SRT_NX10_mpwm_t6_val      0
#define DFLT_VAL_NX10_mpwm_t6_val 0x000fffffU

enum {
	BFW_NX10_mpwm_t6_val       = 20, /* [19:0] */
	BFW_NX10_mpwm_t6_reserved1 = 12  /* [31:20] */
};

typedef struct NX10_MPWM_T6_BIT_Ttag {
	unsigned int val       : BFW_NX10_mpwm_t6_val;       /* Width of channel 6 low phase in steps of 2,5ns */
	unsigned int reserved1 : BFW_NX10_mpwm_t6_reserved1; /* reserved                                       */
} NX10_MPWM_T6_BIT_T;

typedef union {
	unsigned int       val;
	NX10_MPWM_T6_BIT_T bf;
} NX10_MPWM_T6_T;

/* --------------------------------------------------------------------- */
/* Register mpwm_t7 */
/* => PWM channel 7 treshold: */
/*    A threshold value does not exactly desribe the PWM output behaviour, */
/*    as it depends on mode (triangle or sawtooth) and other symmetry and accuracy factors. */
/*    To better describe the exact behaviour of PWM outputs, we use the low phase width, */
/*    which can easily be set in relation with counter period. */
/*    The hardware will automatically choose the exact threshold compare values from the programmed low phase width. */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX10_mpwm_t7  0x0000005CU
#define Adr_NX10_mpwm_mpwm_t7 0x1014055CU
#define Adr_NX10_mpwm_t7      0x1014055CU
#define DFLT_VAL_NX10_mpwm_t7 0x000fffffU

#define MSK_NX10_mpwm_t7_val      0x000fffffU
#define SRT_NX10_mpwm_t7_val      0
#define DFLT_VAL_NX10_mpwm_t7_val 0x000fffffU

enum {
	BFW_NX10_mpwm_t7_val       = 20, /* [19:0] */
	BFW_NX10_mpwm_t7_reserved1 = 12  /* [31:20] */
};

typedef struct NX10_MPWM_T7_BIT_Ttag {
	unsigned int val       : BFW_NX10_mpwm_t7_val;       /* Width of channel 7 low phase in steps of 2,5ns */
	unsigned int reserved1 : BFW_NX10_mpwm_t7_reserved1; /* reserved                                       */
} NX10_MPWM_T7_BIT_T;

typedef union {
	unsigned int       val;
	NX10_MPWM_T7_BIT_T bf;
} NX10_MPWM_T7_T;

/* --------------------------------------------------------------------- */
/* Register mpwm_t0_shadow */
/* => PWM channel 0 low phase width shadow: */
/* => Mode: R */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX10_mpwm_t0_shadow  0x00000060U
#define Adr_NX10_mpwm_mpwm_t0_shadow 0x10140560U
#define Adr_NX10_mpwm_t0_shadow      0x10140560U

#define MSK_NX10_mpwm_t0_shadow_val 0x000fffffU
#define SRT_NX10_mpwm_t0_shadow_val 0

enum {
	BFW_NX10_mpwm_t0_shadow_val       = 20, /* [19:0] */
	BFW_NX10_mpwm_t0_shadow_reserved1 = 12  /* [31:20] */
};

typedef struct NX10_MPWM_T0_SHADOW_BIT_Ttag {
	unsigned int val       : BFW_NX10_mpwm_t0_shadow_val;       /* Value will be updated from mpwm_t0 at end of period if mpwm_config_pins-shadow0. */
	unsigned int reserved1 : BFW_NX10_mpwm_t0_shadow_reserved1; /* reserved                                                                         */
} NX10_MPWM_T0_SHADOW_BIT_T;

typedef union {
	unsigned int              val;
	NX10_MPWM_T0_SHADOW_BIT_T bf;
} NX10_MPWM_T0_SHADOW_T;

/* --------------------------------------------------------------------- */
/* Register mpwm_t1_shadow */
/* => PWM channel 1 low phase width shadow: */
/* => Mode: R */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX10_mpwm_t1_shadow  0x00000064U
#define Adr_NX10_mpwm_mpwm_t1_shadow 0x10140564U
#define Adr_NX10_mpwm_t1_shadow      0x10140564U

#define MSK_NX10_mpwm_t1_shadow_val 0x000fffffU
#define SRT_NX10_mpwm_t1_shadow_val 0

enum {
	BFW_NX10_mpwm_t1_shadow_val       = 20, /* [19:0] */
	BFW_NX10_mpwm_t1_shadow_reserved1 = 12  /* [31:20] */
};

typedef struct NX10_MPWM_T1_SHADOW_BIT_Ttag {
	unsigned int val       : BFW_NX10_mpwm_t1_shadow_val;       /* Value will be updated from mpwm_t1 at end of period if mpwm_config_pins-shadow1. */
	unsigned int reserved1 : BFW_NX10_mpwm_t1_shadow_reserved1; /* reserved                                                                         */
} NX10_MPWM_T1_SHADOW_BIT_T;

typedef union {
	unsigned int              val;
	NX10_MPWM_T1_SHADOW_BIT_T bf;
} NX10_MPWM_T1_SHADOW_T;

/* --------------------------------------------------------------------- */
/* Register mpwm_t2_shadow */
/* => PWM channel 2 low phase width shadow: */
/* => Mode: R */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX10_mpwm_t2_shadow  0x00000068U
#define Adr_NX10_mpwm_mpwm_t2_shadow 0x10140568U
#define Adr_NX10_mpwm_t2_shadow      0x10140568U

#define MSK_NX10_mpwm_t2_shadow_val 0x000fffffU
#define SRT_NX10_mpwm_t2_shadow_val 0

enum {
	BFW_NX10_mpwm_t2_shadow_val       = 20, /* [19:0] */
	BFW_NX10_mpwm_t2_shadow_reserved1 = 12  /* [31:20] */
};

typedef struct NX10_MPWM_T2_SHADOW_BIT_Ttag {
	unsigned int val       : BFW_NX10_mpwm_t2_shadow_val;       /* Value will be updated from mpwm_t2 at end of period if mpwm_config_pins-shadow2. */
	unsigned int reserved1 : BFW_NX10_mpwm_t2_shadow_reserved1; /* reserved                                                                         */
} NX10_MPWM_T2_SHADOW_BIT_T;

typedef union {
	unsigned int              val;
	NX10_MPWM_T2_SHADOW_BIT_T bf;
} NX10_MPWM_T2_SHADOW_T;

/* --------------------------------------------------------------------- */
/* Register mpwm_t3_shadow */
/* => PWM channel 3 low phase width shadow: */
/* => Mode: R */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX10_mpwm_t3_shadow  0x0000006CU
#define Adr_NX10_mpwm_mpwm_t3_shadow 0x1014056CU
#define Adr_NX10_mpwm_t3_shadow      0x1014056CU

#define MSK_NX10_mpwm_t3_shadow_val 0x000fffffU
#define SRT_NX10_mpwm_t3_shadow_val 0

enum {
	BFW_NX10_mpwm_t3_shadow_val       = 20, /* [19:0] */
	BFW_NX10_mpwm_t3_shadow_reserved1 = 12  /* [31:20] */
};

typedef struct NX10_MPWM_T3_SHADOW_BIT_Ttag {
	unsigned int val       : BFW_NX10_mpwm_t3_shadow_val;       /* Value will be updated from mpwm_t3 at end of period if mpwm_config_pins-shadow3. */
	unsigned int reserved1 : BFW_NX10_mpwm_t3_shadow_reserved1; /* reserved                                                                         */
} NX10_MPWM_T3_SHADOW_BIT_T;

typedef union {
	unsigned int              val;
	NX10_MPWM_T3_SHADOW_BIT_T bf;
} NX10_MPWM_T3_SHADOW_T;

/* --------------------------------------------------------------------- */
/* Register mpwm_t4_shadow */
/* => PWM channel 4 low phase width shadow: */
/* => Mode: R */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX10_mpwm_t4_shadow  0x00000070U
#define Adr_NX10_mpwm_mpwm_t4_shadow 0x10140570U
#define Adr_NX10_mpwm_t4_shadow      0x10140570U

#define MSK_NX10_mpwm_t4_shadow_val 0x000fffffU
#define SRT_NX10_mpwm_t4_shadow_val 0

enum {
	BFW_NX10_mpwm_t4_shadow_val       = 20, /* [19:0] */
	BFW_NX10_mpwm_t4_shadow_reserved1 = 12  /* [31:20] */
};

typedef struct NX10_MPWM_T4_SHADOW_BIT_Ttag {
	unsigned int val       : BFW_NX10_mpwm_t4_shadow_val;       /* Value will be updated from mpwm_t4 at end of period if mpwm_config_pins-shadow4. */
	unsigned int reserved1 : BFW_NX10_mpwm_t4_shadow_reserved1; /* reserved                                                                         */
} NX10_MPWM_T4_SHADOW_BIT_T;

typedef union {
	unsigned int              val;
	NX10_MPWM_T4_SHADOW_BIT_T bf;
} NX10_MPWM_T4_SHADOW_T;

/* --------------------------------------------------------------------- */
/* Register mpwm_t5_shadow */
/* => PWM channel 5 low phase width shadow: */
/* => Mode: R */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX10_mpwm_t5_shadow  0x00000074U
#define Adr_NX10_mpwm_mpwm_t5_shadow 0x10140574U
#define Adr_NX10_mpwm_t5_shadow      0x10140574U

#define MSK_NX10_mpwm_t5_shadow_val 0x000fffffU
#define SRT_NX10_mpwm_t5_shadow_val 0

enum {
	BFW_NX10_mpwm_t5_shadow_val       = 20, /* [19:0] */
	BFW_NX10_mpwm_t5_shadow_reserved1 = 12  /* [31:20] */
};

typedef struct NX10_MPWM_T5_SHADOW_BIT_Ttag {
	unsigned int val       : BFW_NX10_mpwm_t5_shadow_val;       /* Value will be updated from mpwm_t5 at end of period if mpwm_config_pins-shadow5. */
	unsigned int reserved1 : BFW_NX10_mpwm_t5_shadow_reserved1; /* reserved                                                                         */
} NX10_MPWM_T5_SHADOW_BIT_T;

typedef union {
	unsigned int              val;
	NX10_MPWM_T5_SHADOW_BIT_T bf;
} NX10_MPWM_T5_SHADOW_T;

/* --------------------------------------------------------------------- */
/* Register mpwm_t6_shadow */
/* => PWM channel 6 low phase width shadow: */
/* => Mode: R */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX10_mpwm_t6_shadow  0x00000078U
#define Adr_NX10_mpwm_mpwm_t6_shadow 0x10140578U
#define Adr_NX10_mpwm_t6_shadow      0x10140578U

#define MSK_NX10_mpwm_t6_shadow_val 0x000fffffU
#define SRT_NX10_mpwm_t6_shadow_val 0

enum {
	BFW_NX10_mpwm_t6_shadow_val       = 20, /* [19:0] */
	BFW_NX10_mpwm_t6_shadow_reserved1 = 12  /* [31:20] */
};

typedef struct NX10_MPWM_T6_SHADOW_BIT_Ttag {
	unsigned int val       : BFW_NX10_mpwm_t6_shadow_val;       /* Value will be updated from mpwm_t6 at end of period if mpwm_config_pins-shadow6. */
	unsigned int reserved1 : BFW_NX10_mpwm_t6_shadow_reserved1; /* reserved                                                                         */
} NX10_MPWM_T6_SHADOW_BIT_T;

typedef union {
	unsigned int              val;
	NX10_MPWM_T6_SHADOW_BIT_T bf;
} NX10_MPWM_T6_SHADOW_T;

/* --------------------------------------------------------------------- */
/* Register mpwm_t7_shadow */
/* => PWM channel 7 low phase width shadow: */
/* => Mode: R */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX10_mpwm_t7_shadow  0x0000007CU
#define Adr_NX10_mpwm_mpwm_t7_shadow 0x1014057CU
#define Adr_NX10_mpwm_t7_shadow      0x1014057CU

#define MSK_NX10_mpwm_t7_shadow_val 0x000fffffU
#define SRT_NX10_mpwm_t7_shadow_val 0

enum {
	BFW_NX10_mpwm_t7_shadow_val       = 20, /* [19:0] */
	BFW_NX10_mpwm_t7_shadow_reserved1 = 12  /* [31:20] */
};

typedef struct NX10_MPWM_T7_SHADOW_BIT_Ttag {
	unsigned int val       : BFW_NX10_mpwm_t7_shadow_val;       /* Value will be updated from mpwm_t7 at end of period if mpwm_config_pins-shadow7. */
	unsigned int reserved1 : BFW_NX10_mpwm_t7_shadow_reserved1; /* reserved                                                                         */
} NX10_MPWM_T7_SHADOW_BIT_T;

typedef union {
	unsigned int              val;
	NX10_MPWM_T7_SHADOW_BIT_T bf;
} NX10_MPWM_T7_SHADOW_T;


/* ===================================================================== */

/* Area of menc */

/* ===================================================================== */

#define Addr_NX10_menc 0x10140580U

/* --------------------------------------------------------------------- */
/* Register menc_config */
/* => Encoder configuration register: */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX10_menc_config  0x00000000U
#define Adr_NX10_menc_menc_config 0x10140580U
#define Adr_NX10_menc_config      0x10140580U
#define DFLT_VAL_NX10_menc_config 0x00000000U

#define MSK_NX10_menc_config_enc0_en                      0x00000001U
#define SRT_NX10_menc_config_enc0_en                      0
#define DFLT_VAL_NX10_menc_config_enc0_en                 0x00000000U
#define MSK_NX10_menc_config_enc0_filter_sample_rate      0x0000000eU
#define SRT_NX10_menc_config_enc0_filter_sample_rate      1
#define DFLT_VAL_NX10_menc_config_enc0_filter_sample_rate 0x00000000U
#define MSK_NX10_menc_config_enc0_count_dir               0x00000010U
#define SRT_NX10_menc_config_enc0_count_dir               4
#define DFLT_VAL_NX10_menc_config_enc0_count_dir          0x00000000U
#define MSK_NX10_menc_config_enc1_en                      0x00000100U
#define SRT_NX10_menc_config_enc1_en                      8
#define DFLT_VAL_NX10_menc_config_enc1_en                 0x00000000U
#define MSK_NX10_menc_config_enc1_filter_sample_rate      0x00000e00U
#define SRT_NX10_menc_config_enc1_filter_sample_rate      9
#define DFLT_VAL_NX10_menc_config_enc1_filter_sample_rate 0x00000000U
#define MSK_NX10_menc_config_enc1_count_dir               0x00001000U
#define SRT_NX10_menc_config_enc1_count_dir               12
#define DFLT_VAL_NX10_menc_config_enc1_count_dir          0x00000000U
#define MSK_NX10_menc_config_mp0_en                       0x00010000U
#define SRT_NX10_menc_config_mp0_en                       16
#define DFLT_VAL_NX10_menc_config_mp0_en                  0x00000000U
#define MSK_NX10_menc_config_mp0_filter_sample_rate       0x000e0000U
#define SRT_NX10_menc_config_mp0_filter_sample_rate       17
#define DFLT_VAL_NX10_menc_config_mp0_filter_sample_rate  0x00000000U
#define MSK_NX10_menc_config_mp1_en                       0x01000000U
#define SRT_NX10_menc_config_mp1_en                       24
#define DFLT_VAL_NX10_menc_config_mp1_en                  0x00000000U
#define MSK_NX10_menc_config_mp1_filter_sample_rate       0x0e000000U
#define SRT_NX10_menc_config_mp1_filter_sample_rate       25
#define DFLT_VAL_NX10_menc_config_mp1_filter_sample_rate  0x00000000U

enum {
	BFW_NX10_menc_config_enc0_en                 = 1, /* [0] */
	BFW_NX10_menc_config_enc0_filter_sample_rate = 3, /* [3:1] */
	BFW_NX10_menc_config_enc0_count_dir          = 1, /* [4] */
	BFW_NX10_menc_config_reserved1               = 3, /* [7:5] */
	BFW_NX10_menc_config_enc1_en                 = 1, /* [8] */
	BFW_NX10_menc_config_enc1_filter_sample_rate = 3, /* [11:9] */
	BFW_NX10_menc_config_enc1_count_dir          = 1, /* [12] */
	BFW_NX10_menc_config_reserved2               = 3, /* [15:13] */
	BFW_NX10_menc_config_mp0_en                  = 1, /* [16] */
	BFW_NX10_menc_config_mp0_filter_sample_rate  = 3, /* [19:17] */
	BFW_NX10_menc_config_reserved3               = 4, /* [23:20] */
	BFW_NX10_menc_config_mp1_en                  = 1, /* [24] */
	BFW_NX10_menc_config_mp1_filter_sample_rate  = 3, /* [27:25] */
	BFW_NX10_menc_config_reserved4               = 4  /* [31:28] */
};

typedef struct NX10_MENC_CONFIG_BIT_Ttag {
	unsigned int enc0_en                 : BFW_NX10_menc_config_enc0_en;                 /* Encoder0 enable                                 */
	                                                                                     /* 0: disable interrupts based on encoder0 signals */
	unsigned int enc0_filter_sample_rate : BFW_NX10_menc_config_enc0_filter_sample_rate; /* Encoder0 filter sample rate                     */
	                                                                                     /* 0: none - Filter is disabled                    */
	unsigned int enc0_count_dir          : BFW_NX10_menc_config_enc0_count_dir;          /* Encoder0 count direction                        */
	                                                                                     /* 0: standard, 1: inverted                        */
	unsigned int reserved1               : BFW_NX10_menc_config_reserved1;               /* reserved                                        */
	unsigned int enc1_en                 : BFW_NX10_menc_config_enc1_en;                 /* Encoder1 enable                                 */
	                                                                                     /* 0: disable interrupts based on encoder1 signals */
	unsigned int enc1_filter_sample_rate : BFW_NX10_menc_config_enc1_filter_sample_rate; /* Encoder1 filter sample rate                     */
	                                                                                     /* 0: none - Filter is disabled                    */
	unsigned int enc1_count_dir          : BFW_NX10_menc_config_enc1_count_dir;          /* Encoder1 count direction                        */
	                                                                                     /* 0: standard, 1: inverted                        */
	unsigned int reserved2               : BFW_NX10_menc_config_reserved2;               /* reserved                                        */
	unsigned int mp0_en                  : BFW_NX10_menc_config_mp0_en;                  /* mp0 enable:                                     */
	                                                                                     /* 0: disable interrupts based on mp0 signal       */
	unsigned int mp0_filter_sample_rate  : BFW_NX10_menc_config_mp0_filter_sample_rate;  /* Filter sample rate for mp0 signal               */
	                                                                                     /* 0: none - Filter is disabled                    */
	unsigned int reserved3               : BFW_NX10_menc_config_reserved3;               /* reserved                                        */
	unsigned int mp1_en                  : BFW_NX10_menc_config_mp1_en;                  /* mp1 enable                                      */
	                                                                                     /* 0: disable interrupts based on mp1 signal       */
	unsigned int mp1_filter_sample_rate  : BFW_NX10_menc_config_mp1_filter_sample_rate;  /* Filter sample rate for mp1 signal               */
	                                                                                     /* 0: none - Filter is disabled                    */
	unsigned int reserved4               : BFW_NX10_menc_config_reserved4;               /* reserved                                        */
} NX10_MENC_CONFIG_BIT_T;

typedef union {
	unsigned int           val;
	NX10_MENC_CONFIG_BIT_T bf;
} NX10_MENC_CONFIG_T;

/* --------------------------------------------------------------------- */
/* Register menc_enc0_position */
/* => Actual position of encoder 0: */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX10_menc_enc0_position  0x00000004U
#define Adr_NX10_menc_menc_enc0_position 0x10140584U
#define Adr_NX10_menc_enc0_position      0x10140584U
#define DFLT_VAL_NX10_menc_enc0_position 0x00000000U

#define MSK_NX10_menc_enc0_position_val      0xffffffffU
#define SRT_NX10_menc_enc0_position_val      0
#define DFLT_VAL_NX10_menc_enc0_position_val 0x00000000U

enum {
	BFW_NX10_menc_enc0_position_val = 32  /* [31:0] */
};

typedef struct NX10_MENC_ENC0_POSITION_BIT_Ttag {
	unsigned int val : BFW_NX10_menc_enc0_position_val; /* Actual position of encoder 0                                   */
	                                                    /* This register is writable but can also be changed by hardware. */
} NX10_MENC_ENC0_POSITION_BIT_T;

typedef union {
	unsigned int                  val;
	NX10_MENC_ENC0_POSITION_BIT_T bf;
} NX10_MENC_ENC0_POSITION_T;

/* --------------------------------------------------------------------- */
/* Register menc_enc1_position */
/* => Actual position of encoder 1: */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX10_menc_enc1_position  0x00000008U
#define Adr_NX10_menc_menc_enc1_position 0x10140588U
#define Adr_NX10_menc_enc1_position      0x10140588U
#define DFLT_VAL_NX10_menc_enc1_position 0x00000000U

#define MSK_NX10_menc_enc1_position_val      0xffffffffU
#define SRT_NX10_menc_enc1_position_val      0
#define DFLT_VAL_NX10_menc_enc1_position_val 0x00000000U

enum {
	BFW_NX10_menc_enc1_position_val = 32  /* [31:0] */
};

typedef struct NX10_MENC_ENC1_POSITION_BIT_Ttag {
	unsigned int val : BFW_NX10_menc_enc1_position_val; /* Actual position of encoder 1                                   */
	                                                    /* This register is writable but can also be changed by hardware. */
} NX10_MENC_ENC1_POSITION_BIT_T;

typedef union {
	unsigned int                  val;
	NX10_MENC_ENC1_POSITION_BIT_T bf;
} NX10_MENC_ENC1_POSITION_T;

/* --------------------------------------------------------------------- */
/* Register menc_capture_now */
/* => Capture unit capture-now register: */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX10_menc_capture_now  0x0000000CU
#define Adr_NX10_menc_menc_capture_now 0x1014058CU
#define Adr_NX10_menc_capture_now      0x1014058CU
#define DFLT_VAL_NX10_menc_capture_now 0x00000000U

#define MSK_NX10_menc_capture_now_cap0_now      0x00000001U
#define SRT_NX10_menc_capture_now_cap0_now      0
#define DFLT_VAL_NX10_menc_capture_now_cap0_now 0x00000000U
#define MSK_NX10_menc_capture_now_cap1_now      0x00000002U
#define SRT_NX10_menc_capture_now_cap1_now      1
#define DFLT_VAL_NX10_menc_capture_now_cap1_now 0x00000000U
#define MSK_NX10_menc_capture_now_cap2_now      0x00000004U
#define SRT_NX10_menc_capture_now_cap2_now      2
#define DFLT_VAL_NX10_menc_capture_now_cap2_now 0x00000000U
#define MSK_NX10_menc_capture_now_cap3_now      0x00000008U
#define SRT_NX10_menc_capture_now_cap3_now      3
#define DFLT_VAL_NX10_menc_capture_now_cap3_now 0x00000000U

enum {
	BFW_NX10_menc_capture_now_cap0_now  = 1,  /* [0] */
	BFW_NX10_menc_capture_now_cap1_now  = 1,  /* [1] */
	BFW_NX10_menc_capture_now_cap2_now  = 1,  /* [2] */
	BFW_NX10_menc_capture_now_cap3_now  = 1,  /* [3] */
	BFW_NX10_menc_capture_now_reserved1 = 28  /* [31:4] */
};

typedef struct NX10_MENC_CAPTURE_NOW_BIT_Ttag {
	unsigned int cap0_now  : BFW_NX10_menc_capture_now_cap0_now;  /* capture menc_capture0 now (by SW)                           */
	                                                              /* Capture by writing 1 to this register, reset automatically. */
	unsigned int cap1_now  : BFW_NX10_menc_capture_now_cap1_now;  /* capture menc_capture1 now (by SW)                           */
	                                                              /* Capture by writing 1 to this register, reset automatically. */
	unsigned int cap2_now  : BFW_NX10_menc_capture_now_cap2_now;  /* capture menc_capture2 now (by SW)                           */
	                                                              /* Capture by writing 1 to this register, reset automatically. */
	unsigned int cap3_now  : BFW_NX10_menc_capture_now_cap3_now;  /* capture menc_capture3 now (by SW)                           */
	                                                              /* Capture by writing 1 to this register, reset automatically. */
	unsigned int reserved1 : BFW_NX10_menc_capture_now_reserved1; /* reserved                                                    */
} NX10_MENC_CAPTURE_NOW_BIT_T;

typedef union {
	unsigned int                val;
	NX10_MENC_CAPTURE_NOW_BIT_T bf;
} NX10_MENC_CAPTURE_NOW_T;

/* --------------------------------------------------------------------- */
/* Register menc_capture0_config */
/* => Capture unit 0 configuration register: */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX10_menc_capture0_config  0x00000010U
#define Adr_NX10_menc_menc_capture0_config 0x10140590U
#define Adr_NX10_menc_capture0_config      0x10140590U
#define DFLT_VAL_NX10_menc_capture0_config 0x00000000U

#define MSK_NX10_menc_capture0_config_inv         0x00000001U
#define SRT_NX10_menc_capture0_config_inv         0
#define DFLT_VAL_NX10_menc_capture0_config_inv    0x00000000U
#define MSK_NX10_menc_capture0_config_sel         0x0000003eU
#define SRT_NX10_menc_capture0_config_sel         1
#define DFLT_VAL_NX10_menc_capture0_config_sel    0x00000000U
#define MSK_NX10_menc_capture0_config_src         0x000001c0U
#define SRT_NX10_menc_capture0_config_src         6
#define DFLT_VAL_NX10_menc_capture0_config_src    0x00000000U
#define MSK_NX10_menc_capture0_config_src_nr      0x00000200U
#define SRT_NX10_menc_capture0_config_src_nr      9
#define DFLT_VAL_NX10_menc_capture0_config_src_nr 0x00000000U
#define MSK_NX10_menc_capture0_config_conce       0x00000400U
#define SRT_NX10_menc_capture0_config_conce       10
#define DFLT_VAL_NX10_menc_capture0_config_conce  0x00000000U

enum {
	BFW_NX10_menc_capture0_config_inv       = 1,  /* [0] */
	BFW_NX10_menc_capture0_config_sel       = 5,  /* [5:1] */
	BFW_NX10_menc_capture0_config_src       = 3,  /* [8:6] */
	BFW_NX10_menc_capture0_config_src_nr    = 1,  /* [9] */
	BFW_NX10_menc_capture0_config_conce     = 1,  /* [10] */
	BFW_NX10_menc_capture0_config_reserved1 = 21  /* [31:11] */
};

typedef struct NX10_MENC_CAPTURE0_CONFIG_BIT_Ttag {
	unsigned int inv       : BFW_NX10_menc_capture0_config_inv;       /* Invert capture start signal                                       */
	                                                                  /* 0:  positive edge                                                 */
	unsigned int sel       : BFW_NX10_menc_capture0_config_sel;       /* Capture start signal                                              */
	                                                                  /* 0 : off (no capture)                                              */
	unsigned int src       : BFW_NX10_menc_capture0_config_src;       /* Capture source (what to capture)                                  */
	                                                                  /* 0:  system time ns (independant of src_nr)                        */
	unsigned int src_nr    : BFW_NX10_menc_capture0_config_src_nr;    /* Capture source channel                                            */
	                                                                  /* 0:  encoder/channel 0                                             */
	unsigned int conce     : BFW_NX10_menc_capture0_config_conce;     /* Capture once                                                      */
	                                                                  /* 0:  continuos capture: each event overwrites old capture register */
	unsigned int reserved1 : BFW_NX10_menc_capture0_config_reserved1; /* reserved                                                          */
} NX10_MENC_CAPTURE0_CONFIG_BIT_T;

typedef union {
	unsigned int                    val;
	NX10_MENC_CAPTURE0_CONFIG_BIT_T bf;
} NX10_MENC_CAPTURE0_CONFIG_T;

/* --------------------------------------------------------------------- */
/* Register menc_capture0_val */
/* => Capture unit 0 captured value */
/* => Mode: R */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX10_menc_capture0_val  0x00000014U
#define Adr_NX10_menc_menc_capture0_val 0x10140594U
#define Adr_NX10_menc_capture0_val      0x10140594U

#define MSK_NX10_menc_capture0_val_val 0xffffffffU
#define SRT_NX10_menc_capture0_val_val 0

enum {
	BFW_NX10_menc_capture0_val_val = 32  /* [31:0] */
};

typedef struct NX10_MENC_CAPTURE0_VAL_BIT_Ttag {
	unsigned int val : BFW_NX10_menc_capture0_val_val; /* Captured value */
} NX10_MENC_CAPTURE0_VAL_BIT_T;

typedef union {
	unsigned int                 val;
	NX10_MENC_CAPTURE0_VAL_BIT_T bf;
} NX10_MENC_CAPTURE0_VAL_T;

/* --------------------------------------------------------------------- */
/* Register menc_capture0_ta */
/* => Capture unit 0 Ta: */
/* => Mode: R */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX10_menc_capture0_ta  0x00000018U
#define Adr_NX10_menc_menc_capture0_ta 0x10140598U
#define Adr_NX10_menc_capture0_ta      0x10140598U

#define MSK_NX10_menc_capture0_ta_val 0x000fffffU
#define SRT_NX10_menc_capture0_ta_val 0

enum {
	BFW_NX10_menc_capture0_ta_val       = 20, /* [19:0] */
	BFW_NX10_menc_capture0_ta_reserved1 = 12  /* [31:20] */
};

typedef struct NX10_MENC_CAPTURE0_TA_BIT_Ttag {
	unsigned int val       : BFW_NX10_menc_capture0_ta_val;       /* Actual Ta:                    */
	                                                              /* Only used for debug purposes. */
	unsigned int reserved1 : BFW_NX10_menc_capture0_ta_reserved1; /* reserved                      */
} NX10_MENC_CAPTURE0_TA_BIT_T;

typedef union {
	unsigned int                val;
	NX10_MENC_CAPTURE0_TA_BIT_T bf;
} NX10_MENC_CAPTURE0_TA_T;

/* --------------------------------------------------------------------- */
/* Register menc_capture0_te */
/* => Capture unit 0 Te: */
/* => Mode: R */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX10_menc_capture0_te  0x0000001CU
#define Adr_NX10_menc_menc_capture0_te 0x1014059CU
#define Adr_NX10_menc_capture0_te      0x1014059CU

#define MSK_NX10_menc_capture0_te_val 0x000fffffU
#define SRT_NX10_menc_capture0_te_val 0

enum {
	BFW_NX10_menc_capture0_te_val       = 20, /* [19:0] */
	BFW_NX10_menc_capture0_te_reserved1 = 12  /* [31:20] */
};

typedef struct NX10_MENC_CAPTURE0_TE_BIT_Ttag {
	unsigned int val       : BFW_NX10_menc_capture0_te_val;       /* Actual Te:                    */
	                                                              /* Only used for debug purposes. */
	unsigned int reserved1 : BFW_NX10_menc_capture0_te_reserved1; /* reserved                      */
} NX10_MENC_CAPTURE0_TE_BIT_T;

typedef union {
	unsigned int                val;
	NX10_MENC_CAPTURE0_TE_BIT_T bf;
} NX10_MENC_CAPTURE0_TE_T;

/* --------------------------------------------------------------------- */
/* Register menc_capture1_config */
/* => Capture 0 configuration register: */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX10_menc_capture1_config  0x00000020U
#define Adr_NX10_menc_menc_capture1_config 0x101405A0U
#define Adr_NX10_menc_capture1_config      0x101405A0U
#define DFLT_VAL_NX10_menc_capture1_config 0x00000000U

#define MSK_NX10_menc_capture1_config_inv         0x00000001U
#define SRT_NX10_menc_capture1_config_inv         0
#define DFLT_VAL_NX10_menc_capture1_config_inv    0x00000000U
#define MSK_NX10_menc_capture1_config_sel         0x0000003eU
#define SRT_NX10_menc_capture1_config_sel         1
#define DFLT_VAL_NX10_menc_capture1_config_sel    0x00000000U
#define MSK_NX10_menc_capture1_config_src         0x000001c0U
#define SRT_NX10_menc_capture1_config_src         6
#define DFLT_VAL_NX10_menc_capture1_config_src    0x00000000U
#define MSK_NX10_menc_capture1_config_src_nr      0x00000200U
#define SRT_NX10_menc_capture1_config_src_nr      9
#define DFLT_VAL_NX10_menc_capture1_config_src_nr 0x00000000U
#define MSK_NX10_menc_capture1_config_conce       0x00000400U
#define SRT_NX10_menc_capture1_config_conce       10
#define DFLT_VAL_NX10_menc_capture1_config_conce  0x00000000U

enum {
	BFW_NX10_menc_capture1_config_inv       = 1,  /* [0] */
	BFW_NX10_menc_capture1_config_sel       = 5,  /* [5:1] */
	BFW_NX10_menc_capture1_config_src       = 3,  /* [8:6] */
	BFW_NX10_menc_capture1_config_src_nr    = 1,  /* [9] */
	BFW_NX10_menc_capture1_config_conce     = 1,  /* [10] */
	BFW_NX10_menc_capture1_config_reserved1 = 21  /* [31:11] */
};

typedef struct NX10_MENC_CAPTURE1_CONFIG_BIT_Ttag {
	unsigned int inv       : BFW_NX10_menc_capture1_config_inv;       /* Invert capture start signal                                       */
	                                                                  /* 0:  positive edge                                                 */
	unsigned int sel       : BFW_NX10_menc_capture1_config_sel;       /* Capture start signal                                              */
	                                                                  /* 0 : off (no capture)                                              */
	unsigned int src       : BFW_NX10_menc_capture1_config_src;       /* Capture source (what to capture)                                  */
	                                                                  /* 0:  system time ns (independant of src_nr)                        */
	unsigned int src_nr    : BFW_NX10_menc_capture1_config_src_nr;    /* Capture source channel                                            */
	                                                                  /* 0:  encoder/channel 0                                             */
	unsigned int conce     : BFW_NX10_menc_capture1_config_conce;     /* Capture once                                                      */
	                                                                  /* 0:  continuos capture: each event overwrites old capture register */
	unsigned int reserved1 : BFW_NX10_menc_capture1_config_reserved1; /* reserved                                                          */
} NX10_MENC_CAPTURE1_CONFIG_BIT_T;

typedef union {
	unsigned int                    val;
	NX10_MENC_CAPTURE1_CONFIG_BIT_T bf;
} NX10_MENC_CAPTURE1_CONFIG_T;

/* --------------------------------------------------------------------- */
/* Register menc_capture1_val */
/* => Capture unit 1 captured value */
/* => Mode: R */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX10_menc_capture1_val  0x00000024U
#define Adr_NX10_menc_menc_capture1_val 0x101405A4U
#define Adr_NX10_menc_capture1_val      0x101405A4U

#define MSK_NX10_menc_capture1_val_val 0xffffffffU
#define SRT_NX10_menc_capture1_val_val 0

enum {
	BFW_NX10_menc_capture1_val_val = 32  /* [31:0] */
};

typedef struct NX10_MENC_CAPTURE1_VAL_BIT_Ttag {
	unsigned int val : BFW_NX10_menc_capture1_val_val; /* Captured value */
} NX10_MENC_CAPTURE1_VAL_BIT_T;

typedef union {
	unsigned int                 val;
	NX10_MENC_CAPTURE1_VAL_BIT_T bf;
} NX10_MENC_CAPTURE1_VAL_T;

/* --------------------------------------------------------------------- */
/* Register menc_capture1_ta */
/* => Capture unit 1 Ta: */
/* => Mode: R */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX10_menc_capture1_ta  0x00000028U
#define Adr_NX10_menc_menc_capture1_ta 0x101405A8U
#define Adr_NX10_menc_capture1_ta      0x101405A8U

#define MSK_NX10_menc_capture1_ta_val 0x000fffffU
#define SRT_NX10_menc_capture1_ta_val 0

enum {
	BFW_NX10_menc_capture1_ta_val       = 20, /* [19:0] */
	BFW_NX10_menc_capture1_ta_reserved1 = 12  /* [31:20] */
};

typedef struct NX10_MENC_CAPTURE1_TA_BIT_Ttag {
	unsigned int val       : BFW_NX10_menc_capture1_ta_val;       /* Actual Ta:                    */
	                                                              /* Only used for debug purposes. */
	unsigned int reserved1 : BFW_NX10_menc_capture1_ta_reserved1; /* reserved                      */
} NX10_MENC_CAPTURE1_TA_BIT_T;

typedef union {
	unsigned int                val;
	NX10_MENC_CAPTURE1_TA_BIT_T bf;
} NX10_MENC_CAPTURE1_TA_T;

/* --------------------------------------------------------------------- */
/* Register menc_capture1_te */
/* => Capture unit 1 Te: */
/* => Mode: R */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX10_menc_capture1_te  0x0000002CU
#define Adr_NX10_menc_menc_capture1_te 0x101405ACU
#define Adr_NX10_menc_capture1_te      0x101405ACU

#define MSK_NX10_menc_capture1_te_val 0x000fffffU
#define SRT_NX10_menc_capture1_te_val 0

enum {
	BFW_NX10_menc_capture1_te_val       = 20, /* [19:0] */
	BFW_NX10_menc_capture1_te_reserved1 = 12  /* [31:20] */
};

typedef struct NX10_MENC_CAPTURE1_TE_BIT_Ttag {
	unsigned int val       : BFW_NX10_menc_capture1_te_val;       /* Actual Te:                    */
	                                                              /* Only used for debug purposes. */
	unsigned int reserved1 : BFW_NX10_menc_capture1_te_reserved1; /* reserved                      */
} NX10_MENC_CAPTURE1_TE_BIT_T;

typedef union {
	unsigned int                val;
	NX10_MENC_CAPTURE1_TE_BIT_T bf;
} NX10_MENC_CAPTURE1_TE_T;

/* --------------------------------------------------------------------- */
/* Register menc_capture2_config */
/* => Capture 0 configuration register: */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX10_menc_capture2_config  0x00000030U
#define Adr_NX10_menc_menc_capture2_config 0x101405B0U
#define Adr_NX10_menc_capture2_config      0x101405B0U
#define DFLT_VAL_NX10_menc_capture2_config 0x00000000U

#define MSK_NX10_menc_capture2_config_inv         0x00000001U
#define SRT_NX10_menc_capture2_config_inv         0
#define DFLT_VAL_NX10_menc_capture2_config_inv    0x00000000U
#define MSK_NX10_menc_capture2_config_sel         0x0000003eU
#define SRT_NX10_menc_capture2_config_sel         1
#define DFLT_VAL_NX10_menc_capture2_config_sel    0x00000000U
#define MSK_NX10_menc_capture2_config_src         0x000001c0U
#define SRT_NX10_menc_capture2_config_src         6
#define DFLT_VAL_NX10_menc_capture2_config_src    0x00000000U
#define MSK_NX10_menc_capture2_config_src_nr      0x00000200U
#define SRT_NX10_menc_capture2_config_src_nr      9
#define DFLT_VAL_NX10_menc_capture2_config_src_nr 0x00000000U
#define MSK_NX10_menc_capture2_config_conce       0x00000400U
#define SRT_NX10_menc_capture2_config_conce       10
#define DFLT_VAL_NX10_menc_capture2_config_conce  0x00000000U

enum {
	BFW_NX10_menc_capture2_config_inv       = 1,  /* [0] */
	BFW_NX10_menc_capture2_config_sel       = 5,  /* [5:1] */
	BFW_NX10_menc_capture2_config_src       = 3,  /* [8:6] */
	BFW_NX10_menc_capture2_config_src_nr    = 1,  /* [9] */
	BFW_NX10_menc_capture2_config_conce     = 1,  /* [10] */
	BFW_NX10_menc_capture2_config_reserved1 = 21  /* [31:11] */
};

typedef struct NX10_MENC_CAPTURE2_CONFIG_BIT_Ttag {
	unsigned int inv       : BFW_NX10_menc_capture2_config_inv;       /* Invert capture start signal                                       */
	                                                                  /* 0:  positive edge                                                 */
	unsigned int sel       : BFW_NX10_menc_capture2_config_sel;       /* Capture start signal                                              */
	                                                                  /* 0 : off (no capture)                                              */
	unsigned int src       : BFW_NX10_menc_capture2_config_src;       /* Capture source (what to capture)                                  */
	                                                                  /* 0:  system time ns (independant of src_nr)                        */
	unsigned int src_nr    : BFW_NX10_menc_capture2_config_src_nr;    /* Capture source channel                                            */
	                                                                  /* 0:  encoder/channel 0                                             */
	unsigned int conce     : BFW_NX10_menc_capture2_config_conce;     /* Capture once                                                      */
	                                                                  /* 0:  continuos capture: each event overwrites old capture register */
	unsigned int reserved1 : BFW_NX10_menc_capture2_config_reserved1; /* reserved                                                          */
} NX10_MENC_CAPTURE2_CONFIG_BIT_T;

typedef union {
	unsigned int                    val;
	NX10_MENC_CAPTURE2_CONFIG_BIT_T bf;
} NX10_MENC_CAPTURE2_CONFIG_T;

/* --------------------------------------------------------------------- */
/* Register menc_capture2_val */
/* => Capture unit 2 captured value */
/* => Mode: R */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX10_menc_capture2_val  0x00000034U
#define Adr_NX10_menc_menc_capture2_val 0x101405B4U
#define Adr_NX10_menc_capture2_val      0x101405B4U

#define MSK_NX10_menc_capture2_val_val 0xffffffffU
#define SRT_NX10_menc_capture2_val_val 0

enum {
	BFW_NX10_menc_capture2_val_val = 32  /* [31:0] */
};

typedef struct NX10_MENC_CAPTURE2_VAL_BIT_Ttag {
	unsigned int val : BFW_NX10_menc_capture2_val_val; /* Captured value */
} NX10_MENC_CAPTURE2_VAL_BIT_T;

typedef union {
	unsigned int                 val;
	NX10_MENC_CAPTURE2_VAL_BIT_T bf;
} NX10_MENC_CAPTURE2_VAL_T;

/* --------------------------------------------------------------------- */
/* Register menc_capture2_ta */
/* => Capture unit 2 Ta: */
/* => Mode: R */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX10_menc_capture2_ta  0x00000038U
#define Adr_NX10_menc_menc_capture2_ta 0x101405B8U
#define Adr_NX10_menc_capture2_ta      0x101405B8U

#define MSK_NX10_menc_capture2_ta_val 0x000fffffU
#define SRT_NX10_menc_capture2_ta_val 0

enum {
	BFW_NX10_menc_capture2_ta_val       = 20, /* [19:0] */
	BFW_NX10_menc_capture2_ta_reserved1 = 12  /* [31:20] */
};

typedef struct NX10_MENC_CAPTURE2_TA_BIT_Ttag {
	unsigned int val       : BFW_NX10_menc_capture2_ta_val;       /* Actual Ta:                    */
	                                                              /* Only used for debug purposes. */
	unsigned int reserved1 : BFW_NX10_menc_capture2_ta_reserved1; /* reserved                      */
} NX10_MENC_CAPTURE2_TA_BIT_T;

typedef union {
	unsigned int                val;
	NX10_MENC_CAPTURE2_TA_BIT_T bf;
} NX10_MENC_CAPTURE2_TA_T;

/* --------------------------------------------------------------------- */
/* Register menc_capture2_te */
/* => Capture unit 2 Te: */
/* => Mode: R */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX10_menc_capture2_te  0x0000003CU
#define Adr_NX10_menc_menc_capture2_te 0x101405BCU
#define Adr_NX10_menc_capture2_te      0x101405BCU

#define MSK_NX10_menc_capture2_te_val 0x000fffffU
#define SRT_NX10_menc_capture2_te_val 0

enum {
	BFW_NX10_menc_capture2_te_val       = 20, /* [19:0] */
	BFW_NX10_menc_capture2_te_reserved1 = 12  /* [31:20] */
};

typedef struct NX10_MENC_CAPTURE2_TE_BIT_Ttag {
	unsigned int val       : BFW_NX10_menc_capture2_te_val;       /* Actual Te:                    */
	                                                              /* Only used for debug purposes. */
	unsigned int reserved1 : BFW_NX10_menc_capture2_te_reserved1; /* reserved                      */
} NX10_MENC_CAPTURE2_TE_BIT_T;

typedef union {
	unsigned int                val;
	NX10_MENC_CAPTURE2_TE_BIT_T bf;
} NX10_MENC_CAPTURE2_TE_T;

/* --------------------------------------------------------------------- */
/* Register menc_capture3_config */
/* => Capture 0 configuration register: */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX10_menc_capture3_config  0x00000040U
#define Adr_NX10_menc_menc_capture3_config 0x101405C0U
#define Adr_NX10_menc_capture3_config      0x101405C0U
#define DFLT_VAL_NX10_menc_capture3_config 0x00000000U

#define MSK_NX10_menc_capture3_config_inv         0x00000001U
#define SRT_NX10_menc_capture3_config_inv         0
#define DFLT_VAL_NX10_menc_capture3_config_inv    0x00000000U
#define MSK_NX10_menc_capture3_config_sel         0x0000003eU
#define SRT_NX10_menc_capture3_config_sel         1
#define DFLT_VAL_NX10_menc_capture3_config_sel    0x00000000U
#define MSK_NX10_menc_capture3_config_src         0x000001c0U
#define SRT_NX10_menc_capture3_config_src         6
#define DFLT_VAL_NX10_menc_capture3_config_src    0x00000000U
#define MSK_NX10_menc_capture3_config_src_nr      0x00000200U
#define SRT_NX10_menc_capture3_config_src_nr      9
#define DFLT_VAL_NX10_menc_capture3_config_src_nr 0x00000000U
#define MSK_NX10_menc_capture3_config_conce       0x00000400U
#define SRT_NX10_menc_capture3_config_conce       10
#define DFLT_VAL_NX10_menc_capture3_config_conce  0x00000000U

enum {
	BFW_NX10_menc_capture3_config_inv       = 1,  /* [0] */
	BFW_NX10_menc_capture3_config_sel       = 5,  /* [5:1] */
	BFW_NX10_menc_capture3_config_src       = 3,  /* [8:6] */
	BFW_NX10_menc_capture3_config_src_nr    = 1,  /* [9] */
	BFW_NX10_menc_capture3_config_conce     = 1,  /* [10] */
	BFW_NX10_menc_capture3_config_reserved1 = 21  /* [31:11] */
};

typedef struct NX10_MENC_CAPTURE3_CONFIG_BIT_Ttag {
	unsigned int inv       : BFW_NX10_menc_capture3_config_inv;       /* Invert capture start signal                                       */
	                                                                  /* 0:  positive edge                                                 */
	unsigned int sel       : BFW_NX10_menc_capture3_config_sel;       /* Capture start signal                                              */
	                                                                  /* 0 : off (no capture)                                              */
	unsigned int src       : BFW_NX10_menc_capture3_config_src;       /* Capture source (what to capture)                                  */
	                                                                  /* 0:  system time ns (independant of src_nr)                        */
	unsigned int src_nr    : BFW_NX10_menc_capture3_config_src_nr;    /* Capture source channel                                            */
	                                                                  /* 0:  encoder/channel 0                                             */
	unsigned int conce     : BFW_NX10_menc_capture3_config_conce;     /* Capture once                                                      */
	                                                                  /* 0:  continuos capture: each event overwrites old capture register */
	unsigned int reserved1 : BFW_NX10_menc_capture3_config_reserved1; /* reserved                                                          */
} NX10_MENC_CAPTURE3_CONFIG_BIT_T;

typedef union {
	unsigned int                    val;
	NX10_MENC_CAPTURE3_CONFIG_BIT_T bf;
} NX10_MENC_CAPTURE3_CONFIG_T;

/* --------------------------------------------------------------------- */
/* Register menc_capture3_val */
/* => Capture unit 3 captured value */
/* => Mode: R */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX10_menc_capture3_val  0x00000044U
#define Adr_NX10_menc_menc_capture3_val 0x101405C4U
#define Adr_NX10_menc_capture3_val      0x101405C4U

#define MSK_NX10_menc_capture3_val_val 0xffffffffU
#define SRT_NX10_menc_capture3_val_val 0

enum {
	BFW_NX10_menc_capture3_val_val = 32  /* [31:0] */
};

typedef struct NX10_MENC_CAPTURE3_VAL_BIT_Ttag {
	unsigned int val : BFW_NX10_menc_capture3_val_val; /* Captured value */
} NX10_MENC_CAPTURE3_VAL_BIT_T;

typedef union {
	unsigned int                 val;
	NX10_MENC_CAPTURE3_VAL_BIT_T bf;
} NX10_MENC_CAPTURE3_VAL_T;

/* --------------------------------------------------------------------- */
/* Register menc_capture3_ta */
/* => Capture unit 3 Ta: */
/* => Mode: R */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX10_menc_capture3_ta  0x00000048U
#define Adr_NX10_menc_menc_capture3_ta 0x101405C8U
#define Adr_NX10_menc_capture3_ta      0x101405C8U

#define MSK_NX10_menc_capture3_ta_val 0x000fffffU
#define SRT_NX10_menc_capture3_ta_val 0

enum {
	BFW_NX10_menc_capture3_ta_val       = 20, /* [19:0] */
	BFW_NX10_menc_capture3_ta_reserved1 = 12  /* [31:20] */
};

typedef struct NX10_MENC_CAPTURE3_TA_BIT_Ttag {
	unsigned int val       : BFW_NX10_menc_capture3_ta_val;       /* Actual Ta:                    */
	                                                              /* Only used for debug purposes. */
	unsigned int reserved1 : BFW_NX10_menc_capture3_ta_reserved1; /* reserved                      */
} NX10_MENC_CAPTURE3_TA_BIT_T;

typedef union {
	unsigned int                val;
	NX10_MENC_CAPTURE3_TA_BIT_T bf;
} NX10_MENC_CAPTURE3_TA_T;

/* --------------------------------------------------------------------- */
/* Register menc_capture3_te */
/* => Capture unit 3 Te: */
/* => Mode: R */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX10_menc_capture3_te  0x0000004CU
#define Adr_NX10_menc_menc_capture3_te 0x101405CCU
#define Adr_NX10_menc_capture3_te      0x101405CCU

#define MSK_NX10_menc_capture3_te_val 0x000fffffU
#define SRT_NX10_menc_capture3_te_val 0

enum {
	BFW_NX10_menc_capture3_te_val       = 20, /* [19:0] */
	BFW_NX10_menc_capture3_te_reserved1 = 12  /* [31:20] */
};

typedef struct NX10_MENC_CAPTURE3_TE_BIT_Ttag {
	unsigned int val       : BFW_NX10_menc_capture3_te_val;       /* Actual Te:                    */
	                                                              /* Only used for debug purposes. */
	unsigned int reserved1 : BFW_NX10_menc_capture3_te_reserved1; /* reserved                      */
} NX10_MENC_CAPTURE3_TE_BIT_T;

typedef union {
	unsigned int                val;
	NX10_MENC_CAPTURE3_TE_BIT_T bf;
} NX10_MENC_CAPTURE3_TE_T;

/* --------------------------------------------------------------------- */
/* Register menc_status */
/* => Position and capture status: */
/*    Reset by writing 1 to appropriate bit (except enc?_dir_ro). */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX10_menc_status  0x00000050U
#define Adr_NX10_menc_menc_status 0x101405D0U
#define Adr_NX10_menc_status      0x101405D0U
#define DFLT_VAL_NX10_menc_status 0x00000000U

#define MSK_NX10_menc_status_enc0_edge             0x00000001U
#define SRT_NX10_menc_status_enc0_edge             0
#define DFLT_VAL_NX10_menc_status_enc0_edge        0x00000000U
#define MSK_NX10_menc_status_enc0_ovfl_pos         0x00000002U
#define SRT_NX10_menc_status_enc0_ovfl_pos         1
#define DFLT_VAL_NX10_menc_status_enc0_ovfl_pos    0x00000000U
#define MSK_NX10_menc_status_enc0_ovfl_neg         0x00000004U
#define SRT_NX10_menc_status_enc0_ovfl_neg         2
#define DFLT_VAL_NX10_menc_status_enc0_ovfl_neg    0x00000000U
#define MSK_NX10_menc_status_enc0_phase_error      0x00000008U
#define SRT_NX10_menc_status_enc0_phase_error      3
#define DFLT_VAL_NX10_menc_status_enc0_phase_error 0x00000000U
#define MSK_NX10_menc_status_enc0_n                0x00000010U
#define SRT_NX10_menc_status_enc0_n                4
#define DFLT_VAL_NX10_menc_status_enc0_n           0x00000000U
#define MSK_NX10_menc_status_enc0_dir_ro           0x00000080U
#define SRT_NX10_menc_status_enc0_dir_ro           7
#define DFLT_VAL_NX10_menc_status_enc0_dir_ro      0x00000000U
#define MSK_NX10_menc_status_enc1_edge             0x00000100U
#define SRT_NX10_menc_status_enc1_edge             8
#define DFLT_VAL_NX10_menc_status_enc1_edge        0x00000000U
#define MSK_NX10_menc_status_enc1_ovfl_pos         0x00000200U
#define SRT_NX10_menc_status_enc1_ovfl_pos         9
#define DFLT_VAL_NX10_menc_status_enc1_ovfl_pos    0x00000000U
#define MSK_NX10_menc_status_enc1_ovfl_neg         0x00000400U
#define SRT_NX10_menc_status_enc1_ovfl_neg         10
#define DFLT_VAL_NX10_menc_status_enc1_ovfl_neg    0x00000000U
#define MSK_NX10_menc_status_enc1_phase_error      0x00000800U
#define SRT_NX10_menc_status_enc1_phase_error      11
#define DFLT_VAL_NX10_menc_status_enc1_phase_error 0x00000000U
#define MSK_NX10_menc_status_enc1_n                0x00001000U
#define SRT_NX10_menc_status_enc1_n                12
#define DFLT_VAL_NX10_menc_status_enc1_n           0x00000000U
#define MSK_NX10_menc_status_enc1_dir_ro           0x00008000U
#define SRT_NX10_menc_status_enc1_dir_ro           15
#define DFLT_VAL_NX10_menc_status_enc1_dir_ro      0x00000000U
#define MSK_NX10_menc_status_cap0                  0x00010000U
#define SRT_NX10_menc_status_cap0                  16
#define DFLT_VAL_NX10_menc_status_cap0             0x00000000U
#define MSK_NX10_menc_status_cap1                  0x00020000U
#define SRT_NX10_menc_status_cap1                  17
#define DFLT_VAL_NX10_menc_status_cap1             0x00000000U
#define MSK_NX10_menc_status_cap2                  0x00040000U
#define SRT_NX10_menc_status_cap2                  18
#define DFLT_VAL_NX10_menc_status_cap2             0x00000000U
#define MSK_NX10_menc_status_cap3                  0x00080000U
#define SRT_NX10_menc_status_cap3                  19
#define DFLT_VAL_NX10_menc_status_cap3             0x00000000U
#define MSK_NX10_menc_status_mp0                   0x01000000U
#define SRT_NX10_menc_status_mp0                   24
#define DFLT_VAL_NX10_menc_status_mp0              0x00000000U
#define MSK_NX10_menc_status_mp1                   0x02000000U
#define SRT_NX10_menc_status_mp1                   25
#define DFLT_VAL_NX10_menc_status_mp1              0x00000000U

enum {
	BFW_NX10_menc_status_enc0_edge        = 1, /* [0] */
	BFW_NX10_menc_status_enc0_ovfl_pos    = 1, /* [1] */
	BFW_NX10_menc_status_enc0_ovfl_neg    = 1, /* [2] */
	BFW_NX10_menc_status_enc0_phase_error = 1, /* [3] */
	BFW_NX10_menc_status_enc0_n           = 1, /* [4] */
	BFW_NX10_menc_status_reserved1        = 2, /* [6:5] */
	BFW_NX10_menc_status_enc0_dir_ro      = 1, /* [7] */
	BFW_NX10_menc_status_enc1_edge        = 1, /* [8] */
	BFW_NX10_menc_status_enc1_ovfl_pos    = 1, /* [9] */
	BFW_NX10_menc_status_enc1_ovfl_neg    = 1, /* [10] */
	BFW_NX10_menc_status_enc1_phase_error = 1, /* [11] */
	BFW_NX10_menc_status_enc1_n           = 1, /* [12] */
	BFW_NX10_menc_status_reserved2        = 2, /* [14:13] */
	BFW_NX10_menc_status_enc1_dir_ro      = 1, /* [15] */
	BFW_NX10_menc_status_cap0             = 1, /* [16] */
	BFW_NX10_menc_status_cap1             = 1, /* [17] */
	BFW_NX10_menc_status_cap2             = 1, /* [18] */
	BFW_NX10_menc_status_cap3             = 1, /* [19] */
	BFW_NX10_menc_status_reserved3        = 4, /* [23:20] */
	BFW_NX10_menc_status_mp0              = 1, /* [24] */
	BFW_NX10_menc_status_mp1              = 1, /* [25] */
	BFW_NX10_menc_status_reserved4        = 6  /* [31:26] */
};

typedef struct NX10_MENC_STATUS_BIT_Ttag {
	unsigned int enc0_edge        : BFW_NX10_menc_status_enc0_edge;        /* Edge at Encoder 0 occured (rising or falling of enc0_a or enc0_b)            */
	unsigned int enc0_ovfl_pos    : BFW_NX10_menc_status_enc0_ovfl_pos;    /* Encoder0 overflow positive                                                   */
	unsigned int enc0_ovfl_neg    : BFW_NX10_menc_status_enc0_ovfl_neg;    /* Encoder0 overflow negative                                                   */
	unsigned int enc0_phase_error : BFW_NX10_menc_status_enc0_phase_error; /* Phase error at encoder 0:                                                    */
	                                                                       /* Encoder inputs changed 2 phases in 1 cycle, which leads to unknown position. */
	unsigned int enc0_n           : BFW_NX10_menc_status_enc0_n;           /* Rising edge at input enc0_n.                                                 */
	unsigned int reserved1        : BFW_NX10_menc_status_reserved1;        /* reserved                                                                     */
	unsigned int enc0_dir_ro      : BFW_NX10_menc_status_enc0_dir_ro;      /* Encoder0 direction (read only)                                               */
	unsigned int enc1_edge        : BFW_NX10_menc_status_enc1_edge;        /* Edge at Encoder 1 occured (rising or falling of enc1_a or enc1_b)            */
	unsigned int enc1_ovfl_pos    : BFW_NX10_menc_status_enc1_ovfl_pos;    /* Encoder1 overflow positive                                                   */
	unsigned int enc1_ovfl_neg    : BFW_NX10_menc_status_enc1_ovfl_neg;    /* Encoder1 overflow negative                                                   */
	unsigned int enc1_phase_error : BFW_NX10_menc_status_enc1_phase_error; /* Phase error at encoder 1:                                                    */
	                                                                       /* Encoder inputs changed 2 phases in 1 cycle, which leads to unknown position. */
	unsigned int enc1_n           : BFW_NX10_menc_status_enc1_n;           /* Rising edge at input enc1_n.                                                 */
	unsigned int reserved2        : BFW_NX10_menc_status_reserved2;        /* reserved                                                                     */
	unsigned int enc1_dir_ro      : BFW_NX10_menc_status_enc1_dir_ro;      /* Encoder1 direction (read only)                                               */
	unsigned int cap0             : BFW_NX10_menc_status_cap0;             /* Captured register 0                                                          */
	unsigned int cap1             : BFW_NX10_menc_status_cap1;             /* Captured register 1                                                          */
	unsigned int cap2             : BFW_NX10_menc_status_cap2;             /* Captured register 2                                                          */
	unsigned int cap3             : BFW_NX10_menc_status_cap3;             /* Captured register 3                                                          */
	unsigned int reserved3        : BFW_NX10_menc_status_reserved3;        /* reserved                                                                     */
	unsigned int mp0              : BFW_NX10_menc_status_mp0;              /* Rising edge at Measurement Point 0                                           */
	unsigned int mp1              : BFW_NX10_menc_status_mp1;              /* Rising edge at Measurement Point 1                                           */
	unsigned int reserved4        : BFW_NX10_menc_status_reserved4;        /* reserved                                                                     */
} NX10_MENC_STATUS_BIT_T;

typedef union {
	unsigned int           val;
	NX10_MENC_STATUS_BIT_T bf;
} NX10_MENC_STATUS_T;

/* --------------------------------------------------------------------- */
/* Register menc_irq_masked */
/* => menc Masked IRQ register: */
/*    Shows status of masked IRQs (as connected to ARM/xPIC). */
/* => Mode: R */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX10_menc_irq_masked  0x00000054U
#define Adr_NX10_menc_menc_irq_masked 0x101405D4U
#define Adr_NX10_menc_irq_masked      0x101405D4U

#define MSK_NX10_menc_irq_masked_enc0_edge        0x00000001U
#define SRT_NX10_menc_irq_masked_enc0_edge        0
#define MSK_NX10_menc_irq_masked_enc0_ovfl_pos    0x00000002U
#define SRT_NX10_menc_irq_masked_enc0_ovfl_pos    1
#define MSK_NX10_menc_irq_masked_enc0_ovfl_neg    0x00000004U
#define SRT_NX10_menc_irq_masked_enc0_ovfl_neg    2
#define MSK_NX10_menc_irq_masked_enc0_phase_error 0x00000008U
#define SRT_NX10_menc_irq_masked_enc0_phase_error 3
#define MSK_NX10_menc_irq_masked_enc0_n           0x00000010U
#define SRT_NX10_menc_irq_masked_enc0_n           4
#define MSK_NX10_menc_irq_masked_enc1_edge        0x00000100U
#define SRT_NX10_menc_irq_masked_enc1_edge        8
#define MSK_NX10_menc_irq_masked_enc1_ovfl_pos    0x00000200U
#define SRT_NX10_menc_irq_masked_enc1_ovfl_pos    9
#define MSK_NX10_menc_irq_masked_enc1_ovfl_neg    0x00000400U
#define SRT_NX10_menc_irq_masked_enc1_ovfl_neg    10
#define MSK_NX10_menc_irq_masked_enc1_phase_error 0x00000800U
#define SRT_NX10_menc_irq_masked_enc1_phase_error 11
#define MSK_NX10_menc_irq_masked_enc1_n           0x00001000U
#define SRT_NX10_menc_irq_masked_enc1_n           12
#define MSK_NX10_menc_irq_masked_cap0             0x00010000U
#define SRT_NX10_menc_irq_masked_cap0             16
#define MSK_NX10_menc_irq_masked_cap1             0x00020000U
#define SRT_NX10_menc_irq_masked_cap1             17
#define MSK_NX10_menc_irq_masked_cap2             0x00040000U
#define SRT_NX10_menc_irq_masked_cap2             18
#define MSK_NX10_menc_irq_masked_cap3             0x00080000U
#define SRT_NX10_menc_irq_masked_cap3             19
#define MSK_NX10_menc_irq_masked_mp0              0x01000000U
#define SRT_NX10_menc_irq_masked_mp0              24
#define MSK_NX10_menc_irq_masked_mp1              0x02000000U
#define SRT_NX10_menc_irq_masked_mp1              25

enum {
	BFW_NX10_menc_irq_masked_enc0_edge        = 1, /* [0] */
	BFW_NX10_menc_irq_masked_enc0_ovfl_pos    = 1, /* [1] */
	BFW_NX10_menc_irq_masked_enc0_ovfl_neg    = 1, /* [2] */
	BFW_NX10_menc_irq_masked_enc0_phase_error = 1, /* [3] */
	BFW_NX10_menc_irq_masked_enc0_n           = 1, /* [4] */
	BFW_NX10_menc_irq_masked_reserved1        = 3, /* [7:5] */
	BFW_NX10_menc_irq_masked_enc1_edge        = 1, /* [8] */
	BFW_NX10_menc_irq_masked_enc1_ovfl_pos    = 1, /* [9] */
	BFW_NX10_menc_irq_masked_enc1_ovfl_neg    = 1, /* [10] */
	BFW_NX10_menc_irq_masked_enc1_phase_error = 1, /* [11] */
	BFW_NX10_menc_irq_masked_enc1_n           = 1, /* [12] */
	BFW_NX10_menc_irq_masked_reserved2        = 3, /* [15:13] */
	BFW_NX10_menc_irq_masked_cap0             = 1, /* [16] */
	BFW_NX10_menc_irq_masked_cap1             = 1, /* [17] */
	BFW_NX10_menc_irq_masked_cap2             = 1, /* [18] */
	BFW_NX10_menc_irq_masked_cap3             = 1, /* [19] */
	BFW_NX10_menc_irq_masked_reserved3        = 4, /* [23:20] */
	BFW_NX10_menc_irq_masked_mp0              = 1, /* [24] */
	BFW_NX10_menc_irq_masked_mp1              = 1, /* [25] */
	BFW_NX10_menc_irq_masked_reserved4        = 6  /* [31:26] */
};

typedef struct NX10_MENC_IRQ_MASKED_BIT_Ttag {
	unsigned int enc0_edge        : BFW_NX10_menc_irq_masked_enc0_edge;        /* Edge at Encoder 0 occured (rising or falling of enc0_a or enc0_b)            */
	unsigned int enc0_ovfl_pos    : BFW_NX10_menc_irq_masked_enc0_ovfl_pos;    /* Encoder0 overflow positive                                                   */
	unsigned int enc0_ovfl_neg    : BFW_NX10_menc_irq_masked_enc0_ovfl_neg;    /* Encoder0 overflow negative                                                   */
	unsigned int enc0_phase_error : BFW_NX10_menc_irq_masked_enc0_phase_error; /* Phase error at encoder 0:                                                    */
	                                                                           /* Encoder inputs changed 2 phases in 1 cycle, which leads to unknown position. */
	unsigned int enc0_n           : BFW_NX10_menc_irq_masked_enc0_n;           /* Rising edge at input enc0_n.                                                 */
	unsigned int reserved1        : BFW_NX10_menc_irq_masked_reserved1;        /* reserved                                                                     */
	unsigned int enc1_edge        : BFW_NX10_menc_irq_masked_enc1_edge;        /* Edge at Encoder 1 occured (rising or falling of enc1_a or enc1_b)            */
	unsigned int enc1_ovfl_pos    : BFW_NX10_menc_irq_masked_enc1_ovfl_pos;    /* Encoder1 overflow positive                                                   */
	unsigned int enc1_ovfl_neg    : BFW_NX10_menc_irq_masked_enc1_ovfl_neg;    /* Encoder1 overflow negative                                                   */
	unsigned int enc1_phase_error : BFW_NX10_menc_irq_masked_enc1_phase_error; /* Phase error at encoder 1:                                                    */
	                                                                           /* Encoder inputs changed 2 phases in 1 cycle, which leads to unknown position. */
	unsigned int enc1_n           : BFW_NX10_menc_irq_masked_enc1_n;           /* Rising edge at input enc1_n.                                                 */
	unsigned int reserved2        : BFW_NX10_menc_irq_masked_reserved2;        /* reserved                                                                     */
	unsigned int cap0             : BFW_NX10_menc_irq_masked_cap0;             /* Captured register 0                                                          */
	unsigned int cap1             : BFW_NX10_menc_irq_masked_cap1;             /* Captured register 1                                                          */
	unsigned int cap2             : BFW_NX10_menc_irq_masked_cap2;             /* Captured register 2                                                          */
	unsigned int cap3             : BFW_NX10_menc_irq_masked_cap3;             /* Captured register 3                                                          */
	unsigned int reserved3        : BFW_NX10_menc_irq_masked_reserved3;        /* reserved                                                                     */
	unsigned int mp0              : BFW_NX10_menc_irq_masked_mp0;              /* Rising edge at Measurement Point 0                                           */
	unsigned int mp1              : BFW_NX10_menc_irq_masked_mp1;              /* Rising edge at Measurement Point 1                                           */
	unsigned int reserved4        : BFW_NX10_menc_irq_masked_reserved4;        /* reserved                                                                     */
} NX10_MENC_IRQ_MASKED_BIT_T;

typedef union {
	unsigned int               val;
	NX10_MENC_IRQ_MASKED_BIT_T bf;
} NX10_MENC_IRQ_MASKED_T;

/* --------------------------------------------------------------------- */
/* Register menc_irq_msk_set */
/* => menc interrupt mask enable: */
/*    Write access with '1' sets interrupt mask bit (enables interrupt request for corresponding interrupt source). */
/*    Write access with '0' does not influence this bit. */
/*    Read access shows actual interrupt mask */
/*    Attention: Before activating interrupt mask, delete old pending interrupts by writing the same value to adr_menc_irq_raw */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX10_menc_irq_msk_set  0x00000058U
#define Adr_NX10_menc_menc_irq_msk_set 0x101405D8U
#define Adr_NX10_menc_irq_msk_set      0x101405D8U
#define DFLT_VAL_NX10_menc_irq_msk_set 0x00000000U

#define MSK_NX10_menc_irq_msk_set_enc0_edge             0x00000001U
#define SRT_NX10_menc_irq_msk_set_enc0_edge             0
#define DFLT_VAL_NX10_menc_irq_msk_set_enc0_edge        0x00000000U
#define MSK_NX10_menc_irq_msk_set_enc0_ovfl_pos         0x00000002U
#define SRT_NX10_menc_irq_msk_set_enc0_ovfl_pos         1
#define DFLT_VAL_NX10_menc_irq_msk_set_enc0_ovfl_pos    0x00000000U
#define MSK_NX10_menc_irq_msk_set_enc0_ovfl_neg         0x00000004U
#define SRT_NX10_menc_irq_msk_set_enc0_ovfl_neg         2
#define DFLT_VAL_NX10_menc_irq_msk_set_enc0_ovfl_neg    0x00000000U
#define MSK_NX10_menc_irq_msk_set_enc0_phase_error      0x00000008U
#define SRT_NX10_menc_irq_msk_set_enc0_phase_error      3
#define DFLT_VAL_NX10_menc_irq_msk_set_enc0_phase_error 0x00000000U
#define MSK_NX10_menc_irq_msk_set_enc0_n                0x00000010U
#define SRT_NX10_menc_irq_msk_set_enc0_n                4
#define DFLT_VAL_NX10_menc_irq_msk_set_enc0_n           0x00000000U
#define MSK_NX10_menc_irq_msk_set_enc1_edge             0x00000100U
#define SRT_NX10_menc_irq_msk_set_enc1_edge             8
#define DFLT_VAL_NX10_menc_irq_msk_set_enc1_edge        0x00000000U
#define MSK_NX10_menc_irq_msk_set_enc1_ovfl_pos         0x00000200U
#define SRT_NX10_menc_irq_msk_set_enc1_ovfl_pos         9
#define DFLT_VAL_NX10_menc_irq_msk_set_enc1_ovfl_pos    0x00000000U
#define MSK_NX10_menc_irq_msk_set_enc1_ovfl_neg         0x00000400U
#define SRT_NX10_menc_irq_msk_set_enc1_ovfl_neg         10
#define DFLT_VAL_NX10_menc_irq_msk_set_enc1_ovfl_neg    0x00000000U
#define MSK_NX10_menc_irq_msk_set_enc1_phase_error      0x00000800U
#define SRT_NX10_menc_irq_msk_set_enc1_phase_error      11
#define DFLT_VAL_NX10_menc_irq_msk_set_enc1_phase_error 0x00000000U
#define MSK_NX10_menc_irq_msk_set_enc1_n                0x00001000U
#define SRT_NX10_menc_irq_msk_set_enc1_n                12
#define DFLT_VAL_NX10_menc_irq_msk_set_enc1_n           0x00000000U
#define MSK_NX10_menc_irq_msk_set_cap0                  0x00010000U
#define SRT_NX10_menc_irq_msk_set_cap0                  16
#define DFLT_VAL_NX10_menc_irq_msk_set_cap0             0x00000000U
#define MSK_NX10_menc_irq_msk_set_cap1                  0x00020000U
#define SRT_NX10_menc_irq_msk_set_cap1                  17
#define DFLT_VAL_NX10_menc_irq_msk_set_cap1             0x00000000U
#define MSK_NX10_menc_irq_msk_set_cap2                  0x00040000U
#define SRT_NX10_menc_irq_msk_set_cap2                  18
#define DFLT_VAL_NX10_menc_irq_msk_set_cap2             0x00000000U
#define MSK_NX10_menc_irq_msk_set_cap3                  0x00080000U
#define SRT_NX10_menc_irq_msk_set_cap3                  19
#define DFLT_VAL_NX10_menc_irq_msk_set_cap3             0x00000000U
#define MSK_NX10_menc_irq_msk_set_mp0                   0x01000000U
#define SRT_NX10_menc_irq_msk_set_mp0                   24
#define DFLT_VAL_NX10_menc_irq_msk_set_mp0              0x00000000U
#define MSK_NX10_menc_irq_msk_set_mp1                   0x02000000U
#define SRT_NX10_menc_irq_msk_set_mp1                   25
#define DFLT_VAL_NX10_menc_irq_msk_set_mp1              0x00000000U

enum {
	BFW_NX10_menc_irq_msk_set_enc0_edge        = 1, /* [0] */
	BFW_NX10_menc_irq_msk_set_enc0_ovfl_pos    = 1, /* [1] */
	BFW_NX10_menc_irq_msk_set_enc0_ovfl_neg    = 1, /* [2] */
	BFW_NX10_menc_irq_msk_set_enc0_phase_error = 1, /* [3] */
	BFW_NX10_menc_irq_msk_set_enc0_n           = 1, /* [4] */
	BFW_NX10_menc_irq_msk_set_reserved1        = 3, /* [7:5] */
	BFW_NX10_menc_irq_msk_set_enc1_edge        = 1, /* [8] */
	BFW_NX10_menc_irq_msk_set_enc1_ovfl_pos    = 1, /* [9] */
	BFW_NX10_menc_irq_msk_set_enc1_ovfl_neg    = 1, /* [10] */
	BFW_NX10_menc_irq_msk_set_enc1_phase_error = 1, /* [11] */
	BFW_NX10_menc_irq_msk_set_enc1_n           = 1, /* [12] */
	BFW_NX10_menc_irq_msk_set_reserved2        = 3, /* [15:13] */
	BFW_NX10_menc_irq_msk_set_cap0             = 1, /* [16] */
	BFW_NX10_menc_irq_msk_set_cap1             = 1, /* [17] */
	BFW_NX10_menc_irq_msk_set_cap2             = 1, /* [18] */
	BFW_NX10_menc_irq_msk_set_cap3             = 1, /* [19] */
	BFW_NX10_menc_irq_msk_set_reserved3        = 4, /* [23:20] */
	BFW_NX10_menc_irq_msk_set_mp0              = 1, /* [24] */
	BFW_NX10_menc_irq_msk_set_mp1              = 1, /* [25] */
	BFW_NX10_menc_irq_msk_set_reserved4        = 6  /* [31:26] */
};

typedef struct NX10_MENC_IRQ_MSK_SET_BIT_Ttag {
	unsigned int enc0_edge        : BFW_NX10_menc_irq_msk_set_enc0_edge;        /* Edge at Encoder 0 occured (rising or falling of enc0_a or enc0_b)            */
	unsigned int enc0_ovfl_pos    : BFW_NX10_menc_irq_msk_set_enc0_ovfl_pos;    /* Encoder0 overflow positive                                                   */
	unsigned int enc0_ovfl_neg    : BFW_NX10_menc_irq_msk_set_enc0_ovfl_neg;    /* Encoder0 overflow negative                                                   */
	unsigned int enc0_phase_error : BFW_NX10_menc_irq_msk_set_enc0_phase_error; /* Phase error at encoder 0:                                                    */
	                                                                            /* Encoder inputs changed 2 phases in 1 cycle, which leads to unknown position. */
	unsigned int enc0_n           : BFW_NX10_menc_irq_msk_set_enc0_n;           /* Rising edge at input enc0_n.                                                 */
	unsigned int reserved1        : BFW_NX10_menc_irq_msk_set_reserved1;        /* reserved                                                                     */
	unsigned int enc1_edge        : BFW_NX10_menc_irq_msk_set_enc1_edge;        /* Edge at Encoder 1 occured (rising or falling of enc1_a or enc1_b)            */
	unsigned int enc1_ovfl_pos    : BFW_NX10_menc_irq_msk_set_enc1_ovfl_pos;    /* Encoder1 overflow positive                                                   */
	unsigned int enc1_ovfl_neg    : BFW_NX10_menc_irq_msk_set_enc1_ovfl_neg;    /* Encoder1 overflow negative                                                   */
	unsigned int enc1_phase_error : BFW_NX10_menc_irq_msk_set_enc1_phase_error; /* Phase error at encoder 1:                                                    */
	                                                                            /* Encoder inputs changed 2 phases in 1 cycle, which leads to unknown position. */
	unsigned int enc1_n           : BFW_NX10_menc_irq_msk_set_enc1_n;           /* Rising edge at input enc1_n.                                                 */
	unsigned int reserved2        : BFW_NX10_menc_irq_msk_set_reserved2;        /* reserved                                                                     */
	unsigned int cap0             : BFW_NX10_menc_irq_msk_set_cap0;             /* Captured register 0                                                          */
	unsigned int cap1             : BFW_NX10_menc_irq_msk_set_cap1;             /* Captured register 1                                                          */
	unsigned int cap2             : BFW_NX10_menc_irq_msk_set_cap2;             /* Captured register 2                                                          */
	unsigned int cap3             : BFW_NX10_menc_irq_msk_set_cap3;             /* Captured register 3                                                          */
	unsigned int reserved3        : BFW_NX10_menc_irq_msk_set_reserved3;        /* reserved                                                                     */
	unsigned int mp0              : BFW_NX10_menc_irq_msk_set_mp0;              /* Rising edge at Measurement Point 0                                           */
	unsigned int mp1              : BFW_NX10_menc_irq_msk_set_mp1;              /* Rising edge at Measurement Point 1                                           */
	unsigned int reserved4        : BFW_NX10_menc_irq_msk_set_reserved4;        /* reserved                                                                     */
} NX10_MENC_IRQ_MSK_SET_BIT_T;

typedef union {
	unsigned int                val;
	NX10_MENC_IRQ_MSK_SET_BIT_T bf;
} NX10_MENC_IRQ_MSK_SET_T;

/* --------------------------------------------------------------------- */
/* Register menc_irq_msk_reset */
/* => menc interrupt mask disable: */
/*    Write access with '1' resets interrupt mask bit (disables interrupt request for corresponding interrupt source). */
/*    Write access with '0' does not influence this bit. */
/*    Read access shows actual interrupt mask */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX10_menc_irq_msk_reset  0x0000005CU
#define Adr_NX10_menc_menc_irq_msk_reset 0x101405DCU
#define Adr_NX10_menc_irq_msk_reset      0x101405DCU
#define DFLT_VAL_NX10_menc_irq_msk_reset 0x00000000U

#define MSK_NX10_menc_irq_msk_reset_enc0_edge             0x00000001U
#define SRT_NX10_menc_irq_msk_reset_enc0_edge             0
#define DFLT_VAL_NX10_menc_irq_msk_reset_enc0_edge        0x00000000U
#define MSK_NX10_menc_irq_msk_reset_enc0_ovfl_pos         0x00000002U
#define SRT_NX10_menc_irq_msk_reset_enc0_ovfl_pos         1
#define DFLT_VAL_NX10_menc_irq_msk_reset_enc0_ovfl_pos    0x00000000U
#define MSK_NX10_menc_irq_msk_reset_enc0_ovfl_neg         0x00000004U
#define SRT_NX10_menc_irq_msk_reset_enc0_ovfl_neg         2
#define DFLT_VAL_NX10_menc_irq_msk_reset_enc0_ovfl_neg    0x00000000U
#define MSK_NX10_menc_irq_msk_reset_enc0_phase_error      0x00000008U
#define SRT_NX10_menc_irq_msk_reset_enc0_phase_error      3
#define DFLT_VAL_NX10_menc_irq_msk_reset_enc0_phase_error 0x00000000U
#define MSK_NX10_menc_irq_msk_reset_enc0_n                0x00000010U
#define SRT_NX10_menc_irq_msk_reset_enc0_n                4
#define DFLT_VAL_NX10_menc_irq_msk_reset_enc0_n           0x00000000U
#define MSK_NX10_menc_irq_msk_reset_enc1_edge             0x00000100U
#define SRT_NX10_menc_irq_msk_reset_enc1_edge             8
#define DFLT_VAL_NX10_menc_irq_msk_reset_enc1_edge        0x00000000U
#define MSK_NX10_menc_irq_msk_reset_enc1_ovfl_pos         0x00000200U
#define SRT_NX10_menc_irq_msk_reset_enc1_ovfl_pos         9
#define DFLT_VAL_NX10_menc_irq_msk_reset_enc1_ovfl_pos    0x00000000U
#define MSK_NX10_menc_irq_msk_reset_enc1_ovfl_neg         0x00000400U
#define SRT_NX10_menc_irq_msk_reset_enc1_ovfl_neg         10
#define DFLT_VAL_NX10_menc_irq_msk_reset_enc1_ovfl_neg    0x00000000U
#define MSK_NX10_menc_irq_msk_reset_enc1_phase_error      0x00000800U
#define SRT_NX10_menc_irq_msk_reset_enc1_phase_error      11
#define DFLT_VAL_NX10_menc_irq_msk_reset_enc1_phase_error 0x00000000U
#define MSK_NX10_menc_irq_msk_reset_enc1_n                0x00001000U
#define SRT_NX10_menc_irq_msk_reset_enc1_n                12
#define DFLT_VAL_NX10_menc_irq_msk_reset_enc1_n           0x00000000U
#define MSK_NX10_menc_irq_msk_reset_cap0                  0x00010000U
#define SRT_NX10_menc_irq_msk_reset_cap0                  16
#define DFLT_VAL_NX10_menc_irq_msk_reset_cap0             0x00000000U
#define MSK_NX10_menc_irq_msk_reset_cap1                  0x00020000U
#define SRT_NX10_menc_irq_msk_reset_cap1                  17
#define DFLT_VAL_NX10_menc_irq_msk_reset_cap1             0x00000000U
#define MSK_NX10_menc_irq_msk_reset_cap2                  0x00040000U
#define SRT_NX10_menc_irq_msk_reset_cap2                  18
#define DFLT_VAL_NX10_menc_irq_msk_reset_cap2             0x00000000U
#define MSK_NX10_menc_irq_msk_reset_cap3                  0x00080000U
#define SRT_NX10_menc_irq_msk_reset_cap3                  19
#define DFLT_VAL_NX10_menc_irq_msk_reset_cap3             0x00000000U
#define MSK_NX10_menc_irq_msk_reset_mp0                   0x01000000U
#define SRT_NX10_menc_irq_msk_reset_mp0                   24
#define DFLT_VAL_NX10_menc_irq_msk_reset_mp0              0x00000000U
#define MSK_NX10_menc_irq_msk_reset_mp1                   0x02000000U
#define SRT_NX10_menc_irq_msk_reset_mp1                   25
#define DFLT_VAL_NX10_menc_irq_msk_reset_mp1              0x00000000U

enum {
	BFW_NX10_menc_irq_msk_reset_enc0_edge        = 1, /* [0] */
	BFW_NX10_menc_irq_msk_reset_enc0_ovfl_pos    = 1, /* [1] */
	BFW_NX10_menc_irq_msk_reset_enc0_ovfl_neg    = 1, /* [2] */
	BFW_NX10_menc_irq_msk_reset_enc0_phase_error = 1, /* [3] */
	BFW_NX10_menc_irq_msk_reset_enc0_n           = 1, /* [4] */
	BFW_NX10_menc_irq_msk_reset_reserved1        = 3, /* [7:5] */
	BFW_NX10_menc_irq_msk_reset_enc1_edge        = 1, /* [8] */
	BFW_NX10_menc_irq_msk_reset_enc1_ovfl_pos    = 1, /* [9] */
	BFW_NX10_menc_irq_msk_reset_enc1_ovfl_neg    = 1, /* [10] */
	BFW_NX10_menc_irq_msk_reset_enc1_phase_error = 1, /* [11] */
	BFW_NX10_menc_irq_msk_reset_enc1_n           = 1, /* [12] */
	BFW_NX10_menc_irq_msk_reset_reserved2        = 3, /* [15:13] */
	BFW_NX10_menc_irq_msk_reset_cap0             = 1, /* [16] */
	BFW_NX10_menc_irq_msk_reset_cap1             = 1, /* [17] */
	BFW_NX10_menc_irq_msk_reset_cap2             = 1, /* [18] */
	BFW_NX10_menc_irq_msk_reset_cap3             = 1, /* [19] */
	BFW_NX10_menc_irq_msk_reset_reserved3        = 4, /* [23:20] */
	BFW_NX10_menc_irq_msk_reset_mp0              = 1, /* [24] */
	BFW_NX10_menc_irq_msk_reset_mp1              = 1, /* [25] */
	BFW_NX10_menc_irq_msk_reset_reserved4        = 6  /* [31:26] */
};

typedef struct NX10_MENC_IRQ_MSK_RESET_BIT_Ttag {
	unsigned int enc0_edge        : BFW_NX10_menc_irq_msk_reset_enc0_edge;        /* Edge at Encoder 0 occured (rising or falling of enc0_a or enc0_b)            */
	unsigned int enc0_ovfl_pos    : BFW_NX10_menc_irq_msk_reset_enc0_ovfl_pos;    /* Encoder0 overflow positive                                                   */
	unsigned int enc0_ovfl_neg    : BFW_NX10_menc_irq_msk_reset_enc0_ovfl_neg;    /* Encoder0 overflow negative                                                   */
	unsigned int enc0_phase_error : BFW_NX10_menc_irq_msk_reset_enc0_phase_error; /* Phase error at encoder 0:                                                    */
	                                                                              /* Encoder inputs changed 2 phases in 1 cycle, which leads to unknown position. */
	unsigned int enc0_n           : BFW_NX10_menc_irq_msk_reset_enc0_n;           /* Rising edge at input enc0_n.                                                 */
	unsigned int reserved1        : BFW_NX10_menc_irq_msk_reset_reserved1;        /* reserved                                                                     */
	unsigned int enc1_edge        : BFW_NX10_menc_irq_msk_reset_enc1_edge;        /* Edge at Encoder 1 occured (rising or falling of enc1_a or enc1_b)            */
	unsigned int enc1_ovfl_pos    : BFW_NX10_menc_irq_msk_reset_enc1_ovfl_pos;    /* Encoder1 overflow positive                                                   */
	unsigned int enc1_ovfl_neg    : BFW_NX10_menc_irq_msk_reset_enc1_ovfl_neg;    /* Encoder1 overflow negative                                                   */
	unsigned int enc1_phase_error : BFW_NX10_menc_irq_msk_reset_enc1_phase_error; /* Phase error at encoder 1:                                                    */
	                                                                              /* Encoder inputs changed 2 phases in 1 cycle, which leads to unknown position. */
	unsigned int enc1_n           : BFW_NX10_menc_irq_msk_reset_enc1_n;           /* Rising edge at input enc1_n.                                                 */
	unsigned int reserved2        : BFW_NX10_menc_irq_msk_reset_reserved2;        /* reserved                                                                     */
	unsigned int cap0             : BFW_NX10_menc_irq_msk_reset_cap0;             /* Captured register 0                                                          */
	unsigned int cap1             : BFW_NX10_menc_irq_msk_reset_cap1;             /* Captured register 1                                                          */
	unsigned int cap2             : BFW_NX10_menc_irq_msk_reset_cap2;             /* Captured register 2                                                          */
	unsigned int cap3             : BFW_NX10_menc_irq_msk_reset_cap3;             /* Captured register 3                                                          */
	unsigned int reserved3        : BFW_NX10_menc_irq_msk_reset_reserved3;        /* reserved                                                                     */
	unsigned int mp0              : BFW_NX10_menc_irq_msk_reset_mp0;              /* Rising edge at Measurement Point 0                                           */
	unsigned int mp1              : BFW_NX10_menc_irq_msk_reset_mp1;              /* Rising edge at Measurement Point 1                                           */
	unsigned int reserved4        : BFW_NX10_menc_irq_msk_reset_reserved4;        /* reserved                                                                     */
} NX10_MENC_IRQ_MSK_RESET_BIT_T;

typedef union {
	unsigned int                  val;
	NX10_MENC_IRQ_MSK_RESET_BIT_T bf;
} NX10_MENC_IRQ_MSK_RESET_T;


/* ===================================================================== */

/* Area of io_link */

/* ===================================================================== */

#define Addr_NX10_io_link 0x10140600U

/* ===================================================================== */

/* AREA xlink */
/* Area of xlink0, xlink1, xlink2, xlink3 */

/* ===================================================================== */

#define Addr_NX10_xlink0 0x10140600U
#define Addr_NX10_xlink1 0x10140610U
#define Addr_NX10_xlink2 0x10140620U
#define Addr_NX10_xlink3 0x10140630U

/* --------------------------------------------------------------------- */
/* Register xlink_cfg */
/* => configuration register */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX10_xlink_cfg    0x00000000U
#define Adr_NX10_xlink0_xlink_cfg 0x10140600U
#define Adr_NX10_xlink1_xlink_cfg 0x10140610U
#define Adr_NX10_xlink2_xlink_cfg 0x10140620U
#define Adr_NX10_xlink3_xlink_cfg 0x10140630U
#define DFLT_VAL_NX10_xlink_cfg   0xb4a0001bU

#define MSK_NX10_xlink_cfg_rate_inc        0x0000ffffU
#define SRT_NX10_xlink_cfg_rate_inc        0
#define DFLT_VAL_NX10_xlink_cfg_rate_inc   0x0000001bU
#define MSK_NX10_xlink_cfg_xlink_en        0x00010000U
#define SRT_NX10_xlink_cfg_xlink_en        16
#define DFLT_VAL_NX10_xlink_cfg_xlink_en   0x00000000U
#define MSK_NX10_xlink_cfg_fb_en           0x00020000U
#define SRT_NX10_xlink_cfg_fb_en           17
#define DFLT_VAL_NX10_xlink_cfg_fb_en      0x00000000U
#define MSK_NX10_xlink_cfg_bclk2oe_en      0x00040000U
#define SRT_NX10_xlink_cfg_bclk2oe_en      18
#define DFLT_VAL_NX10_xlink_cfg_bclk2oe_en 0x00000000U
#define MSK_NX10_xlink_cfg_cnt_da          0x00080000U
#define SRT_NX10_xlink_cfg_cnt_da          19
#define DFLT_VAL_NX10_xlink_cfg_cnt_da     0x00000000U
#define MSK_NX10_xlink_cfg_bits2rec        0x00f00000U
#define SRT_NX10_xlink_cfg_bits2rec        20
#define DFLT_VAL_NX10_xlink_cfg_bits2rec   0x00a00000U
#define MSK_NX10_xlink_cfg_start_spl       0x0f000000U
#define SRT_NX10_xlink_cfg_start_spl       24
#define DFLT_VAL_NX10_xlink_cfg_start_spl  0x04000000U
#define MSK_NX10_xlink_cfg_end_spl         0xf0000000U
#define SRT_NX10_xlink_cfg_end_spl         28
#define DFLT_VAL_NX10_xlink_cfg_end_spl    0xb0000000U

enum {
	BFW_NX10_xlink_cfg_rate_inc   = 16, /* [15:0] */
	BFW_NX10_xlink_cfg_xlink_en   = 1,  /* [16] */
	BFW_NX10_xlink_cfg_fb_en      = 1,  /* [17] */
	BFW_NX10_xlink_cfg_bclk2oe_en = 1,  /* [18] */
	BFW_NX10_xlink_cfg_cnt_da     = 1,  /* [19] */
	BFW_NX10_xlink_cfg_bits2rec   = 4,  /* [23:20] */
	BFW_NX10_xlink_cfg_start_spl  = 4,  /* [27:24] */
	BFW_NX10_xlink_cfg_end_spl    = 4   /* [31:28] */
};

typedef struct NX10_XLINK_CFG_BIT_Ttag {
	unsigned int rate_inc   : BFW_NX10_xlink_cfg_rate_inc;   /* bitrate compare value                                                      */
	                                                         /* for bit clock counter (bit_cnt)                                            */
	unsigned int xlink_en   : BFW_NX10_xlink_cfg_xlink_en;   /* disable the output enable, and activity                                    */
	unsigned int fb_en      : BFW_NX10_xlink_cfg_fb_en;      /* test feature, enable internal feedback                                     */
	unsigned int bclk2oe_en : BFW_NX10_xlink_cfg_bclk2oe_en; /* test feature, do not set this bit!                                         */
	unsigned int cnt_da     : BFW_NX10_xlink_cfg_cnt_da;     /* test feature, do not set this bit!                                         */
	unsigned int bits2rec   : BFW_NX10_xlink_cfg_bits2rec;   /* count of bits to receive                                                   */
	                                                         /* note: the reset value expect: 1stopbit, 8databits, 1paritybit and 1stopbit */
	unsigned int start_spl  : BFW_NX10_xlink_cfg_start_spl;  /* start sample point for receive data                                        */
	                                                         /* a sample period is defined as 1/16 of the bitrate period                   */
	unsigned int end_spl    : BFW_NX10_xlink_cfg_end_spl;    /* end sample point  for receive data                                         */
} NX10_XLINK_CFG_BIT_T;

typedef union {
	unsigned int         val;
	NX10_XLINK_CFG_BIT_T bf;
} NX10_XLINK_CFG_T;

/* --------------------------------------------------------------------- */
/* Register xlink_tx */
/* => xlink transmit register */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX10_xlink_tx    0x00000004U
#define Adr_NX10_xlink0_xlink_tx 0x10140604U
#define Adr_NX10_xlink1_xlink_tx 0x10140614U
#define Adr_NX10_xlink2_xlink_tx 0x10140624U
#define Adr_NX10_xlink3_xlink_tx 0x10140634U
#define DFLT_VAL_NX10_xlink_tx   0x00030000U

#define MSK_NX10_xlink_tx_hold         0x0000ffffU
#define SRT_NX10_xlink_tx_hold         0
#define DFLT_VAL_NX10_xlink_tx_hold    0x00000000U
#define MSK_NX10_xlink_tx_rdy_ro       0x00010000U
#define SRT_NX10_xlink_tx_rdy_ro       16
#define DFLT_VAL_NX10_xlink_tx_rdy_ro  0x00010000U
#define MSK_NX10_xlink_tx_idle_ro      0x00020000U
#define SRT_NX10_xlink_tx_idle_ro      17
#define DFLT_VAL_NX10_xlink_tx_idle_ro 0x00020000U

enum {
	BFW_NX10_xlink_tx_hold      = 16, /* [15:0] */
	BFW_NX10_xlink_tx_rdy_ro    = 1,  /* [16] */
	BFW_NX10_xlink_tx_idle_ro   = 1,  /* [17] */
	BFW_NX10_xlink_tx_reserved1 = 14  /* [31:18] */
};

typedef struct NX10_XLINK_TX_BIT_Ttag {
	unsigned int hold      : BFW_NX10_xlink_tx_hold;      /* hold register                              */
	                                                      /*   format for a valid serial DATA sequence: */
	unsigned int rdy_ro    : BFW_NX10_xlink_tx_rdy_ro;    /* TX buffer ready (valid on ready)           */
	                                                      /*  0 TX buffer not ready                     */
	unsigned int idle_ro   : BFW_NX10_xlink_tx_idle_ro;   /* indicates no activity on tx                */
	unsigned int reserved1 : BFW_NX10_xlink_tx_reserved1; /* reserved                                   */
} NX10_XLINK_TX_BIT_T;

typedef union {
	unsigned int        val;
	NX10_XLINK_TX_BIT_T bf;
} NX10_XLINK_TX_T;

/* --------------------------------------------------------------------- */
/* Register xlink_rx */
/* => xlink RX register */
/*    writing to the register, reset the ready bit, the overflow bit and the sampling error bit */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX10_xlink_rx    0x00000008U
#define Adr_NX10_xlink0_xlink_rx 0x10140608U
#define Adr_NX10_xlink1_xlink_rx 0x10140618U
#define Adr_NX10_xlink2_xlink_rx 0x10140628U
#define Adr_NX10_xlink3_xlink_rx 0x10140638U
#define DFLT_VAL_NX10_xlink_rx   0x0000ffffU

#define MSK_NX10_xlink_rx_hold_ro         0x0000ffffU
#define SRT_NX10_xlink_rx_hold_ro         0
#define DFLT_VAL_NX10_xlink_rx_hold_ro    0x0000ffffU
#define MSK_NX10_xlink_rx_rdy_ro          0x00010000U
#define SRT_NX10_xlink_rx_rdy_ro          16
#define DFLT_VAL_NX10_xlink_rx_rdy_ro     0x00000000U
#define MSK_NX10_xlink_rx_rxd_ro          0x00080000U
#define SRT_NX10_xlink_rx_rxd_ro          19
#define DFLT_VAL_NX10_xlink_rx_rxd_ro     0x00000000U
#define MSK_NX10_xlink_rx_ovf_err_ro      0x00100000U
#define SRT_NX10_xlink_rx_ovf_err_ro      20
#define DFLT_VAL_NX10_xlink_rx_ovf_err_ro 0x00000000U
#define MSK_NX10_xlink_rx_spl_err_ro      0x00200000U
#define SRT_NX10_xlink_rx_spl_err_ro      21
#define DFLT_VAL_NX10_xlink_rx_spl_err_ro 0x00000000U

enum {
	BFW_NX10_xlink_rx_hold_ro    = 16, /* [15:0] */
	BFW_NX10_xlink_rx_rdy_ro     = 1,  /* [16] */
	BFW_NX10_xlink_rx_reserved1  = 2,  /* [18:17] */
	BFW_NX10_xlink_rx_rxd_ro     = 1,  /* [19] */
	BFW_NX10_xlink_rx_ovf_err_ro = 1,  /* [20] */
	BFW_NX10_xlink_rx_spl_err_ro = 1,  /* [21] */
	BFW_NX10_xlink_rx_reserved2  = 10  /* [31:22] */
};

typedef struct NX10_XLINK_RX_BIT_Ttag {
	unsigned int hold_ro    : BFW_NX10_xlink_rx_hold_ro;    /* RX byte (when valid)                            */
	                                                        /*   hold[15:0] is used to shift in RX(LSB first!) */
	unsigned int rdy_ro     : BFW_NX10_xlink_rx_rdy_ro;     /* RX buffer ready (valid on ready)                */
	                                                        /*  0 RX buffer not ready                          */
	unsigned int reserved1  : BFW_NX10_xlink_rx_reserved1;  /* reserved                                        */
	unsigned int rxd_ro     : BFW_NX10_xlink_rx_rxd_ro;     /* current status of rx data                       */
	unsigned int ovf_err_ro : BFW_NX10_xlink_rx_ovf_err_ro; /* overflow error on received data                 */
	unsigned int spl_err_ro : BFW_NX10_xlink_rx_spl_err_ro; /* sampling error detected                         */
	                                                        /* if the amount of sampled bits (HI or LOW)       */
	unsigned int reserved2  : BFW_NX10_xlink_rx_reserved2;  /* reserved                                        */
} NX10_XLINK_RX_BIT_T;

typedef union {
	unsigned int        val;
	NX10_XLINK_RX_BIT_T bf;
} NX10_XLINK_RX_T;

/* --------------------------------------------------------------------- */
/* Register xlink_stat */
/* => xlink status register */
/*    writing to this register set the bit clock counter to zero! */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX10_xlink_stat    0x0000000CU
#define Adr_NX10_xlink0_xlink_stat 0x1014060CU
#define Adr_NX10_xlink1_xlink_stat 0x1014061CU
#define Adr_NX10_xlink2_xlink_stat 0x1014062CU
#define Adr_NX10_xlink3_xlink_stat 0x1014063CU
#define DFLT_VAL_NX10_xlink_stat   0x00000000U

#define MSK_NX10_xlink_stat_bit_cnt_ro       0x0000ffffU
#define SRT_NX10_xlink_stat_bit_cnt_ro       0
#define DFLT_VAL_NX10_xlink_stat_bit_cnt_ro  0x00000000U
#define MSK_NX10_xlink_stat_bit_clk_ro       0x00010000U
#define SRT_NX10_xlink_stat_bit_clk_ro       16
#define DFLT_VAL_NX10_xlink_stat_bit_clk_ro  0x00000000U
#define MSK_NX10_xlink_stat_txo_ro           0x00020000U
#define SRT_NX10_xlink_stat_txo_ro           17
#define DFLT_VAL_NX10_xlink_stat_txo_ro      0x00000000U
#define MSK_NX10_xlink_stat_rxo_ro           0x00040000U
#define SRT_NX10_xlink_stat_rxo_ro           18
#define DFLT_VAL_NX10_xlink_stat_rxo_ro      0x00000000U
#define MSK_NX10_xlink_stat_txoe_ro          0x00080000U
#define SRT_NX10_xlink_stat_txoe_ro          19
#define DFLT_VAL_NX10_xlink_stat_txoe_ro     0x00000000U
#define MSK_NX10_xlink_stat_fsm_ro           0x00300000U
#define SRT_NX10_xlink_stat_fsm_ro           20
#define DFLT_VAL_NX10_xlink_stat_fsm_ro      0x00000000U
#define MSK_NX10_xlink_stat_bits_sh_ro       0x03c00000U
#define SRT_NX10_xlink_stat_bits_sh_ro       22
#define DFLT_VAL_NX10_xlink_stat_bits_sh_ro  0x00000000U
#define MSK_NX10_xlink_stat_hilo_cnt_ro      0x7c000000U
#define SRT_NX10_xlink_stat_hilo_cnt_ro      26
#define DFLT_VAL_NX10_xlink_stat_hilo_cnt_ro 0x00000000U

enum {
	BFW_NX10_xlink_stat_bit_cnt_ro  = 16, /* [15:0] */
	BFW_NX10_xlink_stat_bit_clk_ro  = 1,  /* [16] */
	BFW_NX10_xlink_stat_txo_ro      = 1,  /* [17] */
	BFW_NX10_xlink_stat_rxo_ro      = 1,  /* [18] */
	BFW_NX10_xlink_stat_txoe_ro     = 1,  /* [19] */
	BFW_NX10_xlink_stat_fsm_ro      = 2,  /* [21:20] */
	BFW_NX10_xlink_stat_bits_sh_ro  = 4,  /* [25:22] */
	BFW_NX10_xlink_stat_hilo_cnt_ro = 5,  /* [30:26] */
	BFW_NX10_xlink_stat_reserved1   = 1   /* [31] */
};

typedef struct NX10_XLINK_STAT_BIT_Ttag {
	unsigned int bit_cnt_ro  : BFW_NX10_xlink_stat_bit_cnt_ro;  /* status of bit clock counter */
	unsigned int bit_clk_ro  : BFW_NX10_xlink_stat_bit_clk_ro;  /* status of bit clock signal  */
	unsigned int txo_ro      : BFW_NX10_xlink_stat_txo_ro;      /* status of tx output         */
	unsigned int rxo_ro      : BFW_NX10_xlink_stat_rxo_ro;      /* status of rx input          */
	unsigned int txoe_ro     : BFW_NX10_xlink_stat_txoe_ro;     /* status of tx output enable  */
	unsigned int fsm_ro      : BFW_NX10_xlink_stat_fsm_ro;      /* debug status                */
	unsigned int bits_sh_ro  : BFW_NX10_xlink_stat_bits_sh_ro;  /* debug status                */
	unsigned int hilo_cnt_ro : BFW_NX10_xlink_stat_hilo_cnt_ro; /* debug status                */
	unsigned int reserved1   : BFW_NX10_xlink_stat_reserved1;   /* reserved                    */
} NX10_XLINK_STAT_BIT_T;

typedef union {
	unsigned int          val;
	NX10_XLINK_STAT_BIT_T bf;
} NX10_XLINK_STAT_T;


/* ===================================================================== */

/* Area of io_link_irq */

/* ===================================================================== */

#define Addr_NX10_io_link_irq 0x10140640U

/* --------------------------------------------------------------------- */
/* Register io_link_irq_raw */
/* => IO-Link raw interrupts: */
/*    Shows status of raw IRQs (not masked). */
/*    Reset IRQ by writing 1 to appropriate bit. */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX10_io_link_irq_raw         0x00000000U
#define Adr_NX10_io_link_irq_io_link_irq_raw 0x10140640U
#define Adr_NX10_io_link_irq_raw             0x10140640U
#define DFLT_VAL_NX10_io_link_irq_raw        0x00000000U

#define MSK_NX10_io_link_irq_raw_xlink0_tx_next       0x00000001U
#define SRT_NX10_io_link_irq_raw_xlink0_tx_next       0
#define DFLT_VAL_NX10_io_link_irq_raw_xlink0_tx_next  0x00000000U
#define MSK_NX10_io_link_irq_raw_xlink0_rx_next       0x00000002U
#define SRT_NX10_io_link_irq_raw_xlink0_rx_next       1
#define DFLT_VAL_NX10_io_link_irq_raw_xlink0_rx_next  0x00000000U
#define MSK_NX10_io_link_irq_raw_xlink0_shift_en      0x00000004U
#define SRT_NX10_io_link_irq_raw_xlink0_shift_en      2
#define DFLT_VAL_NX10_io_link_irq_raw_xlink0_shift_en 0x00000000U
#define MSK_NX10_io_link_irq_raw_xlink1_tx_next       0x00000010U
#define SRT_NX10_io_link_irq_raw_xlink1_tx_next       4
#define DFLT_VAL_NX10_io_link_irq_raw_xlink1_tx_next  0x00000000U
#define MSK_NX10_io_link_irq_raw_xlink1_rx_next       0x00000020U
#define SRT_NX10_io_link_irq_raw_xlink1_rx_next       5
#define DFLT_VAL_NX10_io_link_irq_raw_xlink1_rx_next  0x00000000U
#define MSK_NX10_io_link_irq_raw_xlink1_shift_en      0x00000040U
#define SRT_NX10_io_link_irq_raw_xlink1_shift_en      6
#define DFLT_VAL_NX10_io_link_irq_raw_xlink1_shift_en 0x00000000U
#define MSK_NX10_io_link_irq_raw_xlink2_tx_next       0x00000100U
#define SRT_NX10_io_link_irq_raw_xlink2_tx_next       8
#define DFLT_VAL_NX10_io_link_irq_raw_xlink2_tx_next  0x00000000U
#define MSK_NX10_io_link_irq_raw_xlink2_rx_next       0x00000200U
#define SRT_NX10_io_link_irq_raw_xlink2_rx_next       9
#define DFLT_VAL_NX10_io_link_irq_raw_xlink2_rx_next  0x00000000U
#define MSK_NX10_io_link_irq_raw_xlink2_shift_en      0x00000400U
#define SRT_NX10_io_link_irq_raw_xlink2_shift_en      10
#define DFLT_VAL_NX10_io_link_irq_raw_xlink2_shift_en 0x00000000U
#define MSK_NX10_io_link_irq_raw_xlink3_tx_next       0x00001000U
#define SRT_NX10_io_link_irq_raw_xlink3_tx_next       12
#define DFLT_VAL_NX10_io_link_irq_raw_xlink3_tx_next  0x00000000U
#define MSK_NX10_io_link_irq_raw_xlink3_rx_next       0x00002000U
#define SRT_NX10_io_link_irq_raw_xlink3_rx_next       13
#define DFLT_VAL_NX10_io_link_irq_raw_xlink3_rx_next  0x00000000U
#define MSK_NX10_io_link_irq_raw_xlink3_shift_en      0x00004000U
#define SRT_NX10_io_link_irq_raw_xlink3_shift_en      14
#define DFLT_VAL_NX10_io_link_irq_raw_xlink3_shift_en 0x00000000U

enum {
	BFW_NX10_io_link_irq_raw_xlink0_tx_next  = 1,  /* [0] */
	BFW_NX10_io_link_irq_raw_xlink0_rx_next  = 1,  /* [1] */
	BFW_NX10_io_link_irq_raw_xlink0_shift_en = 1,  /* [2] */
	BFW_NX10_io_link_irq_raw_reserved1       = 1,  /* [3] */
	BFW_NX10_io_link_irq_raw_xlink1_tx_next  = 1,  /* [4] */
	BFW_NX10_io_link_irq_raw_xlink1_rx_next  = 1,  /* [5] */
	BFW_NX10_io_link_irq_raw_xlink1_shift_en = 1,  /* [6] */
	BFW_NX10_io_link_irq_raw_reserved2       = 1,  /* [7] */
	BFW_NX10_io_link_irq_raw_xlink2_tx_next  = 1,  /* [8] */
	BFW_NX10_io_link_irq_raw_xlink2_rx_next  = 1,  /* [9] */
	BFW_NX10_io_link_irq_raw_xlink2_shift_en = 1,  /* [10] */
	BFW_NX10_io_link_irq_raw_reserved3       = 1,  /* [11] */
	BFW_NX10_io_link_irq_raw_xlink3_tx_next  = 1,  /* [12] */
	BFW_NX10_io_link_irq_raw_xlink3_rx_next  = 1,  /* [13] */
	BFW_NX10_io_link_irq_raw_xlink3_shift_en = 1,  /* [14] */
	BFW_NX10_io_link_irq_raw_reserved4       = 17  /* [31:15] */
};

typedef struct NX10_IO_LINK_IRQ_RAW_BIT_Ttag {
	unsigned int xlink0_tx_next  : BFW_NX10_io_link_irq_raw_xlink0_tx_next;  /* tx_next interrupt  */
	unsigned int xlink0_rx_next  : BFW_NX10_io_link_irq_raw_xlink0_rx_next;  /* rx_next interrupt  */
	unsigned int xlink0_shift_en : BFW_NX10_io_link_irq_raw_xlink0_shift_en; /* shift_en interrupt */
	unsigned int reserved1       : BFW_NX10_io_link_irq_raw_reserved1;       /* reserved           */
	unsigned int xlink1_tx_next  : BFW_NX10_io_link_irq_raw_xlink1_tx_next;  /* tx_next interrupt  */
	unsigned int xlink1_rx_next  : BFW_NX10_io_link_irq_raw_xlink1_rx_next;  /* rx_next interrupt  */
	unsigned int xlink1_shift_en : BFW_NX10_io_link_irq_raw_xlink1_shift_en; /* shift_en interrupt */
	unsigned int reserved2       : BFW_NX10_io_link_irq_raw_reserved2;       /* reserved           */
	unsigned int xlink2_tx_next  : BFW_NX10_io_link_irq_raw_xlink2_tx_next;  /* tx_next interrupt  */
	unsigned int xlink2_rx_next  : BFW_NX10_io_link_irq_raw_xlink2_rx_next;  /* rx_next interrupt  */
	unsigned int xlink2_shift_en : BFW_NX10_io_link_irq_raw_xlink2_shift_en; /* shift_en interrupt */
	unsigned int reserved3       : BFW_NX10_io_link_irq_raw_reserved3;       /* reserved           */
	unsigned int xlink3_tx_next  : BFW_NX10_io_link_irq_raw_xlink3_tx_next;  /* tx_next interrupt  */
	unsigned int xlink3_rx_next  : BFW_NX10_io_link_irq_raw_xlink3_rx_next;  /* rx_next interrupt  */
	unsigned int xlink3_shift_en : BFW_NX10_io_link_irq_raw_xlink3_shift_en; /* shift_en interrupt */
	unsigned int reserved4       : BFW_NX10_io_link_irq_raw_reserved4;       /* reserved           */
} NX10_IO_LINK_IRQ_RAW_BIT_T;

typedef union {
	unsigned int               val;
	NX10_IO_LINK_IRQ_RAW_BIT_T bf;
} NX10_IO_LINK_IRQ_RAW_T;

/* --------------------------------------------------------------------- */
/* Register io_link_irq_masked */
/* => IO-Link Masked IRQ register */
/*    Shows status of masked IRQs (as connected to ARM/xPIC) */
/* => Mode: R */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX10_io_link_irq_masked         0x00000004U
#define Adr_NX10_io_link_irq_io_link_irq_masked 0x10140644U
#define Adr_NX10_io_link_irq_masked             0x10140644U

#define MSK_NX10_io_link_irq_masked_xlink0_tx_next  0x00000001U
#define SRT_NX10_io_link_irq_masked_xlink0_tx_next  0
#define MSK_NX10_io_link_irq_masked_xlink0_rx_next  0x00000002U
#define SRT_NX10_io_link_irq_masked_xlink0_rx_next  1
#define MSK_NX10_io_link_irq_masked_xlink0_shift_en 0x00000004U
#define SRT_NX10_io_link_irq_masked_xlink0_shift_en 2
#define MSK_NX10_io_link_irq_masked_xlink1_tx_next  0x00000010U
#define SRT_NX10_io_link_irq_masked_xlink1_tx_next  4
#define MSK_NX10_io_link_irq_masked_xlink1_rx_next  0x00000020U
#define SRT_NX10_io_link_irq_masked_xlink1_rx_next  5
#define MSK_NX10_io_link_irq_masked_xlink1_shift_en 0x00000040U
#define SRT_NX10_io_link_irq_masked_xlink1_shift_en 6
#define MSK_NX10_io_link_irq_masked_xlink2_tx_next  0x00000100U
#define SRT_NX10_io_link_irq_masked_xlink2_tx_next  8
#define MSK_NX10_io_link_irq_masked_xlink2_rx_next  0x00000200U
#define SRT_NX10_io_link_irq_masked_xlink2_rx_next  9
#define MSK_NX10_io_link_irq_masked_xlink2_shift_en 0x00000400U
#define SRT_NX10_io_link_irq_masked_xlink2_shift_en 10
#define MSK_NX10_io_link_irq_masked_xlink3_tx_next  0x00001000U
#define SRT_NX10_io_link_irq_masked_xlink3_tx_next  12
#define MSK_NX10_io_link_irq_masked_xlink3_rx_next  0x00002000U
#define SRT_NX10_io_link_irq_masked_xlink3_rx_next  13
#define MSK_NX10_io_link_irq_masked_xlink3_shift_en 0x00004000U
#define SRT_NX10_io_link_irq_masked_xlink3_shift_en 14

enum {
	BFW_NX10_io_link_irq_masked_xlink0_tx_next  = 1,  /* [0] */
	BFW_NX10_io_link_irq_masked_xlink0_rx_next  = 1,  /* [1] */
	BFW_NX10_io_link_irq_masked_xlink0_shift_en = 1,  /* [2] */
	BFW_NX10_io_link_irq_masked_reserved1       = 1,  /* [3] */
	BFW_NX10_io_link_irq_masked_xlink1_tx_next  = 1,  /* [4] */
	BFW_NX10_io_link_irq_masked_xlink1_rx_next  = 1,  /* [5] */
	BFW_NX10_io_link_irq_masked_xlink1_shift_en = 1,  /* [6] */
	BFW_NX10_io_link_irq_masked_reserved2       = 1,  /* [7] */
	BFW_NX10_io_link_irq_masked_xlink2_tx_next  = 1,  /* [8] */
	BFW_NX10_io_link_irq_masked_xlink2_rx_next  = 1,  /* [9] */
	BFW_NX10_io_link_irq_masked_xlink2_shift_en = 1,  /* [10] */
	BFW_NX10_io_link_irq_masked_reserved3       = 1,  /* [11] */
	BFW_NX10_io_link_irq_masked_xlink3_tx_next  = 1,  /* [12] */
	BFW_NX10_io_link_irq_masked_xlink3_rx_next  = 1,  /* [13] */
	BFW_NX10_io_link_irq_masked_xlink3_shift_en = 1,  /* [14] */
	BFW_NX10_io_link_irq_masked_reserved4       = 17  /* [31:15] */
};

typedef struct NX10_IO_LINK_IRQ_MASKED_BIT_Ttag {
	unsigned int xlink0_tx_next  : BFW_NX10_io_link_irq_masked_xlink0_tx_next;  /* tx_next interrupt  */
	unsigned int xlink0_rx_next  : BFW_NX10_io_link_irq_masked_xlink0_rx_next;  /* rx_next interrupt  */
	unsigned int xlink0_shift_en : BFW_NX10_io_link_irq_masked_xlink0_shift_en; /* shift_en interrupt */
	unsigned int reserved1       : BFW_NX10_io_link_irq_masked_reserved1;       /* reserved           */
	unsigned int xlink1_tx_next  : BFW_NX10_io_link_irq_masked_xlink1_tx_next;  /* tx_next interrupt  */
	unsigned int xlink1_rx_next  : BFW_NX10_io_link_irq_masked_xlink1_rx_next;  /* rx_next interrupt  */
	unsigned int xlink1_shift_en : BFW_NX10_io_link_irq_masked_xlink1_shift_en; /* shift_en interrupt */
	unsigned int reserved2       : BFW_NX10_io_link_irq_masked_reserved2;       /* reserved           */
	unsigned int xlink2_tx_next  : BFW_NX10_io_link_irq_masked_xlink2_tx_next;  /* tx_next interrupt  */
	unsigned int xlink2_rx_next  : BFW_NX10_io_link_irq_masked_xlink2_rx_next;  /* rx_next interrupt  */
	unsigned int xlink2_shift_en : BFW_NX10_io_link_irq_masked_xlink2_shift_en; /* shift_en interrupt */
	unsigned int reserved3       : BFW_NX10_io_link_irq_masked_reserved3;       /* reserved           */
	unsigned int xlink3_tx_next  : BFW_NX10_io_link_irq_masked_xlink3_tx_next;  /* tx_next interrupt  */
	unsigned int xlink3_rx_next  : BFW_NX10_io_link_irq_masked_xlink3_rx_next;  /* rx_next interrupt  */
	unsigned int xlink3_shift_en : BFW_NX10_io_link_irq_masked_xlink3_shift_en; /* shift_en interrupt */
	unsigned int reserved4       : BFW_NX10_io_link_irq_masked_reserved4;       /* reserved           */
} NX10_IO_LINK_IRQ_MASKED_BIT_T;

typedef union {
	unsigned int                  val;
	NX10_IO_LINK_IRQ_MASKED_BIT_T bf;
} NX10_IO_LINK_IRQ_MASKED_T;

/* --------------------------------------------------------------------- */
/* Register io_link_irq_msk_set */
/* => IO-Link interrupt mask enable: */
/*    Write access with '1' sets interrupt mask bit (enables interrupt request for corresponding interrupt source) */
/*    Write access with '0' does not influence this bit */
/*    Read access shows actual interrupt mask */
/*    Attention: Before activating interrupt mask, delete old pending interrupts by writing the same value to adr_io_link_irq_raw */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX10_io_link_irq_msk_set         0x00000008U
#define Adr_NX10_io_link_irq_io_link_irq_msk_set 0x10140648U
#define Adr_NX10_io_link_irq_msk_set             0x10140648U
#define DFLT_VAL_NX10_io_link_irq_msk_set        0x00000000U

#define MSK_NX10_io_link_irq_msk_set_xlink0_tx_next       0x00000001U
#define SRT_NX10_io_link_irq_msk_set_xlink0_tx_next       0
#define DFLT_VAL_NX10_io_link_irq_msk_set_xlink0_tx_next  0x00000000U
#define MSK_NX10_io_link_irq_msk_set_xlink0_rx_next       0x00000002U
#define SRT_NX10_io_link_irq_msk_set_xlink0_rx_next       1
#define DFLT_VAL_NX10_io_link_irq_msk_set_xlink0_rx_next  0x00000000U
#define MSK_NX10_io_link_irq_msk_set_xlink0_shift_en      0x00000004U
#define SRT_NX10_io_link_irq_msk_set_xlink0_shift_en      2
#define DFLT_VAL_NX10_io_link_irq_msk_set_xlink0_shift_en 0x00000000U
#define MSK_NX10_io_link_irq_msk_set_xlink1_tx_next       0x00000010U
#define SRT_NX10_io_link_irq_msk_set_xlink1_tx_next       4
#define DFLT_VAL_NX10_io_link_irq_msk_set_xlink1_tx_next  0x00000000U
#define MSK_NX10_io_link_irq_msk_set_xlink1_rx_next       0x00000020U
#define SRT_NX10_io_link_irq_msk_set_xlink1_rx_next       5
#define DFLT_VAL_NX10_io_link_irq_msk_set_xlink1_rx_next  0x00000000U
#define MSK_NX10_io_link_irq_msk_set_xlink1_shift_en      0x00000040U
#define SRT_NX10_io_link_irq_msk_set_xlink1_shift_en      6
#define DFLT_VAL_NX10_io_link_irq_msk_set_xlink1_shift_en 0x00000000U
#define MSK_NX10_io_link_irq_msk_set_xlink2_tx_next       0x00000100U
#define SRT_NX10_io_link_irq_msk_set_xlink2_tx_next       8
#define DFLT_VAL_NX10_io_link_irq_msk_set_xlink2_tx_next  0x00000000U
#define MSK_NX10_io_link_irq_msk_set_xlink2_rx_next       0x00000200U
#define SRT_NX10_io_link_irq_msk_set_xlink2_rx_next       9
#define DFLT_VAL_NX10_io_link_irq_msk_set_xlink2_rx_next  0x00000000U
#define MSK_NX10_io_link_irq_msk_set_xlink2_shift_en      0x00000400U
#define SRT_NX10_io_link_irq_msk_set_xlink2_shift_en      10
#define DFLT_VAL_NX10_io_link_irq_msk_set_xlink2_shift_en 0x00000000U
#define MSK_NX10_io_link_irq_msk_set_xlink3_tx_next       0x00001000U
#define SRT_NX10_io_link_irq_msk_set_xlink3_tx_next       12
#define DFLT_VAL_NX10_io_link_irq_msk_set_xlink3_tx_next  0x00000000U
#define MSK_NX10_io_link_irq_msk_set_xlink3_rx_next       0x00002000U
#define SRT_NX10_io_link_irq_msk_set_xlink3_rx_next       13
#define DFLT_VAL_NX10_io_link_irq_msk_set_xlink3_rx_next  0x00000000U
#define MSK_NX10_io_link_irq_msk_set_xlink3_shift_en      0x00004000U
#define SRT_NX10_io_link_irq_msk_set_xlink3_shift_en      14
#define DFLT_VAL_NX10_io_link_irq_msk_set_xlink3_shift_en 0x00000000U

enum {
	BFW_NX10_io_link_irq_msk_set_xlink0_tx_next  = 1,  /* [0] */
	BFW_NX10_io_link_irq_msk_set_xlink0_rx_next  = 1,  /* [1] */
	BFW_NX10_io_link_irq_msk_set_xlink0_shift_en = 1,  /* [2] */
	BFW_NX10_io_link_irq_msk_set_reserved1       = 1,  /* [3] */
	BFW_NX10_io_link_irq_msk_set_xlink1_tx_next  = 1,  /* [4] */
	BFW_NX10_io_link_irq_msk_set_xlink1_rx_next  = 1,  /* [5] */
	BFW_NX10_io_link_irq_msk_set_xlink1_shift_en = 1,  /* [6] */
	BFW_NX10_io_link_irq_msk_set_reserved2       = 1,  /* [7] */
	BFW_NX10_io_link_irq_msk_set_xlink2_tx_next  = 1,  /* [8] */
	BFW_NX10_io_link_irq_msk_set_xlink2_rx_next  = 1,  /* [9] */
	BFW_NX10_io_link_irq_msk_set_xlink2_shift_en = 1,  /* [10] */
	BFW_NX10_io_link_irq_msk_set_reserved3       = 1,  /* [11] */
	BFW_NX10_io_link_irq_msk_set_xlink3_tx_next  = 1,  /* [12] */
	BFW_NX10_io_link_irq_msk_set_xlink3_rx_next  = 1,  /* [13] */
	BFW_NX10_io_link_irq_msk_set_xlink3_shift_en = 1,  /* [14] */
	BFW_NX10_io_link_irq_msk_set_reserved4       = 17  /* [31:15] */
};

typedef struct NX10_IO_LINK_IRQ_MSK_SET_BIT_Ttag {
	unsigned int xlink0_tx_next  : BFW_NX10_io_link_irq_msk_set_xlink0_tx_next;  /* tx_next interrupt  */
	unsigned int xlink0_rx_next  : BFW_NX10_io_link_irq_msk_set_xlink0_rx_next;  /* rx_next interrupt  */
	unsigned int xlink0_shift_en : BFW_NX10_io_link_irq_msk_set_xlink0_shift_en; /* shift_en interrupt */
	unsigned int reserved1       : BFW_NX10_io_link_irq_msk_set_reserved1;       /* reserved           */
	unsigned int xlink1_tx_next  : BFW_NX10_io_link_irq_msk_set_xlink1_tx_next;  /* tx_next interrupt  */
	unsigned int xlink1_rx_next  : BFW_NX10_io_link_irq_msk_set_xlink1_rx_next;  /* rx_next interrupt  */
	unsigned int xlink1_shift_en : BFW_NX10_io_link_irq_msk_set_xlink1_shift_en; /* shift_en interrupt */
	unsigned int reserved2       : BFW_NX10_io_link_irq_msk_set_reserved2;       /* reserved           */
	unsigned int xlink2_tx_next  : BFW_NX10_io_link_irq_msk_set_xlink2_tx_next;  /* tx_next interrupt  */
	unsigned int xlink2_rx_next  : BFW_NX10_io_link_irq_msk_set_xlink2_rx_next;  /* rx_next interrupt  */
	unsigned int xlink2_shift_en : BFW_NX10_io_link_irq_msk_set_xlink2_shift_en; /* shift_en interrupt */
	unsigned int reserved3       : BFW_NX10_io_link_irq_msk_set_reserved3;       /* reserved           */
	unsigned int xlink3_tx_next  : BFW_NX10_io_link_irq_msk_set_xlink3_tx_next;  /* tx_next interrupt  */
	unsigned int xlink3_rx_next  : BFW_NX10_io_link_irq_msk_set_xlink3_rx_next;  /* rx_next interrupt  */
	unsigned int xlink3_shift_en : BFW_NX10_io_link_irq_msk_set_xlink3_shift_en; /* shift_en interrupt */
	unsigned int reserved4       : BFW_NX10_io_link_irq_msk_set_reserved4;       /* reserved           */
} NX10_IO_LINK_IRQ_MSK_SET_BIT_T;

typedef union {
	unsigned int                   val;
	NX10_IO_LINK_IRQ_MSK_SET_BIT_T bf;
} NX10_IO_LINK_IRQ_MSK_SET_T;

/* --------------------------------------------------------------------- */
/* Register io_link_irq_msk_reset */
/* => IO-Link interrupt mask disable: */
/*    Write access with '1' resets interrupt mask bit (disables interrupt request for corresponding interrupt source) */
/*    Write access with '0' does not influence this bit */
/*    Read access shows actual interrupt mask */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX10_io_link_irq_msk_reset         0x0000000CU
#define Adr_NX10_io_link_irq_io_link_irq_msk_reset 0x1014064CU
#define Adr_NX10_io_link_irq_msk_reset             0x1014064CU
#define DFLT_VAL_NX10_io_link_irq_msk_reset        0x00000000U

#define MSK_NX10_io_link_irq_msk_reset_xlink0_tx_next       0x00000001U
#define SRT_NX10_io_link_irq_msk_reset_xlink0_tx_next       0
#define DFLT_VAL_NX10_io_link_irq_msk_reset_xlink0_tx_next  0x00000000U
#define MSK_NX10_io_link_irq_msk_reset_xlink0_rx_next       0x00000002U
#define SRT_NX10_io_link_irq_msk_reset_xlink0_rx_next       1
#define DFLT_VAL_NX10_io_link_irq_msk_reset_xlink0_rx_next  0x00000000U
#define MSK_NX10_io_link_irq_msk_reset_xlink0_shift_en      0x00000004U
#define SRT_NX10_io_link_irq_msk_reset_xlink0_shift_en      2
#define DFLT_VAL_NX10_io_link_irq_msk_reset_xlink0_shift_en 0x00000000U
#define MSK_NX10_io_link_irq_msk_reset_xlink1_tx_next       0x00000010U
#define SRT_NX10_io_link_irq_msk_reset_xlink1_tx_next       4
#define DFLT_VAL_NX10_io_link_irq_msk_reset_xlink1_tx_next  0x00000000U
#define MSK_NX10_io_link_irq_msk_reset_xlink1_rx_next       0x00000020U
#define SRT_NX10_io_link_irq_msk_reset_xlink1_rx_next       5
#define DFLT_VAL_NX10_io_link_irq_msk_reset_xlink1_rx_next  0x00000000U
#define MSK_NX10_io_link_irq_msk_reset_xlink1_shift_en      0x00000040U
#define SRT_NX10_io_link_irq_msk_reset_xlink1_shift_en      6
#define DFLT_VAL_NX10_io_link_irq_msk_reset_xlink1_shift_en 0x00000000U
#define MSK_NX10_io_link_irq_msk_reset_xlink2_tx_next       0x00000100U
#define SRT_NX10_io_link_irq_msk_reset_xlink2_tx_next       8
#define DFLT_VAL_NX10_io_link_irq_msk_reset_xlink2_tx_next  0x00000000U
#define MSK_NX10_io_link_irq_msk_reset_xlink2_rx_next       0x00000200U
#define SRT_NX10_io_link_irq_msk_reset_xlink2_rx_next       9
#define DFLT_VAL_NX10_io_link_irq_msk_reset_xlink2_rx_next  0x00000000U
#define MSK_NX10_io_link_irq_msk_reset_xlink2_shift_en      0x00000400U
#define SRT_NX10_io_link_irq_msk_reset_xlink2_shift_en      10
#define DFLT_VAL_NX10_io_link_irq_msk_reset_xlink2_shift_en 0x00000000U
#define MSK_NX10_io_link_irq_msk_reset_xlink3_tx_next       0x00001000U
#define SRT_NX10_io_link_irq_msk_reset_xlink3_tx_next       12
#define DFLT_VAL_NX10_io_link_irq_msk_reset_xlink3_tx_next  0x00000000U
#define MSK_NX10_io_link_irq_msk_reset_xlink3_rx_next       0x00002000U
#define SRT_NX10_io_link_irq_msk_reset_xlink3_rx_next       13
#define DFLT_VAL_NX10_io_link_irq_msk_reset_xlink3_rx_next  0x00000000U
#define MSK_NX10_io_link_irq_msk_reset_xlink3_shift_en      0x00004000U
#define SRT_NX10_io_link_irq_msk_reset_xlink3_shift_en      14
#define DFLT_VAL_NX10_io_link_irq_msk_reset_xlink3_shift_en 0x00000000U

enum {
	BFW_NX10_io_link_irq_msk_reset_xlink0_tx_next  = 1,  /* [0] */
	BFW_NX10_io_link_irq_msk_reset_xlink0_rx_next  = 1,  /* [1] */
	BFW_NX10_io_link_irq_msk_reset_xlink0_shift_en = 1,  /* [2] */
	BFW_NX10_io_link_irq_msk_reset_reserved1       = 1,  /* [3] */
	BFW_NX10_io_link_irq_msk_reset_xlink1_tx_next  = 1,  /* [4] */
	BFW_NX10_io_link_irq_msk_reset_xlink1_rx_next  = 1,  /* [5] */
	BFW_NX10_io_link_irq_msk_reset_xlink1_shift_en = 1,  /* [6] */
	BFW_NX10_io_link_irq_msk_reset_reserved2       = 1,  /* [7] */
	BFW_NX10_io_link_irq_msk_reset_xlink2_tx_next  = 1,  /* [8] */
	BFW_NX10_io_link_irq_msk_reset_xlink2_rx_next  = 1,  /* [9] */
	BFW_NX10_io_link_irq_msk_reset_xlink2_shift_en = 1,  /* [10] */
	BFW_NX10_io_link_irq_msk_reset_reserved3       = 1,  /* [11] */
	BFW_NX10_io_link_irq_msk_reset_xlink3_tx_next  = 1,  /* [12] */
	BFW_NX10_io_link_irq_msk_reset_xlink3_rx_next  = 1,  /* [13] */
	BFW_NX10_io_link_irq_msk_reset_xlink3_shift_en = 1,  /* [14] */
	BFW_NX10_io_link_irq_msk_reset_reserved4       = 17  /* [31:15] */
};

typedef struct NX10_IO_LINK_IRQ_MSK_RESET_BIT_Ttag {
	unsigned int xlink0_tx_next  : BFW_NX10_io_link_irq_msk_reset_xlink0_tx_next;  /* tx_next interrupt  */
	unsigned int xlink0_rx_next  : BFW_NX10_io_link_irq_msk_reset_xlink0_rx_next;  /* rx_next interrupt  */
	unsigned int xlink0_shift_en : BFW_NX10_io_link_irq_msk_reset_xlink0_shift_en; /* shift_en interrupt */
	unsigned int reserved1       : BFW_NX10_io_link_irq_msk_reset_reserved1;       /* reserved           */
	unsigned int xlink1_tx_next  : BFW_NX10_io_link_irq_msk_reset_xlink1_tx_next;  /* tx_next interrupt  */
	unsigned int xlink1_rx_next  : BFW_NX10_io_link_irq_msk_reset_xlink1_rx_next;  /* rx_next interrupt  */
	unsigned int xlink1_shift_en : BFW_NX10_io_link_irq_msk_reset_xlink1_shift_en; /* shift_en interrupt */
	unsigned int reserved2       : BFW_NX10_io_link_irq_msk_reset_reserved2;       /* reserved           */
	unsigned int xlink2_tx_next  : BFW_NX10_io_link_irq_msk_reset_xlink2_tx_next;  /* tx_next interrupt  */
	unsigned int xlink2_rx_next  : BFW_NX10_io_link_irq_msk_reset_xlink2_rx_next;  /* rx_next interrupt  */
	unsigned int xlink2_shift_en : BFW_NX10_io_link_irq_msk_reset_xlink2_shift_en; /* shift_en interrupt */
	unsigned int reserved3       : BFW_NX10_io_link_irq_msk_reset_reserved3;       /* reserved           */
	unsigned int xlink3_tx_next  : BFW_NX10_io_link_irq_msk_reset_xlink3_tx_next;  /* tx_next interrupt  */
	unsigned int xlink3_rx_next  : BFW_NX10_io_link_irq_msk_reset_xlink3_rx_next;  /* rx_next interrupt  */
	unsigned int xlink3_shift_en : BFW_NX10_io_link_irq_msk_reset_xlink3_shift_en; /* shift_en interrupt */
	unsigned int reserved4       : BFW_NX10_io_link_irq_msk_reset_reserved4;       /* reserved           */
} NX10_IO_LINK_IRQ_MSK_RESET_BIT_T;

typedef union {
	unsigned int                     val;
	NX10_IO_LINK_IRQ_MSK_RESET_BIT_T bf;
} NX10_IO_LINK_IRQ_MSK_RESET_T;

/* --------------------------------------------------------------------- */
/* Register io_link_irq_enable */
/* => IO-Link processor enable: */
/*    Enable all irqs for xpic and/or arm */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX10_io_link_irq_enable         0x00000010U
#define Adr_NX10_io_link_irq_io_link_irq_enable 0x10140650U
#define Adr_NX10_io_link_irq_enable             0x10140650U
#define DFLT_VAL_NX10_io_link_irq_enable        0x00000002U

#define MSK_NX10_io_link_irq_enable_arm_en       0x00000001U
#define SRT_NX10_io_link_irq_enable_arm_en       0
#define DFLT_VAL_NX10_io_link_irq_enable_arm_en  0x00000000U
#define MSK_NX10_io_link_irq_enable_xpic_en      0x00000002U
#define SRT_NX10_io_link_irq_enable_xpic_en      1
#define DFLT_VAL_NX10_io_link_irq_enable_xpic_en 0x00000002U

enum {
	BFW_NX10_io_link_irq_enable_arm_en    = 1,  /* [0] */
	BFW_NX10_io_link_irq_enable_xpic_en   = 1,  /* [1] */
	BFW_NX10_io_link_irq_enable_reserved1 = 30  /* [31:2] */
};

typedef struct NX10_IO_LINK_IRQ_ENABLE_BIT_Ttag {
	unsigned int arm_en    : BFW_NX10_io_link_irq_enable_arm_en;    /* enable interrupts to ARM  */
	unsigned int xpic_en   : BFW_NX10_io_link_irq_enable_xpic_en;   /* enable interrupts to xPIC */
	unsigned int reserved1 : BFW_NX10_io_link_irq_enable_reserved1; /* reserved                  */
} NX10_IO_LINK_IRQ_ENABLE_BIT_T;

typedef union {
	unsigned int                  val;
	NX10_IO_LINK_IRQ_ENABLE_BIT_T bf;
} NX10_IO_LINK_IRQ_ENABLE_T;


/* ===================================================================== */

/* AREA spi */
/* Area of spi_motion */

/* ===================================================================== */

#define Addr_NX10_spi_motion 0x10140680U
#define NX10_NETX_SPI1_AREA  0x10140680U

/* --------------------------------------------------------------------- */
/* Register spi_cr0 */
/* => spi control register 0 */
/*    Registers 0x30..0x3C can be used instead of registers 0x00...0x24 to keep netx50 software compliant to netx100/500 */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX10_spi_cr0        0x00000000U
#define Adr_NX10_spi_motion_spi_cr0 0x10140680U
#define Adr_NX10_spi_cr0            0x10140680U
#define DFLT_VAL_NX10_spi_cr0       0x80080007U

#define MSK_NX10_spi_cr0_datasize             0x0000000fU
#define SRT_NX10_spi_cr0_datasize             0
#define DFLT_VAL_NX10_spi_cr0_datasize        0x00000007U
#define MSK_NX10_spi_cr0_SPO                  0x00000040U
#define SRT_NX10_spi_cr0_SPO                  6
#define DFLT_VAL_NX10_spi_cr0_SPO             0x00000000U
#define MSK_NX10_spi_cr0_SPH                  0x00000080U
#define SRT_NX10_spi_cr0_SPH                  7
#define DFLT_VAL_NX10_spi_cr0_SPH             0x00000000U
#define MSK_NX10_spi_cr0_sck_muladd           0x000fff00U
#define SRT_NX10_spi_cr0_sck_muladd           8
#define DFLT_VAL_NX10_spi_cr0_sck_muladd      0x00080000U
#define MSK_NX10_spi_cr0_format               0x03000000U
#define SRT_NX10_spi_cr0_format               24
#define DFLT_VAL_NX10_spi_cr0_format          0x00000000U
#define MSK_NX10_spi_cr0_filter_in            0x08000000U
#define SRT_NX10_spi_cr0_filter_in            27
#define DFLT_VAL_NX10_spi_cr0_filter_in       0x00000000U
#define MSK_NX10_spi_cr0_slave_sig_early      0x10000000U
#define SRT_NX10_spi_cr0_slave_sig_early      28
#define DFLT_VAL_NX10_spi_cr0_slave_sig_early 0x00000000U
#define MSK_NX10_spi_cr0_netx100_comp         0x80000000U
#define SRT_NX10_spi_cr0_netx100_comp         31
#define DFLT_VAL_NX10_spi_cr0_netx100_comp    0x80000000U

enum {
	BFW_NX10_spi_cr0_datasize        = 4,  /* [3:0] */
	BFW_NX10_spi_cr0_reserved1       = 2,  /* [5:4] */
	BFW_NX10_spi_cr0_SPO             = 1,  /* [6] */
	BFW_NX10_spi_cr0_SPH             = 1,  /* [7] */
	BFW_NX10_spi_cr0_sck_muladd      = 12, /* [19:8] */
	BFW_NX10_spi_cr0_reserved2       = 4,  /* [23:20] */
	BFW_NX10_spi_cr0_format          = 2,  /* [25:24] */
	BFW_NX10_spi_cr0_reserved3       = 1,  /* [26] */
	BFW_NX10_spi_cr0_filter_in       = 1,  /* [27] */
	BFW_NX10_spi_cr0_slave_sig_early = 1,  /* [28] */
	BFW_NX10_spi_cr0_reserved4       = 2,  /* [30:29] */
	BFW_NX10_spi_cr0_netx100_comp    = 1   /* [31] */
};

typedef struct NX10_SPI_CR0_BIT_Ttag {
	unsigned int datasize        : BFW_NX10_spi_cr0_datasize;        /* DSS: data size select (transfer size = datasize + 1 bits)                                      */
	                                                                 /* 0000...0010: reserved                                                                          */
	unsigned int reserved1       : BFW_NX10_spi_cr0_reserved1;       /* reserved                                                                                       */
	unsigned int SPO             : BFW_NX10_spi_cr0_SPO;             /* serial clock polarity (netx500: CR_cpol)                                                       */
	                                                                 /* 0: idle: clock is low, first edge is rising                                                    */
	unsigned int SPH             : BFW_NX10_spi_cr0_SPH;             /* serial clock phase (netx500: CR_ncpha)                                                         */
	                                                                 /* 1: sample data at second clock edge edge, data is generated half a clock phase before sampling */
	unsigned int sck_muladd      : BFW_NX10_spi_cr0_sck_muladd;      /* Serial clock rate multiply add value for master spi_sck generation.                            */
	                                                                 /* spi_sck-frequency: f_spi_sck = (sck_muladd * 100)/4096 [MHz].                                  */
	unsigned int reserved2       : BFW_NX10_spi_cr0_reserved2;       /* reserved                                                                                       */
	unsigned int format          : BFW_NX10_spi_cr0_format;          /* frame format                                                                                   */
	                                                                 /* 00: Motorola SPI frame format                                                                  */
	unsigned int reserved3       : BFW_NX10_spi_cr0_reserved3;       /* reserved                                                                                       */
	unsigned int filter_in       : BFW_NX10_spi_cr0_filter_in;       /* Receive-data is sampled every 10ns (100MHz system clock). If this bit is set, the              */
	                                                                 /* stored receive value will be the result of a majority decision of the three sampling points    */
	unsigned int slave_sig_early : BFW_NX10_spi_cr0_slave_sig_early; /* Generate MISO in slavemode 1 spi_sck clock edge earlier than Spec-defined.                     */
	                                                                 /* This is to compensate Pad/sampling-delays on fast data rates.                                  */
	unsigned int reserved4       : BFW_NX10_spi_cr0_reserved4;       /* reserved                                                                                       */
	unsigned int netx100_comp    : BFW_NX10_spi_cr0_netx100_comp;    /* use netx100/500-compatible SPI mode:                                                           */
	                                                                 /* 0: start transfer after writing data                                                           */
} NX10_SPI_CR0_BIT_T;

typedef union {
	unsigned int       val;
	NX10_SPI_CR0_BIT_T bf;
} NX10_SPI_CR0_T;

/* --------------------------------------------------------------------- */
/* Register spi_cr1 */
/* => spi control register 0 */
/*    Registers 0x30..0x3C can be used instead of registers 0x00...0x24 to keep netx50 software compliant to netx100/500 */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX10_spi_cr1        0x00000004U
#define Adr_NX10_spi_motion_spi_cr1 0x10140684U
#define Adr_NX10_spi_cr1            0x10140684U
#define DFLT_VAL_NX10_spi_cr1       0x08080000U

#define MSK_NX10_spi_cr1_LBM              0x00000001U
#define SRT_NX10_spi_cr1_LBM              0
#define DFLT_VAL_NX10_spi_cr1_LBM         0x00000000U
#define MSK_NX10_spi_cr1_SSE              0x00000002U
#define SRT_NX10_spi_cr1_SSE              1
#define DFLT_VAL_NX10_spi_cr1_SSE         0x00000000U
#define MSK_NX10_spi_cr1_MS               0x00000004U
#define SRT_NX10_spi_cr1_MS               2
#define DFLT_VAL_NX10_spi_cr1_MS          0x00000000U
#define MSK_NX10_spi_cr1_SOD              0x00000008U
#define SRT_NX10_spi_cr1_SOD              3
#define DFLT_VAL_NX10_spi_cr1_SOD         0x00000000U
#define MSK_NX10_spi_cr1_fss              0x00000700U
#define SRT_NX10_spi_cr1_fss              8
#define DFLT_VAL_NX10_spi_cr1_fss         0x00000000U
#define MSK_NX10_spi_cr1_fss_static       0x00000800U
#define SRT_NX10_spi_cr1_fss_static       11
#define DFLT_VAL_NX10_spi_cr1_fss_static  0x00000000U
#define MSK_NX10_spi_cr1_tx_fifo_wm       0x000f0000U
#define SRT_NX10_spi_cr1_tx_fifo_wm       16
#define DFLT_VAL_NX10_spi_cr1_tx_fifo_wm  0x00080000U
#define MSK_NX10_spi_cr1_tx_fifo_clr      0x00100000U
#define SRT_NX10_spi_cr1_tx_fifo_clr      20
#define DFLT_VAL_NX10_spi_cr1_tx_fifo_clr 0x00000000U
#define MSK_NX10_spi_cr1_rx_fifo_wm       0x0f000000U
#define SRT_NX10_spi_cr1_rx_fifo_wm       24
#define DFLT_VAL_NX10_spi_cr1_rx_fifo_wm  0x08000000U
#define MSK_NX10_spi_cr1_rx_fifo_clr      0x10000000U
#define SRT_NX10_spi_cr1_rx_fifo_clr      28
#define DFLT_VAL_NX10_spi_cr1_rx_fifo_clr 0x00000000U

enum {
	BFW_NX10_spi_cr1_LBM         = 1, /* [0] */
	BFW_NX10_spi_cr1_SSE         = 1, /* [1] */
	BFW_NX10_spi_cr1_MS          = 1, /* [2] */
	BFW_NX10_spi_cr1_SOD         = 1, /* [3] */
	BFW_NX10_spi_cr1_reserved1   = 4, /* [7:4] */
	BFW_NX10_spi_cr1_fss         = 3, /* [10:8] */
	BFW_NX10_spi_cr1_fss_static  = 1, /* [11] */
	BFW_NX10_spi_cr1_reserved2   = 4, /* [15:12] */
	BFW_NX10_spi_cr1_tx_fifo_wm  = 4, /* [19:16] */
	BFW_NX10_spi_cr1_tx_fifo_clr = 1, /* [20] */
	BFW_NX10_spi_cr1_reserved3   = 3, /* [23:21] */
	BFW_NX10_spi_cr1_rx_fifo_wm  = 4, /* [27:24] */
	BFW_NX10_spi_cr1_rx_fifo_clr = 1, /* [28] */
	BFW_NX10_spi_cr1_reserved4   = 3  /* [31:29] */
};

typedef struct NX10_SPI_CR1_BIT_Ttag {
	unsigned int LBM         : BFW_NX10_spi_cr1_LBM;         /* loop back mode                                                                                    */
	                                                         /* 0: internal loop back disabled                                                                    */
	unsigned int SSE         : BFW_NX10_spi_cr1_SSE;         /* SPI enable.                                                                                       */
	                                                         /* 0: interface disabled                                                                             */
	unsigned int MS          : BFW_NX10_spi_cr1_MS;          /* mode select:                                                                                      */
	                                                         /* 0: device is configured as master                                                                 */
	unsigned int SOD         : BFW_NX10_spi_cr1_SOD;         /* slave mode output disable (to connect multibe slaves to opne master)                              */
	                                                         /* 0: SPI-MISO can be driven in slave mode                                                           */
	unsigned int reserved1   : BFW_NX10_spi_cr1_reserved1;   /* reserved                                                                                          */
	unsigned int fss         : BFW_NX10_spi_cr1_fss;         /* extended: Frame or slave select (up to 3 devices can be assigned directly,                        */
	                                                         /* up to 8 devices can be assigned if an external demultiplexer is used if device is master.         */
	unsigned int fss_static  : BFW_NX10_spi_cr1_fss_static;  /* SPI static chipselect                                                                             */
	                                                         /* 0: SPI-chipselect will be toggled automatically at data frame begin/end according to fss and FRF0 */
	unsigned int reserved2   : BFW_NX10_spi_cr1_reserved2;   /* reserved                                                                                          */
	unsigned int tx_fifo_wm  : BFW_NX10_spi_cr1_tx_fifo_wm;  /* transmit FIFO watermark for IRQ-generation                                                        */
	unsigned int tx_fifo_clr : BFW_NX10_spi_cr1_tx_fifo_clr; /* extended: writing "1" to this bit will clear the transmit-FIFOs                                   */
	                                                         /* There must be at least 1 system-clock idle after clear before writing new data to the FIFO.       */
	unsigned int reserved3   : BFW_NX10_spi_cr1_reserved3;   /* reserved                                                                                          */
	unsigned int rx_fifo_wm  : BFW_NX10_spi_cr1_rx_fifo_wm;  /* receive FIFO watermark for IRQ-generation                                                         */
	unsigned int rx_fifo_clr : BFW_NX10_spi_cr1_rx_fifo_clr; /* extended: writing "1" to this bit will clear the receive-FIFOs                                    */
	unsigned int reserved4   : BFW_NX10_spi_cr1_reserved4;   /* reserved                                                                                          */
} NX10_SPI_CR1_BIT_T;

typedef union {
	unsigned int       val;
	NX10_SPI_CR1_BIT_T bf;
} NX10_SPI_CR1_T;

/* --------------------------------------------------------------------- */
/* Register spi_dr */
/* => spi data register (DR) */
/*    Registers 0x30..0x3C can be used instead of registers 0x00...0x24 to keep netx50 software compliant to netx100/500 */
/*    read access: received data byte is delivered from receive FIFO */
/*    write access: send data byte is written to send FIFO */
/*    Both, receive and transmit FIFO have a depth of 16. */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX10_spi_dr        0x00000008U
#define Adr_NX10_spi_motion_spi_dr 0x10140688U
#define Adr_NX10_spi_dr            0x10140688U
#define DFLT_VAL_NX10_spi_dr       0x00000000U

#define MSK_NX10_spi_dr_data      0x0001ffffU
#define SRT_NX10_spi_dr_data      0
#define DFLT_VAL_NX10_spi_dr_data 0x00000000U

enum {
	BFW_NX10_spi_dr_data      = 17, /* [16:0] */
	BFW_NX10_spi_dr_reserved1 = 15  /* [31:17] */
};

typedef struct NX10_SPI_DR_BIT_Ttag {
	unsigned int data      : BFW_NX10_spi_dr_data;      /* Transmit data, must be right aligned on writing, only bits according to spi_cr0.DSS are considered */
	                                                    /* Receive data will be delivered right aligned, unused bits (spi_cr0.DSS < 0xF) will be "0".         */
	unsigned int reserved1 : BFW_NX10_spi_dr_reserved1; /* reserved                                                                                           */
} NX10_SPI_DR_BIT_T;

typedef union {
	unsigned int      val;
	NX10_SPI_DR_BIT_T bf;
} NX10_SPI_DR_T;

/* --------------------------------------------------------------------- */
/* Register spi_sr */
/* => read only spi status register */
/*    Registers 0x30..0x3C can be used instead of registers 0x00...0x24 to keep netx50 software compliant to netx100/500 */
/*    SPI master mode: MISO-input-data will be stored in the receive FIFO, transmit FIFO generates MOSI-output-data */
/*    SPI slave mode: MOSI-input-data will be stored in the receive FIFO, transmit FIFO generates MISO-output-data */
/*    Shows the current status of the spi interface. */
/*    Both, receive and transmit FIFO have a depth of 16. */
/* => Mode: R */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX10_spi_sr        0x0000000CU
#define Adr_NX10_spi_motion_spi_sr 0x1014068CU
#define Adr_NX10_spi_sr            0x1014068CU

#define MSK_NX10_spi_sr_TFE              0x00000001U
#define SRT_NX10_spi_sr_TFE              0
#define MSK_NX10_spi_sr_TNF              0x00000002U
#define SRT_NX10_spi_sr_TNF              1
#define MSK_NX10_spi_sr_RNE              0x00000004U
#define SRT_NX10_spi_sr_RNE              2
#define MSK_NX10_spi_sr_RFF              0x00000008U
#define SRT_NX10_spi_sr_RFF              3
#define MSK_NX10_spi_sr_BSY              0x00000010U
#define SRT_NX10_spi_sr_BSY              4
#define MSK_NX10_spi_sr_tx_fifo_level    0x001f0000U
#define SRT_NX10_spi_sr_tx_fifo_level    16
#define MSK_NX10_spi_sr_tx_fifo_err_ovfl 0x00400000U
#define SRT_NX10_spi_sr_tx_fifo_err_ovfl 22
#define MSK_NX10_spi_sr_tx_fifo_err_undr 0x00800000U
#define SRT_NX10_spi_sr_tx_fifo_err_undr 23
#define MSK_NX10_spi_sr_rx_fifo_level    0x1f000000U
#define SRT_NX10_spi_sr_rx_fifo_level    24
#define MSK_NX10_spi_sr_rx_fifo_err_ovfl 0x40000000U
#define SRT_NX10_spi_sr_rx_fifo_err_ovfl 30
#define MSK_NX10_spi_sr_rx_fifo_err_undr 0x80000000U
#define SRT_NX10_spi_sr_rx_fifo_err_undr 31

enum {
	BFW_NX10_spi_sr_TFE              = 1,  /* [0] */
	BFW_NX10_spi_sr_TNF              = 1,  /* [1] */
	BFW_NX10_spi_sr_RNE              = 1,  /* [2] */
	BFW_NX10_spi_sr_RFF              = 1,  /* [3] */
	BFW_NX10_spi_sr_BSY              = 1,  /* [4] */
	BFW_NX10_spi_sr_reserved1        = 11, /* [15:5] */
	BFW_NX10_spi_sr_tx_fifo_level    = 5,  /* [20:16] */
	BFW_NX10_spi_sr_reserved2        = 1,  /* [21] */
	BFW_NX10_spi_sr_tx_fifo_err_ovfl = 1,  /* [22] */
	BFW_NX10_spi_sr_tx_fifo_err_undr = 1,  /* [23] */
	BFW_NX10_spi_sr_rx_fifo_level    = 5,  /* [28:24] */
	BFW_NX10_spi_sr_reserved3        = 1,  /* [29] */
	BFW_NX10_spi_sr_rx_fifo_err_ovfl = 1,  /* [30] */
	BFW_NX10_spi_sr_rx_fifo_err_undr = 1   /* [31] */
};

typedef struct NX10_SPI_SR_BIT_Ttag {
	unsigned int TFE              : BFW_NX10_spi_sr_TFE;              /* transmit FIFO is empty (1 if empty)                                                         */
	unsigned int TNF              : BFW_NX10_spi_sr_TNF;              /* transmit FIFO is not full (0 if full)                                                       */
	unsigned int RNE              : BFW_NX10_spi_sr_RNE;              /* receive FIFO is not empty (0 if empty)                                                      */
	unsigned int RFF              : BFW_NX10_spi_sr_RFF;              /* receive FIFO is full (1 if full)                                                            */
	unsigned int BSY              : BFW_NX10_spi_sr_BSY;              /* device busy (1 if data is currently transmitted/received or the transmit FIFO is not empty) */
	unsigned int reserved1        : BFW_NX10_spi_sr_reserved1;        /* reserved                                                                                    */
	unsigned int tx_fifo_level    : BFW_NX10_spi_sr_tx_fifo_level;    /* extended: transmit FIFO level (number of words to transmit are left in FIFO)                */
	unsigned int reserved2        : BFW_NX10_spi_sr_reserved2;        /* reserved                                                                                    */
	unsigned int tx_fifo_err_ovfl : BFW_NX10_spi_sr_tx_fifo_err_ovfl; /* extended: transmit FIFO overflow error occured, data is lost                                */
	unsigned int tx_fifo_err_undr : BFW_NX10_spi_sr_tx_fifo_err_undr; /* extended: transmit FIFO underrun error occured, data is lost                                */
	unsigned int rx_fifo_level    : BFW_NX10_spi_sr_rx_fifo_level;    /* extended: receive FIFO level (number of received words to read out are left in FIFO)        */
	unsigned int reserved3        : BFW_NX10_spi_sr_reserved3;        /* reserved                                                                                    */
	unsigned int rx_fifo_err_ovfl : BFW_NX10_spi_sr_rx_fifo_err_ovfl; /* extended: receive FIFO overflow error occured, data is lost                                 */
	unsigned int rx_fifo_err_undr : BFW_NX10_spi_sr_rx_fifo_err_undr; /* extended: receive FIFO underrun error occured, data is lost                                 */
} NX10_SPI_SR_BIT_T;

typedef union {
	unsigned int      val;
	NX10_SPI_SR_BIT_T bf;
} NX10_SPI_SR_T;

/* --------------------------------------------------------------------- */
/* Register spi_cpsr */
/* => Registers 0x30..0x3C can be used instead of registers 0x00...0x24 to keep netx50 software compliant to netx100/500 */
/*    spi clock prescale register */
/*    No clock predeviding is done. */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX10_spi_cpsr        0x00000010U
#define Adr_NX10_spi_motion_spi_cpsr 0x10140690U
#define Adr_NX10_spi_cpsr            0x10140690U
#define DFLT_VAL_NX10_spi_cpsr       0x00000000U

#define MSK_NX10_spi_cpsr_CPSDVSR      0x000000ffU
#define SRT_NX10_spi_cpsr_CPSDVSR      0
#define DFLT_VAL_NX10_spi_cpsr_CPSDVSR 0x00000000U

enum {
	BFW_NX10_spi_cpsr_CPSDVSR   = 8,  /* [7:0] */
	BFW_NX10_spi_cpsr_reserved1 = 24  /* [31:8] */
};

typedef struct NX10_SPI_CPSR_BIT_Ttag {
	unsigned int CPSDVSR   : BFW_NX10_spi_cpsr_CPSDVSR;   /* obsolet  */
	unsigned int reserved1 : BFW_NX10_spi_cpsr_reserved1; /* reserved */
} NX10_SPI_CPSR_BIT_T;

typedef union {
	unsigned int        val;
	NX10_SPI_CPSR_BIT_T bf;
} NX10_SPI_CPSR_T;

/* --------------------------------------------------------------------- */
/* Register spi_imsc */
/* => spi interrupt mask set or clear register */
/*    Registers 0x30..0x3C can be used instead of registers 0x00...0x24 to keep netx50 software compliant to netx100/500 */
/*    AND-mask */
/*    Both, receive and transmit FIFO have a depth of 16. */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX10_spi_imsc        0x00000014U
#define Adr_NX10_spi_motion_spi_imsc 0x10140694U
#define Adr_NX10_spi_imsc            0x10140694U
#define DFLT_VAL_NX10_spi_imsc       0x00000000U

#define MSK_NX10_spi_imsc_RORIM       0x00000001U
#define SRT_NX10_spi_imsc_RORIM       0
#define DFLT_VAL_NX10_spi_imsc_RORIM  0x00000000U
#define MSK_NX10_spi_imsc_RTIM        0x00000002U
#define SRT_NX10_spi_imsc_RTIM        1
#define DFLT_VAL_NX10_spi_imsc_RTIM   0x00000000U
#define MSK_NX10_spi_imsc_RXIM        0x00000004U
#define SRT_NX10_spi_imsc_RXIM        2
#define DFLT_VAL_NX10_spi_imsc_RXIM   0x00000000U
#define MSK_NX10_spi_imsc_TXIM        0x00000008U
#define SRT_NX10_spi_imsc_TXIM        3
#define DFLT_VAL_NX10_spi_imsc_TXIM   0x00000000U
#define MSK_NX10_spi_imsc_rxneim      0x00000010U
#define SRT_NX10_spi_imsc_rxneim      4
#define DFLT_VAL_NX10_spi_imsc_rxneim 0x00000000U
#define MSK_NX10_spi_imsc_rxfim       0x00000020U
#define SRT_NX10_spi_imsc_rxfim       5
#define DFLT_VAL_NX10_spi_imsc_rxfim  0x00000000U
#define MSK_NX10_spi_imsc_txeim       0x00000040U
#define SRT_NX10_spi_imsc_txeim       6
#define DFLT_VAL_NX10_spi_imsc_txeim  0x00000000U

enum {
	BFW_NX10_spi_imsc_RORIM     = 1,  /* [0] */
	BFW_NX10_spi_imsc_RTIM      = 1,  /* [1] */
	BFW_NX10_spi_imsc_RXIM      = 1,  /* [2] */
	BFW_NX10_spi_imsc_TXIM      = 1,  /* [3] */
	BFW_NX10_spi_imsc_rxneim    = 1,  /* [4] */
	BFW_NX10_spi_imsc_rxfim     = 1,  /* [5] */
	BFW_NX10_spi_imsc_txeim     = 1,  /* [6] */
	BFW_NX10_spi_imsc_reserved1 = 25  /* [31:7] */
};

typedef struct NX10_SPI_IMSC_BIT_Ttag {
	unsigned int RORIM     : BFW_NX10_spi_imsc_RORIM;     /* receive FIFO overrun interrupt mask                                */
	unsigned int RTIM      : BFW_NX10_spi_imsc_RTIM;      /* receive timeout interrupt mask                                     */
	unsigned int RXIM      : BFW_NX10_spi_imsc_RXIM;      /* receive FIFO interrupt mask                                        */
	unsigned int TXIM      : BFW_NX10_spi_imsc_TXIM;      /* transmit FIFO interrupt mask                                       */
	unsigned int rxneim    : BFW_NX10_spi_imsc_rxneim;    /* receive FIFO not empty interrupt mask (for netx100/500 compliance) */
	unsigned int rxfim     : BFW_NX10_spi_imsc_rxfim;     /* receive FIFO full interrupt mask (for netx100/500 compliance)      */
	unsigned int txeim     : BFW_NX10_spi_imsc_txeim;     /* transmit FIFO empty interrupt mask (for netx100/500 compliance)    */
	unsigned int reserved1 : BFW_NX10_spi_imsc_reserved1; /* reserved                                                           */
} NX10_SPI_IMSC_BIT_T;

typedef union {
	unsigned int        val;
	NX10_SPI_IMSC_BIT_T bf;
} NX10_SPI_IMSC_T;

/* --------------------------------------------------------------------- */
/* Register spi_ris */
/* => spi interrupt state before masking register (raw interrupt) */
/*    Registers 0x30..0x3C can be used instead of registers 0x00...0x24 to keep netx50 software compliant to netx100/500 */
/*    Both, receive and transmit FIFO have a depth of 16. */
/* => Mode: R */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX10_spi_ris        0x00000018U
#define Adr_NX10_spi_motion_spi_ris 0x10140698U
#define Adr_NX10_spi_ris            0x10140698U

#define MSK_NX10_spi_ris_RORRIS  0x00000001U
#define SRT_NX10_spi_ris_RORRIS  0
#define MSK_NX10_spi_ris_RTRIS   0x00000002U
#define SRT_NX10_spi_ris_RTRIS   1
#define MSK_NX10_spi_ris_RXRIS   0x00000004U
#define SRT_NX10_spi_ris_RXRIS   2
#define MSK_NX10_spi_ris_TXRIS   0x00000008U
#define SRT_NX10_spi_ris_TXRIS   3
#define MSK_NX10_spi_ris_rxneris 0x00000010U
#define SRT_NX10_spi_ris_rxneris 4
#define MSK_NX10_spi_ris_rxfris  0x00000020U
#define SRT_NX10_spi_ris_rxfris  5
#define MSK_NX10_spi_ris_txeris  0x00000040U
#define SRT_NX10_spi_ris_txeris  6

enum {
	BFW_NX10_spi_ris_RORRIS    = 1,  /* [0] */
	BFW_NX10_spi_ris_RTRIS     = 1,  /* [1] */
	BFW_NX10_spi_ris_RXRIS     = 1,  /* [2] */
	BFW_NX10_spi_ris_TXRIS     = 1,  /* [3] */
	BFW_NX10_spi_ris_rxneris   = 1,  /* [4] */
	BFW_NX10_spi_ris_rxfris    = 1,  /* [5] */
	BFW_NX10_spi_ris_txeris    = 1,  /* [6] */
	BFW_NX10_spi_ris_reserved1 = 25  /* [31:7] */
};

typedef struct NX10_SPI_RIS_BIT_Ttag {
	unsigned int RORRIS    : BFW_NX10_spi_ris_RORRIS;    /* unmasked receive FIFO overrun interrupt state                                */
	                                                     /* 1: receive FIFO overun error ocuured                                         */
	unsigned int RTRIS     : BFW_NX10_spi_ris_RTRIS;     /* unmasked receive timeout interrupt state                                     */
	                                                     /* timeout period are 32 SPI-clock periods depending on adr_spi_cr0.SCR         */
	unsigned int RXRIS     : BFW_NX10_spi_ris_RXRIS;     /* unmasked receive FIFO interrupt state                                        */
	                                                     /* 1: receive FIFO is higher than spi_cr1.rx_fifo_wm                            */
	unsigned int TXRIS     : BFW_NX10_spi_ris_TXRIS;     /* unmasked transmit FIFO interrupt state                                       */
	                                                     /* 1: transmit FIFO level is below spi_cr1.tx_fifo_wm                           */
	unsigned int rxneris   : BFW_NX10_spi_ris_rxneris;   /* unmasked receive FIFO not empty interrupt state (for netx100/500 compliance) */
	                                                     /* 1: receive FIFO is not empty                                                 */
	unsigned int rxfris    : BFW_NX10_spi_ris_rxfris;    /* unmasked receive FIFO full interrupt state (for netx100/500 compliance)      */
	                                                     /* 1: receive FIFO is full                                                      */
	unsigned int txeris    : BFW_NX10_spi_ris_txeris;    /* unmasked transmit FIFO empty interrupt state (for netx100/500 compliance)    */
	                                                     /* 1: transmit FIFO is empty                                                    */
	unsigned int reserved1 : BFW_NX10_spi_ris_reserved1; /* reserved                                                                     */
} NX10_SPI_RIS_BIT_T;

typedef union {
	unsigned int       val;
	NX10_SPI_RIS_BIT_T bf;
} NX10_SPI_RIS_T;

/* --------------------------------------------------------------------- */
/* Register spi_mis */
/* => spi interrupt status register */
/*    Registers 0x30..0x3C can be used instead of registers 0x00...0x24 to keep netx50 software compliant to netx100/500 */
/*    Both, receive and transmit FIFO have a depth of 16. */
/* => Mode: R */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX10_spi_mis        0x0000001CU
#define Adr_NX10_spi_motion_spi_mis 0x1014069CU
#define Adr_NX10_spi_mis            0x1014069CU

#define MSK_NX10_spi_mis_RORMIS  0x00000001U
#define SRT_NX10_spi_mis_RORMIS  0
#define MSK_NX10_spi_mis_RTMIS   0x00000002U
#define SRT_NX10_spi_mis_RTMIS   1
#define MSK_NX10_spi_mis_RXMIS   0x00000004U
#define SRT_NX10_spi_mis_RXMIS   2
#define MSK_NX10_spi_mis_TXMIS   0x00000008U
#define SRT_NX10_spi_mis_TXMIS   3
#define MSK_NX10_spi_mis_rxnemis 0x00000010U
#define SRT_NX10_spi_mis_rxnemis 4
#define MSK_NX10_spi_mis_rxfmis  0x00000020U
#define SRT_NX10_spi_mis_rxfmis  5
#define MSK_NX10_spi_mis_txemis  0x00000040U
#define SRT_NX10_spi_mis_txemis  6

enum {
	BFW_NX10_spi_mis_RORMIS    = 1,  /* [0] */
	BFW_NX10_spi_mis_RTMIS     = 1,  /* [1] */
	BFW_NX10_spi_mis_RXMIS     = 1,  /* [2] */
	BFW_NX10_spi_mis_TXMIS     = 1,  /* [3] */
	BFW_NX10_spi_mis_rxnemis   = 1,  /* [4] */
	BFW_NX10_spi_mis_rxfmis    = 1,  /* [5] */
	BFW_NX10_spi_mis_txemis    = 1,  /* [6] */
	BFW_NX10_spi_mis_reserved1 = 25  /* [31:7] */
};

typedef struct NX10_SPI_MIS_BIT_Ttag {
	unsigned int RORMIS    : BFW_NX10_spi_mis_RORMIS;    /* masked receive FIFO overrun interrupt state                                */
	unsigned int RTMIS     : BFW_NX10_spi_mis_RTMIS;     /* masked receive timeout interrupt state                                     */
	unsigned int RXMIS     : BFW_NX10_spi_mis_RXMIS;     /* masked receive FIFO interrupt state                                        */
	unsigned int TXMIS     : BFW_NX10_spi_mis_TXMIS;     /* masked transmit FIFO interrupt state                                       */
	unsigned int rxnemis   : BFW_NX10_spi_mis_rxnemis;   /* masked receive FIFO not empty interrupt state (for netx100/500 compliance) */
	unsigned int rxfmis    : BFW_NX10_spi_mis_rxfmis;    /* masked receive FIFO full interrupt state (for netx100/500 compliance)      */
	unsigned int txemis    : BFW_NX10_spi_mis_txemis;    /* masked transmit FIFO empty interrupt state (for netx100/500 compliance)    */
	unsigned int reserved1 : BFW_NX10_spi_mis_reserved1; /* reserved                                                                   */
} NX10_SPI_MIS_BIT_T;

typedef union {
	unsigned int       val;
	NX10_SPI_MIS_BIT_T bf;
} NX10_SPI_MIS_T;

/* --------------------------------------------------------------------- */
/* Register spi_icr */
/* => spi interrupt clear register */
/*    Registers 0x30..0x3C can be used instead of registers 0x00...0x24 to keep netx50 software compliant to netx100/500 */
/*    interrupt is cleard by writing "1" to the according bit */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX10_spi_icr        0x00000020U
#define Adr_NX10_spi_motion_spi_icr 0x101406A0U
#define Adr_NX10_spi_icr            0x101406A0U
#define DFLT_VAL_NX10_spi_icr       0x00000000U

#define MSK_NX10_spi_icr_RORIC       0x00000001U
#define SRT_NX10_spi_icr_RORIC       0
#define DFLT_VAL_NX10_spi_icr_RORIC  0x00000000U
#define MSK_NX10_spi_icr_RTIC        0x00000002U
#define SRT_NX10_spi_icr_RTIC        1
#define DFLT_VAL_NX10_spi_icr_RTIC   0x00000000U
#define MSK_NX10_spi_icr_RXIC        0x00000004U
#define SRT_NX10_spi_icr_RXIC        2
#define DFLT_VAL_NX10_spi_icr_RXIC   0x00000000U
#define MSK_NX10_spi_icr_TXIC        0x00000008U
#define SRT_NX10_spi_icr_TXIC        3
#define DFLT_VAL_NX10_spi_icr_TXIC   0x00000000U
#define MSK_NX10_spi_icr_rxneic      0x00000010U
#define SRT_NX10_spi_icr_rxneic      4
#define DFLT_VAL_NX10_spi_icr_rxneic 0x00000000U
#define MSK_NX10_spi_icr_rxfic       0x00000020U
#define SRT_NX10_spi_icr_rxfic       5
#define DFLT_VAL_NX10_spi_icr_rxfic  0x00000000U
#define MSK_NX10_spi_icr_txeic       0x00000040U
#define SRT_NX10_spi_icr_txeic       6
#define DFLT_VAL_NX10_spi_icr_txeic  0x00000000U

enum {
	BFW_NX10_spi_icr_RORIC     = 1,  /* [0] */
	BFW_NX10_spi_icr_RTIC      = 1,  /* [1] */
	BFW_NX10_spi_icr_RXIC      = 1,  /* [2] */
	BFW_NX10_spi_icr_TXIC      = 1,  /* [3] */
	BFW_NX10_spi_icr_rxneic    = 1,  /* [4] */
	BFW_NX10_spi_icr_rxfic     = 1,  /* [5] */
	BFW_NX10_spi_icr_txeic     = 1,  /* [6] */
	BFW_NX10_spi_icr_reserved1 = 25  /* [31:7] */
};

typedef struct NX10_SPI_ICR_BIT_Ttag {
	unsigned int RORIC     : BFW_NX10_spi_icr_RORIC;     /* clear receive FIFO overrun interrupt                                */
	                                                     /* writing '1' here will clear the receive FIFO                        */
	unsigned int RTIC      : BFW_NX10_spi_icr_RTIC;      /* clear receive FIFO overrun interrupt                                */
	unsigned int RXIC      : BFW_NX10_spi_icr_RXIC;      /* PL022 extention: clear receive FIFO interrupt                       */
	unsigned int TXIC      : BFW_NX10_spi_icr_TXIC;      /* PL022 extention: clear transmit FIFO interrupt                      */
	unsigned int rxneic    : BFW_NX10_spi_icr_rxneic;    /* clear receive FIFO not empty interrupt (for netx100/500 compliance) */
	unsigned int rxfic     : BFW_NX10_spi_icr_rxfic;     /* clear receive FIFO full interrupt (for netx100/500 compliance)      */
	unsigned int txeic     : BFW_NX10_spi_icr_txeic;     /* clear transmit FIFO empty interrupt (for netx100/500 compliance)    */
	unsigned int reserved1 : BFW_NX10_spi_icr_reserved1; /* reserved                                                            */
} NX10_SPI_ICR_BIT_T;

typedef union {
	unsigned int       val;
	NX10_SPI_ICR_BIT_T bf;
} NX10_SPI_ICR_T;

/* --------------------------------------------------------------------- */
/* Register spi_irq_cpu_sel */
/* => Interrupt CPU select register */
/*    Select CPU (xPIC or ARM), which gets Interrupts from this SPI instance. */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX10_spi_irq_cpu_sel        0x00000024U
#define Adr_NX10_spi_motion_spi_irq_cpu_sel 0x101406A4U
#define Adr_NX10_spi_irq_cpu_sel            0x101406A4U
#define DFLT_VAL_NX10_spi_irq_cpu_sel       0x00000001U

#define MSK_NX10_spi_irq_cpu_sel_arm       0x00000001U
#define SRT_NX10_spi_irq_cpu_sel_arm       0
#define DFLT_VAL_NX10_spi_irq_cpu_sel_arm  0x00000001U
#define MSK_NX10_spi_irq_cpu_sel_xpic      0x00000002U
#define SRT_NX10_spi_irq_cpu_sel_xpic      1
#define DFLT_VAL_NX10_spi_irq_cpu_sel_xpic 0x00000000U

enum {
	BFW_NX10_spi_irq_cpu_sel_arm       = 1,  /* [0] */
	BFW_NX10_spi_irq_cpu_sel_xpic      = 1,  /* [1] */
	BFW_NX10_spi_irq_cpu_sel_reserved1 = 30  /* [31:2] */
};

typedef struct NX10_SPI_IRQ_CPU_SEL_BIT_Ttag {
	unsigned int arm       : BFW_NX10_spi_irq_cpu_sel_arm;       /* Enable for IRQ signal to ARM  */
	unsigned int xpic      : BFW_NX10_spi_irq_cpu_sel_xpic;      /* Enable for IRQ signal to xPIC */
	unsigned int reserved1 : BFW_NX10_spi_irq_cpu_sel_reserved1; /* reserved                      */
} NX10_SPI_IRQ_CPU_SEL_BIT_T;

typedef union {
	unsigned int               val;
	NX10_SPI_IRQ_CPU_SEL_BIT_T bf;
} NX10_SPI_IRQ_CPU_SEL_T;

/* --------------------------------------------------------------------- */
/* Register spi_dmacr */
/* => spi DMA control register */
/*    Only single transfer requests will be generated by this module. */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX10_spi_dmacr        0x00000028U
#define Adr_NX10_spi_motion_spi_dmacr 0x101406A8U
#define Adr_NX10_spi_dmacr            0x101406A8U
#define DFLT_VAL_NX10_spi_dmacr       0x00000000U

#define MSK_NX10_spi_dmacr_RXDMAE      0x00000001U
#define SRT_NX10_spi_dmacr_RXDMAE      0
#define DFLT_VAL_NX10_spi_dmacr_RXDMAE 0x00000000U
#define MSK_NX10_spi_dmacr_TXDMAE      0x00000002U
#define SRT_NX10_spi_dmacr_TXDMAE      1
#define DFLT_VAL_NX10_spi_dmacr_TXDMAE 0x00000000U

enum {
	BFW_NX10_spi_dmacr_RXDMAE    = 1,  /* [0] */
	BFW_NX10_spi_dmacr_TXDMAE    = 1,  /* [1] */
	BFW_NX10_spi_dmacr_reserved1 = 30  /* [31:2] */
};

typedef struct NX10_SPI_DMACR_BIT_Ttag {
	unsigned int RXDMAE    : BFW_NX10_spi_dmacr_RXDMAE;    /* enable DMA for SPI-receive data                                                             */
	                                                       /* A request will be generated if RX-FIFO is not empty and spi_cr1.SSE (module enable) is set. */
	unsigned int TXDMAE    : BFW_NX10_spi_dmacr_TXDMAE;    /* enable DMA for SPI-transmit data                                                            */
	                                                       /* A request will be generated if TX-FIFO is not full and spi_cr1.SSE (module enable) is set.  */
	unsigned int reserved1 : BFW_NX10_spi_dmacr_reserved1; /* reserved                                                                                    */
} NX10_SPI_DMACR_BIT_T;

typedef union {
	unsigned int         val;
	NX10_SPI_DMACR_BIT_T bf;
} NX10_SPI_DMACR_T;

/* --------------------------------------------------------------------- */
/* Register spi_data_register */
/* => netx100/500 compliant spi data register (DR) */
/*    Registers 0x30..0x3C can be used instead of registers 0x00...0x24 to keep netx50 software compliant to netx100/500 */
/*    2 data bytes with valid bits */
/*    During write-access data_byte_1 and dr_valid1 must not be used. dr_valid0 must be set. */
/*    In netx50 and later versions both, receive and transmit FIFO have a depth of 16, fill-values are fixed to 4. To keep software */
/*    compatible, not more than 8 bytes should be in netx100/500-FIFOs. */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX10_spi_data_register        0x00000030U
#define Adr_NX10_spi_motion_spi_data_register 0x101406B0U
#define Adr_NX10_spi_data_register            0x101406B0U
#define DFLT_VAL_NX10_spi_data_register       0x00000000U

#define MSK_NX10_spi_data_register_data_byte_0      0x000000ffU
#define SRT_NX10_spi_data_register_data_byte_0      0
#define DFLT_VAL_NX10_spi_data_register_data_byte_0 0x00000000U
#define MSK_NX10_spi_data_register_data_byte_1      0x0000ff00U
#define SRT_NX10_spi_data_register_data_byte_1      8
#define DFLT_VAL_NX10_spi_data_register_data_byte_1 0x00000000U
#define MSK_NX10_spi_data_register_dr_valid0        0x00010000U
#define SRT_NX10_spi_data_register_dr_valid0        16
#define DFLT_VAL_NX10_spi_data_register_dr_valid0   0x00000000U
#define MSK_NX10_spi_data_register_dr_valid1        0x00020000U
#define SRT_NX10_spi_data_register_dr_valid1        17
#define DFLT_VAL_NX10_spi_data_register_dr_valid1   0x00000000U

enum {
	BFW_NX10_spi_data_register_data_byte_0 = 8,  /* [7:0] */
	BFW_NX10_spi_data_register_data_byte_1 = 8,  /* [15:8] */
	BFW_NX10_spi_data_register_dr_valid0   = 1,  /* [16] */
	BFW_NX10_spi_data_register_dr_valid1   = 1,  /* [17] */
	BFW_NX10_spi_data_register_reserved1   = 14  /* [31:18] */
};

typedef struct NX10_SPI_DATA_REGISTER_BIT_Ttag {
	unsigned int data_byte_0 : BFW_NX10_spi_data_register_data_byte_0; /* data byte 0                                                                     */
	unsigned int data_byte_1 : BFW_NX10_spi_data_register_data_byte_1; /* obsolet, don't use                                                              */
	unsigned int dr_valid0   : BFW_NX10_spi_data_register_dr_valid0;   /* valid bit for data_byte_0                                                       */
	                                                                   /* This bit shows if data_byte_0 Is valid and must be set during FIFO write access */
	unsigned int dr_valid1   : BFW_NX10_spi_data_register_dr_valid1;   /* obsolet, always 0                                                               */
	unsigned int reserved1   : BFW_NX10_spi_data_register_reserved1;   /* reserved                                                                        */
} NX10_SPI_DATA_REGISTER_BIT_T;

typedef union {
	unsigned int                 val;
	NX10_SPI_DATA_REGISTER_BIT_T bf;
} NX10_SPI_DATA_REGISTER_T;

/* --------------------------------------------------------------------- */
/* Register spi_status_register */
/* => netx100/500 compliant spi status register (SR): */
/*    Shows the actual status of the spi interface. */
/*    Bits 24..18 show occured interrupts, */
/*    writing ones into these bits deletes the interrupts. */
/*    Writing into other bits has no effect. */
/*    In netx50 and later versions both, receive and transmit FIFO have a depth of 16, fill-values are fixed to 4. To keep software */
/*    compatible, not more than 8 bytes should be in netx100/500-FIFOs. */
/* => Mode: R */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX10_spi_status_register        0x00000034U
#define Adr_NX10_spi_motion_spi_status_register 0x101406B4U
#define Adr_NX10_spi_status_register            0x101406B4U

#define MSK_NX10_spi_status_register_SR_in_fuel_val  0x000001ffU
#define SRT_NX10_spi_status_register_SR_in_fuel_val  0
#define MSK_NX10_spi_status_register_SR_out_fuel_val 0x0003fe00U
#define SRT_NX10_spi_status_register_SR_out_fuel_val 9
#define MSK_NX10_spi_status_register_SR_in_fuel      0x00040000U
#define SRT_NX10_spi_status_register_SR_in_fuel      18
#define MSK_NX10_spi_status_register_SR_in_recdata   0x00080000U
#define SRT_NX10_spi_status_register_SR_in_recdata   19
#define MSK_NX10_spi_status_register_SR_in_full      0x00100000U
#define SRT_NX10_spi_status_register_SR_in_full      20
#define MSK_NX10_spi_status_register_SR_out_fuel     0x00200000U
#define SRT_NX10_spi_status_register_SR_out_fuel     21
#define MSK_NX10_spi_status_register_SR_out_fw       0x00400000U
#define SRT_NX10_spi_status_register_SR_out_fw       22
#define MSK_NX10_spi_status_register_SR_out_empty    0x00800000U
#define SRT_NX10_spi_status_register_SR_out_empty    23
#define MSK_NX10_spi_status_register_SR_out_full     0x01000000U
#define SRT_NX10_spi_status_register_SR_out_full     24
#define MSK_NX10_spi_status_register_SR_selected     0x02000000U
#define SRT_NX10_spi_status_register_SR_selected     25

enum {
	BFW_NX10_spi_status_register_SR_in_fuel_val  = 9, /* [8:0] */
	BFW_NX10_spi_status_register_SR_out_fuel_val = 9, /* [17:9] */
	BFW_NX10_spi_status_register_SR_in_fuel      = 1, /* [18] */
	BFW_NX10_spi_status_register_SR_in_recdata   = 1, /* [19] */
	BFW_NX10_spi_status_register_SR_in_full      = 1, /* [20] */
	BFW_NX10_spi_status_register_SR_out_fuel     = 1, /* [21] */
	BFW_NX10_spi_status_register_SR_out_fw       = 1, /* [22] */
	BFW_NX10_spi_status_register_SR_out_empty    = 1, /* [23] */
	BFW_NX10_spi_status_register_SR_out_full     = 1, /* [24] */
	BFW_NX10_spi_status_register_SR_selected     = 1, /* [25] */
	BFW_NX10_spi_status_register_reserved1       = 6  /* [31:26] */
};

typedef struct NX10_SPI_STATUS_REGISTER_BIT_Ttag {
	unsigned int SR_in_fuel_val  : BFW_NX10_spi_status_register_SR_in_fuel_val;  /* input FIFO fill value (number of bytes)                                                              */
	unsigned int SR_out_fuel_val : BFW_NX10_spi_status_register_SR_out_fuel_val; /* output FIFO fill vlaue (number of bytes)                                                             */
	unsigned int SR_in_fuel      : BFW_NX10_spi_status_register_SR_in_fuel;      /* adjustable fill value of input FIFO reached (equals adr_spi_ris.RXRIS in netx50 and later versions)  */
	unsigned int SR_in_recdata   : BFW_NX10_spi_status_register_SR_in_recdata;   /* valid data bytes in input FIFO (equals adr_spi_ris.rxneris in netx50 and later versions)             */
	unsigned int SR_in_full      : BFW_NX10_spi_status_register_SR_in_full;      /* input FIFO is full (equals adr_spi_ris.rxfris in netx50 and later versions)                          */
	unsigned int SR_out_fuel     : BFW_NX10_spi_status_register_SR_out_fuel;     /* adjustable fill value of output FIFO reached (equals adr_spi_ris.TXRIS in netx50 and later versions) */
	unsigned int SR_out_fw       : BFW_NX10_spi_status_register_SR_out_fw;       /* netx is writing data to fast into output FIFO. This is only with netx100/500 an IRQ.                 */
	                                                                             /* (equals adr_spi_sr.tx_fifo_err_ovfl in netx50 and later versions)                                    */
	unsigned int SR_out_empty    : BFW_NX10_spi_status_register_SR_out_empty;    /* output FIFO is empty in slave mode. (equals adr_spi_ris.txeris in netx50 and later versions)         */
	unsigned int SR_out_full     : BFW_NX10_spi_status_register_SR_out_full;     /* output FIFO is full .This is only with netx100/500 an IRQ.                                           */
	unsigned int SR_selected     : BFW_NX10_spi_status_register_SR_selected;     /* external master has access to spi-interface                                                          */
	unsigned int reserved1       : BFW_NX10_spi_status_register_reserved1;       /* reserved                                                                                             */
} NX10_SPI_STATUS_REGISTER_BIT_T;

typedef union {
	unsigned int                   val;
	NX10_SPI_STATUS_REGISTER_BIT_T bf;
} NX10_SPI_STATUS_REGISTER_T;

/* --------------------------------------------------------------------- */
/* Register spi_control_register */
/* => netx100/500 compliant spi control register (CR) */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX10_spi_control_register        0x00000038U
#define Adr_NX10_spi_motion_spi_control_register 0x101406B8U
#define Adr_NX10_spi_control_register            0x101406B8U
#define DFLT_VAL_NX10_spi_control_register       0x00000000U

#define MSK_NX10_spi_control_register_CR_softreset        0x00000001U
#define SRT_NX10_spi_control_register_CR_softreset        0
#define DFLT_VAL_NX10_spi_control_register_CR_softreset   0x00000000U
#define MSK_NX10_spi_control_register_CR_speed            0x0000001eU
#define SRT_NX10_spi_control_register_CR_speed            1
#define DFLT_VAL_NX10_spi_control_register_CR_speed       0x00000000U
#define MSK_NX10_spi_control_register_CR_read             0x00000040U
#define SRT_NX10_spi_control_register_CR_read             6
#define DFLT_VAL_NX10_spi_control_register_CR_read        0x00000000U
#define MSK_NX10_spi_control_register_CR_write            0x00000080U
#define SRT_NX10_spi_control_register_CR_write            7
#define DFLT_VAL_NX10_spi_control_register_CR_write       0x00000000U
#define MSK_NX10_spi_control_register_CR_ss               0x00000700U
#define SRT_NX10_spi_control_register_CR_ss               8
#define DFLT_VAL_NX10_spi_control_register_CR_ss          0x00000000U
#define MSK_NX10_spi_control_register_CS_mode             0x00000800U
#define SRT_NX10_spi_control_register_CS_mode             11
#define DFLT_VAL_NX10_spi_control_register_CS_mode        0x00000000U
#define MSK_NX10_spi_control_register_CR_clr_infifo       0x00100000U
#define SRT_NX10_spi_control_register_CR_clr_infifo       20
#define DFLT_VAL_NX10_spi_control_register_CR_clr_infifo  0x00000000U
#define MSK_NX10_spi_control_register_CR_clr_outfifo      0x00200000U
#define SRT_NX10_spi_control_register_CR_clr_outfifo      21
#define DFLT_VAL_NX10_spi_control_register_CR_clr_outfifo 0x00000000U
#define MSK_NX10_spi_control_register_CR_burstdelay       0x01c00000U
#define SRT_NX10_spi_control_register_CR_burstdelay       22
#define DFLT_VAL_NX10_spi_control_register_CR_burstdelay  0x00000000U
#define MSK_NX10_spi_control_register_CR_burst            0x0e000000U
#define SRT_NX10_spi_control_register_CR_burst            25
#define DFLT_VAL_NX10_spi_control_register_CR_burst       0x00000000U
#define MSK_NX10_spi_control_register_CR_ncpha            0x10000000U
#define SRT_NX10_spi_control_register_CR_ncpha            28
#define DFLT_VAL_NX10_spi_control_register_CR_ncpha       0x00000000U
#define MSK_NX10_spi_control_register_CR_cpol             0x20000000U
#define SRT_NX10_spi_control_register_CR_cpol             29
#define DFLT_VAL_NX10_spi_control_register_CR_cpol        0x00000000U
#define MSK_NX10_spi_control_register_CR_ms               0x40000000U
#define SRT_NX10_spi_control_register_CR_ms               30
#define DFLT_VAL_NX10_spi_control_register_CR_ms          0x00000000U
#define MSK_NX10_spi_control_register_CR_en               0x80000000U
#define SRT_NX10_spi_control_register_CR_en               31
#define DFLT_VAL_NX10_spi_control_register_CR_en          0x00000000U

enum {
	BFW_NX10_spi_control_register_CR_softreset   = 1, /* [0] */
	BFW_NX10_spi_control_register_CR_speed       = 4, /* [4:1] */
	BFW_NX10_spi_control_register_reserved1      = 1, /* [5] */
	BFW_NX10_spi_control_register_CR_read        = 1, /* [6] */
	BFW_NX10_spi_control_register_CR_write       = 1, /* [7] */
	BFW_NX10_spi_control_register_CR_ss          = 3, /* [10:8] */
	BFW_NX10_spi_control_register_CS_mode        = 1, /* [11] */
	BFW_NX10_spi_control_register_reserved2      = 8, /* [19:12] */
	BFW_NX10_spi_control_register_CR_clr_infifo  = 1, /* [20] */
	BFW_NX10_spi_control_register_CR_clr_outfifo = 1, /* [21] */
	BFW_NX10_spi_control_register_CR_burstdelay  = 3, /* [24:22] */
	BFW_NX10_spi_control_register_CR_burst       = 3, /* [27:25] */
	BFW_NX10_spi_control_register_CR_ncpha       = 1, /* [28] */
	BFW_NX10_spi_control_register_CR_cpol        = 1, /* [29] */
	BFW_NX10_spi_control_register_CR_ms          = 1, /* [30] */
	BFW_NX10_spi_control_register_CR_en          = 1  /* [31] */
};

typedef struct NX10_SPI_CONTROL_REGISTER_BIT_Ttag {
	unsigned int CR_softreset   : BFW_NX10_spi_control_register_CR_softreset;   /* write only: no function in netx100/netx500; later Versions: clears IRQs and FIFOs                             */
	unsigned int CR_speed       : BFW_NX10_spi_control_register_CR_speed;       /* clock devider for SPI clock (2 - 2^16)                                                                        */
	                                                                            /* If SPI Clock-rate is changed by adr_spi_cr0.SCR, this value will not be updated an may be incorrect           */
	unsigned int reserved1      : BFW_NX10_spi_control_register_reserved1;      /* reserved                                                                                                      */
	unsigned int CR_read        : BFW_NX10_spi_control_register_CR_read;        /* netx100/netx500 only, in later versions always "1":  1: enable spi interface read data                        */
	unsigned int CR_write       : BFW_NX10_spi_control_register_CR_write;       /* netx100/netx500 only, in later versions always "1":  1: enable spi interface write data                       */
	unsigned int CR_ss          : BFW_NX10_spi_control_register_CR_ss;          /* external slave select                                                                                         */
	unsigned int CS_mode        : BFW_NX10_spi_control_register_CS_mode;        /* 1: chip select is generated automatically by the internal state machine                                       */
	                                                                            /* 0: chip select is directly controlled by software (see bits CR_ss).                                           */
	unsigned int reserved2      : BFW_NX10_spi_control_register_reserved2;      /* reserved                                                                                                      */
	unsigned int CR_clr_infifo  : BFW_NX10_spi_control_register_CR_clr_infifo;  /* clear input FIFO                                                                                              */
	unsigned int CR_clr_outfifo : BFW_NX10_spi_control_register_CR_clr_outfifo; /* clear output FIFO                                                                                             */
	unsigned int CR_burstdelay  : BFW_NX10_spi_control_register_CR_burstdelay;  /* netx100/netx500 only, obsolet in later versions: delay between transmittion of 2 data bytes                   */
	                                                                            /* (0 to 7 SCK cycles)                                                                                           */
	unsigned int CR_burst       : BFW_NX10_spi_control_register_CR_burst;       /* netx100/netx500 only, obsolet in later versions: burst lenght = 2^CR_burst                                    */
	unsigned int CR_ncpha       : BFW_NX10_spi_control_register_CR_ncpha;       /* SPI clock phase mode (Note: meaning of this bit is inverted to functionality of bit SPH in spi_cr0 register): */
	                                                                            /* 0:change data to secondary spi_sck edge                                                                       */
	unsigned int CR_cpol        : BFW_NX10_spi_control_register_CR_cpol;        /* 1:falling edge of spi_sck is primary                                                                          */
	                                                                            /* 0:rising edge of spi_sck is primary                                                                           */
	unsigned int CR_ms          : BFW_NX10_spi_control_register_CR_ms;          /* 1:master mode 0:slave mode                                                                                    */
	unsigned int CR_en          : BFW_NX10_spi_control_register_CR_en;          /* 1:enable 0:disable spi interface                                                                              */
} NX10_SPI_CONTROL_REGISTER_BIT_T;

typedef union {
	unsigned int                    val;
	NX10_SPI_CONTROL_REGISTER_BIT_T bf;
} NX10_SPI_CONTROL_REGISTER_T;

/* --------------------------------------------------------------------- */
/* Register spi_interrupt_control_register */
/* => netx100/500 compliant spi interrupt control register (IR) */
/*    In netx50 and later versions both, receive and transmit FIFO have a depth of 16, fill-values are fixed to 4. To keep software */
/*    compatible, not more than 8 bytes should be in netx100/500-FIFOs. */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX10_spi_interrupt_control_register        0x0000003CU
#define Adr_NX10_spi_motion_spi_interrupt_control_register 0x101406BCU
#define Adr_NX10_spi_interrupt_control_register            0x101406BCU
#define DFLT_VAL_NX10_spi_interrupt_control_register       0x00000000U

#define MSK_NX10_spi_interrupt_control_register_IR_in_fuel            0x000001ffU
#define SRT_NX10_spi_interrupt_control_register_IR_in_fuel            0
#define DFLT_VAL_NX10_spi_interrupt_control_register_IR_in_fuel       0x00000000U
#define MSK_NX10_spi_interrupt_control_register_IR_out_fuel           0x0003fe00U
#define SRT_NX10_spi_interrupt_control_register_IR_out_fuel           9
#define DFLT_VAL_NX10_spi_interrupt_control_register_IR_out_fuel      0x00000000U
#define MSK_NX10_spi_interrupt_control_register_IR_in_fuel_en         0x00040000U
#define SRT_NX10_spi_interrupt_control_register_IR_in_fuel_en         18
#define DFLT_VAL_NX10_spi_interrupt_control_register_IR_in_fuel_en    0x00000000U
#define MSK_NX10_spi_interrupt_control_register_IR_in_recdata_en      0x00080000U
#define SRT_NX10_spi_interrupt_control_register_IR_in_recdata_en      19
#define DFLT_VAL_NX10_spi_interrupt_control_register_IR_in_recdata_en 0x00000000U
#define MSK_NX10_spi_interrupt_control_register_IR_in_full_en         0x00100000U
#define SRT_NX10_spi_interrupt_control_register_IR_in_full_en         20
#define DFLT_VAL_NX10_spi_interrupt_control_register_IR_in_full_en    0x00000000U
#define MSK_NX10_spi_interrupt_control_register_IR_out_fuel_en        0x00200000U
#define SRT_NX10_spi_interrupt_control_register_IR_out_fuel_en        21
#define DFLT_VAL_NX10_spi_interrupt_control_register_IR_out_fuel_en   0x00000000U
#define MSK_NX10_spi_interrupt_control_register_IR_out_fw_en          0x00400000U
#define SRT_NX10_spi_interrupt_control_register_IR_out_fw_en          22
#define DFLT_VAL_NX10_spi_interrupt_control_register_IR_out_fw_en     0x00000000U
#define MSK_NX10_spi_interrupt_control_register_IR_out_empty_en       0x00800000U
#define SRT_NX10_spi_interrupt_control_register_IR_out_empty_en       23
#define DFLT_VAL_NX10_spi_interrupt_control_register_IR_out_empty_en  0x00000000U
#define MSK_NX10_spi_interrupt_control_register_IR_out_full_en        0x01000000U
#define SRT_NX10_spi_interrupt_control_register_IR_out_full_en        24
#define DFLT_VAL_NX10_spi_interrupt_control_register_IR_out_full_en   0x00000000U

enum {
	BFW_NX10_spi_interrupt_control_register_IR_in_fuel       = 9, /* [8:0] */
	BFW_NX10_spi_interrupt_control_register_IR_out_fuel      = 9, /* [17:9] */
	BFW_NX10_spi_interrupt_control_register_IR_in_fuel_en    = 1, /* [18] */
	BFW_NX10_spi_interrupt_control_register_IR_in_recdata_en = 1, /* [19] */
	BFW_NX10_spi_interrupt_control_register_IR_in_full_en    = 1, /* [20] */
	BFW_NX10_spi_interrupt_control_register_IR_out_fuel_en   = 1, /* [21] */
	BFW_NX10_spi_interrupt_control_register_IR_out_fw_en     = 1, /* [22] */
	BFW_NX10_spi_interrupt_control_register_IR_out_empty_en  = 1, /* [23] */
	BFW_NX10_spi_interrupt_control_register_IR_out_full_en   = 1, /* [24] */
	BFW_NX10_spi_interrupt_control_register_reserved1        = 7  /* [31:25] */
};

typedef struct NX10_SPI_INTERRUPT_CONTROL_REGISTER_BIT_Ttag {
	unsigned int IR_in_fuel       : BFW_NX10_spi_interrupt_control_register_IR_in_fuel;       /* adjustable watermark level of input FIFO                                             */
	unsigned int IR_out_fuel      : BFW_NX10_spi_interrupt_control_register_IR_out_fuel;      /* adjustable watermark level of output FIFO                                            */
	unsigned int IR_in_fuel_en    : BFW_NX10_spi_interrupt_control_register_IR_in_fuel_en;    /* IRQ enable for irq_spi(0)  (equals adr_spi_imsc.RXIM in netx50 and later versions)   */
	unsigned int IR_in_recdata_en : BFW_NX10_spi_interrupt_control_register_IR_in_recdata_en; /* IRQ enable for irq_spi(1)  (equals adr_spi_imsc.txneim in netx50 and later versions) */
	unsigned int IR_in_full_en    : BFW_NX10_spi_interrupt_control_register_IR_in_full_en;    /* IRQ enable for irq_spi(2)  (equals adr_spi_imsc.txfim in netx50 and later versions)  */
	unsigned int IR_out_fuel_en   : BFW_NX10_spi_interrupt_control_register_IR_out_fuel_en;   /* IRQ enable for irq_spi(3)  (equals adr_spi_imsc.TXIM in netx50 and later versions)   */
	unsigned int IR_out_fw_en     : BFW_NX10_spi_interrupt_control_register_IR_out_fw_en;     /* IRQ enable for irq_spi(4), netx100/netx500 only, always "0" in later versions        */
	unsigned int IR_out_empty_en  : BFW_NX10_spi_interrupt_control_register_IR_out_empty_en;  /* IRQ enable for irq_spi(5)  (equals adr_spi_imsc.rxeim in netx50 and later versions)  */
	unsigned int IR_out_full_en   : BFW_NX10_spi_interrupt_control_register_IR_out_full_en;   /* IRQ enable for irq_spi(6), netx100/netx500 only, always "0" in later versions        */
	unsigned int reserved1        : BFW_NX10_spi_interrupt_control_register_reserved1;        /* reserved                                                                             */
} NX10_SPI_INTERRUPT_CONTROL_REGISTER_BIT_T;

typedef union {
	unsigned int                              val;
	NX10_SPI_INTERRUPT_CONTROL_REGISTER_BIT_T bf;
} NX10_SPI_INTERRUPT_CONTROL_REGISTER_T;


/* ===================================================================== */

/* Area of adc_ctrl */

/* ===================================================================== */

#define Addr_NX10_adc_ctrl 0x101406C0U

/* --------------------------------------------------------------------- */
/* Register adc_ctrl_start */
/* => ADC config register: */
/*    This register is writable but can also be changed by hardware (reset). */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX10_adc_ctrl_start      0x00000000U
#define Adr_NX10_adc_ctrl_adc_ctrl_start 0x101406C0U
#define Adr_NX10_adc_ctrl_start          0x101406C0U
#define DFLT_VAL_NX10_adc_ctrl_start     0x00000000U

#define MSK_NX10_adc_ctrl_start_start_adc0      0x00000001U
#define SRT_NX10_adc_ctrl_start_start_adc0      0
#define DFLT_VAL_NX10_adc_ctrl_start_start_adc0 0x00000000U
#define MSK_NX10_adc_ctrl_start_start_adc1      0x00000002U
#define SRT_NX10_adc_ctrl_start_start_adc1      1
#define DFLT_VAL_NX10_adc_ctrl_start_start_adc1 0x00000000U

enum {
	BFW_NX10_adc_ctrl_start_start_adc0 = 1,  /* [0] */
	BFW_NX10_adc_ctrl_start_start_adc1 = 1,  /* [1] */
	BFW_NX10_adc_ctrl_start_reserved1  = 30  /* [31:2] */
};

typedef struct NX10_ADC_CTRL_START_BIT_Ttag {
	unsigned int start_adc0 : BFW_NX10_adc_ctrl_start_start_adc0; /* Start ADC0:                                                     */
	                                                              /* Setting this bit to 1 starts ADC control state machine for ADC0 */
	unsigned int start_adc1 : BFW_NX10_adc_ctrl_start_start_adc1; /* Start ADC1:                                                     */
	                                                              /* Setting this bit to 1 starts ADC control state machine for ADC1 */
	unsigned int reserved1  : BFW_NX10_adc_ctrl_start_reserved1;  /* reserved                                                        */
} NX10_ADC_CTRL_START_BIT_T;

typedef union {
	unsigned int              val;
	NX10_ADC_CTRL_START_BIT_T bf;
} NX10_ADC_CTRL_START_T;

/* --------------------------------------------------------------------- */
/* Register adc_ctrl_autosample_config0 */
/* => ADC config register for ADC autosample state machine: */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX10_adc_ctrl_autosample_config0      0x00000004U
#define Adr_NX10_adc_ctrl_adc_ctrl_autosample_config0 0x101406C4U
#define Adr_NX10_adc_ctrl_autosample_config0          0x101406C4U
#define DFLT_VAL_NX10_adc_ctrl_autosample_config0     0x00000000U

#define MSK_NX10_adc_ctrl_autosample_config0_sel             0x00000007U
#define SRT_NX10_adc_ctrl_autosample_config0_sel             0
#define DFLT_VAL_NX10_adc_ctrl_autosample_config0_sel        0x00000000U
#define MSK_NX10_adc_ctrl_autosample_config0_power_down      0x00000008U
#define SRT_NX10_adc_ctrl_autosample_config0_power_down      3
#define DFLT_VAL_NX10_adc_ctrl_autosample_config0_power_down 0x00000000U
#define MSK_NX10_adc_ctrl_autosample_config0_event_inv       0x00000010U
#define SRT_NX10_adc_ctrl_autosample_config0_event_inv       4
#define DFLT_VAL_NX10_adc_ctrl_autosample_config0_event_inv  0x00000000U
#define MSK_NX10_adc_ctrl_autosample_config0_event_sel       0x000003e0U
#define SRT_NX10_adc_ctrl_autosample_config0_event_sel       5
#define DFLT_VAL_NX10_adc_ctrl_autosample_config0_event_sel  0x00000000U

enum {
	BFW_NX10_adc_ctrl_autosample_config0_sel        = 3,  /* [2:0] */
	BFW_NX10_adc_ctrl_autosample_config0_power_down = 1,  /* [3] */
	BFW_NX10_adc_ctrl_autosample_config0_event_inv  = 1,  /* [4] */
	BFW_NX10_adc_ctrl_autosample_config0_event_sel  = 5,  /* [9:5] */
	BFW_NX10_adc_ctrl_autosample_config0_reserved1  = 22  /* [31:10] */
};

typedef struct NX10_ADC_CTRL_AUTOSAMPLE_CONFIG0_BIT_Ttag {
	unsigned int sel        : BFW_NX10_adc_ctrl_autosample_config0_sel;        /* Select for analog multiplexer of ADC0:      */
	                                                                           /* 000: Sample from analog pin AD0_IN0         */
	unsigned int power_down : BFW_NX10_adc_ctrl_autosample_config0_power_down; /* Power-down mode:                            */
	                                                                           /* 0: leave power of ADC active after sampling */
	unsigned int event_inv  : BFW_NX10_adc_ctrl_autosample_config0_event_inv;  /* Invert AD-conversion start signal           */
	                                                                           /* 0: positive edge                            */
	unsigned int event_sel  : BFW_NX10_adc_ctrl_autosample_config0_event_sel;  /* Select for AD-conversion start signal:      */
	                                                                           /* 0 : start immediately                       */
	unsigned int reserved1  : BFW_NX10_adc_ctrl_autosample_config0_reserved1;  /* reserved                                    */
} NX10_ADC_CTRL_AUTOSAMPLE_CONFIG0_BIT_T;

typedef union {
	unsigned int                           val;
	NX10_ADC_CTRL_AUTOSAMPLE_CONFIG0_BIT_T bf;
} NX10_ADC_CTRL_AUTOSAMPLE_CONFIG0_T;

/* --------------------------------------------------------------------- */
/* Register adc_ctrl_autosample_config1 */
/* => ADC config register for ADC autosample state machine: */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX10_adc_ctrl_autosample_config1      0x00000008U
#define Adr_NX10_adc_ctrl_adc_ctrl_autosample_config1 0x101406C8U
#define Adr_NX10_adc_ctrl_autosample_config1          0x101406C8U
#define DFLT_VAL_NX10_adc_ctrl_autosample_config1     0x00000000U

#define MSK_NX10_adc_ctrl_autosample_config1_sel             0x00000007U
#define SRT_NX10_adc_ctrl_autosample_config1_sel             0
#define DFLT_VAL_NX10_adc_ctrl_autosample_config1_sel        0x00000000U
#define MSK_NX10_adc_ctrl_autosample_config1_power_down      0x00000008U
#define SRT_NX10_adc_ctrl_autosample_config1_power_down      3
#define DFLT_VAL_NX10_adc_ctrl_autosample_config1_power_down 0x00000000U
#define MSK_NX10_adc_ctrl_autosample_config1_event_inv       0x00000010U
#define SRT_NX10_adc_ctrl_autosample_config1_event_inv       4
#define DFLT_VAL_NX10_adc_ctrl_autosample_config1_event_inv  0x00000000U
#define MSK_NX10_adc_ctrl_autosample_config1_event_sel       0x000003e0U
#define SRT_NX10_adc_ctrl_autosample_config1_event_sel       5
#define DFLT_VAL_NX10_adc_ctrl_autosample_config1_event_sel  0x00000000U

enum {
	BFW_NX10_adc_ctrl_autosample_config1_sel        = 3,  /* [2:0] */
	BFW_NX10_adc_ctrl_autosample_config1_power_down = 1,  /* [3] */
	BFW_NX10_adc_ctrl_autosample_config1_event_inv  = 1,  /* [4] */
	BFW_NX10_adc_ctrl_autosample_config1_event_sel  = 5,  /* [9:5] */
	BFW_NX10_adc_ctrl_autosample_config1_reserved1  = 22  /* [31:10] */
};

typedef struct NX10_ADC_CTRL_AUTOSAMPLE_CONFIG1_BIT_Ttag {
	unsigned int sel        : BFW_NX10_adc_ctrl_autosample_config1_sel;        /* Select for analog multiplexer of ADC1:      */
	                                                                           /* 000: Sample from analog pin AD1_IN0         */
	unsigned int power_down : BFW_NX10_adc_ctrl_autosample_config1_power_down; /* Power-down mode:                            */
	                                                                           /* 0: leave power of ADC active after sampling */
	unsigned int event_inv  : BFW_NX10_adc_ctrl_autosample_config1_event_inv;  /* Invert AD-conversion start signal           */
	                                                                           /* 0: positive edge                            */
	unsigned int event_sel  : BFW_NX10_adc_ctrl_autosample_config1_event_sel;  /* Select for AD-conversion start signal:      */
	                                                                           /* 0 : start immediately                       */
	unsigned int reserved1  : BFW_NX10_adc_ctrl_autosample_config1_reserved1;  /* reserved                                    */
} NX10_ADC_CTRL_AUTOSAMPLE_CONFIG1_BIT_T;

typedef union {
	unsigned int                           val;
	NX10_ADC_CTRL_AUTOSAMPLE_CONFIG1_BIT_T bf;
} NX10_ADC_CTRL_AUTOSAMPLE_CONFIG1_T;

/* --------------------------------------------------------------------- */
/* Register adc_ctrl_mansample_config0 */
/* => ADC config register for direct ADC control: */
/*    This register is writable but can also be changed by hardware. */
/*    It must not be written, when ADC autosample state machine is active (irq_raw-adc0_finish=0) */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX10_adc_ctrl_mansample_config0      0x0000000CU
#define Adr_NX10_adc_ctrl_adc_ctrl_mansample_config0 0x101406CCU
#define Adr_NX10_adc_ctrl_mansample_config0          0x101406CCU
#define DFLT_VAL_NX10_adc_ctrl_mansample_config0     0x00000000U

#define MSK_NX10_adc_ctrl_mansample_config0_sel       0x00000007U
#define SRT_NX10_adc_ctrl_mansample_config0_sel       0
#define DFLT_VAL_NX10_adc_ctrl_mansample_config0_sel  0x00000000U
#define MSK_NX10_adc_ctrl_mansample_config0_pdb       0x00000008U
#define SRT_NX10_adc_ctrl_mansample_config0_pdb       3
#define DFLT_VAL_NX10_adc_ctrl_mansample_config0_pdb  0x00000000U
#define MSK_NX10_adc_ctrl_mansample_config0_conv      0x00000010U
#define SRT_NX10_adc_ctrl_mansample_config0_conv      4
#define DFLT_VAL_NX10_adc_ctrl_mansample_config0_conv 0x00000000U

enum {
	BFW_NX10_adc_ctrl_mansample_config0_sel       = 3,  /* [2:0] */
	BFW_NX10_adc_ctrl_mansample_config0_pdb       = 1,  /* [3] */
	BFW_NX10_adc_ctrl_mansample_config0_conv      = 1,  /* [4] */
	BFW_NX10_adc_ctrl_mansample_config0_reserved1 = 27  /* [31:5] */
};

typedef struct NX10_ADC_CTRL_MANSAMPLE_CONFIG0_BIT_Ttag {
	unsigned int sel       : BFW_NX10_adc_ctrl_mansample_config0_sel;       /* Select for analog multiplexer of ADC0:                                        */
	                                                                        /* 000: Sample from analog pin AD0_IN0                                           */
	unsigned int pdb       : BFW_NX10_adc_ctrl_mansample_config0_pdb;       /* Power-down pin:                                                               */
	                                                                        /* 1: Operation mode                                                             */
	unsigned int conv      : BFW_NX10_adc_ctrl_mansample_config0_conv;      /* AD-conversion start pin:                                                      */
	                                                                        /* AD-conversion is started by setting this bit to 1 (with next edge of adcclk). */
	unsigned int reserved1 : BFW_NX10_adc_ctrl_mansample_config0_reserved1; /* reserved                                                                      */
} NX10_ADC_CTRL_MANSAMPLE_CONFIG0_BIT_T;

typedef union {
	unsigned int                          val;
	NX10_ADC_CTRL_MANSAMPLE_CONFIG0_BIT_T bf;
} NX10_ADC_CTRL_MANSAMPLE_CONFIG0_T;

/* --------------------------------------------------------------------- */
/* Register adc_ctrl_mansample_config1 */
/* => ADC config register for direct ADC control: */
/*    This register is writable but can also be changed by hardware. */
/*    It must not be written, when ADC autosample state machine is active (irq_raw-adc0_finish=0) */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX10_adc_ctrl_mansample_config1      0x00000010U
#define Adr_NX10_adc_ctrl_adc_ctrl_mansample_config1 0x101406D0U
#define Adr_NX10_adc_ctrl_mansample_config1          0x101406D0U
#define DFLT_VAL_NX10_adc_ctrl_mansample_config1     0x00000000U

#define MSK_NX10_adc_ctrl_mansample_config1_sel       0x00000007U
#define SRT_NX10_adc_ctrl_mansample_config1_sel       0
#define DFLT_VAL_NX10_adc_ctrl_mansample_config1_sel  0x00000000U
#define MSK_NX10_adc_ctrl_mansample_config1_pdb       0x00000008U
#define SRT_NX10_adc_ctrl_mansample_config1_pdb       3
#define DFLT_VAL_NX10_adc_ctrl_mansample_config1_pdb  0x00000000U
#define MSK_NX10_adc_ctrl_mansample_config1_conv      0x00000010U
#define SRT_NX10_adc_ctrl_mansample_config1_conv      4
#define DFLT_VAL_NX10_adc_ctrl_mansample_config1_conv 0x00000000U

enum {
	BFW_NX10_adc_ctrl_mansample_config1_sel       = 3,  /* [2:0] */
	BFW_NX10_adc_ctrl_mansample_config1_pdb       = 1,  /* [3] */
	BFW_NX10_adc_ctrl_mansample_config1_conv      = 1,  /* [4] */
	BFW_NX10_adc_ctrl_mansample_config1_reserved1 = 27  /* [31:5] */
};

typedef struct NX10_ADC_CTRL_MANSAMPLE_CONFIG1_BIT_Ttag {
	unsigned int sel       : BFW_NX10_adc_ctrl_mansample_config1_sel;       /* Select for analog multiplexer of ADC1:                                        */
	                                                                        /* 000: Sample from analog pin AD1_IN0                                           */
	unsigned int pdb       : BFW_NX10_adc_ctrl_mansample_config1_pdb;       /* Power-down pin:                                                               */
	                                                                        /* 1: Operation mode                                                             */
	unsigned int conv      : BFW_NX10_adc_ctrl_mansample_config1_conv;      /* AD-conversion start pin:                                                      */
	                                                                        /* AD-conversion is started by setting this bit to 1 (with next edge of adcclk). */
	unsigned int reserved1 : BFW_NX10_adc_ctrl_mansample_config1_reserved1; /* reserved                                                                      */
} NX10_ADC_CTRL_MANSAMPLE_CONFIG1_BIT_T;

typedef union {
	unsigned int                          val;
	NX10_ADC_CTRL_MANSAMPLE_CONFIG1_BIT_T bf;
} NX10_ADC_CTRL_MANSAMPLE_CONFIG1_T;

/* --------------------------------------------------------------------- */
/* Register adc_ctrl_status */
/* => ADC status register: */
/* => Mode: R */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX10_adc_ctrl_status      0x00000014U
#define Adr_NX10_adc_ctrl_adc_ctrl_status 0x101406D4U
#define Adr_NX10_adc_ctrl_status          0x101406D4U

#define MSK_NX10_adc_ctrl_status_adc0_eocb   0x00000001U
#define SRT_NX10_adc_ctrl_status_adc0_eocb   0
#define MSK_NX10_adc_ctrl_status_adc1_eocb   0x00000002U
#define SRT_NX10_adc_ctrl_status_adc1_eocb   1
#define MSK_NX10_adc_ctrl_status_adc0_finish 0x00000004U
#define SRT_NX10_adc_ctrl_status_adc0_finish 2
#define MSK_NX10_adc_ctrl_status_adc1_finish 0x00000008U
#define SRT_NX10_adc_ctrl_status_adc1_finish 3
#define MSK_NX10_adc_ctrl_status_adcclk      0x00000010U
#define SRT_NX10_adc_ctrl_status_adcclk      4

enum {
	BFW_NX10_adc_ctrl_status_adc0_eocb   = 1,  /* [0] */
	BFW_NX10_adc_ctrl_status_adc1_eocb   = 1,  /* [1] */
	BFW_NX10_adc_ctrl_status_adc0_finish = 1,  /* [2] */
	BFW_NX10_adc_ctrl_status_adc1_finish = 1,  /* [3] */
	BFW_NX10_adc_ctrl_status_adcclk      = 1,  /* [4] */
	BFW_NX10_adc_ctrl_status_reserved1   = 27  /* [31:5] */
};

typedef struct NX10_ADC_CTRL_STATUS_BIT_Ttag {
	unsigned int adc0_eocb   : BFW_NX10_adc_ctrl_status_adc0_eocb;   /* EOCB signal of ADC0                        */
	unsigned int adc1_eocb   : BFW_NX10_adc_ctrl_status_adc1_eocb;   /* EOCB signal of ADC1                        */
	unsigned int adc0_finish : BFW_NX10_adc_ctrl_status_adc0_finish; /* ADC0 is finished (not sampling any data)   */
	unsigned int adc1_finish : BFW_NX10_adc_ctrl_status_adc1_finish; /* ADC1 is finished (not sampling any data)   */
	unsigned int adcclk      : BFW_NX10_adc_ctrl_status_adcclk;      /* sampled adcclk (16MHz), used for both ADCs */
	unsigned int reserved1   : BFW_NX10_adc_ctrl_status_reserved1;   /* reserved                                   */
} NX10_ADC_CTRL_STATUS_BIT_T;

typedef union {
	unsigned int               val;
	NX10_ADC_CTRL_STATUS_BIT_T bf;
} NX10_ADC_CTRL_STATUS_T;

/* --------------------------------------------------------------------- */
/* Register adc_ctrl_adc0_val */
/* => ADC0 value */
/* => Mode: R */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX10_adc_ctrl_adc0_val      0x00000018U
#define Adr_NX10_adc_ctrl_adc_ctrl_adc0_val 0x101406D8U
#define Adr_NX10_adc_ctrl_adc0_val          0x101406D8U

#define MSK_NX10_adc_ctrl_adc0_val_val 0x000003ffU
#define SRT_NX10_adc_ctrl_adc0_val_val 0

enum {
	BFW_NX10_adc_ctrl_adc0_val_val       = 10, /* [9:0] */
	BFW_NX10_adc_ctrl_adc0_val_reserved1 = 22  /* [31:10] */
};

typedef struct NX10_ADC_CTRL_ADC0_VAL_BIT_Ttag {
	unsigned int val       : BFW_NX10_adc_ctrl_adc0_val_val;       /* Sampled value, changed with posedge of irq_raw-adc0_finish */
	unsigned int reserved1 : BFW_NX10_adc_ctrl_adc0_val_reserved1; /* reserved                                                   */
} NX10_ADC_CTRL_ADC0_VAL_BIT_T;

typedef union {
	unsigned int                 val;
	NX10_ADC_CTRL_ADC0_VAL_BIT_T bf;
} NX10_ADC_CTRL_ADC0_VAL_T;

/* --------------------------------------------------------------------- */
/* Register adc_ctrl_adc1_val */
/* => ADC1 value */
/* => Mode: R */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX10_adc_ctrl_adc1_val      0x0000001CU
#define Adr_NX10_adc_ctrl_adc_ctrl_adc1_val 0x101406DCU
#define Adr_NX10_adc_ctrl_adc1_val          0x101406DCU

#define MSK_NX10_adc_ctrl_adc1_val_val 0x000003ffU
#define SRT_NX10_adc_ctrl_adc1_val_val 0

enum {
	BFW_NX10_adc_ctrl_adc1_val_val       = 10, /* [9:0] */
	BFW_NX10_adc_ctrl_adc1_val_reserved1 = 22  /* [31:10] */
};

typedef struct NX10_ADC_CTRL_ADC1_VAL_BIT_Ttag {
	unsigned int val       : BFW_NX10_adc_ctrl_adc1_val_val;       /* Sampled value, changed with posedge of irq_raw-adc1_finish */
	unsigned int reserved1 : BFW_NX10_adc_ctrl_adc1_val_reserved1; /* reserved                                                   */
} NX10_ADC_CTRL_ADC1_VAL_BIT_T;

typedef union {
	unsigned int                 val;
	NX10_ADC_CTRL_ADC1_VAL_BIT_T bf;
} NX10_ADC_CTRL_ADC1_VAL_T;

/* --------------------------------------------------------------------- */
/* Register adc_ctrl_irq_raw */
/* => ADC_CTRL Raw IRQ register */
/*    Read access shows status of unmasked IRQs */
/*    Write access with 1 resets the appropriate interrupt bit */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX10_adc_ctrl_irq_raw      0x00000020U
#define Adr_NX10_adc_ctrl_adc_ctrl_irq_raw 0x101406E0U
#define Adr_NX10_adc_ctrl_irq_raw          0x101406E0U
#define DFLT_VAL_NX10_adc_ctrl_irq_raw     0x00000000U

#define MSK_NX10_adc_ctrl_irq_raw_adc0_finish       0x00000001U
#define SRT_NX10_adc_ctrl_irq_raw_adc0_finish       0
#define DFLT_VAL_NX10_adc_ctrl_irq_raw_adc0_finish  0x00000000U
#define MSK_NX10_adc_ctrl_irq_raw_adc1_finish       0x00000002U
#define SRT_NX10_adc_ctrl_irq_raw_adc1_finish       1
#define DFLT_VAL_NX10_adc_ctrl_irq_raw_adc1_finish  0x00000000U
#define MSK_NX10_adc_ctrl_irq_raw_start_adc0_n      0x00000004U
#define SRT_NX10_adc_ctrl_irq_raw_start_adc0_n      2
#define DFLT_VAL_NX10_adc_ctrl_irq_raw_start_adc0_n 0x00000000U
#define MSK_NX10_adc_ctrl_irq_raw_start_adc1_n      0x00000008U
#define SRT_NX10_adc_ctrl_irq_raw_start_adc1_n      3
#define DFLT_VAL_NX10_adc_ctrl_irq_raw_start_adc1_n 0x00000000U

enum {
	BFW_NX10_adc_ctrl_irq_raw_adc0_finish  = 1,  /* [0] */
	BFW_NX10_adc_ctrl_irq_raw_adc1_finish  = 1,  /* [1] */
	BFW_NX10_adc_ctrl_irq_raw_start_adc0_n = 1,  /* [2] */
	BFW_NX10_adc_ctrl_irq_raw_start_adc1_n = 1,  /* [3] */
	BFW_NX10_adc_ctrl_irq_raw_reserved1    = 28  /* [31:4] */
};

typedef struct NX10_ADC_CTRL_IRQ_RAW_BIT_Ttag {
	unsigned int adc0_finish  : BFW_NX10_adc_ctrl_irq_raw_adc0_finish;  /* ADC0 finished sampling                                                            */
	unsigned int adc1_finish  : BFW_NX10_adc_ctrl_irq_raw_adc1_finish;  /* ADC1 finished sampling                                                            */
	unsigned int start_adc0_n : BFW_NX10_adc_ctrl_irq_raw_start_adc0_n; /* ADC0 start bit has returned to 0, i.e. ADC0 can be programmed for next conversion */
	unsigned int start_adc1_n : BFW_NX10_adc_ctrl_irq_raw_start_adc1_n; /* ADC1 start bit has returned to 0, i.e. ADC1 can be programmed for next conversion */
	unsigned int reserved1    : BFW_NX10_adc_ctrl_irq_raw_reserved1;    /* reserved                                                                          */
} NX10_ADC_CTRL_IRQ_RAW_BIT_T;

typedef union {
	unsigned int                val;
	NX10_ADC_CTRL_IRQ_RAW_BIT_T bf;
} NX10_ADC_CTRL_IRQ_RAW_T;

/* --------------------------------------------------------------------- */
/* Register adc_ctrl_irq_masked */
/* => ADC_CTRL Masked IRQ register */
/*    Shows status of masked IRQs (as connected to ARM/xPIC) */
/* => Mode: R */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX10_adc_ctrl_irq_masked      0x00000024U
#define Adr_NX10_adc_ctrl_adc_ctrl_irq_masked 0x101406E4U
#define Adr_NX10_adc_ctrl_irq_masked          0x101406E4U

#define MSK_NX10_adc_ctrl_irq_masked_adc0_finish  0x00000001U
#define SRT_NX10_adc_ctrl_irq_masked_adc0_finish  0
#define MSK_NX10_adc_ctrl_irq_masked_adc1_finish  0x00000002U
#define SRT_NX10_adc_ctrl_irq_masked_adc1_finish  1
#define MSK_NX10_adc_ctrl_irq_masked_start_adc0_n 0x00000004U
#define SRT_NX10_adc_ctrl_irq_masked_start_adc0_n 2
#define MSK_NX10_adc_ctrl_irq_masked_start_adc1_n 0x00000008U
#define SRT_NX10_adc_ctrl_irq_masked_start_adc1_n 3

enum {
	BFW_NX10_adc_ctrl_irq_masked_adc0_finish  = 1,  /* [0] */
	BFW_NX10_adc_ctrl_irq_masked_adc1_finish  = 1,  /* [1] */
	BFW_NX10_adc_ctrl_irq_masked_start_adc0_n = 1,  /* [2] */
	BFW_NX10_adc_ctrl_irq_masked_start_adc1_n = 1,  /* [3] */
	BFW_NX10_adc_ctrl_irq_masked_reserved1    = 28  /* [31:4] */
};

typedef struct NX10_ADC_CTRL_IRQ_MASKED_BIT_Ttag {
	unsigned int adc0_finish  : BFW_NX10_adc_ctrl_irq_masked_adc0_finish;  /* ADC0 finished sampling                                                            */
	unsigned int adc1_finish  : BFW_NX10_adc_ctrl_irq_masked_adc1_finish;  /* ADC1 finished sampling                                                            */
	unsigned int start_adc0_n : BFW_NX10_adc_ctrl_irq_masked_start_adc0_n; /* ADC0 start bit has returned to 0, i.e. ADC0 can be programmed for next conversion */
	unsigned int start_adc1_n : BFW_NX10_adc_ctrl_irq_masked_start_adc1_n; /* ADC1 start bit has returned to 0, i.e. ADC1 can be programmed for next conversion */
	unsigned int reserved1    : BFW_NX10_adc_ctrl_irq_masked_reserved1;    /* reserved                                                                          */
} NX10_ADC_CTRL_IRQ_MASKED_BIT_T;

typedef union {
	unsigned int                   val;
	NX10_ADC_CTRL_IRQ_MASKED_BIT_T bf;
} NX10_ADC_CTRL_IRQ_MASKED_T;

/* --------------------------------------------------------------------- */
/* Register adc_ctrl_irq_msk_set */
/* => ADC_CTRL interrupt mask enable: */
/*    Write access with '1' sets interrupt mask bit (enables interrupt request for corresponding interrupt source) */
/*    Write access with '0' does not influence this bit */
/*    Read access shows actual interrupt mask */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX10_adc_ctrl_irq_msk_set      0x00000028U
#define Adr_NX10_adc_ctrl_adc_ctrl_irq_msk_set 0x101406E8U
#define Adr_NX10_adc_ctrl_irq_msk_set          0x101406E8U
#define DFLT_VAL_NX10_adc_ctrl_irq_msk_set     0x00000000U

#define MSK_NX10_adc_ctrl_irq_msk_set_adc0_finish       0x00000001U
#define SRT_NX10_adc_ctrl_irq_msk_set_adc0_finish       0
#define DFLT_VAL_NX10_adc_ctrl_irq_msk_set_adc0_finish  0x00000000U
#define MSK_NX10_adc_ctrl_irq_msk_set_adc1_finish       0x00000002U
#define SRT_NX10_adc_ctrl_irq_msk_set_adc1_finish       1
#define DFLT_VAL_NX10_adc_ctrl_irq_msk_set_adc1_finish  0x00000000U
#define MSK_NX10_adc_ctrl_irq_msk_set_start_adc0_n      0x00000004U
#define SRT_NX10_adc_ctrl_irq_msk_set_start_adc0_n      2
#define DFLT_VAL_NX10_adc_ctrl_irq_msk_set_start_adc0_n 0x00000000U
#define MSK_NX10_adc_ctrl_irq_msk_set_start_adc1_n      0x00000008U
#define SRT_NX10_adc_ctrl_irq_msk_set_start_adc1_n      3
#define DFLT_VAL_NX10_adc_ctrl_irq_msk_set_start_adc1_n 0x00000000U

enum {
	BFW_NX10_adc_ctrl_irq_msk_set_adc0_finish  = 1,  /* [0] */
	BFW_NX10_adc_ctrl_irq_msk_set_adc1_finish  = 1,  /* [1] */
	BFW_NX10_adc_ctrl_irq_msk_set_start_adc0_n = 1,  /* [2] */
	BFW_NX10_adc_ctrl_irq_msk_set_start_adc1_n = 1,  /* [3] */
	BFW_NX10_adc_ctrl_irq_msk_set_reserved1    = 28  /* [31:4] */
};

typedef struct NX10_ADC_CTRL_IRQ_MSK_SET_BIT_Ttag {
	unsigned int adc0_finish  : BFW_NX10_adc_ctrl_irq_msk_set_adc0_finish;  /* ADC0 finished sampling                                                            */
	unsigned int adc1_finish  : BFW_NX10_adc_ctrl_irq_msk_set_adc1_finish;  /* ADC1 finished sampling                                                            */
	unsigned int start_adc0_n : BFW_NX10_adc_ctrl_irq_msk_set_start_adc0_n; /* ADC0 start bit has returned to 0, i.e. ADC0 can be programmed for next conversion */
	unsigned int start_adc1_n : BFW_NX10_adc_ctrl_irq_msk_set_start_adc1_n; /* ADC1 start bit has returned to 0, i.e. ADC1 can be programmed for next conversion */
	unsigned int reserved1    : BFW_NX10_adc_ctrl_irq_msk_set_reserved1;    /* reserved                                                                          */
} NX10_ADC_CTRL_IRQ_MSK_SET_BIT_T;

typedef union {
	unsigned int                    val;
	NX10_ADC_CTRL_IRQ_MSK_SET_BIT_T bf;
} NX10_ADC_CTRL_IRQ_MSK_SET_T;

/* --------------------------------------------------------------------- */
/* Register adc_ctrl_irq_msk_reset */
/* => ADC_CTRL interrupt mask disable: */
/*    Write access with '1' resets interrupt mask bit (disables interrupt request for corresponding interrupt source) */
/*    Write access with '0' does not influence this bit */
/*    Read access shows actual interrupt mask */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX10_adc_ctrl_irq_msk_reset      0x0000002CU
#define Adr_NX10_adc_ctrl_adc_ctrl_irq_msk_reset 0x101406ECU
#define Adr_NX10_adc_ctrl_irq_msk_reset          0x101406ECU
#define DFLT_VAL_NX10_adc_ctrl_irq_msk_reset     0x00000000U

#define MSK_NX10_adc_ctrl_irq_msk_reset_adc0_finish       0x00000001U
#define SRT_NX10_adc_ctrl_irq_msk_reset_adc0_finish       0
#define DFLT_VAL_NX10_adc_ctrl_irq_msk_reset_adc0_finish  0x00000000U
#define MSK_NX10_adc_ctrl_irq_msk_reset_adc1_finish       0x00000002U
#define SRT_NX10_adc_ctrl_irq_msk_reset_adc1_finish       1
#define DFLT_VAL_NX10_adc_ctrl_irq_msk_reset_adc1_finish  0x00000000U
#define MSK_NX10_adc_ctrl_irq_msk_reset_start_adc0_n      0x00000004U
#define SRT_NX10_adc_ctrl_irq_msk_reset_start_adc0_n      2
#define DFLT_VAL_NX10_adc_ctrl_irq_msk_reset_start_adc0_n 0x00000000U
#define MSK_NX10_adc_ctrl_irq_msk_reset_start_adc1_n      0x00000008U
#define SRT_NX10_adc_ctrl_irq_msk_reset_start_adc1_n      3
#define DFLT_VAL_NX10_adc_ctrl_irq_msk_reset_start_adc1_n 0x00000000U

enum {
	BFW_NX10_adc_ctrl_irq_msk_reset_adc0_finish  = 1,  /* [0] */
	BFW_NX10_adc_ctrl_irq_msk_reset_adc1_finish  = 1,  /* [1] */
	BFW_NX10_adc_ctrl_irq_msk_reset_start_adc0_n = 1,  /* [2] */
	BFW_NX10_adc_ctrl_irq_msk_reset_start_adc1_n = 1,  /* [3] */
	BFW_NX10_adc_ctrl_irq_msk_reset_reserved1    = 28  /* [31:4] */
};

typedef struct NX10_ADC_CTRL_IRQ_MSK_RESET_BIT_Ttag {
	unsigned int adc0_finish  : BFW_NX10_adc_ctrl_irq_msk_reset_adc0_finish;  /* ADC0 finished sampling                                                            */
	unsigned int adc1_finish  : BFW_NX10_adc_ctrl_irq_msk_reset_adc1_finish;  /* ADC1 finished sampling                                                            */
	unsigned int start_adc0_n : BFW_NX10_adc_ctrl_irq_msk_reset_start_adc0_n; /* ADC0 start bit has returned to 0, i.e. ADC0 can be programmed for next conversion */
	unsigned int start_adc1_n : BFW_NX10_adc_ctrl_irq_msk_reset_start_adc1_n; /* ADC1 start bit has returned to 0, i.e. ADC1 can be programmed for next conversion */
	unsigned int reserved1    : BFW_NX10_adc_ctrl_irq_msk_reset_reserved1;    /* reserved                                                                          */
} NX10_ADC_CTRL_IRQ_MSK_RESET_BIT_T;

typedef union {
	unsigned int                      val;
	NX10_ADC_CTRL_IRQ_MSK_RESET_BIT_T bf;
} NX10_ADC_CTRL_IRQ_MSK_RESET_T;


/* ===================================================================== */

/* Area of xpic_timer */

/* ===================================================================== */

#define Addr_NX10_xpic_timer 0x10140700U

/* --------------------------------------------------------------------- */
/* Register xpic_timer_config_timer0 */
/* => xPIC TIMER Config register0 */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX10_xpic_timer_config_timer0        0x00000000U
#define Adr_NX10_xpic_timer_xpic_timer_config_timer0 0x10140700U
#define Adr_NX10_xpic_timer_config_timer0            0x10140700U
#define DFLT_VAL_NX10_xpic_timer_config_timer0       0x00000000U

#define MSK_NX10_xpic_timer_config_timer0_mode      0x00000003U
#define SRT_NX10_xpic_timer_config_timer0_mode      0
#define DFLT_VAL_NX10_xpic_timer_config_timer0_mode 0x00000000U

enum {
	BFW_NX10_xpic_timer_config_timer0_mode      = 2,  /* [1:0] */
	BFW_NX10_xpic_timer_config_timer0_reserved1 = 30  /* [31:2] */
};

typedef struct NX10_XPIC_TIMER_CONFIG_TIMER0_BIT_Ttag {
	unsigned int mode      : BFW_NX10_xpic_timer_config_timer0_mode;      /* Timer0                         */
	                                                                      /*       2'b00 : Timer stops at 0 */
	unsigned int reserved1 : BFW_NX10_xpic_timer_config_timer0_reserved1; /* reserved                       */
} NX10_XPIC_TIMER_CONFIG_TIMER0_BIT_T;

typedef union {
	unsigned int                        val;
	NX10_XPIC_TIMER_CONFIG_TIMER0_BIT_T bf;
} NX10_XPIC_TIMER_CONFIG_TIMER0_T;

/* --------------------------------------------------------------------- */
/* Register xpic_timer_config_timer1 */
/* => xPIC TIMER Config register1 */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX10_xpic_timer_config_timer1        0x00000004U
#define Adr_NX10_xpic_timer_xpic_timer_config_timer1 0x10140704U
#define Adr_NX10_xpic_timer_config_timer1            0x10140704U
#define DFLT_VAL_NX10_xpic_timer_config_timer1       0x00000000U

#define MSK_NX10_xpic_timer_config_timer1_mode      0x00000003U
#define SRT_NX10_xpic_timer_config_timer1_mode      0
#define DFLT_VAL_NX10_xpic_timer_config_timer1_mode 0x00000000U

enum {
	BFW_NX10_xpic_timer_config_timer1_mode      = 2,  /* [1:0] */
	BFW_NX10_xpic_timer_config_timer1_reserved1 = 30  /* [31:2] */
};

typedef struct NX10_XPIC_TIMER_CONFIG_TIMER1_BIT_Ttag {
	unsigned int mode      : BFW_NX10_xpic_timer_config_timer1_mode;      /* Timer1                         */
	                                                                      /*       2'b00 : Timer stops at 0 */
	unsigned int reserved1 : BFW_NX10_xpic_timer_config_timer1_reserved1; /* reserved                       */
} NX10_XPIC_TIMER_CONFIG_TIMER1_BIT_T;

typedef union {
	unsigned int                        val;
	NX10_XPIC_TIMER_CONFIG_TIMER1_BIT_T bf;
} NX10_XPIC_TIMER_CONFIG_TIMER1_T;

/* --------------------------------------------------------------------- */
/* Register xpic_timer_config_timer2 */
/* => xPIC TIMER Config register2 */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX10_xpic_timer_config_timer2        0x00000008U
#define Adr_NX10_xpic_timer_xpic_timer_config_timer2 0x10140708U
#define Adr_NX10_xpic_timer_config_timer2            0x10140708U
#define DFLT_VAL_NX10_xpic_timer_config_timer2       0x00000000U

#define MSK_NX10_xpic_timer_config_timer2_mode      0x00000003U
#define SRT_NX10_xpic_timer_config_timer2_mode      0
#define DFLT_VAL_NX10_xpic_timer_config_timer2_mode 0x00000000U

enum {
	BFW_NX10_xpic_timer_config_timer2_mode      = 2,  /* [1:0] */
	BFW_NX10_xpic_timer_config_timer2_reserved1 = 30  /* [31:2] */
};

typedef struct NX10_XPIC_TIMER_CONFIG_TIMER2_BIT_Ttag {
	unsigned int mode      : BFW_NX10_xpic_timer_config_timer2_mode;      /* Timer2                         */
	                                                                      /*       2'b00 : Timer stops at 0 */
	unsigned int reserved1 : BFW_NX10_xpic_timer_config_timer2_reserved1; /* reserved                       */
} NX10_XPIC_TIMER_CONFIG_TIMER2_BIT_T;

typedef union {
	unsigned int                        val;
	NX10_XPIC_TIMER_CONFIG_TIMER2_BIT_T bf;
} NX10_XPIC_TIMER_CONFIG_TIMER2_T;

/* --------------------------------------------------------------------- */
/* Register xpic_timer_preload_timer0 */
/* => xPIC TIMER Timer 0 preload */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX10_xpic_timer_preload_timer0        0x0000000CU
#define Adr_NX10_xpic_timer_xpic_timer_preload_timer0 0x1014070CU
#define Adr_NX10_xpic_timer_preload_timer0            0x1014070CU
#define DFLT_VAL_NX10_xpic_timer_preload_timer0       0x00000000U

#define MSK_NX10_xpic_timer_preload_timer0_val      0xffffffffU
#define SRT_NX10_xpic_timer_preload_timer0_val      0
#define DFLT_VAL_NX10_xpic_timer_preload_timer0_val 0x00000000U

enum {
	BFW_NX10_xpic_timer_preload_timer0_val = 32  /* [31:0] */
};

typedef struct NX10_XPIC_TIMER_PRELOAD_TIMER0_BIT_Ttag {
	unsigned int val : BFW_NX10_xpic_timer_preload_timer0_val; /* preload value */
} NX10_XPIC_TIMER_PRELOAD_TIMER0_BIT_T;

typedef union {
	unsigned int                         val;
	NX10_XPIC_TIMER_PRELOAD_TIMER0_BIT_T bf;
} NX10_XPIC_TIMER_PRELOAD_TIMER0_T;

/* --------------------------------------------------------------------- */
/* Register xpic_timer_preload_timer1 */
/* => xPIC TIMER Timer 1 preload */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX10_xpic_timer_preload_timer1        0x00000010U
#define Adr_NX10_xpic_timer_xpic_timer_preload_timer1 0x10140710U
#define Adr_NX10_xpic_timer_preload_timer1            0x10140710U
#define DFLT_VAL_NX10_xpic_timer_preload_timer1       0x00000000U

#define MSK_NX10_xpic_timer_preload_timer1_val      0xffffffffU
#define SRT_NX10_xpic_timer_preload_timer1_val      0
#define DFLT_VAL_NX10_xpic_timer_preload_timer1_val 0x00000000U

enum {
	BFW_NX10_xpic_timer_preload_timer1_val = 32  /* [31:0] */
};

typedef struct NX10_XPIC_TIMER_PRELOAD_TIMER1_BIT_Ttag {
	unsigned int val : BFW_NX10_xpic_timer_preload_timer1_val; /* preload value */
} NX10_XPIC_TIMER_PRELOAD_TIMER1_BIT_T;

typedef union {
	unsigned int                         val;
	NX10_XPIC_TIMER_PRELOAD_TIMER1_BIT_T bf;
} NX10_XPIC_TIMER_PRELOAD_TIMER1_T;

/* --------------------------------------------------------------------- */
/* Register xpic_timer_preload_timer2 */
/* => xPIC TIMER Timer 2 preload */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX10_xpic_timer_preload_timer2        0x00000014U
#define Adr_NX10_xpic_timer_xpic_timer_preload_timer2 0x10140714U
#define Adr_NX10_xpic_timer_preload_timer2            0x10140714U
#define DFLT_VAL_NX10_xpic_timer_preload_timer2       0x00000000U

#define MSK_NX10_xpic_timer_preload_timer2_val      0xffffffffU
#define SRT_NX10_xpic_timer_preload_timer2_val      0
#define DFLT_VAL_NX10_xpic_timer_preload_timer2_val 0x00000000U

enum {
	BFW_NX10_xpic_timer_preload_timer2_val = 32  /* [31:0] */
};

typedef struct NX10_XPIC_TIMER_PRELOAD_TIMER2_BIT_Ttag {
	unsigned int val : BFW_NX10_xpic_timer_preload_timer2_val; /* preload value */
} NX10_XPIC_TIMER_PRELOAD_TIMER2_BIT_T;

typedef union {
	unsigned int                         val;
	NX10_XPIC_TIMER_PRELOAD_TIMER2_BIT_T bf;
} NX10_XPIC_TIMER_PRELOAD_TIMER2_T;

/* --------------------------------------------------------------------- */
/* Register xpic_timer_timer0 */
/* => xPIC TIMER Timer 0 */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX10_xpic_timer_timer0        0x00000018U
#define Adr_NX10_xpic_timer_xpic_timer_timer0 0x10140718U
#define Adr_NX10_xpic_timer_timer0            0x10140718U
#define DFLT_VAL_NX10_xpic_timer_timer0       0x00000000U

#define MSK_NX10_xpic_timer_timer0_val      0xffffffffU
#define SRT_NX10_xpic_timer_timer0_val      0
#define DFLT_VAL_NX10_xpic_timer_timer0_val 0x00000000U

enum {
	BFW_NX10_xpic_timer_timer0_val = 32  /* [31:0] */
};

typedef struct NX10_XPIC_TIMER_TIMER0_BIT_Ttag {
	unsigned int val : BFW_NX10_xpic_timer_timer0_val; /* actual value of timer / systime compare value */
} NX10_XPIC_TIMER_TIMER0_BIT_T;

typedef union {
	unsigned int                 val;
	NX10_XPIC_TIMER_TIMER0_BIT_T bf;
} NX10_XPIC_TIMER_TIMER0_T;

/* --------------------------------------------------------------------- */
/* Register xpic_timer_timer1 */
/* => xPIC TIMER Timer 1 */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX10_xpic_timer_timer1        0x0000001CU
#define Adr_NX10_xpic_timer_xpic_timer_timer1 0x1014071CU
#define Adr_NX10_xpic_timer_timer1            0x1014071CU
#define DFLT_VAL_NX10_xpic_timer_timer1       0x00000000U

#define MSK_NX10_xpic_timer_timer1_val      0xffffffffU
#define SRT_NX10_xpic_timer_timer1_val      0
#define DFLT_VAL_NX10_xpic_timer_timer1_val 0x00000000U

enum {
	BFW_NX10_xpic_timer_timer1_val = 32  /* [31:0] */
};

typedef struct NX10_XPIC_TIMER_TIMER1_BIT_Ttag {
	unsigned int val : BFW_NX10_xpic_timer_timer1_val; /* actual value of timer / systime compare value */
} NX10_XPIC_TIMER_TIMER1_BIT_T;

typedef union {
	unsigned int                 val;
	NX10_XPIC_TIMER_TIMER1_BIT_T bf;
} NX10_XPIC_TIMER_TIMER1_T;

/* --------------------------------------------------------------------- */
/* Register xpic_timer_timer2 */
/* => xPIC TIMER Timer 2 */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX10_xpic_timer_timer2        0x00000020U
#define Adr_NX10_xpic_timer_xpic_timer_timer2 0x10140720U
#define Adr_NX10_xpic_timer_timer2            0x10140720U
#define DFLT_VAL_NX10_xpic_timer_timer2       0x00000000U

#define MSK_NX10_xpic_timer_timer2_val      0xffffffffU
#define SRT_NX10_xpic_timer_timer2_val      0
#define DFLT_VAL_NX10_xpic_timer_timer2_val 0x00000000U

enum {
	BFW_NX10_xpic_timer_timer2_val = 32  /* [31:0] */
};

typedef struct NX10_XPIC_TIMER_TIMER2_BIT_Ttag {
	unsigned int val : BFW_NX10_xpic_timer_timer2_val; /* actual value of timer / systime compare value */
} NX10_XPIC_TIMER_TIMER2_BIT_T;

typedef union {
	unsigned int                 val;
	NX10_XPIC_TIMER_TIMER2_BIT_T bf;
} NX10_XPIC_TIMER_TIMER2_T;

/* --------------------------------------------------------------------- */
/* Register xpic_timer_irq_raw */
/* => xPIC_TIMER Raw IRQ register: */
/*    Read access shows status of unmasked IRQs */
/*    Write access with '1' resets the appropriate IRQ */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX10_xpic_timer_irq_raw        0x00000024U
#define Adr_NX10_xpic_timer_xpic_timer_irq_raw 0x10140724U
#define Adr_NX10_xpic_timer_irq_raw            0x10140724U
#define DFLT_VAL_NX10_xpic_timer_irq_raw       0x00000000U

#define MSK_NX10_xpic_timer_irq_raw_timer0_irq         0x00000001U
#define SRT_NX10_xpic_timer_irq_raw_timer0_irq         0
#define DFLT_VAL_NX10_xpic_timer_irq_raw_timer0_irq    0x00000000U
#define MSK_NX10_xpic_timer_irq_raw_timer1_irq         0x00000002U
#define SRT_NX10_xpic_timer_irq_raw_timer1_irq         1
#define DFLT_VAL_NX10_xpic_timer_irq_raw_timer1_irq    0x00000000U
#define MSK_NX10_xpic_timer_irq_raw_timer2_irq         0x00000004U
#define SRT_NX10_xpic_timer_irq_raw_timer2_irq         2
#define DFLT_VAL_NX10_xpic_timer_irq_raw_timer2_irq    0x00000000U
#define MSK_NX10_xpic_timer_irq_raw_systime_s_irq      0x00000008U
#define SRT_NX10_xpic_timer_irq_raw_systime_s_irq      3
#define DFLT_VAL_NX10_xpic_timer_irq_raw_systime_s_irq 0x00000000U

enum {
	BFW_NX10_xpic_timer_irq_raw_timer0_irq    = 1,  /* [0] */
	BFW_NX10_xpic_timer_irq_raw_timer1_irq    = 1,  /* [1] */
	BFW_NX10_xpic_timer_irq_raw_timer2_irq    = 1,  /* [2] */
	BFW_NX10_xpic_timer_irq_raw_systime_s_irq = 1,  /* [3] */
	BFW_NX10_xpic_timer_irq_raw_reserved1     = 28  /* [31:4] */
};

typedef struct NX10_XPIC_TIMER_IRQ_RAW_BIT_Ttag {
	unsigned int timer0_irq    : BFW_NX10_xpic_timer_irq_raw_timer0_irq;    /* Timer 0 Interrupt   */
	unsigned int timer1_irq    : BFW_NX10_xpic_timer_irq_raw_timer1_irq;    /* Timer 1 Interrupt   */
	unsigned int timer2_irq    : BFW_NX10_xpic_timer_irq_raw_timer2_irq;    /* Timer 2 Interrupt   */
	unsigned int systime_s_irq : BFW_NX10_xpic_timer_irq_raw_systime_s_irq; /* Systime_s Interrupt */
	unsigned int reserved1     : BFW_NX10_xpic_timer_irq_raw_reserved1;     /* reserved            */
} NX10_XPIC_TIMER_IRQ_RAW_BIT_T;

typedef union {
	unsigned int                  val;
	NX10_XPIC_TIMER_IRQ_RAW_BIT_T bf;
} NX10_XPIC_TIMER_IRQ_RAW_T;

/* --------------------------------------------------------------------- */
/* Register xpic_timer_irq_masked */
/* => xPIC_TIMER Masked IRQ register: */
/*    Shows status of masked IRQs (as connected to ARM/xPIC) */
/* => Mode: R */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX10_xpic_timer_irq_masked        0x00000028U
#define Adr_NX10_xpic_timer_xpic_timer_irq_masked 0x10140728U
#define Adr_NX10_xpic_timer_irq_masked            0x10140728U

#define MSK_NX10_xpic_timer_irq_masked_timer0_irq    0x00000001U
#define SRT_NX10_xpic_timer_irq_masked_timer0_irq    0
#define MSK_NX10_xpic_timer_irq_masked_timer1_irq    0x00000002U
#define SRT_NX10_xpic_timer_irq_masked_timer1_irq    1
#define MSK_NX10_xpic_timer_irq_masked_timer2_irq    0x00000004U
#define SRT_NX10_xpic_timer_irq_masked_timer2_irq    2
#define MSK_NX10_xpic_timer_irq_masked_systime_s_irq 0x00000008U
#define SRT_NX10_xpic_timer_irq_masked_systime_s_irq 3

enum {
	BFW_NX10_xpic_timer_irq_masked_timer0_irq    = 1,  /* [0] */
	BFW_NX10_xpic_timer_irq_masked_timer1_irq    = 1,  /* [1] */
	BFW_NX10_xpic_timer_irq_masked_timer2_irq    = 1,  /* [2] */
	BFW_NX10_xpic_timer_irq_masked_systime_s_irq = 1,  /* [3] */
	BFW_NX10_xpic_timer_irq_masked_reserved1     = 28  /* [31:4] */
};

typedef struct NX10_XPIC_TIMER_IRQ_MASKED_BIT_Ttag {
	unsigned int timer0_irq    : BFW_NX10_xpic_timer_irq_masked_timer0_irq;    /* Timer 0 Interrupt   */
	unsigned int timer1_irq    : BFW_NX10_xpic_timer_irq_masked_timer1_irq;    /* Timer 1 Interrupt   */
	unsigned int timer2_irq    : BFW_NX10_xpic_timer_irq_masked_timer2_irq;    /* Timer 2 Interrupt   */
	unsigned int systime_s_irq : BFW_NX10_xpic_timer_irq_masked_systime_s_irq; /* Systime_s Interrupt */
	unsigned int reserved1     : BFW_NX10_xpic_timer_irq_masked_reserved1;     /* reserved            */
} NX10_XPIC_TIMER_IRQ_MASKED_BIT_T;

typedef union {
	unsigned int                     val;
	NX10_XPIC_TIMER_IRQ_MASKED_BIT_T bf;
} NX10_XPIC_TIMER_IRQ_MASKED_T;

/* --------------------------------------------------------------------- */
/* Register xpic_timer_irq_msk_set */
/* => xPIC_TIMER interrupt mask enable: */
/*    Write access with '1' sets interrupt mask bit (enables interrupt request for corresponding interrupt source) */
/*    Write access with '0' does not influence this bit */
/*    Read access shows actual interrupt mask */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX10_xpic_timer_irq_msk_set        0x0000002CU
#define Adr_NX10_xpic_timer_xpic_timer_irq_msk_set 0x1014072CU
#define Adr_NX10_xpic_timer_irq_msk_set            0x1014072CU
#define DFLT_VAL_NX10_xpic_timer_irq_msk_set       0x00000000U

#define MSK_NX10_xpic_timer_irq_msk_set_timer0_irq         0x00000001U
#define SRT_NX10_xpic_timer_irq_msk_set_timer0_irq         0
#define DFLT_VAL_NX10_xpic_timer_irq_msk_set_timer0_irq    0x00000000U
#define MSK_NX10_xpic_timer_irq_msk_set_timer1_irq         0x00000002U
#define SRT_NX10_xpic_timer_irq_msk_set_timer1_irq         1
#define DFLT_VAL_NX10_xpic_timer_irq_msk_set_timer1_irq    0x00000000U
#define MSK_NX10_xpic_timer_irq_msk_set_timer2_irq         0x00000004U
#define SRT_NX10_xpic_timer_irq_msk_set_timer2_irq         2
#define DFLT_VAL_NX10_xpic_timer_irq_msk_set_timer2_irq    0x00000000U
#define MSK_NX10_xpic_timer_irq_msk_set_systime_s_irq      0x00000008U
#define SRT_NX10_xpic_timer_irq_msk_set_systime_s_irq      3
#define DFLT_VAL_NX10_xpic_timer_irq_msk_set_systime_s_irq 0x00000000U

enum {
	BFW_NX10_xpic_timer_irq_msk_set_timer0_irq    = 1,  /* [0] */
	BFW_NX10_xpic_timer_irq_msk_set_timer1_irq    = 1,  /* [1] */
	BFW_NX10_xpic_timer_irq_msk_set_timer2_irq    = 1,  /* [2] */
	BFW_NX10_xpic_timer_irq_msk_set_systime_s_irq = 1,  /* [3] */
	BFW_NX10_xpic_timer_irq_msk_set_reserved1     = 28  /* [31:4] */
};

typedef struct NX10_XPIC_TIMER_IRQ_MSK_SET_BIT_Ttag {
	unsigned int timer0_irq    : BFW_NX10_xpic_timer_irq_msk_set_timer0_irq;    /* Timer 0 Interrupt   */
	unsigned int timer1_irq    : BFW_NX10_xpic_timer_irq_msk_set_timer1_irq;    /* Timer 1 Interrupt   */
	unsigned int timer2_irq    : BFW_NX10_xpic_timer_irq_msk_set_timer2_irq;    /* Timer 2 Interrupt   */
	unsigned int systime_s_irq : BFW_NX10_xpic_timer_irq_msk_set_systime_s_irq; /* Systime_s Interrupt */
	unsigned int reserved1     : BFW_NX10_xpic_timer_irq_msk_set_reserved1;     /* reserved            */
} NX10_XPIC_TIMER_IRQ_MSK_SET_BIT_T;

typedef union {
	unsigned int                      val;
	NX10_XPIC_TIMER_IRQ_MSK_SET_BIT_T bf;
} NX10_XPIC_TIMER_IRQ_MSK_SET_T;

/* --------------------------------------------------------------------- */
/* Register xpic_timer_irq_msk_reset */
/* => xPIC_TIMER interrupt mask disable: */
/*    Write access with '1' resets interrupt mask bit (disables interrupt request for corresponding interrupt source) */
/*    Write access with '0' does not influence this bit */
/*    Read access shows actual interrupt mask */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX10_xpic_timer_irq_msk_reset        0x00000030U
#define Adr_NX10_xpic_timer_xpic_timer_irq_msk_reset 0x10140730U
#define Adr_NX10_xpic_timer_irq_msk_reset            0x10140730U
#define DFLT_VAL_NX10_xpic_timer_irq_msk_reset       0x00000000U

#define MSK_NX10_xpic_timer_irq_msk_reset_timer0_irq         0x00000001U
#define SRT_NX10_xpic_timer_irq_msk_reset_timer0_irq         0
#define DFLT_VAL_NX10_xpic_timer_irq_msk_reset_timer0_irq    0x00000000U
#define MSK_NX10_xpic_timer_irq_msk_reset_timer1_irq         0x00000002U
#define SRT_NX10_xpic_timer_irq_msk_reset_timer1_irq         1
#define DFLT_VAL_NX10_xpic_timer_irq_msk_reset_timer1_irq    0x00000000U
#define MSK_NX10_xpic_timer_irq_msk_reset_timer2_irq         0x00000004U
#define SRT_NX10_xpic_timer_irq_msk_reset_timer2_irq         2
#define DFLT_VAL_NX10_xpic_timer_irq_msk_reset_timer2_irq    0x00000000U
#define MSK_NX10_xpic_timer_irq_msk_reset_systime_s_irq      0x00000008U
#define SRT_NX10_xpic_timer_irq_msk_reset_systime_s_irq      3
#define DFLT_VAL_NX10_xpic_timer_irq_msk_reset_systime_s_irq 0x00000000U

enum {
	BFW_NX10_xpic_timer_irq_msk_reset_timer0_irq    = 1,  /* [0] */
	BFW_NX10_xpic_timer_irq_msk_reset_timer1_irq    = 1,  /* [1] */
	BFW_NX10_xpic_timer_irq_msk_reset_timer2_irq    = 1,  /* [2] */
	BFW_NX10_xpic_timer_irq_msk_reset_systime_s_irq = 1,  /* [3] */
	BFW_NX10_xpic_timer_irq_msk_reset_reserved1     = 28  /* [31:4] */
};

typedef struct NX10_XPIC_TIMER_IRQ_MSK_RESET_BIT_Ttag {
	unsigned int timer0_irq    : BFW_NX10_xpic_timer_irq_msk_reset_timer0_irq;    /* Timer 0 Interrupt   */
	unsigned int timer1_irq    : BFW_NX10_xpic_timer_irq_msk_reset_timer1_irq;    /* Timer 1 Interrupt   */
	unsigned int timer2_irq    : BFW_NX10_xpic_timer_irq_msk_reset_timer2_irq;    /* Timer 2 Interrupt   */
	unsigned int systime_s_irq : BFW_NX10_xpic_timer_irq_msk_reset_systime_s_irq; /* Systime_s Interrupt */
	unsigned int reserved1     : BFW_NX10_xpic_timer_irq_msk_reset_reserved1;     /* reserved            */
} NX10_XPIC_TIMER_IRQ_MSK_RESET_BIT_T;

typedef union {
	unsigned int                        val;
	NX10_XPIC_TIMER_IRQ_MSK_RESET_BIT_T bf;
} NX10_XPIC_TIMER_IRQ_MSK_RESET_T;

/* --------------------------------------------------------------------- */
/* Register xpic_timer_systime_s */
/* => xPIC_TIMER upper SYSTIME register */
/*    To allow consistent values of systime_s and systime_ns, lower bits of systime is latched to systime_ns, when systime_s is read. */
/*    This register should be dedicated to accesses via xPIC. */
/*    ARM software should access systime via arm_timer_systime_s. */
/*    Host software should access systime via DPM at systime_s. */
/* => Mode: R */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX10_xpic_timer_systime_s        0x00000034U
#define Adr_NX10_xpic_timer_xpic_timer_systime_s 0x10140734U
#define Adr_NX10_xpic_timer_systime_s            0x10140734U

#define MSK_NX10_xpic_timer_systime_s_val 0xffffffffU
#define SRT_NX10_xpic_timer_systime_s_val 0

enum {
	BFW_NX10_xpic_timer_systime_s_val = 32  /* [31:0] */
};

typedef struct NX10_XPIC_TIMER_SYSTIME_S_BIT_Ttag {
	unsigned int val : BFW_NX10_xpic_timer_systime_s_val; /* Systime high:                                  */
	                                                      /* Sample systime_ns at read access to systime_s. */
} NX10_XPIC_TIMER_SYSTIME_S_BIT_T;

typedef union {
	unsigned int                    val;
	NX10_XPIC_TIMER_SYSTIME_S_BIT_T bf;
} NX10_XPIC_TIMER_SYSTIME_S_T;

/* --------------------------------------------------------------------- */
/* Register xpic_timer_systime_ns */
/* => xPIC_TIMER lower SYSTIME register */
/*    To allow consistent values of systime_s and systime_ns, lower bits of systime is latched to systime_ns, when systime_s is read. */
/*    If no systime_s is read before (e.g. at 2nd read access of systime_ns), the actual value of systime_ns is read. */
/*    This register should be dedicated to accesses via xPIC. */
/*    ARM software should access systime via arm_timer_systime_ns. */
/*    Host software should access systime via DPM at systime_ns. */
/* => Mode: R */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX10_xpic_timer_systime_ns        0x00000038U
#define Adr_NX10_xpic_timer_xpic_timer_systime_ns 0x10140738U
#define Adr_NX10_xpic_timer_systime_ns            0x10140738U

#define MSK_NX10_xpic_timer_systime_ns_val 0xffffffffU
#define SRT_NX10_xpic_timer_systime_ns_val 0

enum {
	BFW_NX10_xpic_timer_systime_ns_val = 32  /* [31:0] */
};

typedef struct NX10_XPIC_TIMER_SYSTIME_NS_BIT_Ttag {
	unsigned int val : BFW_NX10_xpic_timer_systime_ns_val; /* Systime low:                                   */
	                                                       /* Sample systime_ns at read access to systime_s. */
} NX10_XPIC_TIMER_SYSTIME_NS_BIT_T;

typedef union {
	unsigned int                     val;
	NX10_XPIC_TIMER_SYSTIME_NS_BIT_T bf;
} NX10_XPIC_TIMER_SYSTIME_NS_T;

/* --------------------------------------------------------------------- */
/* Register xpic_timer_compare_systime_s_value */
/* => xPIC_TIMER SYSTIME sec compare register */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX10_xpic_timer_compare_systime_s_value        0x0000003CU
#define Adr_NX10_xpic_timer_xpic_timer_compare_systime_s_value 0x1014073CU
#define Adr_NX10_xpic_timer_compare_systime_s_value            0x1014073CU
#define DFLT_VAL_NX10_xpic_timer_compare_systime_s_value       0x00000000U

#define MSK_NX10_xpic_timer_compare_systime_s_value_val      0xffffffffU
#define SRT_NX10_xpic_timer_compare_systime_s_value_val      0
#define DFLT_VAL_NX10_xpic_timer_compare_systime_s_value_val 0x00000000U

enum {
	BFW_NX10_xpic_timer_compare_systime_s_value_val = 32  /* [31:0] */
};

typedef struct NX10_XPIC_TIMER_COMPARE_SYSTIME_S_VALUE_BIT_Ttag {
	unsigned int val : BFW_NX10_xpic_timer_compare_systime_s_value_val; /* Compare value with systime_s (seconds):             */
	                                                                    /* Systime_s_compare_irq is set, if systime_s matches. */
} NX10_XPIC_TIMER_COMPARE_SYSTIME_S_VALUE_BIT_T;

typedef union {
	unsigned int                                  val;
	NX10_XPIC_TIMER_COMPARE_SYSTIME_S_VALUE_BIT_T bf;
} NX10_XPIC_TIMER_COMPARE_SYSTIME_S_VALUE_T;


/* ===================================================================== */

/* Area of xpic_vic */

/* ===================================================================== */

#define Addr_NX10_xpic_vic 0x10140800U

/* --------------------------------------------------------------------- */
/* Register xpic_vic_config */
/* => MOTION TIMER Config register0 */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX10_xpic_vic_config      0x00000000U
#define Adr_NX10_xpic_vic_xpic_vic_config 0x10140800U
#define Adr_NX10_xpic_vic_config          0x10140800U
#define DFLT_VAL_NX10_xpic_vic_config     0x00000000U

#define MSK_NX10_xpic_vic_config_enable      0x00000001U
#define SRT_NX10_xpic_vic_config_enable      0
#define DFLT_VAL_NX10_xpic_vic_config_enable 0x00000000U
#define MSK_NX10_xpic_vic_config_table       0x00000002U
#define SRT_NX10_xpic_vic_config_table       1
#define DFLT_VAL_NX10_xpic_vic_config_table  0x00000000U

enum {
	BFW_NX10_xpic_vic_config_enable    = 1,  /* [0] */
	BFW_NX10_xpic_vic_config_table     = 1,  /* [1] */
	BFW_NX10_xpic_vic_config_reserved1 = 30  /* [31:2] */
};

typedef struct NX10_XPIC_VIC_CONFIG_BIT_Ttag {
	unsigned int enable    : BFW_NX10_xpic_vic_config_enable;    /* global enable of xPIC VIC (0: disable/ 1: enable)           */
	unsigned int table     : BFW_NX10_xpic_vic_config_table;     /* use far or near Table                                       */
	                                                             /* 0 = Base Pointer Addr for IRQ Jmp Table + (n*4) DWORD Table */
	unsigned int reserved1 : BFW_NX10_xpic_vic_config_reserved1; /* reserved                                                    */
} NX10_XPIC_VIC_CONFIG_BIT_T;

typedef union {
	unsigned int               val;
	NX10_XPIC_VIC_CONFIG_BIT_T bf;
} NX10_XPIC_VIC_CONFIG_T;

/* --------------------------------------------------------------------- */
/* Register xpic_vic_raw_intr0 */
/* => XPIC VIC Raw0 interrupt status register */
/* => Mode: R */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX10_xpic_vic_raw_intr0      0x00000004U
#define Adr_NX10_xpic_vic_xpic_vic_raw_intr0 0x10140804U
#define Adr_NX10_xpic_vic_raw_intr0          0x10140804U

#define MSK_NX10_xpic_vic_raw_intr0_sw0        0x00000001U
#define SRT_NX10_xpic_vic_raw_intr0_sw0        0
#define MSK_NX10_xpic_vic_raw_intr0_timer0     0x00000002U
#define SRT_NX10_xpic_vic_raw_intr0_timer0     1
#define MSK_NX10_xpic_vic_raw_intr0_timer1     0x00000004U
#define SRT_NX10_xpic_vic_raw_intr0_timer1     2
#define MSK_NX10_xpic_vic_raw_intr0_gpio_timer 0x00000008U
#define SRT_NX10_xpic_vic_raw_intr0_gpio_timer 3
#define MSK_NX10_xpic_vic_raw_intr0_timer2     0x00000010U
#define SRT_NX10_xpic_vic_raw_intr0_timer2     4
#define MSK_NX10_xpic_vic_raw_intr0_systime_s  0x00000020U
#define SRT_NX10_xpic_vic_raw_intr0_systime_s  5
#define MSK_NX10_xpic_vic_raw_intr0_gpio7      0x00000040U
#define SRT_NX10_xpic_vic_raw_intr0_gpio7      6
#define MSK_NX10_xpic_vic_raw_intr0_watchdog   0x00000080U
#define SRT_NX10_xpic_vic_raw_intr0_watchdog   7
#define MSK_NX10_xpic_vic_raw_intr0_uart0      0x00000100U
#define SRT_NX10_xpic_vic_raw_intr0_uart0      8
#define MSK_NX10_xpic_vic_raw_intr0_uart1      0x00000200U
#define SRT_NX10_xpic_vic_raw_intr0_uart1      9
#define MSK_NX10_xpic_vic_raw_intr0_reserved10 0x00000400U
#define SRT_NX10_xpic_vic_raw_intr0_reserved10 10
#define MSK_NX10_xpic_vic_raw_intr0_usb        0x00000800U
#define SRT_NX10_xpic_vic_raw_intr0_usb        11
#define MSK_NX10_xpic_vic_raw_intr0_spi        0x00001000U
#define SRT_NX10_xpic_vic_raw_intr0_spi        12
#define MSK_NX10_xpic_vic_raw_intr0_i2c        0x00002000U
#define SRT_NX10_xpic_vic_raw_intr0_i2c        13
#define MSK_NX10_xpic_vic_raw_intr0_reserved14 0x00004000U
#define SRT_NX10_xpic_vic_raw_intr0_reserved14 14
#define MSK_NX10_xpic_vic_raw_intr0_hif        0x00008000U
#define SRT_NX10_xpic_vic_raw_intr0_hif        15
#define MSK_NX10_xpic_vic_raw_intr0_gpio       0x00010000U
#define SRT_NX10_xpic_vic_raw_intr0_gpio       16
#define MSK_NX10_xpic_vic_raw_intr0_com0       0x00020000U
#define SRT_NX10_xpic_vic_raw_intr0_com0       17
#define MSK_NX10_xpic_vic_raw_intr0_reserved18 0x00040000U
#define SRT_NX10_xpic_vic_raw_intr0_reserved18 18
#define MSK_NX10_xpic_vic_raw_intr0_reserved19 0x00080000U
#define SRT_NX10_xpic_vic_raw_intr0_reserved19 19
#define MSK_NX10_xpic_vic_raw_intr0_reserved20 0x00100000U
#define SRT_NX10_xpic_vic_raw_intr0_reserved20 20
#define MSK_NX10_xpic_vic_raw_intr0_msync0     0x00200000U
#define SRT_NX10_xpic_vic_raw_intr0_msync0     21
#define MSK_NX10_xpic_vic_raw_intr0_reserved22 0x00400000U
#define SRT_NX10_xpic_vic_raw_intr0_reserved22 22
#define MSK_NX10_xpic_vic_raw_intr0_reserved23 0x00800000U
#define SRT_NX10_xpic_vic_raw_intr0_reserved23 23
#define MSK_NX10_xpic_vic_raw_intr0_msync3     0x01000000U
#define SRT_NX10_xpic_vic_raw_intr0_msync3     24
#define MSK_NX10_xpic_vic_raw_intr0_int_phy    0x02000000U
#define SRT_NX10_xpic_vic_raw_intr0_int_phy    25
#define MSK_NX10_xpic_vic_raw_intr0_sysstate   0x04000000U
#define SRT_NX10_xpic_vic_raw_intr0_sysstate   26
#define MSK_NX10_xpic_vic_raw_intr0_dmac       0x08000000U
#define SRT_NX10_xpic_vic_raw_intr0_dmac       27
#define MSK_NX10_xpic_vic_raw_intr0_reserved28 0x10000000U
#define SRT_NX10_xpic_vic_raw_intr0_reserved28 28
#define MSK_NX10_xpic_vic_raw_intr0_pwm        0x20000000U
#define SRT_NX10_xpic_vic_raw_intr0_pwm        29
#define MSK_NX10_xpic_vic_raw_intr0_encoder    0x40000000U
#define SRT_NX10_xpic_vic_raw_intr0_encoder    30
#define MSK_NX10_xpic_vic_raw_intr0_adc        0x80000000U
#define SRT_NX10_xpic_vic_raw_intr0_adc        31

enum {
	BFW_NX10_xpic_vic_raw_intr0_sw0        = 1, /* [0] */
	BFW_NX10_xpic_vic_raw_intr0_timer0     = 1, /* [1] */
	BFW_NX10_xpic_vic_raw_intr0_timer1     = 1, /* [2] */
	BFW_NX10_xpic_vic_raw_intr0_gpio_timer = 1, /* [3] */
	BFW_NX10_xpic_vic_raw_intr0_timer2     = 1, /* [4] */
	BFW_NX10_xpic_vic_raw_intr0_systime_s  = 1, /* [5] */
	BFW_NX10_xpic_vic_raw_intr0_gpio7      = 1, /* [6] */
	BFW_NX10_xpic_vic_raw_intr0_watchdog   = 1, /* [7] */
	BFW_NX10_xpic_vic_raw_intr0_uart0      = 1, /* [8] */
	BFW_NX10_xpic_vic_raw_intr0_uart1      = 1, /* [9] */
	BFW_NX10_xpic_vic_raw_intr0_reserved10 = 1, /* [10] */
	BFW_NX10_xpic_vic_raw_intr0_usb        = 1, /* [11] */
	BFW_NX10_xpic_vic_raw_intr0_spi        = 1, /* [12] */
	BFW_NX10_xpic_vic_raw_intr0_i2c        = 1, /* [13] */
	BFW_NX10_xpic_vic_raw_intr0_reserved14 = 1, /* [14] */
	BFW_NX10_xpic_vic_raw_intr0_hif        = 1, /* [15] */
	BFW_NX10_xpic_vic_raw_intr0_gpio       = 1, /* [16] */
	BFW_NX10_xpic_vic_raw_intr0_com0       = 1, /* [17] */
	BFW_NX10_xpic_vic_raw_intr0_reserved18 = 1, /* [18] */
	BFW_NX10_xpic_vic_raw_intr0_reserved19 = 1, /* [19] */
	BFW_NX10_xpic_vic_raw_intr0_reserved20 = 1, /* [20] */
	BFW_NX10_xpic_vic_raw_intr0_msync0     = 1, /* [21] */
	BFW_NX10_xpic_vic_raw_intr0_reserved22 = 1, /* [22] */
	BFW_NX10_xpic_vic_raw_intr0_reserved23 = 1, /* [23] */
	BFW_NX10_xpic_vic_raw_intr0_msync3     = 1, /* [24] */
	BFW_NX10_xpic_vic_raw_intr0_int_phy    = 1, /* [25] */
	BFW_NX10_xpic_vic_raw_intr0_sysstate   = 1, /* [26] */
	BFW_NX10_xpic_vic_raw_intr0_dmac       = 1, /* [27] */
	BFW_NX10_xpic_vic_raw_intr0_reserved28 = 1, /* [28] */
	BFW_NX10_xpic_vic_raw_intr0_pwm        = 1, /* [29] */
	BFW_NX10_xpic_vic_raw_intr0_encoder    = 1, /* [30] */
	BFW_NX10_xpic_vic_raw_intr0_adc        = 1  /* [31] */
};

typedef struct NX10_XPIC_VIC_RAW_INTR0_BIT_Ttag {
	unsigned int sw0        : BFW_NX10_xpic_vic_raw_intr0_sw0;        /* Reserved for Software Interrupt                                       */
	unsigned int timer0     : BFW_NX10_xpic_vic_raw_intr0_timer0;     /* xPIC Timer0 from XPIC_TIMER Module                                    */
	                                                                  /* Real time operating system timer, Windows CE required                 */
	unsigned int timer1     : BFW_NX10_xpic_vic_raw_intr0_timer1;     /* xPIC Timer1 from XPIC_TIMER Module                                    */
	unsigned int gpio_timer : BFW_NX10_xpic_vic_raw_intr0_gpio_timer; /* GPIO Timer0 or Timer1                                                 */
	                                                                  /* (sep. gpio_irq registers for ARM(intlogic) and xPIC(intlogic_motion)) */
	unsigned int timer2     : BFW_NX10_xpic_vic_raw_intr0_timer2;     /* xPIC Timer2 from XPIC_TIMER Module                                    */
	unsigned int systime_s  : BFW_NX10_xpic_vic_raw_intr0_systime_s;  /* Systime 1day IRQ from XPIC_TIMER module                               */
	unsigned int gpio7      : BFW_NX10_xpic_vic_raw_intr0_gpio7;      /* external interrupt 7, Windows CE required (NMI)                       */
	unsigned int watchdog   : BFW_NX10_xpic_vic_raw_intr0_watchdog;   /* Watchdog IRQ from XPIC_WDG module                                     */
	unsigned int uart0      : BFW_NX10_xpic_vic_raw_intr0_uart0;      /* UART 0 -> Diagnostic channel, Windows CE required                     */
	unsigned int uart1      : BFW_NX10_xpic_vic_raw_intr0_uart1;      /* UART 1                                                                */
	unsigned int reserved10 : BFW_NX10_xpic_vic_raw_intr0_reserved10; /* reserved for netX compatibility (uart2)                               */
	unsigned int usb        : BFW_NX10_xpic_vic_raw_intr0_usb;        /* USB interrupt                                                         */
	unsigned int spi        : BFW_NX10_xpic_vic_raw_intr0_spi;        /* combimned SPI0, SPI1 interrupt                                        */
	unsigned int i2c        : BFW_NX10_xpic_vic_raw_intr0_i2c;        /* I2C                                                                   */
	unsigned int reserved14 : BFW_NX10_xpic_vic_raw_intr0_reserved14; /* reserved for netX compatibility (lcd)                                 */
	unsigned int hif        : BFW_NX10_xpic_vic_raw_intr0_hif;        /* HIF/DPM interrupt                                                     */
	unsigned int gpio       : BFW_NX10_xpic_vic_raw_intr0_gpio;       /* other external Interrupts from GPIO 0-6 / IOLINK                      */
	unsigned int com0       : BFW_NX10_xpic_vic_raw_intr0_com0;       /* Communication channel 0 (= |xpec0_irq[11:0])                          */
	unsigned int reserved18 : BFW_NX10_xpic_vic_raw_intr0_reserved18; /* reserved for netX compatibility (com1)                                */
	unsigned int reserved19 : BFW_NX10_xpic_vic_raw_intr0_reserved19; /* reserved for netX compatibility (com2)                                */
	unsigned int reserved20 : BFW_NX10_xpic_vic_raw_intr0_reserved20; /* reserved  (com3)                                                      */
	unsigned int msync0     : BFW_NX10_xpic_vic_raw_intr0_msync0;     /* Motion synchronization channel 0 (= |xpec0_irq[15:12])                */
	unsigned int reserved22 : BFW_NX10_xpic_vic_raw_intr0_reserved22; /* reserved for netX compatibility (msync1)                              */
	unsigned int reserved23 : BFW_NX10_xpic_vic_raw_intr0_reserved23; /* reserved for netX compatibility (msync2)                              */
	unsigned int msync3     : BFW_NX10_xpic_vic_raw_intr0_msync3;     /* reserved for SW IRQ from ARM to xPIC                                  */
	unsigned int int_phy    : BFW_NX10_xpic_vic_raw_intr0_int_phy;    /* Interrupt from internal Phy                                           */
	unsigned int sysstate   : BFW_NX10_xpic_vic_raw_intr0_sysstate;   /* License error or extmem_timeout                                       */
	unsigned int dmac       : BFW_NX10_xpic_vic_raw_intr0_dmac;       /* DMA controller                                                        */
	unsigned int reserved28 : BFW_NX10_xpic_vic_raw_intr0_reserved28; /* reserved for netX compatibility (trigger_lt)                          */
	unsigned int pwm        : BFW_NX10_xpic_vic_raw_intr0_pwm;        /* Any PWM IRQ                                                           */
	unsigned int encoder    : BFW_NX10_xpic_vic_raw_intr0_encoder;    /* Any encoder IRQ                                                       */
	unsigned int adc        : BFW_NX10_xpic_vic_raw_intr0_adc;        /* ADC0 or ADC1                                                          */
} NX10_XPIC_VIC_RAW_INTR0_BIT_T;

typedef union {
	unsigned int                  val;
	NX10_XPIC_VIC_RAW_INTR0_BIT_T bf;
} NX10_XPIC_VIC_RAW_INTR0_T;

/* --------------------------------------------------------------------- */
/* Register xpic_vic_raw_intr1 */
/* => XPIC VIC Raw1 interrupt status register */
/* => Mode: R */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX10_xpic_vic_raw_intr1      0x00000008U
#define Adr_NX10_xpic_vic_xpic_vic_raw_intr1 0x10140808U
#define Adr_NX10_xpic_vic_raw_intr1          0x10140808U

#define MSK_NX10_xpic_vic_raw_intr1_adc0         0x00000001U
#define SRT_NX10_xpic_vic_raw_intr1_adc0         0
#define MSK_NX10_xpic_vic_raw_intr1_adc1         0x00000002U
#define SRT_NX10_xpic_vic_raw_intr1_adc1         1
#define MSK_NX10_xpic_vic_raw_intr1_enc0         0x00000004U
#define SRT_NX10_xpic_vic_raw_intr1_enc0         2
#define MSK_NX10_xpic_vic_raw_intr1_enc1         0x00000008U
#define SRT_NX10_xpic_vic_raw_intr1_enc1         3
#define MSK_NX10_xpic_vic_raw_intr1_cap0         0x00000010U
#define SRT_NX10_xpic_vic_raw_intr1_cap0         4
#define MSK_NX10_xpic_vic_raw_intr1_cap1         0x00000020U
#define SRT_NX10_xpic_vic_raw_intr1_cap1         5
#define MSK_NX10_xpic_vic_raw_intr1_cap2         0x00000040U
#define SRT_NX10_xpic_vic_raw_intr1_cap2         6
#define MSK_NX10_xpic_vic_raw_intr1_cap3         0x00000080U
#define SRT_NX10_xpic_vic_raw_intr1_cap3         7
#define MSK_NX10_xpic_vic_raw_intr1_mp0          0x00000100U
#define SRT_NX10_xpic_vic_raw_intr1_mp0          8
#define MSK_NX10_xpic_vic_raw_intr1_mp1          0x00000200U
#define SRT_NX10_xpic_vic_raw_intr1_mp1          9
#define MSK_NX10_xpic_vic_raw_intr1_mpwm0        0x00000400U
#define SRT_NX10_xpic_vic_raw_intr1_mpwm0        10
#define MSK_NX10_xpic_vic_raw_intr1_mpwm1        0x00000800U
#define SRT_NX10_xpic_vic_raw_intr1_mpwm1        11
#define MSK_NX10_xpic_vic_raw_intr1_mpwm_failure 0x00001000U
#define SRT_NX10_xpic_vic_raw_intr1_mpwm_failure 12
#define MSK_NX10_xpic_vic_raw_intr1_spi0         0x00002000U
#define SRT_NX10_xpic_vic_raw_intr1_spi0         13
#define MSK_NX10_xpic_vic_raw_intr1_spi1         0x00004000U
#define SRT_NX10_xpic_vic_raw_intr1_spi1         14
#define MSK_NX10_xpic_vic_raw_intr1_gpio_timer0  0x00008000U
#define SRT_NX10_xpic_vic_raw_intr1_gpio_timer0  15
#define MSK_NX10_xpic_vic_raw_intr1_gpio_timer1  0x00010000U
#define SRT_NX10_xpic_vic_raw_intr1_gpio_timer1  16
#define MSK_NX10_xpic_vic_raw_intr1_gpio0        0x00020000U
#define SRT_NX10_xpic_vic_raw_intr1_gpio0        17
#define MSK_NX10_xpic_vic_raw_intr1_gpio1        0x00040000U
#define SRT_NX10_xpic_vic_raw_intr1_gpio1        18
#define MSK_NX10_xpic_vic_raw_intr1_gpio2        0x00080000U
#define SRT_NX10_xpic_vic_raw_intr1_gpio2        19
#define MSK_NX10_xpic_vic_raw_intr1_gpio3        0x00100000U
#define SRT_NX10_xpic_vic_raw_intr1_gpio3        20
#define MSK_NX10_xpic_vic_raw_intr1_gpio4        0x00200000U
#define SRT_NX10_xpic_vic_raw_intr1_gpio4        21
#define MSK_NX10_xpic_vic_raw_intr1_gpio5        0x00400000U
#define SRT_NX10_xpic_vic_raw_intr1_gpio5        22
#define MSK_NX10_xpic_vic_raw_intr1_gpio6        0x00800000U
#define SRT_NX10_xpic_vic_raw_intr1_gpio6        23
#define MSK_NX10_xpic_vic_raw_intr1_reserved24   0x01000000U
#define SRT_NX10_xpic_vic_raw_intr1_reserved24   24
#define MSK_NX10_xpic_vic_raw_intr1_reserved25   0x02000000U
#define SRT_NX10_xpic_vic_raw_intr1_reserved25   25
#define MSK_NX10_xpic_vic_raw_intr1_reserved26   0x04000000U
#define SRT_NX10_xpic_vic_raw_intr1_reserved26   26
#define MSK_NX10_xpic_vic_raw_intr1_reserved27   0x08000000U
#define SRT_NX10_xpic_vic_raw_intr1_reserved27   27
#define MSK_NX10_xpic_vic_raw_intr1_reserved28   0x10000000U
#define SRT_NX10_xpic_vic_raw_intr1_reserved28   28
#define MSK_NX10_xpic_vic_raw_intr1_reserved29   0x20000000U
#define SRT_NX10_xpic_vic_raw_intr1_reserved29   29
#define MSK_NX10_xpic_vic_raw_intr1_reserved30   0x40000000U
#define SRT_NX10_xpic_vic_raw_intr1_reserved30   30
#define MSK_NX10_xpic_vic_raw_intr1_misalign     0x80000000U
#define SRT_NX10_xpic_vic_raw_intr1_misalign     31

enum {
	BFW_NX10_xpic_vic_raw_intr1_adc0         = 1, /* [0] */
	BFW_NX10_xpic_vic_raw_intr1_adc1         = 1, /* [1] */
	BFW_NX10_xpic_vic_raw_intr1_enc0         = 1, /* [2] */
	BFW_NX10_xpic_vic_raw_intr1_enc1         = 1, /* [3] */
	BFW_NX10_xpic_vic_raw_intr1_cap0         = 1, /* [4] */
	BFW_NX10_xpic_vic_raw_intr1_cap1         = 1, /* [5] */
	BFW_NX10_xpic_vic_raw_intr1_cap2         = 1, /* [6] */
	BFW_NX10_xpic_vic_raw_intr1_cap3         = 1, /* [7] */
	BFW_NX10_xpic_vic_raw_intr1_mp0          = 1, /* [8] */
	BFW_NX10_xpic_vic_raw_intr1_mp1          = 1, /* [9] */
	BFW_NX10_xpic_vic_raw_intr1_mpwm0        = 1, /* [10] */
	BFW_NX10_xpic_vic_raw_intr1_mpwm1        = 1, /* [11] */
	BFW_NX10_xpic_vic_raw_intr1_mpwm_failure = 1, /* [12] */
	BFW_NX10_xpic_vic_raw_intr1_spi0         = 1, /* [13] */
	BFW_NX10_xpic_vic_raw_intr1_spi1         = 1, /* [14] */
	BFW_NX10_xpic_vic_raw_intr1_gpio_timer0  = 1, /* [15] */
	BFW_NX10_xpic_vic_raw_intr1_gpio_timer1  = 1, /* [16] */
	BFW_NX10_xpic_vic_raw_intr1_gpio0        = 1, /* [17] */
	BFW_NX10_xpic_vic_raw_intr1_gpio1        = 1, /* [18] */
	BFW_NX10_xpic_vic_raw_intr1_gpio2        = 1, /* [19] */
	BFW_NX10_xpic_vic_raw_intr1_gpio3        = 1, /* [20] */
	BFW_NX10_xpic_vic_raw_intr1_gpio4        = 1, /* [21] */
	BFW_NX10_xpic_vic_raw_intr1_gpio5        = 1, /* [22] */
	BFW_NX10_xpic_vic_raw_intr1_gpio6        = 1, /* [23] */
	BFW_NX10_xpic_vic_raw_intr1_reserved24   = 1, /* [24] */
	BFW_NX10_xpic_vic_raw_intr1_reserved25   = 1, /* [25] */
	BFW_NX10_xpic_vic_raw_intr1_reserved26   = 1, /* [26] */
	BFW_NX10_xpic_vic_raw_intr1_reserved27   = 1, /* [27] */
	BFW_NX10_xpic_vic_raw_intr1_reserved28   = 1, /* [28] */
	BFW_NX10_xpic_vic_raw_intr1_reserved29   = 1, /* [29] */
	BFW_NX10_xpic_vic_raw_intr1_reserved30   = 1, /* [30] */
	BFW_NX10_xpic_vic_raw_intr1_misalign     = 1  /* [31] */
};

typedef struct NX10_XPIC_VIC_RAW_INTR1_BIT_Ttag {
	unsigned int adc0         : BFW_NX10_xpic_vic_raw_intr1_adc0;         /* ADC0                   */
	unsigned int adc1         : BFW_NX10_xpic_vic_raw_intr1_adc1;         /* ADC1                   */
	unsigned int enc0         : BFW_NX10_xpic_vic_raw_intr1_enc0;         /* Encoder0 (ovfl, edge)  */
	unsigned int enc1         : BFW_NX10_xpic_vic_raw_intr1_enc1;         /* Encoder1 (ovfl, edge)  */
	unsigned int cap0         : BFW_NX10_xpic_vic_raw_intr1_cap0;         /* Encoder Capture Unit 0 */
	unsigned int cap1         : BFW_NX10_xpic_vic_raw_intr1_cap1;         /* Encoder Capture Unit 1 */
	unsigned int cap2         : BFW_NX10_xpic_vic_raw_intr1_cap2;         /* Encoder Capture Unit 2 */
	unsigned int cap3         : BFW_NX10_xpic_vic_raw_intr1_cap3;         /* Encoder Capture Unit 3 */
	unsigned int mp0          : BFW_NX10_xpic_vic_raw_intr1_mp0;          /* Encoder mp0            */
	unsigned int mp1          : BFW_NX10_xpic_vic_raw_intr1_mp1;          /* Encoder mp1            */
	unsigned int mpwm0        : BFW_NX10_xpic_vic_raw_intr1_mpwm0;        /* mpwm0                  */
	unsigned int mpwm1        : BFW_NX10_xpic_vic_raw_intr1_mpwm1;        /* mpwm1                  */
	unsigned int mpwm_failure : BFW_NX10_xpic_vic_raw_intr1_mpwm_failure; /* mpwm_failure           */
	unsigned int spi0         : BFW_NX10_xpic_vic_raw_intr1_spi0;         /* spi0                   */
	unsigned int spi1         : BFW_NX10_xpic_vic_raw_intr1_spi1;         /* spi1                   */
	unsigned int gpio_timer0  : BFW_NX10_xpic_vic_raw_intr1_gpio_timer0;  /* gpio_timer0            */
	unsigned int gpio_timer1  : BFW_NX10_xpic_vic_raw_intr1_gpio_timer1;  /* gpio_timer1            */
	unsigned int gpio0        : BFW_NX10_xpic_vic_raw_intr1_gpio0;        /* gpio0                  */
	unsigned int gpio1        : BFW_NX10_xpic_vic_raw_intr1_gpio1;        /* gpio1                  */
	unsigned int gpio2        : BFW_NX10_xpic_vic_raw_intr1_gpio2;        /* gpio2                  */
	unsigned int gpio3        : BFW_NX10_xpic_vic_raw_intr1_gpio3;        /* gpio3                  */
	unsigned int gpio4        : BFW_NX10_xpic_vic_raw_intr1_gpio4;        /* gpio4                  */
	unsigned int gpio5        : BFW_NX10_xpic_vic_raw_intr1_gpio5;        /* gpio5                  */
	unsigned int gpio6        : BFW_NX10_xpic_vic_raw_intr1_gpio6;        /* gpio6                  */
	unsigned int reserved24   : BFW_NX10_xpic_vic_raw_intr1_reserved24;   /* reserved               */
	unsigned int reserved25   : BFW_NX10_xpic_vic_raw_intr1_reserved25;   /* reserved               */
	unsigned int reserved26   : BFW_NX10_xpic_vic_raw_intr1_reserved26;   /* reserved               */
	unsigned int reserved27   : BFW_NX10_xpic_vic_raw_intr1_reserved27;   /* reserved               */
	unsigned int reserved28   : BFW_NX10_xpic_vic_raw_intr1_reserved28;   /* reserved               */
	unsigned int reserved29   : BFW_NX10_xpic_vic_raw_intr1_reserved29;   /* reserved               */
	unsigned int reserved30   : BFW_NX10_xpic_vic_raw_intr1_reserved30;   /* reserved               */
	unsigned int misalign     : BFW_NX10_xpic_vic_raw_intr1_misalign;     /* xPIC data misalignment */
} NX10_XPIC_VIC_RAW_INTR1_BIT_T;

typedef union {
	unsigned int                  val;
	NX10_XPIC_VIC_RAW_INTR1_BIT_T bf;
} NX10_XPIC_VIC_RAW_INTR1_T;

/* --------------------------------------------------------------------- */
/* Register xpic_vic_softint0_set */
/* => XPIC VIC Software0 interrupt set register */
/*    read status */
/*    write (1) set */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX10_xpic_vic_softint0_set      0x0000000CU
#define Adr_NX10_xpic_vic_xpic_vic_softint0_set 0x1014080CU
#define Adr_NX10_xpic_vic_softint0_set          0x1014080CU
#define DFLT_VAL_NX10_xpic_vic_softint0_set     0x00000000U

#define MSK_NX10_xpic_vic_softint0_set_sw0             0x00000001U
#define SRT_NX10_xpic_vic_softint0_set_sw0             0
#define DFLT_VAL_NX10_xpic_vic_softint0_set_sw0        0x00000000U
#define MSK_NX10_xpic_vic_softint0_set_timer0          0x00000002U
#define SRT_NX10_xpic_vic_softint0_set_timer0          1
#define DFLT_VAL_NX10_xpic_vic_softint0_set_timer0     0x00000000U
#define MSK_NX10_xpic_vic_softint0_set_timer1          0x00000004U
#define SRT_NX10_xpic_vic_softint0_set_timer1          2
#define DFLT_VAL_NX10_xpic_vic_softint0_set_timer1     0x00000000U
#define MSK_NX10_xpic_vic_softint0_set_gpio_timer      0x00000008U
#define SRT_NX10_xpic_vic_softint0_set_gpio_timer      3
#define DFLT_VAL_NX10_xpic_vic_softint0_set_gpio_timer 0x00000000U
#define MSK_NX10_xpic_vic_softint0_set_timer2          0x00000010U
#define SRT_NX10_xpic_vic_softint0_set_timer2          4
#define DFLT_VAL_NX10_xpic_vic_softint0_set_timer2     0x00000000U
#define MSK_NX10_xpic_vic_softint0_set_systime_s       0x00000020U
#define SRT_NX10_xpic_vic_softint0_set_systime_s       5
#define DFLT_VAL_NX10_xpic_vic_softint0_set_systime_s  0x00000000U
#define MSK_NX10_xpic_vic_softint0_set_gpio7           0x00000040U
#define SRT_NX10_xpic_vic_softint0_set_gpio7           6
#define DFLT_VAL_NX10_xpic_vic_softint0_set_gpio7      0x00000000U
#define MSK_NX10_xpic_vic_softint0_set_watchdog        0x00000080U
#define SRT_NX10_xpic_vic_softint0_set_watchdog        7
#define DFLT_VAL_NX10_xpic_vic_softint0_set_watchdog   0x00000000U
#define MSK_NX10_xpic_vic_softint0_set_uart0           0x00000100U
#define SRT_NX10_xpic_vic_softint0_set_uart0           8
#define DFLT_VAL_NX10_xpic_vic_softint0_set_uart0      0x00000000U
#define MSK_NX10_xpic_vic_softint0_set_uart1           0x00000200U
#define SRT_NX10_xpic_vic_softint0_set_uart1           9
#define DFLT_VAL_NX10_xpic_vic_softint0_set_uart1      0x00000000U
#define MSK_NX10_xpic_vic_softint0_set_reserved10      0x00000400U
#define SRT_NX10_xpic_vic_softint0_set_reserved10      10
#define DFLT_VAL_NX10_xpic_vic_softint0_set_reserved10 0x00000000U
#define MSK_NX10_xpic_vic_softint0_set_usb             0x00000800U
#define SRT_NX10_xpic_vic_softint0_set_usb             11
#define DFLT_VAL_NX10_xpic_vic_softint0_set_usb        0x00000000U
#define MSK_NX10_xpic_vic_softint0_set_spi             0x00001000U
#define SRT_NX10_xpic_vic_softint0_set_spi             12
#define DFLT_VAL_NX10_xpic_vic_softint0_set_spi        0x00000000U
#define MSK_NX10_xpic_vic_softint0_set_i2c             0x00002000U
#define SRT_NX10_xpic_vic_softint0_set_i2c             13
#define DFLT_VAL_NX10_xpic_vic_softint0_set_i2c        0x00000000U
#define MSK_NX10_xpic_vic_softint0_set_reserved14      0x00004000U
#define SRT_NX10_xpic_vic_softint0_set_reserved14      14
#define DFLT_VAL_NX10_xpic_vic_softint0_set_reserved14 0x00000000U
#define MSK_NX10_xpic_vic_softint0_set_hif             0x00008000U
#define SRT_NX10_xpic_vic_softint0_set_hif             15
#define DFLT_VAL_NX10_xpic_vic_softint0_set_hif        0x00000000U
#define MSK_NX10_xpic_vic_softint0_set_gpio            0x00010000U
#define SRT_NX10_xpic_vic_softint0_set_gpio            16
#define DFLT_VAL_NX10_xpic_vic_softint0_set_gpio       0x00000000U
#define MSK_NX10_xpic_vic_softint0_set_com0            0x00020000U
#define SRT_NX10_xpic_vic_softint0_set_com0            17
#define DFLT_VAL_NX10_xpic_vic_softint0_set_com0       0x00000000U
#define MSK_NX10_xpic_vic_softint0_set_reserved18      0x00040000U
#define SRT_NX10_xpic_vic_softint0_set_reserved18      18
#define DFLT_VAL_NX10_xpic_vic_softint0_set_reserved18 0x00000000U
#define MSK_NX10_xpic_vic_softint0_set_reserved19      0x00080000U
#define SRT_NX10_xpic_vic_softint0_set_reserved19      19
#define DFLT_VAL_NX10_xpic_vic_softint0_set_reserved19 0x00000000U
#define MSK_NX10_xpic_vic_softint0_set_reserved20      0x00100000U
#define SRT_NX10_xpic_vic_softint0_set_reserved20      20
#define DFLT_VAL_NX10_xpic_vic_softint0_set_reserved20 0x00000000U
#define MSK_NX10_xpic_vic_softint0_set_msync0          0x00200000U
#define SRT_NX10_xpic_vic_softint0_set_msync0          21
#define DFLT_VAL_NX10_xpic_vic_softint0_set_msync0     0x00000000U
#define MSK_NX10_xpic_vic_softint0_set_reserved22      0x00400000U
#define SRT_NX10_xpic_vic_softint0_set_reserved22      22
#define DFLT_VAL_NX10_xpic_vic_softint0_set_reserved22 0x00000000U
#define MSK_NX10_xpic_vic_softint0_set_reserved23      0x00800000U
#define SRT_NX10_xpic_vic_softint0_set_reserved23      23
#define DFLT_VAL_NX10_xpic_vic_softint0_set_reserved23 0x00000000U
#define MSK_NX10_xpic_vic_softint0_set_msync3          0x01000000U
#define SRT_NX10_xpic_vic_softint0_set_msync3          24
#define DFLT_VAL_NX10_xpic_vic_softint0_set_msync3     0x00000000U
#define MSK_NX10_xpic_vic_softint0_set_int_phy         0x02000000U
#define SRT_NX10_xpic_vic_softint0_set_int_phy         25
#define DFLT_VAL_NX10_xpic_vic_softint0_set_int_phy    0x00000000U
#define MSK_NX10_xpic_vic_softint0_set_sysstate        0x04000000U
#define SRT_NX10_xpic_vic_softint0_set_sysstate        26
#define DFLT_VAL_NX10_xpic_vic_softint0_set_sysstate   0x00000000U
#define MSK_NX10_xpic_vic_softint0_set_dmac            0x08000000U
#define SRT_NX10_xpic_vic_softint0_set_dmac            27
#define DFLT_VAL_NX10_xpic_vic_softint0_set_dmac       0x00000000U
#define MSK_NX10_xpic_vic_softint0_set_reserved28      0x10000000U
#define SRT_NX10_xpic_vic_softint0_set_reserved28      28
#define DFLT_VAL_NX10_xpic_vic_softint0_set_reserved28 0x00000000U
#define MSK_NX10_xpic_vic_softint0_set_pwm             0x20000000U
#define SRT_NX10_xpic_vic_softint0_set_pwm             29
#define DFLT_VAL_NX10_xpic_vic_softint0_set_pwm        0x00000000U
#define MSK_NX10_xpic_vic_softint0_set_encoder         0x40000000U
#define SRT_NX10_xpic_vic_softint0_set_encoder         30
#define DFLT_VAL_NX10_xpic_vic_softint0_set_encoder    0x00000000U
#define MSK_NX10_xpic_vic_softint0_set_adc             0x80000000U
#define SRT_NX10_xpic_vic_softint0_set_adc             31
#define DFLT_VAL_NX10_xpic_vic_softint0_set_adc        0x00000000U

enum {
	BFW_NX10_xpic_vic_softint0_set_sw0        = 1, /* [0] */
	BFW_NX10_xpic_vic_softint0_set_timer0     = 1, /* [1] */
	BFW_NX10_xpic_vic_softint0_set_timer1     = 1, /* [2] */
	BFW_NX10_xpic_vic_softint0_set_gpio_timer = 1, /* [3] */
	BFW_NX10_xpic_vic_softint0_set_timer2     = 1, /* [4] */
	BFW_NX10_xpic_vic_softint0_set_systime_s  = 1, /* [5] */
	BFW_NX10_xpic_vic_softint0_set_gpio7      = 1, /* [6] */
	BFW_NX10_xpic_vic_softint0_set_watchdog   = 1, /* [7] */
	BFW_NX10_xpic_vic_softint0_set_uart0      = 1, /* [8] */
	BFW_NX10_xpic_vic_softint0_set_uart1      = 1, /* [9] */
	BFW_NX10_xpic_vic_softint0_set_reserved10 = 1, /* [10] */
	BFW_NX10_xpic_vic_softint0_set_usb        = 1, /* [11] */
	BFW_NX10_xpic_vic_softint0_set_spi        = 1, /* [12] */
	BFW_NX10_xpic_vic_softint0_set_i2c        = 1, /* [13] */
	BFW_NX10_xpic_vic_softint0_set_reserved14 = 1, /* [14] */
	BFW_NX10_xpic_vic_softint0_set_hif        = 1, /* [15] */
	BFW_NX10_xpic_vic_softint0_set_gpio       = 1, /* [16] */
	BFW_NX10_xpic_vic_softint0_set_com0       = 1, /* [17] */
	BFW_NX10_xpic_vic_softint0_set_reserved18 = 1, /* [18] */
	BFW_NX10_xpic_vic_softint0_set_reserved19 = 1, /* [19] */
	BFW_NX10_xpic_vic_softint0_set_reserved20 = 1, /* [20] */
	BFW_NX10_xpic_vic_softint0_set_msync0     = 1, /* [21] */
	BFW_NX10_xpic_vic_softint0_set_reserved22 = 1, /* [22] */
	BFW_NX10_xpic_vic_softint0_set_reserved23 = 1, /* [23] */
	BFW_NX10_xpic_vic_softint0_set_msync3     = 1, /* [24] */
	BFW_NX10_xpic_vic_softint0_set_int_phy    = 1, /* [25] */
	BFW_NX10_xpic_vic_softint0_set_sysstate   = 1, /* [26] */
	BFW_NX10_xpic_vic_softint0_set_dmac       = 1, /* [27] */
	BFW_NX10_xpic_vic_softint0_set_reserved28 = 1, /* [28] */
	BFW_NX10_xpic_vic_softint0_set_pwm        = 1, /* [29] */
	BFW_NX10_xpic_vic_softint0_set_encoder    = 1, /* [30] */
	BFW_NX10_xpic_vic_softint0_set_adc        = 1  /* [31] */
};

typedef struct NX10_XPIC_VIC_SOFTINT0_SET_BIT_Ttag {
	unsigned int sw0        : BFW_NX10_xpic_vic_softint0_set_sw0;        /* Reserved for Software Interrupt                                       */
	unsigned int timer0     : BFW_NX10_xpic_vic_softint0_set_timer0;     /* xPIC Timer0 from XPIC_TIMER Module                                    */
	                                                                     /* Real time operating system timer, Windows CE required                 */
	unsigned int timer1     : BFW_NX10_xpic_vic_softint0_set_timer1;     /* xPIC Timer1 from XPIC_TIMER Module                                    */
	unsigned int gpio_timer : BFW_NX10_xpic_vic_softint0_set_gpio_timer; /* GPIO Timer0 or Timer1                                                 */
	                                                                     /* (sep. gpio_irq registers for ARM(intlogic) and xPIC(intlogic_motion)) */
	unsigned int timer2     : BFW_NX10_xpic_vic_softint0_set_timer2;     /* xPIC Timer2 from XPIC_TIMER Module                                    */
	unsigned int systime_s  : BFW_NX10_xpic_vic_softint0_set_systime_s;  /* Systime 1day IRQ from XPIC_TIMER module                               */
	unsigned int gpio7      : BFW_NX10_xpic_vic_softint0_set_gpio7;      /* external interrupt 7, Windows CE required (NMI)                       */
	unsigned int watchdog   : BFW_NX10_xpic_vic_softint0_set_watchdog;   /* Watchdog IRQ from XPIC_WDG module                                     */
	unsigned int uart0      : BFW_NX10_xpic_vic_softint0_set_uart0;      /* UART 0 -> Diagnostic channel, Windows CE required                     */
	unsigned int uart1      : BFW_NX10_xpic_vic_softint0_set_uart1;      /* UART 1                                                                */
	unsigned int reserved10 : BFW_NX10_xpic_vic_softint0_set_reserved10; /* reserved for netX compatibility (uart2)                               */
	unsigned int usb        : BFW_NX10_xpic_vic_softint0_set_usb;        /* USB interrupt                                                         */
	unsigned int spi        : BFW_NX10_xpic_vic_softint0_set_spi;        /* combimned SPI0, SPI1 interrupt                                        */
	unsigned int i2c        : BFW_NX10_xpic_vic_softint0_set_i2c;        /* I2C                                                                   */
	unsigned int reserved14 : BFW_NX10_xpic_vic_softint0_set_reserved14; /* reserved for netX compatibility (lcd)                                 */
	unsigned int hif        : BFW_NX10_xpic_vic_softint0_set_hif;        /* HIF/DPM interrupt                                                     */
	unsigned int gpio       : BFW_NX10_xpic_vic_softint0_set_gpio;       /* other external Interrupts from GPIO 0-6 / IOLINK                      */
	unsigned int com0       : BFW_NX10_xpic_vic_softint0_set_com0;       /* Communication channel 0 (= |xpec0_irq[11:0])                          */
	unsigned int reserved18 : BFW_NX10_xpic_vic_softint0_set_reserved18; /* reserved for netX compatibility (com1)                                */
	unsigned int reserved19 : BFW_NX10_xpic_vic_softint0_set_reserved19; /* reserved for netX compatibility (com2)                                */
	unsigned int reserved20 : BFW_NX10_xpic_vic_softint0_set_reserved20; /* reserved  (com3)                                                      */
	unsigned int msync0     : BFW_NX10_xpic_vic_softint0_set_msync0;     /* Motion synchronization channel 0 (= |xpec0_irq[15:12])                */
	unsigned int reserved22 : BFW_NX10_xpic_vic_softint0_set_reserved22; /* reserved for netX compatibility (msync1)                              */
	unsigned int reserved23 : BFW_NX10_xpic_vic_softint0_set_reserved23; /* reserved for netX compatibility (msync2)                              */
	unsigned int msync3     : BFW_NX10_xpic_vic_softint0_set_msync3;     /* reserved for SW IRQ from ARM to xPIC                                  */
	unsigned int int_phy    : BFW_NX10_xpic_vic_softint0_set_int_phy;    /* Interrupt from internal Phy                                           */
	unsigned int sysstate   : BFW_NX10_xpic_vic_softint0_set_sysstate;   /* License error or extmem_timeout                                       */
	unsigned int dmac       : BFW_NX10_xpic_vic_softint0_set_dmac;       /* DMA controller                                                        */
	unsigned int reserved28 : BFW_NX10_xpic_vic_softint0_set_reserved28; /* reserved for netX compatibility (trigger_lt)                          */
	unsigned int pwm        : BFW_NX10_xpic_vic_softint0_set_pwm;        /* Any PWM IRQ                                                           */
	unsigned int encoder    : BFW_NX10_xpic_vic_softint0_set_encoder;    /* Any encoder IRQ                                                       */
	unsigned int adc        : BFW_NX10_xpic_vic_softint0_set_adc;        /* ADC0 or ADC1                                                          */
} NX10_XPIC_VIC_SOFTINT0_SET_BIT_T;

typedef union {
	unsigned int                     val;
	NX10_XPIC_VIC_SOFTINT0_SET_BIT_T bf;
} NX10_XPIC_VIC_SOFTINT0_SET_T;

/* --------------------------------------------------------------------- */
/* Register xpic_vic_softint1_set */
/* => XPIC VIC Software1 interrupt set register */
/*    read status */
/*    write (1) set */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX10_xpic_vic_softint1_set      0x00000010U
#define Adr_NX10_xpic_vic_xpic_vic_softint1_set 0x10140810U
#define Adr_NX10_xpic_vic_softint1_set          0x10140810U
#define DFLT_VAL_NX10_xpic_vic_softint1_set     0x00000000U

#define MSK_NX10_xpic_vic_softint1_set_adc0              0x00000001U
#define SRT_NX10_xpic_vic_softint1_set_adc0              0
#define DFLT_VAL_NX10_xpic_vic_softint1_set_adc0         0x00000000U
#define MSK_NX10_xpic_vic_softint1_set_adc1              0x00000002U
#define SRT_NX10_xpic_vic_softint1_set_adc1              1
#define DFLT_VAL_NX10_xpic_vic_softint1_set_adc1         0x00000000U
#define MSK_NX10_xpic_vic_softint1_set_enc0              0x00000004U
#define SRT_NX10_xpic_vic_softint1_set_enc0              2
#define DFLT_VAL_NX10_xpic_vic_softint1_set_enc0         0x00000000U
#define MSK_NX10_xpic_vic_softint1_set_enc1              0x00000008U
#define SRT_NX10_xpic_vic_softint1_set_enc1              3
#define DFLT_VAL_NX10_xpic_vic_softint1_set_enc1         0x00000000U
#define MSK_NX10_xpic_vic_softint1_set_cap0              0x00000010U
#define SRT_NX10_xpic_vic_softint1_set_cap0              4
#define DFLT_VAL_NX10_xpic_vic_softint1_set_cap0         0x00000000U
#define MSK_NX10_xpic_vic_softint1_set_cap1              0x00000020U
#define SRT_NX10_xpic_vic_softint1_set_cap1              5
#define DFLT_VAL_NX10_xpic_vic_softint1_set_cap1         0x00000000U
#define MSK_NX10_xpic_vic_softint1_set_cap2              0x00000040U
#define SRT_NX10_xpic_vic_softint1_set_cap2              6
#define DFLT_VAL_NX10_xpic_vic_softint1_set_cap2         0x00000000U
#define MSK_NX10_xpic_vic_softint1_set_cap3              0x00000080U
#define SRT_NX10_xpic_vic_softint1_set_cap3              7
#define DFLT_VAL_NX10_xpic_vic_softint1_set_cap3         0x00000000U
#define MSK_NX10_xpic_vic_softint1_set_mp0               0x00000100U
#define SRT_NX10_xpic_vic_softint1_set_mp0               8
#define DFLT_VAL_NX10_xpic_vic_softint1_set_mp0          0x00000000U
#define MSK_NX10_xpic_vic_softint1_set_mp1               0x00000200U
#define SRT_NX10_xpic_vic_softint1_set_mp1               9
#define DFLT_VAL_NX10_xpic_vic_softint1_set_mp1          0x00000000U
#define MSK_NX10_xpic_vic_softint1_set_mpwm0             0x00000400U
#define SRT_NX10_xpic_vic_softint1_set_mpwm0             10
#define DFLT_VAL_NX10_xpic_vic_softint1_set_mpwm0        0x00000000U
#define MSK_NX10_xpic_vic_softint1_set_mpwm1             0x00000800U
#define SRT_NX10_xpic_vic_softint1_set_mpwm1             11
#define DFLT_VAL_NX10_xpic_vic_softint1_set_mpwm1        0x00000000U
#define MSK_NX10_xpic_vic_softint1_set_mpwm_failure      0x00001000U
#define SRT_NX10_xpic_vic_softint1_set_mpwm_failure      12
#define DFLT_VAL_NX10_xpic_vic_softint1_set_mpwm_failure 0x00000000U
#define MSK_NX10_xpic_vic_softint1_set_spi0              0x00002000U
#define SRT_NX10_xpic_vic_softint1_set_spi0              13
#define DFLT_VAL_NX10_xpic_vic_softint1_set_spi0         0x00000000U
#define MSK_NX10_xpic_vic_softint1_set_spi1              0x00004000U
#define SRT_NX10_xpic_vic_softint1_set_spi1              14
#define DFLT_VAL_NX10_xpic_vic_softint1_set_spi1         0x00000000U
#define MSK_NX10_xpic_vic_softint1_set_gpio_timer0       0x00008000U
#define SRT_NX10_xpic_vic_softint1_set_gpio_timer0       15
#define DFLT_VAL_NX10_xpic_vic_softint1_set_gpio_timer0  0x00000000U
#define MSK_NX10_xpic_vic_softint1_set_gpio_timer1       0x00010000U
#define SRT_NX10_xpic_vic_softint1_set_gpio_timer1       16
#define DFLT_VAL_NX10_xpic_vic_softint1_set_gpio_timer1  0x00000000U
#define MSK_NX10_xpic_vic_softint1_set_gpio0             0x00020000U
#define SRT_NX10_xpic_vic_softint1_set_gpio0             17
#define DFLT_VAL_NX10_xpic_vic_softint1_set_gpio0        0x00000000U
#define MSK_NX10_xpic_vic_softint1_set_gpio1             0x00040000U
#define SRT_NX10_xpic_vic_softint1_set_gpio1             18
#define DFLT_VAL_NX10_xpic_vic_softint1_set_gpio1        0x00000000U
#define MSK_NX10_xpic_vic_softint1_set_gpio2             0x00080000U
#define SRT_NX10_xpic_vic_softint1_set_gpio2             19
#define DFLT_VAL_NX10_xpic_vic_softint1_set_gpio2        0x00000000U
#define MSK_NX10_xpic_vic_softint1_set_gpio3             0x00100000U
#define SRT_NX10_xpic_vic_softint1_set_gpio3             20
#define DFLT_VAL_NX10_xpic_vic_softint1_set_gpio3        0x00000000U
#define MSK_NX10_xpic_vic_softint1_set_gpio4             0x00200000U
#define SRT_NX10_xpic_vic_softint1_set_gpio4             21
#define DFLT_VAL_NX10_xpic_vic_softint1_set_gpio4        0x00000000U
#define MSK_NX10_xpic_vic_softint1_set_gpio5             0x00400000U
#define SRT_NX10_xpic_vic_softint1_set_gpio5             22
#define DFLT_VAL_NX10_xpic_vic_softint1_set_gpio5        0x00000000U
#define MSK_NX10_xpic_vic_softint1_set_gpio6             0x00800000U
#define SRT_NX10_xpic_vic_softint1_set_gpio6             23
#define DFLT_VAL_NX10_xpic_vic_softint1_set_gpio6        0x00000000U
#define MSK_NX10_xpic_vic_softint1_set_reserved24        0x01000000U
#define SRT_NX10_xpic_vic_softint1_set_reserved24        24
#define DFLT_VAL_NX10_xpic_vic_softint1_set_reserved24   0x00000000U
#define MSK_NX10_xpic_vic_softint1_set_reserved25        0x02000000U
#define SRT_NX10_xpic_vic_softint1_set_reserved25        25
#define DFLT_VAL_NX10_xpic_vic_softint1_set_reserved25   0x00000000U
#define MSK_NX10_xpic_vic_softint1_set_reserved26        0x04000000U
#define SRT_NX10_xpic_vic_softint1_set_reserved26        26
#define DFLT_VAL_NX10_xpic_vic_softint1_set_reserved26   0x00000000U
#define MSK_NX10_xpic_vic_softint1_set_reserved27        0x08000000U
#define SRT_NX10_xpic_vic_softint1_set_reserved27        27
#define DFLT_VAL_NX10_xpic_vic_softint1_set_reserved27   0x00000000U
#define MSK_NX10_xpic_vic_softint1_set_reserved28        0x10000000U
#define SRT_NX10_xpic_vic_softint1_set_reserved28        28
#define DFLT_VAL_NX10_xpic_vic_softint1_set_reserved28   0x00000000U
#define MSK_NX10_xpic_vic_softint1_set_reserved29        0x20000000U
#define SRT_NX10_xpic_vic_softint1_set_reserved29        29
#define DFLT_VAL_NX10_xpic_vic_softint1_set_reserved29   0x00000000U
#define MSK_NX10_xpic_vic_softint1_set_reserved30        0x40000000U
#define SRT_NX10_xpic_vic_softint1_set_reserved30        30
#define DFLT_VAL_NX10_xpic_vic_softint1_set_reserved30   0x00000000U
#define MSK_NX10_xpic_vic_softint1_set_misalign          0x80000000U
#define SRT_NX10_xpic_vic_softint1_set_misalign          31
#define DFLT_VAL_NX10_xpic_vic_softint1_set_misalign     0x00000000U

enum {
	BFW_NX10_xpic_vic_softint1_set_adc0         = 1, /* [0] */
	BFW_NX10_xpic_vic_softint1_set_adc1         = 1, /* [1] */
	BFW_NX10_xpic_vic_softint1_set_enc0         = 1, /* [2] */
	BFW_NX10_xpic_vic_softint1_set_enc1         = 1, /* [3] */
	BFW_NX10_xpic_vic_softint1_set_cap0         = 1, /* [4] */
	BFW_NX10_xpic_vic_softint1_set_cap1         = 1, /* [5] */
	BFW_NX10_xpic_vic_softint1_set_cap2         = 1, /* [6] */
	BFW_NX10_xpic_vic_softint1_set_cap3         = 1, /* [7] */
	BFW_NX10_xpic_vic_softint1_set_mp0          = 1, /* [8] */
	BFW_NX10_xpic_vic_softint1_set_mp1          = 1, /* [9] */
	BFW_NX10_xpic_vic_softint1_set_mpwm0        = 1, /* [10] */
	BFW_NX10_xpic_vic_softint1_set_mpwm1        = 1, /* [11] */
	BFW_NX10_xpic_vic_softint1_set_mpwm_failure = 1, /* [12] */
	BFW_NX10_xpic_vic_softint1_set_spi0         = 1, /* [13] */
	BFW_NX10_xpic_vic_softint1_set_spi1         = 1, /* [14] */
	BFW_NX10_xpic_vic_softint1_set_gpio_timer0  = 1, /* [15] */
	BFW_NX10_xpic_vic_softint1_set_gpio_timer1  = 1, /* [16] */
	BFW_NX10_xpic_vic_softint1_set_gpio0        = 1, /* [17] */
	BFW_NX10_xpic_vic_softint1_set_gpio1        = 1, /* [18] */
	BFW_NX10_xpic_vic_softint1_set_gpio2        = 1, /* [19] */
	BFW_NX10_xpic_vic_softint1_set_gpio3        = 1, /* [20] */
	BFW_NX10_xpic_vic_softint1_set_gpio4        = 1, /* [21] */
	BFW_NX10_xpic_vic_softint1_set_gpio5        = 1, /* [22] */
	BFW_NX10_xpic_vic_softint1_set_gpio6        = 1, /* [23] */
	BFW_NX10_xpic_vic_softint1_set_reserved24   = 1, /* [24] */
	BFW_NX10_xpic_vic_softint1_set_reserved25   = 1, /* [25] */
	BFW_NX10_xpic_vic_softint1_set_reserved26   = 1, /* [26] */
	BFW_NX10_xpic_vic_softint1_set_reserved27   = 1, /* [27] */
	BFW_NX10_xpic_vic_softint1_set_reserved28   = 1, /* [28] */
	BFW_NX10_xpic_vic_softint1_set_reserved29   = 1, /* [29] */
	BFW_NX10_xpic_vic_softint1_set_reserved30   = 1, /* [30] */
	BFW_NX10_xpic_vic_softint1_set_misalign     = 1  /* [31] */
};

typedef struct NX10_XPIC_VIC_SOFTINT1_SET_BIT_Ttag {
	unsigned int adc0         : BFW_NX10_xpic_vic_softint1_set_adc0;         /* ADC0                   */
	unsigned int adc1         : BFW_NX10_xpic_vic_softint1_set_adc1;         /* ADC1                   */
	unsigned int enc0         : BFW_NX10_xpic_vic_softint1_set_enc0;         /* Encoder0 (ovfl, edge)  */
	unsigned int enc1         : BFW_NX10_xpic_vic_softint1_set_enc1;         /* Encoder1 (ovfl, edge)  */
	unsigned int cap0         : BFW_NX10_xpic_vic_softint1_set_cap0;         /* Encoder Capture Unit 0 */
	unsigned int cap1         : BFW_NX10_xpic_vic_softint1_set_cap1;         /* Encoder Capture Unit 1 */
	unsigned int cap2         : BFW_NX10_xpic_vic_softint1_set_cap2;         /* Encoder Capture Unit 2 */
	unsigned int cap3         : BFW_NX10_xpic_vic_softint1_set_cap3;         /* Encoder Capture Unit 3 */
	unsigned int mp0          : BFW_NX10_xpic_vic_softint1_set_mp0;          /* Encoder mp0            */
	unsigned int mp1          : BFW_NX10_xpic_vic_softint1_set_mp1;          /* Encoder mp1            */
	unsigned int mpwm0        : BFW_NX10_xpic_vic_softint1_set_mpwm0;        /* mpwm0                  */
	unsigned int mpwm1        : BFW_NX10_xpic_vic_softint1_set_mpwm1;        /* mpwm1                  */
	unsigned int mpwm_failure : BFW_NX10_xpic_vic_softint1_set_mpwm_failure; /* mpwm_failure           */
	unsigned int spi0         : BFW_NX10_xpic_vic_softint1_set_spi0;         /* spi0                   */
	unsigned int spi1         : BFW_NX10_xpic_vic_softint1_set_spi1;         /* spi1                   */
	unsigned int gpio_timer0  : BFW_NX10_xpic_vic_softint1_set_gpio_timer0;  /* gpio_timer0            */
	unsigned int gpio_timer1  : BFW_NX10_xpic_vic_softint1_set_gpio_timer1;  /* gpio_timer1            */
	unsigned int gpio0        : BFW_NX10_xpic_vic_softint1_set_gpio0;        /* gpio0                  */
	unsigned int gpio1        : BFW_NX10_xpic_vic_softint1_set_gpio1;        /* gpio1                  */
	unsigned int gpio2        : BFW_NX10_xpic_vic_softint1_set_gpio2;        /* gpio2                  */
	unsigned int gpio3        : BFW_NX10_xpic_vic_softint1_set_gpio3;        /* gpio3                  */
	unsigned int gpio4        : BFW_NX10_xpic_vic_softint1_set_gpio4;        /* gpio4                  */
	unsigned int gpio5        : BFW_NX10_xpic_vic_softint1_set_gpio5;        /* gpio5                  */
	unsigned int gpio6        : BFW_NX10_xpic_vic_softint1_set_gpio6;        /* gpio6                  */
	unsigned int reserved24   : BFW_NX10_xpic_vic_softint1_set_reserved24;   /* reserved               */
	unsigned int reserved25   : BFW_NX10_xpic_vic_softint1_set_reserved25;   /* reserved               */
	unsigned int reserved26   : BFW_NX10_xpic_vic_softint1_set_reserved26;   /* reserved               */
	unsigned int reserved27   : BFW_NX10_xpic_vic_softint1_set_reserved27;   /* reserved               */
	unsigned int reserved28   : BFW_NX10_xpic_vic_softint1_set_reserved28;   /* reserved               */
	unsigned int reserved29   : BFW_NX10_xpic_vic_softint1_set_reserved29;   /* reserved               */
	unsigned int reserved30   : BFW_NX10_xpic_vic_softint1_set_reserved30;   /* reserved               */
	unsigned int misalign     : BFW_NX10_xpic_vic_softint1_set_misalign;     /* xPIC data misalignment */
} NX10_XPIC_VIC_SOFTINT1_SET_BIT_T;

typedef union {
	unsigned int                     val;
	NX10_XPIC_VIC_SOFTINT1_SET_BIT_T bf;
} NX10_XPIC_VIC_SOFTINT1_SET_T;

/* --------------------------------------------------------------------- */
/* Register xpic_vic_softint0_reset */
/* => XPIC VIC Software0 interrupt reset register */
/*    read status */
/*    write (1) reset */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX10_xpic_vic_softint0_reset      0x00000014U
#define Adr_NX10_xpic_vic_xpic_vic_softint0_reset 0x10140814U
#define Adr_NX10_xpic_vic_softint0_reset          0x10140814U
#define DFLT_VAL_NX10_xpic_vic_softint0_reset     0x00000000U

#define MSK_NX10_xpic_vic_softint0_reset_sw0             0x00000001U
#define SRT_NX10_xpic_vic_softint0_reset_sw0             0
#define DFLT_VAL_NX10_xpic_vic_softint0_reset_sw0        0x00000000U
#define MSK_NX10_xpic_vic_softint0_reset_timer0          0x00000002U
#define SRT_NX10_xpic_vic_softint0_reset_timer0          1
#define DFLT_VAL_NX10_xpic_vic_softint0_reset_timer0     0x00000000U
#define MSK_NX10_xpic_vic_softint0_reset_timer1          0x00000004U
#define SRT_NX10_xpic_vic_softint0_reset_timer1          2
#define DFLT_VAL_NX10_xpic_vic_softint0_reset_timer1     0x00000000U
#define MSK_NX10_xpic_vic_softint0_reset_gpio_timer      0x00000008U
#define SRT_NX10_xpic_vic_softint0_reset_gpio_timer      3
#define DFLT_VAL_NX10_xpic_vic_softint0_reset_gpio_timer 0x00000000U
#define MSK_NX10_xpic_vic_softint0_reset_timer2          0x00000010U
#define SRT_NX10_xpic_vic_softint0_reset_timer2          4
#define DFLT_VAL_NX10_xpic_vic_softint0_reset_timer2     0x00000000U
#define MSK_NX10_xpic_vic_softint0_reset_systime_s       0x00000020U
#define SRT_NX10_xpic_vic_softint0_reset_systime_s       5
#define DFLT_VAL_NX10_xpic_vic_softint0_reset_systime_s  0x00000000U
#define MSK_NX10_xpic_vic_softint0_reset_gpio7           0x00000040U
#define SRT_NX10_xpic_vic_softint0_reset_gpio7           6
#define DFLT_VAL_NX10_xpic_vic_softint0_reset_gpio7      0x00000000U
#define MSK_NX10_xpic_vic_softint0_reset_watchdog        0x00000080U
#define SRT_NX10_xpic_vic_softint0_reset_watchdog        7
#define DFLT_VAL_NX10_xpic_vic_softint0_reset_watchdog   0x00000000U
#define MSK_NX10_xpic_vic_softint0_reset_uart0           0x00000100U
#define SRT_NX10_xpic_vic_softint0_reset_uart0           8
#define DFLT_VAL_NX10_xpic_vic_softint0_reset_uart0      0x00000000U
#define MSK_NX10_xpic_vic_softint0_reset_uart1           0x00000200U
#define SRT_NX10_xpic_vic_softint0_reset_uart1           9
#define DFLT_VAL_NX10_xpic_vic_softint0_reset_uart1      0x00000000U
#define MSK_NX10_xpic_vic_softint0_reset_reserved10      0x00000400U
#define SRT_NX10_xpic_vic_softint0_reset_reserved10      10
#define DFLT_VAL_NX10_xpic_vic_softint0_reset_reserved10 0x00000000U
#define MSK_NX10_xpic_vic_softint0_reset_usb             0x00000800U
#define SRT_NX10_xpic_vic_softint0_reset_usb             11
#define DFLT_VAL_NX10_xpic_vic_softint0_reset_usb        0x00000000U
#define MSK_NX10_xpic_vic_softint0_reset_spi             0x00001000U
#define SRT_NX10_xpic_vic_softint0_reset_spi             12
#define DFLT_VAL_NX10_xpic_vic_softint0_reset_spi        0x00000000U
#define MSK_NX10_xpic_vic_softint0_reset_i2c             0x00002000U
#define SRT_NX10_xpic_vic_softint0_reset_i2c             13
#define DFLT_VAL_NX10_xpic_vic_softint0_reset_i2c        0x00000000U
#define MSK_NX10_xpic_vic_softint0_reset_reserved14      0x00004000U
#define SRT_NX10_xpic_vic_softint0_reset_reserved14      14
#define DFLT_VAL_NX10_xpic_vic_softint0_reset_reserved14 0x00000000U
#define MSK_NX10_xpic_vic_softint0_reset_hif             0x00008000U
#define SRT_NX10_xpic_vic_softint0_reset_hif             15
#define DFLT_VAL_NX10_xpic_vic_softint0_reset_hif        0x00000000U
#define MSK_NX10_xpic_vic_softint0_reset_gpio            0x00010000U
#define SRT_NX10_xpic_vic_softint0_reset_gpio            16
#define DFLT_VAL_NX10_xpic_vic_softint0_reset_gpio       0x00000000U
#define MSK_NX10_xpic_vic_softint0_reset_com0            0x00020000U
#define SRT_NX10_xpic_vic_softint0_reset_com0            17
#define DFLT_VAL_NX10_xpic_vic_softint0_reset_com0       0x00000000U
#define MSK_NX10_xpic_vic_softint0_reset_reserved18      0x00040000U
#define SRT_NX10_xpic_vic_softint0_reset_reserved18      18
#define DFLT_VAL_NX10_xpic_vic_softint0_reset_reserved18 0x00000000U
#define MSK_NX10_xpic_vic_softint0_reset_reserved19      0x00080000U
#define SRT_NX10_xpic_vic_softint0_reset_reserved19      19
#define DFLT_VAL_NX10_xpic_vic_softint0_reset_reserved19 0x00000000U
#define MSK_NX10_xpic_vic_softint0_reset_reserved20      0x00100000U
#define SRT_NX10_xpic_vic_softint0_reset_reserved20      20
#define DFLT_VAL_NX10_xpic_vic_softint0_reset_reserved20 0x00000000U
#define MSK_NX10_xpic_vic_softint0_reset_msync0          0x00200000U
#define SRT_NX10_xpic_vic_softint0_reset_msync0          21
#define DFLT_VAL_NX10_xpic_vic_softint0_reset_msync0     0x00000000U
#define MSK_NX10_xpic_vic_softint0_reset_reserved22      0x00400000U
#define SRT_NX10_xpic_vic_softint0_reset_reserved22      22
#define DFLT_VAL_NX10_xpic_vic_softint0_reset_reserved22 0x00000000U
#define MSK_NX10_xpic_vic_softint0_reset_reserved23      0x00800000U
#define SRT_NX10_xpic_vic_softint0_reset_reserved23      23
#define DFLT_VAL_NX10_xpic_vic_softint0_reset_reserved23 0x00000000U
#define MSK_NX10_xpic_vic_softint0_reset_msync3          0x01000000U
#define SRT_NX10_xpic_vic_softint0_reset_msync3          24
#define DFLT_VAL_NX10_xpic_vic_softint0_reset_msync3     0x00000000U
#define MSK_NX10_xpic_vic_softint0_reset_int_phy         0x02000000U
#define SRT_NX10_xpic_vic_softint0_reset_int_phy         25
#define DFLT_VAL_NX10_xpic_vic_softint0_reset_int_phy    0x00000000U
#define MSK_NX10_xpic_vic_softint0_reset_sysstate        0x04000000U
#define SRT_NX10_xpic_vic_softint0_reset_sysstate        26
#define DFLT_VAL_NX10_xpic_vic_softint0_reset_sysstate   0x00000000U
#define MSK_NX10_xpic_vic_softint0_reset_dmac            0x08000000U
#define SRT_NX10_xpic_vic_softint0_reset_dmac            27
#define DFLT_VAL_NX10_xpic_vic_softint0_reset_dmac       0x00000000U
#define MSK_NX10_xpic_vic_softint0_reset_reserved28      0x10000000U
#define SRT_NX10_xpic_vic_softint0_reset_reserved28      28
#define DFLT_VAL_NX10_xpic_vic_softint0_reset_reserved28 0x00000000U
#define MSK_NX10_xpic_vic_softint0_reset_pwm             0x20000000U
#define SRT_NX10_xpic_vic_softint0_reset_pwm             29
#define DFLT_VAL_NX10_xpic_vic_softint0_reset_pwm        0x00000000U
#define MSK_NX10_xpic_vic_softint0_reset_encoder         0x40000000U
#define SRT_NX10_xpic_vic_softint0_reset_encoder         30
#define DFLT_VAL_NX10_xpic_vic_softint0_reset_encoder    0x00000000U
#define MSK_NX10_xpic_vic_softint0_reset_adc             0x80000000U
#define SRT_NX10_xpic_vic_softint0_reset_adc             31
#define DFLT_VAL_NX10_xpic_vic_softint0_reset_adc        0x00000000U

enum {
	BFW_NX10_xpic_vic_softint0_reset_sw0        = 1, /* [0] */
	BFW_NX10_xpic_vic_softint0_reset_timer0     = 1, /* [1] */
	BFW_NX10_xpic_vic_softint0_reset_timer1     = 1, /* [2] */
	BFW_NX10_xpic_vic_softint0_reset_gpio_timer = 1, /* [3] */
	BFW_NX10_xpic_vic_softint0_reset_timer2     = 1, /* [4] */
	BFW_NX10_xpic_vic_softint0_reset_systime_s  = 1, /* [5] */
	BFW_NX10_xpic_vic_softint0_reset_gpio7      = 1, /* [6] */
	BFW_NX10_xpic_vic_softint0_reset_watchdog   = 1, /* [7] */
	BFW_NX10_xpic_vic_softint0_reset_uart0      = 1, /* [8] */
	BFW_NX10_xpic_vic_softint0_reset_uart1      = 1, /* [9] */
	BFW_NX10_xpic_vic_softint0_reset_reserved10 = 1, /* [10] */
	BFW_NX10_xpic_vic_softint0_reset_usb        = 1, /* [11] */
	BFW_NX10_xpic_vic_softint0_reset_spi        = 1, /* [12] */
	BFW_NX10_xpic_vic_softint0_reset_i2c        = 1, /* [13] */
	BFW_NX10_xpic_vic_softint0_reset_reserved14 = 1, /* [14] */
	BFW_NX10_xpic_vic_softint0_reset_hif        = 1, /* [15] */
	BFW_NX10_xpic_vic_softint0_reset_gpio       = 1, /* [16] */
	BFW_NX10_xpic_vic_softint0_reset_com0       = 1, /* [17] */
	BFW_NX10_xpic_vic_softint0_reset_reserved18 = 1, /* [18] */
	BFW_NX10_xpic_vic_softint0_reset_reserved19 = 1, /* [19] */
	BFW_NX10_xpic_vic_softint0_reset_reserved20 = 1, /* [20] */
	BFW_NX10_xpic_vic_softint0_reset_msync0     = 1, /* [21] */
	BFW_NX10_xpic_vic_softint0_reset_reserved22 = 1, /* [22] */
	BFW_NX10_xpic_vic_softint0_reset_reserved23 = 1, /* [23] */
	BFW_NX10_xpic_vic_softint0_reset_msync3     = 1, /* [24] */
	BFW_NX10_xpic_vic_softint0_reset_int_phy    = 1, /* [25] */
	BFW_NX10_xpic_vic_softint0_reset_sysstate   = 1, /* [26] */
	BFW_NX10_xpic_vic_softint0_reset_dmac       = 1, /* [27] */
	BFW_NX10_xpic_vic_softint0_reset_reserved28 = 1, /* [28] */
	BFW_NX10_xpic_vic_softint0_reset_pwm        = 1, /* [29] */
	BFW_NX10_xpic_vic_softint0_reset_encoder    = 1, /* [30] */
	BFW_NX10_xpic_vic_softint0_reset_adc        = 1  /* [31] */
};

typedef struct NX10_XPIC_VIC_SOFTINT0_RESET_BIT_Ttag {
	unsigned int sw0        : BFW_NX10_xpic_vic_softint0_reset_sw0;        /* Reserved for Software Interrupt                                       */
	unsigned int timer0     : BFW_NX10_xpic_vic_softint0_reset_timer0;     /* xPIC Timer0 from XPIC_TIMER Module                                    */
	                                                                       /* Real time operating system timer, Windows CE required                 */
	unsigned int timer1     : BFW_NX10_xpic_vic_softint0_reset_timer1;     /* xPIC Timer1 from XPIC_TIMER Module                                    */
	unsigned int gpio_timer : BFW_NX10_xpic_vic_softint0_reset_gpio_timer; /* GPIO Timer0 or Timer1                                                 */
	                                                                       /* (sep. gpio_irq registers for ARM(intlogic) and xPIC(intlogic_motion)) */
	unsigned int timer2     : BFW_NX10_xpic_vic_softint0_reset_timer2;     /* xPIC Timer2 from XPIC_TIMER Module                                    */
	unsigned int systime_s  : BFW_NX10_xpic_vic_softint0_reset_systime_s;  /* Systime 1day IRQ from XPIC_TIMER module                               */
	unsigned int gpio7      : BFW_NX10_xpic_vic_softint0_reset_gpio7;      /* external interrupt 7, Windows CE required (NMI)                       */
	unsigned int watchdog   : BFW_NX10_xpic_vic_softint0_reset_watchdog;   /* Watchdog IRQ from XPIC_WDG module                                     */
	unsigned int uart0      : BFW_NX10_xpic_vic_softint0_reset_uart0;      /* UART 0 -> Diagnostic channel, Windows CE required                     */
	unsigned int uart1      : BFW_NX10_xpic_vic_softint0_reset_uart1;      /* UART 1                                                                */
	unsigned int reserved10 : BFW_NX10_xpic_vic_softint0_reset_reserved10; /* reserved for netX compatibility (uart2)                               */
	unsigned int usb        : BFW_NX10_xpic_vic_softint0_reset_usb;        /* USB interrupt                                                         */
	unsigned int spi        : BFW_NX10_xpic_vic_softint0_reset_spi;        /* combimned SPI0, SPI1 interrupt                                        */
	unsigned int i2c        : BFW_NX10_xpic_vic_softint0_reset_i2c;        /* I2C                                                                   */
	unsigned int reserved14 : BFW_NX10_xpic_vic_softint0_reset_reserved14; /* reserved for netX compatibility (lcd)                                 */
	unsigned int hif        : BFW_NX10_xpic_vic_softint0_reset_hif;        /* HIF/DPM interrupt                                                     */
	unsigned int gpio       : BFW_NX10_xpic_vic_softint0_reset_gpio;       /* other external Interrupts from GPIO 0-6 / IOLINK                      */
	unsigned int com0       : BFW_NX10_xpic_vic_softint0_reset_com0;       /* Communication channel 0 (= |xpec0_irq[11:0])                          */
	unsigned int reserved18 : BFW_NX10_xpic_vic_softint0_reset_reserved18; /* reserved for netX compatibility (com1)                                */
	unsigned int reserved19 : BFW_NX10_xpic_vic_softint0_reset_reserved19; /* reserved for netX compatibility (com2)                                */
	unsigned int reserved20 : BFW_NX10_xpic_vic_softint0_reset_reserved20; /* reserved  (com3)                                                      */
	unsigned int msync0     : BFW_NX10_xpic_vic_softint0_reset_msync0;     /* Motion synchronization channel 0 (= |xpec0_irq[15:12])                */
	unsigned int reserved22 : BFW_NX10_xpic_vic_softint0_reset_reserved22; /* reserved for netX compatibility (msync1)                              */
	unsigned int reserved23 : BFW_NX10_xpic_vic_softint0_reset_reserved23; /* reserved for netX compatibility (msync2)                              */
	unsigned int msync3     : BFW_NX10_xpic_vic_softint0_reset_msync3;     /* reserved for SW IRQ from ARM to xPIC                                  */
	unsigned int int_phy    : BFW_NX10_xpic_vic_softint0_reset_int_phy;    /* Interrupt from internal Phy                                           */
	unsigned int sysstate   : BFW_NX10_xpic_vic_softint0_reset_sysstate;   /* License error or extmem_timeout                                       */
	unsigned int dmac       : BFW_NX10_xpic_vic_softint0_reset_dmac;       /* DMA controller                                                        */
	unsigned int reserved28 : BFW_NX10_xpic_vic_softint0_reset_reserved28; /* reserved for netX compatibility (trigger_lt)                          */
	unsigned int pwm        : BFW_NX10_xpic_vic_softint0_reset_pwm;        /* Any PWM IRQ                                                           */
	unsigned int encoder    : BFW_NX10_xpic_vic_softint0_reset_encoder;    /* Any encoder IRQ                                                       */
	unsigned int adc        : BFW_NX10_xpic_vic_softint0_reset_adc;        /* ADC0 or ADC1                                                          */
} NX10_XPIC_VIC_SOFTINT0_RESET_BIT_T;

typedef union {
	unsigned int                       val;
	NX10_XPIC_VIC_SOFTINT0_RESET_BIT_T bf;
} NX10_XPIC_VIC_SOFTINT0_RESET_T;

/* --------------------------------------------------------------------- */
/* Register xpic_vic_softint1_reset */
/* => XPIC VIC Software1 interrupt reset register */
/*    read status */
/*    write (1) reset */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX10_xpic_vic_softint1_reset      0x00000018U
#define Adr_NX10_xpic_vic_xpic_vic_softint1_reset 0x10140818U
#define Adr_NX10_xpic_vic_softint1_reset          0x10140818U
#define DFLT_VAL_NX10_xpic_vic_softint1_reset     0x00000000U

#define MSK_NX10_xpic_vic_softint1_reset_adc0              0x00000001U
#define SRT_NX10_xpic_vic_softint1_reset_adc0              0
#define DFLT_VAL_NX10_xpic_vic_softint1_reset_adc0         0x00000000U
#define MSK_NX10_xpic_vic_softint1_reset_adc1              0x00000002U
#define SRT_NX10_xpic_vic_softint1_reset_adc1              1
#define DFLT_VAL_NX10_xpic_vic_softint1_reset_adc1         0x00000000U
#define MSK_NX10_xpic_vic_softint1_reset_enc0              0x00000004U
#define SRT_NX10_xpic_vic_softint1_reset_enc0              2
#define DFLT_VAL_NX10_xpic_vic_softint1_reset_enc0         0x00000000U
#define MSK_NX10_xpic_vic_softint1_reset_enc1              0x00000008U
#define SRT_NX10_xpic_vic_softint1_reset_enc1              3
#define DFLT_VAL_NX10_xpic_vic_softint1_reset_enc1         0x00000000U
#define MSK_NX10_xpic_vic_softint1_reset_cap0              0x00000010U
#define SRT_NX10_xpic_vic_softint1_reset_cap0              4
#define DFLT_VAL_NX10_xpic_vic_softint1_reset_cap0         0x00000000U
#define MSK_NX10_xpic_vic_softint1_reset_cap1              0x00000020U
#define SRT_NX10_xpic_vic_softint1_reset_cap1              5
#define DFLT_VAL_NX10_xpic_vic_softint1_reset_cap1         0x00000000U
#define MSK_NX10_xpic_vic_softint1_reset_cap2              0x00000040U
#define SRT_NX10_xpic_vic_softint1_reset_cap2              6
#define DFLT_VAL_NX10_xpic_vic_softint1_reset_cap2         0x00000000U
#define MSK_NX10_xpic_vic_softint1_reset_cap3              0x00000080U
#define SRT_NX10_xpic_vic_softint1_reset_cap3              7
#define DFLT_VAL_NX10_xpic_vic_softint1_reset_cap3         0x00000000U
#define MSK_NX10_xpic_vic_softint1_reset_mp0               0x00000100U
#define SRT_NX10_xpic_vic_softint1_reset_mp0               8
#define DFLT_VAL_NX10_xpic_vic_softint1_reset_mp0          0x00000000U
#define MSK_NX10_xpic_vic_softint1_reset_mp1               0x00000200U
#define SRT_NX10_xpic_vic_softint1_reset_mp1               9
#define DFLT_VAL_NX10_xpic_vic_softint1_reset_mp1          0x00000000U
#define MSK_NX10_xpic_vic_softint1_reset_mpwm0             0x00000400U
#define SRT_NX10_xpic_vic_softint1_reset_mpwm0             10
#define DFLT_VAL_NX10_xpic_vic_softint1_reset_mpwm0        0x00000000U
#define MSK_NX10_xpic_vic_softint1_reset_mpwm1             0x00000800U
#define SRT_NX10_xpic_vic_softint1_reset_mpwm1             11
#define DFLT_VAL_NX10_xpic_vic_softint1_reset_mpwm1        0x00000000U
#define MSK_NX10_xpic_vic_softint1_reset_mpwm_failure      0x00001000U
#define SRT_NX10_xpic_vic_softint1_reset_mpwm_failure      12
#define DFLT_VAL_NX10_xpic_vic_softint1_reset_mpwm_failure 0x00000000U
#define MSK_NX10_xpic_vic_softint1_reset_spi0              0x00002000U
#define SRT_NX10_xpic_vic_softint1_reset_spi0              13
#define DFLT_VAL_NX10_xpic_vic_softint1_reset_spi0         0x00000000U
#define MSK_NX10_xpic_vic_softint1_reset_spi1              0x00004000U
#define SRT_NX10_xpic_vic_softint1_reset_spi1              14
#define DFLT_VAL_NX10_xpic_vic_softint1_reset_spi1         0x00000000U
#define MSK_NX10_xpic_vic_softint1_reset_gpio_timer0       0x00008000U
#define SRT_NX10_xpic_vic_softint1_reset_gpio_timer0       15
#define DFLT_VAL_NX10_xpic_vic_softint1_reset_gpio_timer0  0x00000000U
#define MSK_NX10_xpic_vic_softint1_reset_gpio_timer1       0x00010000U
#define SRT_NX10_xpic_vic_softint1_reset_gpio_timer1       16
#define DFLT_VAL_NX10_xpic_vic_softint1_reset_gpio_timer1  0x00000000U
#define MSK_NX10_xpic_vic_softint1_reset_gpio0             0x00020000U
#define SRT_NX10_xpic_vic_softint1_reset_gpio0             17
#define DFLT_VAL_NX10_xpic_vic_softint1_reset_gpio0        0x00000000U
#define MSK_NX10_xpic_vic_softint1_reset_gpio1             0x00040000U
#define SRT_NX10_xpic_vic_softint1_reset_gpio1             18
#define DFLT_VAL_NX10_xpic_vic_softint1_reset_gpio1        0x00000000U
#define MSK_NX10_xpic_vic_softint1_reset_gpio2             0x00080000U
#define SRT_NX10_xpic_vic_softint1_reset_gpio2             19
#define DFLT_VAL_NX10_xpic_vic_softint1_reset_gpio2        0x00000000U
#define MSK_NX10_xpic_vic_softint1_reset_gpio3             0x00100000U
#define SRT_NX10_xpic_vic_softint1_reset_gpio3             20
#define DFLT_VAL_NX10_xpic_vic_softint1_reset_gpio3        0x00000000U
#define MSK_NX10_xpic_vic_softint1_reset_gpio4             0x00200000U
#define SRT_NX10_xpic_vic_softint1_reset_gpio4             21
#define DFLT_VAL_NX10_xpic_vic_softint1_reset_gpio4        0x00000000U
#define MSK_NX10_xpic_vic_softint1_reset_gpio5             0x00400000U
#define SRT_NX10_xpic_vic_softint1_reset_gpio5             22
#define DFLT_VAL_NX10_xpic_vic_softint1_reset_gpio5        0x00000000U
#define MSK_NX10_xpic_vic_softint1_reset_gpio6             0x00800000U
#define SRT_NX10_xpic_vic_softint1_reset_gpio6             23
#define DFLT_VAL_NX10_xpic_vic_softint1_reset_gpio6        0x00000000U
#define MSK_NX10_xpic_vic_softint1_reset_reserved24        0x01000000U
#define SRT_NX10_xpic_vic_softint1_reset_reserved24        24
#define DFLT_VAL_NX10_xpic_vic_softint1_reset_reserved24   0x00000000U
#define MSK_NX10_xpic_vic_softint1_reset_reserved25        0x02000000U
#define SRT_NX10_xpic_vic_softint1_reset_reserved25        25
#define DFLT_VAL_NX10_xpic_vic_softint1_reset_reserved25   0x00000000U
#define MSK_NX10_xpic_vic_softint1_reset_reserved26        0x04000000U
#define SRT_NX10_xpic_vic_softint1_reset_reserved26        26
#define DFLT_VAL_NX10_xpic_vic_softint1_reset_reserved26   0x00000000U
#define MSK_NX10_xpic_vic_softint1_reset_reserved27        0x08000000U
#define SRT_NX10_xpic_vic_softint1_reset_reserved27        27
#define DFLT_VAL_NX10_xpic_vic_softint1_reset_reserved27   0x00000000U
#define MSK_NX10_xpic_vic_softint1_reset_reserved28        0x10000000U
#define SRT_NX10_xpic_vic_softint1_reset_reserved28        28
#define DFLT_VAL_NX10_xpic_vic_softint1_reset_reserved28   0x00000000U
#define MSK_NX10_xpic_vic_softint1_reset_reserved29        0x20000000U
#define SRT_NX10_xpic_vic_softint1_reset_reserved29        29
#define DFLT_VAL_NX10_xpic_vic_softint1_reset_reserved29   0x00000000U
#define MSK_NX10_xpic_vic_softint1_reset_reserved30        0x40000000U
#define SRT_NX10_xpic_vic_softint1_reset_reserved30        30
#define DFLT_VAL_NX10_xpic_vic_softint1_reset_reserved30   0x00000000U
#define MSK_NX10_xpic_vic_softint1_reset_misalign          0x80000000U
#define SRT_NX10_xpic_vic_softint1_reset_misalign          31
#define DFLT_VAL_NX10_xpic_vic_softint1_reset_misalign     0x00000000U

enum {
	BFW_NX10_xpic_vic_softint1_reset_adc0         = 1, /* [0] */
	BFW_NX10_xpic_vic_softint1_reset_adc1         = 1, /* [1] */
	BFW_NX10_xpic_vic_softint1_reset_enc0         = 1, /* [2] */
	BFW_NX10_xpic_vic_softint1_reset_enc1         = 1, /* [3] */
	BFW_NX10_xpic_vic_softint1_reset_cap0         = 1, /* [4] */
	BFW_NX10_xpic_vic_softint1_reset_cap1         = 1, /* [5] */
	BFW_NX10_xpic_vic_softint1_reset_cap2         = 1, /* [6] */
	BFW_NX10_xpic_vic_softint1_reset_cap3         = 1, /* [7] */
	BFW_NX10_xpic_vic_softint1_reset_mp0          = 1, /* [8] */
	BFW_NX10_xpic_vic_softint1_reset_mp1          = 1, /* [9] */
	BFW_NX10_xpic_vic_softint1_reset_mpwm0        = 1, /* [10] */
	BFW_NX10_xpic_vic_softint1_reset_mpwm1        = 1, /* [11] */
	BFW_NX10_xpic_vic_softint1_reset_mpwm_failure = 1, /* [12] */
	BFW_NX10_xpic_vic_softint1_reset_spi0         = 1, /* [13] */
	BFW_NX10_xpic_vic_softint1_reset_spi1         = 1, /* [14] */
	BFW_NX10_xpic_vic_softint1_reset_gpio_timer0  = 1, /* [15] */
	BFW_NX10_xpic_vic_softint1_reset_gpio_timer1  = 1, /* [16] */
	BFW_NX10_xpic_vic_softint1_reset_gpio0        = 1, /* [17] */
	BFW_NX10_xpic_vic_softint1_reset_gpio1        = 1, /* [18] */
	BFW_NX10_xpic_vic_softint1_reset_gpio2        = 1, /* [19] */
	BFW_NX10_xpic_vic_softint1_reset_gpio3        = 1, /* [20] */
	BFW_NX10_xpic_vic_softint1_reset_gpio4        = 1, /* [21] */
	BFW_NX10_xpic_vic_softint1_reset_gpio5        = 1, /* [22] */
	BFW_NX10_xpic_vic_softint1_reset_gpio6        = 1, /* [23] */
	BFW_NX10_xpic_vic_softint1_reset_reserved24   = 1, /* [24] */
	BFW_NX10_xpic_vic_softint1_reset_reserved25   = 1, /* [25] */
	BFW_NX10_xpic_vic_softint1_reset_reserved26   = 1, /* [26] */
	BFW_NX10_xpic_vic_softint1_reset_reserved27   = 1, /* [27] */
	BFW_NX10_xpic_vic_softint1_reset_reserved28   = 1, /* [28] */
	BFW_NX10_xpic_vic_softint1_reset_reserved29   = 1, /* [29] */
	BFW_NX10_xpic_vic_softint1_reset_reserved30   = 1, /* [30] */
	BFW_NX10_xpic_vic_softint1_reset_misalign     = 1  /* [31] */
};

typedef struct NX10_XPIC_VIC_SOFTINT1_RESET_BIT_Ttag {
	unsigned int adc0         : BFW_NX10_xpic_vic_softint1_reset_adc0;         /* ADC0                   */
	unsigned int adc1         : BFW_NX10_xpic_vic_softint1_reset_adc1;         /* ADC1                   */
	unsigned int enc0         : BFW_NX10_xpic_vic_softint1_reset_enc0;         /* Encoder0 (ovfl, edge)  */
	unsigned int enc1         : BFW_NX10_xpic_vic_softint1_reset_enc1;         /* Encoder1 (ovfl, edge)  */
	unsigned int cap0         : BFW_NX10_xpic_vic_softint1_reset_cap0;         /* Encoder Capture Unit 0 */
	unsigned int cap1         : BFW_NX10_xpic_vic_softint1_reset_cap1;         /* Encoder Capture Unit 1 */
	unsigned int cap2         : BFW_NX10_xpic_vic_softint1_reset_cap2;         /* Encoder Capture Unit 2 */
	unsigned int cap3         : BFW_NX10_xpic_vic_softint1_reset_cap3;         /* Encoder Capture Unit 3 */
	unsigned int mp0          : BFW_NX10_xpic_vic_softint1_reset_mp0;          /* Encoder mp0            */
	unsigned int mp1          : BFW_NX10_xpic_vic_softint1_reset_mp1;          /* Encoder mp1            */
	unsigned int mpwm0        : BFW_NX10_xpic_vic_softint1_reset_mpwm0;        /* mpwm0                  */
	unsigned int mpwm1        : BFW_NX10_xpic_vic_softint1_reset_mpwm1;        /* mpwm1                  */
	unsigned int mpwm_failure : BFW_NX10_xpic_vic_softint1_reset_mpwm_failure; /* mpwm_failure           */
	unsigned int spi0         : BFW_NX10_xpic_vic_softint1_reset_spi0;         /* spi0                   */
	unsigned int spi1         : BFW_NX10_xpic_vic_softint1_reset_spi1;         /* spi1                   */
	unsigned int gpio_timer0  : BFW_NX10_xpic_vic_softint1_reset_gpio_timer0;  /* gpio_timer0            */
	unsigned int gpio_timer1  : BFW_NX10_xpic_vic_softint1_reset_gpio_timer1;  /* gpio_timer1            */
	unsigned int gpio0        : BFW_NX10_xpic_vic_softint1_reset_gpio0;        /* gpio0                  */
	unsigned int gpio1        : BFW_NX10_xpic_vic_softint1_reset_gpio1;        /* gpio1                  */
	unsigned int gpio2        : BFW_NX10_xpic_vic_softint1_reset_gpio2;        /* gpio2                  */
	unsigned int gpio3        : BFW_NX10_xpic_vic_softint1_reset_gpio3;        /* gpio3                  */
	unsigned int gpio4        : BFW_NX10_xpic_vic_softint1_reset_gpio4;        /* gpio4                  */
	unsigned int gpio5        : BFW_NX10_xpic_vic_softint1_reset_gpio5;        /* gpio5                  */
	unsigned int gpio6        : BFW_NX10_xpic_vic_softint1_reset_gpio6;        /* gpio6                  */
	unsigned int reserved24   : BFW_NX10_xpic_vic_softint1_reset_reserved24;   /* reserved               */
	unsigned int reserved25   : BFW_NX10_xpic_vic_softint1_reset_reserved25;   /* reserved               */
	unsigned int reserved26   : BFW_NX10_xpic_vic_softint1_reset_reserved26;   /* reserved               */
	unsigned int reserved27   : BFW_NX10_xpic_vic_softint1_reset_reserved27;   /* reserved               */
	unsigned int reserved28   : BFW_NX10_xpic_vic_softint1_reset_reserved28;   /* reserved               */
	unsigned int reserved29   : BFW_NX10_xpic_vic_softint1_reset_reserved29;   /* reserved               */
	unsigned int reserved30   : BFW_NX10_xpic_vic_softint1_reset_reserved30;   /* reserved               */
	unsigned int misalign     : BFW_NX10_xpic_vic_softint1_reset_misalign;     /* xPIC data misalignment */
} NX10_XPIC_VIC_SOFTINT1_RESET_BIT_T;

typedef union {
	unsigned int                       val;
	NX10_XPIC_VIC_SOFTINT1_RESET_BIT_T bf;
} NX10_XPIC_VIC_SOFTINT1_RESET_T;

/* --------------------------------------------------------------------- */
/* Register xpic_vic_fiq_addr */
/* => XPIC VIC FIQ Vector address 0 register */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX10_xpic_vic_fiq_addr      0x0000001CU
#define Adr_NX10_xpic_vic_xpic_vic_fiq_addr 0x1014081CU
#define Adr_NX10_xpic_vic_fiq_addr          0x1014081CU
#define DFLT_VAL_NX10_xpic_vic_fiq_addr     0x00000000U

#define MSK_NX10_xpic_vic_fiq_addr_val      0xffffffffU
#define SRT_NX10_xpic_vic_fiq_addr_val      0
#define DFLT_VAL_NX10_xpic_vic_fiq_addr_val 0x00000000U

enum {
	BFW_NX10_xpic_vic_fiq_addr_val = 32  /* [31:0] */
};

typedef struct NX10_XPIC_VIC_FIQ_ADDR_BIT_Ttag {
	unsigned int val : BFW_NX10_xpic_vic_fiq_addr_val; /* FIQ handler address */
} NX10_XPIC_VIC_FIQ_ADDR_BIT_T;

typedef union {
	unsigned int                 val;
	NX10_XPIC_VIC_FIQ_ADDR_BIT_T bf;
} NX10_XPIC_VIC_FIQ_ADDR_T;

/* --------------------------------------------------------------------- */
/* Register xpic_vic_irq_addr */
/* => XPIC VIC normal IRQ address register */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX10_xpic_vic_irq_addr      0x00000020U
#define Adr_NX10_xpic_vic_xpic_vic_irq_addr 0x10140820U
#define Adr_NX10_xpic_vic_irq_addr          0x10140820U
#define DFLT_VAL_NX10_xpic_vic_irq_addr     0x00000000U

#define MSK_NX10_xpic_vic_irq_addr_val      0xffffffffU
#define SRT_NX10_xpic_vic_irq_addr_val      0
#define DFLT_VAL_NX10_xpic_vic_irq_addr_val 0x00000000U

enum {
	BFW_NX10_xpic_vic_irq_addr_val = 32  /* [31:0] */
};

typedef struct NX10_XPIC_VIC_IRQ_ADDR_BIT_Ttag {
	unsigned int val : BFW_NX10_xpic_vic_irq_addr_val; /* IRQ handler address */
} NX10_XPIC_VIC_IRQ_ADDR_BIT_T;

typedef union {
	unsigned int                 val;
	NX10_XPIC_VIC_IRQ_ADDR_BIT_T bf;
} NX10_XPIC_VIC_IRQ_ADDR_T;

/* --------------------------------------------------------------------- */
/* Register xpic_vic_vector_addr */
/* => XPIC VIC IRQ Vector address */
/* => Mode: R */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX10_xpic_vic_vector_addr      0x00000024U
#define Adr_NX10_xpic_vic_xpic_vic_vector_addr 0x10140824U
#define Adr_NX10_xpic_vic_vector_addr          0x10140824U

#define MSK_NX10_xpic_vic_vector_addr_val 0xffffffffU
#define SRT_NX10_xpic_vic_vector_addr_val 0

enum {
	BFW_NX10_xpic_vic_vector_addr_val = 32  /* [31:0] */
};

typedef struct NX10_XPIC_VIC_VECTOR_ADDR_BIT_Ttag {
	unsigned int val : BFW_NX10_xpic_vic_vector_addr_val; /* IRQ vector address                       */
	                                                      /* read access get actuel highest prior IRQ */
} NX10_XPIC_VIC_VECTOR_ADDR_BIT_T;

typedef union {
	unsigned int                    val;
	NX10_XPIC_VIC_VECTOR_ADDR_BIT_T bf;
} NX10_XPIC_VIC_VECTOR_ADDR_T;

/* --------------------------------------------------------------------- */
/* Register xpic_vic_table_base_addr */
/* => XPIC VIC IRQ Vector address */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX10_xpic_vic_table_base_addr      0x00000028U
#define Adr_NX10_xpic_vic_xpic_vic_table_base_addr 0x10140828U
#define Adr_NX10_xpic_vic_table_base_addr          0x10140828U
#define DFLT_VAL_NX10_xpic_vic_table_base_addr     0x00000000U

#define MSK_NX10_xpic_vic_table_base_addr_val      0xffffffffU
#define SRT_NX10_xpic_vic_table_base_addr_val      0
#define DFLT_VAL_NX10_xpic_vic_table_base_addr_val 0x00000000U

enum {
	BFW_NX10_xpic_vic_table_base_addr_val = 32  /* [31:0] */
};

typedef struct NX10_XPIC_VIC_TABLE_BASE_ADDR_BIT_Ttag {
	unsigned int val : BFW_NX10_xpic_vic_table_base_addr_val; /* IRQ Table base address                  */
	                                                          /* the Base Pointer Addr for IRQ Jmp Table */
} NX10_XPIC_VIC_TABLE_BASE_ADDR_BIT_T;

typedef union {
	unsigned int                        val;
	NX10_XPIC_VIC_TABLE_BASE_ADDR_BIT_T bf;
} NX10_XPIC_VIC_TABLE_BASE_ADDR_T;

/* --------------------------------------------------------------------- */
/* Register xpic_vic_fiq_vect_config */
/* =>  */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX10_xpic_vic_fiq_vect_config      0x0000002CU
#define Adr_NX10_xpic_vic_xpic_vic_fiq_vect_config 0x1014082CU
#define Adr_NX10_xpic_vic_fiq_vect_config          0x1014082CU
#define DFLT_VAL_NX10_xpic_vic_fiq_vect_config     0x00000000U

#define MSK_NX10_xpic_vic_fiq_vect_config_int_source      0x0000003fU
#define SRT_NX10_xpic_vic_fiq_vect_config_int_source      0
#define DFLT_VAL_NX10_xpic_vic_fiq_vect_config_int_source 0x00000000U
#define MSK_NX10_xpic_vic_fiq_vect_config_enable          0x00000040U
#define SRT_NX10_xpic_vic_fiq_vect_config_enable          6
#define DFLT_VAL_NX10_xpic_vic_fiq_vect_config_enable     0x00000000U

enum {
	BFW_NX10_xpic_vic_fiq_vect_config_int_source = 6,  /* [5:0] */
	BFW_NX10_xpic_vic_fiq_vect_config_enable     = 1,  /* [6] */
	BFW_NX10_xpic_vic_fiq_vect_config_reserved1  = 25  /* [31:7] */
};

typedef struct NX10_XPIC_VIC_FIQ_VECT_CONFIG_BIT_Ttag {
	unsigned int int_source : BFW_NX10_xpic_vic_fiq_vect_config_int_source; /* INT_SOURCE 0-64         */
	unsigned int enable     : BFW_NX10_xpic_vic_fiq_vect_config_enable;     /* vector interrupt enable */
	unsigned int reserved1  : BFW_NX10_xpic_vic_fiq_vect_config_reserved1;  /* reserved                */
} NX10_XPIC_VIC_FIQ_VECT_CONFIG_BIT_T;

typedef union {
	unsigned int                        val;
	NX10_XPIC_VIC_FIQ_VECT_CONFIG_BIT_T bf;
} NX10_XPIC_VIC_FIQ_VECT_CONFIG_T;

/* --------------------------------------------------------------------- */
/* Register xpic_vic_vect_config0 */
/* => highest priority */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX10_xpic_vic_vect_config0      0x00000030U
#define Adr_NX10_xpic_vic_xpic_vic_vect_config0 0x10140830U
#define Adr_NX10_xpic_vic_vect_config0          0x10140830U
#define DFLT_VAL_NX10_xpic_vic_vect_config0     0x00000000U

#define MSK_NX10_xpic_vic_vect_config0_int_source      0x0000003fU
#define SRT_NX10_xpic_vic_vect_config0_int_source      0
#define DFLT_VAL_NX10_xpic_vic_vect_config0_int_source 0x00000000U
#define MSK_NX10_xpic_vic_vect_config0_enable          0x00000040U
#define SRT_NX10_xpic_vic_vect_config0_enable          6
#define DFLT_VAL_NX10_xpic_vic_vect_config0_enable     0x00000000U

enum {
	BFW_NX10_xpic_vic_vect_config0_int_source = 6,  /* [5:0] */
	BFW_NX10_xpic_vic_vect_config0_enable     = 1,  /* [6] */
	BFW_NX10_xpic_vic_vect_config0_reserved1  = 25  /* [31:7] */
};

typedef struct NX10_XPIC_VIC_VECT_CONFIG0_BIT_Ttag {
	unsigned int int_source : BFW_NX10_xpic_vic_vect_config0_int_source; /* INT_SOURCE 0-64         */
	unsigned int enable     : BFW_NX10_xpic_vic_vect_config0_enable;     /* vector interrupt enable */
	unsigned int reserved1  : BFW_NX10_xpic_vic_vect_config0_reserved1;  /* reserved                */
} NX10_XPIC_VIC_VECT_CONFIG0_BIT_T;

typedef union {
	unsigned int                     val;
	NX10_XPIC_VIC_VECT_CONFIG0_BIT_T bf;
} NX10_XPIC_VIC_VECT_CONFIG0_T;

/* --------------------------------------------------------------------- */
/* Register xpic_vic_vect_config1 */
/* =>  */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX10_xpic_vic_vect_config1      0x00000034U
#define Adr_NX10_xpic_vic_xpic_vic_vect_config1 0x10140834U
#define Adr_NX10_xpic_vic_vect_config1          0x10140834U
#define DFLT_VAL_NX10_xpic_vic_vect_config1     0x00000000U

#define MSK_NX10_xpic_vic_vect_config1_int_source      0x0000003fU
#define SRT_NX10_xpic_vic_vect_config1_int_source      0
#define DFLT_VAL_NX10_xpic_vic_vect_config1_int_source 0x00000000U
#define MSK_NX10_xpic_vic_vect_config1_enable          0x00000040U
#define SRT_NX10_xpic_vic_vect_config1_enable          6
#define DFLT_VAL_NX10_xpic_vic_vect_config1_enable     0x00000000U

enum {
	BFW_NX10_xpic_vic_vect_config1_int_source = 6,  /* [5:0] */
	BFW_NX10_xpic_vic_vect_config1_enable     = 1,  /* [6] */
	BFW_NX10_xpic_vic_vect_config1_reserved1  = 25  /* [31:7] */
};

typedef struct NX10_XPIC_VIC_VECT_CONFIG1_BIT_Ttag {
	unsigned int int_source : BFW_NX10_xpic_vic_vect_config1_int_source; /* INT_SOURCE 0-64         */
	unsigned int enable     : BFW_NX10_xpic_vic_vect_config1_enable;     /* vector interrupt enable */
	unsigned int reserved1  : BFW_NX10_xpic_vic_vect_config1_reserved1;  /* reserved                */
} NX10_XPIC_VIC_VECT_CONFIG1_BIT_T;

typedef union {
	unsigned int                     val;
	NX10_XPIC_VIC_VECT_CONFIG1_BIT_T bf;
} NX10_XPIC_VIC_VECT_CONFIG1_T;

/* --------------------------------------------------------------------- */
/* Register xpic_vic_vect_config2 */
/* =>  */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX10_xpic_vic_vect_config2      0x00000038U
#define Adr_NX10_xpic_vic_xpic_vic_vect_config2 0x10140838U
#define Adr_NX10_xpic_vic_vect_config2          0x10140838U
#define DFLT_VAL_NX10_xpic_vic_vect_config2     0x00000000U

#define MSK_NX10_xpic_vic_vect_config2_int_source      0x0000003fU
#define SRT_NX10_xpic_vic_vect_config2_int_source      0
#define DFLT_VAL_NX10_xpic_vic_vect_config2_int_source 0x00000000U
#define MSK_NX10_xpic_vic_vect_config2_enable          0x00000040U
#define SRT_NX10_xpic_vic_vect_config2_enable          6
#define DFLT_VAL_NX10_xpic_vic_vect_config2_enable     0x00000000U

enum {
	BFW_NX10_xpic_vic_vect_config2_int_source = 6,  /* [5:0] */
	BFW_NX10_xpic_vic_vect_config2_enable     = 1,  /* [6] */
	BFW_NX10_xpic_vic_vect_config2_reserved1  = 25  /* [31:7] */
};

typedef struct NX10_XPIC_VIC_VECT_CONFIG2_BIT_Ttag {
	unsigned int int_source : BFW_NX10_xpic_vic_vect_config2_int_source; /* INT_SOURCE 0-64         */
	unsigned int enable     : BFW_NX10_xpic_vic_vect_config2_enable;     /* vector interrupt enable */
	unsigned int reserved1  : BFW_NX10_xpic_vic_vect_config2_reserved1;  /* reserved                */
} NX10_XPIC_VIC_VECT_CONFIG2_BIT_T;

typedef union {
	unsigned int                     val;
	NX10_XPIC_VIC_VECT_CONFIG2_BIT_T bf;
} NX10_XPIC_VIC_VECT_CONFIG2_T;

/* --------------------------------------------------------------------- */
/* Register xpic_vic_vect_config3 */
/* =>  */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX10_xpic_vic_vect_config3      0x0000003CU
#define Adr_NX10_xpic_vic_xpic_vic_vect_config3 0x1014083CU
#define Adr_NX10_xpic_vic_vect_config3          0x1014083CU
#define DFLT_VAL_NX10_xpic_vic_vect_config3     0x00000000U

#define MSK_NX10_xpic_vic_vect_config3_int_source      0x0000003fU
#define SRT_NX10_xpic_vic_vect_config3_int_source      0
#define DFLT_VAL_NX10_xpic_vic_vect_config3_int_source 0x00000000U
#define MSK_NX10_xpic_vic_vect_config3_enable          0x00000040U
#define SRT_NX10_xpic_vic_vect_config3_enable          6
#define DFLT_VAL_NX10_xpic_vic_vect_config3_enable     0x00000000U

enum {
	BFW_NX10_xpic_vic_vect_config3_int_source = 6,  /* [5:0] */
	BFW_NX10_xpic_vic_vect_config3_enable     = 1,  /* [6] */
	BFW_NX10_xpic_vic_vect_config3_reserved1  = 25  /* [31:7] */
};

typedef struct NX10_XPIC_VIC_VECT_CONFIG3_BIT_Ttag {
	unsigned int int_source : BFW_NX10_xpic_vic_vect_config3_int_source; /* INT_SOURCE 0-64         */
	unsigned int enable     : BFW_NX10_xpic_vic_vect_config3_enable;     /* vector interrupt enable */
	unsigned int reserved1  : BFW_NX10_xpic_vic_vect_config3_reserved1;  /* reserved                */
} NX10_XPIC_VIC_VECT_CONFIG3_BIT_T;

typedef union {
	unsigned int                     val;
	NX10_XPIC_VIC_VECT_CONFIG3_BIT_T bf;
} NX10_XPIC_VIC_VECT_CONFIG3_T;

/* --------------------------------------------------------------------- */
/* Register xpic_vic_vect_config4 */
/* =>  */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX10_xpic_vic_vect_config4      0x00000040U
#define Adr_NX10_xpic_vic_xpic_vic_vect_config4 0x10140840U
#define Adr_NX10_xpic_vic_vect_config4          0x10140840U
#define DFLT_VAL_NX10_xpic_vic_vect_config4     0x00000000U

#define MSK_NX10_xpic_vic_vect_config4_int_source      0x0000003fU
#define SRT_NX10_xpic_vic_vect_config4_int_source      0
#define DFLT_VAL_NX10_xpic_vic_vect_config4_int_source 0x00000000U
#define MSK_NX10_xpic_vic_vect_config4_enable          0x00000040U
#define SRT_NX10_xpic_vic_vect_config4_enable          6
#define DFLT_VAL_NX10_xpic_vic_vect_config4_enable     0x00000000U

enum {
	BFW_NX10_xpic_vic_vect_config4_int_source = 6,  /* [5:0] */
	BFW_NX10_xpic_vic_vect_config4_enable     = 1,  /* [6] */
	BFW_NX10_xpic_vic_vect_config4_reserved1  = 25  /* [31:7] */
};

typedef struct NX10_XPIC_VIC_VECT_CONFIG4_BIT_Ttag {
	unsigned int int_source : BFW_NX10_xpic_vic_vect_config4_int_source; /* INT_SOURCE 0-64         */
	unsigned int enable     : BFW_NX10_xpic_vic_vect_config4_enable;     /* vector interrupt enable */
	unsigned int reserved1  : BFW_NX10_xpic_vic_vect_config4_reserved1;  /* reserved                */
} NX10_XPIC_VIC_VECT_CONFIG4_BIT_T;

typedef union {
	unsigned int                     val;
	NX10_XPIC_VIC_VECT_CONFIG4_BIT_T bf;
} NX10_XPIC_VIC_VECT_CONFIG4_T;

/* --------------------------------------------------------------------- */
/* Register xpic_vic_vect_config5 */
/* =>  */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX10_xpic_vic_vect_config5      0x00000044U
#define Adr_NX10_xpic_vic_xpic_vic_vect_config5 0x10140844U
#define Adr_NX10_xpic_vic_vect_config5          0x10140844U
#define DFLT_VAL_NX10_xpic_vic_vect_config5     0x00000000U

#define MSK_NX10_xpic_vic_vect_config5_int_source      0x0000003fU
#define SRT_NX10_xpic_vic_vect_config5_int_source      0
#define DFLT_VAL_NX10_xpic_vic_vect_config5_int_source 0x00000000U
#define MSK_NX10_xpic_vic_vect_config5_enable          0x00000040U
#define SRT_NX10_xpic_vic_vect_config5_enable          6
#define DFLT_VAL_NX10_xpic_vic_vect_config5_enable     0x00000000U

enum {
	BFW_NX10_xpic_vic_vect_config5_int_source = 6,  /* [5:0] */
	BFW_NX10_xpic_vic_vect_config5_enable     = 1,  /* [6] */
	BFW_NX10_xpic_vic_vect_config5_reserved1  = 25  /* [31:7] */
};

typedef struct NX10_XPIC_VIC_VECT_CONFIG5_BIT_Ttag {
	unsigned int int_source : BFW_NX10_xpic_vic_vect_config5_int_source; /* INT_SOURCE 0-64         */
	unsigned int enable     : BFW_NX10_xpic_vic_vect_config5_enable;     /* vector interrupt enable */
	unsigned int reserved1  : BFW_NX10_xpic_vic_vect_config5_reserved1;  /* reserved                */
} NX10_XPIC_VIC_VECT_CONFIG5_BIT_T;

typedef union {
	unsigned int                     val;
	NX10_XPIC_VIC_VECT_CONFIG5_BIT_T bf;
} NX10_XPIC_VIC_VECT_CONFIG5_T;

/* --------------------------------------------------------------------- */
/* Register xpic_vic_vect_config6 */
/* =>  */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX10_xpic_vic_vect_config6      0x00000048U
#define Adr_NX10_xpic_vic_xpic_vic_vect_config6 0x10140848U
#define Adr_NX10_xpic_vic_vect_config6          0x10140848U
#define DFLT_VAL_NX10_xpic_vic_vect_config6     0x00000000U

#define MSK_NX10_xpic_vic_vect_config6_int_source      0x0000003fU
#define SRT_NX10_xpic_vic_vect_config6_int_source      0
#define DFLT_VAL_NX10_xpic_vic_vect_config6_int_source 0x00000000U
#define MSK_NX10_xpic_vic_vect_config6_enable          0x00000040U
#define SRT_NX10_xpic_vic_vect_config6_enable          6
#define DFLT_VAL_NX10_xpic_vic_vect_config6_enable     0x00000000U

enum {
	BFW_NX10_xpic_vic_vect_config6_int_source = 6,  /* [5:0] */
	BFW_NX10_xpic_vic_vect_config6_enable     = 1,  /* [6] */
	BFW_NX10_xpic_vic_vect_config6_reserved1  = 25  /* [31:7] */
};

typedef struct NX10_XPIC_VIC_VECT_CONFIG6_BIT_Ttag {
	unsigned int int_source : BFW_NX10_xpic_vic_vect_config6_int_source; /* INT_SOURCE 0-64         */
	unsigned int enable     : BFW_NX10_xpic_vic_vect_config6_enable;     /* vector interrupt enable */
	unsigned int reserved1  : BFW_NX10_xpic_vic_vect_config6_reserved1;  /* reserved                */
} NX10_XPIC_VIC_VECT_CONFIG6_BIT_T;

typedef union {
	unsigned int                     val;
	NX10_XPIC_VIC_VECT_CONFIG6_BIT_T bf;
} NX10_XPIC_VIC_VECT_CONFIG6_T;

/* --------------------------------------------------------------------- */
/* Register xpic_vic_vect_config7 */
/* =>  */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX10_xpic_vic_vect_config7      0x0000004CU
#define Adr_NX10_xpic_vic_xpic_vic_vect_config7 0x1014084CU
#define Adr_NX10_xpic_vic_vect_config7          0x1014084CU
#define DFLT_VAL_NX10_xpic_vic_vect_config7     0x00000000U

#define MSK_NX10_xpic_vic_vect_config7_int_source      0x0000003fU
#define SRT_NX10_xpic_vic_vect_config7_int_source      0
#define DFLT_VAL_NX10_xpic_vic_vect_config7_int_source 0x00000000U
#define MSK_NX10_xpic_vic_vect_config7_enable          0x00000040U
#define SRT_NX10_xpic_vic_vect_config7_enable          6
#define DFLT_VAL_NX10_xpic_vic_vect_config7_enable     0x00000000U

enum {
	BFW_NX10_xpic_vic_vect_config7_int_source = 6,  /* [5:0] */
	BFW_NX10_xpic_vic_vect_config7_enable     = 1,  /* [6] */
	BFW_NX10_xpic_vic_vect_config7_reserved1  = 25  /* [31:7] */
};

typedef struct NX10_XPIC_VIC_VECT_CONFIG7_BIT_Ttag {
	unsigned int int_source : BFW_NX10_xpic_vic_vect_config7_int_source; /* INT_SOURCE 0-64         */
	unsigned int enable     : BFW_NX10_xpic_vic_vect_config7_enable;     /* vector interrupt enable */
	unsigned int reserved1  : BFW_NX10_xpic_vic_vect_config7_reserved1;  /* reserved                */
} NX10_XPIC_VIC_VECT_CONFIG7_BIT_T;

typedef union {
	unsigned int                     val;
	NX10_XPIC_VIC_VECT_CONFIG7_BIT_T bf;
} NX10_XPIC_VIC_VECT_CONFIG7_T;

/* --------------------------------------------------------------------- */
/* Register xpic_vic_vect_config8 */
/* =>  */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX10_xpic_vic_vect_config8      0x00000050U
#define Adr_NX10_xpic_vic_xpic_vic_vect_config8 0x10140850U
#define Adr_NX10_xpic_vic_vect_config8          0x10140850U
#define DFLT_VAL_NX10_xpic_vic_vect_config8     0x00000000U

#define MSK_NX10_xpic_vic_vect_config8_int_source      0x0000003fU
#define SRT_NX10_xpic_vic_vect_config8_int_source      0
#define DFLT_VAL_NX10_xpic_vic_vect_config8_int_source 0x00000000U
#define MSK_NX10_xpic_vic_vect_config8_enable          0x00000040U
#define SRT_NX10_xpic_vic_vect_config8_enable          6
#define DFLT_VAL_NX10_xpic_vic_vect_config8_enable     0x00000000U

enum {
	BFW_NX10_xpic_vic_vect_config8_int_source = 6,  /* [5:0] */
	BFW_NX10_xpic_vic_vect_config8_enable     = 1,  /* [6] */
	BFW_NX10_xpic_vic_vect_config8_reserved1  = 25  /* [31:7] */
};

typedef struct NX10_XPIC_VIC_VECT_CONFIG8_BIT_Ttag {
	unsigned int int_source : BFW_NX10_xpic_vic_vect_config8_int_source; /* INT_SOURCE 0-64         */
	unsigned int enable     : BFW_NX10_xpic_vic_vect_config8_enable;     /* vector interrupt enable */
	unsigned int reserved1  : BFW_NX10_xpic_vic_vect_config8_reserved1;  /* reserved                */
} NX10_XPIC_VIC_VECT_CONFIG8_BIT_T;

typedef union {
	unsigned int                     val;
	NX10_XPIC_VIC_VECT_CONFIG8_BIT_T bf;
} NX10_XPIC_VIC_VECT_CONFIG8_T;

/* --------------------------------------------------------------------- */
/* Register xpic_vic_vect_config9 */
/* =>  */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX10_xpic_vic_vect_config9      0x00000054U
#define Adr_NX10_xpic_vic_xpic_vic_vect_config9 0x10140854U
#define Adr_NX10_xpic_vic_vect_config9          0x10140854U
#define DFLT_VAL_NX10_xpic_vic_vect_config9     0x00000000U

#define MSK_NX10_xpic_vic_vect_config9_int_source      0x0000003fU
#define SRT_NX10_xpic_vic_vect_config9_int_source      0
#define DFLT_VAL_NX10_xpic_vic_vect_config9_int_source 0x00000000U
#define MSK_NX10_xpic_vic_vect_config9_enable          0x00000040U
#define SRT_NX10_xpic_vic_vect_config9_enable          6
#define DFLT_VAL_NX10_xpic_vic_vect_config9_enable     0x00000000U

enum {
	BFW_NX10_xpic_vic_vect_config9_int_source = 6,  /* [5:0] */
	BFW_NX10_xpic_vic_vect_config9_enable     = 1,  /* [6] */
	BFW_NX10_xpic_vic_vect_config9_reserved1  = 25  /* [31:7] */
};

typedef struct NX10_XPIC_VIC_VECT_CONFIG9_BIT_Ttag {
	unsigned int int_source : BFW_NX10_xpic_vic_vect_config9_int_source; /* INT_SOURCE 0-64         */
	unsigned int enable     : BFW_NX10_xpic_vic_vect_config9_enable;     /* vector interrupt enable */
	unsigned int reserved1  : BFW_NX10_xpic_vic_vect_config9_reserved1;  /* reserved                */
} NX10_XPIC_VIC_VECT_CONFIG9_BIT_T;

typedef union {
	unsigned int                     val;
	NX10_XPIC_VIC_VECT_CONFIG9_BIT_T bf;
} NX10_XPIC_VIC_VECT_CONFIG9_T;

/* --------------------------------------------------------------------- */
/* Register xpic_vic_vect_config10 */
/* =>  */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX10_xpic_vic_vect_config10      0x00000058U
#define Adr_NX10_xpic_vic_xpic_vic_vect_config10 0x10140858U
#define Adr_NX10_xpic_vic_vect_config10          0x10140858U
#define DFLT_VAL_NX10_xpic_vic_vect_config10     0x00000000U

#define MSK_NX10_xpic_vic_vect_config10_int_source      0x0000003fU
#define SRT_NX10_xpic_vic_vect_config10_int_source      0
#define DFLT_VAL_NX10_xpic_vic_vect_config10_int_source 0x00000000U
#define MSK_NX10_xpic_vic_vect_config10_enable          0x00000040U
#define SRT_NX10_xpic_vic_vect_config10_enable          6
#define DFLT_VAL_NX10_xpic_vic_vect_config10_enable     0x00000000U

enum {
	BFW_NX10_xpic_vic_vect_config10_int_source = 6,  /* [5:0] */
	BFW_NX10_xpic_vic_vect_config10_enable     = 1,  /* [6] */
	BFW_NX10_xpic_vic_vect_config10_reserved1  = 25  /* [31:7] */
};

typedef struct NX10_XPIC_VIC_VECT_CONFIG10_BIT_Ttag {
	unsigned int int_source : BFW_NX10_xpic_vic_vect_config10_int_source; /* INT_SOURCE 0-64         */
	unsigned int enable     : BFW_NX10_xpic_vic_vect_config10_enable;     /* vector interrupt enable */
	unsigned int reserved1  : BFW_NX10_xpic_vic_vect_config10_reserved1;  /* reserved                */
} NX10_XPIC_VIC_VECT_CONFIG10_BIT_T;

typedef union {
	unsigned int                      val;
	NX10_XPIC_VIC_VECT_CONFIG10_BIT_T bf;
} NX10_XPIC_VIC_VECT_CONFIG10_T;

/* --------------------------------------------------------------------- */
/* Register xpic_vic_vect_config11 */
/* =>  */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX10_xpic_vic_vect_config11      0x0000005CU
#define Adr_NX10_xpic_vic_xpic_vic_vect_config11 0x1014085CU
#define Adr_NX10_xpic_vic_vect_config11          0x1014085CU
#define DFLT_VAL_NX10_xpic_vic_vect_config11     0x00000000U

#define MSK_NX10_xpic_vic_vect_config11_int_source      0x0000003fU
#define SRT_NX10_xpic_vic_vect_config11_int_source      0
#define DFLT_VAL_NX10_xpic_vic_vect_config11_int_source 0x00000000U
#define MSK_NX10_xpic_vic_vect_config11_enable          0x00000040U
#define SRT_NX10_xpic_vic_vect_config11_enable          6
#define DFLT_VAL_NX10_xpic_vic_vect_config11_enable     0x00000000U

enum {
	BFW_NX10_xpic_vic_vect_config11_int_source = 6,  /* [5:0] */
	BFW_NX10_xpic_vic_vect_config11_enable     = 1,  /* [6] */
	BFW_NX10_xpic_vic_vect_config11_reserved1  = 25  /* [31:7] */
};

typedef struct NX10_XPIC_VIC_VECT_CONFIG11_BIT_Ttag {
	unsigned int int_source : BFW_NX10_xpic_vic_vect_config11_int_source; /* INT_SOURCE 0-64         */
	unsigned int enable     : BFW_NX10_xpic_vic_vect_config11_enable;     /* vector interrupt enable */
	unsigned int reserved1  : BFW_NX10_xpic_vic_vect_config11_reserved1;  /* reserved                */
} NX10_XPIC_VIC_VECT_CONFIG11_BIT_T;

typedef union {
	unsigned int                      val;
	NX10_XPIC_VIC_VECT_CONFIG11_BIT_T bf;
} NX10_XPIC_VIC_VECT_CONFIG11_T;

/* --------------------------------------------------------------------- */
/* Register xpic_vic_vect_config12 */
/* =>  */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX10_xpic_vic_vect_config12      0x00000060U
#define Adr_NX10_xpic_vic_xpic_vic_vect_config12 0x10140860U
#define Adr_NX10_xpic_vic_vect_config12          0x10140860U
#define DFLT_VAL_NX10_xpic_vic_vect_config12     0x00000000U

#define MSK_NX10_xpic_vic_vect_config12_int_source      0x0000003fU
#define SRT_NX10_xpic_vic_vect_config12_int_source      0
#define DFLT_VAL_NX10_xpic_vic_vect_config12_int_source 0x00000000U
#define MSK_NX10_xpic_vic_vect_config12_enable          0x00000040U
#define SRT_NX10_xpic_vic_vect_config12_enable          6
#define DFLT_VAL_NX10_xpic_vic_vect_config12_enable     0x00000000U

enum {
	BFW_NX10_xpic_vic_vect_config12_int_source = 6,  /* [5:0] */
	BFW_NX10_xpic_vic_vect_config12_enable     = 1,  /* [6] */
	BFW_NX10_xpic_vic_vect_config12_reserved1  = 25  /* [31:7] */
};

typedef struct NX10_XPIC_VIC_VECT_CONFIG12_BIT_Ttag {
	unsigned int int_source : BFW_NX10_xpic_vic_vect_config12_int_source; /* INT_SOURCE 0-64         */
	unsigned int enable     : BFW_NX10_xpic_vic_vect_config12_enable;     /* vector interrupt enable */
	unsigned int reserved1  : BFW_NX10_xpic_vic_vect_config12_reserved1;  /* reserved                */
} NX10_XPIC_VIC_VECT_CONFIG12_BIT_T;

typedef union {
	unsigned int                      val;
	NX10_XPIC_VIC_VECT_CONFIG12_BIT_T bf;
} NX10_XPIC_VIC_VECT_CONFIG12_T;

/* --------------------------------------------------------------------- */
/* Register xpic_vic_vect_config13 */
/* =>  */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX10_xpic_vic_vect_config13      0x00000064U
#define Adr_NX10_xpic_vic_xpic_vic_vect_config13 0x10140864U
#define Adr_NX10_xpic_vic_vect_config13          0x10140864U
#define DFLT_VAL_NX10_xpic_vic_vect_config13     0x00000000U

#define MSK_NX10_xpic_vic_vect_config13_int_source      0x0000003fU
#define SRT_NX10_xpic_vic_vect_config13_int_source      0
#define DFLT_VAL_NX10_xpic_vic_vect_config13_int_source 0x00000000U
#define MSK_NX10_xpic_vic_vect_config13_enable          0x00000040U
#define SRT_NX10_xpic_vic_vect_config13_enable          6
#define DFLT_VAL_NX10_xpic_vic_vect_config13_enable     0x00000000U

enum {
	BFW_NX10_xpic_vic_vect_config13_int_source = 6,  /* [5:0] */
	BFW_NX10_xpic_vic_vect_config13_enable     = 1,  /* [6] */
	BFW_NX10_xpic_vic_vect_config13_reserved1  = 25  /* [31:7] */
};

typedef struct NX10_XPIC_VIC_VECT_CONFIG13_BIT_Ttag {
	unsigned int int_source : BFW_NX10_xpic_vic_vect_config13_int_source; /* INT_SOURCE 0-64         */
	unsigned int enable     : BFW_NX10_xpic_vic_vect_config13_enable;     /* vector interrupt enable */
	unsigned int reserved1  : BFW_NX10_xpic_vic_vect_config13_reserved1;  /* reserved                */
} NX10_XPIC_VIC_VECT_CONFIG13_BIT_T;

typedef union {
	unsigned int                      val;
	NX10_XPIC_VIC_VECT_CONFIG13_BIT_T bf;
} NX10_XPIC_VIC_VECT_CONFIG13_T;

/* --------------------------------------------------------------------- */
/* Register xpic_vic_vect_config14 */
/* =>  */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX10_xpic_vic_vect_config14      0x00000068U
#define Adr_NX10_xpic_vic_xpic_vic_vect_config14 0x10140868U
#define Adr_NX10_xpic_vic_vect_config14          0x10140868U
#define DFLT_VAL_NX10_xpic_vic_vect_config14     0x00000000U

#define MSK_NX10_xpic_vic_vect_config14_int_source      0x0000003fU
#define SRT_NX10_xpic_vic_vect_config14_int_source      0
#define DFLT_VAL_NX10_xpic_vic_vect_config14_int_source 0x00000000U
#define MSK_NX10_xpic_vic_vect_config14_enable          0x00000040U
#define SRT_NX10_xpic_vic_vect_config14_enable          6
#define DFLT_VAL_NX10_xpic_vic_vect_config14_enable     0x00000000U

enum {
	BFW_NX10_xpic_vic_vect_config14_int_source = 6,  /* [5:0] */
	BFW_NX10_xpic_vic_vect_config14_enable     = 1,  /* [6] */
	BFW_NX10_xpic_vic_vect_config14_reserved1  = 25  /* [31:7] */
};

typedef struct NX10_XPIC_VIC_VECT_CONFIG14_BIT_Ttag {
	unsigned int int_source : BFW_NX10_xpic_vic_vect_config14_int_source; /* INT_SOURCE 0-64         */
	unsigned int enable     : BFW_NX10_xpic_vic_vect_config14_enable;     /* vector interrupt enable */
	unsigned int reserved1  : BFW_NX10_xpic_vic_vect_config14_reserved1;  /* reserved                */
} NX10_XPIC_VIC_VECT_CONFIG14_BIT_T;

typedef union {
	unsigned int                      val;
	NX10_XPIC_VIC_VECT_CONFIG14_BIT_T bf;
} NX10_XPIC_VIC_VECT_CONFIG14_T;

/* --------------------------------------------------------------------- */
/* Register xpic_vic_vect_config15 */
/* => XPIC default interrupt vector, all interrupt sources (wired-OR) */
/*    select with default interrupt vector register */
/*    lowest priority */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX10_xpic_vic_vect_config15      0x0000006CU
#define Adr_NX10_xpic_vic_xpic_vic_vect_config15 0x1014086CU
#define Adr_NX10_xpic_vic_vect_config15          0x1014086CU
#define DFLT_VAL_NX10_xpic_vic_vect_config15     0x00000000U

#define MSK_NX10_xpic_vic_vect_config15_enable      0x00000040U
#define SRT_NX10_xpic_vic_vect_config15_enable      6
#define DFLT_VAL_NX10_xpic_vic_vect_config15_enable 0x00000000U

enum {
	BFW_NX10_xpic_vic_vect_config15_reserved1 = 6,  /* [5:0] */
	BFW_NX10_xpic_vic_vect_config15_enable    = 1,  /* [6] */
	BFW_NX10_xpic_vic_vect_config15_reserved2 = 25  /* [31:7] */
};

typedef struct NX10_XPIC_VIC_VECT_CONFIG15_BIT_Ttag {
	unsigned int reserved1 : BFW_NX10_xpic_vic_vect_config15_reserved1; /* reserved                */
	unsigned int enable    : BFW_NX10_xpic_vic_vect_config15_enable;    /* vector interrupt enable */
	unsigned int reserved2 : BFW_NX10_xpic_vic_vect_config15_reserved2; /* reserved                */
} NX10_XPIC_VIC_VECT_CONFIG15_BIT_T;

typedef union {
	unsigned int                      val;
	NX10_XPIC_VIC_VECT_CONFIG15_BIT_T bf;
} NX10_XPIC_VIC_VECT_CONFIG15_T;

/* --------------------------------------------------------------------- */
/* Register xpic_vic_default0 */
/* => XPIC default interrupt vector select0 */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX10_xpic_vic_default0      0x00000070U
#define Adr_NX10_xpic_vic_xpic_vic_default0 0x10140870U
#define Adr_NX10_xpic_vic_default0          0x10140870U
#define DFLT_VAL_NX10_xpic_vic_default0     0x00000000U

#define MSK_NX10_xpic_vic_default0_val      0xffffffffU
#define SRT_NX10_xpic_vic_default0_val      0
#define DFLT_VAL_NX10_xpic_vic_default0_val 0x00000000U

enum {
	BFW_NX10_xpic_vic_default0_val = 32  /* [31:0] */
};

typedef struct NX10_XPIC_VIC_DEFAULT0_BIT_Ttag {
	unsigned int val : BFW_NX10_xpic_vic_default0_val; /* select int0 - int31 (wired-OR) 1-selected 0-not selected */
} NX10_XPIC_VIC_DEFAULT0_BIT_T;

typedef union {
	unsigned int                 val;
	NX10_XPIC_VIC_DEFAULT0_BIT_T bf;
} NX10_XPIC_VIC_DEFAULT0_T;

/* --------------------------------------------------------------------- */
/* Register xpic_vic_default1 */
/* => XPIC default interrupt vector select0 */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX10_xpic_vic_default1      0x00000074U
#define Adr_NX10_xpic_vic_xpic_vic_default1 0x10140874U
#define Adr_NX10_xpic_vic_default1          0x10140874U
#define DFLT_VAL_NX10_xpic_vic_default1     0x00000000U

#define MSK_NX10_xpic_vic_default1_val      0xffffffffU
#define SRT_NX10_xpic_vic_default1_val      0
#define DFLT_VAL_NX10_xpic_vic_default1_val 0x00000000U

enum {
	BFW_NX10_xpic_vic_default1_val = 32  /* [31:0] */
};

typedef struct NX10_XPIC_VIC_DEFAULT1_BIT_Ttag {
	unsigned int val : BFW_NX10_xpic_vic_default1_val; /* select int32 - int63 (wired-OR) 1-selected 0-not selected */
} NX10_XPIC_VIC_DEFAULT1_BIT_T;

typedef union {
	unsigned int                 val;
	NX10_XPIC_VIC_DEFAULT1_BIT_T bf;
} NX10_XPIC_VIC_DEFAULT1_T;


/* ===================================================================== */

/* Area of xpic_wdg */

/* ===================================================================== */

#define Addr_NX10_xpic_wdg 0x10140900U

/* --------------------------------------------------------------------- */
/* Register xpic_wdg_trig */
/* => netX xPIC Watchdog Trigger Register. */
/*    The watchdog access code is generated by a pseudo random generator. */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX10_xpic_wdg_trig      0x00000000U
#define Adr_NX10_xpic_wdg_xpic_wdg_trig 0x10140900U
#define Adr_NX10_xpic_wdg_trig          0x10140900U
#define DFLT_VAL_NX10_xpic_wdg_trig     0x00000000U

#define MSK_NX10_xpic_wdg_trig_wdg_access_code            0x000fffffU
#define SRT_NX10_xpic_wdg_trig_wdg_access_code            0
#define DFLT_VAL_NX10_xpic_wdg_trig_wdg_access_code       0x00000000U
#define MSK_NX10_xpic_wdg_trig_irq_req_watchdog           0x01000000U
#define SRT_NX10_xpic_wdg_trig_irq_req_watchdog           24
#define DFLT_VAL_NX10_xpic_wdg_trig_irq_req_watchdog      0x00000000U
#define MSK_NX10_xpic_wdg_trig_wdg_counter_trigger_w      0x10000000U
#define SRT_NX10_xpic_wdg_trig_wdg_counter_trigger_w      28
#define DFLT_VAL_NX10_xpic_wdg_trig_wdg_counter_trigger_w 0x00000000U
#define MSK_NX10_xpic_wdg_trig_write_enable               0x80000000U
#define SRT_NX10_xpic_wdg_trig_write_enable               31
#define DFLT_VAL_NX10_xpic_wdg_trig_write_enable          0x00000000U

enum {
	BFW_NX10_xpic_wdg_trig_wdg_access_code       = 20, /* [19:0] */
	BFW_NX10_xpic_wdg_trig_reserved1             = 4,  /* [23:20] */
	BFW_NX10_xpic_wdg_trig_irq_req_watchdog      = 1,  /* [24] */
	BFW_NX10_xpic_wdg_trig_reserved2             = 3,  /* [27:25] */
	BFW_NX10_xpic_wdg_trig_wdg_counter_trigger_w = 1,  /* [28] */
	BFW_NX10_xpic_wdg_trig_reserved3             = 2,  /* [30:29] */
	BFW_NX10_xpic_wdg_trig_write_enable          = 1   /* [31] */
};

typedef struct NX10_XPIC_WDG_TRIG_BIT_Ttag {
	unsigned int wdg_access_code       : BFW_NX10_xpic_wdg_trig_wdg_access_code;       /* Watchdog access code for triggering. A read access gives the next 16 bit code for trigger. */
	                                                                                   /* A write access with correct access code will trigger the watchdog counter.                 */
	unsigned int reserved1             : BFW_NX10_xpic_wdg_trig_reserved1;             /* reserved                                                                                   */
	unsigned int irq_req_watchdog      : BFW_NX10_xpic_wdg_trig_irq_req_watchdog;      /* xPIC IRQ request of watchdog, writing 1 deletes IRQ to xPIC                                */
	unsigned int reserved2             : BFW_NX10_xpic_wdg_trig_reserved2;             /* reserved                                                                                   */
	unsigned int wdg_counter_trigger_w : BFW_NX10_xpic_wdg_trig_wdg_counter_trigger_w; /* Watchdog trigger bit:                                                                      */
	                                                                                   /* Bit must be set to trigger the watchdog counter.                                           */
	unsigned int reserved3             : BFW_NX10_xpic_wdg_trig_reserved3;             /* reserved                                                                                   */
	unsigned int write_enable          : BFW_NX10_xpic_wdg_trig_write_enable;          /* Write enable bit for timeout register:                                                     */
	                                                                                   /* As long as this bit is not set all write accesses to the timeout register are ignored.     */
} NX10_XPIC_WDG_TRIG_BIT_T;

typedef union {
	unsigned int             val;
	NX10_XPIC_WDG_TRIG_BIT_T bf;
} NX10_XPIC_WDG_TRIG_T;

/* --------------------------------------------------------------------- */
/* Register xpic_wdg_counter */
/* => netX xPIC Watchdog Register */
/* => Mode: R */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX10_xpic_wdg_counter      0x00000004U
#define Adr_NX10_xpic_wdg_xpic_wdg_counter 0x10140904U
#define Adr_NX10_xpic_wdg_counter          0x10140904U

#define MSK_NX10_xpic_wdg_counter_val 0x0001ffffU
#define SRT_NX10_xpic_wdg_counter_val 0

enum {
	BFW_NX10_xpic_wdg_counter_val       = 17, /* [16:0] */
	BFW_NX10_xpic_wdg_counter_reserved1 = 15  /* [31:17] */
};

typedef struct NX10_XPIC_WDG_COUNTER_BIT_Ttag {
	unsigned int val       : BFW_NX10_xpic_wdg_counter_val;       /* Actual watchdog counter value: */
	                                                              /* Bit 16 shows:                  */
	unsigned int reserved1 : BFW_NX10_xpic_wdg_counter_reserved1; /* reserved                       */
} NX10_XPIC_WDG_COUNTER_BIT_T;

typedef union {
	unsigned int                val;
	NX10_XPIC_WDG_COUNTER_BIT_T bf;
} NX10_XPIC_WDG_COUNTER_T;

/* --------------------------------------------------------------------- */
/* Register xpic_wdg_xpic_irq_timeout */
/* => netX xPIC Watchdog xPIC interrupt timout register: */
/*    xpic_irq_timeout or arm_irq_timeout must be nonzero to enable watchdog */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX10_xpic_wdg_xpic_irq_timeout      0x00000008U
#define Adr_NX10_xpic_wdg_xpic_wdg_xpic_irq_timeout 0x10140908U
#define Adr_NX10_xpic_wdg_xpic_irq_timeout          0x10140908U
#define DFLT_VAL_NX10_xpic_wdg_xpic_irq_timeout     0x00000000U

#define MSK_NX10_xpic_wdg_xpic_irq_timeout_val      0x0000ffffU
#define SRT_NX10_xpic_wdg_xpic_irq_timeout_val      0
#define DFLT_VAL_NX10_xpic_wdg_xpic_irq_timeout_val 0x00000000U

enum {
	BFW_NX10_xpic_wdg_xpic_irq_timeout_val       = 16, /* [15:0] */
	BFW_NX10_xpic_wdg_xpic_irq_timeout_reserved1 = 16  /* [31:16] */
};

typedef struct NX10_XPIC_WDG_XPIC_IRQ_TIMEOUT_BIT_Ttag {
	unsigned int val       : BFW_NX10_xpic_wdg_xpic_irq_timeout_val;       /* Watchdog interrupt timeout */
	unsigned int reserved1 : BFW_NX10_xpic_wdg_xpic_irq_timeout_reserved1; /* reserved                   */
} NX10_XPIC_WDG_XPIC_IRQ_TIMEOUT_BIT_T;

typedef union {
	unsigned int                         val;
	NX10_XPIC_WDG_XPIC_IRQ_TIMEOUT_BIT_T bf;
} NX10_XPIC_WDG_XPIC_IRQ_TIMEOUT_T;

/* --------------------------------------------------------------------- */
/* Register xpic_wdg_arm_irq_timeout */
/* => netX xPIC Watchdog ARM interrupt timout register: */
/*    xpic_irq_timeout or arm_irq_timeout must be nonzero to enable watchdog */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX10_xpic_wdg_arm_irq_timeout      0x0000000CU
#define Adr_NX10_xpic_wdg_xpic_wdg_arm_irq_timeout 0x1014090CU
#define Adr_NX10_xpic_wdg_arm_irq_timeout          0x1014090CU
#define DFLT_VAL_NX10_xpic_wdg_arm_irq_timeout     0x00000000U

#define MSK_NX10_xpic_wdg_arm_irq_timeout_val      0x0000ffffU
#define SRT_NX10_xpic_wdg_arm_irq_timeout_val      0
#define DFLT_VAL_NX10_xpic_wdg_arm_irq_timeout_val 0x00000000U

enum {
	BFW_NX10_xpic_wdg_arm_irq_timeout_val       = 16, /* [15:0] */
	BFW_NX10_xpic_wdg_arm_irq_timeout_reserved1 = 16  /* [31:16] */
};

typedef struct NX10_XPIC_WDG_ARM_IRQ_TIMEOUT_BIT_Ttag {
	unsigned int val       : BFW_NX10_xpic_wdg_arm_irq_timeout_val;       /* Watchdog ARM interrupt timeout */
	unsigned int reserved1 : BFW_NX10_xpic_wdg_arm_irq_timeout_reserved1; /* reserved                       */
} NX10_XPIC_WDG_ARM_IRQ_TIMEOUT_BIT_T;

typedef union {
	unsigned int                        val;
	NX10_XPIC_WDG_ARM_IRQ_TIMEOUT_BIT_T bf;
} NX10_XPIC_WDG_ARM_IRQ_TIMEOUT_T;

/* --------------------------------------------------------------------- */
/* Register xpic_wdg_irq_raw */
/* => Raw interrupt register: */
/*    Reset by writing 1 to appropriate bit. */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX10_xpic_wdg_irq_raw      0x00000010U
#define Adr_NX10_xpic_wdg_xpic_wdg_irq_raw 0x10140910U
#define Adr_NX10_xpic_wdg_irq_raw          0x10140910U
#define DFLT_VAL_NX10_xpic_wdg_irq_raw     0x00000000U

#define MSK_NX10_xpic_wdg_irq_raw_wdg_arm_irq      0x00000001U
#define SRT_NX10_xpic_wdg_irq_raw_wdg_arm_irq      0
#define DFLT_VAL_NX10_xpic_wdg_irq_raw_wdg_arm_irq 0x00000000U

enum {
	BFW_NX10_xpic_wdg_irq_raw_wdg_arm_irq = 1,  /* [0] */
	BFW_NX10_xpic_wdg_irq_raw_reserved1   = 31  /* [31:1] */
};

typedef struct NX10_XPIC_WDG_IRQ_RAW_BIT_Ttag {
	unsigned int wdg_arm_irq : BFW_NX10_xpic_wdg_irq_raw_wdg_arm_irq; /* Interrupt from xPIC Watchdog to ARM */
	unsigned int reserved1   : BFW_NX10_xpic_wdg_irq_raw_reserved1;   /* reserved                            */
} NX10_XPIC_WDG_IRQ_RAW_BIT_T;

typedef union {
	unsigned int                val;
	NX10_XPIC_WDG_IRQ_RAW_BIT_T bf;
} NX10_XPIC_WDG_IRQ_RAW_T;

/* --------------------------------------------------------------------- */
/* Register xpic_wdg_irq_masked */
/* => xpic_wdg Masked IRQ register: */
/*    Shows status of masked IRQs (as connected to ARM/xPIC). */
/* => Mode: R */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX10_xpic_wdg_irq_masked      0x00000014U
#define Adr_NX10_xpic_wdg_xpic_wdg_irq_masked 0x10140914U
#define Adr_NX10_xpic_wdg_irq_masked          0x10140914U

#define MSK_NX10_xpic_wdg_irq_masked_wdg_arm_irq 0x00000001U
#define SRT_NX10_xpic_wdg_irq_masked_wdg_arm_irq 0

enum {
	BFW_NX10_xpic_wdg_irq_masked_wdg_arm_irq = 1,  /* [0] */
	BFW_NX10_xpic_wdg_irq_masked_reserved1   = 31  /* [31:1] */
};

typedef struct NX10_XPIC_WDG_IRQ_MASKED_BIT_Ttag {
	unsigned int wdg_arm_irq : BFW_NX10_xpic_wdg_irq_masked_wdg_arm_irq; /* Interrupt from xPIC Watchdog to ARM */
	unsigned int reserved1   : BFW_NX10_xpic_wdg_irq_masked_reserved1;   /* reserved                            */
} NX10_XPIC_WDG_IRQ_MASKED_BIT_T;

typedef union {
	unsigned int                   val;
	NX10_XPIC_WDG_IRQ_MASKED_BIT_T bf;
} NX10_XPIC_WDG_IRQ_MASKED_T;

/* --------------------------------------------------------------------- */
/* Register xpic_wdg_irq_msk_set */
/* => xpic_wdg interrupt mask enable: */
/*    Write access with '1' sets interrupt mask bit (enables interrupt request for corresponding interrupt source). */
/*    Write access with '0' does not influence this bit. */
/*    Read access shows actual interrupt mask. */
/*    Attention: Before activating interrupt mask, delete old pending interrupts by writing the same value to adr_xpic_wdg_irq_raw. */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX10_xpic_wdg_irq_msk_set      0x00000018U
#define Adr_NX10_xpic_wdg_xpic_wdg_irq_msk_set 0x10140918U
#define Adr_NX10_xpic_wdg_irq_msk_set          0x10140918U
#define DFLT_VAL_NX10_xpic_wdg_irq_msk_set     0x00000000U

#define MSK_NX10_xpic_wdg_irq_msk_set_wdg_arm_irq      0x00000001U
#define SRT_NX10_xpic_wdg_irq_msk_set_wdg_arm_irq      0
#define DFLT_VAL_NX10_xpic_wdg_irq_msk_set_wdg_arm_irq 0x00000000U

enum {
	BFW_NX10_xpic_wdg_irq_msk_set_wdg_arm_irq = 1,  /* [0] */
	BFW_NX10_xpic_wdg_irq_msk_set_reserved1   = 31  /* [31:1] */
};

typedef struct NX10_XPIC_WDG_IRQ_MSK_SET_BIT_Ttag {
	unsigned int wdg_arm_irq : BFW_NX10_xpic_wdg_irq_msk_set_wdg_arm_irq; /* Interrupt from xPIC Watchdog to ARM */
	unsigned int reserved1   : BFW_NX10_xpic_wdg_irq_msk_set_reserved1;   /* reserved                            */
} NX10_XPIC_WDG_IRQ_MSK_SET_BIT_T;

typedef union {
	unsigned int                    val;
	NX10_XPIC_WDG_IRQ_MSK_SET_BIT_T bf;
} NX10_XPIC_WDG_IRQ_MSK_SET_T;

/* --------------------------------------------------------------------- */
/* Register xpic_wdg_irq_msk_reset */
/* => xpic_wdg interrupt mask disable: */
/*    Write access with '1' resets interrupt mask bit (disables interrupt request for corresponding interrupt source). */
/*    Write access with '0' does not influence this bit. */
/*    Read access shows actual interrupt mask. */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX10_xpic_wdg_irq_msk_reset      0x0000001CU
#define Adr_NX10_xpic_wdg_xpic_wdg_irq_msk_reset 0x1014091CU
#define Adr_NX10_xpic_wdg_irq_msk_reset          0x1014091CU
#define DFLT_VAL_NX10_xpic_wdg_irq_msk_reset     0x00000000U

#define MSK_NX10_xpic_wdg_irq_msk_reset_wdg_arm_irq      0x00000001U
#define SRT_NX10_xpic_wdg_irq_msk_reset_wdg_arm_irq      0
#define DFLT_VAL_NX10_xpic_wdg_irq_msk_reset_wdg_arm_irq 0x00000000U

enum {
	BFW_NX10_xpic_wdg_irq_msk_reset_wdg_arm_irq = 1,  /* [0] */
	BFW_NX10_xpic_wdg_irq_msk_reset_reserved1   = 31  /* [31:1] */
};

typedef struct NX10_XPIC_WDG_IRQ_MSK_RESET_BIT_Ttag {
	unsigned int wdg_arm_irq : BFW_NX10_xpic_wdg_irq_msk_reset_wdg_arm_irq; /* Interrupt from xPIC Watchdog to ARM */
	unsigned int reserved1   : BFW_NX10_xpic_wdg_irq_msk_reset_reserved1;   /* reserved                            */
} NX10_XPIC_WDG_IRQ_MSK_RESET_BIT_T;

typedef union {
	unsigned int                      val;
	NX10_XPIC_WDG_IRQ_MSK_RESET_BIT_T bf;
} NX10_XPIC_WDG_IRQ_MSK_RESET_T;


/* ===================================================================== */

/* Area of intlogic_sys */

/* ===================================================================== */

#define Addr_NX10_intlogic_sys 0x10180000U

/* ===================================================================== */

/* AREA xc */
/* Area of xc, xc_motion */

/* ===================================================================== */

#define Addr_NX10_xc        0x10180000U
#define NX10_NETX_XC_AREA   0x10180000U
#define Addr_NX10_xc_motion 0x10100000U

/* --------------------------------------------------------------------- */
/* Register xc_base */
/* =>  */
/* => Mode:  */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX10_xc_base       0x00000000U
#define Adr_NX10_xc_xc_base        0x10180000U
#define Adr_NX10_xc_motion_xc_base 0x10100000U


/* ===================================================================== */

/* AREA xpec */
/* Area of xpec0 */

/* ===================================================================== */

#define Addr_NX10_xpec0    0x10180000U
#define NX10_NETX_XP0_BASE 0x10180000U

/* --------------------------------------------------------------------- */
/* Register xpec_r0 */
/* => xPEC work register for indirect addressing */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX10_xpec_r0   0x00000000U
#define Adr_NX10_xpec0_xpec_r0 0x10180000U
#define Adr_NX10_xpec_r0       0x10180000U
#define DFLT_VAL_NX10_xpec_r0  0x00000000U

#define MSK_NX10_xpec_r0_r0      0xffffffffU
#define SRT_NX10_xpec_r0_r0      0
#define DFLT_VAL_NX10_xpec_r0_r0 0x00000000U

enum {
	BFW_NX10_xpec_r0_r0 = 32  /* [31:0] */
};

typedef struct NX10_XPEC_R0_BIT_Ttag {
	unsigned int r0 : BFW_NX10_xpec_r0_r0; /* Work Register 0 */
} NX10_XPEC_R0_BIT_T;

typedef union {
	unsigned int       val;
	NX10_XPEC_R0_BIT_T bf;
} NX10_XPEC_R0_T;

/* --------------------------------------------------------------------- */
/* Register xpec_r1 */
/* => xPEC work register for indirect addressing */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX10_xpec_r1   0x00000004U
#define Adr_NX10_xpec0_xpec_r1 0x10180004U
#define Adr_NX10_xpec_r1       0x10180004U
#define DFLT_VAL_NX10_xpec_r1  0x00000000U

#define MSK_NX10_xpec_r1_r1      0xffffffffU
#define SRT_NX10_xpec_r1_r1      0
#define DFLT_VAL_NX10_xpec_r1_r1 0x00000000U

enum {
	BFW_NX10_xpec_r1_r1 = 32  /* [31:0] */
};

typedef struct NX10_XPEC_R1_BIT_Ttag {
	unsigned int r1 : BFW_NX10_xpec_r1_r1; /* Work Register 1 */
} NX10_XPEC_R1_BIT_T;

typedef union {
	unsigned int       val;
	NX10_XPEC_R1_BIT_T bf;
} NX10_XPEC_R1_T;

/* --------------------------------------------------------------------- */
/* Register xpec_r2 */
/* => xPEC work register for indirect addressing */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX10_xpec_r2   0x00000008U
#define Adr_NX10_xpec0_xpec_r2 0x10180008U
#define Adr_NX10_xpec_r2       0x10180008U
#define DFLT_VAL_NX10_xpec_r2  0x00000000U

#define MSK_NX10_xpec_r2_r2      0xffffffffU
#define SRT_NX10_xpec_r2_r2      0
#define DFLT_VAL_NX10_xpec_r2_r2 0x00000000U

enum {
	BFW_NX10_xpec_r2_r2 = 32  /* [31:0] */
};

typedef struct NX10_XPEC_R2_BIT_Ttag {
	unsigned int r2 : BFW_NX10_xpec_r2_r2; /* Work Register 2 */
} NX10_XPEC_R2_BIT_T;

typedef union {
	unsigned int       val;
	NX10_XPEC_R2_BIT_T bf;
} NX10_XPEC_R2_T;

/* --------------------------------------------------------------------- */
/* Register xpec_r3 */
/* => xPEC work register for indirect addressing */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX10_xpec_r3   0x0000000CU
#define Adr_NX10_xpec0_xpec_r3 0x1018000CU
#define Adr_NX10_xpec_r3       0x1018000CU
#define DFLT_VAL_NX10_xpec_r3  0x00000000U

#define MSK_NX10_xpec_r3_r3      0xffffffffU
#define SRT_NX10_xpec_r3_r3      0
#define DFLT_VAL_NX10_xpec_r3_r3 0x00000000U

enum {
	BFW_NX10_xpec_r3_r3 = 32  /* [31:0] */
};

typedef struct NX10_XPEC_R3_BIT_Ttag {
	unsigned int r3 : BFW_NX10_xpec_r3_r3; /* Work Register 3 */
} NX10_XPEC_R3_BIT_T;

typedef union {
	unsigned int       val;
	NX10_XPEC_R3_BIT_T bf;
} NX10_XPEC_R3_T;

/* --------------------------------------------------------------------- */
/* Register xpec_r4 */
/* => xPEC work register for indirect addressing */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX10_xpec_r4   0x00000010U
#define Adr_NX10_xpec0_xpec_r4 0x10180010U
#define Adr_NX10_xpec_r4       0x10180010U
#define DFLT_VAL_NX10_xpec_r4  0x00000000U

#define MSK_NX10_xpec_r4_r4      0xffffffffU
#define SRT_NX10_xpec_r4_r4      0
#define DFLT_VAL_NX10_xpec_r4_r4 0x00000000U

enum {
	BFW_NX10_xpec_r4_r4 = 32  /* [31:0] */
};

typedef struct NX10_XPEC_R4_BIT_Ttag {
	unsigned int r4 : BFW_NX10_xpec_r4_r4; /* Work Register 4 */
} NX10_XPEC_R4_BIT_T;

typedef union {
	unsigned int       val;
	NX10_XPEC_R4_BIT_T bf;
} NX10_XPEC_R4_T;

/* --------------------------------------------------------------------- */
/* Register xpec_r5 */
/* => xPEC work register for indirect addressing */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX10_xpec_r5   0x00000014U
#define Adr_NX10_xpec0_xpec_r5 0x10180014U
#define Adr_NX10_xpec_r5       0x10180014U
#define DFLT_VAL_NX10_xpec_r5  0x00000000U

#define MSK_NX10_xpec_r5_r5      0xffffffffU
#define SRT_NX10_xpec_r5_r5      0
#define DFLT_VAL_NX10_xpec_r5_r5 0x00000000U

enum {
	BFW_NX10_xpec_r5_r5 = 32  /* [31:0] */
};

typedef struct NX10_XPEC_R5_BIT_Ttag {
	unsigned int r5 : BFW_NX10_xpec_r5_r5; /* Work Register 5 */
} NX10_XPEC_R5_BIT_T;

typedef union {
	unsigned int       val;
	NX10_XPEC_R5_BIT_T bf;
} NX10_XPEC_R5_T;

/* --------------------------------------------------------------------- */
/* Register xpec_r6 */
/* => xPEC work register for indirect addressing */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX10_xpec_r6   0x00000018U
#define Adr_NX10_xpec0_xpec_r6 0x10180018U
#define Adr_NX10_xpec_r6       0x10180018U
#define DFLT_VAL_NX10_xpec_r6  0x00000000U

#define MSK_NX10_xpec_r6_r6      0xffffffffU
#define SRT_NX10_xpec_r6_r6      0
#define DFLT_VAL_NX10_xpec_r6_r6 0x00000000U

enum {
	BFW_NX10_xpec_r6_r6 = 32  /* [31:0] */
};

typedef struct NX10_XPEC_R6_BIT_Ttag {
	unsigned int r6 : BFW_NX10_xpec_r6_r6; /* Work Register 6 */
} NX10_XPEC_R6_BIT_T;

typedef union {
	unsigned int       val;
	NX10_XPEC_R6_BIT_T bf;
} NX10_XPEC_R6_T;

/* --------------------------------------------------------------------- */
/* Register xpec_r7 */
/* => xPEC work register for indirect addressing */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX10_xpec_r7   0x0000001CU
#define Adr_NX10_xpec0_xpec_r7 0x1018001CU
#define Adr_NX10_xpec_r7       0x1018001CU
#define DFLT_VAL_NX10_xpec_r7  0x00000000U

#define MSK_NX10_xpec_r7_r7      0xffffffffU
#define SRT_NX10_xpec_r7_r7      0
#define DFLT_VAL_NX10_xpec_r7_r7 0x00000000U

enum {
	BFW_NX10_xpec_r7_r7 = 32  /* [31:0] */
};

typedef struct NX10_XPEC_R7_BIT_Ttag {
	unsigned int r7 : BFW_NX10_xpec_r7_r7; /* Work Register 7 */
} NX10_XPEC_R7_BIT_T;

typedef union {
	unsigned int       val;
	NX10_XPEC_R7_BIT_T bf;
} NX10_XPEC_R7_T;

/* --------------------------------------------------------------------- */
/* Register usr0 */
/* => xPEC user Register additional work register */
/*    Bitws 31 downto 28 are connected to the Event controller */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX10_usr0   0x00000020U
#define Adr_NX10_xpec0_usr0 0x10180020U
#define Adr_NX10_usr0       0x10180020U
#define DFLT_VAL_NX10_usr0  0x00000000U

#define MSK_NX10_usr0_usr0      0xffffffffU
#define SRT_NX10_usr0_usr0      0
#define DFLT_VAL_NX10_usr0_usr0 0x00000000U

enum {
	BFW_NX10_usr0_usr0 = 32  /* [31:0] */
};

typedef struct NX10_USR0_BIT_Ttag {
	unsigned int usr0 : BFW_NX10_usr0_usr0; /* User Register 0 */
} NX10_USR0_BIT_T;

typedef union {
	unsigned int    val;
	NX10_USR0_BIT_T bf;
} NX10_USR0_T;

/* --------------------------------------------------------------------- */
/* Register usr1 */
/* => xPEC user Register additional work register */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX10_usr1   0x00000024U
#define Adr_NX10_xpec0_usr1 0x10180024U
#define Adr_NX10_usr1       0x10180024U
#define DFLT_VAL_NX10_usr1  0x00000000U

#define MSK_NX10_usr1_usr1      0xffffffffU
#define SRT_NX10_usr1_usr1      0
#define DFLT_VAL_NX10_usr1_usr1 0x00000000U

enum {
	BFW_NX10_usr1_usr1 = 32  /* [31:0] */
};

typedef struct NX10_USR1_BIT_Ttag {
	unsigned int usr1 : BFW_NX10_usr1_usr1; /* User Register 1 */
} NX10_USR1_BIT_T;

typedef union {
	unsigned int    val;
	NX10_USR1_BIT_T bf;
} NX10_USR1_T;

/* --------------------------------------------------------------------- */
/* Register range45 */
/* => xPEC Overflow Underflow register to limit stack and fifo buffer. */
/*    Generates range bits inside xPEC status register */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX10_range45   0x00000028U
#define Adr_NX10_xpec0_range45 0x10180028U
#define Adr_NX10_range45       0x10180028U
#define DFLT_VAL_NX10_range45  0x00000000U

#define MSK_NX10_range45_range4       0x00001fffU
#define SRT_NX10_range45_range4       0
#define DFLT_VAL_NX10_range45_range4  0x00000000U
#define MSK_NX10_range45_bigger4      0x00002000U
#define SRT_NX10_range45_bigger4      13
#define DFLT_VAL_NX10_range45_bigger4 0x00000000U
#define MSK_NX10_range45_range5       0x1fff0000U
#define SRT_NX10_range45_range5       16
#define DFLT_VAL_NX10_range45_range5  0x00000000U
#define MSK_NX10_range45_bigger5      0x20000000U
#define SRT_NX10_range45_bigger5      29
#define DFLT_VAL_NX10_range45_bigger5 0x00000000U

enum {
	BFW_NX10_range45_range4    = 13, /* [12:0] */
	BFW_NX10_range45_bigger4   = 1,  /* [13] */
	BFW_NX10_range45_reserved1 = 2,  /* [15:14] */
	BFW_NX10_range45_range5    = 13, /* [28:16] */
	BFW_NX10_range45_bigger5   = 1,  /* [29] */
	BFW_NX10_range45_reserved2 = 2   /* [31:30] */
};

typedef struct NX10_RANGE45_BIT_Ttag {
	unsigned int range4    : BFW_NX10_range45_range4;    /* border for xpec_r4                                                                          */
	unsigned int bigger4   : BFW_NX10_range45_bigger4;   /* 0: generate range status bit, if r4 < range4; 1: generate range status bit, if r4 >= range4 */
	unsigned int reserved1 : BFW_NX10_range45_reserved1; /* reserved                                                                                    */
	unsigned int range5    : BFW_NX10_range45_range5;    /* border for xpec_r5                                                                          */
	unsigned int bigger5   : BFW_NX10_range45_bigger5;   /* 0: generate range status bit, if r5 < range5; 1: generate range status bit, if r5 >= range5 */
	unsigned int reserved2 : BFW_NX10_range45_reserved2; /* reserved                                                                                    */
} NX10_RANGE45_BIT_T;

typedef union {
	unsigned int       val;
	NX10_RANGE45_BIT_T bf;
} NX10_RANGE45_T;

/* --------------------------------------------------------------------- */
/* Register range67 */
/* => xPEC Overflow Underflow register to limit stack and fifo buffer. */
/*    Generates range bits inside xPEC status register */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX10_range67   0x0000002CU
#define Adr_NX10_xpec0_range67 0x1018002CU
#define Adr_NX10_range67       0x1018002CU
#define DFLT_VAL_NX10_range67  0x00000000U

#define MSK_NX10_range67_range6       0x00001fffU
#define SRT_NX10_range67_range6       0
#define DFLT_VAL_NX10_range67_range6  0x00000000U
#define MSK_NX10_range67_bigger6      0x00002000U
#define SRT_NX10_range67_bigger6      13
#define DFLT_VAL_NX10_range67_bigger6 0x00000000U
#define MSK_NX10_range67_range7       0x1fff0000U
#define SRT_NX10_range67_range7       16
#define DFLT_VAL_NX10_range67_range7  0x00000000U
#define MSK_NX10_range67_bigger7      0x20000000U
#define SRT_NX10_range67_bigger7      29
#define DFLT_VAL_NX10_range67_bigger7 0x00000000U

enum {
	BFW_NX10_range67_range6    = 13, /* [12:0] */
	BFW_NX10_range67_bigger6   = 1,  /* [13] */
	BFW_NX10_range67_reserved1 = 2,  /* [15:14] */
	BFW_NX10_range67_range7    = 13, /* [28:16] */
	BFW_NX10_range67_bigger7   = 1,  /* [29] */
	BFW_NX10_range67_reserved2 = 2   /* [31:30] */
};

typedef struct NX10_RANGE67_BIT_Ttag {
	unsigned int range6    : BFW_NX10_range67_range6;    /* border for xpec_r6                                                                          */
	unsigned int bigger6   : BFW_NX10_range67_bigger6;   /* 0: generate range status bit, if r6 < range6; 1: generate range status bit, if r6 >= range6 */
	unsigned int reserved1 : BFW_NX10_range67_reserved1; /* reserved                                                                                    */
	unsigned int range7    : BFW_NX10_range67_range7;    /* border for xpec_r7                                                                          */
	unsigned int bigger7   : BFW_NX10_range67_bigger7;   /* 0: generate range status bit, if r7 < range7; 1: generate range status bit, if r7 >= range7 */
	unsigned int reserved2 : BFW_NX10_range67_reserved2; /* reserved                                                                                    */
} NX10_RANGE67_BIT_T;

typedef union {
	unsigned int       val;
	NX10_RANGE67_BIT_T bf;
} NX10_RANGE67_T;

/* --------------------------------------------------------------------- */
/* Register timer0 */
/* => xPEC Timer 0 */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX10_timer0   0x00000030U
#define Adr_NX10_xpec0_timer0 0x10180030U
#define Adr_NX10_timer0       0x10180030U
#define DFLT_VAL_NX10_timer0  0x00000000U

#define MSK_NX10_timer0_preload0      0xffffffffU
#define SRT_NX10_timer0_preload0      0
#define DFLT_VAL_NX10_timer0_preload0 0x00000000U

enum {
	BFW_NX10_timer0_preload0 = 32  /* [31:0] */
};

typedef struct NX10_TIMER0_BIT_Ttag {
	unsigned int preload0 : BFW_NX10_timer0_preload0; /* read: actual value of timer, write: timer and preload value */
} NX10_TIMER0_BIT_T;

typedef union {
	unsigned int      val;
	NX10_TIMER0_BIT_T bf;
} NX10_TIMER0_T;

/* --------------------------------------------------------------------- */
/* Register timer1 */
/* => xPEC Timer 1 */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX10_timer1   0x00000034U
#define Adr_NX10_xpec0_timer1 0x10180034U
#define Adr_NX10_timer1       0x10180034U
#define DFLT_VAL_NX10_timer1  0x00000000U

#define MSK_NX10_timer1_preload1      0xffffffffU
#define SRT_NX10_timer1_preload1      0
#define DFLT_VAL_NX10_timer1_preload1 0x00000000U

enum {
	BFW_NX10_timer1_preload1 = 32  /* [31:0] */
};

typedef struct NX10_TIMER1_BIT_Ttag {
	unsigned int preload1 : BFW_NX10_timer1_preload1; /* read: actual value of timer, write: timer and preload value */
} NX10_TIMER1_BIT_T;

typedef union {
	unsigned int      val;
	NX10_TIMER1_BIT_T bf;
} NX10_TIMER1_T;

/* --------------------------------------------------------------------- */
/* Register timer2 */
/* => xPEC Timer 2 */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX10_timer2   0x00000038U
#define Adr_NX10_xpec0_timer2 0x10180038U
#define Adr_NX10_timer2       0x10180038U
#define DFLT_VAL_NX10_timer2  0x00000000U

#define MSK_NX10_timer2_preload2      0xffffffffU
#define SRT_NX10_timer2_preload2      0
#define DFLT_VAL_NX10_timer2_preload2 0x00000000U

enum {
	BFW_NX10_timer2_preload2 = 32  /* [31:0] */
};

typedef struct NX10_TIMER2_BIT_Ttag {
	unsigned int preload2 : BFW_NX10_timer2_preload2; /* read: actual value of timer, write: timer and preload value */
} NX10_TIMER2_BIT_T;

typedef union {
	unsigned int      val;
	NX10_TIMER2_BIT_T bf;
} NX10_TIMER2_T;

/* --------------------------------------------------------------------- */
/* Register timer3 */
/* => xPEC Timer 3 */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX10_timer3   0x0000003CU
#define Adr_NX10_xpec0_timer3 0x1018003CU
#define Adr_NX10_timer3       0x1018003CU
#define DFLT_VAL_NX10_timer3  0x00000000U

#define MSK_NX10_timer3_preload3      0xffffffffU
#define SRT_NX10_timer3_preload3      0
#define DFLT_VAL_NX10_timer3_preload3 0x00000000U

enum {
	BFW_NX10_timer3_preload3 = 32  /* [31:0] */
};

typedef struct NX10_TIMER3_BIT_Ttag {
	unsigned int preload3 : BFW_NX10_timer3_preload3; /* read: actual value of timer, write: timer and preload value */
} NX10_TIMER3_BIT_T;

typedef union {
	unsigned int      val;
	NX10_TIMER3_BIT_T bf;
} NX10_TIMER3_T;

/* --------------------------------------------------------------------- */
/* Register urx_count */
/* => xPEC urx counter */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX10_urx_count   0x00000040U
#define Adr_NX10_xpec0_urx_count 0x10180040U
#define Adr_NX10_urx_count       0x10180040U
#define DFLT_VAL_NX10_urx_count  0x00000000U

#define MSK_NX10_urx_count_urx_count      0xffffffffU
#define SRT_NX10_urx_count_urx_count      0
#define DFLT_VAL_NX10_urx_count_urx_count 0x00000000U

enum {
	BFW_NX10_urx_count_urx_count = 32  /* [31:0] */
};

typedef struct NX10_URX_COUNT_BIT_Ttag {
	unsigned int urx_count : BFW_NX10_urx_count_urx_count; /* counts up received bytes (accesses of xPEC to any URX FIFO) */
} NX10_URX_COUNT_BIT_T;

typedef union {
	unsigned int         val;
	NX10_URX_COUNT_BIT_T bf;
} NX10_URX_COUNT_T;

/* --------------------------------------------------------------------- */
/* Register utx_count */
/* => xPEC utx counter */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX10_utx_count   0x00000044U
#define Adr_NX10_xpec0_utx_count 0x10180044U
#define Adr_NX10_utx_count       0x10180044U
#define DFLT_VAL_NX10_utx_count  0x00000000U

#define MSK_NX10_utx_count_utx_count      0xffffffffU
#define SRT_NX10_utx_count_utx_count      0
#define DFLT_VAL_NX10_utx_count_utx_count 0x00000000U

enum {
	BFW_NX10_utx_count_utx_count = 32  /* [31:0] */
};

typedef struct NX10_UTX_COUNT_BIT_Ttag {
	unsigned int utx_count : BFW_NX10_utx_count_utx_count; /* counts up transmitted bytes (accesses of xPEC to any UTX FIFO) */
} NX10_UTX_COUNT_BIT_T;

typedef union {
	unsigned int         val;
	NX10_UTX_COUNT_BIT_T bf;
} NX10_UTX_COUNT_T;

/* --------------------------------------------------------------------- */
/* Register xpec_pc */
/* => xPEC Program Counter */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX10_xpec_pc   0x00000048U
#define Adr_NX10_xpec0_xpec_pc 0x10180048U
#define Adr_NX10_xpec_pc       0x10180048U
#define DFLT_VAL_NX10_xpec_pc  0x000007ffU

#define MSK_NX10_xpec_pc_pc      0x000007ffU
#define SRT_NX10_xpec_pc_pc      0
#define DFLT_VAL_NX10_xpec_pc_pc 0x000007ffU

enum {
	BFW_NX10_xpec_pc_pc        = 11, /* [10:0] */
	BFW_NX10_xpec_pc_reserved1 = 21  /* [31:11] */
};

typedef struct NX10_XPEC_PC_BIT_Ttag {
	unsigned int pc        : BFW_NX10_xpec_pc_pc;        /* Program Counter (dword address inside DPRAM) */
	unsigned int reserved1 : BFW_NX10_xpec_pc_reserved1; /* reserved                                     */
} NX10_XPEC_PC_BIT_T;

typedef union {
	unsigned int       val;
	NX10_XPEC_PC_BIT_T bf;
} NX10_XPEC_PC_T;

/* --------------------------------------------------------------------- */
/* Register zero */
/* => Zero Register */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX10_zero   0x0000004CU
#define Adr_NX10_xpec0_zero 0x1018004CU
#define Adr_NX10_zero       0x1018004CU
#define DFLT_VAL_NX10_zero  0x00000000U

#define MSK_NX10_zero_zero      0xffffffffU
#define SRT_NX10_zero_zero      0
#define DFLT_VAL_NX10_zero_zero 0x00000000U

enum {
	BFW_NX10_zero_zero = 32  /* [31:0] */
};

typedef struct NX10_ZERO_BIT_Ttag {
	unsigned int zero : BFW_NX10_zero_zero; /* Always Zero */
} NX10_ZERO_BIT_T;

typedef union {
	unsigned int    val;
	NX10_ZERO_BIT_T bf;
} NX10_ZERO_T;

/* --------------------------------------------------------------------- */
/* Register xpec_statcfg */
/* => xPEC Config register */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX10_xpec_statcfg   0x00000050U
#define Adr_NX10_xpec0_xpec_statcfg 0x10180050U
#define Adr_NX10_xpec_statcfg       0x10180050U
#define DFLT_VAL_NX10_xpec_statcfg  0x00000000U

#define MSK_NX10_xpec_statcfg_timer0                  0x00000003U
#define SRT_NX10_xpec_statcfg_timer0                  0
#define DFLT_VAL_NX10_xpec_statcfg_timer0             0x00000000U
#define MSK_NX10_xpec_statcfg_timer1                  0x0000000cU
#define SRT_NX10_xpec_statcfg_timer1                  2
#define DFLT_VAL_NX10_xpec_statcfg_timer1             0x00000000U
#define MSK_NX10_xpec_statcfg_timer2                  0x00000030U
#define SRT_NX10_xpec_statcfg_timer2                  4
#define DFLT_VAL_NX10_xpec_statcfg_timer2             0x00000000U
#define MSK_NX10_xpec_statcfg_timer3                  0x000000c0U
#define SRT_NX10_xpec_statcfg_timer3                  6
#define DFLT_VAL_NX10_xpec_statcfg_timer3             0x00000000U
#define MSK_NX10_xpec_statcfg_timer4                  0x00000300U
#define SRT_NX10_xpec_statcfg_timer4                  8
#define DFLT_VAL_NX10_xpec_statcfg_timer4             0x00000000U
#define MSK_NX10_xpec_statcfg_timer5                  0x00000c00U
#define SRT_NX10_xpec_statcfg_timer5                  10
#define DFLT_VAL_NX10_xpec_statcfg_timer5             0x00000000U
#define MSK_NX10_xpec_statcfg_reset_req               0x00001000U
#define SRT_NX10_xpec_statcfg_reset_req               12
#define DFLT_VAL_NX10_xpec_statcfg_reset_req          0x00000000U
#define MSK_NX10_xpec_statcfg_reset_dis               0x00002000U
#define SRT_NX10_xpec_statcfg_reset_dis               13
#define DFLT_VAL_NX10_xpec_statcfg_reset_dis          0x00000000U
#define MSK_NX10_xpec_statcfg_debug_mode              0x00004000U
#define SRT_NX10_xpec_statcfg_debug_mode              14
#define DFLT_VAL_NX10_xpec_statcfg_debug_mode         0x00000000U
#define MSK_NX10_xpec_statcfg_register_mode           0x00030000U
#define SRT_NX10_xpec_statcfg_register_mode           16
#define DFLT_VAL_NX10_xpec_statcfg_register_mode      0x00000000U
#define MSK_NX10_xpec_statcfg_wr4_range_sel           0x000c0000U
#define SRT_NX10_xpec_statcfg_wr4_range_sel           18
#define DFLT_VAL_NX10_xpec_statcfg_wr4_range_sel      0x00000000U
#define MSK_NX10_xpec_statcfg_wr5_range_sel           0x00300000U
#define SRT_NX10_xpec_statcfg_wr5_range_sel           20
#define DFLT_VAL_NX10_xpec_statcfg_wr5_range_sel      0x00000000U
#define MSK_NX10_xpec_statcfg_wr6_range_sel           0x00c00000U
#define SRT_NX10_xpec_statcfg_wr6_range_sel           22
#define DFLT_VAL_NX10_xpec_statcfg_wr6_range_sel      0x00000000U
#define MSK_NX10_xpec_statcfg_wr7_range_sel           0x03000000U
#define SRT_NX10_xpec_statcfg_wr7_range_sel           24
#define DFLT_VAL_NX10_xpec_statcfg_wr7_range_sel      0x00000000U
#define MSK_NX10_xpec_statcfg_run_dma_controller      0x80000000U
#define SRT_NX10_xpec_statcfg_run_dma_controller      31
#define DFLT_VAL_NX10_xpec_statcfg_run_dma_controller 0x00000000U

enum {
	BFW_NX10_xpec_statcfg_timer0             = 2, /* [1:0] */
	BFW_NX10_xpec_statcfg_timer1             = 2, /* [3:2] */
	BFW_NX10_xpec_statcfg_timer2             = 2, /* [5:4] */
	BFW_NX10_xpec_statcfg_timer3             = 2, /* [7:6] */
	BFW_NX10_xpec_statcfg_timer4             = 2, /* [9:8] */
	BFW_NX10_xpec_statcfg_timer5             = 2, /* [11:10] */
	BFW_NX10_xpec_statcfg_reset_req          = 1, /* [12] */
	BFW_NX10_xpec_statcfg_reset_dis          = 1, /* [13] */
	BFW_NX10_xpec_statcfg_debug_mode         = 1, /* [14] */
	BFW_NX10_xpec_statcfg_reserved1          = 1, /* [15] */
	BFW_NX10_xpec_statcfg_register_mode      = 2, /* [17:16] */
	BFW_NX10_xpec_statcfg_wr4_range_sel      = 2, /* [19:18] */
	BFW_NX10_xpec_statcfg_wr5_range_sel      = 2, /* [21:20] */
	BFW_NX10_xpec_statcfg_wr6_range_sel      = 2, /* [23:22] */
	BFW_NX10_xpec_statcfg_wr7_range_sel      = 2, /* [25:24] */
	BFW_NX10_xpec_statcfg_reserved2          = 5, /* [30:26] */
	BFW_NX10_xpec_statcfg_run_dma_controller = 1  /* [31] */
};

typedef struct NX10_XPEC_STATCFG_BIT_Ttag {
	unsigned int timer0             : BFW_NX10_xpec_statcfg_timer0;             /* Timer0                                                  */
	                                                                            /*       2'b00 : Timer stops at 0                          */
	unsigned int timer1             : BFW_NX10_xpec_statcfg_timer1;             /* Timer1                                                  */
	unsigned int timer2             : BFW_NX10_xpec_statcfg_timer2;             /* Timer2                                                  */
	unsigned int timer3             : BFW_NX10_xpec_statcfg_timer3;             /* Timer3                                                  */
	unsigned int timer4             : BFW_NX10_xpec_statcfg_timer4;             /* Timer4                                                  */
	unsigned int timer5             : BFW_NX10_xpec_statcfg_timer5;             /* Timer5                                                  */
	unsigned int reset_req          : BFW_NX10_xpec_statcfg_reset_req;          /* System Reset                                            */
	unsigned int reset_dis          : BFW_NX10_xpec_statcfg_reset_dis;          /* disable own Reset                                       */
	unsigned int debug_mode         : BFW_NX10_xpec_statcfg_debug_mode;         /* in this mode XPEC gets debug data form sr14 and sr15    */
	unsigned int reserved1          : BFW_NX10_xpec_statcfg_reserved1;          /* reserved                                                */
	unsigned int register_mode      : BFW_NX10_xpec_statcfg_register_mode;      /* Register Mode default 0                                 */
	                                                                            /*       2'b00 : normal mode (shared register and statcfg) */
	unsigned int wr4_range_sel      : BFW_NX10_xpec_statcfg_wr4_range_sel;      /* Select range mode for wr4 default 0                     */
	                                                                            /*       2'b00 : normal mode (range4 for wr4)              */
	unsigned int wr5_range_sel      : BFW_NX10_xpec_statcfg_wr5_range_sel;      /* Select range mode for wr5 default 0                     */
	                                                                            /*       2'b00 : normal mode (range5 for wr5)              */
	unsigned int wr6_range_sel      : BFW_NX10_xpec_statcfg_wr6_range_sel;      /* Select range mode for wr6 default 0                     */
	                                                                            /*       2'b00 : normal mode (range6 for wr6)              */
	unsigned int wr7_range_sel      : BFW_NX10_xpec_statcfg_wr7_range_sel;      /* Select range mode for wr7 default 0                     */
	                                                                            /*       2'b00 : normal mode (range7 for wr7)              */
	unsigned int reserved2          : BFW_NX10_xpec_statcfg_reserved2;          /* reserved                                                */
	unsigned int run_dma_controller : BFW_NX10_xpec_statcfg_run_dma_controller; /* 0: stop dma_controller, 1: start dma_controller         */
	                                                                            /* stop / start the polling                                */
} NX10_XPEC_STATCFG_BIT_T;

typedef union {
	unsigned int            val;
	NX10_XPEC_STATCFG_BIT_T bf;
} NX10_XPEC_STATCFG_T;

/* --------------------------------------------------------------------- */
/* Register ec_maska */
/* => JMP-Mask a */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX10_ec_maska   0x00000054U
#define Adr_NX10_xpec0_ec_maska 0x10180054U
#define Adr_NX10_ec_maska       0x10180054U
#define DFLT_VAL_NX10_ec_maska  0x0000ffffU

#define MSK_NX10_ec_maska_sel0                   0x000000ffU
#define SRT_NX10_ec_maska_sel0                   0
#define DFLT_VAL_NX10_ec_maska_sel0              0x000000ffU
#define MSK_NX10_ec_maska_sel1                   0x0000ff00U
#define SRT_NX10_ec_maska_sel1                   8
#define DFLT_VAL_NX10_ec_maska_sel1              0x0000ff00U
#define MSK_NX10_ec_maska_jmp_adr                0x07ff0000U
#define SRT_NX10_ec_maska_jmp_adr                16
#define DFLT_VAL_NX10_ec_maska_jmp_adr           0x00000000U
#define MSK_NX10_ec_maska_level_edge_event0      0x18000000U
#define SRT_NX10_ec_maska_level_edge_event0      27
#define DFLT_VAL_NX10_ec_maska_level_edge_event0 0x00000000U
#define MSK_NX10_ec_maska_level_edge_event1      0x60000000U
#define SRT_NX10_ec_maska_level_edge_event1      29
#define DFLT_VAL_NX10_ec_maska_level_edge_event1 0x00000000U
#define MSK_NX10_ec_maska_and_or                 0x80000000U
#define SRT_NX10_ec_maska_and_or                 31
#define DFLT_VAL_NX10_ec_maska_and_or            0x00000000U

enum {
	BFW_NX10_ec_maska_sel0              = 8,  /* [7:0] */
	BFW_NX10_ec_maska_sel1              = 8,  /* [15:8] */
	BFW_NX10_ec_maska_jmp_adr           = 11, /* [26:16] */
	BFW_NX10_ec_maska_level_edge_event0 = 2,  /* [28:27] */
	BFW_NX10_ec_maska_level_edge_event1 = 2,  /* [30:29] */
	BFW_NX10_ec_maska_and_or            = 1   /* [31] */
};

typedef struct NX10_EC_MASKA_BIT_Ttag {
	unsigned int sel0              : BFW_NX10_ec_maska_sel0;              /* Select of event 0:                               */
	                                                                      /*     0-15    : XMAC status reg 0 (statcfg0 16:31) */
	unsigned int sel1              : BFW_NX10_ec_maska_sel1;              /* Select of event 1                                */
	unsigned int jmp_adr           : BFW_NX10_ec_maska_jmp_adr;           /* jmp address (0-2047)                             */
	unsigned int level_edge_event0 : BFW_NX10_ec_maska_level_edge_event0; /* for event 0 : level / edge sensitive:            */
	                                                                      /*               2'b00 sensitve to 1 level          */
	unsigned int level_edge_event1 : BFW_NX10_ec_maska_level_edge_event1; /* for event 1 : level / edge sensitive:            */
	                                                                      /*               2'b00 sensitve to 1 level          */
	unsigned int and_or            : BFW_NX10_ec_maska_and_or;            /* and/or bit:                                      */
	                                                                      /* 0 - All bits of mask must fit with events,       */
} NX10_EC_MASKA_BIT_T;

typedef union {
	unsigned int        val;
	NX10_EC_MASKA_BIT_T bf;
} NX10_EC_MASKA_T;

/* --------------------------------------------------------------------- */
/* Register ec_maskb */
/* => JMP-Mask b */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX10_ec_maskb   0x00000058U
#define Adr_NX10_xpec0_ec_maskb 0x10180058U
#define Adr_NX10_ec_maskb       0x10180058U
#define DFLT_VAL_NX10_ec_maskb  0x0000ffffU

#define MSK_NX10_ec_maskb_sel0                   0x000000ffU
#define SRT_NX10_ec_maskb_sel0                   0
#define DFLT_VAL_NX10_ec_maskb_sel0              0x000000ffU
#define MSK_NX10_ec_maskb_sel1                   0x0000ff00U
#define SRT_NX10_ec_maskb_sel1                   8
#define DFLT_VAL_NX10_ec_maskb_sel1              0x0000ff00U
#define MSK_NX10_ec_maskb_jmp_adr                0x07ff0000U
#define SRT_NX10_ec_maskb_jmp_adr                16
#define DFLT_VAL_NX10_ec_maskb_jmp_adr           0x00000000U
#define MSK_NX10_ec_maskb_level_edge_event0      0x18000000U
#define SRT_NX10_ec_maskb_level_edge_event0      27
#define DFLT_VAL_NX10_ec_maskb_level_edge_event0 0x00000000U
#define MSK_NX10_ec_maskb_level_edge_event1      0x60000000U
#define SRT_NX10_ec_maskb_level_edge_event1      29
#define DFLT_VAL_NX10_ec_maskb_level_edge_event1 0x00000000U
#define MSK_NX10_ec_maskb_and_or                 0x80000000U
#define SRT_NX10_ec_maskb_and_or                 31
#define DFLT_VAL_NX10_ec_maskb_and_or            0x00000000U

enum {
	BFW_NX10_ec_maskb_sel0              = 8,  /* [7:0] */
	BFW_NX10_ec_maskb_sel1              = 8,  /* [15:8] */
	BFW_NX10_ec_maskb_jmp_adr           = 11, /* [26:16] */
	BFW_NX10_ec_maskb_level_edge_event0 = 2,  /* [28:27] */
	BFW_NX10_ec_maskb_level_edge_event1 = 2,  /* [30:29] */
	BFW_NX10_ec_maskb_and_or            = 1   /* [31] */
};

typedef struct NX10_EC_MASKB_BIT_Ttag {
	unsigned int sel0              : BFW_NX10_ec_maskb_sel0;              /* Select of event 0                          */
	unsigned int sel1              : BFW_NX10_ec_maskb_sel1;              /* Select of event 1                          */
	unsigned int jmp_adr           : BFW_NX10_ec_maskb_jmp_adr;           /* jmp address (0-2047)                       */
	unsigned int level_edge_event0 : BFW_NX10_ec_maskb_level_edge_event0; /* for event 0 : level / edge sensitive:      */
	                                                                      /*               2'b00 sensitve to 1 level    */
	unsigned int level_edge_event1 : BFW_NX10_ec_maskb_level_edge_event1; /* for event 1 : level / edge sensitive:      */
	                                                                      /*               2'b00 sensitve to 1 level    */
	unsigned int and_or            : BFW_NX10_ec_maskb_and_or;            /* and/or bit:                                */
	                                                                      /* 0 - All bits of mask must fit with events, */
} NX10_EC_MASKB_BIT_T;

typedef union {
	unsigned int        val;
	NX10_EC_MASKB_BIT_T bf;
} NX10_EC_MASKB_T;

/* --------------------------------------------------------------------- */
/* Register ec_mask0 */
/* => Shared in xPEC fmmusm mode with pio (r mode). */
/*    in the PIO Mode read : 31-16 pio_oe[15:0] and 15-0 pio_in[15:0] */
/*    JMP-Mask 0 */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX10_ec_mask0   0x0000005CU
#define Adr_NX10_xpec0_ec_mask0 0x1018005CU
#define Adr_NX10_ec_mask0       0x1018005CU
#define DFLT_VAL_NX10_ec_mask0  0x0000ffffU

#define MSK_NX10_ec_mask0_sel0                   0x000000ffU
#define SRT_NX10_ec_mask0_sel0                   0
#define DFLT_VAL_NX10_ec_mask0_sel0              0x000000ffU
#define MSK_NX10_ec_mask0_sel1                   0x0000ff00U
#define SRT_NX10_ec_mask0_sel1                   8
#define DFLT_VAL_NX10_ec_mask0_sel1              0x0000ff00U
#define MSK_NX10_ec_mask0_jmp_adr                0x07ff0000U
#define SRT_NX10_ec_mask0_jmp_adr                16
#define DFLT_VAL_NX10_ec_mask0_jmp_adr           0x00000000U
#define MSK_NX10_ec_mask0_level_edge_event0      0x18000000U
#define SRT_NX10_ec_mask0_level_edge_event0      27
#define DFLT_VAL_NX10_ec_mask0_level_edge_event0 0x00000000U
#define MSK_NX10_ec_mask0_level_edge_event1      0x60000000U
#define SRT_NX10_ec_mask0_level_edge_event1      29
#define DFLT_VAL_NX10_ec_mask0_level_edge_event1 0x00000000U
#define MSK_NX10_ec_mask0_and_or                 0x80000000U
#define SRT_NX10_ec_mask0_and_or                 31
#define DFLT_VAL_NX10_ec_mask0_and_or            0x00000000U

enum {
	BFW_NX10_ec_mask0_sel0              = 8,  /* [7:0] */
	BFW_NX10_ec_mask0_sel1              = 8,  /* [15:8] */
	BFW_NX10_ec_mask0_jmp_adr           = 11, /* [26:16] */
	BFW_NX10_ec_mask0_level_edge_event0 = 2,  /* [28:27] */
	BFW_NX10_ec_mask0_level_edge_event1 = 2,  /* [30:29] */
	BFW_NX10_ec_mask0_and_or            = 1   /* [31] */
};

typedef struct NX10_EC_MASK0_BIT_Ttag {
	unsigned int sel0              : BFW_NX10_ec_mask0_sel0;              /* Select of event 0                          */
	unsigned int sel1              : BFW_NX10_ec_mask0_sel1;              /* Select of event 1                          */
	unsigned int jmp_adr           : BFW_NX10_ec_mask0_jmp_adr;           /* jmp address (0-2047)                       */
	unsigned int level_edge_event0 : BFW_NX10_ec_mask0_level_edge_event0; /* for event 0 : level / edge sensitive:      */
	                                                                      /*               2'b00 sensitve to 1 level    */
	unsigned int level_edge_event1 : BFW_NX10_ec_mask0_level_edge_event1; /* for event 1 : level / edge sensitive:      */
	                                                                      /*               2'b00 sensitve to 1 level    */
	unsigned int and_or            : BFW_NX10_ec_mask0_and_or;            /* and/or bit:                                */
	                                                                      /* 0 - All bits of mask must fit with events, */
} NX10_EC_MASK0_BIT_T;

typedef union {
	unsigned int        val;
	NX10_EC_MASK0_BIT_T bf;
} NX10_EC_MASK0_T;

/* --------------------------------------------------------------------- */
/* Register ec_mask1 */
/* => Shared in xPEC fmmusm mode with dpm_pio (r mode). */
/*    in the PDM_PIO Mode read : 31-16 dpm_pio_oe[15:0] and 15-0 dpm_pio_in[15:0] */
/*    JMP-Mask 1 */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX10_ec_mask1   0x00000060U
#define Adr_NX10_xpec0_ec_mask1 0x10180060U
#define Adr_NX10_ec_mask1       0x10180060U
#define DFLT_VAL_NX10_ec_mask1  0x0000ffffU

#define MSK_NX10_ec_mask1_sel0                   0x000000ffU
#define SRT_NX10_ec_mask1_sel0                   0
#define DFLT_VAL_NX10_ec_mask1_sel0              0x000000ffU
#define MSK_NX10_ec_mask1_sel1                   0x0000ff00U
#define SRT_NX10_ec_mask1_sel1                   8
#define DFLT_VAL_NX10_ec_mask1_sel1              0x0000ff00U
#define MSK_NX10_ec_mask1_jmp_adr                0x07ff0000U
#define SRT_NX10_ec_mask1_jmp_adr                16
#define DFLT_VAL_NX10_ec_mask1_jmp_adr           0x00000000U
#define MSK_NX10_ec_mask1_level_edge_event0      0x18000000U
#define SRT_NX10_ec_mask1_level_edge_event0      27
#define DFLT_VAL_NX10_ec_mask1_level_edge_event0 0x00000000U
#define MSK_NX10_ec_mask1_level_edge_event1      0x60000000U
#define SRT_NX10_ec_mask1_level_edge_event1      29
#define DFLT_VAL_NX10_ec_mask1_level_edge_event1 0x00000000U
#define MSK_NX10_ec_mask1_and_or                 0x80000000U
#define SRT_NX10_ec_mask1_and_or                 31
#define DFLT_VAL_NX10_ec_mask1_and_or            0x00000000U

enum {
	BFW_NX10_ec_mask1_sel0              = 8,  /* [7:0] */
	BFW_NX10_ec_mask1_sel1              = 8,  /* [15:8] */
	BFW_NX10_ec_mask1_jmp_adr           = 11, /* [26:16] */
	BFW_NX10_ec_mask1_level_edge_event0 = 2,  /* [28:27] */
	BFW_NX10_ec_mask1_level_edge_event1 = 2,  /* [30:29] */
	BFW_NX10_ec_mask1_and_or            = 1   /* [31] */
};

typedef struct NX10_EC_MASK1_BIT_Ttag {
	unsigned int sel0              : BFW_NX10_ec_mask1_sel0;              /* Select of event 0                          */
	unsigned int sel1              : BFW_NX10_ec_mask1_sel1;              /* Select of event 1                          */
	unsigned int jmp_adr           : BFW_NX10_ec_mask1_jmp_adr;           /* jmp address (0-2047)                       */
	unsigned int level_edge_event0 : BFW_NX10_ec_mask1_level_edge_event0; /* for event 0 : level / edge sensitive:      */
	                                                                      /*               2'b00 sensitve to 1 level    */
	unsigned int level_edge_event1 : BFW_NX10_ec_mask1_level_edge_event1; /* for event 1 : level / edge sensitive:      */
	                                                                      /*               2'b00 sensitve to 1 level    */
	unsigned int and_or            : BFW_NX10_ec_mask1_and_or;            /* and/or bit:                                */
	                                                                      /* 0 - All bits of mask must fit with events, */
} NX10_EC_MASK1_BIT_T;

typedef union {
	unsigned int        val;
	NX10_EC_MASK1_BIT_T bf;
} NX10_EC_MASK1_T;

/* --------------------------------------------------------------------- */
/* Register ec_mask2 */
/* => Shared in xPEC fmmusm mode with netx_version (r mode). */
/*    JMP-Mask 2 */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX10_ec_mask2   0x00000064U
#define Adr_NX10_xpec0_ec_mask2 0x10180064U
#define Adr_NX10_ec_mask2       0x10180064U
#define DFLT_VAL_NX10_ec_mask2  0x0000ffffU

#define MSK_NX10_ec_mask2_sel0                   0x000000ffU
#define SRT_NX10_ec_mask2_sel0                   0
#define DFLT_VAL_NX10_ec_mask2_sel0              0x000000ffU
#define MSK_NX10_ec_mask2_sel1                   0x0000ff00U
#define SRT_NX10_ec_mask2_sel1                   8
#define DFLT_VAL_NX10_ec_mask2_sel1              0x0000ff00U
#define MSK_NX10_ec_mask2_jmp_adr                0x07ff0000U
#define SRT_NX10_ec_mask2_jmp_adr                16
#define DFLT_VAL_NX10_ec_mask2_jmp_adr           0x00000000U
#define MSK_NX10_ec_mask2_level_edge_event0      0x18000000U
#define SRT_NX10_ec_mask2_level_edge_event0      27
#define DFLT_VAL_NX10_ec_mask2_level_edge_event0 0x00000000U
#define MSK_NX10_ec_mask2_level_edge_event1      0x60000000U
#define SRT_NX10_ec_mask2_level_edge_event1      29
#define DFLT_VAL_NX10_ec_mask2_level_edge_event1 0x00000000U
#define MSK_NX10_ec_mask2_and_or                 0x80000000U
#define SRT_NX10_ec_mask2_and_or                 31
#define DFLT_VAL_NX10_ec_mask2_and_or            0x00000000U

enum {
	BFW_NX10_ec_mask2_sel0              = 8,  /* [7:0] */
	BFW_NX10_ec_mask2_sel1              = 8,  /* [15:8] */
	BFW_NX10_ec_mask2_jmp_adr           = 11, /* [26:16] */
	BFW_NX10_ec_mask2_level_edge_event0 = 2,  /* [28:27] */
	BFW_NX10_ec_mask2_level_edge_event1 = 2,  /* [30:29] */
	BFW_NX10_ec_mask2_and_or            = 1   /* [31] */
};

typedef struct NX10_EC_MASK2_BIT_Ttag {
	unsigned int sel0              : BFW_NX10_ec_mask2_sel0;              /* Select of event 0                          */
	unsigned int sel1              : BFW_NX10_ec_mask2_sel1;              /* Select of event 1                          */
	unsigned int jmp_adr           : BFW_NX10_ec_mask2_jmp_adr;           /* jmp address (0-2047)                       */
	unsigned int level_edge_event0 : BFW_NX10_ec_mask2_level_edge_event0; /* for event 0 : level / edge sensitive:      */
	                                                                      /*               2'b00 sensitve to 1 level    */
	unsigned int level_edge_event1 : BFW_NX10_ec_mask2_level_edge_event1; /* for event 1 : level / edge sensitive:      */
	                                                                      /*               2'b00 sensitve to 1 level    */
	unsigned int and_or            : BFW_NX10_ec_mask2_and_or;            /* and/or bit:                                */
	                                                                      /* 0 - All bits of mask must fit with events, */
} NX10_EC_MASK2_BIT_T;

typedef union {
	unsigned int        val;
	NX10_EC_MASK2_BIT_T bf;
} NX10_EC_MASK2_T;

/* --------------------------------------------------------------------- */
/* Register ec_mask3 */
/* => JMP-Mask 3 */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX10_ec_mask3   0x00000068U
#define Adr_NX10_xpec0_ec_mask3 0x10180068U
#define Adr_NX10_ec_mask3       0x10180068U
#define DFLT_VAL_NX10_ec_mask3  0x0000ffffU

#define MSK_NX10_ec_mask3_sel0                   0x000000ffU
#define SRT_NX10_ec_mask3_sel0                   0
#define DFLT_VAL_NX10_ec_mask3_sel0              0x000000ffU
#define MSK_NX10_ec_mask3_sel1                   0x0000ff00U
#define SRT_NX10_ec_mask3_sel1                   8
#define DFLT_VAL_NX10_ec_mask3_sel1              0x0000ff00U
#define MSK_NX10_ec_mask3_jmp_adr                0x07ff0000U
#define SRT_NX10_ec_mask3_jmp_adr                16
#define DFLT_VAL_NX10_ec_mask3_jmp_adr           0x00000000U
#define MSK_NX10_ec_mask3_level_edge_event0      0x18000000U
#define SRT_NX10_ec_mask3_level_edge_event0      27
#define DFLT_VAL_NX10_ec_mask3_level_edge_event0 0x00000000U
#define MSK_NX10_ec_mask3_level_edge_event1      0x60000000U
#define SRT_NX10_ec_mask3_level_edge_event1      29
#define DFLT_VAL_NX10_ec_mask3_level_edge_event1 0x00000000U
#define MSK_NX10_ec_mask3_and_or                 0x80000000U
#define SRT_NX10_ec_mask3_and_or                 31
#define DFLT_VAL_NX10_ec_mask3_and_or            0x00000000U

enum {
	BFW_NX10_ec_mask3_sel0              = 8,  /* [7:0] */
	BFW_NX10_ec_mask3_sel1              = 8,  /* [15:8] */
	BFW_NX10_ec_mask3_jmp_adr           = 11, /* [26:16] */
	BFW_NX10_ec_mask3_level_edge_event0 = 2,  /* [28:27] */
	BFW_NX10_ec_mask3_level_edge_event1 = 2,  /* [30:29] */
	BFW_NX10_ec_mask3_and_or            = 1   /* [31] */
};

typedef struct NX10_EC_MASK3_BIT_Ttag {
	unsigned int sel0              : BFW_NX10_ec_mask3_sel0;              /* Select of event 0                          */
	unsigned int sel1              : BFW_NX10_ec_mask3_sel1;              /* Select of event 1                          */
	unsigned int jmp_adr           : BFW_NX10_ec_mask3_jmp_adr;           /* jmp address (0-2047)                       */
	unsigned int level_edge_event0 : BFW_NX10_ec_mask3_level_edge_event0; /* for event 0 : level / edge sensitive:      */
	                                                                      /*               2'b00 sensitve to 1 level    */
	unsigned int level_edge_event1 : BFW_NX10_ec_mask3_level_edge_event1; /* for event 1 : level / edge sensitive:      */
	                                                                      /*               2'b00 sensitve to 1 level    */
	unsigned int and_or            : BFW_NX10_ec_mask3_and_or;            /* and/or bit:                                */
	                                                                      /* 0 - All bits of mask must fit with events, */
} NX10_EC_MASK3_BIT_T;

typedef union {
	unsigned int        val;
	NX10_EC_MASK3_BIT_T bf;
} NX10_EC_MASK3_T;

/* --------------------------------------------------------------------- */
/* Register ec_mask4 */
/* => JMP-Mask 4 */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX10_ec_mask4   0x0000006CU
#define Adr_NX10_xpec0_ec_mask4 0x1018006CU
#define Adr_NX10_ec_mask4       0x1018006CU
#define DFLT_VAL_NX10_ec_mask4  0x0000ffffU

#define MSK_NX10_ec_mask4_sel0                   0x000000ffU
#define SRT_NX10_ec_mask4_sel0                   0
#define DFLT_VAL_NX10_ec_mask4_sel0              0x000000ffU
#define MSK_NX10_ec_mask4_sel1                   0x0000ff00U
#define SRT_NX10_ec_mask4_sel1                   8
#define DFLT_VAL_NX10_ec_mask4_sel1              0x0000ff00U
#define MSK_NX10_ec_mask4_jmp_adr                0x07ff0000U
#define SRT_NX10_ec_mask4_jmp_adr                16
#define DFLT_VAL_NX10_ec_mask4_jmp_adr           0x00000000U
#define MSK_NX10_ec_mask4_level_edge_event0      0x18000000U
#define SRT_NX10_ec_mask4_level_edge_event0      27
#define DFLT_VAL_NX10_ec_mask4_level_edge_event0 0x00000000U
#define MSK_NX10_ec_mask4_level_edge_event1      0x60000000U
#define SRT_NX10_ec_mask4_level_edge_event1      29
#define DFLT_VAL_NX10_ec_mask4_level_edge_event1 0x00000000U
#define MSK_NX10_ec_mask4_and_or                 0x80000000U
#define SRT_NX10_ec_mask4_and_or                 31
#define DFLT_VAL_NX10_ec_mask4_and_or            0x00000000U

enum {
	BFW_NX10_ec_mask4_sel0              = 8,  /* [7:0] */
	BFW_NX10_ec_mask4_sel1              = 8,  /* [15:8] */
	BFW_NX10_ec_mask4_jmp_adr           = 11, /* [26:16] */
	BFW_NX10_ec_mask4_level_edge_event0 = 2,  /* [28:27] */
	BFW_NX10_ec_mask4_level_edge_event1 = 2,  /* [30:29] */
	BFW_NX10_ec_mask4_and_or            = 1   /* [31] */
};

typedef struct NX10_EC_MASK4_BIT_Ttag {
	unsigned int sel0              : BFW_NX10_ec_mask4_sel0;              /* Select of event 0                          */
	unsigned int sel1              : BFW_NX10_ec_mask4_sel1;              /* Select of event 1                          */
	unsigned int jmp_adr           : BFW_NX10_ec_mask4_jmp_adr;           /* jmp address (0-2047)                       */
	unsigned int level_edge_event0 : BFW_NX10_ec_mask4_level_edge_event0; /* for event 0 : level / edge sensitive:      */
	                                                                      /*               2'b00 sensitve to 1 level    */
	unsigned int level_edge_event1 : BFW_NX10_ec_mask4_level_edge_event1; /* for event 1 : level / edge sensitive:      */
	                                                                      /*               2'b00 sensitve to 1 level    */
	unsigned int and_or            : BFW_NX10_ec_mask4_and_or;            /* and/or bit:                                */
	                                                                      /* 0 - All bits of mask must fit with events, */
} NX10_EC_MASK4_BIT_T;

typedef union {
	unsigned int        val;
	NX10_EC_MASK4_BIT_T bf;
} NX10_EC_MASK4_T;

/* --------------------------------------------------------------------- */
/* Register ec_mask5 */
/* => JMP-Mask 5 */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX10_ec_mask5   0x00000070U
#define Adr_NX10_xpec0_ec_mask5 0x10180070U
#define Adr_NX10_ec_mask5       0x10180070U
#define DFLT_VAL_NX10_ec_mask5  0x0000ffffU

#define MSK_NX10_ec_mask5_sel0                   0x000000ffU
#define SRT_NX10_ec_mask5_sel0                   0
#define DFLT_VAL_NX10_ec_mask5_sel0              0x000000ffU
#define MSK_NX10_ec_mask5_sel1                   0x0000ff00U
#define SRT_NX10_ec_mask5_sel1                   8
#define DFLT_VAL_NX10_ec_mask5_sel1              0x0000ff00U
#define MSK_NX10_ec_mask5_jmp_adr                0x07ff0000U
#define SRT_NX10_ec_mask5_jmp_adr                16
#define DFLT_VAL_NX10_ec_mask5_jmp_adr           0x00000000U
#define MSK_NX10_ec_mask5_level_edge_event0      0x18000000U
#define SRT_NX10_ec_mask5_level_edge_event0      27
#define DFLT_VAL_NX10_ec_mask5_level_edge_event0 0x00000000U
#define MSK_NX10_ec_mask5_level_edge_event1      0x60000000U
#define SRT_NX10_ec_mask5_level_edge_event1      29
#define DFLT_VAL_NX10_ec_mask5_level_edge_event1 0x00000000U
#define MSK_NX10_ec_mask5_and_or                 0x80000000U
#define SRT_NX10_ec_mask5_and_or                 31
#define DFLT_VAL_NX10_ec_mask5_and_or            0x00000000U

enum {
	BFW_NX10_ec_mask5_sel0              = 8,  /* [7:0] */
	BFW_NX10_ec_mask5_sel1              = 8,  /* [15:8] */
	BFW_NX10_ec_mask5_jmp_adr           = 11, /* [26:16] */
	BFW_NX10_ec_mask5_level_edge_event0 = 2,  /* [28:27] */
	BFW_NX10_ec_mask5_level_edge_event1 = 2,  /* [30:29] */
	BFW_NX10_ec_mask5_and_or            = 1   /* [31] */
};

typedef struct NX10_EC_MASK5_BIT_Ttag {
	unsigned int sel0              : BFW_NX10_ec_mask5_sel0;              /* Select of event 0                          */
	unsigned int sel1              : BFW_NX10_ec_mask5_sel1;              /* Select of event 1                          */
	unsigned int jmp_adr           : BFW_NX10_ec_mask5_jmp_adr;           /* jmp address (0-2047)                       */
	unsigned int level_edge_event0 : BFW_NX10_ec_mask5_level_edge_event0; /* for event 0 : level / edge sensitive:      */
	                                                                      /*               2'b00 sensitve to 1 level    */
	unsigned int level_edge_event1 : BFW_NX10_ec_mask5_level_edge_event1; /* for event 1 : level / edge sensitive:      */
	                                                                      /*               2'b00 sensitve to 1 level    */
	unsigned int and_or            : BFW_NX10_ec_mask5_and_or;            /* and/or bit:                                */
	                                                                      /* 0 - All bits of mask must fit with events, */
} NX10_EC_MASK5_BIT_T;

typedef union {
	unsigned int        val;
	NX10_EC_MASK5_BIT_T bf;
} NX10_EC_MASK5_T;

/* --------------------------------------------------------------------- */
/* Register ec_mask6 */
/* => JMP-Mask 6 */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX10_ec_mask6   0x00000074U
#define Adr_NX10_xpec0_ec_mask6 0x10180074U
#define Adr_NX10_ec_mask6       0x10180074U
#define DFLT_VAL_NX10_ec_mask6  0x0000ffffU

#define MSK_NX10_ec_mask6_sel0                   0x000000ffU
#define SRT_NX10_ec_mask6_sel0                   0
#define DFLT_VAL_NX10_ec_mask6_sel0              0x000000ffU
#define MSK_NX10_ec_mask6_sel1                   0x0000ff00U
#define SRT_NX10_ec_mask6_sel1                   8
#define DFLT_VAL_NX10_ec_mask6_sel1              0x0000ff00U
#define MSK_NX10_ec_mask6_jmp_adr                0x07ff0000U
#define SRT_NX10_ec_mask6_jmp_adr                16
#define DFLT_VAL_NX10_ec_mask6_jmp_adr           0x00000000U
#define MSK_NX10_ec_mask6_level_edge_event0      0x18000000U
#define SRT_NX10_ec_mask6_level_edge_event0      27
#define DFLT_VAL_NX10_ec_mask6_level_edge_event0 0x00000000U
#define MSK_NX10_ec_mask6_level_edge_event1      0x60000000U
#define SRT_NX10_ec_mask6_level_edge_event1      29
#define DFLT_VAL_NX10_ec_mask6_level_edge_event1 0x00000000U
#define MSK_NX10_ec_mask6_and_or                 0x80000000U
#define SRT_NX10_ec_mask6_and_or                 31
#define DFLT_VAL_NX10_ec_mask6_and_or            0x00000000U

enum {
	BFW_NX10_ec_mask6_sel0              = 8,  /* [7:0] */
	BFW_NX10_ec_mask6_sel1              = 8,  /* [15:8] */
	BFW_NX10_ec_mask6_jmp_adr           = 11, /* [26:16] */
	BFW_NX10_ec_mask6_level_edge_event0 = 2,  /* [28:27] */
	BFW_NX10_ec_mask6_level_edge_event1 = 2,  /* [30:29] */
	BFW_NX10_ec_mask6_and_or            = 1   /* [31] */
};

typedef struct NX10_EC_MASK6_BIT_Ttag {
	unsigned int sel0              : BFW_NX10_ec_mask6_sel0;              /* Select of event 0                          */
	unsigned int sel1              : BFW_NX10_ec_mask6_sel1;              /* Select of event 1                          */
	unsigned int jmp_adr           : BFW_NX10_ec_mask6_jmp_adr;           /* jmp address (0-2047)                       */
	unsigned int level_edge_event0 : BFW_NX10_ec_mask6_level_edge_event0; /* for event 0 : level / edge sensitive:      */
	                                                                      /*               2'b00 sensitve to 1 level    */
	unsigned int level_edge_event1 : BFW_NX10_ec_mask6_level_edge_event1; /* for event 1 : level / edge sensitive:      */
	                                                                      /*               2'b00 sensitve to 1 level    */
	unsigned int and_or            : BFW_NX10_ec_mask6_and_or;            /* and/or bit:                                */
	                                                                      /* 0 - All bits of mask must fit with events, */
} NX10_EC_MASK6_BIT_T;

typedef union {
	unsigned int        val;
	NX10_EC_MASK6_BIT_T bf;
} NX10_EC_MASK6_T;

/* --------------------------------------------------------------------- */
/* Register ec_mask7 */
/* => JMP-Mask 7 */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX10_ec_mask7   0x00000078U
#define Adr_NX10_xpec0_ec_mask7 0x10180078U
#define Adr_NX10_ec_mask7       0x10180078U
#define DFLT_VAL_NX10_ec_mask7  0x0000ffffU

#define MSK_NX10_ec_mask7_sel0                   0x000000ffU
#define SRT_NX10_ec_mask7_sel0                   0
#define DFLT_VAL_NX10_ec_mask7_sel0              0x000000ffU
#define MSK_NX10_ec_mask7_sel1                   0x0000ff00U
#define SRT_NX10_ec_mask7_sel1                   8
#define DFLT_VAL_NX10_ec_mask7_sel1              0x0000ff00U
#define MSK_NX10_ec_mask7_jmp_adr                0x07ff0000U
#define SRT_NX10_ec_mask7_jmp_adr                16
#define DFLT_VAL_NX10_ec_mask7_jmp_adr           0x00000000U
#define MSK_NX10_ec_mask7_level_edge_event0      0x18000000U
#define SRT_NX10_ec_mask7_level_edge_event0      27
#define DFLT_VAL_NX10_ec_mask7_level_edge_event0 0x00000000U
#define MSK_NX10_ec_mask7_level_edge_event1      0x60000000U
#define SRT_NX10_ec_mask7_level_edge_event1      29
#define DFLT_VAL_NX10_ec_mask7_level_edge_event1 0x00000000U
#define MSK_NX10_ec_mask7_and_or                 0x80000000U
#define SRT_NX10_ec_mask7_and_or                 31
#define DFLT_VAL_NX10_ec_mask7_and_or            0x00000000U

enum {
	BFW_NX10_ec_mask7_sel0              = 8,  /* [7:0] */
	BFW_NX10_ec_mask7_sel1              = 8,  /* [15:8] */
	BFW_NX10_ec_mask7_jmp_adr           = 11, /* [26:16] */
	BFW_NX10_ec_mask7_level_edge_event0 = 2,  /* [28:27] */
	BFW_NX10_ec_mask7_level_edge_event1 = 2,  /* [30:29] */
	BFW_NX10_ec_mask7_and_or            = 1   /* [31] */
};

typedef struct NX10_EC_MASK7_BIT_Ttag {
	unsigned int sel0              : BFW_NX10_ec_mask7_sel0;              /* Select of event 0                          */
	unsigned int sel1              : BFW_NX10_ec_mask7_sel1;              /* Select of event 1                          */
	unsigned int jmp_adr           : BFW_NX10_ec_mask7_jmp_adr;           /* jmp address (0-2047)                       */
	unsigned int level_edge_event0 : BFW_NX10_ec_mask7_level_edge_event0; /* for event 0 : level / edge sensitive:      */
	                                                                      /*               2'b00 sensitve to 1 level    */
	unsigned int level_edge_event1 : BFW_NX10_ec_mask7_level_edge_event1; /* for event 1 : level / edge sensitive:      */
	                                                                      /*               2'b00 sensitve to 1 level    */
	unsigned int and_or            : BFW_NX10_ec_mask7_and_or;            /* and/or bit:                                */
	                                                                      /* 0 - All bits of mask must fit with events, */
} NX10_EC_MASK7_BIT_T;

typedef union {
	unsigned int        val;
	NX10_EC_MASK7_BIT_T bf;
} NX10_EC_MASK7_T;

/* --------------------------------------------------------------------- */
/* Register ec_mask8 */
/* => JMP-Mask 8 */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX10_ec_mask8   0x0000007CU
#define Adr_NX10_xpec0_ec_mask8 0x1018007CU
#define Adr_NX10_ec_mask8       0x1018007CU
#define DFLT_VAL_NX10_ec_mask8  0x0000ffffU

#define MSK_NX10_ec_mask8_sel0                   0x000000ffU
#define SRT_NX10_ec_mask8_sel0                   0
#define DFLT_VAL_NX10_ec_mask8_sel0              0x000000ffU
#define MSK_NX10_ec_mask8_sel1                   0x0000ff00U
#define SRT_NX10_ec_mask8_sel1                   8
#define DFLT_VAL_NX10_ec_mask8_sel1              0x0000ff00U
#define MSK_NX10_ec_mask8_jmp_adr                0x07ff0000U
#define SRT_NX10_ec_mask8_jmp_adr                16
#define DFLT_VAL_NX10_ec_mask8_jmp_adr           0x00000000U
#define MSK_NX10_ec_mask8_level_edge_event0      0x18000000U
#define SRT_NX10_ec_mask8_level_edge_event0      27
#define DFLT_VAL_NX10_ec_mask8_level_edge_event0 0x00000000U
#define MSK_NX10_ec_mask8_level_edge_event1      0x60000000U
#define SRT_NX10_ec_mask8_level_edge_event1      29
#define DFLT_VAL_NX10_ec_mask8_level_edge_event1 0x00000000U
#define MSK_NX10_ec_mask8_and_or                 0x80000000U
#define SRT_NX10_ec_mask8_and_or                 31
#define DFLT_VAL_NX10_ec_mask8_and_or            0x00000000U

enum {
	BFW_NX10_ec_mask8_sel0              = 8,  /* [7:0] */
	BFW_NX10_ec_mask8_sel1              = 8,  /* [15:8] */
	BFW_NX10_ec_mask8_jmp_adr           = 11, /* [26:16] */
	BFW_NX10_ec_mask8_level_edge_event0 = 2,  /* [28:27] */
	BFW_NX10_ec_mask8_level_edge_event1 = 2,  /* [30:29] */
	BFW_NX10_ec_mask8_and_or            = 1   /* [31] */
};

typedef struct NX10_EC_MASK8_BIT_Ttag {
	unsigned int sel0              : BFW_NX10_ec_mask8_sel0;              /* Select of event 0                          */
	unsigned int sel1              : BFW_NX10_ec_mask8_sel1;              /* Select of event 1                          */
	unsigned int jmp_adr           : BFW_NX10_ec_mask8_jmp_adr;           /* jmp address (0-2047)                       */
	unsigned int level_edge_event0 : BFW_NX10_ec_mask8_level_edge_event0; /* for event 0 : level / edge sensitive:      */
	                                                                      /*               2'b00 sensitve to 1 level    */
	unsigned int level_edge_event1 : BFW_NX10_ec_mask8_level_edge_event1; /* for event 1 : level / edge sensitive:      */
	                                                                      /*               2'b00 sensitve to 1 level    */
	unsigned int and_or            : BFW_NX10_ec_mask8_and_or;            /* and/or bit:                                */
	                                                                      /* 0 - All bits of mask must fit with events, */
} NX10_EC_MASK8_BIT_T;

typedef union {
	unsigned int        val;
	NX10_EC_MASK8_BIT_T bf;
} NX10_EC_MASK8_T;

/* --------------------------------------------------------------------- */
/* Register ec_mask9 */
/* => JMP-Mask 9 */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX10_ec_mask9   0x00000080U
#define Adr_NX10_xpec0_ec_mask9 0x10180080U
#define Adr_NX10_ec_mask9       0x10180080U
#define DFLT_VAL_NX10_ec_mask9  0x0000ffffU

#define MSK_NX10_ec_mask9_sel0                   0x000000ffU
#define SRT_NX10_ec_mask9_sel0                   0
#define DFLT_VAL_NX10_ec_mask9_sel0              0x000000ffU
#define MSK_NX10_ec_mask9_sel1                   0x0000ff00U
#define SRT_NX10_ec_mask9_sel1                   8
#define DFLT_VAL_NX10_ec_mask9_sel1              0x0000ff00U
#define MSK_NX10_ec_mask9_jmp_adr                0x07ff0000U
#define SRT_NX10_ec_mask9_jmp_adr                16
#define DFLT_VAL_NX10_ec_mask9_jmp_adr           0x00000000U
#define MSK_NX10_ec_mask9_level_edge_event0      0x18000000U
#define SRT_NX10_ec_mask9_level_edge_event0      27
#define DFLT_VAL_NX10_ec_mask9_level_edge_event0 0x00000000U
#define MSK_NX10_ec_mask9_level_edge_event1      0x60000000U
#define SRT_NX10_ec_mask9_level_edge_event1      29
#define DFLT_VAL_NX10_ec_mask9_level_edge_event1 0x00000000U
#define MSK_NX10_ec_mask9_and_or                 0x80000000U
#define SRT_NX10_ec_mask9_and_or                 31
#define DFLT_VAL_NX10_ec_mask9_and_or            0x00000000U

enum {
	BFW_NX10_ec_mask9_sel0              = 8,  /* [7:0] */
	BFW_NX10_ec_mask9_sel1              = 8,  /* [15:8] */
	BFW_NX10_ec_mask9_jmp_adr           = 11, /* [26:16] */
	BFW_NX10_ec_mask9_level_edge_event0 = 2,  /* [28:27] */
	BFW_NX10_ec_mask9_level_edge_event1 = 2,  /* [30:29] */
	BFW_NX10_ec_mask9_and_or            = 1   /* [31] */
};

typedef struct NX10_EC_MASK9_BIT_Ttag {
	unsigned int sel0              : BFW_NX10_ec_mask9_sel0;              /* Select of event 0                          */
	unsigned int sel1              : BFW_NX10_ec_mask9_sel1;              /* Select of event 1                          */
	unsigned int jmp_adr           : BFW_NX10_ec_mask9_jmp_adr;           /* jmp address (0-2047)                       */
	unsigned int level_edge_event0 : BFW_NX10_ec_mask9_level_edge_event0; /* for event 0 : level / edge sensitive:      */
	                                                                      /*               2'b00 sensitve to 1 level    */
	unsigned int level_edge_event1 : BFW_NX10_ec_mask9_level_edge_event1; /* for event 1 : level / edge sensitive:      */
	                                                                      /*               2'b00 sensitve to 1 level    */
	unsigned int and_or            : BFW_NX10_ec_mask9_and_or;            /* and/or bit:                                */
	                                                                      /* 0 - All bits of mask must fit with events, */
} NX10_EC_MASK9_BIT_T;

typedef union {
	unsigned int        val;
	NX10_EC_MASK9_BIT_T bf;
} NX10_EC_MASK9_T;

/* --------------------------------------------------------------------- */
/* Register timer4 */
/* => xPEC Timer 4 */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX10_timer4   0x00000084U
#define Adr_NX10_xpec0_timer4 0x10180084U
#define Adr_NX10_timer4       0x10180084U
#define DFLT_VAL_NX10_timer4  0x00000000U

#define MSK_NX10_timer4_preload2      0xffffffffU
#define SRT_NX10_timer4_preload2      0
#define DFLT_VAL_NX10_timer4_preload2 0x00000000U

enum {
	BFW_NX10_timer4_preload2 = 32  /* [31:0] */
};

typedef struct NX10_TIMER4_BIT_Ttag {
	unsigned int preload2 : BFW_NX10_timer4_preload2; /* read: actual value of timer, write: timer and preload value */
} NX10_TIMER4_BIT_T;

typedef union {
	unsigned int      val;
	NX10_TIMER4_BIT_T bf;
} NX10_TIMER4_T;

/* --------------------------------------------------------------------- */
/* Register timer5 */
/* => xPEC Timer 5 */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX10_timer5   0x00000088U
#define Adr_NX10_xpec0_timer5 0x10180088U
#define Adr_NX10_timer5       0x10180088U
#define DFLT_VAL_NX10_timer5  0x00000000U

#define MSK_NX10_timer5_preload3      0xffffffffU
#define SRT_NX10_timer5_preload3      0
#define DFLT_VAL_NX10_timer5_preload3 0x00000000U

enum {
	BFW_NX10_timer5_preload3 = 32  /* [31:0] */
};

typedef struct NX10_TIMER5_BIT_Ttag {
	unsigned int preload3 : BFW_NX10_timer5_preload3; /* read: actual value of timer, write: timer and preload value */
} NX10_TIMER5_BIT_T;

typedef union {
	unsigned int      val;
	NX10_TIMER5_BIT_T bf;
} NX10_TIMER5_T;

/* --------------------------------------------------------------------- */
/* Register irq */
/* => xPEC IRQ Register */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX10_irq   0x0000008CU
#define Adr_NX10_xpec0_irq 0x1018008CU
#define Adr_NX10_irq       0x1018008CU
#define DFLT_VAL_NX10_irq  0x00000000U

#define MSK_NX10_irq_xpec_irq      0x0000ffffU
#define SRT_NX10_irq_xpec_irq      0
#define DFLT_VAL_NX10_irq_xpec_irq 0x00000000U
#define MSK_NX10_irq_arm_irq       0xffff0000U
#define SRT_NX10_irq_arm_irq       16
#define DFLT_VAL_NX10_irq_arm_irq  0x00000000U

enum {
	BFW_NX10_irq_xpec_irq = 16, /* [15:0] */
	BFW_NX10_irq_arm_irq  = 16  /* [31:16] */
};

typedef struct NX10_IRQ_BIT_Ttag {
	unsigned int xpec_irq : BFW_NX10_irq_xpec_irq; /* set by xpec ; reset by arm  */
	unsigned int arm_irq  : BFW_NX10_irq_arm_irq;  /* set by arm  ; reset by xpec */
} NX10_IRQ_BIT_T;

typedef union {
	unsigned int   val;
	NX10_IRQ_BIT_T bf;
} NX10_IRQ_T;

/* --------------------------------------------------------------------- */
/* Register xpec_systime_ns */
/* => xPEC System time (for read) */
/*    PIOs and PIOS output enables [15:0] (write) */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX10_xpec_systime_ns   0x00000090U
#define Adr_NX10_xpec0_xpec_systime_ns 0x10180090U
#define Adr_NX10_xpec_systime_ns       0x10180090U
#define DFLT_VAL_NX10_xpec_systime_ns  0x00000000U

#define MSK_NX10_xpec_systime_ns_systime_ns      0xffffffffU
#define SRT_NX10_xpec_systime_ns_systime_ns      0
#define DFLT_VAL_NX10_xpec_systime_ns_systime_ns 0x00000000U

enum {
	BFW_NX10_xpec_systime_ns_systime_ns = 32  /* [31:0] */
};

typedef struct NX10_XPEC_SYSTIME_NS_BIT_Ttag {
	unsigned int systime_ns : BFW_NX10_xpec_systime_ns_systime_ns; /* read: 32 - Bit System Time (ns) */
	                                                               /* write:  31-15 pio_oe[15:0]      */
} NX10_XPEC_SYSTIME_NS_BIT_T;

typedef union {
	unsigned int               val;
	NX10_XPEC_SYSTIME_NS_BIT_T bf;
} NX10_XPEC_SYSTIME_NS_T;

/* --------------------------------------------------------------------- */
/* Register fifo_data */
/* => xPEC fifo_data */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX10_fifo_data   0x00000094U
#define Adr_NX10_xpec0_fifo_data 0x10180094U
#define Adr_NX10_fifo_data       0x10180094U
#define DFLT_VAL_NX10_fifo_data  0x00000000U

#define MSK_NX10_fifo_data_fifo_data      0xffffffffU
#define SRT_NX10_fifo_data_fifo_data      0
#define DFLT_VAL_NX10_fifo_data_fifo_data 0x00000000U

enum {
	BFW_NX10_fifo_data_fifo_data = 32  /* [31:0] */
};

typedef struct NX10_FIFO_DATA_BIT_Ttag {
	unsigned int fifo_data : BFW_NX10_fifo_data_fifo_data; /* default 0x0000 */
} NX10_FIFO_DATA_BIT_T;

typedef union {
	unsigned int         val;
	NX10_FIFO_DATA_BIT_T bf;
} NX10_FIFO_DATA_T;

/* --------------------------------------------------------------------- */
/* Register xpec_systime_s */
/* => xPEC System time (read) */
/*    DPM_PIOs and DPM_PIOS output enables [15:0] (write) */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX10_xpec_systime_s   0x00000098U
#define Adr_NX10_xpec0_xpec_systime_s 0x10180098U
#define Adr_NX10_xpec_systime_s       0x10180098U
#define DFLT_VAL_NX10_xpec_systime_s  0x00000000U

#define MSK_NX10_xpec_systime_s_systime_s      0xffffffffU
#define SRT_NX10_xpec_systime_s_systime_s      0
#define DFLT_VAL_NX10_xpec_systime_s_systime_s 0x00000000U

enum {
	BFW_NX10_xpec_systime_s_systime_s = 32  /* [31:0] */
};

typedef struct NX10_XPEC_SYSTIME_S_BIT_Ttag {
	unsigned int systime_s : BFW_NX10_xpec_systime_s_systime_s; /* read: 32 - Bit System Time (s) */
	                                                            /* write: 31-15 dpm_pio_oe[15:0]  */
} NX10_XPEC_SYSTIME_S_BIT_T;

typedef union {
	unsigned int              val;
	NX10_XPEC_SYSTIME_S_BIT_T bf;
} NX10_XPEC_SYSTIME_S_T;

/* --------------------------------------------------------------------- */
/* Register xpec_adc */
/* => Shared in xPEC fmmusm mode with buf_man (r/w mode). */
/*    reserved for ADC Register in future netX-versions. */
/*    becomes adr_buf_man of BUF_MAN */
/*    Buffer manager address for master xPEC: */
/*    16 buffer manager modules can be accessed, where each one handles buffer numbers between up to 4 procesors. */
/*    Each read request of a master will be answered by the most actual buffer number, */
/*    each write request of a master will be answered by the lowest free buffer number. */
/*    The buffer managers can be accessed in 2 different modes: 'normal mode' and 'parallel mode' (also known as EtherCAT mode): */
/*    In normal mode getting a new buffer happens with 2 command accesses: */
/*    1st: Write access: Tell the buf_manager channel (0..15) and wether you want read or write buffer. */
/*         Wait for 2 clockcycles, until new buffer number is calculated after any write access. */
/*    2nd: Read access: Read the buffer number (0..4). */
/*    In parallel mode all buffers are accessed in parallel but some functionality is limited. */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX10_xpec_adc   0x0000009CU
#define Adr_NX10_xpec0_xpec_adc 0x1018009CU
#define Adr_NX10_xpec_adc       0x1018009CU
#define DFLT_VAL_NX10_xpec_adc  0x00000007U

#define MSK_NX10_xpec_adc_buf_nr              0x0000000fU
#define SRT_NX10_xpec_adc_buf_nr              0
#define DFLT_VAL_NX10_xpec_adc_buf_nr         0x00000007U
#define MSK_NX10_xpec_adc_req_type            0x00000060U
#define SRT_NX10_xpec_adc_req_type            5
#define DFLT_VAL_NX10_xpec_adc_req_type       0x00000000U
#define MSK_NX10_xpec_adc_semaphore_mode      0x00000080U
#define SRT_NX10_xpec_adc_semaphore_mode      7
#define DFLT_VAL_NX10_xpec_adc_semaphore_mode 0x00000000U
#define MSK_NX10_xpec_adc_parallel_mode       0x00000100U
#define SRT_NX10_xpec_adc_parallel_mode       8
#define DFLT_VAL_NX10_xpec_adc_parallel_mode  0x00000000U
#define MSK_NX10_xpec_adc_reset               0x00000200U
#define SRT_NX10_xpec_adc_reset               9
#define DFLT_VAL_NX10_xpec_adc_reset          0x00000000U
#define MSK_NX10_xpec_adc_sm_update_en        0x00000400U
#define SRT_NX10_xpec_adc_sm_update_en        10
#define DFLT_VAL_NX10_xpec_adc_sm_update_en   0x00000000U
#define MSK_NX10_xpec_adc_sm_update_dis       0x00000800U
#define SRT_NX10_xpec_adc_sm_update_dis       11
#define DFLT_VAL_NX10_xpec_adc_sm_update_dis  0x00000000U

enum {
	BFW_NX10_xpec_adc_buf_nr         = 4,  /* [3:0] */
	BFW_NX10_xpec_adc_reserved1      = 1,  /* [4] */
	BFW_NX10_xpec_adc_req_type       = 2,  /* [6:5] */
	BFW_NX10_xpec_adc_semaphore_mode = 1,  /* [7] */
	BFW_NX10_xpec_adc_parallel_mode  = 1,  /* [8] */
	BFW_NX10_xpec_adc_reset          = 1,  /* [9] */
	BFW_NX10_xpec_adc_sm_update_en   = 1,  /* [10] */
	BFW_NX10_xpec_adc_sm_update_dis  = 1,  /* [11] */
	BFW_NX10_xpec_adc_reserved2      = 20  /* [31:12] */
};

typedef struct NX10_XPEC_ADC_BIT_Ttag {
	unsigned int buf_nr         : BFW_NX10_xpec_adc_buf_nr;         /* write access: number of buf_manager channel (0..15)                                              */
	                                                                /* read access: number of buffer (0..m+1), where m ist the number of masters using this buf_manager */
	unsigned int reserved1      : BFW_NX10_xpec_adc_reserved1;      /* reserved                                                                                         */
	unsigned int req_type       : BFW_NX10_xpec_adc_req_type;       /* Request type bits are write-only                                                                 */
	                                                                /* 00: request read buffer (or semaphore)                                                           */
	unsigned int semaphore_mode : BFW_NX10_xpec_adc_semaphore_mode; /* Activate 'semaphore mode' for this buf_nr by writing 1 to this bit.                              */
	                                                                /* To return from semaphore-mode reset this channel                                                 */
	unsigned int parallel_mode  : BFW_NX10_xpec_adc_parallel_mode;  /* activate parallel mode by writing 1 to this bit (other bits are ignored):                        */
	                                                                /* In parallel mode, the behavior of all bits of this register changes completely.                  */
	unsigned int reset          : BFW_NX10_xpec_adc_reset;          /* reset channel                                                                                    */
	unsigned int sm_update_en   : BFW_NX10_xpec_adc_sm_update_en;   /* activate SM_auto_update mode by writing 1 to this bit:                                           */
	                                                                /* In SM_auto_update mode the requested buffer numbers of buffer managers 0..7 will automatically   */
	unsigned int sm_update_dis  : BFW_NX10_xpec_adc_sm_update_dis;  /* de-activate SM_auto_update mode by writing 1 to this bit:                                        */
	unsigned int reserved2      : BFW_NX10_xpec_adc_reserved2;      /* reserved                                                                                         */
} NX10_XPEC_ADC_BIT_T;

typedef union {
	unsigned int        val;
	NX10_XPEC_ADC_BIT_T bf;
} NX10_XPEC_ADC_T;

/* --------------------------------------------------------------------- */
/* Register xpec_sr0 */
/* => Shared Work Register 0 accessed by all xPECs and all xMACs. */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX10_xpec_sr0   0x000000A0U
#define Adr_NX10_xpec0_xpec_sr0 0x101800A0U
#define Adr_NX10_xpec_sr0       0x101800A0U
#define DFLT_VAL_NX10_xpec_sr0  0x00000000U

#define MSK_NX10_xpec_sr0_SR0         0x0000ffffU
#define SRT_NX10_xpec_sr0_SR0         0
#define DFLT_VAL_NX10_xpec_sr0_SR0    0x00000000U
#define MSK_NX10_xpec_sr0_SR0_15      0xffff0000U
#define SRT_NX10_xpec_sr0_SR0_15      16
#define DFLT_VAL_NX10_xpec_sr0_SR0_15 0x00000000U

enum {
	BFW_NX10_xpec_sr0_SR0    = 16, /* [15:0] */
	BFW_NX10_xpec_sr0_SR0_15 = 16  /* [31:16] */
};

typedef struct NX10_XPEC_SR0_BIT_Ttag {
	unsigned int SR0    : BFW_NX10_xpec_sr0_SR0;    /* Shared Register */
	unsigned int SR0_15 : BFW_NX10_xpec_sr0_SR0_15; /* Sign extension  */
} NX10_XPEC_SR0_BIT_T;

typedef union {
	unsigned int        val;
	NX10_XPEC_SR0_BIT_T bf;
} NX10_XPEC_SR0_T;

/* --------------------------------------------------------------------- */
/* Register xpec_sr1 */
/* => Shared Work Register 1 accessed by all xPECs and all xMACs. */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX10_xpec_sr1   0x000000A4U
#define Adr_NX10_xpec0_xpec_sr1 0x101800A4U
#define Adr_NX10_xpec_sr1       0x101800A4U
#define DFLT_VAL_NX10_xpec_sr1  0x00000000U

#define MSK_NX10_xpec_sr1_SR1         0x0000ffffU
#define SRT_NX10_xpec_sr1_SR1         0
#define DFLT_VAL_NX10_xpec_sr1_SR1    0x00000000U
#define MSK_NX10_xpec_sr1_SR1_15      0xffff0000U
#define SRT_NX10_xpec_sr1_SR1_15      16
#define DFLT_VAL_NX10_xpec_sr1_SR1_15 0x00000000U

enum {
	BFW_NX10_xpec_sr1_SR1    = 16, /* [15:0] */
	BFW_NX10_xpec_sr1_SR1_15 = 16  /* [31:16] */
};

typedef struct NX10_XPEC_SR1_BIT_Ttag {
	unsigned int SR1    : BFW_NX10_xpec_sr1_SR1;    /* Shared Register */
	unsigned int SR1_15 : BFW_NX10_xpec_sr1_SR1_15; /* Sign extension  */
} NX10_XPEC_SR1_BIT_T;

typedef union {
	unsigned int        val;
	NX10_XPEC_SR1_BIT_T bf;
} NX10_XPEC_SR1_T;

/* --------------------------------------------------------------------- */
/* Register xpec_sr2 */
/* => Shared Work Register 2 accessed by all xPECs and all xMACs. */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX10_xpec_sr2   0x000000A8U
#define Adr_NX10_xpec0_xpec_sr2 0x101800A8U
#define Adr_NX10_xpec_sr2       0x101800A8U
#define DFLT_VAL_NX10_xpec_sr2  0x00000000U

#define MSK_NX10_xpec_sr2_SR2         0x0000ffffU
#define SRT_NX10_xpec_sr2_SR2         0
#define DFLT_VAL_NX10_xpec_sr2_SR2    0x00000000U
#define MSK_NX10_xpec_sr2_SR2_15      0xffff0000U
#define SRT_NX10_xpec_sr2_SR2_15      16
#define DFLT_VAL_NX10_xpec_sr2_SR2_15 0x00000000U

enum {
	BFW_NX10_xpec_sr2_SR2    = 16, /* [15:0] */
	BFW_NX10_xpec_sr2_SR2_15 = 16  /* [31:16] */
};

typedef struct NX10_XPEC_SR2_BIT_Ttag {
	unsigned int SR2    : BFW_NX10_xpec_sr2_SR2;    /* Shared Register */
	unsigned int SR2_15 : BFW_NX10_xpec_sr2_SR2_15; /* Sign extension  */
} NX10_XPEC_SR2_BIT_T;

typedef union {
	unsigned int        val;
	NX10_XPEC_SR2_BIT_T bf;
} NX10_XPEC_SR2_T;

/* --------------------------------------------------------------------- */
/* Register xpec_sr3 */
/* => Shared Work Register 3 accessed by all xPECs and all xMACs. */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX10_xpec_sr3   0x000000ACU
#define Adr_NX10_xpec0_xpec_sr3 0x101800ACU
#define Adr_NX10_xpec_sr3       0x101800ACU
#define DFLT_VAL_NX10_xpec_sr3  0x00000000U

#define MSK_NX10_xpec_sr3_SR3         0x0000ffffU
#define SRT_NX10_xpec_sr3_SR3         0
#define DFLT_VAL_NX10_xpec_sr3_SR3    0x00000000U
#define MSK_NX10_xpec_sr3_SR3_15      0xffff0000U
#define SRT_NX10_xpec_sr3_SR3_15      16
#define DFLT_VAL_NX10_xpec_sr3_SR3_15 0x00000000U

enum {
	BFW_NX10_xpec_sr3_SR3    = 16, /* [15:0] */
	BFW_NX10_xpec_sr3_SR3_15 = 16  /* [31:16] */
};

typedef struct NX10_XPEC_SR3_BIT_Ttag {
	unsigned int SR3    : BFW_NX10_xpec_sr3_SR3;    /* Shared Register */
	unsigned int SR3_15 : BFW_NX10_xpec_sr3_SR3_15; /* Sign extension  */
} NX10_XPEC_SR3_BIT_T;

typedef union {
	unsigned int        val;
	NX10_XPEC_SR3_BIT_T bf;
} NX10_XPEC_SR3_T;

/* --------------------------------------------------------------------- */
/* Register xpec_sr4 */
/* => Shared Work Register 4 accessed by all xPECs and all xMACs. */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX10_xpec_sr4   0x000000B0U
#define Adr_NX10_xpec0_xpec_sr4 0x101800B0U
#define Adr_NX10_xpec_sr4       0x101800B0U
#define DFLT_VAL_NX10_xpec_sr4  0x00000000U

#define MSK_NX10_xpec_sr4_SR4         0x0000ffffU
#define SRT_NX10_xpec_sr4_SR4         0
#define DFLT_VAL_NX10_xpec_sr4_SR4    0x00000000U
#define MSK_NX10_xpec_sr4_SR4_15      0xffff0000U
#define SRT_NX10_xpec_sr4_SR4_15      16
#define DFLT_VAL_NX10_xpec_sr4_SR4_15 0x00000000U

enum {
	BFW_NX10_xpec_sr4_SR4    = 16, /* [15:0] */
	BFW_NX10_xpec_sr4_SR4_15 = 16  /* [31:16] */
};

typedef struct NX10_XPEC_SR4_BIT_Ttag {
	unsigned int SR4    : BFW_NX10_xpec_sr4_SR4;    /* Shared Register */
	unsigned int SR4_15 : BFW_NX10_xpec_sr4_SR4_15; /* Sign extension  */
} NX10_XPEC_SR4_BIT_T;

typedef union {
	unsigned int        val;
	NX10_XPEC_SR4_BIT_T bf;
} NX10_XPEC_SR4_T;

/* --------------------------------------------------------------------- */
/* Register xpec_sr5 */
/* => Shared Work Register 5 accessed by all xPECs and all xMACs. */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX10_xpec_sr5   0x000000B4U
#define Adr_NX10_xpec0_xpec_sr5 0x101800B4U
#define Adr_NX10_xpec_sr5       0x101800B4U
#define DFLT_VAL_NX10_xpec_sr5  0x00000000U

#define MSK_NX10_xpec_sr5_SR5         0x0000ffffU
#define SRT_NX10_xpec_sr5_SR5         0
#define DFLT_VAL_NX10_xpec_sr5_SR5    0x00000000U
#define MSK_NX10_xpec_sr5_SR5_15      0xffff0000U
#define SRT_NX10_xpec_sr5_SR5_15      16
#define DFLT_VAL_NX10_xpec_sr5_SR5_15 0x00000000U

enum {
	BFW_NX10_xpec_sr5_SR5    = 16, /* [15:0] */
	BFW_NX10_xpec_sr5_SR5_15 = 16  /* [31:16] */
};

typedef struct NX10_XPEC_SR5_BIT_Ttag {
	unsigned int SR5    : BFW_NX10_xpec_sr5_SR5;    /* Shared Register */
	unsigned int SR5_15 : BFW_NX10_xpec_sr5_SR5_15; /* Sign extension  */
} NX10_XPEC_SR5_BIT_T;

typedef union {
	unsigned int        val;
	NX10_XPEC_SR5_BIT_T bf;
} NX10_XPEC_SR5_T;

/* --------------------------------------------------------------------- */
/* Register statcfg0 */
/* => xMAC0 Shared Config/Status Register */
/*    for write mode the upper Bits [31:16] are mask bits for Bits [15:0] of shared_config (xMAC) register */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX10_statcfg0   0x000000E0U
#define Adr_NX10_xpec0_statcfg0 0x101800E0U
#define Adr_NX10_statcfg0       0x101800E0U
#define DFLT_VAL_NX10_statcfg0  0x08500000U

#define MSK_NX10_statcfg0_gpio2_out              0x00000001U
#define SRT_NX10_statcfg0_gpio2_out              0
#define DFLT_VAL_NX10_statcfg0_gpio2_out         0x00000000U
#define MSK_NX10_statcfg0_gpio2_oe               0x00000002U
#define SRT_NX10_statcfg0_gpio2_oe               1
#define DFLT_VAL_NX10_statcfg0_gpio2_oe          0x00000000U
#define MSK_NX10_statcfg0_gpio3_out              0x00000004U
#define SRT_NX10_statcfg0_gpio3_out              2
#define DFLT_VAL_NX10_statcfg0_gpio3_out         0x00000000U
#define MSK_NX10_statcfg0_gpio3_oe               0x00000008U
#define SRT_NX10_statcfg0_gpio3_oe               3
#define DFLT_VAL_NX10_statcfg0_gpio3_oe          0x00000000U
#define MSK_NX10_statcfg0_gpio4_out              0x00000010U
#define SRT_NX10_statcfg0_gpio4_out              4
#define DFLT_VAL_NX10_statcfg0_gpio4_out         0x00000000U
#define MSK_NX10_statcfg0_gpio4_oe               0x00000020U
#define SRT_NX10_statcfg0_gpio4_oe               5
#define DFLT_VAL_NX10_statcfg0_gpio4_oe          0x00000000U
#define MSK_NX10_statcfg0_gpio5_out              0x00000040U
#define SRT_NX10_statcfg0_gpio5_out              6
#define DFLT_VAL_NX10_statcfg0_gpio5_out         0x00000000U
#define MSK_NX10_statcfg0_gpio5_oe               0x00000080U
#define SRT_NX10_statcfg0_gpio5_oe               7
#define DFLT_VAL_NX10_statcfg0_gpio5_oe          0x00000000U
#define MSK_NX10_statcfg0_rx_shift_lr            0x00000100U
#define SRT_NX10_statcfg0_rx_shift_lr            8
#define DFLT_VAL_NX10_statcfg0_rx_shift_lr       0x00000000U
#define MSK_NX10_statcfg0_tx_shift_lr            0x00000200U
#define SRT_NX10_statcfg0_tx_shift_lr            9
#define DFLT_VAL_NX10_statcfg0_tx_shift_lr       0x00000000U
#define MSK_NX10_statcfg0_reset_rx_fifo          0x00000400U
#define SRT_NX10_statcfg0_reset_rx_fifo          10
#define DFLT_VAL_NX10_statcfg0_reset_rx_fifo     0x00000000U
#define MSK_NX10_statcfg0_reset_tx_fifo          0x00000800U
#define SRT_NX10_statcfg0_reset_tx_fifo          11
#define DFLT_VAL_NX10_statcfg0_reset_tx_fifo     0x00000000U
#define MSK_NX10_statcfg0_gpio0_out              0x00001000U
#define SRT_NX10_statcfg0_gpio0_out              12
#define DFLT_VAL_NX10_statcfg0_gpio0_out         0x00000000U
#define MSK_NX10_statcfg0_gpio0_oe               0x00002000U
#define SRT_NX10_statcfg0_gpio0_oe               13
#define DFLT_VAL_NX10_statcfg0_gpio0_oe          0x00000000U
#define MSK_NX10_statcfg0_gpio1_out              0x00004000U
#define SRT_NX10_statcfg0_gpio1_out              14
#define DFLT_VAL_NX10_statcfg0_gpio1_out         0x00000000U
#define MSK_NX10_statcfg0_gpio1_oe               0x00008000U
#define SRT_NX10_statcfg0_gpio1_oe               15
#define DFLT_VAL_NX10_statcfg0_gpio1_oe          0x00000000U
#define MSK_NX10_statcfg0_gpio0_in               0x00010000U
#define SRT_NX10_statcfg0_gpio0_in               16
#define DFLT_VAL_NX10_statcfg0_gpio0_in          0x00000000U
#define MSK_NX10_statcfg0_gpio1_in               0x00020000U
#define SRT_NX10_statcfg0_gpio1_in               17
#define DFLT_VAL_NX10_statcfg0_gpio1_in          0x00000000U
#define MSK_NX10_statcfg0_rx_rdy                 0x00040000U
#define SRT_NX10_statcfg0_rx_rdy                 18
#define DFLT_VAL_NX10_statcfg0_rx_rdy            0x00000000U
#define MSK_NX10_statcfg0_rx_ovf                 0x00080000U
#define SRT_NX10_statcfg0_rx_ovf                 19
#define DFLT_VAL_NX10_statcfg0_rx_ovf            0x00000000U
#define MSK_NX10_statcfg0_tx_nxt                 0x00100000U
#define SRT_NX10_statcfg0_tx_nxt                 20
#define DFLT_VAL_NX10_statcfg0_tx_nxt            0x00100000U
#define MSK_NX10_statcfg0_tx_ufl                 0x00200000U
#define SRT_NX10_statcfg0_tx_ufl                 21
#define DFLT_VAL_NX10_statcfg0_tx_ufl            0x00000000U
#define MSK_NX10_statcfg0_utx_empty              0x00400000U
#define SRT_NX10_statcfg0_utx_empty              22
#define DFLT_VAL_NX10_statcfg0_utx_empty         0x00400000U
#define MSK_NX10_statcfg0_brec                   0x00800000U
#define SRT_NX10_statcfg0_brec                   23
#define DFLT_VAL_NX10_statcfg0_brec              0x00000000U
#define MSK_NX10_statcfg0_btran                  0x01000000U
#define SRT_NX10_statcfg0_btran                  24
#define DFLT_VAL_NX10_statcfg0_btran             0x00000000U
#define MSK_NX10_statcfg0_stat_rpu               0x02000000U
#define SRT_NX10_statcfg0_stat_rpu               25
#define DFLT_VAL_NX10_statcfg0_stat_rpu          0x00000000U
#define MSK_NX10_statcfg0_stat_tpu               0x04000000U
#define SRT_NX10_statcfg0_stat_tpu               26
#define DFLT_VAL_NX10_statcfg0_stat_tpu          0x00000000U
#define MSK_NX10_statcfg0_phy_led_en             0x08000000U
#define SRT_NX10_statcfg0_phy_led_en             27
#define DFLT_VAL_NX10_statcfg0_phy_led_en        0x08000000U
#define MSK_NX10_statcfg0_gpio2_in_phy_led0      0x10000000U
#define SRT_NX10_statcfg0_gpio2_in_phy_led0      28
#define DFLT_VAL_NX10_statcfg0_gpio2_in_phy_led0 0x00000000U
#define MSK_NX10_statcfg0_gpio3_in_phy_led1      0x20000000U
#define SRT_NX10_statcfg0_gpio3_in_phy_led1      29
#define DFLT_VAL_NX10_statcfg0_gpio3_in_phy_led1 0x00000000U
#define MSK_NX10_statcfg0_gpio4_in_phy_led2      0x40000000U
#define SRT_NX10_statcfg0_gpio4_in_phy_led2      30
#define DFLT_VAL_NX10_statcfg0_gpio4_in_phy_led2 0x00000000U
#define MSK_NX10_statcfg0_gpio5_in_phy_led3      0x80000000U
#define SRT_NX10_statcfg0_gpio5_in_phy_led3      31
#define DFLT_VAL_NX10_statcfg0_gpio5_in_phy_led3 0x00000000U

enum {
	BFW_NX10_statcfg0_gpio2_out         = 1, /* [0] */
	BFW_NX10_statcfg0_gpio2_oe          = 1, /* [1] */
	BFW_NX10_statcfg0_gpio3_out         = 1, /* [2] */
	BFW_NX10_statcfg0_gpio3_oe          = 1, /* [3] */
	BFW_NX10_statcfg0_gpio4_out         = 1, /* [4] */
	BFW_NX10_statcfg0_gpio4_oe          = 1, /* [5] */
	BFW_NX10_statcfg0_gpio5_out         = 1, /* [6] */
	BFW_NX10_statcfg0_gpio5_oe          = 1, /* [7] */
	BFW_NX10_statcfg0_rx_shift_lr       = 1, /* [8] */
	BFW_NX10_statcfg0_tx_shift_lr       = 1, /* [9] */
	BFW_NX10_statcfg0_reset_rx_fifo     = 1, /* [10] */
	BFW_NX10_statcfg0_reset_tx_fifo     = 1, /* [11] */
	BFW_NX10_statcfg0_gpio0_out         = 1, /* [12] */
	BFW_NX10_statcfg0_gpio0_oe          = 1, /* [13] */
	BFW_NX10_statcfg0_gpio1_out         = 1, /* [14] */
	BFW_NX10_statcfg0_gpio1_oe          = 1, /* [15] */
	BFW_NX10_statcfg0_gpio0_in          = 1, /* [16] */
	BFW_NX10_statcfg0_gpio1_in          = 1, /* [17] */
	BFW_NX10_statcfg0_rx_rdy            = 1, /* [18] */
	BFW_NX10_statcfg0_rx_ovf            = 1, /* [19] */
	BFW_NX10_statcfg0_tx_nxt            = 1, /* [20] */
	BFW_NX10_statcfg0_tx_ufl            = 1, /* [21] */
	BFW_NX10_statcfg0_utx_empty         = 1, /* [22] */
	BFW_NX10_statcfg0_brec              = 1, /* [23] */
	BFW_NX10_statcfg0_btran             = 1, /* [24] */
	BFW_NX10_statcfg0_stat_rpu          = 1, /* [25] */
	BFW_NX10_statcfg0_stat_tpu          = 1, /* [26] */
	BFW_NX10_statcfg0_phy_led_en        = 1, /* [27] */
	BFW_NX10_statcfg0_gpio2_in_phy_led0 = 1, /* [28] */
	BFW_NX10_statcfg0_gpio3_in_phy_led1 = 1, /* [29] */
	BFW_NX10_statcfg0_gpio4_in_phy_led2 = 1, /* [30] */
	BFW_NX10_statcfg0_gpio5_in_phy_led3 = 1  /* [31] */
};

typedef struct NX10_STATCFG0_BIT_Ttag {
	unsigned int gpio2_out         : BFW_NX10_statcfg0_gpio2_out;         /* General Purpose IO 2 output                                                    */
	unsigned int gpio2_oe          : BFW_NX10_statcfg0_gpio2_oe;          /* General Purpose IO 2 output enable                                             */
	unsigned int gpio3_out         : BFW_NX10_statcfg0_gpio3_out;         /* General Purpose IO 3 output                                                    */
	unsigned int gpio3_oe          : BFW_NX10_statcfg0_gpio3_oe;          /* General Purpose IO 3 output enable                                             */
	unsigned int gpio4_out         : BFW_NX10_statcfg0_gpio4_out;         /* General Purpose IO 4 output                                                    */
	unsigned int gpio4_oe          : BFW_NX10_statcfg0_gpio4_oe;          /* General Purpose IO 4 output enable                                             */
	unsigned int gpio5_out         : BFW_NX10_statcfg0_gpio5_out;         /* General Purpose IO 5 output                                                    */
	unsigned int gpio5_oe          : BFW_NX10_statcfg0_gpio5_oe;          /* General Purpose IO 5 output enable                                             */
	unsigned int rx_shift_lr       : BFW_NX10_statcfg0_rx_shift_lr;       /* 1: SBU reads incoming bits to position 0 of register rx and shifts rx left,    */
	                                                                      /* 0: SBU reads incoming bits to position 15 of register rx and shifts rx right   */
	unsigned int tx_shift_lr       : BFW_NX10_statcfg0_tx_shift_lr;       /* 1: OBU reads outgoing bits from position 15 of register tx and shifts tx left, */
	                                                                      /* 0: OBU reads outgoing bits from position 0 of register tx and shifts tx right  */
	unsigned int reset_rx_fifo     : BFW_NX10_statcfg0_reset_rx_fifo;     /* reset URX_FIFO and rx_ovf bit inside status_shared register                    */
	unsigned int reset_tx_fifo     : BFW_NX10_statcfg0_reset_tx_fifo;     /* reset UTX_FIFO and tx_ufl bit inside status_shared register                    */
	unsigned int gpio0_out         : BFW_NX10_statcfg0_gpio0_out;         /* General Purpose IO 0 output                                                    */
	unsigned int gpio0_oe          : BFW_NX10_statcfg0_gpio0_oe;          /* General Purpose IO 0 output enable                                             */
	unsigned int gpio1_out         : BFW_NX10_statcfg0_gpio1_out;         /* General Purpose IO 1 output                                                    */
	unsigned int gpio1_oe          : BFW_NX10_statcfg0_gpio1_oe;          /* General Purpose IO 1 output enable                                             */
	unsigned int gpio0_in          : BFW_NX10_statcfg0_gpio0_in;          /* value at external gpio pin                                                     */
	unsigned int gpio1_in          : BFW_NX10_statcfg0_gpio1_in;          /* value at external gpio pin                                                     */
	unsigned int rx_rdy            : BFW_NX10_statcfg0_rx_rdy;            /* received bytes are valid at output of URX_FIFO                                 */
	unsigned int rx_ovf            : BFW_NX10_statcfg0_rx_ovf;            /* receive overflow (too much data in URX_FIFO)                                   */
	unsigned int tx_nxt            : BFW_NX10_statcfg0_tx_nxt;            /* put next tx_word to UTX_FIFO: at least one entry of UTX_FIFO is empty          */
	unsigned int tx_ufl            : BFW_NX10_statcfg0_tx_ufl;            /* transmit underflow (not enough data in UTX_FIFO)                               */
	unsigned int utx_empty         : BFW_NX10_statcfg0_utx_empty;         /* UTX_FIFO is empty                                                              */
	unsigned int brec              : BFW_NX10_statcfg0_brec;              /* bit_received (active for 1 cc)                                                 */
	unsigned int btran             : BFW_NX10_statcfg0_btran;             /* bit_transmitted (active for 1 cc)                                              */
	unsigned int stat_rpu          : BFW_NX10_statcfg0_stat_rpu;          /* set and reset by RPU command bits                                              */
	unsigned int stat_tpu          : BFW_NX10_statcfg0_stat_tpu;          /* set and reset by TPU command bits                                              */
	unsigned int phy_led_en        : BFW_NX10_statcfg0_phy_led_en;        /* -> read only version of xmac_config_sbu-phy_led_en (visible to xPECs)          */
	unsigned int gpio2_in_phy_led0 : BFW_NX10_statcfg0_gpio2_in_phy_led0; /* IF phy_led_en:                                                                 */
	                                                                      /* 1: gpio2_in # value at external gpio pin                                       */
	unsigned int gpio3_in_phy_led1 : BFW_NX10_statcfg0_gpio3_in_phy_led1; /* IF phy_led_en:                                                                 */
	                                                                      /* 1: gpio3_in # value at external gpio pin                                       */
	unsigned int gpio4_in_phy_led2 : BFW_NX10_statcfg0_gpio4_in_phy_led2; /* IF phy_led_en:                                                                 */
	                                                                      /* 1: gpio4_in # value at external gpio pin                                       */
	unsigned int gpio5_in_phy_led3 : BFW_NX10_statcfg0_gpio5_in_phy_led3; /* IF phy_led_en:                                                                 */
	                                                                      /* 1: gpio5_in # value at external gpio pin                                       */
} NX10_STATCFG0_BIT_T;

typedef union {
	unsigned int        val;
	NX10_STATCFG0_BIT_T bf;
} NX10_STATCFG0_T;

/* --------------------------------------------------------------------- */
/* Register urtx0 */
/* => xMAC0 URX Shared Register */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX10_urtx0   0x000000F0U
#define Adr_NX10_xpec0_urtx0 0x101800F0U
#define Adr_NX10_urtx0       0x101800F0U
#define DFLT_VAL_NX10_urtx0  0x00000000U

#define MSK_NX10_urtx0_urtx_xmac0      0x0000ffffU
#define SRT_NX10_urtx0_urtx_xmac0      0
#define DFLT_VAL_NX10_urtx0_urtx_xmac0 0x00000000U

enum {
	BFW_NX10_urtx0_urtx_xmac0 = 16, /* [15:0] */
	BFW_NX10_urtx0_reserved1  = 16  /* [31:16] */
};

typedef struct NX10_URTX0_BIT_Ttag {
	unsigned int urtx_xmac0 : BFW_NX10_urtx0_urtx_xmac0; /* read access:  Lastly received bits (output of URX_FIFO)       */
	                                                     /* write access: Bits to be transmitted next (input of UTX_FIFO) */
	unsigned int reserved1  : BFW_NX10_urtx0_reserved1;  /* reserved                                                      */
} NX10_URTX0_BIT_T;

typedef union {
	unsigned int     val;
	NX10_URTX0_BIT_T bf;
} NX10_URTX0_T;

/* --------------------------------------------------------------------- */
/* Register xpu_hold_pc */
/* => xPEC hold_pc register - only accessible by the ARM */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX10_xpu_hold_pc   0x00000100U
#define Adr_NX10_xpec0_xpu_hold_pc 0x10180100U
#define Adr_NX10_xpu_hold_pc       0x10180100U
#define DFLT_VAL_NX10_xpu_hold_pc  0x00000001U

#define MSK_NX10_xpu_hold_pc_hold      0x00000001U
#define SRT_NX10_xpu_hold_pc_hold      0
#define DFLT_VAL_NX10_xpu_hold_pc_hold 0x00000001U

enum {
	BFW_NX10_xpu_hold_pc_hold      = 1,  /* [0] */
	BFW_NX10_xpu_hold_pc_reserved1 = 31  /* [31:1] */
};

typedef struct NX10_XPU_HOLD_PC_BIT_Ttag {
	unsigned int hold      : BFW_NX10_xpu_hold_pc_hold;      /* 0: start XPU, 1: hold XPU */
	unsigned int reserved1 : BFW_NX10_xpu_hold_pc_reserved1; /* reserved                  */
} NX10_XPU_HOLD_PC_BIT_T;

typedef union {
	unsigned int           val;
	NX10_XPU_HOLD_PC_BIT_T bf;
} NX10_XPU_HOLD_PC_T;

/* --------------------------------------------------------------------- */
/* Register pram_start */
/* =>  */
/* => Mode:  */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX10_pram_start   0x00004000U
#define Adr_NX10_xpec0_pram_start 0x10184000U
#define Adr_NX10_pram_start       0x10184000U

/* --------------------------------------------------------------------- */
/* Register dram_start */
/* =>  */
/* => Mode:  */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX10_dram_start   0x00006000U
#define Adr_NX10_xpec0_dram_start 0x10186000U
#define Adr_NX10_dram_start       0x10186000U


/* ===================================================================== */

/* Area of xpic */

/* ===================================================================== */

#define Addr_NX10_xpic 0x10188000U

/* --------------------------------------------------------------------- */
/* Register xpic_r0 */
/* => xPIC work register for indirect addressing */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX10_xpic_r0  0x00000000U
#define Adr_NX10_xpic_xpic_r0 0x10188000U
#define Adr_NX10_xpic_r0      0x10188000U
#define DFLT_VAL_NX10_xpic_r0 0x00000000U

#define MSK_NX10_xpic_r0_r0      0xffffffffU
#define SRT_NX10_xpic_r0_r0      0
#define DFLT_VAL_NX10_xpic_r0_r0 0x00000000U

enum {
	BFW_NX10_xpic_r0_r0 = 32  /* [31:0] */
};

typedef struct NX10_XPIC_R0_BIT_Ttag {
	unsigned int r0 : BFW_NX10_xpic_r0_r0; /* Work Register 0 */
} NX10_XPIC_R0_BIT_T;

typedef union {
	unsigned int       val;
	NX10_XPIC_R0_BIT_T bf;
} NX10_XPIC_R0_T;

/* --------------------------------------------------------------------- */
/* Register xpic_r1 */
/* => xPIC work register for indirect addressing */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX10_xpic_r1  0x00000004U
#define Adr_NX10_xpic_xpic_r1 0x10188004U
#define Adr_NX10_xpic_r1      0x10188004U
#define DFLT_VAL_NX10_xpic_r1 0x00000000U

#define MSK_NX10_xpic_r1_r1      0xffffffffU
#define SRT_NX10_xpic_r1_r1      0
#define DFLT_VAL_NX10_xpic_r1_r1 0x00000000U

enum {
	BFW_NX10_xpic_r1_r1 = 32  /* [31:0] */
};

typedef struct NX10_XPIC_R1_BIT_Ttag {
	unsigned int r1 : BFW_NX10_xpic_r1_r1; /* Work Register 1 */
} NX10_XPIC_R1_BIT_T;

typedef union {
	unsigned int       val;
	NX10_XPIC_R1_BIT_T bf;
} NX10_XPIC_R1_T;

/* --------------------------------------------------------------------- */
/* Register xpic_r2 */
/* => xPIC work register for indirect addressing */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX10_xpic_r2  0x00000008U
#define Adr_NX10_xpic_xpic_r2 0x10188008U
#define Adr_NX10_xpic_r2      0x10188008U
#define DFLT_VAL_NX10_xpic_r2 0x00000000U

#define MSK_NX10_xpic_r2_r2      0xffffffffU
#define SRT_NX10_xpic_r2_r2      0
#define DFLT_VAL_NX10_xpic_r2_r2 0x00000000U

enum {
	BFW_NX10_xpic_r2_r2 = 32  /* [31:0] */
};

typedef struct NX10_XPIC_R2_BIT_Ttag {
	unsigned int r2 : BFW_NX10_xpic_r2_r2; /* Work Register 2 */
} NX10_XPIC_R2_BIT_T;

typedef union {
	unsigned int       val;
	NX10_XPIC_R2_BIT_T bf;
} NX10_XPIC_R2_T;

/* --------------------------------------------------------------------- */
/* Register xpic_r3 */
/* => xPIC work register for indirect addressing */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX10_xpic_r3  0x0000000CU
#define Adr_NX10_xpic_xpic_r3 0x1018800CU
#define Adr_NX10_xpic_r3      0x1018800CU
#define DFLT_VAL_NX10_xpic_r3 0x00000000U

#define MSK_NX10_xpic_r3_r3      0xffffffffU
#define SRT_NX10_xpic_r3_r3      0
#define DFLT_VAL_NX10_xpic_r3_r3 0x00000000U

enum {
	BFW_NX10_xpic_r3_r3 = 32  /* [31:0] */
};

typedef struct NX10_XPIC_R3_BIT_Ttag {
	unsigned int r3 : BFW_NX10_xpic_r3_r3; /* Work Register 3 */
} NX10_XPIC_R3_BIT_T;

typedef union {
	unsigned int       val;
	NX10_XPIC_R3_BIT_T bf;
} NX10_XPIC_R3_T;

/* --------------------------------------------------------------------- */
/* Register xpic_r4 */
/* => xPIC work register for indirect addressing */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX10_xpic_r4  0x00000010U
#define Adr_NX10_xpic_xpic_r4 0x10188010U
#define Adr_NX10_xpic_r4      0x10188010U
#define DFLT_VAL_NX10_xpic_r4 0x00000000U

#define MSK_NX10_xpic_r4_r4      0xffffffffU
#define SRT_NX10_xpic_r4_r4      0
#define DFLT_VAL_NX10_xpic_r4_r4 0x00000000U

enum {
	BFW_NX10_xpic_r4_r4 = 32  /* [31:0] */
};

typedef struct NX10_XPIC_R4_BIT_Ttag {
	unsigned int r4 : BFW_NX10_xpic_r4_r4; /* Work Register 4 */
} NX10_XPIC_R4_BIT_T;

typedef union {
	unsigned int       val;
	NX10_XPIC_R4_BIT_T bf;
} NX10_XPIC_R4_T;

/* --------------------------------------------------------------------- */
/* Register xpic_r5 */
/* => xPIC work register for indirect addressing */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX10_xpic_r5  0x00000014U
#define Adr_NX10_xpic_xpic_r5 0x10188014U
#define Adr_NX10_xpic_r5      0x10188014U
#define DFLT_VAL_NX10_xpic_r5 0x00000000U

#define MSK_NX10_xpic_r5_r5      0xffffffffU
#define SRT_NX10_xpic_r5_r5      0
#define DFLT_VAL_NX10_xpic_r5_r5 0x00000000U

enum {
	BFW_NX10_xpic_r5_r5 = 32  /* [31:0] */
};

typedef struct NX10_XPIC_R5_BIT_Ttag {
	unsigned int r5 : BFW_NX10_xpic_r5_r5; /* Work Register 5 */
} NX10_XPIC_R5_BIT_T;

typedef union {
	unsigned int       val;
	NX10_XPIC_R5_BIT_T bf;
} NX10_XPIC_R5_T;

/* --------------------------------------------------------------------- */
/* Register xpic_r6 */
/* => xPIC work register for indirect addressing */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX10_xpic_r6  0x00000018U
#define Adr_NX10_xpic_xpic_r6 0x10188018U
#define Adr_NX10_xpic_r6      0x10188018U
#define DFLT_VAL_NX10_xpic_r6 0x00000000U

#define MSK_NX10_xpic_r6_r6      0xffffffffU
#define SRT_NX10_xpic_r6_r6      0
#define DFLT_VAL_NX10_xpic_r6_r6 0x00000000U

enum {
	BFW_NX10_xpic_r6_r6 = 32  /* [31:0] */
};

typedef struct NX10_XPIC_R6_BIT_Ttag {
	unsigned int r6 : BFW_NX10_xpic_r6_r6; /* Work Register 6 */
} NX10_XPIC_R6_BIT_T;

typedef union {
	unsigned int       val;
	NX10_XPIC_R6_BIT_T bf;
} NX10_XPIC_R6_T;

/* --------------------------------------------------------------------- */
/* Register xpic_r7 */
/* => xPIC work register for indirect addressing */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX10_xpic_r7  0x0000001CU
#define Adr_NX10_xpic_xpic_r7 0x1018801CU
#define Adr_NX10_xpic_r7      0x1018801CU
#define DFLT_VAL_NX10_xpic_r7 0x00000000U

#define MSK_NX10_xpic_r7_r7      0xffffffffU
#define SRT_NX10_xpic_r7_r7      0
#define DFLT_VAL_NX10_xpic_r7_r7 0x00000000U

enum {
	BFW_NX10_xpic_r7_r7 = 32  /* [31:0] */
};

typedef struct NX10_XPIC_R7_BIT_Ttag {
	unsigned int r7 : BFW_NX10_xpic_r7_r7; /* Work Register 7 */
} NX10_XPIC_R7_BIT_T;

typedef union {
	unsigned int       val;
	NX10_XPIC_R7_BIT_T bf;
} NX10_XPIC_R7_T;

/* --------------------------------------------------------------------- */
/* Register xpic_usr0 */
/* => xPIC user Register additional work register */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX10_xpic_usr0  0x00000020U
#define Adr_NX10_xpic_xpic_usr0 0x10188020U
#define Adr_NX10_xpic_usr0      0x10188020U
#define DFLT_VAL_NX10_xpic_usr0 0x00000000U

#define MSK_NX10_xpic_usr0_usr0      0xffffffffU
#define SRT_NX10_xpic_usr0_usr0      0
#define DFLT_VAL_NX10_xpic_usr0_usr0 0x00000000U

enum {
	BFW_NX10_xpic_usr0_usr0 = 32  /* [31:0] */
};

typedef struct NX10_XPIC_USR0_BIT_Ttag {
	unsigned int usr0 : BFW_NX10_xpic_usr0_usr0; /* User Register 0 */
} NX10_XPIC_USR0_BIT_T;

typedef union {
	unsigned int         val;
	NX10_XPIC_USR0_BIT_T bf;
} NX10_XPIC_USR0_T;

/* --------------------------------------------------------------------- */
/* Register xpic_usr1 */
/* => xPIC user Register additional work register */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX10_xpic_usr1  0x00000024U
#define Adr_NX10_xpic_xpic_usr1 0x10188024U
#define Adr_NX10_xpic_usr1      0x10188024U
#define DFLT_VAL_NX10_xpic_usr1 0x00000000U

#define MSK_NX10_xpic_usr1_usr1      0xffffffffU
#define SRT_NX10_xpic_usr1_usr1      0
#define DFLT_VAL_NX10_xpic_usr1_usr1 0x00000000U

enum {
	BFW_NX10_xpic_usr1_usr1 = 32  /* [31:0] */
};

typedef struct NX10_XPIC_USR1_BIT_Ttag {
	unsigned int usr1 : BFW_NX10_xpic_usr1_usr1; /* User Register 1 */
} NX10_XPIC_USR1_BIT_T;

typedef union {
	unsigned int         val;
	NX10_XPIC_USR1_BIT_T bf;
} NX10_XPIC_USR1_T;

/* --------------------------------------------------------------------- */
/* Register xpic_usr2 */
/* => xPIC user Register additional work register */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX10_xpic_usr2  0x00000028U
#define Adr_NX10_xpic_xpic_usr2 0x10188028U
#define Adr_NX10_xpic_usr2      0x10188028U
#define DFLT_VAL_NX10_xpic_usr2 0x00000000U

#define MSK_NX10_xpic_usr2_usr2      0xffffffffU
#define SRT_NX10_xpic_usr2_usr2      0
#define DFLT_VAL_NX10_xpic_usr2_usr2 0x00000000U

enum {
	BFW_NX10_xpic_usr2_usr2 = 32  /* [31:0] */
};

typedef struct NX10_XPIC_USR2_BIT_Ttag {
	unsigned int usr2 : BFW_NX10_xpic_usr2_usr2; /* User Register 2 */
} NX10_XPIC_USR2_BIT_T;

typedef union {
	unsigned int         val;
	NX10_XPIC_USR2_BIT_T bf;
} NX10_XPIC_USR2_T;

/* --------------------------------------------------------------------- */
/* Register xpic_usr3 */
/* => xPIC user Register additional work register */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX10_xpic_usr3  0x0000002CU
#define Adr_NX10_xpic_xpic_usr3 0x1018802CU
#define Adr_NX10_xpic_usr3      0x1018802CU
#define DFLT_VAL_NX10_xpic_usr3 0x00000000U

#define MSK_NX10_xpic_usr3_usr3      0xffffffffU
#define SRT_NX10_xpic_usr3_usr3      0
#define DFLT_VAL_NX10_xpic_usr3_usr3 0x00000000U

enum {
	BFW_NX10_xpic_usr3_usr3 = 32  /* [31:0] */
};

typedef struct NX10_XPIC_USR3_BIT_Ttag {
	unsigned int usr3 : BFW_NX10_xpic_usr3_usr3; /* User Register 3 */
} NX10_XPIC_USR3_BIT_T;

typedef union {
	unsigned int         val;
	NX10_XPIC_USR3_BIT_T bf;
} NX10_XPIC_USR3_T;

/* --------------------------------------------------------------------- */
/* Register xpic_usr4 */
/* => xPIC user Register additional work register */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX10_xpic_usr4  0x00000030U
#define Adr_NX10_xpic_xpic_usr4 0x10188030U
#define Adr_NX10_xpic_usr4      0x10188030U
#define DFLT_VAL_NX10_xpic_usr4 0x00000000U

#define MSK_NX10_xpic_usr4_usr4      0xffffffffU
#define SRT_NX10_xpic_usr4_usr4      0
#define DFLT_VAL_NX10_xpic_usr4_usr4 0x00000000U

enum {
	BFW_NX10_xpic_usr4_usr4 = 32  /* [31:0] */
};

typedef struct NX10_XPIC_USR4_BIT_Ttag {
	unsigned int usr4 : BFW_NX10_xpic_usr4_usr4; /* User Register 4 */
} NX10_XPIC_USR4_BIT_T;

typedef union {
	unsigned int         val;
	NX10_XPIC_USR4_BIT_T bf;
} NX10_XPIC_USR4_T;

/* --------------------------------------------------------------------- */
/* Register xpic_pc */
/* => xPIC Program Counter */
/*    Shared in xPIC 64_BIT_MUL_TARGET mode with usr32 (w mode) */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX10_xpic_pc  0x00000034U
#define Adr_NX10_xpic_xpic_pc 0x10188034U
#define Adr_NX10_xpic_pc      0x10188034U
#define DFLT_VAL_NX10_xpic_pc 0xfffffffcU

#define MSK_NX10_xpic_pc_pc      0x000007ffU
#define SRT_NX10_xpic_pc_pc      0
#define DFLT_VAL_NX10_xpic_pc_pc 0xfffffffcU

enum {
	BFW_NX10_xpic_pc_pc        = 11, /* [10:0] */
	BFW_NX10_xpic_pc_reserved1 = 21  /* [31:11] */
};

typedef struct NX10_XPIC_PC_BIT_Ttag {
	unsigned int pc        : BFW_NX10_xpic_pc_pc;        /* Program Counter (dword address inside DPRAM) */
	unsigned int reserved1 : BFW_NX10_xpic_pc_reserved1; /* reserved                                     */
} NX10_XPIC_PC_BIT_T;

typedef union {
	unsigned int       val;
	NX10_XPIC_PC_BIT_T bf;
} NX10_XPIC_PC_T;

/* --------------------------------------------------------------------- */
/* Register xpic_stat */
/* => Processor Status Register */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX10_xpic_stat  0x00000038U
#define Adr_NX10_xpic_xpic_stat 0x10188038U
#define Adr_NX10_xpic_stat      0x10188038U
#define DFLT_VAL_NX10_xpic_stat 0x00000000U

#define MSK_NX10_xpic_stat_stat      0xffffffffU
#define SRT_NX10_xpic_stat_stat      0
#define DFLT_VAL_NX10_xpic_stat_stat 0x00000000U

enum {
	BFW_NX10_xpic_stat_stat = 32  /* [31:0] */
};

typedef struct NX10_XPIC_STAT_BIT_Ttag {
	unsigned int stat : BFW_NX10_xpic_stat_stat; /*  */
} NX10_XPIC_STAT_BIT_T;

typedef union {
	unsigned int         val;
	NX10_XPIC_STAT_BIT_T bf;
} NX10_XPIC_STAT_T;

/* --------------------------------------------------------------------- */
/* Register xpic_zero */
/* => Zero Register */
/*    Shared in xPIC 64_BIT_MUL_TARGET mode with usr10 (w mode) */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX10_xpic_zero  0x0000003CU
#define Adr_NX10_xpic_xpic_zero 0x1018803CU
#define Adr_NX10_xpic_zero      0x1018803CU
#define DFLT_VAL_NX10_xpic_zero 0x00000000U

#define MSK_NX10_xpic_zero_zero      0xffffffffU
#define SRT_NX10_xpic_zero_zero      0
#define DFLT_VAL_NX10_xpic_zero_zero 0x00000000U

enum {
	BFW_NX10_xpic_zero_zero = 32  /* [31:0] */
};

typedef struct NX10_XPIC_ZERO_BIT_Ttag {
	unsigned int zero : BFW_NX10_xpic_zero_zero; /* Always Zero */
} NX10_XPIC_ZERO_BIT_T;

typedef union {
	unsigned int         val;
	NX10_XPIC_ZERO_BIT_T bf;
} NX10_XPIC_ZERO_T;

/* --------------------------------------------------------------------- */
/* Register xpic_pram_start */
/* =>  */
/* => Mode:  */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX10_xpic_pram_start  0x00004000U
#define Adr_NX10_xpic_xpic_pram_start 0x1018C000U
#define Adr_NX10_xpic_pram_start      0x1018C000U

/* --------------------------------------------------------------------- */
/* Register xpic_dram_start */
/* =>  */
/* => Mode:  */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX10_xpic_dram_start  0x00006000U
#define Adr_NX10_xpic_xpic_dram_start 0x1018E000U
#define Adr_NX10_xpic_dram_start      0x1018E000U


/* ===================================================================== */

/* Area of xpic_debug */

/* ===================================================================== */

#define Addr_NX10_xpic_debug 0x10188100U

/* --------------------------------------------------------------------- */
/* Register xpic_hold_pc */
/* =>  */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX10_xpic_hold_pc        0x00000000U
#define Adr_NX10_xpic_debug_xpic_hold_pc 0x10188100U
#define Adr_NX10_xpic_hold_pc            0x10188100U
#define DFLT_VAL_NX10_xpic_hold_pc       0x00000001U

#define MSK_NX10_xpic_hold_pc_hold                   0x00000001U
#define SRT_NX10_xpic_hold_pc_hold                   0
#define DFLT_VAL_NX10_xpic_hold_pc_hold              0x00000001U
#define MSK_NX10_xpic_hold_pc_single_step            0x00000002U
#define SRT_NX10_xpic_hold_pc_single_step            1
#define DFLT_VAL_NX10_xpic_hold_pc_single_step       0x00000000U
#define MSK_NX10_xpic_hold_pc_monitor_mode           0x00000004U
#define SRT_NX10_xpic_hold_pc_monitor_mode           2
#define DFLT_VAL_NX10_xpic_hold_pc_monitor_mode      0x00000000U
#define MSK_NX10_xpic_hold_pc_disable_int            0x00000008U
#define SRT_NX10_xpic_hold_pc_disable_int            3
#define DFLT_VAL_NX10_xpic_hold_pc_disable_int       0x00000000U
#define MSK_NX10_xpic_hold_pc_misalignment_hold      0x00000010U
#define SRT_NX10_xpic_hold_pc_misalignment_hold      4
#define DFLT_VAL_NX10_xpic_hold_pc_misalignment_hold 0x00000000U
#define MSK_NX10_xpic_hold_pc_bank_select            0x00000020U
#define SRT_NX10_xpic_hold_pc_bank_select            5
#define DFLT_VAL_NX10_xpic_hold_pc_bank_select       0x00000000U
#define MSK_NX10_xpic_hold_pc_bank_control           0x00000040U
#define SRT_NX10_xpic_hold_pc_bank_control           6
#define DFLT_VAL_NX10_xpic_hold_pc_bank_control      0x00000000U
#define MSK_NX10_xpic_hold_pc_reset_xpic             0x00000080U
#define SRT_NX10_xpic_hold_pc_reset_xpic             7
#define DFLT_VAL_NX10_xpic_hold_pc_reset_xpic        0x00000000U

enum {
	BFW_NX10_xpic_hold_pc_hold              = 1,  /* [0] */
	BFW_NX10_xpic_hold_pc_single_step       = 1,  /* [1] */
	BFW_NX10_xpic_hold_pc_monitor_mode      = 1,  /* [2] */
	BFW_NX10_xpic_hold_pc_disable_int       = 1,  /* [3] */
	BFW_NX10_xpic_hold_pc_misalignment_hold = 1,  /* [4] */
	BFW_NX10_xpic_hold_pc_bank_select       = 1,  /* [5] */
	BFW_NX10_xpic_hold_pc_bank_control      = 1,  /* [6] */
	BFW_NX10_xpic_hold_pc_reset_xpic        = 1,  /* [7] */
	BFW_NX10_xpic_hold_pc_reserved1         = 24  /* [31:8] */
};

typedef struct NX10_XPIC_HOLD_PC_BIT_Ttag {
	unsigned int hold              : BFW_NX10_xpic_hold_pc_hold;              /* 0- start xPIC, 1- hold xPIC                                                                  */
	unsigned int single_step       : BFW_NX10_xpic_hold_pc_single_step;       /* single_step mode                                                                             */
	unsigned int monitor_mode      : BFW_NX10_xpic_hold_pc_monitor_mode;      /* dont hold xPCI on break0 and break1, only monitor                                            */
	unsigned int disable_int       : BFW_NX10_xpic_hold_pc_disable_int;       /* disable interrupts                                                                           */
	unsigned int misalignment_hold : BFW_NX10_xpic_hold_pc_misalignment_hold; /* hold xPIC on misalignment                                                                    */
	unsigned int bank_select       : BFW_NX10_xpic_hold_pc_bank_select;       /* select register Bank 0 or 1 if bank_control=1 (r0-r7; stat)                                  */
	unsigned int bank_control      : BFW_NX10_xpic_hold_pc_bank_control;      /* control over the register bank selection                                                     */
	                                                                          /* WARNING: reset this BIT to 0 BEFORE start xPIC (clear hold bits)                             */
	unsigned int reset_xpic        : BFW_NX10_xpic_hold_pc_reset_xpic;        /* REQUEST reset all internal internal states and the pipeline                                  */
	                                                                          /* EXCEPT: the internal register (r0-r7, usr0-4), bank0 and bank1 reset this registers manually */
	unsigned int reserved1         : BFW_NX10_xpic_hold_pc_reserved1;         /* reserved                                                                                     */
} NX10_XPIC_HOLD_PC_BIT_T;

typedef union {
	unsigned int            val;
	NX10_XPIC_HOLD_PC_BIT_T bf;
} NX10_XPIC_HOLD_PC_T;

/* --------------------------------------------------------------------- */
/* Register xpic_break0_addr */
/* =>  */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX10_xpic_break0_addr        0x00000004U
#define Adr_NX10_xpic_debug_xpic_break0_addr 0x10188104U
#define Adr_NX10_xpic_break0_addr            0x10188104U
#define DFLT_VAL_NX10_xpic_break0_addr       0x00000000U

#define MSK_NX10_xpic_break0_addr_val      0xffffffffU
#define SRT_NX10_xpic_break0_addr_val      0
#define DFLT_VAL_NX10_xpic_break0_addr_val 0x00000000U

enum {
	BFW_NX10_xpic_break0_addr_val = 32  /* [31:0] */
};

typedef struct NX10_XPIC_BREAK0_ADDR_BIT_Ttag {
	unsigned int val : BFW_NX10_xpic_break0_addr_val; /* Breakpoint 0 address value */
} NX10_XPIC_BREAK0_ADDR_BIT_T;

typedef union {
	unsigned int                val;
	NX10_XPIC_BREAK0_ADDR_BIT_T bf;
} NX10_XPIC_BREAK0_ADDR_T;

/* --------------------------------------------------------------------- */
/* Register xpic_break0_addr_mask */
/* =>  */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX10_xpic_break0_addr_mask        0x00000008U
#define Adr_NX10_xpic_debug_xpic_break0_addr_mask 0x10188108U
#define Adr_NX10_xpic_break0_addr_mask            0x10188108U
#define DFLT_VAL_NX10_xpic_break0_addr_mask       0x00000000U

#define MSK_NX10_xpic_break0_addr_mask_val      0xffffffffU
#define SRT_NX10_xpic_break0_addr_mask_val      0
#define DFLT_VAL_NX10_xpic_break0_addr_mask_val 0x00000000U

enum {
	BFW_NX10_xpic_break0_addr_mask_val = 32  /* [31:0] */
};

typedef struct NX10_XPIC_BREAK0_ADDR_MASK_BIT_Ttag {
	unsigned int val : BFW_NX10_xpic_break0_addr_mask_val; /* Breakpoint 0 address mask */
} NX10_XPIC_BREAK0_ADDR_MASK_BIT_T;

typedef union {
	unsigned int                     val;
	NX10_XPIC_BREAK0_ADDR_MASK_BIT_T bf;
} NX10_XPIC_BREAK0_ADDR_MASK_T;

/* --------------------------------------------------------------------- */
/* Register xpic_break0_data */
/* =>  */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX10_xpic_break0_data        0x0000000CU
#define Adr_NX10_xpic_debug_xpic_break0_data 0x1018810CU
#define Adr_NX10_xpic_break0_data            0x1018810CU
#define DFLT_VAL_NX10_xpic_break0_data       0x00000000U

#define MSK_NX10_xpic_break0_data_val      0xffffffffU
#define SRT_NX10_xpic_break0_data_val      0
#define DFLT_VAL_NX10_xpic_break0_data_val 0x00000000U

enum {
	BFW_NX10_xpic_break0_data_val = 32  /* [31:0] */
};

typedef struct NX10_XPIC_BREAK0_DATA_BIT_Ttag {
	unsigned int val : BFW_NX10_xpic_break0_data_val; /* Breakpoint 0 data value   (for data access only) */
} NX10_XPIC_BREAK0_DATA_BIT_T;

typedef union {
	unsigned int                val;
	NX10_XPIC_BREAK0_DATA_BIT_T bf;
} NX10_XPIC_BREAK0_DATA_T;

/* --------------------------------------------------------------------- */
/* Register xpic_break0_data_mask */
/* =>  */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX10_xpic_break0_data_mask        0x00000010U
#define Adr_NX10_xpic_debug_xpic_break0_data_mask 0x10188110U
#define Adr_NX10_xpic_break0_data_mask            0x10188110U
#define DFLT_VAL_NX10_xpic_break0_data_mask       0x00000000U

#define MSK_NX10_xpic_break0_data_mask_val      0xffffffffU
#define SRT_NX10_xpic_break0_data_mask_val      0
#define DFLT_VAL_NX10_xpic_break0_data_mask_val 0x00000000U

enum {
	BFW_NX10_xpic_break0_data_mask_val = 32  /* [31:0] */
};

typedef struct NX10_XPIC_BREAK0_DATA_MASK_BIT_Ttag {
	unsigned int val : BFW_NX10_xpic_break0_data_mask_val; /* Breakpoint 0 data mask    (for data access only) */
} NX10_XPIC_BREAK0_DATA_MASK_BIT_T;

typedef union {
	unsigned int                     val;
	NX10_XPIC_BREAK0_DATA_MASK_BIT_T bf;
} NX10_XPIC_BREAK0_DATA_MASK_T;

/* --------------------------------------------------------------------- */
/* Register xpic_break0_contr */
/* =>  */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX10_xpic_break0_contr        0x00000014U
#define Adr_NX10_xpic_debug_xpic_break0_contr 0x10188114U
#define Adr_NX10_xpic_break0_contr            0x10188114U
#define DFLT_VAL_NX10_xpic_break0_contr       0x00000000U

#define MSK_NX10_xpic_break0_contr_write            0x00000001U
#define SRT_NX10_xpic_break0_contr_write            0
#define DFLT_VAL_NX10_xpic_break0_contr_write       0x00000000U
#define MSK_NX10_xpic_break0_contr_mas              0x00000006U
#define SRT_NX10_xpic_break0_contr_mas              1
#define DFLT_VAL_NX10_xpic_break0_contr_mas         0x00000000U
#define MSK_NX10_xpic_break0_contr_data_access      0x00000008U
#define SRT_NX10_xpic_break0_contr_data_access      3
#define DFLT_VAL_NX10_xpic_break0_contr_data_access 0x00000000U
#define MSK_NX10_xpic_break0_contr_fiq_mode         0x00000010U
#define SRT_NX10_xpic_break0_contr_fiq_mode         4
#define DFLT_VAL_NX10_xpic_break0_contr_fiq_mode    0x00000000U
#define MSK_NX10_xpic_break0_contr_irq_mode         0x00000020U
#define SRT_NX10_xpic_break0_contr_irq_mode         5
#define DFLT_VAL_NX10_xpic_break0_contr_irq_mode    0x00000000U
#define MSK_NX10_xpic_break0_contr_chain            0x00000040U
#define SRT_NX10_xpic_break0_contr_chain            6
#define DFLT_VAL_NX10_xpic_break0_contr_chain       0x00000000U
#define MSK_NX10_xpic_break0_contr_range            0x00000080U
#define SRT_NX10_xpic_break0_contr_range            7
#define DFLT_VAL_NX10_xpic_break0_contr_range       0x00000000U
#define MSK_NX10_xpic_break0_contr_enable           0x00000100U
#define SRT_NX10_xpic_break0_contr_enable           8
#define DFLT_VAL_NX10_xpic_break0_contr_enable      0x00000000U

enum {
	BFW_NX10_xpic_break0_contr_write       = 1,  /* [0] */
	BFW_NX10_xpic_break0_contr_mas         = 2,  /* [2:1] */
	BFW_NX10_xpic_break0_contr_data_access = 1,  /* [3] */
	BFW_NX10_xpic_break0_contr_fiq_mode    = 1,  /* [4] */
	BFW_NX10_xpic_break0_contr_irq_mode    = 1,  /* [5] */
	BFW_NX10_xpic_break0_contr_chain       = 1,  /* [6] */
	BFW_NX10_xpic_break0_contr_range       = 1,  /* [7] */
	BFW_NX10_xpic_break0_contr_enable      = 1,  /* [8] */
	BFW_NX10_xpic_break0_contr_reserved1   = 23  /* [31:9] */
};

typedef struct NX10_XPIC_BREAK0_CONTR_BIT_Ttag {
	unsigned int write       : BFW_NX10_xpic_break0_contr_write;       /* Breakpoint 0  write/read access                                              */
	unsigned int mas         : BFW_NX10_xpic_break0_contr_mas;         /* Breakpoint 0  memory access size (00: byte. 01: word, 10 dword, 11 reserved) */
	unsigned int data_access : BFW_NX10_xpic_break0_contr_data_access; /* Breakpoint 0  (1: data access, 0: instruction fetch)                         */
	unsigned int fiq_mode    : BFW_NX10_xpic_break0_contr_fiq_mode;    /* Breakpoint 0  xPIC in FIQ Mode                                               */
	unsigned int irq_mode    : BFW_NX10_xpic_break0_contr_irq_mode;    /* Breakpoint 0  xPIC in IRQ Mode                                               */
	unsigned int chain       : BFW_NX10_xpic_break0_contr_chain;       /* Breakpoint 0 input from Breakpoint 1                                         */
	unsigned int range       : BFW_NX10_xpic_break0_contr_range;       /* Breakpoint 0 input from Breakpoint 1                                         */
	unsigned int enable      : BFW_NX10_xpic_break0_contr_enable;      /* Breakpoint 0                                                                 */
	unsigned int reserved1   : BFW_NX10_xpic_break0_contr_reserved1;   /* reserved                                                                     */
} NX10_XPIC_BREAK0_CONTR_BIT_T;

typedef union {
	unsigned int                 val;
	NX10_XPIC_BREAK0_CONTR_BIT_T bf;
} NX10_XPIC_BREAK0_CONTR_T;

/* --------------------------------------------------------------------- */
/* Register xpic_break0_contr_mask */
/* =>  */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX10_xpic_break0_contr_mask        0x00000018U
#define Adr_NX10_xpic_debug_xpic_break0_contr_mask 0x10188118U
#define Adr_NX10_xpic_break0_contr_mask            0x10188118U
#define DFLT_VAL_NX10_xpic_break0_contr_mask       0x00000000U

#define MSK_NX10_xpic_break0_contr_mask_val      0x000000ffU
#define SRT_NX10_xpic_break0_contr_mask_val      0
#define DFLT_VAL_NX10_xpic_break0_contr_mask_val 0x00000000U

enum {
	BFW_NX10_xpic_break0_contr_mask_val       = 8,  /* [7:0] */
	BFW_NX10_xpic_break0_contr_mask_reserved1 = 24  /* [31:8] */
};

typedef struct NX10_XPIC_BREAK0_CONTR_MASK_BIT_Ttag {
	unsigned int val       : BFW_NX10_xpic_break0_contr_mask_val;       /* Breakpoint 0 control mask */
	unsigned int reserved1 : BFW_NX10_xpic_break0_contr_mask_reserved1; /* reserved                  */
} NX10_XPIC_BREAK0_CONTR_MASK_BIT_T;

typedef union {
	unsigned int                      val;
	NX10_XPIC_BREAK0_CONTR_MASK_BIT_T bf;
} NX10_XPIC_BREAK0_CONTR_MASK_T;

/* --------------------------------------------------------------------- */
/* Register xpic_break1_addr */
/* =>  */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX10_xpic_break1_addr        0x0000001CU
#define Adr_NX10_xpic_debug_xpic_break1_addr 0x1018811CU
#define Adr_NX10_xpic_break1_addr            0x1018811CU
#define DFLT_VAL_NX10_xpic_break1_addr       0x00000000U

#define MSK_NX10_xpic_break1_addr_val      0xffffffffU
#define SRT_NX10_xpic_break1_addr_val      0
#define DFLT_VAL_NX10_xpic_break1_addr_val 0x00000000U

enum {
	BFW_NX10_xpic_break1_addr_val = 32  /* [31:0] */
};

typedef struct NX10_XPIC_BREAK1_ADDR_BIT_Ttag {
	unsigned int val : BFW_NX10_xpic_break1_addr_val; /* Breakpoint 1 address value */
} NX10_XPIC_BREAK1_ADDR_BIT_T;

typedef union {
	unsigned int                val;
	NX10_XPIC_BREAK1_ADDR_BIT_T bf;
} NX10_XPIC_BREAK1_ADDR_T;

/* --------------------------------------------------------------------- */
/* Register xpic_break1_addr_mask */
/* =>  */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX10_xpic_break1_addr_mask        0x00000020U
#define Adr_NX10_xpic_debug_xpic_break1_addr_mask 0x10188120U
#define Adr_NX10_xpic_break1_addr_mask            0x10188120U
#define DFLT_VAL_NX10_xpic_break1_addr_mask       0x00000000U

#define MSK_NX10_xpic_break1_addr_mask_val      0xffffffffU
#define SRT_NX10_xpic_break1_addr_mask_val      0
#define DFLT_VAL_NX10_xpic_break1_addr_mask_val 0x00000000U

enum {
	BFW_NX10_xpic_break1_addr_mask_val = 32  /* [31:0] */
};

typedef struct NX10_XPIC_BREAK1_ADDR_MASK_BIT_Ttag {
	unsigned int val : BFW_NX10_xpic_break1_addr_mask_val; /* Breakpoint 1 address mask */
} NX10_XPIC_BREAK1_ADDR_MASK_BIT_T;

typedef union {
	unsigned int                     val;
	NX10_XPIC_BREAK1_ADDR_MASK_BIT_T bf;
} NX10_XPIC_BREAK1_ADDR_MASK_T;

/* --------------------------------------------------------------------- */
/* Register xpic_break1_data */
/* =>  */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX10_xpic_break1_data        0x00000024U
#define Adr_NX10_xpic_debug_xpic_break1_data 0x10188124U
#define Adr_NX10_xpic_break1_data            0x10188124U
#define DFLT_VAL_NX10_xpic_break1_data       0x00000000U

#define MSK_NX10_xpic_break1_data_val      0xffffffffU
#define SRT_NX10_xpic_break1_data_val      0
#define DFLT_VAL_NX10_xpic_break1_data_val 0x00000000U

enum {
	BFW_NX10_xpic_break1_data_val = 32  /* [31:0] */
};

typedef struct NX10_XPIC_BREAK1_DATA_BIT_Ttag {
	unsigned int val : BFW_NX10_xpic_break1_data_val; /* Breakpoint 1 data value   (for data access only) */
} NX10_XPIC_BREAK1_DATA_BIT_T;

typedef union {
	unsigned int                val;
	NX10_XPIC_BREAK1_DATA_BIT_T bf;
} NX10_XPIC_BREAK1_DATA_T;

/* --------------------------------------------------------------------- */
/* Register xpic_break1_data_mask */
/* =>  */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX10_xpic_break1_data_mask        0x00000028U
#define Adr_NX10_xpic_debug_xpic_break1_data_mask 0x10188128U
#define Adr_NX10_xpic_break1_data_mask            0x10188128U
#define DFLT_VAL_NX10_xpic_break1_data_mask       0x00000000U

#define MSK_NX10_xpic_break1_data_mask_val      0xffffffffU
#define SRT_NX10_xpic_break1_data_mask_val      0
#define DFLT_VAL_NX10_xpic_break1_data_mask_val 0x00000000U

enum {
	BFW_NX10_xpic_break1_data_mask_val = 32  /* [31:0] */
};

typedef struct NX10_XPIC_BREAK1_DATA_MASK_BIT_Ttag {
	unsigned int val : BFW_NX10_xpic_break1_data_mask_val; /* Breakpoint 1 data mask   (for data access only) */
} NX10_XPIC_BREAK1_DATA_MASK_BIT_T;

typedef union {
	unsigned int                     val;
	NX10_XPIC_BREAK1_DATA_MASK_BIT_T bf;
} NX10_XPIC_BREAK1_DATA_MASK_T;

/* --------------------------------------------------------------------- */
/* Register xpic_break1_contr */
/* =>  */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX10_xpic_break1_contr        0x0000002CU
#define Adr_NX10_xpic_debug_xpic_break1_contr 0x1018812CU
#define Adr_NX10_xpic_break1_contr            0x1018812CU
#define DFLT_VAL_NX10_xpic_break1_contr       0x00000000U

#define MSK_NX10_xpic_break1_contr_write            0x00000001U
#define SRT_NX10_xpic_break1_contr_write            0
#define DFLT_VAL_NX10_xpic_break1_contr_write       0x00000000U
#define MSK_NX10_xpic_break1_contr_mas              0x00000006U
#define SRT_NX10_xpic_break1_contr_mas              1
#define DFLT_VAL_NX10_xpic_break1_contr_mas         0x00000000U
#define MSK_NX10_xpic_break1_contr_data_access      0x00000008U
#define SRT_NX10_xpic_break1_contr_data_access      3
#define DFLT_VAL_NX10_xpic_break1_contr_data_access 0x00000000U
#define MSK_NX10_xpic_break1_contr_fiq_mode         0x00000010U
#define SRT_NX10_xpic_break1_contr_fiq_mode         4
#define DFLT_VAL_NX10_xpic_break1_contr_fiq_mode    0x00000000U
#define MSK_NX10_xpic_break1_contr_irq_mode         0x00000020U
#define SRT_NX10_xpic_break1_contr_irq_mode         5
#define DFLT_VAL_NX10_xpic_break1_contr_irq_mode    0x00000000U
#define MSK_NX10_xpic_break1_contr_chain            0x00000040U
#define SRT_NX10_xpic_break1_contr_chain            6
#define DFLT_VAL_NX10_xpic_break1_contr_chain       0x00000000U
#define MSK_NX10_xpic_break1_contr_range            0x00000080U
#define SRT_NX10_xpic_break1_contr_range            7
#define DFLT_VAL_NX10_xpic_break1_contr_range       0x00000000U
#define MSK_NX10_xpic_break1_contr_enable           0x00000100U
#define SRT_NX10_xpic_break1_contr_enable           8
#define DFLT_VAL_NX10_xpic_break1_contr_enable      0x00000000U

enum {
	BFW_NX10_xpic_break1_contr_write       = 1,  /* [0] */
	BFW_NX10_xpic_break1_contr_mas         = 2,  /* [2:1] */
	BFW_NX10_xpic_break1_contr_data_access = 1,  /* [3] */
	BFW_NX10_xpic_break1_contr_fiq_mode    = 1,  /* [4] */
	BFW_NX10_xpic_break1_contr_irq_mode    = 1,  /* [5] */
	BFW_NX10_xpic_break1_contr_chain       = 1,  /* [6] */
	BFW_NX10_xpic_break1_contr_range       = 1,  /* [7] */
	BFW_NX10_xpic_break1_contr_enable      = 1,  /* [8] */
	BFW_NX10_xpic_break1_contr_reserved1   = 23  /* [31:9] */
};

typedef struct NX10_XPIC_BREAK1_CONTR_BIT_Ttag {
	unsigned int write       : BFW_NX10_xpic_break1_contr_write;       /* Breakpoint 1  write/read access                                              */
	unsigned int mas         : BFW_NX10_xpic_break1_contr_mas;         /* Breakpoint 1  memory access size (00: byte. 01: word, 10 dword, 11 reserved) */
	unsigned int data_access : BFW_NX10_xpic_break1_contr_data_access; /* Breakpoint 1  (1: data access, 0: instruction fetch)                         */
	unsigned int fiq_mode    : BFW_NX10_xpic_break1_contr_fiq_mode;    /* Breakpoint 1  xPIC in FIQ Mode                                               */
	unsigned int irq_mode    : BFW_NX10_xpic_break1_contr_irq_mode;    /* Breakpoint 1  xPIC in IRQ Mode                                               */
	unsigned int chain       : BFW_NX10_xpic_break1_contr_chain;       /* reserved                                                                     */
	unsigned int range       : BFW_NX10_xpic_break1_contr_range;       /* reserved                                                                     */
	unsigned int enable      : BFW_NX10_xpic_break1_contr_enable;      /* Breakpoint 1                                                                 */
	unsigned int reserved1   : BFW_NX10_xpic_break1_contr_reserved1;   /* reserved                                                                     */
} NX10_XPIC_BREAK1_CONTR_BIT_T;

typedef union {
	unsigned int                 val;
	NX10_XPIC_BREAK1_CONTR_BIT_T bf;
} NX10_XPIC_BREAK1_CONTR_T;

/* --------------------------------------------------------------------- */
/* Register xpic_break1_contr_mask */
/* =>  */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX10_xpic_break1_contr_mask        0x00000030U
#define Adr_NX10_xpic_debug_xpic_break1_contr_mask 0x10188130U
#define Adr_NX10_xpic_break1_contr_mask            0x10188130U
#define DFLT_VAL_NX10_xpic_break1_contr_mask       0x00000000U

#define MSK_NX10_xpic_break1_contr_mask_val      0x000000ffU
#define SRT_NX10_xpic_break1_contr_mask_val      0
#define DFLT_VAL_NX10_xpic_break1_contr_mask_val 0x00000000U

enum {
	BFW_NX10_xpic_break1_contr_mask_val       = 8,  /* [7:0] */
	BFW_NX10_xpic_break1_contr_mask_reserved1 = 24  /* [31:8] */
};

typedef struct NX10_XPIC_BREAK1_CONTR_MASK_BIT_Ttag {
	unsigned int val       : BFW_NX10_xpic_break1_contr_mask_val;       /* Breakpoint 1 control mask */
	unsigned int reserved1 : BFW_NX10_xpic_break1_contr_mask_reserved1; /* reserved                  */
} NX10_XPIC_BREAK1_CONTR_MASK_BIT_T;

typedef union {
	unsigned int                      val;
	NX10_XPIC_BREAK1_CONTR_MASK_BIT_T bf;
} NX10_XPIC_BREAK1_CONTR_MASK_T;

/* --------------------------------------------------------------------- */
/* Register xpic_break_last_pc */
/* =>  */
/* => Mode: R */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX10_xpic_break_last_pc        0x00000034U
#define Adr_NX10_xpic_debug_xpic_break_last_pc 0x10188134U
#define Adr_NX10_xpic_break_last_pc            0x10188134U

#define MSK_NX10_xpic_break_last_pc_val 0xffffffffU
#define SRT_NX10_xpic_break_last_pc_val 0

enum {
	BFW_NX10_xpic_break_last_pc_val = 32  /* [31:0] */
};

typedef struct NX10_XPIC_BREAK_LAST_PC_BIT_Ttag {
	unsigned int val : BFW_NX10_xpic_break_last_pc_val; /* last PC */
} NX10_XPIC_BREAK_LAST_PC_BIT_T;

typedef union {
	unsigned int                  val;
	NX10_XPIC_BREAK_LAST_PC_BIT_T bf;
} NX10_XPIC_BREAK_LAST_PC_T;

/* --------------------------------------------------------------------- */
/* Register xpic_break_status */
/* => Read access shows the reason why xPIC is in HOLD / BREAK */
/* => Mode: R */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX10_xpic_break_status        0x00000038U
#define Adr_NX10_xpic_debug_xpic_break_status 0x10188138U
#define Adr_NX10_xpic_break_status            0x10188138U

#define MSK_NX10_xpic_break_status_xpic_in_hold      0x00000001U
#define SRT_NX10_xpic_break_status_xpic_in_hold      0
#define MSK_NX10_xpic_break_status_hold              0x00000002U
#define SRT_NX10_xpic_break_status_hold              1
#define MSK_NX10_xpic_break_status_break0            0x00000004U
#define SRT_NX10_xpic_break_status_break0            2
#define MSK_NX10_xpic_break_status_break1            0x00000008U
#define SRT_NX10_xpic_break_status_break1            3
#define MSK_NX10_xpic_break_status_soft_break        0x00000010U
#define SRT_NX10_xpic_break_status_soft_break        4
#define MSK_NX10_xpic_break_status_single_step       0x00000020U
#define SRT_NX10_xpic_break_status_single_step       5
#define MSK_NX10_xpic_break_status_data_misalignment 0x00000040U
#define SRT_NX10_xpic_break_status_data_misalignment 6
#define MSK_NX10_xpic_break_status_break0_read_data  0x00000080U
#define SRT_NX10_xpic_break_status_break0_read_data  7
#define MSK_NX10_xpic_break_status_break1_read_data  0x00000100U
#define SRT_NX10_xpic_break_status_break1_read_data  8
#define MSK_NX10_xpic_break_status_xpic_reset_status 0x00000200U
#define SRT_NX10_xpic_break_status_xpic_reset_status 9

enum {
	BFW_NX10_xpic_break_status_xpic_in_hold      = 1,  /* [0] */
	BFW_NX10_xpic_break_status_hold              = 1,  /* [1] */
	BFW_NX10_xpic_break_status_break0            = 1,  /* [2] */
	BFW_NX10_xpic_break_status_break1            = 1,  /* [3] */
	BFW_NX10_xpic_break_status_soft_break        = 1,  /* [4] */
	BFW_NX10_xpic_break_status_single_step       = 1,  /* [5] */
	BFW_NX10_xpic_break_status_data_misalignment = 1,  /* [6] */
	BFW_NX10_xpic_break_status_break0_read_data  = 1,  /* [7] */
	BFW_NX10_xpic_break_status_break1_read_data  = 1,  /* [8] */
	BFW_NX10_xpic_break_status_xpic_reset_status = 1,  /* [9] */
	BFW_NX10_xpic_break_status_reserved1         = 22  /* [31:10] */
};

typedef struct NX10_XPIC_BREAK_STATUS_BIT_Ttag {
	unsigned int xpic_in_hold      : BFW_NX10_xpic_break_status_xpic_in_hold;      /* xPIC is in Break or Hold (read only)                           */
	unsigned int hold              : BFW_NX10_xpic_break_status_hold;              /* global HOLD BIT status 0- start xPIC, 1- hold xPIC (read only) */
	unsigned int break0            : BFW_NX10_xpic_break_status_break0;            /* Breakpoint 0 is active(read only)                              */
	unsigned int break1            : BFW_NX10_xpic_break_status_break1;            /* Breakpoint 1 is active(read only)                              */
	unsigned int soft_break        : BFW_NX10_xpic_break_status_soft_break;        /* Software Break is active(read only)                            */
	unsigned int single_step       : BFW_NX10_xpic_break_status_single_step;       /* Single Step Break is active(read only)                         */
	unsigned int data_misalignment : BFW_NX10_xpic_break_status_data_misalignment; /* Data Misaligment is active(read only)                          */
	unsigned int break0_read_data  : BFW_NX10_xpic_break_status_break0_read_data;  /* Breakpoint 0 last load access (read only)                      */
	unsigned int break1_read_data  : BFW_NX10_xpic_break_status_break1_read_data;  /* Breakpoint 1 last load access (read only)                      */
	unsigned int xpic_reset_status : BFW_NX10_xpic_break_status_xpic_reset_status; /* 1 = XPIC ist in Reset(read only)                               */
	unsigned int reserved1         : BFW_NX10_xpic_break_status_reserved1;         /* reserved                                                       */
} NX10_XPIC_BREAK_STATUS_BIT_T;

typedef union {
	unsigned int                 val;
	NX10_XPIC_BREAK_STATUS_BIT_T bf;
} NX10_XPIC_BREAK_STATUS_T;

/* --------------------------------------------------------------------- */
/* Register xpic_break_irq_raw */
/* => xPIC_DEBUG Raw IRQ register: */
/*    Read access shows status of unmasked IRQs */
/*    Write access with '1' resets the appropriate IRQ and clear the HOLD reason */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX10_xpic_break_irq_raw        0x0000003CU
#define Adr_NX10_xpic_debug_xpic_break_irq_raw 0x1018813CU
#define Adr_NX10_xpic_break_irq_raw            0x1018813CU
#define DFLT_VAL_NX10_xpic_break_irq_raw       0x00000000U

#define MSK_NX10_xpic_break_irq_raw_break0_irq            0x00000001U
#define SRT_NX10_xpic_break_irq_raw_break0_irq            0
#define DFLT_VAL_NX10_xpic_break_irq_raw_break0_irq       0x00000000U
#define MSK_NX10_xpic_break_irq_raw_break1_irq            0x00000002U
#define SRT_NX10_xpic_break_irq_raw_break1_irq            1
#define DFLT_VAL_NX10_xpic_break_irq_raw_break1_irq       0x00000000U
#define MSK_NX10_xpic_break_irq_raw_soft_break_irq        0x00000004U
#define SRT_NX10_xpic_break_irq_raw_soft_break_irq        2
#define DFLT_VAL_NX10_xpic_break_irq_raw_soft_break_irq   0x00000000U
#define MSK_NX10_xpic_break_irq_raw_single_step_irq       0x00000008U
#define SRT_NX10_xpic_break_irq_raw_single_step_irq       3
#define DFLT_VAL_NX10_xpic_break_irq_raw_single_step_irq  0x00000000U
#define MSK_NX10_xpic_break_irq_raw_misalignment_irq      0x00000010U
#define SRT_NX10_xpic_break_irq_raw_misalignment_irq      4
#define DFLT_VAL_NX10_xpic_break_irq_raw_misalignment_irq 0x00000000U

enum {
	BFW_NX10_xpic_break_irq_raw_break0_irq       = 1,  /* [0] */
	BFW_NX10_xpic_break_irq_raw_break1_irq       = 1,  /* [1] */
	BFW_NX10_xpic_break_irq_raw_soft_break_irq   = 1,  /* [2] */
	BFW_NX10_xpic_break_irq_raw_single_step_irq  = 1,  /* [3] */
	BFW_NX10_xpic_break_irq_raw_misalignment_irq = 1,  /* [4] */
	BFW_NX10_xpic_break_irq_raw_reserved1        = 27  /* [31:5] */
};

typedef struct NX10_XPIC_BREAK_IRQ_RAW_BIT_Ttag {
	unsigned int break0_irq       : BFW_NX10_xpic_break_irq_raw_break0_irq;       /* Breakpoint 0 Interrupt            */
	unsigned int break1_irq       : BFW_NX10_xpic_break_irq_raw_break1_irq;       /* Breakpoint 1 Interrupt            */
	unsigned int soft_break_irq   : BFW_NX10_xpic_break_irq_raw_soft_break_irq;   /* Software Breakpoint Interrupt     */
	unsigned int single_step_irq  : BFW_NX10_xpic_break_irq_raw_single_step_irq;  /* single step Breakpoint Interrupt  */
	unsigned int misalignment_irq : BFW_NX10_xpic_break_irq_raw_misalignment_irq; /* Data Misalignment Error Interrupt */
	unsigned int reserved1        : BFW_NX10_xpic_break_irq_raw_reserved1;        /* reserved                          */
} NX10_XPIC_BREAK_IRQ_RAW_BIT_T;

typedef union {
	unsigned int                  val;
	NX10_XPIC_BREAK_IRQ_RAW_BIT_T bf;
} NX10_XPIC_BREAK_IRQ_RAW_T;

/* --------------------------------------------------------------------- */
/* Register xpic_break_irq_masked */
/* => xPIC_DEBUG Masked IRQ register: for other CPU (ARM) */
/*    Shows status of masked IRQs (as connected to ARM) */
/* => Mode: R */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX10_xpic_break_irq_masked        0x00000040U
#define Adr_NX10_xpic_debug_xpic_break_irq_masked 0x10188140U
#define Adr_NX10_xpic_break_irq_masked            0x10188140U

#define MSK_NX10_xpic_break_irq_masked_break0_irq       0x00000001U
#define SRT_NX10_xpic_break_irq_masked_break0_irq       0
#define MSK_NX10_xpic_break_irq_masked_break1_irq       0x00000002U
#define SRT_NX10_xpic_break_irq_masked_break1_irq       1
#define MSK_NX10_xpic_break_irq_masked_soft_break_irq   0x00000004U
#define SRT_NX10_xpic_break_irq_masked_soft_break_irq   2
#define MSK_NX10_xpic_break_irq_masked_single_step_irq  0x00000008U
#define SRT_NX10_xpic_break_irq_masked_single_step_irq  3
#define MSK_NX10_xpic_break_irq_masked_misalignment_irq 0x00000010U
#define SRT_NX10_xpic_break_irq_masked_misalignment_irq 4

enum {
	BFW_NX10_xpic_break_irq_masked_break0_irq       = 1,  /* [0] */
	BFW_NX10_xpic_break_irq_masked_break1_irq       = 1,  /* [1] */
	BFW_NX10_xpic_break_irq_masked_soft_break_irq   = 1,  /* [2] */
	BFW_NX10_xpic_break_irq_masked_single_step_irq  = 1,  /* [3] */
	BFW_NX10_xpic_break_irq_masked_misalignment_irq = 1,  /* [4] */
	BFW_NX10_xpic_break_irq_masked_reserved1        = 27  /* [31:5] */
};

typedef struct NX10_XPIC_BREAK_IRQ_MASKED_BIT_Ttag {
	unsigned int break0_irq       : BFW_NX10_xpic_break_irq_masked_break0_irq;       /* Breakpoint 0 Interrupt            */
	unsigned int break1_irq       : BFW_NX10_xpic_break_irq_masked_break1_irq;       /* Breakpoint 1 Interrupt            */
	unsigned int soft_break_irq   : BFW_NX10_xpic_break_irq_masked_soft_break_irq;   /* Software Breakpoint Interrupt     */
	unsigned int single_step_irq  : BFW_NX10_xpic_break_irq_masked_single_step_irq;  /* single step Breakpoint Interrupt  */
	unsigned int misalignment_irq : BFW_NX10_xpic_break_irq_masked_misalignment_irq; /* Data Misalignment Error Interrupt */
	unsigned int reserved1        : BFW_NX10_xpic_break_irq_masked_reserved1;        /* reserved                          */
} NX10_XPIC_BREAK_IRQ_MASKED_BIT_T;

typedef union {
	unsigned int                     val;
	NX10_XPIC_BREAK_IRQ_MASKED_BIT_T bf;
} NX10_XPIC_BREAK_IRQ_MASKED_T;

/* --------------------------------------------------------------------- */
/* Register xpic_break_irq_msk_set */
/* => xPIC_DEBUG interrupt mask enable: for other CPU (ARM) */
/*    Write access with '1' sets interrupt mask bit (enables interrupt request for corresponding interrupt source) */
/*    Write access with '0' does not influence this bit */
/*    Read access shows actual interrupt mask */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX10_xpic_break_irq_msk_set        0x00000044U
#define Adr_NX10_xpic_debug_xpic_break_irq_msk_set 0x10188144U
#define Adr_NX10_xpic_break_irq_msk_set            0x10188144U
#define DFLT_VAL_NX10_xpic_break_irq_msk_set       0x00000000U

#define MSK_NX10_xpic_break_irq_msk_set_break0_irq            0x00000001U
#define SRT_NX10_xpic_break_irq_msk_set_break0_irq            0
#define DFLT_VAL_NX10_xpic_break_irq_msk_set_break0_irq       0x00000000U
#define MSK_NX10_xpic_break_irq_msk_set_break1_irq            0x00000002U
#define SRT_NX10_xpic_break_irq_msk_set_break1_irq            1
#define DFLT_VAL_NX10_xpic_break_irq_msk_set_break1_irq       0x00000000U
#define MSK_NX10_xpic_break_irq_msk_set_soft_break_irq        0x00000004U
#define SRT_NX10_xpic_break_irq_msk_set_soft_break_irq        2
#define DFLT_VAL_NX10_xpic_break_irq_msk_set_soft_break_irq   0x00000000U
#define MSK_NX10_xpic_break_irq_msk_set_single_step_irq       0x00000008U
#define SRT_NX10_xpic_break_irq_msk_set_single_step_irq       3
#define DFLT_VAL_NX10_xpic_break_irq_msk_set_single_step_irq  0x00000000U
#define MSK_NX10_xpic_break_irq_msk_set_misalignment_irq      0x00000010U
#define SRT_NX10_xpic_break_irq_msk_set_misalignment_irq      4
#define DFLT_VAL_NX10_xpic_break_irq_msk_set_misalignment_irq 0x00000000U

enum {
	BFW_NX10_xpic_break_irq_msk_set_break0_irq       = 1,  /* [0] */
	BFW_NX10_xpic_break_irq_msk_set_break1_irq       = 1,  /* [1] */
	BFW_NX10_xpic_break_irq_msk_set_soft_break_irq   = 1,  /* [2] */
	BFW_NX10_xpic_break_irq_msk_set_single_step_irq  = 1,  /* [3] */
	BFW_NX10_xpic_break_irq_msk_set_misalignment_irq = 1,  /* [4] */
	BFW_NX10_xpic_break_irq_msk_set_reserved1        = 27  /* [31:5] */
};

typedef struct NX10_XPIC_BREAK_IRQ_MSK_SET_BIT_Ttag {
	unsigned int break0_irq       : BFW_NX10_xpic_break_irq_msk_set_break0_irq;       /* Breakpoint 0 Interrupt            */
	unsigned int break1_irq       : BFW_NX10_xpic_break_irq_msk_set_break1_irq;       /* Breakpoint 1 Interrupt            */
	unsigned int soft_break_irq   : BFW_NX10_xpic_break_irq_msk_set_soft_break_irq;   /* Software Breakpoint Interrupt     */
	unsigned int single_step_irq  : BFW_NX10_xpic_break_irq_msk_set_single_step_irq;  /* single step Breakpoint Interrupt  */
	unsigned int misalignment_irq : BFW_NX10_xpic_break_irq_msk_set_misalignment_irq; /* Data Misalignment Error Interrupt */
	unsigned int reserved1        : BFW_NX10_xpic_break_irq_msk_set_reserved1;        /* reserved                          */
} NX10_XPIC_BREAK_IRQ_MSK_SET_BIT_T;

typedef union {
	unsigned int                      val;
	NX10_XPIC_BREAK_IRQ_MSK_SET_BIT_T bf;
} NX10_XPIC_BREAK_IRQ_MSK_SET_T;

/* --------------------------------------------------------------------- */
/* Register xpic_break_irq_msk_reset */
/* => xPIC_DEBUG interrupt mask disable: for other CPU (ARM) */
/*    Write access with '1' resets interrupt mask bit (disables interrupt request for corresponding interrupt source) */
/*    Write access with '0' does not influence this bit */
/*    Read access shows actual interrupt mask */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX10_xpic_break_irq_msk_reset        0x00000048U
#define Adr_NX10_xpic_debug_xpic_break_irq_msk_reset 0x10188148U
#define Adr_NX10_xpic_break_irq_msk_reset            0x10188148U
#define DFLT_VAL_NX10_xpic_break_irq_msk_reset       0x00000000U

#define MSK_NX10_xpic_break_irq_msk_reset_break0_irq            0x00000001U
#define SRT_NX10_xpic_break_irq_msk_reset_break0_irq            0
#define DFLT_VAL_NX10_xpic_break_irq_msk_reset_break0_irq       0x00000000U
#define MSK_NX10_xpic_break_irq_msk_reset_break1_irq            0x00000002U
#define SRT_NX10_xpic_break_irq_msk_reset_break1_irq            1
#define DFLT_VAL_NX10_xpic_break_irq_msk_reset_break1_irq       0x00000000U
#define MSK_NX10_xpic_break_irq_msk_reset_soft_break_irq        0x00000004U
#define SRT_NX10_xpic_break_irq_msk_reset_soft_break_irq        2
#define DFLT_VAL_NX10_xpic_break_irq_msk_reset_soft_break_irq   0x00000000U
#define MSK_NX10_xpic_break_irq_msk_reset_single_step_irq       0x00000008U
#define SRT_NX10_xpic_break_irq_msk_reset_single_step_irq       3
#define DFLT_VAL_NX10_xpic_break_irq_msk_reset_single_step_irq  0x00000000U
#define MSK_NX10_xpic_break_irq_msk_reset_misalignment_irq      0x00000010U
#define SRT_NX10_xpic_break_irq_msk_reset_misalignment_irq      4
#define DFLT_VAL_NX10_xpic_break_irq_msk_reset_misalignment_irq 0x00000000U

enum {
	BFW_NX10_xpic_break_irq_msk_reset_break0_irq       = 1,  /* [0] */
	BFW_NX10_xpic_break_irq_msk_reset_break1_irq       = 1,  /* [1] */
	BFW_NX10_xpic_break_irq_msk_reset_soft_break_irq   = 1,  /* [2] */
	BFW_NX10_xpic_break_irq_msk_reset_single_step_irq  = 1,  /* [3] */
	BFW_NX10_xpic_break_irq_msk_reset_misalignment_irq = 1,  /* [4] */
	BFW_NX10_xpic_break_irq_msk_reset_reserved1        = 27  /* [31:5] */
};

typedef struct NX10_XPIC_BREAK_IRQ_MSK_RESET_BIT_Ttag {
	unsigned int break0_irq       : BFW_NX10_xpic_break_irq_msk_reset_break0_irq;       /* Breakpoint 0 Interrupt            */
	unsigned int break1_irq       : BFW_NX10_xpic_break_irq_msk_reset_break1_irq;       /* Breakpoint 1 Interrupt            */
	unsigned int soft_break_irq   : BFW_NX10_xpic_break_irq_msk_reset_soft_break_irq;   /* Software Breakpoint Interrupt     */
	unsigned int single_step_irq  : BFW_NX10_xpic_break_irq_msk_reset_single_step_irq;  /* single step Breakpoint Interrupt  */
	unsigned int misalignment_irq : BFW_NX10_xpic_break_irq_msk_reset_misalignment_irq; /* Data Misalignment Error Interrupt */
	unsigned int reserved1        : BFW_NX10_xpic_break_irq_msk_reset_reserved1;        /* reserved                          */
} NX10_XPIC_BREAK_IRQ_MSK_RESET_BIT_T;

typedef union {
	unsigned int                        val;
	NX10_XPIC_BREAK_IRQ_MSK_RESET_BIT_T bf;
} NX10_XPIC_BREAK_IRQ_MSK_RESET_T;

/* --------------------------------------------------------------------- */
/* Register xpic_break_own_irq_masked */
/* => xPIC_DEBUG own Masked IRQ register: for xPIC */
/*    Shows status of masked IRQs (as connected to xPIC) */
/* => Mode: R */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX10_xpic_break_own_irq_masked        0x0000004CU
#define Adr_NX10_xpic_debug_xpic_break_own_irq_masked 0x1018814CU
#define Adr_NX10_xpic_break_own_irq_masked            0x1018814CU

#define MSK_NX10_xpic_break_own_irq_masked_misalignment_irq 0x00000001U
#define SRT_NX10_xpic_break_own_irq_masked_misalignment_irq 0

enum {
	BFW_NX10_xpic_break_own_irq_masked_misalignment_irq = 1,  /* [0] */
	BFW_NX10_xpic_break_own_irq_masked_reserved1        = 31  /* [31:1] */
};

typedef struct NX10_XPIC_BREAK_OWN_IRQ_MASKED_BIT_Ttag {
	unsigned int misalignment_irq : BFW_NX10_xpic_break_own_irq_masked_misalignment_irq; /* Data Misalignment Error Interrupt */
	unsigned int reserved1        : BFW_NX10_xpic_break_own_irq_masked_reserved1;        /* reserved                          */
} NX10_XPIC_BREAK_OWN_IRQ_MASKED_BIT_T;

typedef union {
	unsigned int                         val;
	NX10_XPIC_BREAK_OWN_IRQ_MASKED_BIT_T bf;
} NX10_XPIC_BREAK_OWN_IRQ_MASKED_T;

/* --------------------------------------------------------------------- */
/* Register xpic_break_own_irq_msk_set */
/* => xPIC_DEBUG own interrupt mask enable: for xPIC */
/*    Write access with '1' sets interrupt mask bit (enables interrupt request for corresponding interrupt source) */
/*    Write access with '0' does not influence this bit */
/*    Read access shows actual interrupt mask */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX10_xpic_break_own_irq_msk_set        0x00000050U
#define Adr_NX10_xpic_debug_xpic_break_own_irq_msk_set 0x10188150U
#define Adr_NX10_xpic_break_own_irq_msk_set            0x10188150U
#define DFLT_VAL_NX10_xpic_break_own_irq_msk_set       0x00000000U

#define MSK_NX10_xpic_break_own_irq_msk_set_misalignment_irq      0x00000001U
#define SRT_NX10_xpic_break_own_irq_msk_set_misalignment_irq      0
#define DFLT_VAL_NX10_xpic_break_own_irq_msk_set_misalignment_irq 0x00000000U

enum {
	BFW_NX10_xpic_break_own_irq_msk_set_misalignment_irq = 1,  /* [0] */
	BFW_NX10_xpic_break_own_irq_msk_set_reserved1        = 31  /* [31:1] */
};

typedef struct NX10_XPIC_BREAK_OWN_IRQ_MSK_SET_BIT_Ttag {
	unsigned int misalignment_irq : BFW_NX10_xpic_break_own_irq_msk_set_misalignment_irq; /* Data Misalignment Error Interrupt */
	unsigned int reserved1        : BFW_NX10_xpic_break_own_irq_msk_set_reserved1;        /* reserved                          */
} NX10_XPIC_BREAK_OWN_IRQ_MSK_SET_BIT_T;

typedef union {
	unsigned int                          val;
	NX10_XPIC_BREAK_OWN_IRQ_MSK_SET_BIT_T bf;
} NX10_XPIC_BREAK_OWN_IRQ_MSK_SET_T;

/* --------------------------------------------------------------------- */
/* Register xpic_break_own_irq_msk_reset */
/* => xPIC_DEBUG own interrupt mask disable: for XPIC */
/*    Write access with '1' resets interrupt mask bit (disables interrupt request for corresponding interrupt source) */
/*    Write access with '0' does not influence this bit */
/*    Read access shows actual interrupt mask */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX10_xpic_break_own_irq_msk_reset        0x00000054U
#define Adr_NX10_xpic_debug_xpic_break_own_irq_msk_reset 0x10188154U
#define Adr_NX10_xpic_break_own_irq_msk_reset            0x10188154U
#define DFLT_VAL_NX10_xpic_break_own_irq_msk_reset       0x00000000U

#define MSK_NX10_xpic_break_own_irq_msk_reset_misalignment_irq      0x00000001U
#define SRT_NX10_xpic_break_own_irq_msk_reset_misalignment_irq      0
#define DFLT_VAL_NX10_xpic_break_own_irq_msk_reset_misalignment_irq 0x00000000U

enum {
	BFW_NX10_xpic_break_own_irq_msk_reset_misalignment_irq = 1,  /* [0] */
	BFW_NX10_xpic_break_own_irq_msk_reset_reserved1        = 31  /* [31:1] */
};

typedef struct NX10_XPIC_BREAK_OWN_IRQ_MSK_RESET_BIT_Ttag {
	unsigned int misalignment_irq : BFW_NX10_xpic_break_own_irq_msk_reset_misalignment_irq; /* Data Misalignment Error Interrupt */
	unsigned int reserved1        : BFW_NX10_xpic_break_own_irq_msk_reset_reserved1;        /* reserved                          */
} NX10_XPIC_BREAK_OWN_IRQ_MSK_RESET_BIT_T;

typedef union {
	unsigned int                            val;
	NX10_XPIC_BREAK_OWN_IRQ_MSK_RESET_BIT_T bf;
} NX10_XPIC_BREAK_OWN_IRQ_MSK_RESET_T;

/* --------------------------------------------------------------------- */
/* Register xpic_break_return_fiq_pc */
/* => xPIC_DEBUG information FIQ return PC value */
/*    valid if xPIC is in FIQ */
/* => Mode: R */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX10_xpic_break_return_fiq_pc        0x00000058U
#define Adr_NX10_xpic_debug_xpic_break_return_fiq_pc 0x10188158U
#define Adr_NX10_xpic_break_return_fiq_pc            0x10188158U

#define MSK_NX10_xpic_break_return_fiq_pc_val 0xffffffffU
#define SRT_NX10_xpic_break_return_fiq_pc_val 0

enum {
	BFW_NX10_xpic_break_return_fiq_pc_val = 32  /* [31:0] */
};

typedef struct NX10_XPIC_BREAK_RETURN_FIQ_PC_BIT_Ttag {
	unsigned int val : BFW_NX10_xpic_break_return_fiq_pc_val; /* xPIC FIQ return value */
} NX10_XPIC_BREAK_RETURN_FIQ_PC_BIT_T;

typedef union {
	unsigned int                        val;
	NX10_XPIC_BREAK_RETURN_FIQ_PC_BIT_T bf;
} NX10_XPIC_BREAK_RETURN_FIQ_PC_T;

/* --------------------------------------------------------------------- */
/* Register xpic_break_return_irq_pc */
/* => xPIC_DEBUG information last IRQ return PC value */
/*    valid if xPIC is in IRQ */
/* => Mode: R */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX10_xpic_break_return_irq_pc        0x0000005CU
#define Adr_NX10_xpic_debug_xpic_break_return_irq_pc 0x1018815CU
#define Adr_NX10_xpic_break_return_irq_pc            0x1018815CU

#define MSK_NX10_xpic_break_return_irq_pc_val 0xffffffffU
#define SRT_NX10_xpic_break_return_irq_pc_val 0

enum {
	BFW_NX10_xpic_break_return_irq_pc_val = 32  /* [31:0] */
};

typedef struct NX10_XPIC_BREAK_RETURN_IRQ_PC_BIT_Ttag {
	unsigned int val : BFW_NX10_xpic_break_return_irq_pc_val; /* xPIC last IRQ return value */
} NX10_XPIC_BREAK_RETURN_IRQ_PC_BIT_T;

typedef union {
	unsigned int                        val;
	NX10_XPIC_BREAK_RETURN_IRQ_PC_BIT_T bf;
} NX10_XPIC_BREAK_RETURN_IRQ_PC_T;


/* ===================================================================== */

/* AREA xmac */
/* Area of xmac0 */

/* ===================================================================== */

#define Addr_NX10_xmac0    0x101A0000U
#define NX10_NETX_XM0_BASE 0x101A0000U

/* --------------------------------------------------------------------- */
/* Register xmac_rpu_program_start */
/* => xMAC RPU program-RAM start address. */
/*    The Program-RAM is not addressable for xMAC RPU and TPU ! */
/* => Mode:  */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX10_xmac_rpu_program_start   0x00000000U
#define Adr_NX10_xmac0_xmac_rpu_program_start 0x101A0000U
#define Adr_NX10_xmac_rpu_program_start       0x101A0000U

/* --------------------------------------------------------------------- */
/* Register xmac_rpu_program_end */
/* => xMAC RPU program-RAM end address. */
/*    This value is not used by design flow, only for documentation */
/* => Mode:  */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX10_xmac_rpu_program_end   0x000003FFU
#define Adr_NX10_xmac0_xmac_rpu_program_end 0x101A03FFU
#define Adr_NX10_xmac_rpu_program_end       0x101A03FFU

/* --------------------------------------------------------------------- */
/* Register xmac_tpu_program_start */
/* => xMAC TPU program-RAM start address. */
/*    The Program-RAM is not addressable for xMAC RPU and TPU ! */
/* => Mode:  */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX10_xmac_tpu_program_start   0x00000400U
#define Adr_NX10_xmac0_xmac_tpu_program_start 0x101A0400U
#define Adr_NX10_xmac_tpu_program_start       0x101A0400U

/* --------------------------------------------------------------------- */
/* Register xmac_tpu_program_end */
/* => xMAC TPU program-RAM end address. */
/*    This value is not used by design flow, only for documentation */
/* => Mode:  */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX10_xmac_tpu_program_end   0x000007FFU
#define Adr_NX10_xmac0_xmac_tpu_program_end 0x101A07FFU
#define Adr_NX10_xmac_tpu_program_end       0x101A07FFU

/* --------------------------------------------------------------------- */
/* Register xmac_sr0 */
/* => Shared Work Register 0 accessible by all xMACs and xPECs */
/*    This register has a write pipeline delay of 1 clock cycle */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX10_xmac_sr0   0x00000800U
#define Adr_NX10_xmac0_xmac_sr0 0x101A0800U
#define Adr_NX10_xmac_sr0       0x101A0800U
#define DFLT_VAL_NX10_xmac_sr0  0x00000000U

#define MSK_NX10_xmac_sr0_SR0      0x0000ffffU
#define SRT_NX10_xmac_sr0_SR0      0
#define DFLT_VAL_NX10_xmac_sr0_SR0 0x00000000U

enum {
	BFW_NX10_xmac_sr0_SR0       = 16, /* [15:0] */
	BFW_NX10_xmac_sr0_reserved1 = 16  /* [31:16] */
};

typedef struct NX10_XMAC_SR0_BIT_Ttag {
	unsigned int SR0       : BFW_NX10_xmac_sr0_SR0;       /* Shared Register */
	unsigned int reserved1 : BFW_NX10_xmac_sr0_reserved1; /* reserved        */
} NX10_XMAC_SR0_BIT_T;

typedef union {
	unsigned int        val;
	NX10_XMAC_SR0_BIT_T bf;
} NX10_XMAC_SR0_T;

/* --------------------------------------------------------------------- */
/* Register xmac_sr1 */
/* => Shared Work Register 1 accessible by all xMACs and xPECs */
/*    This register has a write pipeline delay of 1 clock cycle */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX10_xmac_sr1   0x00000804U
#define Adr_NX10_xmac0_xmac_sr1 0x101A0804U
#define Adr_NX10_xmac_sr1       0x101A0804U
#define DFLT_VAL_NX10_xmac_sr1  0x00000000U

#define MSK_NX10_xmac_sr1_SR1      0x0000ffffU
#define SRT_NX10_xmac_sr1_SR1      0
#define DFLT_VAL_NX10_xmac_sr1_SR1 0x00000000U

enum {
	BFW_NX10_xmac_sr1_SR1       = 16, /* [15:0] */
	BFW_NX10_xmac_sr1_reserved1 = 16  /* [31:16] */
};

typedef struct NX10_XMAC_SR1_BIT_Ttag {
	unsigned int SR1       : BFW_NX10_xmac_sr1_SR1;       /* Shared Register */
	unsigned int reserved1 : BFW_NX10_xmac_sr1_reserved1; /* reserved        */
} NX10_XMAC_SR1_BIT_T;

typedef union {
	unsigned int        val;
	NX10_XMAC_SR1_BIT_T bf;
} NX10_XMAC_SR1_T;

/* --------------------------------------------------------------------- */
/* Register xmac_sr2 */
/* => Shared Work Register 2 accessible by all xMACs and xPECs */
/*    This register has a write pipeline delay of 1 clock cycle */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX10_xmac_sr2   0x00000808U
#define Adr_NX10_xmac0_xmac_sr2 0x101A0808U
#define Adr_NX10_xmac_sr2       0x101A0808U
#define DFLT_VAL_NX10_xmac_sr2  0x00000000U

#define MSK_NX10_xmac_sr2_SR2      0x0000ffffU
#define SRT_NX10_xmac_sr2_SR2      0
#define DFLT_VAL_NX10_xmac_sr2_SR2 0x00000000U

enum {
	BFW_NX10_xmac_sr2_SR2       = 16, /* [15:0] */
	BFW_NX10_xmac_sr2_reserved1 = 16  /* [31:16] */
};

typedef struct NX10_XMAC_SR2_BIT_Ttag {
	unsigned int SR2       : BFW_NX10_xmac_sr2_SR2;       /* Shared Register */
	unsigned int reserved1 : BFW_NX10_xmac_sr2_reserved1; /* reserved        */
} NX10_XMAC_SR2_BIT_T;

typedef union {
	unsigned int        val;
	NX10_XMAC_SR2_BIT_T bf;
} NX10_XMAC_SR2_T;

/* --------------------------------------------------------------------- */
/* Register xmac_sr3 */
/* => Shared Work Register 3 accessible by all xMACs and xPECs */
/*    This register has a write pipeline delay of 1 clock cycle */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX10_xmac_sr3   0x0000080CU
#define Adr_NX10_xmac0_xmac_sr3 0x101A080CU
#define Adr_NX10_xmac_sr3       0x101A080CU
#define DFLT_VAL_NX10_xmac_sr3  0x00000000U

#define MSK_NX10_xmac_sr3_SR3      0x0000ffffU
#define SRT_NX10_xmac_sr3_SR3      0
#define DFLT_VAL_NX10_xmac_sr3_SR3 0x00000000U

enum {
	BFW_NX10_xmac_sr3_SR3       = 16, /* [15:0] */
	BFW_NX10_xmac_sr3_reserved1 = 16  /* [31:16] */
};

typedef struct NX10_XMAC_SR3_BIT_Ttag {
	unsigned int SR3       : BFW_NX10_xmac_sr3_SR3;       /* Shared Register */
	unsigned int reserved1 : BFW_NX10_xmac_sr3_reserved1; /* reserved        */
} NX10_XMAC_SR3_BIT_T;

typedef union {
	unsigned int        val;
	NX10_XMAC_SR3_BIT_T bf;
} NX10_XMAC_SR3_T;

/* --------------------------------------------------------------------- */
/* Register xmac_sr4 */
/* => Shared Work Register 4 accessible by all xMACs and xPECs */
/*    This register has a write pipeline delay of 1 clock cycle */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX10_xmac_sr4   0x00000810U
#define Adr_NX10_xmac0_xmac_sr4 0x101A0810U
#define Adr_NX10_xmac_sr4       0x101A0810U
#define DFLT_VAL_NX10_xmac_sr4  0x00000000U

#define MSK_NX10_xmac_sr4_SR4      0x0000ffffU
#define SRT_NX10_xmac_sr4_SR4      0
#define DFLT_VAL_NX10_xmac_sr4_SR4 0x00000000U

enum {
	BFW_NX10_xmac_sr4_SR4       = 16, /* [15:0] */
	BFW_NX10_xmac_sr4_reserved1 = 16  /* [31:16] */
};

typedef struct NX10_XMAC_SR4_BIT_Ttag {
	unsigned int SR4       : BFW_NX10_xmac_sr4_SR4;       /* Shared Register */
	unsigned int reserved1 : BFW_NX10_xmac_sr4_reserved1; /* reserved        */
} NX10_XMAC_SR4_BIT_T;

typedef union {
	unsigned int        val;
	NX10_XMAC_SR4_BIT_T bf;
} NX10_XMAC_SR4_T;

/* --------------------------------------------------------------------- */
/* Register xmac_sr5 */
/* => Shared Work Register 5 accessible by all xMACs and xPECs */
/*    This register has a write pipeline delay of 1 clock cycle */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX10_xmac_sr5   0x00000814U
#define Adr_NX10_xmac0_xmac_sr5 0x101A0814U
#define Adr_NX10_xmac_sr5       0x101A0814U
#define DFLT_VAL_NX10_xmac_sr5  0x00000000U

#define MSK_NX10_xmac_sr5_SR5      0x0000ffffU
#define SRT_NX10_xmac_sr5_SR5      0
#define DFLT_VAL_NX10_xmac_sr5_SR5 0x00000000U

enum {
	BFW_NX10_xmac_sr5_SR5       = 16, /* [15:0] */
	BFW_NX10_xmac_sr5_reserved1 = 16  /* [31:16] */
};

typedef struct NX10_XMAC_SR5_BIT_Ttag {
	unsigned int SR5       : BFW_NX10_xmac_sr5_SR5;       /* Shared Register */
	unsigned int reserved1 : BFW_NX10_xmac_sr5_reserved1; /* reserved        */
} NX10_XMAC_SR5_BIT_T;

typedef union {
	unsigned int        val;
	NX10_XMAC_SR5_BIT_T bf;
} NX10_XMAC_SR5_T;

/* --------------------------------------------------------------------- */
/* Register xmac_status_shared0 */
/* => xMAC0 Shared Status Register */
/* => Mode: R */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX10_xmac_status_shared0   0x00000840U
#define Adr_NX10_xmac0_xmac_status_shared0 0x101A0840U
#define Adr_NX10_xmac_status_shared0       0x101A0840U

#define MSK_NX10_xmac_status_shared0_gpio0_in          0x00000001U
#define SRT_NX10_xmac_status_shared0_gpio0_in          0
#define MSK_NX10_xmac_status_shared0_gpio1_in          0x00000002U
#define SRT_NX10_xmac_status_shared0_gpio1_in          1
#define MSK_NX10_xmac_status_shared0_rx_rdy            0x00000004U
#define SRT_NX10_xmac_status_shared0_rx_rdy            2
#define MSK_NX10_xmac_status_shared0_rx_ovf            0x00000008U
#define SRT_NX10_xmac_status_shared0_rx_ovf            3
#define MSK_NX10_xmac_status_shared0_tx_nxt            0x00000010U
#define SRT_NX10_xmac_status_shared0_tx_nxt            4
#define MSK_NX10_xmac_status_shared0_tx_ufl            0x00000020U
#define SRT_NX10_xmac_status_shared0_tx_ufl            5
#define MSK_NX10_xmac_status_shared0_utx_empty         0x00000040U
#define SRT_NX10_xmac_status_shared0_utx_empty         6
#define MSK_NX10_xmac_status_shared0_brec              0x00000080U
#define SRT_NX10_xmac_status_shared0_brec              7
#define MSK_NX10_xmac_status_shared0_btran             0x00000100U
#define SRT_NX10_xmac_status_shared0_btran             8
#define MSK_NX10_xmac_status_shared0_stat_rpu          0x00000200U
#define SRT_NX10_xmac_status_shared0_stat_rpu          9
#define MSK_NX10_xmac_status_shared0_stat_tpu          0x00000400U
#define SRT_NX10_xmac_status_shared0_stat_tpu          10
#define MSK_NX10_xmac_status_shared0_phy_led_en        0x00000800U
#define SRT_NX10_xmac_status_shared0_phy_led_en        11
#define MSK_NX10_xmac_status_shared0_gpio2_in_phy_led0 0x00001000U
#define SRT_NX10_xmac_status_shared0_gpio2_in_phy_led0 12
#define MSK_NX10_xmac_status_shared0_gpio3_in_phy_led1 0x00002000U
#define SRT_NX10_xmac_status_shared0_gpio3_in_phy_led1 13
#define MSK_NX10_xmac_status_shared0_gpio4_in_phy_led2 0x00004000U
#define SRT_NX10_xmac_status_shared0_gpio4_in_phy_led2 14
#define MSK_NX10_xmac_status_shared0_gpio5_in_phy_led3 0x00008000U
#define SRT_NX10_xmac_status_shared0_gpio5_in_phy_led3 15

enum {
	BFW_NX10_xmac_status_shared0_gpio0_in          = 1,  /* [0] */
	BFW_NX10_xmac_status_shared0_gpio1_in          = 1,  /* [1] */
	BFW_NX10_xmac_status_shared0_rx_rdy            = 1,  /* [2] */
	BFW_NX10_xmac_status_shared0_rx_ovf            = 1,  /* [3] */
	BFW_NX10_xmac_status_shared0_tx_nxt            = 1,  /* [4] */
	BFW_NX10_xmac_status_shared0_tx_ufl            = 1,  /* [5] */
	BFW_NX10_xmac_status_shared0_utx_empty         = 1,  /* [6] */
	BFW_NX10_xmac_status_shared0_brec              = 1,  /* [7] */
	BFW_NX10_xmac_status_shared0_btran             = 1,  /* [8] */
	BFW_NX10_xmac_status_shared0_stat_rpu          = 1,  /* [9] */
	BFW_NX10_xmac_status_shared0_stat_tpu          = 1,  /* [10] */
	BFW_NX10_xmac_status_shared0_phy_led_en        = 1,  /* [11] */
	BFW_NX10_xmac_status_shared0_gpio2_in_phy_led0 = 1,  /* [12] */
	BFW_NX10_xmac_status_shared0_gpio3_in_phy_led1 = 1,  /* [13] */
	BFW_NX10_xmac_status_shared0_gpio4_in_phy_led2 = 1,  /* [14] */
	BFW_NX10_xmac_status_shared0_gpio5_in_phy_led3 = 1,  /* [15] */
	BFW_NX10_xmac_status_shared0_reserved1         = 16  /* [31:16] */
};

typedef struct NX10_XMAC_STATUS_SHARED0_BIT_Ttag {
	unsigned int gpio0_in          : BFW_NX10_xmac_status_shared0_gpio0_in;          /* value at external gpio pin                                            */
	unsigned int gpio1_in          : BFW_NX10_xmac_status_shared0_gpio1_in;          /* value at external gpio pin                                            */
	unsigned int rx_rdy            : BFW_NX10_xmac_status_shared0_rx_rdy;            /* received bytes are valid at output of URX_FIFO                        */
	unsigned int rx_ovf            : BFW_NX10_xmac_status_shared0_rx_ovf;            /* receive overflow (too much data in URX_FIFO)                          */
	unsigned int tx_nxt            : BFW_NX10_xmac_status_shared0_tx_nxt;            /* put next tx_word to UTX_FIFO: at least one entry of UTX_FIFO is empty */
	unsigned int tx_ufl            : BFW_NX10_xmac_status_shared0_tx_ufl;            /* transmit underflow (not enough data in UTX_FIFO)                      */
	unsigned int utx_empty         : BFW_NX10_xmac_status_shared0_utx_empty;         /* UTX_FIFO is empty                                                     */
	unsigned int brec              : BFW_NX10_xmac_status_shared0_brec;              /* bit_received (active for 1 cc)                                        */
	unsigned int btran             : BFW_NX10_xmac_status_shared0_btran;             /* bit_transmitted (active for 1 cc)                                     */
	unsigned int stat_rpu          : BFW_NX10_xmac_status_shared0_stat_rpu;          /* set and reset by RPU command bits                                     */
	unsigned int stat_tpu          : BFW_NX10_xmac_status_shared0_stat_tpu;          /* set and reset by TPU command bits                                     */
	unsigned int phy_led_en        : BFW_NX10_xmac_status_shared0_phy_led_en;        /* -> read only version of xmac_config_sbu-phy_led_en (visible to xPECs) */
	unsigned int gpio2_in_phy_led0 : BFW_NX10_xmac_status_shared0_gpio2_in_phy_led0; /* IF phy_led_en:                                                        */
	                                                                                 /* 1: Internal Phy0 LED0, usually link_status                            */
	unsigned int gpio3_in_phy_led1 : BFW_NX10_xmac_status_shared0_gpio3_in_phy_led1; /* IF phy_led_en:                                                        */
	                                                                                 /* 1: Internal Phy0 LED1, usually activity                               */
	unsigned int gpio4_in_phy_led2 : BFW_NX10_xmac_status_shared0_gpio4_in_phy_led2; /* IF phy_led_en:                                                        */
	                                                                                 /* 1: Internal Phy0 LED2, usually speed100                               */
	unsigned int gpio5_in_phy_led3 : BFW_NX10_xmac_status_shared0_gpio5_in_phy_led3; /* IF phy_led_en:                                                        */
	                                                                                 /* 1: Internal Phy0 LED3, usually full_duplex                            */
	unsigned int reserved1         : BFW_NX10_xmac_status_shared0_reserved1;         /* reserved                                                              */
} NX10_XMAC_STATUS_SHARED0_BIT_T;

typedef union {
	unsigned int                   val;
	NX10_XMAC_STATUS_SHARED0_BIT_T bf;
} NX10_XMAC_STATUS_SHARED0_T;

/* --------------------------------------------------------------------- */
/* Register xmac_config_shared0 */
/* => xMAC0 Shared Config Register */
/*    This register has a write pipeline delay of 1 clock cycle */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX10_xmac_config_shared0   0x00000844U
#define Adr_NX10_xmac0_xmac_config_shared0 0x101A0844U
#define Adr_NX10_xmac_config_shared0       0x101A0844U
#define DFLT_VAL_NX10_xmac_config_shared0  0x00000000U

#define MSK_NX10_xmac_config_shared0_gpio2_out          0x00000001U
#define SRT_NX10_xmac_config_shared0_gpio2_out          0
#define DFLT_VAL_NX10_xmac_config_shared0_gpio2_out     0x00000000U
#define MSK_NX10_xmac_config_shared0_gpio2_oe           0x00000002U
#define SRT_NX10_xmac_config_shared0_gpio2_oe           1
#define DFLT_VAL_NX10_xmac_config_shared0_gpio2_oe      0x00000000U
#define MSK_NX10_xmac_config_shared0_gpio3_out          0x00000004U
#define SRT_NX10_xmac_config_shared0_gpio3_out          2
#define DFLT_VAL_NX10_xmac_config_shared0_gpio3_out     0x00000000U
#define MSK_NX10_xmac_config_shared0_gpio3_oe           0x00000008U
#define SRT_NX10_xmac_config_shared0_gpio3_oe           3
#define DFLT_VAL_NX10_xmac_config_shared0_gpio3_oe      0x00000000U
#define MSK_NX10_xmac_config_shared0_gpio4_out          0x00000010U
#define SRT_NX10_xmac_config_shared0_gpio4_out          4
#define DFLT_VAL_NX10_xmac_config_shared0_gpio4_out     0x00000000U
#define MSK_NX10_xmac_config_shared0_gpio4_oe           0x00000020U
#define SRT_NX10_xmac_config_shared0_gpio4_oe           5
#define DFLT_VAL_NX10_xmac_config_shared0_gpio4_oe      0x00000000U
#define MSK_NX10_xmac_config_shared0_gpio5_out          0x00000040U
#define SRT_NX10_xmac_config_shared0_gpio5_out          6
#define DFLT_VAL_NX10_xmac_config_shared0_gpio5_out     0x00000000U
#define MSK_NX10_xmac_config_shared0_gpio5_oe           0x00000080U
#define SRT_NX10_xmac_config_shared0_gpio5_oe           7
#define DFLT_VAL_NX10_xmac_config_shared0_gpio5_oe      0x00000000U
#define MSK_NX10_xmac_config_shared0_rx_shift_lr        0x00000100U
#define SRT_NX10_xmac_config_shared0_rx_shift_lr        8
#define DFLT_VAL_NX10_xmac_config_shared0_rx_shift_lr   0x00000000U
#define MSK_NX10_xmac_config_shared0_tx_shift_lr        0x00000200U
#define SRT_NX10_xmac_config_shared0_tx_shift_lr        9
#define DFLT_VAL_NX10_xmac_config_shared0_tx_shift_lr   0x00000000U
#define MSK_NX10_xmac_config_shared0_reset_rx_fifo      0x00000400U
#define SRT_NX10_xmac_config_shared0_reset_rx_fifo      10
#define DFLT_VAL_NX10_xmac_config_shared0_reset_rx_fifo 0x00000000U
#define MSK_NX10_xmac_config_shared0_reset_tx_fifo      0x00000800U
#define SRT_NX10_xmac_config_shared0_reset_tx_fifo      11
#define DFLT_VAL_NX10_xmac_config_shared0_reset_tx_fifo 0x00000000U
#define MSK_NX10_xmac_config_shared0_gpio0_out          0x00001000U
#define SRT_NX10_xmac_config_shared0_gpio0_out          12
#define DFLT_VAL_NX10_xmac_config_shared0_gpio0_out     0x00000000U
#define MSK_NX10_xmac_config_shared0_gpio0_oe           0x00002000U
#define SRT_NX10_xmac_config_shared0_gpio0_oe           13
#define DFLT_VAL_NX10_xmac_config_shared0_gpio0_oe      0x00000000U
#define MSK_NX10_xmac_config_shared0_gpio1_out          0x00004000U
#define SRT_NX10_xmac_config_shared0_gpio1_out          14
#define DFLT_VAL_NX10_xmac_config_shared0_gpio1_out     0x00000000U
#define MSK_NX10_xmac_config_shared0_gpio1_oe           0x00008000U
#define SRT_NX10_xmac_config_shared0_gpio1_oe           15
#define DFLT_VAL_NX10_xmac_config_shared0_gpio1_oe      0x00000000U

enum {
	BFW_NX10_xmac_config_shared0_gpio2_out     = 1,  /* [0] */
	BFW_NX10_xmac_config_shared0_gpio2_oe      = 1,  /* [1] */
	BFW_NX10_xmac_config_shared0_gpio3_out     = 1,  /* [2] */
	BFW_NX10_xmac_config_shared0_gpio3_oe      = 1,  /* [3] */
	BFW_NX10_xmac_config_shared0_gpio4_out     = 1,  /* [4] */
	BFW_NX10_xmac_config_shared0_gpio4_oe      = 1,  /* [5] */
	BFW_NX10_xmac_config_shared0_gpio5_out     = 1,  /* [6] */
	BFW_NX10_xmac_config_shared0_gpio5_oe      = 1,  /* [7] */
	BFW_NX10_xmac_config_shared0_rx_shift_lr   = 1,  /* [8] */
	BFW_NX10_xmac_config_shared0_tx_shift_lr   = 1,  /* [9] */
	BFW_NX10_xmac_config_shared0_reset_rx_fifo = 1,  /* [10] */
	BFW_NX10_xmac_config_shared0_reset_tx_fifo = 1,  /* [11] */
	BFW_NX10_xmac_config_shared0_gpio0_out     = 1,  /* [12] */
	BFW_NX10_xmac_config_shared0_gpio0_oe      = 1,  /* [13] */
	BFW_NX10_xmac_config_shared0_gpio1_out     = 1,  /* [14] */
	BFW_NX10_xmac_config_shared0_gpio1_oe      = 1,  /* [15] */
	BFW_NX10_xmac_config_shared0_reserved1     = 16  /* [31:16] */
};

typedef struct NX10_XMAC_CONFIG_SHARED0_BIT_Ttag {
	unsigned int gpio2_out     : BFW_NX10_xmac_config_shared0_gpio2_out;     /* General Purpose IO 2 output                                                    */
	unsigned int gpio2_oe      : BFW_NX10_xmac_config_shared0_gpio2_oe;      /* General Purpose IO 2 output enable                                             */
	unsigned int gpio3_out     : BFW_NX10_xmac_config_shared0_gpio3_out;     /* General Purpose IO 3 output                                                    */
	unsigned int gpio3_oe      : BFW_NX10_xmac_config_shared0_gpio3_oe;      /* General Purpose IO 3 output enable                                             */
	unsigned int gpio4_out     : BFW_NX10_xmac_config_shared0_gpio4_out;     /* General Purpose IO 4 output                                                    */
	unsigned int gpio4_oe      : BFW_NX10_xmac_config_shared0_gpio4_oe;      /* General Purpose IO 4 output enable                                             */
	unsigned int gpio5_out     : BFW_NX10_xmac_config_shared0_gpio5_out;     /* General Purpose IO 5 output                                                    */
	unsigned int gpio5_oe      : BFW_NX10_xmac_config_shared0_gpio5_oe;      /* General Purpose IO 5 output enable                                             */
	unsigned int rx_shift_lr   : BFW_NX10_xmac_config_shared0_rx_shift_lr;   /* 1: SBU writes incoming bits to position 0 of register rx and shifts rx left,   */
	                                                                         /* 0: SBU writes incoming bits to position 15 of register rx and shifts rx right  */
	unsigned int tx_shift_lr   : BFW_NX10_xmac_config_shared0_tx_shift_lr;   /* 1: OBU reads outgoing bits from position 15 of register tx and shifts tx left, */
	                                                                         /* 0: OBU reads outgoing bits from position 0 of register tx and shifts tx right  */
	unsigned int reset_rx_fifo : BFW_NX10_xmac_config_shared0_reset_rx_fifo; /* reset URX_FIFO and rx_ovf bit inside status_shared register                    */
	unsigned int reset_tx_fifo : BFW_NX10_xmac_config_shared0_reset_tx_fifo; /* reset UTX_FIFO and tx_ufl bit inside status_shared register                    */
	unsigned int gpio0_out     : BFW_NX10_xmac_config_shared0_gpio0_out;     /* General Purpose IO 0 output                                                    */
	unsigned int gpio0_oe      : BFW_NX10_xmac_config_shared0_gpio0_oe;      /* General Purpose IO 0 output enable                                             */
	unsigned int gpio1_out     : BFW_NX10_xmac_config_shared0_gpio1_out;     /* General Purpose IO 1 output                                                    */
	unsigned int gpio1_oe      : BFW_NX10_xmac_config_shared0_gpio1_oe;      /* General Purpose IO 1 output enable                                             */
	unsigned int reserved1     : BFW_NX10_xmac_config_shared0_reserved1;     /* reserved                                                                       */
} NX10_XMAC_CONFIG_SHARED0_BIT_T;

typedef union {
	unsigned int                   val;
	NX10_XMAC_CONFIG_SHARED0_BIT_T bf;
} NX10_XMAC_CONFIG_SHARED0_T;

/* --------------------------------------------------------------------- */
/* Register xmac_urx_utx0 */
/* => xMAC0 URX/UTX Shared Register FIFO */
/*    This register has a write pipeline delay of 1 clock cycle */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX10_xmac_urx_utx0   0x00000860U
#define Adr_NX10_xmac0_xmac_urx_utx0 0x101A0860U
#define Adr_NX10_xmac_urx_utx0       0x101A0860U
#define DFLT_VAL_NX10_xmac_urx_utx0  0x00000000U

#define MSK_NX10_xmac_urx_utx0_UTX_XMAC0      0x0000ffffU
#define SRT_NX10_xmac_urx_utx0_UTX_XMAC0      0
#define DFLT_VAL_NX10_xmac_urx_utx0_UTX_XMAC0 0x00000000U

enum {
	BFW_NX10_xmac_urx_utx0_UTX_XMAC0 = 16, /* [15:0] */
	BFW_NX10_xmac_urx_utx0_reserved1 = 16  /* [31:16] */
};

typedef struct NX10_XMAC_URX_UTX0_BIT_Ttag {
	unsigned int UTX_XMAC0 : BFW_NX10_xmac_urx_utx0_UTX_XMAC0; /* read access:  Lastly received bits (output of URX_FIFO)       */
	                                                           /* write access: Bits to be transmitted next (input of UTX_FIFO) */
	unsigned int reserved1 : BFW_NX10_xmac_urx_utx0_reserved1; /* reserved                                                      */
} NX10_XMAC_URX_UTX0_BIT_T;

typedef union {
	unsigned int             val;
	NX10_XMAC_URX_UTX0_BIT_T bf;
} NX10_XMAC_URX_UTX0_T;

/* --------------------------------------------------------------------- */
/* Register xmac_urx */
/* => xMAC URX FIFO input */
/*    URX FIFO is part of xMAC. It can be read (output) by all xMACs and xPECs, but only written (input) by the xMAC it belongs to. */
/*    This register has a write pipeline delay of 1 clock cycle */
/* => Mode: W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX10_xmac_urx   0x00000870U
#define Adr_NX10_xmac0_xmac_urx 0x101A0870U
#define Adr_NX10_xmac_urx       0x101A0870U
#define DFLT_VAL_NX10_xmac_urx  0x00000000U

#define MSK_NX10_xmac_urx_urx      0x0000ffffU
#define SRT_NX10_xmac_urx_urx      0
#define DFLT_VAL_NX10_xmac_urx_urx 0x00000000U

enum {
	BFW_NX10_xmac_urx_urx       = 16, /* [15:0] */
	BFW_NX10_xmac_urx_reserved1 = 16  /* [31:16] */
};

typedef struct NX10_XMAC_URX_BIT_Ttag {
	unsigned int urx       : BFW_NX10_xmac_urx_urx;       /* Lastly received bits to be transmitted to xPEC (input of URX_FIFO) */
	unsigned int reserved1 : BFW_NX10_xmac_urx_reserved1; /* reserved                                                           */
} NX10_XMAC_URX_BIT_T;

typedef union {
	unsigned int        val;
	NX10_XMAC_URX_BIT_T bf;
} NX10_XMAC_URX_T;

/* --------------------------------------------------------------------- */
/* Register xmac_utx */
/* => xMAC UTX FIFO output */
/*    UTX FIFO is part of xMAC. It can be written (input) by all xMACs and xPECs, but only read (output) by the xMAC it belongs to. */
/* => Mode: R */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX10_xmac_utx   0x00000874U
#define Adr_NX10_xmac0_xmac_utx 0x101A0874U
#define Adr_NX10_xmac_utx       0x101A0874U

#define MSK_NX10_xmac_utx_utx 0x0000ffffU
#define SRT_NX10_xmac_utx_utx 0

enum {
	BFW_NX10_xmac_utx_utx       = 16, /* [15:0] */
	BFW_NX10_xmac_utx_reserved1 = 16  /* [31:16] */
};

typedef struct NX10_XMAC_UTX_BIT_Ttag {
	unsigned int utx       : BFW_NX10_xmac_utx_utx;       /* Bits to be transmitted next (output of UTX_FIFO)                             */
	                                                      /* read as src2 allows multiple reads, only read as src1 will change FIFO state */
	unsigned int reserved1 : BFW_NX10_xmac_utx_reserved1; /* reserved                                                                     */
} NX10_XMAC_UTX_BIT_T;

typedef union {
	unsigned int        val;
	NX10_XMAC_UTX_BIT_T bf;
} NX10_XMAC_UTX_T;

/* --------------------------------------------------------------------- */
/* Register xmac_rx */
/* => xMAC RX Register */
/*    Sampled bits from SBU are collected in this register, */
/*    i.e. if a new bit arrives from SBU (sync), other bits are shifted (direction programmable). */
/*    Same behavior in MII-Modes (4 bits arrive in parallel and the other bits are shifted by 4). */
/* => Mode: R */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX10_xmac_rx   0x00000878U
#define Adr_NX10_xmac0_xmac_rx 0x101A0878U
#define Adr_NX10_xmac_rx       0x101A0878U

#define MSK_NX10_xmac_rx_rx 0x0000ffffU
#define SRT_NX10_xmac_rx_rx 0

enum {
	BFW_NX10_xmac_rx_rx        = 16, /* [15:0] */
	BFW_NX10_xmac_rx_reserved1 = 16  /* [31:16] */
};

typedef struct NX10_XMAC_RX_BIT_Ttag {
	unsigned int rx        : BFW_NX10_xmac_rx_rx;        /* 16 previously received bits */
	unsigned int reserved1 : BFW_NX10_xmac_rx_reserved1; /* reserved                    */
} NX10_XMAC_RX_BIT_T;

typedef union {
	unsigned int       val;
	NX10_XMAC_RX_BIT_T bf;
} NX10_XMAC_RX_T;

/* --------------------------------------------------------------------- */
/* Register xmac_rx_hw */
/* => xMAC RX_HW Register */
/*    rx_hw bit in RPU-code writes actually received bit from rx to this register. */
/*    Useful in case of bitwise format, to collect source bits from raw input bitstream (e.g. in HDLC-coding). */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX10_xmac_rx_hw   0x00000880U
#define Adr_NX10_xmac0_xmac_rx_hw 0x101A0880U
#define Adr_NX10_xmac_rx_hw       0x101A0880U
#define DFLT_VAL_NX10_xmac_rx_hw  0x00000000U

#define MSK_NX10_xmac_rx_hw_rx_hw      0x0000ffffU
#define SRT_NX10_xmac_rx_hw_rx_hw      0
#define DFLT_VAL_NX10_xmac_rx_hw_rx_hw 0x00000000U

enum {
	BFW_NX10_xmac_rx_hw_rx_hw     = 16, /* [15:0] */
	BFW_NX10_xmac_rx_hw_reserved1 = 16  /* [31:16] */
};

typedef struct NX10_XMAC_RX_HW_BIT_Ttag {
	unsigned int rx_hw     : BFW_NX10_xmac_rx_hw_rx_hw;     /* collected source bits from raw input bitstream                        */
	                                                        /* same orientation of bits as in rx register (depending on rx_shift_lr) */
	unsigned int reserved1 : BFW_NX10_xmac_rx_hw_reserved1; /* reserved                                                              */
} NX10_XMAC_RX_HW_BIT_T;

typedef union {
	unsigned int          val;
	NX10_XMAC_RX_HW_BIT_T bf;
} NX10_XMAC_RX_HW_T;

/* --------------------------------------------------------------------- */
/* Register xmac_rx_hw_count */
/* => xMAC RX_HW_COUNT Register */
/*    Counts bits collected by rx_hw bit RPU-code. */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX10_xmac_rx_hw_count   0x00000884U
#define Adr_NX10_xmac0_xmac_rx_hw_count 0x101A0884U
#define Adr_NX10_xmac_rx_hw_count       0x101A0884U
#define DFLT_VAL_NX10_xmac_rx_hw_count  0x00000000U

#define MSK_NX10_xmac_rx_hw_count_rx_hw_count      0x0000ffffU
#define SRT_NX10_xmac_rx_hw_count_rx_hw_count      0
#define DFLT_VAL_NX10_xmac_rx_hw_count_rx_hw_count 0x00000000U

enum {
	BFW_NX10_xmac_rx_hw_count_rx_hw_count = 16, /* [15:0] */
	BFW_NX10_xmac_rx_hw_count_reserved1   = 16  /* [31:16] */
};

typedef struct NX10_XMAC_RX_HW_COUNT_BIT_Ttag {
	unsigned int rx_hw_count : BFW_NX10_xmac_rx_hw_count_rx_hw_count; /* counts down with rx_hw in RPU-code                               */
	                                                                  /* (from rx_nof_bits-1 to 0, 16-bit downcounter if rx_nof_bits = 0) */
	unsigned int reserved1   : BFW_NX10_xmac_rx_hw_count_reserved1;   /* reserved                                                         */
} NX10_XMAC_RX_HW_COUNT_BIT_T;

typedef union {
	unsigned int                val;
	NX10_XMAC_RX_HW_COUNT_BIT_T bf;
} NX10_XMAC_RX_HW_COUNT_T;

/* --------------------------------------------------------------------- */
/* Register xmac_tx */
/* => xMAC TX Register */
/*    Transmitted bits read automatically by OBU from this register, */
/*    i.e. if a bit is send (sync), other bits are rotated accordingly (direction programmable). */
/*    Same behavior in MII-Modes (4 bits arrive in parallel and the other bits are rotated by 4). */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX10_xmac_tx   0x00000888U
#define Adr_NX10_xmac0_xmac_tx 0x101A0888U
#define Adr_NX10_xmac_tx       0x101A0888U
#define DFLT_VAL_NX10_xmac_tx  0x00000000U

#define MSK_NX10_xmac_tx_tx      0x0000ffffU
#define SRT_NX10_xmac_tx_tx      0
#define DFLT_VAL_NX10_xmac_tx_tx 0x00000000U

enum {
	BFW_NX10_xmac_tx_tx        = 16, /* [15:0] */
	BFW_NX10_xmac_tx_reserved1 = 16  /* [31:16] */
};

typedef struct NX10_XMAC_TX_BIT_Ttag {
	unsigned int tx        : BFW_NX10_xmac_tx_tx;        /* to be transmitted bits                                */
	                                                     /* bit 0  is transmitted next in case of tx_shift_lr = 0 */
	unsigned int reserved1 : BFW_NX10_xmac_tx_reserved1; /* reserved                                              */
} NX10_XMAC_TX_BIT_T;

typedef union {
	unsigned int       val;
	NX10_XMAC_TX_BIT_T bf;
} NX10_XMAC_TX_T;

/* --------------------------------------------------------------------- */
/* Register xmac_tx_hw */
/* => xMAC TX_HW Register */
/*    tx_hw bit in TPU-code writes to be transmitted bit in tx register from this register */
/*    Useful in case of bitwise format, to insert source bits into output bitstream. */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX10_xmac_tx_hw   0x0000088CU
#define Adr_NX10_xmac0_xmac_tx_hw 0x101A088CU
#define Adr_NX10_xmac_tx_hw       0x101A088CU
#define DFLT_VAL_NX10_xmac_tx_hw  0x00000000U

#define MSK_NX10_xmac_tx_hw_tx_hw      0x0000ffffU
#define SRT_NX10_xmac_tx_hw_tx_hw      0
#define DFLT_VAL_NX10_xmac_tx_hw_tx_hw 0x00000000U

enum {
	BFW_NX10_xmac_tx_hw_tx_hw     = 16, /* [15:0] */
	BFW_NX10_xmac_tx_hw_reserved1 = 16  /* [31:16] */
};

typedef struct NX10_XMAC_TX_HW_BIT_Ttag {
	unsigned int tx_hw     : BFW_NX10_xmac_tx_hw_tx_hw;     /* bits to be inserted into output bitstream                             */
	                                                        /* same orientation of bits as in tx register (depending on tx_shift_lr) */
	unsigned int reserved1 : BFW_NX10_xmac_tx_hw_reserved1; /* reserved                                                              */
} NX10_XMAC_TX_HW_BIT_T;

typedef union {
	unsigned int          val;
	NX10_XMAC_TX_HW_BIT_T bf;
} NX10_XMAC_TX_HW_T;

/* --------------------------------------------------------------------- */
/* Register xmac_tx_hw_count */
/* => xMAC TX_HW_COUNT Register */
/*    Counts bits collected by tx_hw bit TPU-code. */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX10_xmac_tx_hw_count   0x00000890U
#define Adr_NX10_xmac0_xmac_tx_hw_count 0x101A0890U
#define Adr_NX10_xmac_tx_hw_count       0x101A0890U
#define DFLT_VAL_NX10_xmac_tx_hw_count  0x00000000U

#define MSK_NX10_xmac_tx_hw_count_tx_hw_count      0x0000ffffU
#define SRT_NX10_xmac_tx_hw_count_tx_hw_count      0
#define DFLT_VAL_NX10_xmac_tx_hw_count_tx_hw_count 0x00000000U

enum {
	BFW_NX10_xmac_tx_hw_count_tx_hw_count = 16, /* [15:0] */
	BFW_NX10_xmac_tx_hw_count_reserved1   = 16  /* [31:16] */
};

typedef struct NX10_XMAC_TX_HW_COUNT_BIT_Ttag {
	unsigned int tx_hw_count : BFW_NX10_xmac_tx_hw_count_tx_hw_count; /* counts down with tx_hw in TPU-code                               */
	                                                                  /* (from tx_nof_bits-1 to 0, 16-bit downcounter if tx_nof_bits = 0) */
	unsigned int reserved1   : BFW_NX10_xmac_tx_hw_count_reserved1;   /* reserved                                                         */
} NX10_XMAC_TX_HW_COUNT_BIT_T;

typedef union {
	unsigned int                val;
	NX10_XMAC_TX_HW_COUNT_BIT_T bf;
} NX10_XMAC_TX_HW_COUNT_T;

/* --------------------------------------------------------------------- */
/* Register xmac_tx_sent */
/* => xMAC TX Sent Register */
/*    Collects already transmitted bits. */
/*    Useful for pattern match. */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX10_xmac_tx_sent   0x00000894U
#define Adr_NX10_xmac0_xmac_tx_sent 0x101A0894U
#define Adr_NX10_xmac_tx_sent       0x101A0894U
#define DFLT_VAL_NX10_xmac_tx_sent  0x00000000U

#define MSK_NX10_xmac_tx_sent_tx_sent      0x0000ffffU
#define SRT_NX10_xmac_tx_sent_tx_sent      0
#define DFLT_VAL_NX10_xmac_tx_sent_tx_sent 0x00000000U

enum {
	BFW_NX10_xmac_tx_sent_tx_sent   = 16, /* [15:0] */
	BFW_NX10_xmac_tx_sent_reserved1 = 16  /* [31:16] */
};

typedef struct NX10_XMAC_TX_SENT_BIT_Ttag {
	unsigned int tx_sent   : BFW_NX10_xmac_tx_sent_tx_sent;   /* already transmitted bits,                                          */
	                                                          /* bit 15 is always the oldest bit (shift direction not programmable) */
	unsigned int reserved1 : BFW_NX10_xmac_tx_sent_reserved1; /* reserved                                                           */
} NX10_XMAC_TX_SENT_BIT_T;

typedef union {
	unsigned int            val;
	NX10_XMAC_TX_SENT_BIT_T bf;
} NX10_XMAC_TX_SENT_T;

/* --------------------------------------------------------------------- */
/* Register xmac_rpu_pc */
/* => RPU Progamm counter */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX10_xmac_rpu_pc   0x00000898U
#define Adr_NX10_xmac0_xmac_rpu_pc 0x101A0898U
#define Adr_NX10_xmac_rpu_pc       0x101A0898U
#define DFLT_VAL_NX10_xmac_rpu_pc  0x00000000U

#define MSK_NX10_xmac_rpu_pc_rpu_pc      0x0000007fU
#define SRT_NX10_xmac_rpu_pc_rpu_pc      0
#define DFLT_VAL_NX10_xmac_rpu_pc_rpu_pc 0x00000000U

enum {
	BFW_NX10_xmac_rpu_pc_rpu_pc    = 7,  /* [6:0] */
	BFW_NX10_xmac_rpu_pc_reserved1 = 25  /* [31:7] */
};

typedef struct NX10_XMAC_RPU_PC_BIT_Ttag {
	unsigned int rpu_pc    : BFW_NX10_xmac_rpu_pc_rpu_pc;    /* Program Counter of RPU */
	unsigned int reserved1 : BFW_NX10_xmac_rpu_pc_reserved1; /* reserved               */
} NX10_XMAC_RPU_PC_BIT_T;

typedef union {
	unsigned int           val;
	NX10_XMAC_RPU_PC_BIT_T bf;
} NX10_XMAC_RPU_PC_T;

/* --------------------------------------------------------------------- */
/* Register xmac_tpu_pc */
/* => TPU Progamm counter */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX10_xmac_tpu_pc   0x0000089CU
#define Adr_NX10_xmac0_xmac_tpu_pc 0x101A089CU
#define Adr_NX10_xmac_tpu_pc       0x101A089CU
#define DFLT_VAL_NX10_xmac_tpu_pc  0x00000000U

#define MSK_NX10_xmac_tpu_pc_tpu_pc      0x0000007fU
#define SRT_NX10_xmac_tpu_pc_tpu_pc      0
#define DFLT_VAL_NX10_xmac_tpu_pc_tpu_pc 0x00000000U

enum {
	BFW_NX10_xmac_tpu_pc_tpu_pc    = 7,  /* [6:0] */
	BFW_NX10_xmac_tpu_pc_reserved1 = 25  /* [31:7] */
};

typedef struct NX10_XMAC_TPU_PC_BIT_Ttag {
	unsigned int tpu_pc    : BFW_NX10_xmac_tpu_pc_tpu_pc;    /* Program Counter of TPU */
	unsigned int reserved1 : BFW_NX10_xmac_tpu_pc_reserved1; /* reserved               */
} NX10_XMAC_TPU_PC_BIT_T;

typedef union {
	unsigned int           val;
	NX10_XMAC_TPU_PC_BIT_T bf;
} NX10_XMAC_TPU_PC_T;

/* --------------------------------------------------------------------- */
/* Register xmac_wr0 */
/* => xMAC internal Work Register 0 */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX10_xmac_wr0   0x000008A0U
#define Adr_NX10_xmac0_xmac_wr0 0x101A08A0U
#define Adr_NX10_xmac_wr0       0x101A08A0U
#define DFLT_VAL_NX10_xmac_wr0  0x00000000U

#define MSK_NX10_xmac_wr0_WR0      0x0000ffffU
#define SRT_NX10_xmac_wr0_WR0      0
#define DFLT_VAL_NX10_xmac_wr0_WR0 0x00000000U

enum {
	BFW_NX10_xmac_wr0_WR0       = 16, /* [15:0] */
	BFW_NX10_xmac_wr0_reserved1 = 16  /* [31:16] */
};

typedef struct NX10_XMAC_WR0_BIT_Ttag {
	unsigned int WR0       : BFW_NX10_xmac_wr0_WR0;       /* Work Register */
	unsigned int reserved1 : BFW_NX10_xmac_wr0_reserved1; /* reserved      */
} NX10_XMAC_WR0_BIT_T;

typedef union {
	unsigned int        val;
	NX10_XMAC_WR0_BIT_T bf;
} NX10_XMAC_WR0_T;

/* --------------------------------------------------------------------- */
/* Register xmac_wr1 */
/* => xMAC internal Work Register 1 */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX10_xmac_wr1   0x000008A4U
#define Adr_NX10_xmac0_xmac_wr1 0x101A08A4U
#define Adr_NX10_xmac_wr1       0x101A08A4U
#define DFLT_VAL_NX10_xmac_wr1  0x00000000U

#define MSK_NX10_xmac_wr1_WR1      0x0000ffffU
#define SRT_NX10_xmac_wr1_WR1      0
#define DFLT_VAL_NX10_xmac_wr1_WR1 0x00000000U

enum {
	BFW_NX10_xmac_wr1_WR1       = 16, /* [15:0] */
	BFW_NX10_xmac_wr1_reserved1 = 16  /* [31:16] */
};

typedef struct NX10_XMAC_WR1_BIT_Ttag {
	unsigned int WR1       : BFW_NX10_xmac_wr1_WR1;       /* Work Register */
	unsigned int reserved1 : BFW_NX10_xmac_wr1_reserved1; /* reserved      */
} NX10_XMAC_WR1_BIT_T;

typedef union {
	unsigned int        val;
	NX10_XMAC_WR1_BIT_T bf;
} NX10_XMAC_WR1_T;

/* --------------------------------------------------------------------- */
/* Register xmac_wr2 */
/* => xMAC internal Work Register 2 */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX10_xmac_wr2   0x000008A8U
#define Adr_NX10_xmac0_xmac_wr2 0x101A08A8U
#define Adr_NX10_xmac_wr2       0x101A08A8U
#define DFLT_VAL_NX10_xmac_wr2  0x00000000U

#define MSK_NX10_xmac_wr2_WR2      0x0000ffffU
#define SRT_NX10_xmac_wr2_WR2      0
#define DFLT_VAL_NX10_xmac_wr2_WR2 0x00000000U

enum {
	BFW_NX10_xmac_wr2_WR2       = 16, /* [15:0] */
	BFW_NX10_xmac_wr2_reserved1 = 16  /* [31:16] */
};

typedef struct NX10_XMAC_WR2_BIT_Ttag {
	unsigned int WR2       : BFW_NX10_xmac_wr2_WR2;       /* Work Register */
	unsigned int reserved1 : BFW_NX10_xmac_wr2_reserved1; /* reserved      */
} NX10_XMAC_WR2_BIT_T;

typedef union {
	unsigned int        val;
	NX10_XMAC_WR2_BIT_T bf;
} NX10_XMAC_WR2_T;

/* --------------------------------------------------------------------- */
/* Register xmac_wr3 */
/* => xMAC internal Work Register 3 */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX10_xmac_wr3   0x000008ACU
#define Adr_NX10_xmac0_xmac_wr3 0x101A08ACU
#define Adr_NX10_xmac_wr3       0x101A08ACU
#define DFLT_VAL_NX10_xmac_wr3  0x00000000U

#define MSK_NX10_xmac_wr3_WR3      0x0000ffffU
#define SRT_NX10_xmac_wr3_WR3      0
#define DFLT_VAL_NX10_xmac_wr3_WR3 0x00000000U

enum {
	BFW_NX10_xmac_wr3_WR3       = 16, /* [15:0] */
	BFW_NX10_xmac_wr3_reserved1 = 16  /* [31:16] */
};

typedef struct NX10_XMAC_WR3_BIT_Ttag {
	unsigned int WR3       : BFW_NX10_xmac_wr3_WR3;       /* Work Register */
	unsigned int reserved1 : BFW_NX10_xmac_wr3_reserved1; /* reserved      */
} NX10_XMAC_WR3_BIT_T;

typedef union {
	unsigned int        val;
	NX10_XMAC_WR3_BIT_T bf;
} NX10_XMAC_WR3_T;

/* --------------------------------------------------------------------- */
/* Register xmac_wr4 */
/* => xMAC internal Work Register 4 */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX10_xmac_wr4   0x000008B0U
#define Adr_NX10_xmac0_xmac_wr4 0x101A08B0U
#define Adr_NX10_xmac_wr4       0x101A08B0U
#define DFLT_VAL_NX10_xmac_wr4  0x00000000U

#define MSK_NX10_xmac_wr4_WR4      0x0000ffffU
#define SRT_NX10_xmac_wr4_WR4      0
#define DFLT_VAL_NX10_xmac_wr4_WR4 0x00000000U

enum {
	BFW_NX10_xmac_wr4_WR4       = 16, /* [15:0] */
	BFW_NX10_xmac_wr4_reserved1 = 16  /* [31:16] */
};

typedef struct NX10_XMAC_WR4_BIT_Ttag {
	unsigned int WR4       : BFW_NX10_xmac_wr4_WR4;       /* Work Register */
	unsigned int reserved1 : BFW_NX10_xmac_wr4_reserved1; /* reserved      */
} NX10_XMAC_WR4_BIT_T;

typedef union {
	unsigned int        val;
	NX10_XMAC_WR4_BIT_T bf;
} NX10_XMAC_WR4_T;

/* --------------------------------------------------------------------- */
/* Register xmac_wr5 */
/* => xMAC internal Work Register 5 */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX10_xmac_wr5   0x000008B4U
#define Adr_NX10_xmac0_xmac_wr5 0x101A08B4U
#define Adr_NX10_xmac_wr5       0x101A08B4U
#define DFLT_VAL_NX10_xmac_wr5  0x00000000U

#define MSK_NX10_xmac_wr5_WR5      0x0000ffffU
#define SRT_NX10_xmac_wr5_WR5      0
#define DFLT_VAL_NX10_xmac_wr5_WR5 0x00000000U

enum {
	BFW_NX10_xmac_wr5_WR5       = 16, /* [15:0] */
	BFW_NX10_xmac_wr5_reserved1 = 16  /* [31:16] */
};

typedef struct NX10_XMAC_WR5_BIT_Ttag {
	unsigned int WR5       : BFW_NX10_xmac_wr5_WR5;       /* Work Register */
	unsigned int reserved1 : BFW_NX10_xmac_wr5_reserved1; /* reserved      */
} NX10_XMAC_WR5_BIT_T;

typedef union {
	unsigned int        val;
	NX10_XMAC_WR5_BIT_T bf;
} NX10_XMAC_WR5_T;

/* --------------------------------------------------------------------- */
/* Register xmac_wr6 */
/* => xMAC internal Work Register 6 */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX10_xmac_wr6   0x000008B8U
#define Adr_NX10_xmac0_xmac_wr6 0x101A08B8U
#define Adr_NX10_xmac_wr6       0x101A08B8U
#define DFLT_VAL_NX10_xmac_wr6  0x00000000U

#define MSK_NX10_xmac_wr6_WR6      0x0000ffffU
#define SRT_NX10_xmac_wr6_WR6      0
#define DFLT_VAL_NX10_xmac_wr6_WR6 0x00000000U

enum {
	BFW_NX10_xmac_wr6_WR6       = 16, /* [15:0] */
	BFW_NX10_xmac_wr6_reserved1 = 16  /* [31:16] */
};

typedef struct NX10_XMAC_WR6_BIT_Ttag {
	unsigned int WR6       : BFW_NX10_xmac_wr6_WR6;       /* Work Register */
	unsigned int reserved1 : BFW_NX10_xmac_wr6_reserved1; /* reserved      */
} NX10_XMAC_WR6_BIT_T;

typedef union {
	unsigned int        val;
	NX10_XMAC_WR6_BIT_T bf;
} NX10_XMAC_WR6_T;

/* --------------------------------------------------------------------- */
/* Register xmac_wr7 */
/* => xMAC internal Work Register 7 */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX10_xmac_wr7   0x000008BCU
#define Adr_NX10_xmac0_xmac_wr7 0x101A08BCU
#define Adr_NX10_xmac_wr7       0x101A08BCU
#define DFLT_VAL_NX10_xmac_wr7  0x00000000U

#define MSK_NX10_xmac_wr7_WR7      0x0000ffffU
#define SRT_NX10_xmac_wr7_WR7      0
#define DFLT_VAL_NX10_xmac_wr7_WR7 0x00000000U

enum {
	BFW_NX10_xmac_wr7_WR7       = 16, /* [15:0] */
	BFW_NX10_xmac_wr7_reserved1 = 16  /* [31:16] */
};

typedef struct NX10_XMAC_WR7_BIT_Ttag {
	unsigned int WR7       : BFW_NX10_xmac_wr7_WR7;       /* Work Register */
	unsigned int reserved1 : BFW_NX10_xmac_wr7_reserved1; /* reserved      */
} NX10_XMAC_WR7_BIT_T;

typedef union {
	unsigned int        val;
	NX10_XMAC_WR7_BIT_T bf;
} NX10_XMAC_WR7_T;

/* --------------------------------------------------------------------- */
/* Register xmac_wr8 */
/* => xMAC internal Work Register 7 */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX10_xmac_wr8   0x000008C0U
#define Adr_NX10_xmac0_xmac_wr8 0x101A08C0U
#define Adr_NX10_xmac_wr8       0x101A08C0U
#define DFLT_VAL_NX10_xmac_wr8  0x00000000U

#define MSK_NX10_xmac_wr8_WR7      0x0000ffffU
#define SRT_NX10_xmac_wr8_WR7      0
#define DFLT_VAL_NX10_xmac_wr8_WR7 0x00000000U

enum {
	BFW_NX10_xmac_wr8_WR7       = 16, /* [15:0] */
	BFW_NX10_xmac_wr8_reserved1 = 16  /* [31:16] */
};

typedef struct NX10_XMAC_WR8_BIT_Ttag {
	unsigned int WR7       : BFW_NX10_xmac_wr8_WR7;       /* Work Register */
	unsigned int reserved1 : BFW_NX10_xmac_wr8_reserved1; /* reserved      */
} NX10_XMAC_WR8_BIT_T;

typedef union {
	unsigned int        val;
	NX10_XMAC_WR8_BIT_T bf;
} NX10_XMAC_WR8_T;

/* --------------------------------------------------------------------- */
/* Register xmac_wr9 */
/* => xMAC internal Work Register 7 */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX10_xmac_wr9   0x000008C4U
#define Adr_NX10_xmac0_xmac_wr9 0x101A08C4U
#define Adr_NX10_xmac_wr9       0x101A08C4U
#define DFLT_VAL_NX10_xmac_wr9  0x00000000U

#define MSK_NX10_xmac_wr9_WR7      0x0000ffffU
#define SRT_NX10_xmac_wr9_WR7      0
#define DFLT_VAL_NX10_xmac_wr9_WR7 0x00000000U

enum {
	BFW_NX10_xmac_wr9_WR7       = 16, /* [15:0] */
	BFW_NX10_xmac_wr9_reserved1 = 16  /* [31:16] */
};

typedef struct NX10_XMAC_WR9_BIT_Ttag {
	unsigned int WR7       : BFW_NX10_xmac_wr9_WR7;       /* Work Register */
	unsigned int reserved1 : BFW_NX10_xmac_wr9_reserved1; /* reserved      */
} NX10_XMAC_WR9_BIT_T;

typedef union {
	unsigned int        val;
	NX10_XMAC_WR9_BIT_T bf;
} NX10_XMAC_WR9_T;

/* --------------------------------------------------------------------- */
/* Register xmac_sys_time */
/* => xMAC System Time */
/* => Mode: R */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX10_xmac_sys_time   0x000008C8U
#define Adr_NX10_xmac0_xmac_sys_time 0x101A08C8U
#define Adr_NX10_xmac_sys_time       0x101A08C8U

#define MSK_NX10_xmac_sys_time_sys_time 0x0000ffffU
#define SRT_NX10_xmac_sys_time_sys_time 0

enum {
	BFW_NX10_xmac_sys_time_sys_time  = 16, /* [15:0] */
	BFW_NX10_xmac_sys_time_reserved1 = 16  /* [31:16] */
};

typedef struct NX10_XMAC_SYS_TIME_BIT_Ttag {
	unsigned int sys_time  : BFW_NX10_xmac_sys_time_sys_time;  /* 16 lower bits of 32 bit systime_ns */
	unsigned int reserved1 : BFW_NX10_xmac_sys_time_reserved1; /* reserved                           */
} NX10_XMAC_SYS_TIME_BIT_T;

typedef union {
	unsigned int             val;
	NX10_XMAC_SYS_TIME_BIT_T bf;
} NX10_XMAC_SYS_TIME_T;

/* --------------------------------------------------------------------- */
/* Register xmac_sys_time_upper */
/* => xMAC System Time uppler bits, */
/*    latched at read access of xmac_sys_time */
/* => Mode: R */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX10_xmac_sys_time_upper   0x000008CCU
#define Adr_NX10_xmac0_xmac_sys_time_upper 0x101A08CCU
#define Adr_NX10_xmac_sys_time_upper       0x101A08CCU

#define MSK_NX10_xmac_sys_time_upper_sys_time_upper 0x0000ffffU
#define SRT_NX10_xmac_sys_time_upper_sys_time_upper 0

enum {
	BFW_NX10_xmac_sys_time_upper_sys_time_upper = 16, /* [15:0] */
	BFW_NX10_xmac_sys_time_upper_reserved1      = 16  /* [31:16] */
};

typedef struct NX10_XMAC_SYS_TIME_UPPER_BIT_Ttag {
	unsigned int sys_time_upper : BFW_NX10_xmac_sys_time_upper_sys_time_upper; /* 16 upper bits of 32 bit systime_ns,              */
	                                                                           /* latched at read access of xmac_sys_time (lower), */
	unsigned int reserved1      : BFW_NX10_xmac_sys_time_upper_reserved1;      /* reserved                                         */
} NX10_XMAC_SYS_TIME_UPPER_BIT_T;

typedef union {
	unsigned int                   val;
	NX10_XMAC_SYS_TIME_UPPER_BIT_T bf;
} NX10_XMAC_SYS_TIME_UPPER_T;

/* --------------------------------------------------------------------- */
/* Register xmac_cmp0_status */
/* => xMAC Compare0 Status Register */
/* => Mode: R */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX10_xmac_cmp0_status   0x000008D0U
#define Adr_NX10_xmac0_xmac_cmp0_status 0x101A08D0U
#define Adr_NX10_xmac_cmp0_status       0x101A08D0U

#define MSK_NX10_xmac_cmp0_status_sr0_z       0x00000001U
#define SRT_NX10_xmac_cmp0_status_sr0_z       0
#define MSK_NX10_xmac_cmp0_status_sr1_z       0x00000002U
#define SRT_NX10_xmac_cmp0_status_sr1_z       1
#define MSK_NX10_xmac_cmp0_status_sr2_z       0x00000004U
#define SRT_NX10_xmac_cmp0_status_sr2_z       2
#define MSK_NX10_xmac_cmp0_status_sr3_z       0x00000008U
#define SRT_NX10_xmac_cmp0_status_sr3_z       3
#define MSK_NX10_xmac_cmp0_status_sr4_z       0x00000010U
#define SRT_NX10_xmac_cmp0_status_sr4_z       4
#define MSK_NX10_xmac_cmp0_status_sr5_z       0x00000020U
#define SRT_NX10_xmac_cmp0_status_sr5_z       5
#define MSK_NX10_xmac_cmp0_status_cnt_rx_z    0x00000100U
#define SRT_NX10_xmac_cmp0_status_cnt_rx_z    8
#define MSK_NX10_xmac_cmp0_status_cnt_tx_z    0x00000200U
#define SRT_NX10_xmac_cmp0_status_cnt_tx_z    9
#define MSK_NX10_xmac_cmp0_status_cnt_rx_hw_z 0x00000400U
#define SRT_NX10_xmac_cmp0_status_cnt_rx_hw_z 10
#define MSK_NX10_xmac_cmp0_status_cnt_tx_hw_z 0x00000800U
#define SRT_NX10_xmac_cmp0_status_cnt_tx_hw_z 11
#define MSK_NX10_xmac_cmp0_status_cnt1_rpu_z  0x00001000U
#define SRT_NX10_xmac_cmp0_status_cnt1_rpu_z  12
#define MSK_NX10_xmac_cmp0_status_cnt2_rpu_z  0x00002000U
#define SRT_NX10_xmac_cmp0_status_cnt2_rpu_z  13
#define MSK_NX10_xmac_cmp0_status_cnt1_tpu_z  0x00004000U
#define SRT_NX10_xmac_cmp0_status_cnt1_tpu_z  14
#define MSK_NX10_xmac_cmp0_status_cnt2_tpu_z  0x00008000U
#define SRT_NX10_xmac_cmp0_status_cnt2_tpu_z  15

enum {
	BFW_NX10_xmac_cmp0_status_sr0_z       = 1,  /* [0] */
	BFW_NX10_xmac_cmp0_status_sr1_z       = 1,  /* [1] */
	BFW_NX10_xmac_cmp0_status_sr2_z       = 1,  /* [2] */
	BFW_NX10_xmac_cmp0_status_sr3_z       = 1,  /* [3] */
	BFW_NX10_xmac_cmp0_status_sr4_z       = 1,  /* [4] */
	BFW_NX10_xmac_cmp0_status_sr5_z       = 1,  /* [5] */
	BFW_NX10_xmac_cmp0_status_reserved1   = 2,  /* [7:6] */
	BFW_NX10_xmac_cmp0_status_cnt_rx_z    = 1,  /* [8] */
	BFW_NX10_xmac_cmp0_status_cnt_tx_z    = 1,  /* [9] */
	BFW_NX10_xmac_cmp0_status_cnt_rx_hw_z = 1,  /* [10] */
	BFW_NX10_xmac_cmp0_status_cnt_tx_hw_z = 1,  /* [11] */
	BFW_NX10_xmac_cmp0_status_cnt1_rpu_z  = 1,  /* [12] */
	BFW_NX10_xmac_cmp0_status_cnt2_rpu_z  = 1,  /* [13] */
	BFW_NX10_xmac_cmp0_status_cnt1_tpu_z  = 1,  /* [14] */
	BFW_NX10_xmac_cmp0_status_cnt2_tpu_z  = 1,  /* [15] */
	BFW_NX10_xmac_cmp0_status_reserved2   = 16  /* [31:16] */
};

typedef struct NX10_XMAC_CMP0_STATUS_BIT_Ttag {
	unsigned int sr0_z       : BFW_NX10_xmac_cmp0_status_sr0_z;       /* sr0 = 0         */
	unsigned int sr1_z       : BFW_NX10_xmac_cmp0_status_sr1_z;       /* sr1 = 0         */
	unsigned int sr2_z       : BFW_NX10_xmac_cmp0_status_sr2_z;       /* sr2 = 0         */
	unsigned int sr3_z       : BFW_NX10_xmac_cmp0_status_sr3_z;       /* sr3 = 0         */
	unsigned int sr4_z       : BFW_NX10_xmac_cmp0_status_sr4_z;       /* sr4 = 0         */
	unsigned int sr5_z       : BFW_NX10_xmac_cmp0_status_sr5_z;       /* sr5 = 0         */
	unsigned int reserved1   : BFW_NX10_xmac_cmp0_status_reserved1;   /* reserved        */
	unsigned int cnt_rx_z    : BFW_NX10_xmac_cmp0_status_cnt_rx_z;    /* count_rx = 0    */
	unsigned int cnt_tx_z    : BFW_NX10_xmac_cmp0_status_cnt_tx_z;    /* count_tx = 0    */
	unsigned int cnt_rx_hw_z : BFW_NX10_xmac_cmp0_status_cnt_rx_hw_z; /* rx_hw_count = 0 */
	unsigned int cnt_tx_hw_z : BFW_NX10_xmac_cmp0_status_cnt_tx_hw_z; /* tx_hw_count = 0 */
	unsigned int cnt1_rpu_z  : BFW_NX10_xmac_cmp0_status_cnt1_rpu_z;  /* rpu_count1 = 0  */
	unsigned int cnt2_rpu_z  : BFW_NX10_xmac_cmp0_status_cnt2_rpu_z;  /* rpu_count2 = 0  */
	unsigned int cnt1_tpu_z  : BFW_NX10_xmac_cmp0_status_cnt1_tpu_z;  /* tpu_count1 = 0  */
	unsigned int cnt2_tpu_z  : BFW_NX10_xmac_cmp0_status_cnt2_tpu_z;  /* tpu_count2 = 0  */
	unsigned int reserved2   : BFW_NX10_xmac_cmp0_status_reserved2;   /* reserved        */
} NX10_XMAC_CMP0_STATUS_BIT_T;

typedef union {
	unsigned int                val;
	NX10_XMAC_CMP0_STATUS_BIT_T bf;
} NX10_XMAC_CMP0_STATUS_T;

/* --------------------------------------------------------------------- */
/* Register xmac_cmp1_status */
/* => xMAC Compare1 Status Register */
/* => Mode: R */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX10_xmac_cmp1_status   0x000008D4U
#define Adr_NX10_xmac0_xmac_cmp1_status 0x101A08D4U
#define Adr_NX10_xmac_cmp1_status       0x101A08D4U

#define MSK_NX10_xmac_cmp1_status_wr0_z    0x00000001U
#define SRT_NX10_xmac_cmp1_status_wr0_z    0
#define MSK_NX10_xmac_cmp1_status_wr1_z    0x00000002U
#define SRT_NX10_xmac_cmp1_status_wr1_z    1
#define MSK_NX10_xmac_cmp1_status_wr2_z    0x00000004U
#define SRT_NX10_xmac_cmp1_status_wr2_z    2
#define MSK_NX10_xmac_cmp1_status_wr3_z    0x00000008U
#define SRT_NX10_xmac_cmp1_status_wr3_z    3
#define MSK_NX10_xmac_cmp1_status_wr4_z    0x00000010U
#define SRT_NX10_xmac_cmp1_status_wr4_z    4
#define MSK_NX10_xmac_cmp1_status_wr5_z    0x00000020U
#define SRT_NX10_xmac_cmp1_status_wr5_z    5
#define MSK_NX10_xmac_cmp1_status_wr6_z    0x00000040U
#define SRT_NX10_xmac_cmp1_status_wr6_z    6
#define MSK_NX10_xmac_cmp1_status_wr7_z    0x00000080U
#define SRT_NX10_xmac_cmp1_status_wr7_z    7
#define MSK_NX10_xmac_cmp1_status_wr8_z    0x00000100U
#define SRT_NX10_xmac_cmp1_status_wr8_z    8
#define MSK_NX10_xmac_cmp1_status_wr9_z    0x00000200U
#define SRT_NX10_xmac_cmp1_status_wr9_z    9
#define MSK_NX10_xmac_cmp1_status_wr0_wr1  0x00000400U
#define SRT_NX10_xmac_cmp1_status_wr0_wr1  10
#define MSK_NX10_xmac_cmp1_status_wr2_wr3  0x00000800U
#define SRT_NX10_xmac_cmp1_status_wr2_wr3  11
#define MSK_NX10_xmac_cmp1_status_wr4_wr5  0x00001000U
#define SRT_NX10_xmac_cmp1_status_wr4_wr5  12
#define MSK_NX10_xmac_cmp1_status_wr6_wr7  0x00002000U
#define SRT_NX10_xmac_cmp1_status_wr6_wr7  13
#define MSK_NX10_xmac_cmp1_status_wr8_wr9  0x00004000U
#define SRT_NX10_xmac_cmp1_status_wr8_wr9  14
#define MSK_NX10_xmac_cmp1_status_sys_time 0x00008000U
#define SRT_NX10_xmac_cmp1_status_sys_time 15

enum {
	BFW_NX10_xmac_cmp1_status_wr0_z     = 1,  /* [0] */
	BFW_NX10_xmac_cmp1_status_wr1_z     = 1,  /* [1] */
	BFW_NX10_xmac_cmp1_status_wr2_z     = 1,  /* [2] */
	BFW_NX10_xmac_cmp1_status_wr3_z     = 1,  /* [3] */
	BFW_NX10_xmac_cmp1_status_wr4_z     = 1,  /* [4] */
	BFW_NX10_xmac_cmp1_status_wr5_z     = 1,  /* [5] */
	BFW_NX10_xmac_cmp1_status_wr6_z     = 1,  /* [6] */
	BFW_NX10_xmac_cmp1_status_wr7_z     = 1,  /* [7] */
	BFW_NX10_xmac_cmp1_status_wr8_z     = 1,  /* [8] */
	BFW_NX10_xmac_cmp1_status_wr9_z     = 1,  /* [9] */
	BFW_NX10_xmac_cmp1_status_wr0_wr1   = 1,  /* [10] */
	BFW_NX10_xmac_cmp1_status_wr2_wr3   = 1,  /* [11] */
	BFW_NX10_xmac_cmp1_status_wr4_wr5   = 1,  /* [12] */
	BFW_NX10_xmac_cmp1_status_wr6_wr7   = 1,  /* [13] */
	BFW_NX10_xmac_cmp1_status_wr8_wr9   = 1,  /* [14] */
	BFW_NX10_xmac_cmp1_status_sys_time  = 1,  /* [15] */
	BFW_NX10_xmac_cmp1_status_reserved1 = 16  /* [31:16] */
};

typedef struct NX10_XMAC_CMP1_STATUS_BIT_Ttag {
	unsigned int wr0_z     : BFW_NX10_xmac_cmp1_status_wr0_z;     /* 1: work register 0 equals 0                                               */
	unsigned int wr1_z     : BFW_NX10_xmac_cmp1_status_wr1_z;     /* 1: work register 1 equals 0                                               */
	unsigned int wr2_z     : BFW_NX10_xmac_cmp1_status_wr2_z;     /* 1: work register 2 equals 0                                               */
	unsigned int wr3_z     : BFW_NX10_xmac_cmp1_status_wr3_z;     /* 1: work register 3 equals 0                                               */
	unsigned int wr4_z     : BFW_NX10_xmac_cmp1_status_wr4_z;     /* 1: work register 4 equals 0                                               */
	unsigned int wr5_z     : BFW_NX10_xmac_cmp1_status_wr5_z;     /* 1: work register 5 equals 0                                               */
	unsigned int wr6_z     : BFW_NX10_xmac_cmp1_status_wr6_z;     /* 1: work register 6 equals 0                                               */
	unsigned int wr7_z     : BFW_NX10_xmac_cmp1_status_wr7_z;     /* 1: work register 7 equals 0                                               */
	unsigned int wr8_z     : BFW_NX10_xmac_cmp1_status_wr8_z;     /* 1: work register 8 equals 0                                               */
	unsigned int wr9_z     : BFW_NX10_xmac_cmp1_status_wr9_z;     /* 1: work register 9 equals 0                                               */
	unsigned int wr0_wr1   : BFW_NX10_xmac_cmp1_status_wr0_wr1;   /* 1: wr0 equals wr1                                                         */
	unsigned int wr2_wr3   : BFW_NX10_xmac_cmp1_status_wr2_wr3;   /* 1: wr2 equals wr3                                                         */
	unsigned int wr4_wr5   : BFW_NX10_xmac_cmp1_status_wr4_wr5;   /* 1: wr4 equals wr5                                                         */
	unsigned int wr6_wr7   : BFW_NX10_xmac_cmp1_status_wr6_wr7;   /* 1: wr6 equals wr7                                                         */
	unsigned int wr8_wr9   : BFW_NX10_xmac_cmp1_status_wr8_wr9;   /* 1: wr8 equals wr9                                                         */
	unsigned int sys_time  : BFW_NX10_xmac_cmp1_status_sys_time;  /* compare of sys_time with wr6,wr2(value) and wr7,wr3(mask):                */
	                                                              /* {wr7,wr3} define, which bits of sys_time and {wr6,wr2} are to be compared */
	unsigned int reserved1 : BFW_NX10_xmac_cmp1_status_reserved1; /* reserved                                                                  */
} NX10_XMAC_CMP1_STATUS_BIT_T;

typedef union {
	unsigned int                val;
	NX10_XMAC_CMP1_STATUS_BIT_T bf;
} NX10_XMAC_CMP1_STATUS_T;

/* --------------------------------------------------------------------- */
/* Register xmac_cmp2_status */
/* => xMAC Compare2 Status Register */
/* => Mode: R */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX10_xmac_cmp2_status   0x000008D8U
#define Adr_NX10_xmac0_xmac_cmp2_status 0x101A08D8U
#define Adr_NX10_xmac_cmp2_status       0x101A08D8U

#define MSK_NX10_xmac_cmp2_status_wr0_sr0 0x00000001U
#define SRT_NX10_xmac_cmp2_status_wr0_sr0 0
#define MSK_NX10_xmac_cmp2_status_wr1_sr1 0x00000002U
#define SRT_NX10_xmac_cmp2_status_wr1_sr1 1
#define MSK_NX10_xmac_cmp2_status_wr2_sr2 0x00000004U
#define SRT_NX10_xmac_cmp2_status_wr2_sr2 2
#define MSK_NX10_xmac_cmp2_status_wr3_sr3 0x00000008U
#define SRT_NX10_xmac_cmp2_status_wr3_sr3 3
#define MSK_NX10_xmac_cmp2_status_wr4_sr4 0x00000010U
#define SRT_NX10_xmac_cmp2_status_wr4_sr4 4
#define MSK_NX10_xmac_cmp2_status_wr5_sr5 0x00000020U
#define SRT_NX10_xmac_cmp2_status_wr5_sr5 5

enum {
	BFW_NX10_xmac_cmp2_status_wr0_sr0   = 1,  /* [0] */
	BFW_NX10_xmac_cmp2_status_wr1_sr1   = 1,  /* [1] */
	BFW_NX10_xmac_cmp2_status_wr2_sr2   = 1,  /* [2] */
	BFW_NX10_xmac_cmp2_status_wr3_sr3   = 1,  /* [3] */
	BFW_NX10_xmac_cmp2_status_wr4_sr4   = 1,  /* [4] */
	BFW_NX10_xmac_cmp2_status_wr5_sr5   = 1,  /* [5] */
	BFW_NX10_xmac_cmp2_status_reserved1 = 26  /* [31:6] */
};

typedef struct NX10_XMAC_CMP2_STATUS_BIT_Ttag {
	unsigned int wr0_sr0   : BFW_NX10_xmac_cmp2_status_wr0_sr0;   /* 1: wr0 equals sr0 */
	unsigned int wr1_sr1   : BFW_NX10_xmac_cmp2_status_wr1_sr1;   /* 1: wr1 equals sr1 */
	unsigned int wr2_sr2   : BFW_NX10_xmac_cmp2_status_wr2_sr2;   /* 1: wr2 equals sr2 */
	unsigned int wr3_sr3   : BFW_NX10_xmac_cmp2_status_wr3_sr3;   /* 1: wr3 equals sr3 */
	unsigned int wr4_sr4   : BFW_NX10_xmac_cmp2_status_wr4_sr4;   /* 1: wr4 equals sr4 */
	unsigned int wr5_sr5   : BFW_NX10_xmac_cmp2_status_wr5_sr5;   /* 1: wr5 equals sr5 */
	unsigned int reserved1 : BFW_NX10_xmac_cmp2_status_reserved1; /* reserved          */
} NX10_XMAC_CMP2_STATUS_BIT_T;

typedef union {
	unsigned int                val;
	NX10_XMAC_CMP2_STATUS_BIT_T bf;
} NX10_XMAC_CMP2_STATUS_T;

/* --------------------------------------------------------------------- */
/* Register xmac_cmp3_status */
/* => xMAC Compare3 Status Register */
/* => Mode: R */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX10_xmac_cmp3_status   0x000008DCU
#define Adr_NX10_xmac0_xmac_cmp3_status 0x101A08DCU
#define Adr_NX10_xmac_cmp3_status       0x101A08DCU

#define MSK_NX10_xmac_cmp3_status_rpucnt1_wr0 0x00000001U
#define SRT_NX10_xmac_cmp3_status_rpucnt1_wr0 0
#define MSK_NX10_xmac_cmp3_status_rpucnt1_wr1 0x00000002U
#define SRT_NX10_xmac_cmp3_status_rpucnt1_wr1 1
#define MSK_NX10_xmac_cmp3_status_rpucnt1_wr2 0x00000004U
#define SRT_NX10_xmac_cmp3_status_rpucnt1_wr2 2
#define MSK_NX10_xmac_cmp3_status_rpucnt1_wr3 0x00000008U
#define SRT_NX10_xmac_cmp3_status_rpucnt1_wr3 3
#define MSK_NX10_xmac_cmp3_status_rpucnt1_wr4 0x00000010U
#define SRT_NX10_xmac_cmp3_status_rpucnt1_wr4 4
#define MSK_NX10_xmac_cmp3_status_rpucnt1_wr5 0x00000020U
#define SRT_NX10_xmac_cmp3_status_rpucnt1_wr5 5
#define MSK_NX10_xmac_cmp3_status_rpucnt1_wr6 0x00000040U
#define SRT_NX10_xmac_cmp3_status_rpucnt1_wr6 6
#define MSK_NX10_xmac_cmp3_status_rpucnt1_wr7 0x00000080U
#define SRT_NX10_xmac_cmp3_status_rpucnt1_wr7 7
#define MSK_NX10_xmac_cmp3_status_tpucnt1_wr0 0x00000100U
#define SRT_NX10_xmac_cmp3_status_tpucnt1_wr0 8
#define MSK_NX10_xmac_cmp3_status_tpucnt1_wr1 0x00000200U
#define SRT_NX10_xmac_cmp3_status_tpucnt1_wr1 9
#define MSK_NX10_xmac_cmp3_status_tpucnt1_wr2 0x00000400U
#define SRT_NX10_xmac_cmp3_status_tpucnt1_wr2 10
#define MSK_NX10_xmac_cmp3_status_tpucnt1_wr3 0x00000800U
#define SRT_NX10_xmac_cmp3_status_tpucnt1_wr3 11
#define MSK_NX10_xmac_cmp3_status_tpucnt1_wr4 0x00001000U
#define SRT_NX10_xmac_cmp3_status_tpucnt1_wr4 12
#define MSK_NX10_xmac_cmp3_status_tpucnt1_wr5 0x00002000U
#define SRT_NX10_xmac_cmp3_status_tpucnt1_wr5 13
#define MSK_NX10_xmac_cmp3_status_tpucnt1_wr6 0x00004000U
#define SRT_NX10_xmac_cmp3_status_tpucnt1_wr6 14
#define MSK_NX10_xmac_cmp3_status_tpucnt1_wr7 0x00008000U
#define SRT_NX10_xmac_cmp3_status_tpucnt1_wr7 15

enum {
	BFW_NX10_xmac_cmp3_status_rpucnt1_wr0 = 1,  /* [0] */
	BFW_NX10_xmac_cmp3_status_rpucnt1_wr1 = 1,  /* [1] */
	BFW_NX10_xmac_cmp3_status_rpucnt1_wr2 = 1,  /* [2] */
	BFW_NX10_xmac_cmp3_status_rpucnt1_wr3 = 1,  /* [3] */
	BFW_NX10_xmac_cmp3_status_rpucnt1_wr4 = 1,  /* [4] */
	BFW_NX10_xmac_cmp3_status_rpucnt1_wr5 = 1,  /* [5] */
	BFW_NX10_xmac_cmp3_status_rpucnt1_wr6 = 1,  /* [6] */
	BFW_NX10_xmac_cmp3_status_rpucnt1_wr7 = 1,  /* [7] */
	BFW_NX10_xmac_cmp3_status_tpucnt1_wr0 = 1,  /* [8] */
	BFW_NX10_xmac_cmp3_status_tpucnt1_wr1 = 1,  /* [9] */
	BFW_NX10_xmac_cmp3_status_tpucnt1_wr2 = 1,  /* [10] */
	BFW_NX10_xmac_cmp3_status_tpucnt1_wr3 = 1,  /* [11] */
	BFW_NX10_xmac_cmp3_status_tpucnt1_wr4 = 1,  /* [12] */
	BFW_NX10_xmac_cmp3_status_tpucnt1_wr5 = 1,  /* [13] */
	BFW_NX10_xmac_cmp3_status_tpucnt1_wr6 = 1,  /* [14] */
	BFW_NX10_xmac_cmp3_status_tpucnt1_wr7 = 1,  /* [15] */
	BFW_NX10_xmac_cmp3_status_reserved1   = 16  /* [31:16] */
};

typedef struct NX10_XMAC_CMP3_STATUS_BIT_Ttag {
	unsigned int rpucnt1_wr0 : BFW_NX10_xmac_cmp3_status_rpucnt1_wr0; /* 1: rpu_count1 equals wr0 */
	unsigned int rpucnt1_wr1 : BFW_NX10_xmac_cmp3_status_rpucnt1_wr1; /* 1: rpu_count1 equals wr1 */
	unsigned int rpucnt1_wr2 : BFW_NX10_xmac_cmp3_status_rpucnt1_wr2; /* 1: rpu_count1 equals wr2 */
	unsigned int rpucnt1_wr3 : BFW_NX10_xmac_cmp3_status_rpucnt1_wr3; /* 1: rpu_count1 equals wr3 */
	unsigned int rpucnt1_wr4 : BFW_NX10_xmac_cmp3_status_rpucnt1_wr4; /* 1: rpu_count1 equals wr4 */
	unsigned int rpucnt1_wr5 : BFW_NX10_xmac_cmp3_status_rpucnt1_wr5; /* 1: rpu_count1 equals wr5 */
	unsigned int rpucnt1_wr6 : BFW_NX10_xmac_cmp3_status_rpucnt1_wr6; /* 1: rpu_count1 equals wr6 */
	unsigned int rpucnt1_wr7 : BFW_NX10_xmac_cmp3_status_rpucnt1_wr7; /* 1: rpu_count1 equals wr7 */
	unsigned int tpucnt1_wr0 : BFW_NX10_xmac_cmp3_status_tpucnt1_wr0; /* 1: tpu_count1 equals wr0 */
	unsigned int tpucnt1_wr1 : BFW_NX10_xmac_cmp3_status_tpucnt1_wr1; /* 1: tpu_count1 equals wr1 */
	unsigned int tpucnt1_wr2 : BFW_NX10_xmac_cmp3_status_tpucnt1_wr2; /* 1: tpu_count1 equals wr2 */
	unsigned int tpucnt1_wr3 : BFW_NX10_xmac_cmp3_status_tpucnt1_wr3; /* 1: tpu_count1 equals wr3 */
	unsigned int tpucnt1_wr4 : BFW_NX10_xmac_cmp3_status_tpucnt1_wr4; /* 1: tpu_count1 equals wr4 */
	unsigned int tpucnt1_wr5 : BFW_NX10_xmac_cmp3_status_tpucnt1_wr5; /* 1: tpu_count1 equals wr5 */
	unsigned int tpucnt1_wr6 : BFW_NX10_xmac_cmp3_status_tpucnt1_wr6; /* 1: tpu_count1 equals wr6 */
	unsigned int tpucnt1_wr7 : BFW_NX10_xmac_cmp3_status_tpucnt1_wr7; /* 1: tpu_count1 equals wr7 */
	unsigned int reserved1   : BFW_NX10_xmac_cmp3_status_reserved1;   /* reserved                 */
} NX10_XMAC_CMP3_STATUS_BIT_T;

typedef union {
	unsigned int                val;
	NX10_XMAC_CMP3_STATUS_BIT_T bf;
} NX10_XMAC_CMP3_STATUS_T;

/* --------------------------------------------------------------------- */
/* Register xmac_alu_flags */
/* => xMAC RPU and TPU ALU Flags: */
/*    ALU Flags are only influenced by combinatonal commands like add, sub, rotate, shift. */
/*    Bitwise commands (e.g. and, or, ...) do not influence ALU-Flags. */
/*    In case of bitwise commands, ALU-Flags keep their old value. */
/* => Mode: R */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX10_xmac_alu_flags   0x000008E0U
#define Adr_NX10_xmac0_xmac_alu_flags 0x101A08E0U
#define Adr_NX10_xmac_alu_flags       0x101A08E0U

#define MSK_NX10_xmac_alu_flags_rpu_carry 0x00000001U
#define SRT_NX10_xmac_alu_flags_rpu_carry 0
#define MSK_NX10_xmac_alu_flags_rpu_zero  0x00000002U
#define SRT_NX10_xmac_alu_flags_rpu_zero  1
#define MSK_NX10_xmac_alu_flags_rpu_neg   0x00000004U
#define SRT_NX10_xmac_alu_flags_rpu_neg   2
#define MSK_NX10_xmac_alu_flags_rpu_ovf   0x00000008U
#define SRT_NX10_xmac_alu_flags_rpu_ovf   3
#define MSK_NX10_xmac_alu_flags_tpu_carry 0x00000010U
#define SRT_NX10_xmac_alu_flags_tpu_carry 4
#define MSK_NX10_xmac_alu_flags_tpu_zero  0x00000020U
#define SRT_NX10_xmac_alu_flags_tpu_zero  5
#define MSK_NX10_xmac_alu_flags_tpu_neg   0x00000040U
#define SRT_NX10_xmac_alu_flags_tpu_neg   6
#define MSK_NX10_xmac_alu_flags_tpu_ovf   0x00000080U
#define SRT_NX10_xmac_alu_flags_tpu_ovf   7
#define MSK_NX10_xmac_alu_flags_rxcnt_wr2 0x00004000U
#define SRT_NX10_xmac_alu_flags_rxcnt_wr2 14
#define MSK_NX10_xmac_alu_flags_txcnt_wr7 0x00008000U
#define SRT_NX10_xmac_alu_flags_txcnt_wr7 15

enum {
	BFW_NX10_xmac_alu_flags_rpu_carry = 1,  /* [0] */
	BFW_NX10_xmac_alu_flags_rpu_zero  = 1,  /* [1] */
	BFW_NX10_xmac_alu_flags_rpu_neg   = 1,  /* [2] */
	BFW_NX10_xmac_alu_flags_rpu_ovf   = 1,  /* [3] */
	BFW_NX10_xmac_alu_flags_tpu_carry = 1,  /* [4] */
	BFW_NX10_xmac_alu_flags_tpu_zero  = 1,  /* [5] */
	BFW_NX10_xmac_alu_flags_tpu_neg   = 1,  /* [6] */
	BFW_NX10_xmac_alu_flags_tpu_ovf   = 1,  /* [7] */
	BFW_NX10_xmac_alu_flags_reserved1 = 6,  /* [13:8] */
	BFW_NX10_xmac_alu_flags_rxcnt_wr2 = 1,  /* [14] */
	BFW_NX10_xmac_alu_flags_txcnt_wr7 = 1,  /* [15] */
	BFW_NX10_xmac_alu_flags_reserved2 = 16  /* [31:16] */
};

typedef struct NX10_XMAC_ALU_FLAGS_BIT_Ttag {
	unsigned int rpu_carry : BFW_NX10_xmac_alu_flags_rpu_carry; /* RPU carry flag                                              */
	unsigned int rpu_zero  : BFW_NX10_xmac_alu_flags_rpu_zero;  /* RPU zero flag                                               */
	unsigned int rpu_neg   : BFW_NX10_xmac_alu_flags_rpu_neg;   /* RPU neg flag                                                */
	unsigned int rpu_ovf   : BFW_NX10_xmac_alu_flags_rpu_ovf;   /* RPU ovf flag                                                */
	unsigned int tpu_carry : BFW_NX10_xmac_alu_flags_tpu_carry; /* TPU carry flag                                              */
	unsigned int tpu_zero  : BFW_NX10_xmac_alu_flags_tpu_zero;  /* TPU zero flag                                               */
	unsigned int tpu_neg   : BFW_NX10_xmac_alu_flags_tpu_neg;   /* TPU neg flag                                                */
	unsigned int tpu_ovf   : BFW_NX10_xmac_alu_flags_tpu_ovf;   /* TPU ovf flag                                                */
	unsigned int reserved1 : BFW_NX10_xmac_alu_flags_reserved1; /* reserved                                                    */
	unsigned int rxcnt_wr2 : BFW_NX10_xmac_alu_flags_rxcnt_wr2; /* 1: rx_count equals wr2, no ALU-Flag, calculated every cycle */
	unsigned int txcnt_wr7 : BFW_NX10_xmac_alu_flags_txcnt_wr7; /* 1: tx_count equals wr7, no ALU-Flag, calculated every cycle */
	unsigned int reserved2 : BFW_NX10_xmac_alu_flags_reserved2; /* reserved                                                    */
} NX10_XMAC_ALU_FLAGS_BIT_T;

typedef union {
	unsigned int              val;
	NX10_XMAC_ALU_FLAGS_BIT_T bf;
} NX10_XMAC_ALU_FLAGS_T;

/* --------------------------------------------------------------------- */
/* Register xmac_status_int */
/* => xMAC Status Internal Register */
/* => Mode: R */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX10_xmac_status_int   0x000008E4U
#define Adr_NX10_xmac0_xmac_status_int 0x101A08E4U
#define Adr_NX10_xmac_status_int       0x101A08E4U

#define MSK_NX10_xmac_status_int_rpm_hit0    0x00000001U
#define SRT_NX10_xmac_status_int_rpm_hit0    0
#define MSK_NX10_xmac_status_int_rpm_hit1    0x00000002U
#define SRT_NX10_xmac_status_int_rpm_hit1    1
#define MSK_NX10_xmac_status_int_rpm_hit0or1 0x00000004U
#define SRT_NX10_xmac_status_int_rpm_hit0or1 2
#define MSK_NX10_xmac_status_int_tpm_hit0    0x00000008U
#define SRT_NX10_xmac_status_int_tpm_hit0    3
#define MSK_NX10_xmac_status_int_tpm_hit1    0x00000010U
#define SRT_NX10_xmac_status_int_tpm_hit1    4
#define MSK_NX10_xmac_status_int_tpm_hit0or1 0x00000020U
#define SRT_NX10_xmac_status_int_tpm_hit0or1 5
#define MSK_NX10_xmac_status_int_lbit_eq_bit 0x00000040U
#define SRT_NX10_xmac_status_int_lbit_eq_bit 6
#define MSK_NX10_xmac_status_int_tx_eq_wr45  0x00000080U
#define SRT_NX10_xmac_status_int_tx_eq_wr45  7
#define MSK_NX10_xmac_status_int_rx_crc_ok   0x00000100U
#define SRT_NX10_xmac_status_int_rx_crc_ok   8
#define MSK_NX10_xmac_status_int_tx_crc_ok   0x00000200U
#define SRT_NX10_xmac_status_int_tx_crc_ok   9
#define MSK_NX10_xmac_status_int_rx_crc32_ok 0x00000400U
#define SRT_NX10_xmac_status_int_rx_crc32_ok 10
#define MSK_NX10_xmac_status_int_recbit      0x00000800U
#define SRT_NX10_xmac_status_int_recbit      11
#define MSK_NX10_xmac_status_int_brec        0x00001000U
#define SRT_NX10_xmac_status_int_brec        12
#define MSK_NX10_xmac_status_int_btran       0x00002000U
#define SRT_NX10_xmac_status_int_btran       13
#define MSK_NX10_xmac_status_int_zero        0x00008000U
#define SRT_NX10_xmac_status_int_zero        15

enum {
	BFW_NX10_xmac_status_int_rpm_hit0    = 1,  /* [0] */
	BFW_NX10_xmac_status_int_rpm_hit1    = 1,  /* [1] */
	BFW_NX10_xmac_status_int_rpm_hit0or1 = 1,  /* [2] */
	BFW_NX10_xmac_status_int_tpm_hit0    = 1,  /* [3] */
	BFW_NX10_xmac_status_int_tpm_hit1    = 1,  /* [4] */
	BFW_NX10_xmac_status_int_tpm_hit0or1 = 1,  /* [5] */
	BFW_NX10_xmac_status_int_lbit_eq_bit = 1,  /* [6] */
	BFW_NX10_xmac_status_int_tx_eq_wr45  = 1,  /* [7] */
	BFW_NX10_xmac_status_int_rx_crc_ok   = 1,  /* [8] */
	BFW_NX10_xmac_status_int_tx_crc_ok   = 1,  /* [9] */
	BFW_NX10_xmac_status_int_rx_crc32_ok = 1,  /* [10] */
	BFW_NX10_xmac_status_int_recbit      = 1,  /* [11] */
	BFW_NX10_xmac_status_int_brec        = 1,  /* [12] */
	BFW_NX10_xmac_status_int_btran       = 1,  /* [13] */
	BFW_NX10_xmac_status_int_reserved1   = 1,  /* [14] */
	BFW_NX10_xmac_status_int_zero        = 1,  /* [15] */
	BFW_NX10_xmac_status_int_reserved2   = 16  /* [31:16] */
};

typedef struct NX10_XMAC_STATUS_INT_BIT_Ttag {
	unsigned int rpm_hit0    : BFW_NX10_xmac_status_int_rpm_hit0;    /* receive pattern 0 matches                                */
	unsigned int rpm_hit1    : BFW_NX10_xmac_status_int_rpm_hit1;    /* receive pattern 1 matches                                */
	unsigned int rpm_hit0or1 : BFW_NX10_xmac_status_int_rpm_hit0or1; /* receive pattern 0 or pattern 1 matches                   */
	unsigned int tpm_hit0    : BFW_NX10_xmac_status_int_tpm_hit0;    /* transmit pattern 0 matches                               */
	unsigned int tpm_hit1    : BFW_NX10_xmac_status_int_tpm_hit1;    /* transmit pattern 1 matches                               */
	unsigned int tpm_hit0or1 : BFW_NX10_xmac_status_int_tpm_hit0or1; /* transmit pattern 0 or pattern 1 matches                  */
	unsigned int lbit_eq_bit : BFW_NX10_xmac_status_int_lbit_eq_bit; /* last received bit = actually received bit                */
	unsigned int tx_eq_wr45  : BFW_NX10_xmac_status_int_tx_eq_wr45;  /* compare of tx with wr4(value) and wr5(mask):             */
	                                                                 /* wr5 defines, which bits of tx and wr4 are to be compared */
	unsigned int rx_crc_ok   : BFW_NX10_xmac_status_int_rx_crc_ok;   /* compare of rx_crc_l/_h with wr0/1:                       */
	unsigned int tx_crc_ok   : BFW_NX10_xmac_status_int_tx_crc_ok;   /* compare of tx_crc_l/_h with wr8/9:                       */
	unsigned int rx_crc32_ok : BFW_NX10_xmac_status_int_rx_crc32_ok; /* compare of rx_crc32 with 0xc704dd7b                      */
	unsigned int recbit      : BFW_NX10_xmac_status_int_recbit;      /* acutally received bit                                    */
	unsigned int brec        : BFW_NX10_xmac_status_int_brec;        /* bit received (active for 1 cc)                           */
	unsigned int btran       : BFW_NX10_xmac_status_int_btran;       /* bit transmitted (active for 1 cc)                        */
	unsigned int reserved1   : BFW_NX10_xmac_status_int_reserved1;   /* reserved                                                 */
	unsigned int zero        : BFW_NX10_xmac_status_int_zero;        /* always 0                                                 */
	unsigned int reserved2   : BFW_NX10_xmac_status_int_reserved2;   /* reserved                                                 */
} NX10_XMAC_STATUS_INT_BIT_T;

typedef union {
	unsigned int               val;
	NX10_XMAC_STATUS_INT_BIT_T bf;
} NX10_XMAC_STATUS_INT_T;

/* --------------------------------------------------------------------- */
/* Register xmac_stat_bits */
/* => xMAC stat_bits: */
/*    set and reset by hw_support bits (set_stat and reset_stat) and selected by src1_adr, */
/*    accessible by all RPUs and TPUs with higher set than reset priority */
/* => Mode: R */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX10_xmac_stat_bits   0x000008E8U
#define Adr_NX10_xmac0_xmac_stat_bits 0x101A08E8U
#define Adr_NX10_xmac_stat_bits       0x101A08E8U

#define MSK_NX10_xmac_stat_bits_stat_bits 0x0000ffffU
#define SRT_NX10_xmac_stat_bits_stat_bits 0

enum {
	BFW_NX10_xmac_stat_bits_stat_bits = 16, /* [15:0] */
	BFW_NX10_xmac_stat_bits_reserved1 = 16  /* [31:16] */
};

typedef struct NX10_XMAC_STAT_BITS_BIT_Ttag {
	unsigned int stat_bits : BFW_NX10_xmac_stat_bits_stat_bits; /* seperate bits selected by lower bits of src1_adr, if set_stat/reset_stat are active */
	unsigned int reserved1 : BFW_NX10_xmac_stat_bits_reserved1; /* reserved                                                                            */
} NX10_XMAC_STAT_BITS_BIT_T;

typedef union {
	unsigned int              val;
	NX10_XMAC_STAT_BITS_BIT_T bf;
} NX10_XMAC_STAT_BITS_T;

/* --------------------------------------------------------------------- */
/* Register xmac_status_mii */
/* => xMAC MII receive status register */
/* => Mode: R */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX10_xmac_status_mii   0x000008ECU
#define Adr_NX10_xmac0_xmac_status_mii 0x101A08ECU
#define Adr_NX10_xmac_status_mii       0x101A08ECU

#define MSK_NX10_xmac_status_mii_rx_dv       0x00000001U
#define SRT_NX10_xmac_status_mii_rx_dv       0
#define MSK_NX10_xmac_status_mii_rx_err      0x00000002U
#define SRT_NX10_xmac_status_mii_rx_err      1
#define MSK_NX10_xmac_status_mii_crs         0x00000004U
#define SRT_NX10_xmac_status_mii_crs         2
#define MSK_NX10_xmac_status_mii_col         0x00000008U
#define SRT_NX10_xmac_status_mii_col         3
#define MSK_NX10_xmac_status_mii_s_nc        0x00000010U
#define SRT_NX10_xmac_status_mii_s_nc        4
#define MSK_NX10_xmac_status_mii_v_ne_ns_nc  0x00000020U
#define SRT_NX10_xmac_status_mii_v_ne_ns_nc  5
#define MSK_NX10_xmac_status_mii_v_ne_nc     0x00000040U
#define SRT_NX10_xmac_status_mii_v_ne_nc     6
#define MSK_NX10_xmac_status_mii_v_ne_ns     0x00000080U
#define SRT_NX10_xmac_status_mii_v_ne_ns     7
#define MSK_NX10_xmac_status_mii_v_ne        0x00000100U
#define SRT_NX10_xmac_status_mii_v_ne        8
#define MSK_NX10_xmac_status_mii_v_ne_s_nc   0x00000200U
#define SRT_NX10_xmac_status_mii_v_ne_s_nc   9
#define MSK_NX10_xmac_status_mii_v_ne_s      0x00000400U
#define SRT_NX10_xmac_status_mii_v_ne_s      10
#define MSK_NX10_xmac_status_mii_v_ne_nc_p0  0x00000800U
#define SRT_NX10_xmac_status_mii_v_ne_nc_p0  11
#define MSK_NX10_xmac_status_mii_v_ne_nc_p1  0x00001000U
#define SRT_NX10_xmac_status_mii_v_ne_nc_p1  12
#define MSK_NX10_xmac_status_mii_v_ne_nc_p01 0x00002000U
#define SRT_NX10_xmac_status_mii_v_ne_nc_p01 13

enum {
	BFW_NX10_xmac_status_mii_rx_dv       = 1,  /* [0] */
	BFW_NX10_xmac_status_mii_rx_err      = 1,  /* [1] */
	BFW_NX10_xmac_status_mii_crs         = 1,  /* [2] */
	BFW_NX10_xmac_status_mii_col         = 1,  /* [3] */
	BFW_NX10_xmac_status_mii_s_nc        = 1,  /* [4] */
	BFW_NX10_xmac_status_mii_v_ne_ns_nc  = 1,  /* [5] */
	BFW_NX10_xmac_status_mii_v_ne_nc     = 1,  /* [6] */
	BFW_NX10_xmac_status_mii_v_ne_ns     = 1,  /* [7] */
	BFW_NX10_xmac_status_mii_v_ne        = 1,  /* [8] */
	BFW_NX10_xmac_status_mii_v_ne_s_nc   = 1,  /* [9] */
	BFW_NX10_xmac_status_mii_v_ne_s      = 1,  /* [10] */
	BFW_NX10_xmac_status_mii_v_ne_nc_p0  = 1,  /* [11] */
	BFW_NX10_xmac_status_mii_v_ne_nc_p1  = 1,  /* [12] */
	BFW_NX10_xmac_status_mii_v_ne_nc_p01 = 1,  /* [13] */
	BFW_NX10_xmac_status_mii_reserved1   = 18  /* [31:14] */
};

typedef struct NX10_XMAC_STATUS_MII_BIT_Ttag {
	unsigned int rx_dv       : BFW_NX10_xmac_status_mii_rx_dv;       /* mii data valid                                         */
	unsigned int rx_err      : BFW_NX10_xmac_status_mii_rx_err;      /* mii rx_err                                             */
	unsigned int crs         : BFW_NX10_xmac_status_mii_crs;         /* mii crs                                                */
	unsigned int col         : BFW_NX10_xmac_status_mii_col;         /* mii col                                                */
	unsigned int s_nc        : BFW_NX10_xmac_status_mii_s_nc;        /* crs & !col                                             */
	unsigned int v_ne_ns_nc  : BFW_NX10_xmac_status_mii_v_ne_ns_nc;  /* rx_dv & !rx_err & !crs & !col                          */
	unsigned int v_ne_nc     : BFW_NX10_xmac_status_mii_v_ne_nc;     /* rx_dv & !rx_err &        !col                          */
	unsigned int v_ne_ns     : BFW_NX10_xmac_status_mii_v_ne_ns;     /* rx_dv & !rx_err & !crs                                 */
	unsigned int v_ne        : BFW_NX10_xmac_status_mii_v_ne;        /* rx_dv & !rx_err                                        */
	unsigned int v_ne_s_nc   : BFW_NX10_xmac_status_mii_v_ne_s_nc;   /* rx_dv & !rx_err &  crs & !col                          */
	unsigned int v_ne_s      : BFW_NX10_xmac_status_mii_v_ne_s;      /* rx_dv & !rx_err &  crs                                 */
	unsigned int v_ne_nc_p0  : BFW_NX10_xmac_status_mii_v_ne_nc_p0;  /* rx_dv & !rx_err &        !col &  rpm_hit0              */
	unsigned int v_ne_nc_p1  : BFW_NX10_xmac_status_mii_v_ne_nc_p1;  /* rx_dv & !rx_err &        !col &              rpm_hit1  */
	unsigned int v_ne_nc_p01 : BFW_NX10_xmac_status_mii_v_ne_nc_p01; /* rx_dv & !rx_err &        !col & (rpm_hit0 |  rpm_hit1) */
	unsigned int reserved1   : BFW_NX10_xmac_status_mii_reserved1;   /* reserved                                               */
} NX10_XMAC_STATUS_MII_BIT_T;

typedef union {
	unsigned int               val;
	NX10_XMAC_STATUS_MII_BIT_T bf;
} NX10_XMAC_STATUS_MII_T;

/* --------------------------------------------------------------------- */
/* Register xmac_status_mii2 */
/* => xMAC 2nd MII receive status register */
/* => Mode: R */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX10_xmac_status_mii2   0x000008F0U
#define Adr_NX10_xmac0_xmac_status_mii2 0x101A08F0U
#define Adr_NX10_xmac_status_mii2       0x101A08F0U

#define MSK_NX10_xmac_status_mii2_dv                    0x00000001U
#define SRT_NX10_xmac_status_mii2_dv                    0
#define MSK_NX10_xmac_status_mii2_rx_dv                 0x00000002U
#define SRT_NX10_xmac_status_mii2_rx_dv                 1
#define MSK_NX10_xmac_status_mii2_rx_err                0x00000004U
#define SRT_NX10_xmac_status_mii2_rx_err                2
#define MSK_NX10_xmac_status_mii2_rx_crs                0x00000008U
#define SRT_NX10_xmac_status_mii2_rx_crs                3
#define MSK_NX10_xmac_status_mii2_v_ne                  0x00000010U
#define SRT_NX10_xmac_status_mii2_v_ne                  4
#define MSK_NX10_xmac_status_mii2_rx_miif_error_ro      0x00000020U
#define SRT_NX10_xmac_status_mii2_rx_miif_error_ro      5
#define MSK_NX10_xmac_status_mii2_rx_miif_ovfl_ro       0x00000040U
#define SRT_NX10_xmac_status_mii2_rx_miif_ovfl_ro       6
#define MSK_NX10_xmac_status_mii2_rx_miif_unfl_ro       0x00000080U
#define SRT_NX10_xmac_status_mii2_rx_miif_unfl_ro       7
#define MSK_NX10_xmac_status_mii2_rx_miif_short_dv_ro   0x00000100U
#define SRT_NX10_xmac_status_mii2_rx_miif_short_dv_ro   8
#define MSK_NX10_xmac_status_mii2_tx_miif_error_ro      0x00000200U
#define SRT_NX10_xmac_status_mii2_tx_miif_error_ro      9
#define MSK_NX10_xmac_status_mii2_tx_miif_ovfl_ro       0x00000400U
#define SRT_NX10_xmac_status_mii2_tx_miif_ovfl_ro       10
#define MSK_NX10_xmac_status_mii2_tx_miif_unfl_ro       0x00000800U
#define SRT_NX10_xmac_status_mii2_tx_miif_unfl_ro       11
#define MSK_NX10_xmac_status_mii2_tx_miif_short_txen_ro 0x00001000U
#define SRT_NX10_xmac_status_mii2_tx_miif_short_txen_ro 12
#define MSK_NX10_xmac_status_mii2_rx_err_was_here       0x00002000U
#define SRT_NX10_xmac_status_mii2_rx_err_was_here       13
#define MSK_NX10_xmac_status_mii2_col_was_here          0x00004000U
#define SRT_NX10_xmac_status_mii2_col_was_here          14
#define MSK_NX10_xmac_status_mii2_crs_was_here          0x00008000U
#define SRT_NX10_xmac_status_mii2_crs_was_here          15

enum {
	BFW_NX10_xmac_status_mii2_dv                    = 1,  /* [0] */
	BFW_NX10_xmac_status_mii2_rx_dv                 = 1,  /* [1] */
	BFW_NX10_xmac_status_mii2_rx_err                = 1,  /* [2] */
	BFW_NX10_xmac_status_mii2_rx_crs                = 1,  /* [3] */
	BFW_NX10_xmac_status_mii2_v_ne                  = 1,  /* [4] */
	BFW_NX10_xmac_status_mii2_rx_miif_error_ro      = 1,  /* [5] */
	BFW_NX10_xmac_status_mii2_rx_miif_ovfl_ro       = 1,  /* [6] */
	BFW_NX10_xmac_status_mii2_rx_miif_unfl_ro       = 1,  /* [7] */
	BFW_NX10_xmac_status_mii2_rx_miif_short_dv_ro   = 1,  /* [8] */
	BFW_NX10_xmac_status_mii2_tx_miif_error_ro      = 1,  /* [9] */
	BFW_NX10_xmac_status_mii2_tx_miif_ovfl_ro       = 1,  /* [10] */
	BFW_NX10_xmac_status_mii2_tx_miif_unfl_ro       = 1,  /* [11] */
	BFW_NX10_xmac_status_mii2_tx_miif_short_txen_ro = 1,  /* [12] */
	BFW_NX10_xmac_status_mii2_rx_err_was_here       = 1,  /* [13] */
	BFW_NX10_xmac_status_mii2_col_was_here          = 1,  /* [14] */
	BFW_NX10_xmac_status_mii2_crs_was_here          = 1,  /* [15] */
	BFW_NX10_xmac_status_mii2_reserved1             = 16  /* [31:16] */
};

typedef struct NX10_XMAC_STATUS_MII2_BIT_Ttag {
	unsigned int dv                    : BFW_NX10_xmac_status_mii2_dv;                    /* RX-Nibble-FIFO data valid:                                                                     */
	                                                                                      /* Fifo is automatically filled, if rx_dv=1. This bit gets active, if fifo contains enough data.  */
	unsigned int rx_dv                 : BFW_NX10_xmac_status_mii2_rx_dv;                 /* MII rx_dv before RX_Nibble-FIFO.                                                               */
	                                                                                      /* This bit is a copy of xmac_status_mii-rx_dv.                                                   */
	unsigned int rx_err                : BFW_NX10_xmac_status_mii2_rx_err;                /* MII rx_err before RX_Nibble-FIFO.                                                              */
	                                                                                      /* This bit is a copy of xmac_status_mii-rx_err.                                                  */
	unsigned int rx_crs                : BFW_NX10_xmac_status_mii2_rx_crs;                /* MII crs before RX_Nibble-FIFO.                                                                 */
	                                                                                      /* This bit is a copy of xmac_status_mii-crs.                                                     */
	unsigned int v_ne                  : BFW_NX10_xmac_status_mii2_v_ne;                  /* dv & !rx_err                                                                                   */
	                                                                                      /* Useful, if rx_err has to be checked every cycle by software                                    */
	unsigned int rx_miif_error_ro      : BFW_NX10_xmac_status_mii2_rx_miif_error_ro;      /* Any error at RX-Nibble-FIFO occured,                                                           */
	                                                                                      /* Any error can be tx_miif_short_txen_ro, tx_miif_ovfl_ro or tx_miif_unfl_ro.                    */
	unsigned int rx_miif_ovfl_ro       : BFW_NX10_xmac_status_mii2_rx_miif_ovfl_ro;       /* RX-Nibble-FIFO overflow.                                                                       */
	                                                                                      /* This bit is read only.                                                                         */
	unsigned int rx_miif_unfl_ro       : BFW_NX10_xmac_status_mii2_rx_miif_unfl_ro;       /* RX-Nibble-FIFO underflow.                                                                      */
	                                                                                      /* This bit is read only.                                                                         */
	unsigned int rx_miif_short_dv_ro   : BFW_NX10_xmac_status_mii2_rx_miif_short_dv_ro;   /* RX-Nibble-FIFO error: rx_dv was active or inactive for very short time.                        */
	                                                                                      /* Rx_dv went inactive before FIFO reached fill_level or went active before FIFO was flushed.     */
	unsigned int tx_miif_error_ro      : BFW_NX10_xmac_status_mii2_tx_miif_error_ro;      /* Any error at TX-Nibble-FIFO occured,                                                           */
	                                                                                      /* Any error can be tx_miif_short_txen_ro, tx_miif_ovfl_ro or tx_miif_unfl_ro.                    */
	unsigned int tx_miif_ovfl_ro       : BFW_NX10_xmac_status_mii2_tx_miif_ovfl_ro;       /* TX-Nibble-FIFO overflow.                                                                       */
	                                                                                      /* This bit is read only.                                                                         */
	unsigned int tx_miif_unfl_ro       : BFW_NX10_xmac_status_mii2_tx_miif_unfl_ro;       /* TX-Nibble-FIFO underflow.                                                                      */
	                                                                                      /* This bit is read only.                                                                         */
	unsigned int tx_miif_short_txen_ro : BFW_NX10_xmac_status_mii2_tx_miif_short_txen_ro; /* tx_en was changed too fast:                                                                    */
	                                                                                      /* When setting tx_en=1, it must stay active at least until fifo reaches fill_level (fifo_depth). */
	unsigned int rx_err_was_here       : BFW_NX10_xmac_status_mii2_rx_err_was_here;       /* rx_err was here:                                                                               */
	                                                                                      /* Useful, if rx_err needs only to be checked at end of frame.                                    */
	unsigned int col_was_here          : BFW_NX10_xmac_status_mii2_col_was_here;          /* col was here:                                                                                  */
	                                                                                      /* Useful, if col needs only to be checked at end of frame.                                       */
	unsigned int crs_was_here          : BFW_NX10_xmac_status_mii2_crs_was_here;          /* crs was here:                                                                                  */
	                                                                                      /* Useful, if crs needs only to be checked at end of frame.                                       */
	unsigned int reserved1             : BFW_NX10_xmac_status_mii2_reserved1;             /* reserved                                                                                       */
} NX10_XMAC_STATUS_MII2_BIT_T;

typedef union {
	unsigned int                val;
	NX10_XMAC_STATUS_MII2_BIT_T bf;
} NX10_XMAC_STATUS_MII2_T;

/* --------------------------------------------------------------------- */
/* Register xmac_config_mii */
/* => xMAC MII transmit config register */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX10_xmac_config_mii   0x000008F8U
#define Adr_NX10_xmac0_xmac_config_mii 0x101A08F8U
#define Adr_NX10_xmac_config_mii       0x101A08F8U
#define DFLT_VAL_NX10_xmac_config_mii  0x00000000U

#define MSK_NX10_xmac_config_mii_tx_en       0x00000001U
#define SRT_NX10_xmac_config_mii_tx_en       0
#define DFLT_VAL_NX10_xmac_config_mii_tx_en  0x00000000U
#define MSK_NX10_xmac_config_mii_tx_err      0x00000002U
#define SRT_NX10_xmac_config_mii_tx_err      1
#define DFLT_VAL_NX10_xmac_config_mii_tx_err 0x00000000U

enum {
	BFW_NX10_xmac_config_mii_tx_en     = 1,  /* [0] */
	BFW_NX10_xmac_config_mii_tx_err    = 1,  /* [1] */
	BFW_NX10_xmac_config_mii_reserved1 = 30  /* [31:2] */
};

typedef struct NX10_XMAC_CONFIG_MII_BIT_Ttag {
	unsigned int tx_en     : BFW_NX10_xmac_config_mii_tx_en;     /* mii tx_en                  */
	                                                             /* Synchronized to mii tx_clk */
	unsigned int tx_err    : BFW_NX10_xmac_config_mii_tx_err;    /* mii tx_err                 */
	                                                             /* Synchronized to mii tx_clk */
	unsigned int reserved1 : BFW_NX10_xmac_config_mii_reserved1; /* reserved                   */
} NX10_XMAC_CONFIG_MII_BIT_T;

typedef union {
	unsigned int               val;
	NX10_XMAC_CONFIG_MII_BIT_T bf;
} NX10_XMAC_CONFIG_MII_T;

/* --------------------------------------------------------------------- */
/* Register xmac_config_rx_nibble_fifo */
/* => xMAC RX MII Nibble FIFO config register */
/*    This register has a write pipeline delay of 1 clock cycle */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX10_xmac_config_rx_nibble_fifo   0x000008FCU
#define Adr_NX10_xmac0_xmac_config_rx_nibble_fifo 0x101A08FCU
#define Adr_NX10_xmac_config_rx_nibble_fifo       0x101A08FCU
#define DFLT_VAL_NX10_xmac_config_rx_nibble_fifo  0x00001000U

#define MSK_NX10_xmac_config_rx_nibble_fifo_sample_phase        0x00000007U
#define SRT_NX10_xmac_config_rx_nibble_fifo_sample_phase        0
#define DFLT_VAL_NX10_xmac_config_rx_nibble_fifo_sample_phase   0x00000000U
#define MSK_NX10_xmac_config_rx_nibble_fifo_delay_rx_data       0x00000008U
#define SRT_NX10_xmac_config_rx_nibble_fifo_delay_rx_data       3
#define DFLT_VAL_NX10_xmac_config_rx_nibble_fifo_delay_rx_data  0x00000000U
#define MSK_NX10_xmac_config_rx_nibble_fifo_fifo_depth_add      0x00000030U
#define SRT_NX10_xmac_config_rx_nibble_fifo_fifo_depth_add      4
#define DFLT_VAL_NX10_xmac_config_rx_nibble_fifo_fifo_depth_add 0x00000000U
#define MSK_NX10_xmac_config_rx_nibble_fifo_fifo_depth          0x000003c0U
#define SRT_NX10_xmac_config_rx_nibble_fifo_fifo_depth          6
#define DFLT_VAL_NX10_xmac_config_rx_nibble_fifo_fifo_depth     0x00000000U
#define MSK_NX10_xmac_config_rx_nibble_fifo_rx_write_phase      0x00000c00U
#define SRT_NX10_xmac_config_rx_nibble_fifo_rx_write_phase      10
#define DFLT_VAL_NX10_xmac_config_rx_nibble_fifo_rx_write_phase 0x00000000U
#define MSK_NX10_xmac_config_rx_nibble_fifo_rpu_sync_delay      0x00003000U
#define SRT_NX10_xmac_config_rx_nibble_fifo_rpu_sync_delay      12
#define DFLT_VAL_NX10_xmac_config_rx_nibble_fifo_rpu_sync_delay 0x00001000U

enum {
	BFW_NX10_xmac_config_rx_nibble_fifo_sample_phase   = 3,  /* [2:0] */
	BFW_NX10_xmac_config_rx_nibble_fifo_delay_rx_data  = 1,  /* [3] */
	BFW_NX10_xmac_config_rx_nibble_fifo_fifo_depth_add = 2,  /* [5:4] */
	BFW_NX10_xmac_config_rx_nibble_fifo_fifo_depth     = 4,  /* [9:6] */
	BFW_NX10_xmac_config_rx_nibble_fifo_rx_write_phase = 2,  /* [11:10] */
	BFW_NX10_xmac_config_rx_nibble_fifo_rpu_sync_delay = 2,  /* [13:12] */
	BFW_NX10_xmac_config_rx_nibble_fifo_reserved1      = 18  /* [31:14] */
};

typedef struct NX10_XMAC_CONFIG_RX_NIBBLE_FIFO_BIT_Ttag {
	unsigned int sample_phase   : BFW_NX10_xmac_config_rx_nibble_fifo_sample_phase;   /* Phase of mii_rx_clk, where mii_rx_d, rx_dv, rx_err, crs, col are sampled:                                                                 */
	                                                                                  /* This value is used for input of MII data independant on RX-Nibble-FIFO.                                                                   */
	unsigned int delay_rx_data  : BFW_NX10_xmac_config_rx_nibble_fifo_delay_rx_data;  /* Delay mii inputs (rx_d, rx_dv, rx_err, crs, col) by 1 clockcycle before sampling them.                                                    */
	                                                                                  /* Enable this, if rx_d gets invalid shortly after rx_clk (hold<10ns).                                                                       */
	unsigned int fifo_depth_add : BFW_NX10_xmac_config_rx_nibble_fifo_fifo_depth_add; /* Fill level additional wait cycles                                                                                                         */
	                                                                                  /* Allows to increase the garanteed delay of the fifo in bitclock units instead of full nibbles.                                             */
	unsigned int fifo_depth     : BFW_NX10_xmac_config_rx_nibble_fifo_fifo_depth;     /* Fill level (= number of nibbles) up to which RX-Nibble-FIFO is filled, before reading to rx register starts.                              */
	                                                                                  /* 0 means, RX-Nibble-FIFO is turned off, data is sampled directly to rx register (with jitter), FIFO is reset.                              */
	unsigned int rx_write_phase : BFW_NX10_xmac_config_rx_nibble_fifo_rx_write_phase; /* Phases, in which nibbles from RX-Nibble-FIFO are written to rx register:                                                                  */
	                                                                                  /* If RX-Nibble-FIFO is enabled (fifo_depth!=0), the sync-signal (copies data to rx register) is generated by a counter (instead of rx_clk), */
	unsigned int rpu_sync_delay : BFW_NX10_xmac_config_rx_nibble_fifo_rpu_sync_delay; /* Delay between rx_write_phase and RPU-sync pulse:                                                                                          */
	                                                                                  /* By this value the RPU-sync pulse is delayed by 0, 1, 2 or 3 clockcycles (x10ns).                                                          */
	unsigned int reserved1      : BFW_NX10_xmac_config_rx_nibble_fifo_reserved1;      /* reserved                                                                                                                                  */
} NX10_XMAC_CONFIG_RX_NIBBLE_FIFO_BIT_T;

typedef union {
	unsigned int                          val;
	NX10_XMAC_CONFIG_RX_NIBBLE_FIFO_BIT_T bf;
} NX10_XMAC_CONFIG_RX_NIBBLE_FIFO_T;

/* --------------------------------------------------------------------- */
/* Register xmac_config_tx_nibble_fifo */
/* => xMAC TX NII Nibble FIFO config register */
/*    This register has a write pipeline delay of 1 clock cycle */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX10_xmac_config_tx_nibble_fifo   0x00000900U
#define Adr_NX10_xmac0_xmac_config_tx_nibble_fifo 0x101A0900U
#define Adr_NX10_xmac_config_tx_nibble_fifo       0x101A0900U
#define DFLT_VAL_NX10_xmac_config_tx_nibble_fifo  0x00000000U

#define MSK_NX10_xmac_config_tx_nibble_fifo_output_phase           0x00000007U
#define SRT_NX10_xmac_config_tx_nibble_fifo_output_phase           0
#define DFLT_VAL_NX10_xmac_config_tx_nibble_fifo_output_phase      0x00000000U
#define MSK_NX10_xmac_config_tx_nibble_fifo_fifo_depth_add         0x00000018U
#define SRT_NX10_xmac_config_tx_nibble_fifo_fifo_depth_add         3
#define DFLT_VAL_NX10_xmac_config_tx_nibble_fifo_fifo_depth_add    0x00000000U
#define MSK_NX10_xmac_config_tx_nibble_fifo_fifo_depth             0x000001e0U
#define SRT_NX10_xmac_config_tx_nibble_fifo_fifo_depth             5
#define DFLT_VAL_NX10_xmac_config_tx_nibble_fifo_fifo_depth        0x00000000U
#define MSK_NX10_xmac_config_tx_nibble_fifo_tx_read_phase          0x00000600U
#define SRT_NX10_xmac_config_tx_nibble_fifo_tx_read_phase          9
#define DFLT_VAL_NX10_xmac_config_tx_nibble_fifo_tx_read_phase     0x00000000U
#define MSK_NX10_xmac_config_tx_nibble_fifo_tpu_sync_delay         0x00001800U
#define SRT_NX10_xmac_config_tx_nibble_fifo_tpu_sync_delay         11
#define DFLT_VAL_NX10_xmac_config_tx_nibble_fifo_tpu_sync_delay    0x00000000U
#define MSK_NX10_xmac_config_tx_nibble_fifo_outputedge_tx_clk      0x00002000U
#define SRT_NX10_xmac_config_tx_nibble_fifo_outputedge_tx_clk      13
#define DFLT_VAL_NX10_xmac_config_tx_nibble_fifo_outputedge_tx_clk 0x00000000U

enum {
	BFW_NX10_xmac_config_tx_nibble_fifo_output_phase      = 3,  /* [2:0] */
	BFW_NX10_xmac_config_tx_nibble_fifo_fifo_depth_add    = 2,  /* [4:3] */
	BFW_NX10_xmac_config_tx_nibble_fifo_fifo_depth        = 4,  /* [8:5] */
	BFW_NX10_xmac_config_tx_nibble_fifo_tx_read_phase     = 2,  /* [10:9] */
	BFW_NX10_xmac_config_tx_nibble_fifo_tpu_sync_delay    = 2,  /* [12:11] */
	BFW_NX10_xmac_config_tx_nibble_fifo_outputedge_tx_clk = 1,  /* [13] */
	BFW_NX10_xmac_config_tx_nibble_fifo_reserved1         = 18  /* [31:14] */
};

typedef struct NX10_XMAC_CONFIG_TX_NIBBLE_FIFO_BIT_Ttag {
	unsigned int output_phase      : BFW_NX10_xmac_config_tx_nibble_fifo_output_phase;      /* Phase of mii_tx_clk, where mii_tx_d, tx_en, tx_err outputs are changed in relation to incoming mii_txclk:      */
	                                                                                        /* This value is used for output of MII data independant on TX-Nibble-FIFO.                                       */
	unsigned int fifo_depth_add    : BFW_NX10_xmac_config_tx_nibble_fifo_fifo_depth_add;    /* Fill level additional wait cycles                                                                              */
	                                                                                        /* Allows to increase the garanteed delay of the fifo in bitclock units instead of full nibbles.                  */
	unsigned int fifo_depth        : BFW_NX10_xmac_config_tx_nibble_fifo_fifo_depth;        /* Fill level (= number of nibbles) up to which TX-Nibble-FIFO is filled, before output to external pins starts.  */
	                                                                                        /* 0 means, TX-Nibble-FIFO is turned off, data is sampled directly from tx register (with jitter), FIFO is reset. */
	unsigned int tx_read_phase     : BFW_NX10_xmac_config_tx_nibble_fifo_tx_read_phase;     /* TX register read phase:                                                                                        */
	                                                                                        /* If TX-Nibble-FIFO is enabled (fifo_depth!=0), TX-register is only dependant on a global 2-bit-counter.         */
	unsigned int tpu_sync_delay    : BFW_NX10_xmac_config_tx_nibble_fifo_tpu_sync_delay;    /* Delay between read of TX-register and TPU-sync pulse:                                                          */
	                                                                                        /* By this value the TPU-sync pulse is delayed by 0, 1, 2 or 3 clockcycles (x10ns).                               */
	unsigned int outputedge_tx_clk : BFW_NX10_xmac_config_tx_nibble_fifo_outputedge_tx_clk; /* MII output data is changed (active for 1cc)                                                                    */
	unsigned int reserved1         : BFW_NX10_xmac_config_tx_nibble_fifo_reserved1;         /* reserved                                                                                                       */
} NX10_XMAC_CONFIG_TX_NIBBLE_FIFO_BIT_T;

typedef union {
	unsigned int                          val;
	NX10_XMAC_CONFIG_TX_NIBBLE_FIFO_BIT_T bf;
} NX10_XMAC_CONFIG_TX_NIBBLE_FIFO_T;

/* --------------------------------------------------------------------- */
/* Register xmac_config_sbu */
/* => xMAC Config Register for SBU */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX10_xmac_config_sbu   0x00000904U
#define Adr_NX10_xmac0_xmac_config_sbu 0x101A0904U
#define Adr_NX10_xmac_config_sbu       0x101A0904U
#define DFLT_VAL_NX10_xmac_config_sbu  0x00000080U

#define MSK_NX10_xmac_config_sbu_sync_to_eclk           0x00000001U
#define SRT_NX10_xmac_config_sbu_sync_to_eclk           0
#define DFLT_VAL_NX10_xmac_config_sbu_sync_to_eclk      0x00000000U
#define MSK_NX10_xmac_config_sbu_sync_to_bitstream      0x00000002U
#define SRT_NX10_xmac_config_sbu_sync_to_bitstream      1
#define DFLT_VAL_NX10_xmac_config_sbu_sync_to_bitstream 0x00000000U
#define MSK_NX10_xmac_config_sbu_sync_to_posedge        0x00000004U
#define SRT_NX10_xmac_config_sbu_sync_to_posedge        2
#define DFLT_VAL_NX10_xmac_config_sbu_sync_to_posedge   0x00000000U
#define MSK_NX10_xmac_config_sbu_sync_to_negedge        0x00000008U
#define SRT_NX10_xmac_config_sbu_sync_to_negedge        3
#define DFLT_VAL_NX10_xmac_config_sbu_sync_to_negedge   0x00000000U
#define MSK_NX10_xmac_config_sbu_count_modulo           0x00000010U
#define SRT_NX10_xmac_config_sbu_count_modulo           4
#define DFLT_VAL_NX10_xmac_config_sbu_count_modulo      0x00000000U
#define MSK_NX10_xmac_config_sbu_invert_bit             0x00000020U
#define SRT_NX10_xmac_config_sbu_invert_bit             5
#define DFLT_VAL_NX10_xmac_config_sbu_invert_bit        0x00000000U
#define MSK_NX10_xmac_config_sbu_predivide_clk          0x00000040U
#define SRT_NX10_xmac_config_sbu_predivide_clk          6
#define DFLT_VAL_NX10_xmac_config_sbu_predivide_clk     0x00000000U
#define MSK_NX10_xmac_config_sbu_phy_led_en             0x00000080U
#define SRT_NX10_xmac_config_sbu_phy_led_en             7
#define DFLT_VAL_NX10_xmac_config_sbu_phy_led_en        0x00000080U
#define MSK_NX10_xmac_config_sbu_ext_mode               0x00000300U
#define SRT_NX10_xmac_config_sbu_ext_mode               8
#define DFLT_VAL_NX10_xmac_config_sbu_ext_mode          0x00000000U
#define MSK_NX10_xmac_config_sbu_rx_err_low_active      0x00000400U
#define SRT_NX10_xmac_config_sbu_rx_err_low_active      10
#define DFLT_VAL_NX10_xmac_config_sbu_rx_err_low_active 0x00000000U
#define MSK_NX10_xmac_config_sbu_rx_err_reset           0x00000800U
#define SRT_NX10_xmac_config_sbu_rx_err_reset           11
#define DFLT_VAL_NX10_xmac_config_sbu_rx_err_reset      0x00000000U
#define MSK_NX10_xmac_config_sbu_col_low_active         0x00001000U
#define SRT_NX10_xmac_config_sbu_col_low_active         12
#define DFLT_VAL_NX10_xmac_config_sbu_col_low_active    0x00000000U
#define MSK_NX10_xmac_config_sbu_col_reset              0x00002000U
#define SRT_NX10_xmac_config_sbu_col_reset              13
#define DFLT_VAL_NX10_xmac_config_sbu_col_reset         0x00000000U
#define MSK_NX10_xmac_config_sbu_crs_low_active         0x00004000U
#define SRT_NX10_xmac_config_sbu_crs_low_active         14
#define DFLT_VAL_NX10_xmac_config_sbu_crs_low_active    0x00000000U
#define MSK_NX10_xmac_config_sbu_crs_reset              0x00008000U
#define SRT_NX10_xmac_config_sbu_crs_reset              15
#define DFLT_VAL_NX10_xmac_config_sbu_crs_reset         0x00000000U

enum {
	BFW_NX10_xmac_config_sbu_sync_to_eclk      = 1,  /* [0] */
	BFW_NX10_xmac_config_sbu_sync_to_bitstream = 1,  /* [1] */
	BFW_NX10_xmac_config_sbu_sync_to_posedge   = 1,  /* [2] */
	BFW_NX10_xmac_config_sbu_sync_to_negedge   = 1,  /* [3] */
	BFW_NX10_xmac_config_sbu_count_modulo      = 1,  /* [4] */
	BFW_NX10_xmac_config_sbu_invert_bit        = 1,  /* [5] */
	BFW_NX10_xmac_config_sbu_predivide_clk     = 1,  /* [6] */
	BFW_NX10_xmac_config_sbu_phy_led_en        = 1,  /* [7] */
	BFW_NX10_xmac_config_sbu_ext_mode          = 2,  /* [9:8] */
	BFW_NX10_xmac_config_sbu_rx_err_low_active = 1,  /* [10] */
	BFW_NX10_xmac_config_sbu_rx_err_reset      = 1,  /* [11] */
	BFW_NX10_xmac_config_sbu_col_low_active    = 1,  /* [12] */
	BFW_NX10_xmac_config_sbu_col_reset         = 1,  /* [13] */
	BFW_NX10_xmac_config_sbu_crs_low_active    = 1,  /* [14] */
	BFW_NX10_xmac_config_sbu_crs_reset         = 1,  /* [15] */
	BFW_NX10_xmac_config_sbu_reserved1         = 16  /* [31:16] */
};

typedef struct NX10_XMAC_CONFIG_SBU_BIT_Ttag {
	unsigned int sync_to_eclk      : BFW_NX10_xmac_config_sbu_sync_to_eclk;      /* Synchronize rate_multiplier to external clock,                                          */
	                                                                             /* rate_mul is set to rate_mul_start at pos/negedge of eclk                                */
	unsigned int sync_to_bitstream : BFW_NX10_xmac_config_sbu_sync_to_bitstream; /* Synchronize rate_multiplier to data_in,                                                 */
	                                                                             /* rate_mul is set to rate_mul_start at pos/negedge of data_in                             */
	unsigned int sync_to_posedge   : BFW_NX10_xmac_config_sbu_sync_to_posedge;   /* Synchronization of rate_multiplier works on positive edges of data_in/eclk              */
	unsigned int sync_to_negedge   : BFW_NX10_xmac_config_sbu_sync_to_negedge;   /* Synchronization of rate_multiplier works on negative edges of data_in/eclk              */
	unsigned int count_modulo      : BFW_NX10_xmac_config_sbu_count_modulo;      /* rate_multiplier continues counting after maximum value is reached                       */
	unsigned int invert_bit        : BFW_NX10_xmac_config_sbu_invert_bit;        /* Invert incoming bit (only in bitstream mode).                                           */
	                                                                             /* This register does not influence Syncronization (sync_to_bitstream),                    */
	unsigned int predivide_clk     : BFW_NX10_xmac_config_sbu_predivide_clk;     /* use a clock frequency divided by 256                                                    */
	unsigned int phy_led_en        : BFW_NX10_xmac_config_sbu_phy_led_en;        /* switch between GPIO 2..5 and PHY LED signals of internal PHYs in status_shared register */
	                                                                             /* 1: use PHY LED inputs for xmac_status_shared[15:12]                                     */
	unsigned int ext_mode          : BFW_NX10_xmac_config_sbu_ext_mode;          /* 00 single bit, 01 mii, 10,11 reserved                                                   */
	unsigned int rx_err_low_active : BFW_NX10_xmac_config_sbu_rx_err_low_active; /* to generate rx_err_was_here signal:                                                     */
	                                                                             /* 0: activate rx_err_was_here if rx_err=1,                                                */
	unsigned int rx_err_reset      : BFW_NX10_xmac_config_sbu_rx_err_reset;      /* to reset rx_err_was_here signal                                                         */
	unsigned int col_low_active    : BFW_NX10_xmac_config_sbu_col_low_active;    /* to generate col_was_here signal:                                                        */
	                                                                             /* 0: activate col_was_here if col=1,                                                      */
	unsigned int col_reset         : BFW_NX10_xmac_config_sbu_col_reset;         /* to reset col_was_here signal                                                            */
	unsigned int crs_low_active    : BFW_NX10_xmac_config_sbu_crs_low_active;    /* to generate crs_was_here signal:                                                        */
	                                                                             /* 0: activate crs_was_here if crs=1,                                                      */
	unsigned int crs_reset         : BFW_NX10_xmac_config_sbu_crs_reset;         /* to reset crs_was_here signal                                                            */
	unsigned int reserved1         : BFW_NX10_xmac_config_sbu_reserved1;         /* reserved                                                                                */
} NX10_XMAC_CONFIG_SBU_BIT_T;

typedef union {
	unsigned int               val;
	NX10_XMAC_CONFIG_SBU_BIT_T bf;
} NX10_XMAC_CONFIG_SBU_T;

/* --------------------------------------------------------------------- */
/* Register xmac_sbu_rate_mul_add */
/* => xMAC SBU rate_mul_add: */
/*    Value added each cc to Rate Multiplier. */
/*    rate_mul_add = eclk / clk * 65536 */
/*    This register has a write pipeline delay of 1 clock cycle */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX10_xmac_sbu_rate_mul_add   0x00000908U
#define Adr_NX10_xmac0_xmac_sbu_rate_mul_add 0x101A0908U
#define Adr_NX10_xmac_sbu_rate_mul_add       0x101A0908U
#define DFLT_VAL_NX10_xmac_sbu_rate_mul_add  0x00000001U

#define MSK_NX10_xmac_sbu_rate_mul_add_rate_mul_add      0x0000ffffU
#define SRT_NX10_xmac_sbu_rate_mul_add_rate_mul_add      0
#define DFLT_VAL_NX10_xmac_sbu_rate_mul_add_rate_mul_add 0x00000001U

enum {
	BFW_NX10_xmac_sbu_rate_mul_add_rate_mul_add = 16, /* [15:0] */
	BFW_NX10_xmac_sbu_rate_mul_add_reserved1    = 16  /* [31:16] */
};

typedef struct NX10_XMAC_SBU_RATE_MUL_ADD_BIT_Ttag {
	unsigned int rate_mul_add : BFW_NX10_xmac_sbu_rate_mul_add_rate_mul_add; /* Value added each cc to Rate Multiplier.                             */
	                                                                         /* If rate_mul_add=1:      rate_mul counts from [rate_mul_start:65535] */
	unsigned int reserved1    : BFW_NX10_xmac_sbu_rate_mul_add_reserved1;    /* reserved                                                            */
} NX10_XMAC_SBU_RATE_MUL_ADD_BIT_T;

typedef union {
	unsigned int                     val;
	NX10_XMAC_SBU_RATE_MUL_ADD_BIT_T bf;
} NX10_XMAC_SBU_RATE_MUL_ADD_T;

/* --------------------------------------------------------------------- */
/* Register xmac_sbu_rate_mul_start */
/* => xMAC SBU rate_mul_start */
/*    This register has a write pipeline delay of 1 clock cycle */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX10_xmac_sbu_rate_mul_start   0x0000090CU
#define Adr_NX10_xmac0_xmac_sbu_rate_mul_start 0x101A090CU
#define Adr_NX10_xmac_sbu_rate_mul_start       0x101A090CU
#define DFLT_VAL_NX10_xmac_sbu_rate_mul_start  0x00000000U

#define MSK_NX10_xmac_sbu_rate_mul_start_rate_mul_start      0x0000ffffU
#define SRT_NX10_xmac_sbu_rate_mul_start_rate_mul_start      0
#define DFLT_VAL_NX10_xmac_sbu_rate_mul_start_rate_mul_start 0x00000000U

enum {
	BFW_NX10_xmac_sbu_rate_mul_start_rate_mul_start = 16, /* [15:0] */
	BFW_NX10_xmac_sbu_rate_mul_start_reserved1      = 16  /* [31:16] */
};

typedef struct NX10_XMAC_SBU_RATE_MUL_START_BIT_Ttag {
	unsigned int rate_mul_start : BFW_NX10_xmac_sbu_rate_mul_start_rate_mul_start; /* Value, the Rate Multiplier is set to at sync */
	unsigned int reserved1      : BFW_NX10_xmac_sbu_rate_mul_start_reserved1;      /* reserved                                     */
} NX10_XMAC_SBU_RATE_MUL_START_BIT_T;

typedef union {
	unsigned int                       val;
	NX10_XMAC_SBU_RATE_MUL_START_BIT_T bf;
} NX10_XMAC_SBU_RATE_MUL_START_T;

/* --------------------------------------------------------------------- */
/* Register xmac_sbu_rate_mul */
/* => xMAC SBU rate_mul */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX10_xmac_sbu_rate_mul   0x00000910U
#define Adr_NX10_xmac0_xmac_sbu_rate_mul 0x101A0910U
#define Adr_NX10_xmac_sbu_rate_mul       0x101A0910U
#define DFLT_VAL_NX10_xmac_sbu_rate_mul  0x0000ffffU

#define MSK_NX10_xmac_sbu_rate_mul_rate_mul      0x0000ffffU
#define SRT_NX10_xmac_sbu_rate_mul_rate_mul      0
#define DFLT_VAL_NX10_xmac_sbu_rate_mul_rate_mul 0x0000ffffU

enum {
	BFW_NX10_xmac_sbu_rate_mul_rate_mul  = 16, /* [15:0] */
	BFW_NX10_xmac_sbu_rate_mul_reserved1 = 16  /* [31:16] */
};

typedef struct NX10_XMAC_SBU_RATE_MUL_BIT_Ttag {
	unsigned int rate_mul  : BFW_NX10_xmac_sbu_rate_mul_rate_mul;  /* current value of Rate Multiplier */
	unsigned int reserved1 : BFW_NX10_xmac_sbu_rate_mul_reserved1; /* reserved                         */
} NX10_XMAC_SBU_RATE_MUL_BIT_T;

typedef union {
	unsigned int                 val;
	NX10_XMAC_SBU_RATE_MUL_BIT_T bf;
} NX10_XMAC_SBU_RATE_MUL_T;

/* --------------------------------------------------------------------- */
/* Register xmac_start_sample_pos */
/* => xMAC SBU start_sample_pos */
/*    This register has a write pipeline delay of 1 clock cycle */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX10_xmac_start_sample_pos   0x00000914U
#define Adr_NX10_xmac0_xmac_start_sample_pos 0x101A0914U
#define Adr_NX10_xmac_start_sample_pos       0x101A0914U
#define DFLT_VAL_NX10_xmac_start_sample_pos  0x00000000U

#define MSK_NX10_xmac_start_sample_pos_start_sample_pos      0x0000ffffU
#define SRT_NX10_xmac_start_sample_pos_start_sample_pos      0
#define DFLT_VAL_NX10_xmac_start_sample_pos_start_sample_pos 0x00000000U

enum {
	BFW_NX10_xmac_start_sample_pos_start_sample_pos = 16, /* [15:0] */
	BFW_NX10_xmac_start_sample_pos_reserved1        = 16  /* [31:16] */
};

typedef struct NX10_XMAC_START_SAMPLE_POS_BIT_Ttag {
	unsigned int start_sample_pos : BFW_NX10_xmac_start_sample_pos_start_sample_pos; /* data is sampled and averaged if start_sample_pos <= rate_mul < stop_sample_pos */
	unsigned int reserved1        : BFW_NX10_xmac_start_sample_pos_reserved1;        /* reserved                                                                       */
} NX10_XMAC_START_SAMPLE_POS_BIT_T;

typedef union {
	unsigned int                     val;
	NX10_XMAC_START_SAMPLE_POS_BIT_T bf;
} NX10_XMAC_START_SAMPLE_POS_T;

/* --------------------------------------------------------------------- */
/* Register xmac_stop_sample_pos */
/* => xMAC SBU stop_sample_pos */
/*    This register has a write pipeline delay of 1 clock cycle */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX10_xmac_stop_sample_pos   0x00000918U
#define Adr_NX10_xmac0_xmac_stop_sample_pos 0x101A0918U
#define Adr_NX10_xmac_stop_sample_pos       0x101A0918U
#define DFLT_VAL_NX10_xmac_stop_sample_pos  0x00000000U

#define MSK_NX10_xmac_stop_sample_pos_stop_sample_pos      0x0000ffffU
#define SRT_NX10_xmac_stop_sample_pos_stop_sample_pos      0
#define DFLT_VAL_NX10_xmac_stop_sample_pos_stop_sample_pos 0x00000000U

enum {
	BFW_NX10_xmac_stop_sample_pos_stop_sample_pos = 16, /* [15:0] */
	BFW_NX10_xmac_stop_sample_pos_reserved1       = 16  /* [31:16] */
};

typedef struct NX10_XMAC_STOP_SAMPLE_POS_BIT_Ttag {
	unsigned int stop_sample_pos : BFW_NX10_xmac_stop_sample_pos_stop_sample_pos; /* data is sampled and averaged if start_sample_pos <= rate_mul < stop_sample_pos */
	unsigned int reserved1       : BFW_NX10_xmac_stop_sample_pos_reserved1;       /* reserved                                                                       */
} NX10_XMAC_STOP_SAMPLE_POS_BIT_T;

typedef union {
	unsigned int                    val;
	NX10_XMAC_STOP_SAMPLE_POS_BIT_T bf;
} NX10_XMAC_STOP_SAMPLE_POS_T;

/* --------------------------------------------------------------------- */
/* Register xmac_config_obu */
/* => xMAC Config Register for OBU */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX10_xmac_config_obu   0x0000091CU
#define Adr_NX10_xmac0_xmac_config_obu 0x101A091CU
#define Adr_NX10_xmac_config_obu       0x101A091CU
#define DFLT_VAL_NX10_xmac_config_obu  0x00000180U

#define MSK_NX10_xmac_config_obu_sync_to_eclk               0x00000001U
#define SRT_NX10_xmac_config_obu_sync_to_eclk               0
#define DFLT_VAL_NX10_xmac_config_obu_sync_to_eclk          0x00000000U
#define MSK_NX10_xmac_config_obu_sync_to_bitstream          0x00000002U
#define SRT_NX10_xmac_config_obu_sync_to_bitstream          1
#define DFLT_VAL_NX10_xmac_config_obu_sync_to_bitstream     0x00000000U
#define MSK_NX10_xmac_config_obu_sync_to_posedge            0x00000004U
#define SRT_NX10_xmac_config_obu_sync_to_posedge            2
#define DFLT_VAL_NX10_xmac_config_obu_sync_to_posedge       0x00000000U
#define MSK_NX10_xmac_config_obu_sync_to_negedge            0x00000008U
#define SRT_NX10_xmac_config_obu_sync_to_negedge            3
#define DFLT_VAL_NX10_xmac_config_obu_sync_to_negedge       0x00000000U
#define MSK_NX10_xmac_config_obu_count_modulo               0x00000010U
#define SRT_NX10_xmac_config_obu_count_modulo               4
#define DFLT_VAL_NX10_xmac_config_obu_count_modulo          0x00000000U
#define MSK_NX10_xmac_config_obu_invert_tx_oe               0x00000020U
#define SRT_NX10_xmac_config_obu_invert_tx_oe               5
#define DFLT_VAL_NX10_xmac_config_obu_invert_tx_oe          0x00000000U
#define MSK_NX10_xmac_config_obu_predivide_clk              0x00000040U
#define SRT_NX10_xmac_config_obu_predivide_clk              6
#define DFLT_VAL_NX10_xmac_config_obu_predivide_clk         0x00000000U
#define MSK_NX10_xmac_config_obu_tx_three_state             0x00000080U
#define SRT_NX10_xmac_config_obu_tx_three_state             7
#define DFLT_VAL_NX10_xmac_config_obu_tx_three_state        0x00000080U
#define MSK_NX10_xmac_config_obu_eclk_noe                   0x00000100U
#define SRT_NX10_xmac_config_obu_eclk_noe                   8
#define DFLT_VAL_NX10_xmac_config_obu_eclk_noe              0x00000100U
#define MSK_NX10_xmac_config_obu_sample_bitstream_eclk      0x00000200U
#define SRT_NX10_xmac_config_obu_sample_bitstream_eclk      9
#define DFLT_VAL_NX10_xmac_config_obu_sample_bitstream_eclk 0x00000000U

enum {
	BFW_NX10_xmac_config_obu_sync_to_eclk          = 1,  /* [0] */
	BFW_NX10_xmac_config_obu_sync_to_bitstream     = 1,  /* [1] */
	BFW_NX10_xmac_config_obu_sync_to_posedge       = 1,  /* [2] */
	BFW_NX10_xmac_config_obu_sync_to_negedge       = 1,  /* [3] */
	BFW_NX10_xmac_config_obu_count_modulo          = 1,  /* [4] */
	BFW_NX10_xmac_config_obu_invert_tx_oe          = 1,  /* [5] */
	BFW_NX10_xmac_config_obu_predivide_clk         = 1,  /* [6] */
	BFW_NX10_xmac_config_obu_tx_three_state        = 1,  /* [7] */
	BFW_NX10_xmac_config_obu_eclk_noe              = 1,  /* [8] */
	BFW_NX10_xmac_config_obu_sample_bitstream_eclk = 1,  /* [9] */
	BFW_NX10_xmac_config_obu_reserved1             = 22  /* [31:10] */
};

typedef struct NX10_XMAC_CONFIG_OBU_BIT_Ttag {
	unsigned int sync_to_eclk          : BFW_NX10_xmac_config_obu_sync_to_eclk;          /* Synchronize rate_multiplier to external clock,                                      */
	                                                                                     /* rate_mul is set to rate_mul_start at pos/negedge of eclk                            */
	unsigned int sync_to_bitstream     : BFW_NX10_xmac_config_obu_sync_to_bitstream;     /* Synchronize rate_multiplier to data_in,                                             */
	                                                                                     /* rate_mul is set to rate_mul_start at pos/negedge of data_in                         */
	unsigned int sync_to_posedge       : BFW_NX10_xmac_config_obu_sync_to_posedge;       /* Synchronization of rate_multiplier works on positive edges of data_in/eclk          */
	unsigned int sync_to_negedge       : BFW_NX10_xmac_config_obu_sync_to_negedge;       /* Synchronization of rate_multiplier works on negative edges of data_in/eclk          */
	unsigned int count_modulo          : BFW_NX10_xmac_config_obu_count_modulo;          /* rate_multiplier continues counting after maximum value is reached                   */
	unsigned int invert_tx_oe          : BFW_NX10_xmac_config_obu_invert_tx_oe;          /* Invert outgoing tx_bit_oe:                                                          */
	                                                                                     /* Only the output_enable going to pad tx_bit_oe (mii_txen) is inverted,               */
	unsigned int predivide_clk         : BFW_NX10_xmac_config_obu_predivide_clk;         /* use a clock frequency divided by 256                                                */
	unsigned int tx_three_state        : BFW_NX10_xmac_config_obu_tx_three_state;        /* deactivates output enable of actually transmitted bit (or nibble in mii-mode)       */
	unsigned int eclk_noe              : BFW_NX10_xmac_config_obu_eclk_noe;              /* inv. output enable of eclk: 0: eclk generated by xMAC, 1: eclk coming from external */
	unsigned int sample_bitstream_eclk : BFW_NX10_xmac_config_obu_sample_bitstream_eclk; /* 1: sample outgoing bitstream and its oe with eclk (posedge).                        */
	unsigned int reserved1             : BFW_NX10_xmac_config_obu_reserved1;             /* reserved                                                                            */
} NX10_XMAC_CONFIG_OBU_BIT_T;

typedef union {
	unsigned int               val;
	NX10_XMAC_CONFIG_OBU_BIT_T bf;
} NX10_XMAC_CONFIG_OBU_T;

/* --------------------------------------------------------------------- */
/* Register xmac_obu_rate_mul_add */
/* => xMAC OBU rate_mul_add: */
/*    Value added each cc to Rate Multiplier. */
/*    rate_mul_add = eclk / clk * 65536 */
/*    This register has a write pipeline delay of 1 clock cycle */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX10_xmac_obu_rate_mul_add   0x00000920U
#define Adr_NX10_xmac0_xmac_obu_rate_mul_add 0x101A0920U
#define Adr_NX10_xmac_obu_rate_mul_add       0x101A0920U
#define DFLT_VAL_NX10_xmac_obu_rate_mul_add  0x00000001U

#define MSK_NX10_xmac_obu_rate_mul_add_rate_mul_add      0x0000ffffU
#define SRT_NX10_xmac_obu_rate_mul_add_rate_mul_add      0
#define DFLT_VAL_NX10_xmac_obu_rate_mul_add_rate_mul_add 0x00000001U

enum {
	BFW_NX10_xmac_obu_rate_mul_add_rate_mul_add = 16, /* [15:0] */
	BFW_NX10_xmac_obu_rate_mul_add_reserved1    = 16  /* [31:16] */
};

typedef struct NX10_XMAC_OBU_RATE_MUL_ADD_BIT_Ttag {
	unsigned int rate_mul_add : BFW_NX10_xmac_obu_rate_mul_add_rate_mul_add; /* Value added each cc to Rate Multiplier.                             */
	                                                                         /* If rate_mul_add=1:      rate_mul counts from [rate_mul_start:65535] */
	unsigned int reserved1    : BFW_NX10_xmac_obu_rate_mul_add_reserved1;    /* reserved                                                            */
} NX10_XMAC_OBU_RATE_MUL_ADD_BIT_T;

typedef union {
	unsigned int                     val;
	NX10_XMAC_OBU_RATE_MUL_ADD_BIT_T bf;
} NX10_XMAC_OBU_RATE_MUL_ADD_T;

/* --------------------------------------------------------------------- */
/* Register xmac_obu_rate_mul_start */
/* => xMAC OBU rate_mul_start */
/*    This register has a write pipeline delay of 1 clock cycle */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX10_xmac_obu_rate_mul_start   0x00000924U
#define Adr_NX10_xmac0_xmac_obu_rate_mul_start 0x101A0924U
#define Adr_NX10_xmac_obu_rate_mul_start       0x101A0924U
#define DFLT_VAL_NX10_xmac_obu_rate_mul_start  0x00000000U

#define MSK_NX10_xmac_obu_rate_mul_start_rate_mul_start      0x0000ffffU
#define SRT_NX10_xmac_obu_rate_mul_start_rate_mul_start      0
#define DFLT_VAL_NX10_xmac_obu_rate_mul_start_rate_mul_start 0x00000000U

enum {
	BFW_NX10_xmac_obu_rate_mul_start_rate_mul_start = 16, /* [15:0] */
	BFW_NX10_xmac_obu_rate_mul_start_reserved1      = 16  /* [31:16] */
};

typedef struct NX10_XMAC_OBU_RATE_MUL_START_BIT_Ttag {
	unsigned int rate_mul_start : BFW_NX10_xmac_obu_rate_mul_start_rate_mul_start; /* Value, the Rate Multiplier is set to at sync */
	unsigned int reserved1      : BFW_NX10_xmac_obu_rate_mul_start_reserved1;      /* reserved                                     */
} NX10_XMAC_OBU_RATE_MUL_START_BIT_T;

typedef union {
	unsigned int                       val;
	NX10_XMAC_OBU_RATE_MUL_START_BIT_T bf;
} NX10_XMAC_OBU_RATE_MUL_START_T;

/* --------------------------------------------------------------------- */
/* Register xmac_obu_rate_mul */
/* => xMAC OBU rate_mul */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX10_xmac_obu_rate_mul   0x00000928U
#define Adr_NX10_xmac0_xmac_obu_rate_mul 0x101A0928U
#define Adr_NX10_xmac_obu_rate_mul       0x101A0928U
#define DFLT_VAL_NX10_xmac_obu_rate_mul  0x0000ffffU

#define MSK_NX10_xmac_obu_rate_mul_rate_mul      0x0000ffffU
#define SRT_NX10_xmac_obu_rate_mul_rate_mul      0
#define DFLT_VAL_NX10_xmac_obu_rate_mul_rate_mul 0x0000ffffU

enum {
	BFW_NX10_xmac_obu_rate_mul_rate_mul  = 16, /* [15:0] */
	BFW_NX10_xmac_obu_rate_mul_reserved1 = 16  /* [31:16] */
};

typedef struct NX10_XMAC_OBU_RATE_MUL_BIT_Ttag {
	unsigned int rate_mul  : BFW_NX10_xmac_obu_rate_mul_rate_mul;  /* current value of Rate Multiplier */
	unsigned int reserved1 : BFW_NX10_xmac_obu_rate_mul_reserved1; /* reserved                         */
} NX10_XMAC_OBU_RATE_MUL_BIT_T;

typedef union {
	unsigned int                 val;
	NX10_XMAC_OBU_RATE_MUL_BIT_T bf;
} NX10_XMAC_OBU_RATE_MUL_T;

/* --------------------------------------------------------------------- */
/* Register xmac_start_trans_pos */
/* => xMAC SBU start_trans_pos */
/*    This register has a write pipeline delay of 1 clock cycle */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX10_xmac_start_trans_pos   0x0000092CU
#define Adr_NX10_xmac0_xmac_start_trans_pos 0x101A092CU
#define Adr_NX10_xmac_start_trans_pos       0x101A092CU
#define DFLT_VAL_NX10_xmac_start_trans_pos  0x00000000U

#define MSK_NX10_xmac_start_trans_pos_start_trans_pos      0x0000ffffU
#define SRT_NX10_xmac_start_trans_pos_start_trans_pos      0
#define DFLT_VAL_NX10_xmac_start_trans_pos_start_trans_pos 0x00000000U

enum {
	BFW_NX10_xmac_start_trans_pos_start_trans_pos = 16, /* [15:0] */
	BFW_NX10_xmac_start_trans_pos_reserved1       = 16  /* [31:16] */
};

typedef struct NX10_XMAC_START_TRANS_POS_BIT_Ttag {
	unsigned int start_trans_pos : BFW_NX10_xmac_start_trans_pos_start_trans_pos; /* bitstream_out and bitstream_oe change their value at start_trans_pos = rate_mul */
	unsigned int reserved1       : BFW_NX10_xmac_start_trans_pos_reserved1;       /* reserved                                                                        */
} NX10_XMAC_START_TRANS_POS_BIT_T;

typedef union {
	unsigned int                    val;
	NX10_XMAC_START_TRANS_POS_BIT_T bf;
} NX10_XMAC_START_TRANS_POS_T;

/* --------------------------------------------------------------------- */
/* Register xmac_stop_trans_pos */
/* => xMAC SBU stop_trans_pos */
/*    This register has a write pipeline delay of 1 clock cycle */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX10_xmac_stop_trans_pos   0x00000930U
#define Adr_NX10_xmac0_xmac_stop_trans_pos 0x101A0930U
#define Adr_NX10_xmac_stop_trans_pos       0x101A0930U
#define DFLT_VAL_NX10_xmac_stop_trans_pos  0x00000000U

#define MSK_NX10_xmac_stop_trans_pos_stop_trans_pos      0x0000ffffU
#define SRT_NX10_xmac_stop_trans_pos_stop_trans_pos      0
#define DFLT_VAL_NX10_xmac_stop_trans_pos_stop_trans_pos 0x00000000U

enum {
	BFW_NX10_xmac_stop_trans_pos_stop_trans_pos = 16, /* [15:0] */
	BFW_NX10_xmac_stop_trans_pos_reserved1      = 16  /* [31:16] */
};

typedef struct NX10_XMAC_STOP_TRANS_POS_BIT_Ttag {
	unsigned int stop_trans_pos : BFW_NX10_xmac_stop_trans_pos_stop_trans_pos; /* bitstream_oe becomes 0 if rate_mul >= stop_trans_pos */
	unsigned int reserved1      : BFW_NX10_xmac_stop_trans_pos_reserved1;      /* reserved                                             */
} NX10_XMAC_STOP_TRANS_POS_BIT_T;

typedef union {
	unsigned int                   val;
	NX10_XMAC_STOP_TRANS_POS_BIT_T bf;
} NX10_XMAC_STOP_TRANS_POS_T;

/* --------------------------------------------------------------------- */
/* Register xmac_rpu_count1 */
/* => xMAC RPU Counter 1 */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX10_xmac_rpu_count1   0x00000934U
#define Adr_NX10_xmac0_xmac_rpu_count1 0x101A0934U
#define Adr_NX10_xmac_rpu_count1       0x101A0934U
#define DFLT_VAL_NX10_xmac_rpu_count1  0x00000000U

#define MSK_NX10_xmac_rpu_count1_rpu_count1      0x0000ffffU
#define SRT_NX10_xmac_rpu_count1_rpu_count1      0
#define DFLT_VAL_NX10_xmac_rpu_count1_rpu_count1 0x00000000U

enum {
	BFW_NX10_xmac_rpu_count1_rpu_count1 = 16, /* [15:0] */
	BFW_NX10_xmac_rpu_count1_reserved1  = 16  /* [31:16] */
};

typedef struct NX10_XMAC_RPU_COUNT1_BIT_Ttag {
	unsigned int rpu_count1 : BFW_NX10_xmac_rpu_count1_rpu_count1; /* Counter incremented by rpu-hw_support bit cnt1 */
	unsigned int reserved1  : BFW_NX10_xmac_rpu_count1_reserved1;  /* reserved                                       */
} NX10_XMAC_RPU_COUNT1_BIT_T;

typedef union {
	unsigned int               val;
	NX10_XMAC_RPU_COUNT1_BIT_T bf;
} NX10_XMAC_RPU_COUNT1_T;

/* --------------------------------------------------------------------- */
/* Register xmac_rpu_count2 */
/* => xMAC RPU Counter 2 */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX10_xmac_rpu_count2   0x00000938U
#define Adr_NX10_xmac0_xmac_rpu_count2 0x101A0938U
#define Adr_NX10_xmac_rpu_count2       0x101A0938U
#define DFLT_VAL_NX10_xmac_rpu_count2  0x00000000U

#define MSK_NX10_xmac_rpu_count2_rpu_count2      0x0000ffffU
#define SRT_NX10_xmac_rpu_count2_rpu_count2      0
#define DFLT_VAL_NX10_xmac_rpu_count2_rpu_count2 0x00000000U

enum {
	BFW_NX10_xmac_rpu_count2_rpu_count2 = 16, /* [15:0] */
	BFW_NX10_xmac_rpu_count2_reserved1  = 16  /* [31:16] */
};

typedef struct NX10_XMAC_RPU_COUNT2_BIT_Ttag {
	unsigned int rpu_count2 : BFW_NX10_xmac_rpu_count2_rpu_count2; /* Counter incremented by rpu-hw_support bit cnt2 */
	unsigned int reserved1  : BFW_NX10_xmac_rpu_count2_reserved1;  /* reserved                                       */
} NX10_XMAC_RPU_COUNT2_BIT_T;

typedef union {
	unsigned int               val;
	NX10_XMAC_RPU_COUNT2_BIT_T bf;
} NX10_XMAC_RPU_COUNT2_T;

/* --------------------------------------------------------------------- */
/* Register xmac_tpu_count1 */
/* => xMAC TPU Counter 1 */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX10_xmac_tpu_count1   0x0000093CU
#define Adr_NX10_xmac0_xmac_tpu_count1 0x101A093CU
#define Adr_NX10_xmac_tpu_count1       0x101A093CU
#define DFLT_VAL_NX10_xmac_tpu_count1  0x00000000U

#define MSK_NX10_xmac_tpu_count1_tpu_count1      0x0000ffffU
#define SRT_NX10_xmac_tpu_count1_tpu_count1      0
#define DFLT_VAL_NX10_xmac_tpu_count1_tpu_count1 0x00000000U

enum {
	BFW_NX10_xmac_tpu_count1_tpu_count1 = 16, /* [15:0] */
	BFW_NX10_xmac_tpu_count1_reserved1  = 16  /* [31:16] */
};

typedef struct NX10_XMAC_TPU_COUNT1_BIT_Ttag {
	unsigned int tpu_count1 : BFW_NX10_xmac_tpu_count1_tpu_count1; /* Counter incremented by tpu-hw_support bit cnt1 */
	unsigned int reserved1  : BFW_NX10_xmac_tpu_count1_reserved1;  /* reserved                                       */
} NX10_XMAC_TPU_COUNT1_BIT_T;

typedef union {
	unsigned int               val;
	NX10_XMAC_TPU_COUNT1_BIT_T bf;
} NX10_XMAC_TPU_COUNT1_T;

/* --------------------------------------------------------------------- */
/* Register xmac_tpu_count2 */
/* => xMAC TPU Counter 2 */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX10_xmac_tpu_count2   0x00000940U
#define Adr_NX10_xmac0_xmac_tpu_count2 0x101A0940U
#define Adr_NX10_xmac_tpu_count2       0x101A0940U
#define DFLT_VAL_NX10_xmac_tpu_count2  0x00000000U

#define MSK_NX10_xmac_tpu_count2_tpu_count2      0x0000ffffU
#define SRT_NX10_xmac_tpu_count2_tpu_count2      0
#define DFLT_VAL_NX10_xmac_tpu_count2_tpu_count2 0x00000000U

enum {
	BFW_NX10_xmac_tpu_count2_tpu_count2 = 16, /* [15:0] */
	BFW_NX10_xmac_tpu_count2_reserved1  = 16  /* [31:16] */
};

typedef struct NX10_XMAC_TPU_COUNT2_BIT_Ttag {
	unsigned int tpu_count2 : BFW_NX10_xmac_tpu_count2_tpu_count2; /* Counter incremented by tpu-hw_support bit cnt2 */
	unsigned int reserved1  : BFW_NX10_xmac_tpu_count2_reserved1;  /* reserved                                       */
} NX10_XMAC_TPU_COUNT2_BIT_T;

typedef union {
	unsigned int               val;
	NX10_XMAC_TPU_COUNT2_BIT_T bf;
} NX10_XMAC_TPU_COUNT2_T;

/* --------------------------------------------------------------------- */
/* Register xmac_rx_count */
/* => xMAC RX Counter */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX10_xmac_rx_count   0x00000944U
#define Adr_NX10_xmac0_xmac_rx_count 0x101A0944U
#define Adr_NX10_xmac_rx_count       0x101A0944U
#define DFLT_VAL_NX10_xmac_rx_count  0x00000000U

#define MSK_NX10_xmac_rx_count_rx_count      0x0000ffffU
#define SRT_NX10_xmac_rx_count_rx_count      0
#define DFLT_VAL_NX10_xmac_rx_count_rx_count 0x00000000U

enum {
	BFW_NX10_xmac_rx_count_rx_count  = 16, /* [15:0] */
	BFW_NX10_xmac_rx_count_reserved1 = 16  /* [31:16] */
};

typedef struct NX10_XMAC_RX_COUNT_BIT_Ttag {
	unsigned int rx_count  : BFW_NX10_xmac_rx_count_rx_count;  /* Counter running on eclk */
	unsigned int reserved1 : BFW_NX10_xmac_rx_count_reserved1; /* reserved                */
} NX10_XMAC_RX_COUNT_BIT_T;

typedef union {
	unsigned int             val;
	NX10_XMAC_RX_COUNT_BIT_T bf;
} NX10_XMAC_RX_COUNT_T;

/* --------------------------------------------------------------------- */
/* Register xmac_tx_count */
/* => xMAC TX Counter */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX10_xmac_tx_count   0x00000948U
#define Adr_NX10_xmac0_xmac_tx_count 0x101A0948U
#define Adr_NX10_xmac_tx_count       0x101A0948U
#define DFLT_VAL_NX10_xmac_tx_count  0x00000000U

#define MSK_NX10_xmac_tx_count_tx_count      0x0000ffffU
#define SRT_NX10_xmac_tx_count_tx_count      0
#define DFLT_VAL_NX10_xmac_tx_count_tx_count 0x00000000U

enum {
	BFW_NX10_xmac_tx_count_tx_count  = 16, /* [15:0] */
	BFW_NX10_xmac_tx_count_reserved1 = 16  /* [31:16] */
};

typedef struct NX10_XMAC_TX_COUNT_BIT_Ttag {
	unsigned int tx_count  : BFW_NX10_xmac_tx_count_tx_count;  /* Counter running on eclk */
	unsigned int reserved1 : BFW_NX10_xmac_tx_count_reserved1; /* reserved                */
} NX10_XMAC_TX_COUNT_BIT_T;

typedef union {
	unsigned int             val;
	NX10_XMAC_TX_COUNT_BIT_T bf;
} NX10_XMAC_TX_COUNT_T;

/* --------------------------------------------------------------------- */
/* Register xmac_rpm_mask0 */
/* => xMAC Receive Pattern Match Mask 0 Register: */
/*    Defines, which bits are compared between xmac_rpm_val0 and xmac_rx. */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX10_xmac_rpm_mask0   0x0000094CU
#define Adr_NX10_xmac0_xmac_rpm_mask0 0x101A094CU
#define Adr_NX10_xmac_rpm_mask0       0x101A094CU
#define DFLT_VAL_NX10_xmac_rpm_mask0  0x00000000U

#define MSK_NX10_xmac_rpm_mask0_PM_MASK0      0x0000ffffU
#define SRT_NX10_xmac_rpm_mask0_PM_MASK0      0
#define DFLT_VAL_NX10_xmac_rpm_mask0_PM_MASK0 0x00000000U

enum {
	BFW_NX10_xmac_rpm_mask0_PM_MASK0  = 16, /* [15:0] */
	BFW_NX10_xmac_rpm_mask0_reserved1 = 16  /* [31:16] */
};

typedef struct NX10_XMAC_RPM_MASK0_BIT_Ttag {
	unsigned int PM_MASK0  : BFW_NX10_xmac_rpm_mask0_PM_MASK0;  /* Pattern Match Mask:                                   */
	                                                            /* 1: compare this position of xmac_rpm_val0 and xmac_rx */
	unsigned int reserved1 : BFW_NX10_xmac_rpm_mask0_reserved1; /* reserved                                              */
} NX10_XMAC_RPM_MASK0_BIT_T;

typedef union {
	unsigned int              val;
	NX10_XMAC_RPM_MASK0_BIT_T bf;
} NX10_XMAC_RPM_MASK0_T;

/* --------------------------------------------------------------------- */
/* Register xmac_rpm_val0 */
/* => xMAC Receive Pattern Match Value 0 Register: */
/*    Defines value of bits to be compared with xmac_rx. */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX10_xmac_rpm_val0   0x00000950U
#define Adr_NX10_xmac0_xmac_rpm_val0 0x101A0950U
#define Adr_NX10_xmac_rpm_val0       0x101A0950U
#define DFLT_VAL_NX10_xmac_rpm_val0  0x00000000U

#define MSK_NX10_xmac_rpm_val0_PM_VAL0      0x0000ffffU
#define SRT_NX10_xmac_rpm_val0_PM_VAL0      0
#define DFLT_VAL_NX10_xmac_rpm_val0_PM_VAL0 0x00000000U

enum {
	BFW_NX10_xmac_rpm_val0_PM_VAL0   = 16, /* [15:0] */
	BFW_NX10_xmac_rpm_val0_reserved1 = 16  /* [31:16] */
};

typedef struct NX10_XMAC_RPM_VAL0_BIT_Ttag {
	unsigned int PM_VAL0   : BFW_NX10_xmac_rpm_val0_PM_VAL0;   /* Pattern Match Value */
	unsigned int reserved1 : BFW_NX10_xmac_rpm_val0_reserved1; /* reserved            */
} NX10_XMAC_RPM_VAL0_BIT_T;

typedef union {
	unsigned int             val;
	NX10_XMAC_RPM_VAL0_BIT_T bf;
} NX10_XMAC_RPM_VAL0_T;

/* --------------------------------------------------------------------- */
/* Register xmac_rpm_mask1 */
/* => xMAC Receive Pattern Match Mask 1 Register: */
/*    Defines, which bits are compared between xmac_rpm_val1 and xmac_rx */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX10_xmac_rpm_mask1   0x00000954U
#define Adr_NX10_xmac0_xmac_rpm_mask1 0x101A0954U
#define Adr_NX10_xmac_rpm_mask1       0x101A0954U
#define DFLT_VAL_NX10_xmac_rpm_mask1  0x00000000U

#define MSK_NX10_xmac_rpm_mask1_PM_MASK1      0x0000ffffU
#define SRT_NX10_xmac_rpm_mask1_PM_MASK1      0
#define DFLT_VAL_NX10_xmac_rpm_mask1_PM_MASK1 0x00000000U

enum {
	BFW_NX10_xmac_rpm_mask1_PM_MASK1  = 16, /* [15:0] */
	BFW_NX10_xmac_rpm_mask1_reserved1 = 16  /* [31:16] */
};

typedef struct NX10_XMAC_RPM_MASK1_BIT_Ttag {
	unsigned int PM_MASK1  : BFW_NX10_xmac_rpm_mask1_PM_MASK1;  /* Pattern Match Mask:                                   */
	                                                            /* 1: compare this position of xmac_rpm_val1 and xmac_rx */
	unsigned int reserved1 : BFW_NX10_xmac_rpm_mask1_reserved1; /* reserved                                              */
} NX10_XMAC_RPM_MASK1_BIT_T;

typedef union {
	unsigned int              val;
	NX10_XMAC_RPM_MASK1_BIT_T bf;
} NX10_XMAC_RPM_MASK1_T;

/* --------------------------------------------------------------------- */
/* Register xmac_rpm_val1 */
/* => xMAC Receive Pattern Match Value 1 Register: */
/*    Defines value of bits to be compared with xmac_rx. */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX10_xmac_rpm_val1   0x00000958U
#define Adr_NX10_xmac0_xmac_rpm_val1 0x101A0958U
#define Adr_NX10_xmac_rpm_val1       0x101A0958U
#define DFLT_VAL_NX10_xmac_rpm_val1  0x00000000U

#define MSK_NX10_xmac_rpm_val1_PM_VAL1      0x0000ffffU
#define SRT_NX10_xmac_rpm_val1_PM_VAL1      0
#define DFLT_VAL_NX10_xmac_rpm_val1_PM_VAL1 0x00000000U

enum {
	BFW_NX10_xmac_rpm_val1_PM_VAL1   = 16, /* [15:0] */
	BFW_NX10_xmac_rpm_val1_reserved1 = 16  /* [31:16] */
};

typedef struct NX10_XMAC_RPM_VAL1_BIT_Ttag {
	unsigned int PM_VAL1   : BFW_NX10_xmac_rpm_val1_PM_VAL1;   /* Pattern Match Value */
	unsigned int reserved1 : BFW_NX10_xmac_rpm_val1_reserved1; /* reserved            */
} NX10_XMAC_RPM_VAL1_BIT_T;

typedef union {
	unsigned int             val;
	NX10_XMAC_RPM_VAL1_BIT_T bf;
} NX10_XMAC_RPM_VAL1_T;

/* --------------------------------------------------------------------- */
/* Register xmac_tpm_mask0 */
/* => xMAC Transmit Pattern Match Mask 0 Register: */
/*    Defines, which bits are compared between xmac_tpm_val0 and xmac_tx_sent. */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX10_xmac_tpm_mask0   0x0000095CU
#define Adr_NX10_xmac0_xmac_tpm_mask0 0x101A095CU
#define Adr_NX10_xmac_tpm_mask0       0x101A095CU
#define DFLT_VAL_NX10_xmac_tpm_mask0  0x00000000U

#define MSK_NX10_xmac_tpm_mask0_PM_MASK0      0x0000ffffU
#define SRT_NX10_xmac_tpm_mask0_PM_MASK0      0
#define DFLT_VAL_NX10_xmac_tpm_mask0_PM_MASK0 0x00000000U

enum {
	BFW_NX10_xmac_tpm_mask0_PM_MASK0  = 16, /* [15:0] */
	BFW_NX10_xmac_tpm_mask0_reserved1 = 16  /* [31:16] */
};

typedef struct NX10_XMAC_TPM_MASK0_BIT_Ttag {
	unsigned int PM_MASK0  : BFW_NX10_xmac_tpm_mask0_PM_MASK0;  /* Pattern Match Mask:                                        */
	                                                            /* 1: compare this position of xmac_tpm_val0 and xmac_tx_sent */
	unsigned int reserved1 : BFW_NX10_xmac_tpm_mask0_reserved1; /* reserved                                                   */
} NX10_XMAC_TPM_MASK0_BIT_T;

typedef union {
	unsigned int              val;
	NX10_XMAC_TPM_MASK0_BIT_T bf;
} NX10_XMAC_TPM_MASK0_T;

/* --------------------------------------------------------------------- */
/* Register xmac_tpm_val0 */
/* => xMAC Transmit Pattern Match Value 0 Register: */
/*    Defines value of bits to be compared with xmac_tx_sent. */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX10_xmac_tpm_val0   0x00000960U
#define Adr_NX10_xmac0_xmac_tpm_val0 0x101A0960U
#define Adr_NX10_xmac_tpm_val0       0x101A0960U
#define DFLT_VAL_NX10_xmac_tpm_val0  0x00000000U

#define MSK_NX10_xmac_tpm_val0_PM_VAL0      0x0000ffffU
#define SRT_NX10_xmac_tpm_val0_PM_VAL0      0
#define DFLT_VAL_NX10_xmac_tpm_val0_PM_VAL0 0x00000000U

enum {
	BFW_NX10_xmac_tpm_val0_PM_VAL0   = 16, /* [15:0] */
	BFW_NX10_xmac_tpm_val0_reserved1 = 16  /* [31:16] */
};

typedef struct NX10_XMAC_TPM_VAL0_BIT_Ttag {
	unsigned int PM_VAL0   : BFW_NX10_xmac_tpm_val0_PM_VAL0;   /* Pattern Match Value */
	unsigned int reserved1 : BFW_NX10_xmac_tpm_val0_reserved1; /* reserved            */
} NX10_XMAC_TPM_VAL0_BIT_T;

typedef union {
	unsigned int             val;
	NX10_XMAC_TPM_VAL0_BIT_T bf;
} NX10_XMAC_TPM_VAL0_T;

/* --------------------------------------------------------------------- */
/* Register xmac_tpm_mask1 */
/* => xMAC Transmit Pattern Match Mask 1 Register: */
/*    Defines, which bits are compared between xmac_tpm_val1 and xmac_tx_sent. */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX10_xmac_tpm_mask1   0x00000964U
#define Adr_NX10_xmac0_xmac_tpm_mask1 0x101A0964U
#define Adr_NX10_xmac_tpm_mask1       0x101A0964U
#define DFLT_VAL_NX10_xmac_tpm_mask1  0x00000000U

#define MSK_NX10_xmac_tpm_mask1_PM_MASK1      0x0000ffffU
#define SRT_NX10_xmac_tpm_mask1_PM_MASK1      0
#define DFLT_VAL_NX10_xmac_tpm_mask1_PM_MASK1 0x00000000U

enum {
	BFW_NX10_xmac_tpm_mask1_PM_MASK1  = 16, /* [15:0] */
	BFW_NX10_xmac_tpm_mask1_reserved1 = 16  /* [31:16] */
};

typedef struct NX10_XMAC_TPM_MASK1_BIT_Ttag {
	unsigned int PM_MASK1  : BFW_NX10_xmac_tpm_mask1_PM_MASK1;  /* Pattern Match Mask:                                        */
	                                                            /* 1: compare this position of xmac_tpm_val1 and xmac_tx_sent */
	unsigned int reserved1 : BFW_NX10_xmac_tpm_mask1_reserved1; /* reserved                                                   */
} NX10_XMAC_TPM_MASK1_BIT_T;

typedef union {
	unsigned int              val;
	NX10_XMAC_TPM_MASK1_BIT_T bf;
} NX10_XMAC_TPM_MASK1_T;

/* --------------------------------------------------------------------- */
/* Register xmac_tpm_val1 */
/* => xMAC Transmit Pattern Match Value 1 Register: */
/*    Defines value of bits to be compared with xmac_tx_sent. */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX10_xmac_tpm_val1   0x00000968U
#define Adr_NX10_xmac0_xmac_tpm_val1 0x101A0968U
#define Adr_NX10_xmac_tpm_val1       0x101A0968U
#define DFLT_VAL_NX10_xmac_tpm_val1  0x00000000U

#define MSK_NX10_xmac_tpm_val1_PM_VAL1      0x0000ffffU
#define SRT_NX10_xmac_tpm_val1_PM_VAL1      0
#define DFLT_VAL_NX10_xmac_tpm_val1_PM_VAL1 0x00000000U

enum {
	BFW_NX10_xmac_tpm_val1_PM_VAL1   = 16, /* [15:0] */
	BFW_NX10_xmac_tpm_val1_reserved1 = 16  /* [31:16] */
};

typedef struct NX10_XMAC_TPM_VAL1_BIT_Ttag {
	unsigned int PM_VAL1   : BFW_NX10_xmac_tpm_val1_PM_VAL1;   /* Pattern Match Value */
	unsigned int reserved1 : BFW_NX10_xmac_tpm_val1_reserved1; /* reserved            */
} NX10_XMAC_TPM_VAL1_BIT_T;

typedef union {
	unsigned int             val;
	NX10_XMAC_TPM_VAL1_BIT_T bf;
} NX10_XMAC_TPM_VAL1_T;

/* --------------------------------------------------------------------- */
/* Register xmac_rx_tx_nof_bits */
/* => xMAC RX / TX number of bits */
/*    This register has a write pipeline delay of 1 clock cycle */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX10_xmac_rx_tx_nof_bits   0x000009BCU
#define Adr_NX10_xmac0_xmac_rx_tx_nof_bits 0x101A09BCU
#define Adr_NX10_xmac_rx_tx_nof_bits       0x101A09BCU
#define DFLT_VAL_NX10_xmac_rx_tx_nof_bits  0x00000088U

#define MSK_NX10_xmac_rx_tx_nof_bits_rx_nof_bits      0x0000000fU
#define SRT_NX10_xmac_rx_tx_nof_bits_rx_nof_bits      0
#define DFLT_VAL_NX10_xmac_rx_tx_nof_bits_rx_nof_bits 0x00000008U
#define MSK_NX10_xmac_rx_tx_nof_bits_tx_nof_bits      0x000000f0U
#define SRT_NX10_xmac_rx_tx_nof_bits_tx_nof_bits      4
#define DFLT_VAL_NX10_xmac_rx_tx_nof_bits_tx_nof_bits 0x00000080U

enum {
	BFW_NX10_xmac_rx_tx_nof_bits_rx_nof_bits = 4,  /* [3:0] */
	BFW_NX10_xmac_rx_tx_nof_bits_tx_nof_bits = 4,  /* [7:4] */
	BFW_NX10_xmac_rx_tx_nof_bits_reserved1   = 24  /* [31:8] */
};

typedef struct NX10_XMAC_RX_TX_NOF_BITS_BIT_Ttag {
	unsigned int rx_nof_bits : BFW_NX10_xmac_rx_tx_nof_bits_rx_nof_bits; /* Number of bits written by SBU to rx-register, only used for rx_hw_count */
	unsigned int tx_nof_bits : BFW_NX10_xmac_rx_tx_nof_bits_tx_nof_bits; /* Number of bits read by OBU from tx-register                             */
	unsigned int reserved1   : BFW_NX10_xmac_rx_tx_nof_bits_reserved1;   /* reserved                                                                */
} NX10_XMAC_RX_TX_NOF_BITS_BIT_T;

typedef union {
	unsigned int                   val;
	NX10_XMAC_RX_TX_NOF_BITS_BIT_T bf;
} NX10_XMAC_RX_TX_NOF_BITS_T;

/* --------------------------------------------------------------------- */
/* Register xmac_rx_crc32_l */
/* => xMAC RX CRC32 lower part */
/*    This register has a write pipeline delay of 1 clock cycle */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX10_xmac_rx_crc32_l   0x000009C0U
#define Adr_NX10_xmac0_xmac_rx_crc32_l 0x101A09C0U
#define Adr_NX10_xmac_rx_crc32_l       0x101A09C0U
#define DFLT_VAL_NX10_xmac_rx_crc32_l  0x00000000U

#define MSK_NX10_xmac_rx_crc32_l_RX_CRC32_L      0x0000ffffU
#define SRT_NX10_xmac_rx_crc32_l_RX_CRC32_L      0
#define DFLT_VAL_NX10_xmac_rx_crc32_l_RX_CRC32_L 0x00000000U

enum {
	BFW_NX10_xmac_rx_crc32_l_RX_CRC32_L = 16, /* [15:0] */
	BFW_NX10_xmac_rx_crc32_l_reserved1  = 16  /* [31:16] */
};

typedef struct NX10_XMAC_RX_CRC32_L_BIT_Ttag {
	unsigned int RX_CRC32_L : BFW_NX10_xmac_rx_crc32_l_RX_CRC32_L; /* lower bits of RX-CRC32 */
	unsigned int reserved1  : BFW_NX10_xmac_rx_crc32_l_reserved1;  /* reserved               */
} NX10_XMAC_RX_CRC32_L_BIT_T;

typedef union {
	unsigned int               val;
	NX10_XMAC_RX_CRC32_L_BIT_T bf;
} NX10_XMAC_RX_CRC32_L_T;

/* --------------------------------------------------------------------- */
/* Register xmac_rx_crc32_h */
/* => xMAC RX CRC32 upper part */
/*    This register has a write pipeline delay of 1 clock cycle */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX10_xmac_rx_crc32_h   0x000009C4U
#define Adr_NX10_xmac0_xmac_rx_crc32_h 0x101A09C4U
#define Adr_NX10_xmac_rx_crc32_h       0x101A09C4U
#define DFLT_VAL_NX10_xmac_rx_crc32_h  0x00000000U

#define MSK_NX10_xmac_rx_crc32_h_RX_CRC32_H      0x0000ffffU
#define SRT_NX10_xmac_rx_crc32_h_RX_CRC32_H      0
#define DFLT_VAL_NX10_xmac_rx_crc32_h_RX_CRC32_H 0x00000000U

enum {
	BFW_NX10_xmac_rx_crc32_h_RX_CRC32_H = 16, /* [15:0] */
	BFW_NX10_xmac_rx_crc32_h_reserved1  = 16  /* [31:16] */
};

typedef struct NX10_XMAC_RX_CRC32_H_BIT_Ttag {
	unsigned int RX_CRC32_H : BFW_NX10_xmac_rx_crc32_h_RX_CRC32_H; /* upper bits of RX-CRC32 */
	unsigned int reserved1  : BFW_NX10_xmac_rx_crc32_h_reserved1;  /* reserved               */
} NX10_XMAC_RX_CRC32_H_BIT_T;

typedef union {
	unsigned int               val;
	NX10_XMAC_RX_CRC32_H_BIT_T bf;
} NX10_XMAC_RX_CRC32_H_T;

/* --------------------------------------------------------------------- */
/* Register xmac_rx_crc32_cfg */
/* => xMAC RX CRC32 Config Register */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX10_xmac_rx_crc32_cfg   0x000009C8U
#define Adr_NX10_xmac0_xmac_rx_crc32_cfg 0x101A09C8U
#define Adr_NX10_xmac_rx_crc32_cfg       0x101A09C8U
#define DFLT_VAL_NX10_xmac_rx_crc32_cfg  0x00000000U

#define MSK_NX10_xmac_rx_crc32_cfg_shift_right      0x00000001U
#define SRT_NX10_xmac_rx_crc32_cfg_shift_right      0
#define DFLT_VAL_NX10_xmac_rx_crc32_cfg_shift_right 0x00000000U
#define MSK_NX10_xmac_rx_crc32_cfg_zero             0x00000002U
#define SRT_NX10_xmac_rx_crc32_cfg_zero             1
#define DFLT_VAL_NX10_xmac_rx_crc32_cfg_zero        0x00000000U
#define MSK_NX10_xmac_rx_crc32_cfg_invert           0x00000004U
#define SRT_NX10_xmac_rx_crc32_cfg_invert           2
#define DFLT_VAL_NX10_xmac_rx_crc32_cfg_invert      0x00000000U
#define MSK_NX10_xmac_rx_crc32_cfg_nof_bits         0x00000300U
#define SRT_NX10_xmac_rx_crc32_cfg_nof_bits         8
#define DFLT_VAL_NX10_xmac_rx_crc32_cfg_nof_bits    0x00000000U
#define MSK_NX10_xmac_rx_crc32_cfg_direct_div       0x00000400U
#define SRT_NX10_xmac_rx_crc32_cfg_direct_div       10
#define DFLT_VAL_NX10_xmac_rx_crc32_cfg_direct_div  0x00000000U
#define MSK_NX10_xmac_rx_crc32_cfg_endian           0x00000800U
#define SRT_NX10_xmac_rx_crc32_cfg_endian           11
#define DFLT_VAL_NX10_xmac_rx_crc32_cfg_endian      0x00000000U
#define MSK_NX10_xmac_rx_crc32_cfg_swap_output      0x00001000U
#define SRT_NX10_xmac_rx_crc32_cfg_swap_output      12
#define DFLT_VAL_NX10_xmac_rx_crc32_cfg_swap_output 0x00000000U

enum {
	BFW_NX10_xmac_rx_crc32_cfg_shift_right = 1,  /* [0] */
	BFW_NX10_xmac_rx_crc32_cfg_zero        = 1,  /* [1] */
	BFW_NX10_xmac_rx_crc32_cfg_invert      = 1,  /* [2] */
	BFW_NX10_xmac_rx_crc32_cfg_reserved1   = 5,  /* [7:3] */
	BFW_NX10_xmac_rx_crc32_cfg_nof_bits    = 2,  /* [9:8] */
	BFW_NX10_xmac_rx_crc32_cfg_direct_div  = 1,  /* [10] */
	BFW_NX10_xmac_rx_crc32_cfg_endian      = 1,  /* [11] */
	BFW_NX10_xmac_rx_crc32_cfg_swap_output = 1,  /* [12] */
	BFW_NX10_xmac_rx_crc32_cfg_reserved2   = 19  /* [31:13] */
};

typedef struct NX10_XMAC_RX_CRC32_CFG_BIT_Ttag {
	unsigned int shift_right : BFW_NX10_xmac_rx_crc32_cfg_shift_right; /* Shift RX CRC32 from left to right                                      */
	                                                                   /* (usually used with crc_swap_output but inverted in case of crc_endian) */
	unsigned int zero        : BFW_NX10_xmac_rx_crc32_cfg_zero;        /* Set input of RX CRC32 to zero (before invert)                          */
	unsigned int invert      : BFW_NX10_xmac_rx_crc32_cfg_invert;      /* Invert input of RX CRC32                                               */
	unsigned int reserved1   : BFW_NX10_xmac_rx_crc32_cfg_reserved1;   /* reserved                                                               */
	unsigned int nof_bits    : BFW_NX10_xmac_rx_crc32_cfg_nof_bits;    /* 1(0),2(1),4(2),8(3) Bits from rx register to be executed in parallel   */
	unsigned int direct_div  : BFW_NX10_xmac_rx_crc32_cfg_direct_div;  /* calculate direct polynomial division without n zeros after frame       */
	unsigned int endian      : BFW_NX10_xmac_rx_crc32_cfg_endian;      /* Swap incoming bits in case of nof_bits = 2,4,8                         */
	unsigned int swap_output : BFW_NX10_xmac_rx_crc32_cfg_swap_output; /* Swap output of crc at PU access                                        */
	unsigned int reserved2   : BFW_NX10_xmac_rx_crc32_cfg_reserved2;   /* reserved                                                               */
} NX10_XMAC_RX_CRC32_CFG_BIT_T;

typedef union {
	unsigned int                 val;
	NX10_XMAC_RX_CRC32_CFG_BIT_T bf;
} NX10_XMAC_RX_CRC32_CFG_T;

/* --------------------------------------------------------------------- */
/* Register xmac_tx_crc32_l */
/* => xMAC TX CRC32 lower part */
/*    This register has a write pipeline delay of 1 clock cycle */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX10_xmac_tx_crc32_l   0x000009CCU
#define Adr_NX10_xmac0_xmac_tx_crc32_l 0x101A09CCU
#define Adr_NX10_xmac_tx_crc32_l       0x101A09CCU
#define DFLT_VAL_NX10_xmac_tx_crc32_l  0x00000000U

#define MSK_NX10_xmac_tx_crc32_l_TX_CRC32_L      0x0000ffffU
#define SRT_NX10_xmac_tx_crc32_l_TX_CRC32_L      0
#define DFLT_VAL_NX10_xmac_tx_crc32_l_TX_CRC32_L 0x00000000U

enum {
	BFW_NX10_xmac_tx_crc32_l_TX_CRC32_L = 16, /* [15:0] */
	BFW_NX10_xmac_tx_crc32_l_reserved1  = 16  /* [31:16] */
};

typedef struct NX10_XMAC_TX_CRC32_L_BIT_Ttag {
	unsigned int TX_CRC32_L : BFW_NX10_xmac_tx_crc32_l_TX_CRC32_L; /* lower bits of TX-CRC32 */
	unsigned int reserved1  : BFW_NX10_xmac_tx_crc32_l_reserved1;  /* reserved               */
} NX10_XMAC_TX_CRC32_L_BIT_T;

typedef union {
	unsigned int               val;
	NX10_XMAC_TX_CRC32_L_BIT_T bf;
} NX10_XMAC_TX_CRC32_L_T;

/* --------------------------------------------------------------------- */
/* Register xmac_tx_crc32_h */
/* => xMAC TX CRC32 upper part */
/*    This register has a write pipeline delay of 1 clock cycle */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX10_xmac_tx_crc32_h   0x000009D0U
#define Adr_NX10_xmac0_xmac_tx_crc32_h 0x101A09D0U
#define Adr_NX10_xmac_tx_crc32_h       0x101A09D0U
#define DFLT_VAL_NX10_xmac_tx_crc32_h  0x00000000U

#define MSK_NX10_xmac_tx_crc32_h_TX_CRC32_H      0x0000ffffU
#define SRT_NX10_xmac_tx_crc32_h_TX_CRC32_H      0
#define DFLT_VAL_NX10_xmac_tx_crc32_h_TX_CRC32_H 0x00000000U

enum {
	BFW_NX10_xmac_tx_crc32_h_TX_CRC32_H = 16, /* [15:0] */
	BFW_NX10_xmac_tx_crc32_h_reserved1  = 16  /* [31:16] */
};

typedef struct NX10_XMAC_TX_CRC32_H_BIT_Ttag {
	unsigned int TX_CRC32_H : BFW_NX10_xmac_tx_crc32_h_TX_CRC32_H; /* upper bits of TX-CRC32 */
	unsigned int reserved1  : BFW_NX10_xmac_tx_crc32_h_reserved1;  /* reserved               */
} NX10_XMAC_TX_CRC32_H_BIT_T;

typedef union {
	unsigned int               val;
	NX10_XMAC_TX_CRC32_H_BIT_T bf;
} NX10_XMAC_TX_CRC32_H_T;

/* --------------------------------------------------------------------- */
/* Register xmac_tx_crc32_cfg */
/* => xMAC TX CRC32 Config Register */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX10_xmac_tx_crc32_cfg   0x000009D4U
#define Adr_NX10_xmac0_xmac_tx_crc32_cfg 0x101A09D4U
#define Adr_NX10_xmac_tx_crc32_cfg       0x101A09D4U
#define DFLT_VAL_NX10_xmac_tx_crc32_cfg  0x00000000U

#define MSK_NX10_xmac_tx_crc32_cfg_shift_right      0x00000001U
#define SRT_NX10_xmac_tx_crc32_cfg_shift_right      0
#define DFLT_VAL_NX10_xmac_tx_crc32_cfg_shift_right 0x00000000U
#define MSK_NX10_xmac_tx_crc32_cfg_zero             0x00000002U
#define SRT_NX10_xmac_tx_crc32_cfg_zero             1
#define DFLT_VAL_NX10_xmac_tx_crc32_cfg_zero        0x00000000U
#define MSK_NX10_xmac_tx_crc32_cfg_invert           0x00000004U
#define SRT_NX10_xmac_tx_crc32_cfg_invert           2
#define DFLT_VAL_NX10_xmac_tx_crc32_cfg_invert      0x00000000U
#define MSK_NX10_xmac_tx_crc32_cfg_nof_bits         0x00000300U
#define SRT_NX10_xmac_tx_crc32_cfg_nof_bits         8
#define DFLT_VAL_NX10_xmac_tx_crc32_cfg_nof_bits    0x00000000U
#define MSK_NX10_xmac_tx_crc32_cfg_direct_div       0x00000400U
#define SRT_NX10_xmac_tx_crc32_cfg_direct_div       10
#define DFLT_VAL_NX10_xmac_tx_crc32_cfg_direct_div  0x00000000U
#define MSK_NX10_xmac_tx_crc32_cfg_endian           0x00000800U
#define SRT_NX10_xmac_tx_crc32_cfg_endian           11
#define DFLT_VAL_NX10_xmac_tx_crc32_cfg_endian      0x00000000U
#define MSK_NX10_xmac_tx_crc32_cfg_swap_output      0x00001000U
#define SRT_NX10_xmac_tx_crc32_cfg_swap_output      12
#define DFLT_VAL_NX10_xmac_tx_crc32_cfg_swap_output 0x00000000U

enum {
	BFW_NX10_xmac_tx_crc32_cfg_shift_right = 1,  /* [0] */
	BFW_NX10_xmac_tx_crc32_cfg_zero        = 1,  /* [1] */
	BFW_NX10_xmac_tx_crc32_cfg_invert      = 1,  /* [2] */
	BFW_NX10_xmac_tx_crc32_cfg_reserved1   = 5,  /* [7:3] */
	BFW_NX10_xmac_tx_crc32_cfg_nof_bits    = 2,  /* [9:8] */
	BFW_NX10_xmac_tx_crc32_cfg_direct_div  = 1,  /* [10] */
	BFW_NX10_xmac_tx_crc32_cfg_endian      = 1,  /* [11] */
	BFW_NX10_xmac_tx_crc32_cfg_swap_output = 1,  /* [12] */
	BFW_NX10_xmac_tx_crc32_cfg_reserved2   = 19  /* [31:13] */
};

typedef struct NX10_XMAC_TX_CRC32_CFG_BIT_Ttag {
	unsigned int shift_right : BFW_NX10_xmac_tx_crc32_cfg_shift_right; /* Shift TX CRC32 from left to right                                      */
	                                                                   /* (usually used with crc_swap_output but inverted in case of crc_endian) */
	unsigned int zero        : BFW_NX10_xmac_tx_crc32_cfg_zero;        /* Set input of TX CRC32 to zero (before invert)                          */
	unsigned int invert      : BFW_NX10_xmac_tx_crc32_cfg_invert;      /* Invert input of TX CRC32                                               */
	unsigned int reserved1   : BFW_NX10_xmac_tx_crc32_cfg_reserved1;   /* reserved                                                               */
	unsigned int nof_bits    : BFW_NX10_xmac_tx_crc32_cfg_nof_bits;    /* 1(0),2(1),4(2),8(3) Bits from tx_register to be executed in parallel   */
	unsigned int direct_div  : BFW_NX10_xmac_tx_crc32_cfg_direct_div;  /* calculate direct polynomial division without n zeros after frame       */
	unsigned int endian      : BFW_NX10_xmac_tx_crc32_cfg_endian;      /* Swap incoming bits in case of nof_bits = 2,4,8                         */
	unsigned int swap_output : BFW_NX10_xmac_tx_crc32_cfg_swap_output; /* Swap output of crc at PU access                                        */
	unsigned int reserved2   : BFW_NX10_xmac_tx_crc32_cfg_reserved2;   /* reserved                                                               */
} NX10_XMAC_TX_CRC32_CFG_BIT_T;

typedef union {
	unsigned int                 val;
	NX10_XMAC_TX_CRC32_CFG_BIT_T bf;
} NX10_XMAC_TX_CRC32_CFG_T;

/* --------------------------------------------------------------------- */
/* Register xmac_rx_crc_polynomial_l */
/* => xMAC RX CRC Polynomial lower part */
/*    This register has a write pipeline delay of 1 clock cycle */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX10_xmac_rx_crc_polynomial_l   0x000009D8U
#define Adr_NX10_xmac0_xmac_rx_crc_polynomial_l 0x101A09D8U
#define Adr_NX10_xmac_rx_crc_polynomial_l       0x101A09D8U
#define DFLT_VAL_NX10_xmac_rx_crc_polynomial_l  0x00000000U

#define MSK_NX10_xmac_rx_crc_polynomial_l_RX_POL_L      0x0000ffffU
#define SRT_NX10_xmac_rx_crc_polynomial_l_RX_POL_L      0
#define DFLT_VAL_NX10_xmac_rx_crc_polynomial_l_RX_POL_L 0x00000000U

enum {
	BFW_NX10_xmac_rx_crc_polynomial_l_RX_POL_L  = 16, /* [15:0] */
	BFW_NX10_xmac_rx_crc_polynomial_l_reserved1 = 16  /* [31:16] */
};

typedef struct NX10_XMAC_RX_CRC_POLYNOMIAL_L_BIT_Ttag {
	unsigned int RX_POL_L  : BFW_NX10_xmac_rx_crc_polynomial_l_RX_POL_L;  /* lower bits of RX-CRC Polynomial */
	unsigned int reserved1 : BFW_NX10_xmac_rx_crc_polynomial_l_reserved1; /* reserved                        */
} NX10_XMAC_RX_CRC_POLYNOMIAL_L_BIT_T;

typedef union {
	unsigned int                        val;
	NX10_XMAC_RX_CRC_POLYNOMIAL_L_BIT_T bf;
} NX10_XMAC_RX_CRC_POLYNOMIAL_L_T;

/* --------------------------------------------------------------------- */
/* Register xmac_rx_crc_polynomial_h */
/* => xMAC RX CRC Polynomial lower part */
/*    This register has a write pipeline delay of 1 clock cycle */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX10_xmac_rx_crc_polynomial_h   0x000009DCU
#define Adr_NX10_xmac0_xmac_rx_crc_polynomial_h 0x101A09DCU
#define Adr_NX10_xmac_rx_crc_polynomial_h       0x101A09DCU
#define DFLT_VAL_NX10_xmac_rx_crc_polynomial_h  0x00000000U

#define MSK_NX10_xmac_rx_crc_polynomial_h_RX_POL_H      0x0000ffffU
#define SRT_NX10_xmac_rx_crc_polynomial_h_RX_POL_H      0
#define DFLT_VAL_NX10_xmac_rx_crc_polynomial_h_RX_POL_H 0x00000000U

enum {
	BFW_NX10_xmac_rx_crc_polynomial_h_RX_POL_H  = 16, /* [15:0] */
	BFW_NX10_xmac_rx_crc_polynomial_h_reserved1 = 16  /* [31:16] */
};

typedef struct NX10_XMAC_RX_CRC_POLYNOMIAL_H_BIT_Ttag {
	unsigned int RX_POL_H  : BFW_NX10_xmac_rx_crc_polynomial_h_RX_POL_H;  /* upper bits of RX-CRC Polynomial */
	unsigned int reserved1 : BFW_NX10_xmac_rx_crc_polynomial_h_reserved1; /* reserved                        */
} NX10_XMAC_RX_CRC_POLYNOMIAL_H_BIT_T;

typedef union {
	unsigned int                        val;
	NX10_XMAC_RX_CRC_POLYNOMIAL_H_BIT_T bf;
} NX10_XMAC_RX_CRC_POLYNOMIAL_H_T;

/* --------------------------------------------------------------------- */
/* Register xmac_rx_crc_l */
/* => xMAC RX CRC lower part */
/*    This register has a write pipeline delay of 1 clock cycle */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX10_xmac_rx_crc_l   0x000009E0U
#define Adr_NX10_xmac0_xmac_rx_crc_l 0x101A09E0U
#define Adr_NX10_xmac_rx_crc_l       0x101A09E0U
#define DFLT_VAL_NX10_xmac_rx_crc_l  0x00000000U

#define MSK_NX10_xmac_rx_crc_l_RX_CRC_L      0x0000ffffU
#define SRT_NX10_xmac_rx_crc_l_RX_CRC_L      0
#define DFLT_VAL_NX10_xmac_rx_crc_l_RX_CRC_L 0x00000000U

enum {
	BFW_NX10_xmac_rx_crc_l_RX_CRC_L  = 16, /* [15:0] */
	BFW_NX10_xmac_rx_crc_l_reserved1 = 16  /* [31:16] */
};

typedef struct NX10_XMAC_RX_CRC_L_BIT_Ttag {
	unsigned int RX_CRC_L  : BFW_NX10_xmac_rx_crc_l_RX_CRC_L;  /* lower bits of RX-CRC */
	unsigned int reserved1 : BFW_NX10_xmac_rx_crc_l_reserved1; /* reserved             */
} NX10_XMAC_RX_CRC_L_BIT_T;

typedef union {
	unsigned int             val;
	NX10_XMAC_RX_CRC_L_BIT_T bf;
} NX10_XMAC_RX_CRC_L_T;

/* --------------------------------------------------------------------- */
/* Register xmac_rx_crc_h */
/* => xMAC RX CRC upper part */
/*    This register has a write pipeline delay of 1 clock cycle */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX10_xmac_rx_crc_h   0x000009E4U
#define Adr_NX10_xmac0_xmac_rx_crc_h 0x101A09E4U
#define Adr_NX10_xmac_rx_crc_h       0x101A09E4U
#define DFLT_VAL_NX10_xmac_rx_crc_h  0x00000000U

#define MSK_NX10_xmac_rx_crc_h_RX_CRC_H      0x0000ffffU
#define SRT_NX10_xmac_rx_crc_h_RX_CRC_H      0
#define DFLT_VAL_NX10_xmac_rx_crc_h_RX_CRC_H 0x00000000U

enum {
	BFW_NX10_xmac_rx_crc_h_RX_CRC_H  = 16, /* [15:0] */
	BFW_NX10_xmac_rx_crc_h_reserved1 = 16  /* [31:16] */
};

typedef struct NX10_XMAC_RX_CRC_H_BIT_Ttag {
	unsigned int RX_CRC_H  : BFW_NX10_xmac_rx_crc_h_RX_CRC_H;  /* upper bits of RX-CRC */
	unsigned int reserved1 : BFW_NX10_xmac_rx_crc_h_reserved1; /* reserved             */
} NX10_XMAC_RX_CRC_H_BIT_T;

typedef union {
	unsigned int             val;
	NX10_XMAC_RX_CRC_H_BIT_T bf;
} NX10_XMAC_RX_CRC_H_T;

/* --------------------------------------------------------------------- */
/* Register xmac_rx_crc_cfg */
/* => xMAC RX CRC Config Register */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX10_xmac_rx_crc_cfg   0x000009E8U
#define Adr_NX10_xmac0_xmac_rx_crc_cfg 0x101A09E8U
#define Adr_NX10_xmac_rx_crc_cfg       0x101A09E8U
#define DFLT_VAL_NX10_xmac_rx_crc_cfg  0x00000000U

#define MSK_NX10_xmac_rx_crc_cfg_shift_right      0x00000001U
#define SRT_NX10_xmac_rx_crc_cfg_shift_right      0
#define DFLT_VAL_NX10_xmac_rx_crc_cfg_shift_right 0x00000000U
#define MSK_NX10_xmac_rx_crc_cfg_zero             0x00000002U
#define SRT_NX10_xmac_rx_crc_cfg_zero             1
#define DFLT_VAL_NX10_xmac_rx_crc_cfg_zero        0x00000000U
#define MSK_NX10_xmac_rx_crc_cfg_invert           0x00000004U
#define SRT_NX10_xmac_rx_crc_cfg_invert           2
#define DFLT_VAL_NX10_xmac_rx_crc_cfg_invert      0x00000000U
#define MSK_NX10_xmac_rx_crc_cfg_len              0x000000f8U
#define SRT_NX10_xmac_rx_crc_cfg_len              3
#define DFLT_VAL_NX10_xmac_rx_crc_cfg_len         0x00000000U
#define MSK_NX10_xmac_rx_crc_cfg_nof_bits         0x00000300U
#define SRT_NX10_xmac_rx_crc_cfg_nof_bits         8
#define DFLT_VAL_NX10_xmac_rx_crc_cfg_nof_bits    0x00000000U
#define MSK_NX10_xmac_rx_crc_cfg_direct_div       0x00000400U
#define SRT_NX10_xmac_rx_crc_cfg_direct_div       10
#define DFLT_VAL_NX10_xmac_rx_crc_cfg_direct_div  0x00000000U
#define MSK_NX10_xmac_rx_crc_cfg_endian           0x00000800U
#define SRT_NX10_xmac_rx_crc_cfg_endian           11
#define DFLT_VAL_NX10_xmac_rx_crc_cfg_endian      0x00000000U
#define MSK_NX10_xmac_rx_crc_cfg_swap_output      0x00001000U
#define SRT_NX10_xmac_rx_crc_cfg_swap_output      12
#define DFLT_VAL_NX10_xmac_rx_crc_cfg_swap_output 0x00000000U

enum {
	BFW_NX10_xmac_rx_crc_cfg_shift_right = 1,  /* [0] */
	BFW_NX10_xmac_rx_crc_cfg_zero        = 1,  /* [1] */
	BFW_NX10_xmac_rx_crc_cfg_invert      = 1,  /* [2] */
	BFW_NX10_xmac_rx_crc_cfg_len         = 5,  /* [7:3] */
	BFW_NX10_xmac_rx_crc_cfg_nof_bits    = 2,  /* [9:8] */
	BFW_NX10_xmac_rx_crc_cfg_direct_div  = 1,  /* [10] */
	BFW_NX10_xmac_rx_crc_cfg_endian      = 1,  /* [11] */
	BFW_NX10_xmac_rx_crc_cfg_swap_output = 1,  /* [12] */
	BFW_NX10_xmac_rx_crc_cfg_reserved1   = 19  /* [31:13] */
};

typedef struct NX10_XMAC_RX_CRC_CFG_BIT_Ttag {
	unsigned int shift_right : BFW_NX10_xmac_rx_crc_cfg_shift_right; /* Shift RX CRC from left to right                                        */
	                                                                 /* (usually used with crc_swap_output but inverted in case of crc_endian) */
	unsigned int zero        : BFW_NX10_xmac_rx_crc_cfg_zero;        /* Set input of RX CRC to zero (before invert)                            */
	unsigned int invert      : BFW_NX10_xmac_rx_crc_cfg_invert;      /* Invert input of RX CRC                                                 */
	unsigned int len         : BFW_NX10_xmac_rx_crc_cfg_len;         /* Length of RX_CRC minus 1 (0-31)                                        */
	unsigned int nof_bits    : BFW_NX10_xmac_rx_crc_cfg_nof_bits;    /* 1(0),2(1),4(2),8(3) Bits from rx register to be executed in parallel   */
	unsigned int direct_div  : BFW_NX10_xmac_rx_crc_cfg_direct_div;  /* calculate direct polynomial division without n zeros after frame       */
	unsigned int endian      : BFW_NX10_xmac_rx_crc_cfg_endian;      /* Swap incoming bits in case of nof_bits = 2,4,8                         */
	unsigned int swap_output : BFW_NX10_xmac_rx_crc_cfg_swap_output; /* Swap output of crc at PU access                                        */
	unsigned int reserved1   : BFW_NX10_xmac_rx_crc_cfg_reserved1;   /* reserved                                                               */
} NX10_XMAC_RX_CRC_CFG_BIT_T;

typedef union {
	unsigned int               val;
	NX10_XMAC_RX_CRC_CFG_BIT_T bf;
} NX10_XMAC_RX_CRC_CFG_T;

/* --------------------------------------------------------------------- */
/* Register xmac_tx_crc_polynomial_l */
/* => xMAC TX CRC Polynomial lower part */
/*    This register has a write pipeline delay of 1 clock cycle */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX10_xmac_tx_crc_polynomial_l   0x000009ECU
#define Adr_NX10_xmac0_xmac_tx_crc_polynomial_l 0x101A09ECU
#define Adr_NX10_xmac_tx_crc_polynomial_l       0x101A09ECU
#define DFLT_VAL_NX10_xmac_tx_crc_polynomial_l  0x00000000U

#define MSK_NX10_xmac_tx_crc_polynomial_l_TX_POL_L      0x0000ffffU
#define SRT_NX10_xmac_tx_crc_polynomial_l_TX_POL_L      0
#define DFLT_VAL_NX10_xmac_tx_crc_polynomial_l_TX_POL_L 0x00000000U

enum {
	BFW_NX10_xmac_tx_crc_polynomial_l_TX_POL_L  = 16, /* [15:0] */
	BFW_NX10_xmac_tx_crc_polynomial_l_reserved1 = 16  /* [31:16] */
};

typedef struct NX10_XMAC_TX_CRC_POLYNOMIAL_L_BIT_Ttag {
	unsigned int TX_POL_L  : BFW_NX10_xmac_tx_crc_polynomial_l_TX_POL_L;  /* lower bits of TX-CRC Polynomial */
	unsigned int reserved1 : BFW_NX10_xmac_tx_crc_polynomial_l_reserved1; /* reserved                        */
} NX10_XMAC_TX_CRC_POLYNOMIAL_L_BIT_T;

typedef union {
	unsigned int                        val;
	NX10_XMAC_TX_CRC_POLYNOMIAL_L_BIT_T bf;
} NX10_XMAC_TX_CRC_POLYNOMIAL_L_T;

/* --------------------------------------------------------------------- */
/* Register xmac_tx_crc_polynomial_h */
/* => xMAC TX CRC Polynomial lower part */
/*    This register has a write pipeline delay of 1 clock cycle */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX10_xmac_tx_crc_polynomial_h   0x000009F0U
#define Adr_NX10_xmac0_xmac_tx_crc_polynomial_h 0x101A09F0U
#define Adr_NX10_xmac_tx_crc_polynomial_h       0x101A09F0U
#define DFLT_VAL_NX10_xmac_tx_crc_polynomial_h  0x00000000U

#define MSK_NX10_xmac_tx_crc_polynomial_h_TX_POL_H      0x0000ffffU
#define SRT_NX10_xmac_tx_crc_polynomial_h_TX_POL_H      0
#define DFLT_VAL_NX10_xmac_tx_crc_polynomial_h_TX_POL_H 0x00000000U

enum {
	BFW_NX10_xmac_tx_crc_polynomial_h_TX_POL_H  = 16, /* [15:0] */
	BFW_NX10_xmac_tx_crc_polynomial_h_reserved1 = 16  /* [31:16] */
};

typedef struct NX10_XMAC_TX_CRC_POLYNOMIAL_H_BIT_Ttag {
	unsigned int TX_POL_H  : BFW_NX10_xmac_tx_crc_polynomial_h_TX_POL_H;  /* upper bits of TX-CRC Polynomial */
	unsigned int reserved1 : BFW_NX10_xmac_tx_crc_polynomial_h_reserved1; /* reserved                        */
} NX10_XMAC_TX_CRC_POLYNOMIAL_H_BIT_T;

typedef union {
	unsigned int                        val;
	NX10_XMAC_TX_CRC_POLYNOMIAL_H_BIT_T bf;
} NX10_XMAC_TX_CRC_POLYNOMIAL_H_T;

/* --------------------------------------------------------------------- */
/* Register xmac_tx_crc_l */
/* => xMAC TX CRC lower part */
/*    This register has a write pipeline delay of 1 clock cycle */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX10_xmac_tx_crc_l   0x000009F4U
#define Adr_NX10_xmac0_xmac_tx_crc_l 0x101A09F4U
#define Adr_NX10_xmac_tx_crc_l       0x101A09F4U
#define DFLT_VAL_NX10_xmac_tx_crc_l  0x00000000U

#define MSK_NX10_xmac_tx_crc_l_TX_CRC_L      0x0000ffffU
#define SRT_NX10_xmac_tx_crc_l_TX_CRC_L      0
#define DFLT_VAL_NX10_xmac_tx_crc_l_TX_CRC_L 0x00000000U

enum {
	BFW_NX10_xmac_tx_crc_l_TX_CRC_L  = 16, /* [15:0] */
	BFW_NX10_xmac_tx_crc_l_reserved1 = 16  /* [31:16] */
};

typedef struct NX10_XMAC_TX_CRC_L_BIT_Ttag {
	unsigned int TX_CRC_L  : BFW_NX10_xmac_tx_crc_l_TX_CRC_L;  /* lower bits of TX-CRC */
	unsigned int reserved1 : BFW_NX10_xmac_tx_crc_l_reserved1; /* reserved             */
} NX10_XMAC_TX_CRC_L_BIT_T;

typedef union {
	unsigned int             val;
	NX10_XMAC_TX_CRC_L_BIT_T bf;
} NX10_XMAC_TX_CRC_L_T;

/* --------------------------------------------------------------------- */
/* Register xmac_tx_crc_h */
/* => xMAC TX CRC upper part */
/*    This register has a write pipeline delay of 1 clock cycle */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX10_xmac_tx_crc_h   0x000009F8U
#define Adr_NX10_xmac0_xmac_tx_crc_h 0x101A09F8U
#define Adr_NX10_xmac_tx_crc_h       0x101A09F8U
#define DFLT_VAL_NX10_xmac_tx_crc_h  0x00000000U

#define MSK_NX10_xmac_tx_crc_h_TX_CRC_H      0x0000ffffU
#define SRT_NX10_xmac_tx_crc_h_TX_CRC_H      0
#define DFLT_VAL_NX10_xmac_tx_crc_h_TX_CRC_H 0x00000000U

enum {
	BFW_NX10_xmac_tx_crc_h_TX_CRC_H  = 16, /* [15:0] */
	BFW_NX10_xmac_tx_crc_h_reserved1 = 16  /* [31:16] */
};

typedef struct NX10_XMAC_TX_CRC_H_BIT_Ttag {
	unsigned int TX_CRC_H  : BFW_NX10_xmac_tx_crc_h_TX_CRC_H;  /* upper bits of TX-CRC */
	unsigned int reserved1 : BFW_NX10_xmac_tx_crc_h_reserved1; /* reserved             */
} NX10_XMAC_TX_CRC_H_BIT_T;

typedef union {
	unsigned int             val;
	NX10_XMAC_TX_CRC_H_BIT_T bf;
} NX10_XMAC_TX_CRC_H_T;

/* --------------------------------------------------------------------- */
/* Register xmac_tx_crc_cfg */
/* => xMAC TX CRC Config Register */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX10_xmac_tx_crc_cfg   0x000009FCU
#define Adr_NX10_xmac0_xmac_tx_crc_cfg 0x101A09FCU
#define Adr_NX10_xmac_tx_crc_cfg       0x101A09FCU
#define DFLT_VAL_NX10_xmac_tx_crc_cfg  0x00000000U

#define MSK_NX10_xmac_tx_crc_cfg_shift_right      0x00000001U
#define SRT_NX10_xmac_tx_crc_cfg_shift_right      0
#define DFLT_VAL_NX10_xmac_tx_crc_cfg_shift_right 0x00000000U
#define MSK_NX10_xmac_tx_crc_cfg_zero             0x00000002U
#define SRT_NX10_xmac_tx_crc_cfg_zero             1
#define DFLT_VAL_NX10_xmac_tx_crc_cfg_zero        0x00000000U
#define MSK_NX10_xmac_tx_crc_cfg_invert           0x00000004U
#define SRT_NX10_xmac_tx_crc_cfg_invert           2
#define DFLT_VAL_NX10_xmac_tx_crc_cfg_invert      0x00000000U
#define MSK_NX10_xmac_tx_crc_cfg_len              0x000000f8U
#define SRT_NX10_xmac_tx_crc_cfg_len              3
#define DFLT_VAL_NX10_xmac_tx_crc_cfg_len         0x00000000U
#define MSK_NX10_xmac_tx_crc_cfg_nof_bits         0x00000300U
#define SRT_NX10_xmac_tx_crc_cfg_nof_bits         8
#define DFLT_VAL_NX10_xmac_tx_crc_cfg_nof_bits    0x00000000U
#define MSK_NX10_xmac_tx_crc_cfg_direct_div       0x00000400U
#define SRT_NX10_xmac_tx_crc_cfg_direct_div       10
#define DFLT_VAL_NX10_xmac_tx_crc_cfg_direct_div  0x00000000U
#define MSK_NX10_xmac_tx_crc_cfg_endian           0x00000800U
#define SRT_NX10_xmac_tx_crc_cfg_endian           11
#define DFLT_VAL_NX10_xmac_tx_crc_cfg_endian      0x00000000U
#define MSK_NX10_xmac_tx_crc_cfg_swap_output      0x00001000U
#define SRT_NX10_xmac_tx_crc_cfg_swap_output      12
#define DFLT_VAL_NX10_xmac_tx_crc_cfg_swap_output 0x00000000U

enum {
	BFW_NX10_xmac_tx_crc_cfg_shift_right = 1,  /* [0] */
	BFW_NX10_xmac_tx_crc_cfg_zero        = 1,  /* [1] */
	BFW_NX10_xmac_tx_crc_cfg_invert      = 1,  /* [2] */
	BFW_NX10_xmac_tx_crc_cfg_len         = 5,  /* [7:3] */
	BFW_NX10_xmac_tx_crc_cfg_nof_bits    = 2,  /* [9:8] */
	BFW_NX10_xmac_tx_crc_cfg_direct_div  = 1,  /* [10] */
	BFW_NX10_xmac_tx_crc_cfg_endian      = 1,  /* [11] */
	BFW_NX10_xmac_tx_crc_cfg_swap_output = 1,  /* [12] */
	BFW_NX10_xmac_tx_crc_cfg_reserved1   = 19  /* [31:13] */
};

typedef struct NX10_XMAC_TX_CRC_CFG_BIT_Ttag {
	unsigned int shift_right : BFW_NX10_xmac_tx_crc_cfg_shift_right; /* Shift TX CRC from left to right                                        */
	                                                                 /* (usually used with crc_swap_output but inverted in case of crc_endian) */
	unsigned int zero        : BFW_NX10_xmac_tx_crc_cfg_zero;        /* Set input of TX CRC to zero (before invert)                            */
	unsigned int invert      : BFW_NX10_xmac_tx_crc_cfg_invert;      /* Invert input of TX CRC                                                 */
	unsigned int len         : BFW_NX10_xmac_tx_crc_cfg_len;         /* Length of TX_CRC minus 1 (0-31)                                        */
	unsigned int nof_bits    : BFW_NX10_xmac_tx_crc_cfg_nof_bits;    /* 1(0),2(1),4(2),8(3) Bits from tx_register to be executed in parallel   */
	unsigned int direct_div  : BFW_NX10_xmac_tx_crc_cfg_direct_div;  /* calculate direct polynomial division without n zeros after frame       */
	unsigned int endian      : BFW_NX10_xmac_tx_crc_cfg_endian;      /* Swap incoming bits in case of nof_bits = 2,4,8                         */
	unsigned int swap_output : BFW_NX10_xmac_tx_crc_cfg_swap_output; /* Swap output of crc at PU access                                        */
	unsigned int reserved1   : BFW_NX10_xmac_tx_crc_cfg_reserved1;   /* reserved                                                               */
} NX10_XMAC_TX_CRC_CFG_BIT_T;

typedef union {
	unsigned int               val;
	NX10_XMAC_TX_CRC_CFG_BIT_T bf;
} NX10_XMAC_TX_CRC_CFG_T;

/* --------------------------------------------------------------------- */
/* Register xmac_rpu_hold_pc */
/* => xMAC RPU hold_pc register: */
/*    rpu_hold_pc and tpu_hold_pc are the only registers accessible by ARM-CPU, */
/*    while RPU or TPU are running (hold=0). */
/*    To access other registers of xMAC, first hold RPU and TPU. */
/*    This register is not visible for xMAC RPU and TPU. */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX10_xmac_rpu_hold_pc   0x00000A00U
#define Adr_NX10_xmac0_xmac_rpu_hold_pc 0x101A0A00U
#define Adr_NX10_xmac_rpu_hold_pc       0x101A0A00U
#define DFLT_VAL_NX10_xmac_rpu_hold_pc  0x00008000U

#define MSK_NX10_xmac_rpu_hold_pc_rpu_pc        0x0000007fU
#define SRT_NX10_xmac_rpu_hold_pc_rpu_pc        0
#define DFLT_VAL_NX10_xmac_rpu_hold_pc_rpu_pc   0x00000000U
#define MSK_NX10_xmac_rpu_hold_pc_rpu_hold      0x00008000U
#define SRT_NX10_xmac_rpu_hold_pc_rpu_hold      15
#define DFLT_VAL_NX10_xmac_rpu_hold_pc_rpu_hold 0x00008000U

enum {
	BFW_NX10_xmac_rpu_hold_pc_rpu_pc    = 7,  /* [6:0] */
	BFW_NX10_xmac_rpu_hold_pc_reserved1 = 8,  /* [14:7] */
	BFW_NX10_xmac_rpu_hold_pc_rpu_hold  = 1,  /* [15] */
	BFW_NX10_xmac_rpu_hold_pc_reserved2 = 16  /* [31:16] */
};

typedef struct NX10_XMAC_RPU_HOLD_PC_BIT_Ttag {
	unsigned int rpu_pc    : BFW_NX10_xmac_rpu_hold_pc_rpu_pc;    /* Program counter (read only, write can happen via adr_xmac_rpu_pc) */
	unsigned int reserved1 : BFW_NX10_xmac_rpu_hold_pc_reserved1; /* reserved                                                          */
	unsigned int rpu_hold  : BFW_NX10_xmac_rpu_hold_pc_rpu_hold;  /* to hold RPU                                                       */
	unsigned int reserved2 : BFW_NX10_xmac_rpu_hold_pc_reserved2; /* reserved                                                          */
} NX10_XMAC_RPU_HOLD_PC_BIT_T;

typedef union {
	unsigned int                val;
	NX10_XMAC_RPU_HOLD_PC_BIT_T bf;
} NX10_XMAC_RPU_HOLD_PC_T;

/* --------------------------------------------------------------------- */
/* Register xmac_tpu_hold_pc */
/* => xMAC TPU hold_pc register: */
/*    rpu_hold_pc and tpu_hold_pc are the only registers accessible by ARM-CPU, */
/*    while RPU or TPU are running (hold=0). */
/*    To access other registers of xMAC, first hold RPU and TPU. */
/*    This register is not visible for xMAC RPU and TPU. */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX10_xmac_tpu_hold_pc   0x00000A04U
#define Adr_NX10_xmac0_xmac_tpu_hold_pc 0x101A0A04U
#define Adr_NX10_xmac_tpu_hold_pc       0x101A0A04U
#define DFLT_VAL_NX10_xmac_tpu_hold_pc  0x00008000U

#define MSK_NX10_xmac_tpu_hold_pc_tpu_pc        0x0000007fU
#define SRT_NX10_xmac_tpu_hold_pc_tpu_pc        0
#define DFLT_VAL_NX10_xmac_tpu_hold_pc_tpu_pc   0x00000000U
#define MSK_NX10_xmac_tpu_hold_pc_tpu_hold      0x00008000U
#define SRT_NX10_xmac_tpu_hold_pc_tpu_hold      15
#define DFLT_VAL_NX10_xmac_tpu_hold_pc_tpu_hold 0x00008000U

enum {
	BFW_NX10_xmac_tpu_hold_pc_tpu_pc    = 7,  /* [6:0] */
	BFW_NX10_xmac_tpu_hold_pc_reserved1 = 8,  /* [14:7] */
	BFW_NX10_xmac_tpu_hold_pc_tpu_hold  = 1,  /* [15] */
	BFW_NX10_xmac_tpu_hold_pc_reserved2 = 16  /* [31:16] */
};

typedef struct NX10_XMAC_TPU_HOLD_PC_BIT_Ttag {
	unsigned int tpu_pc    : BFW_NX10_xmac_tpu_hold_pc_tpu_pc;    /* Program counter (read only, write can happen via adr_xmac_tpu_pc) */
	unsigned int reserved1 : BFW_NX10_xmac_tpu_hold_pc_reserved1; /* reserved                                                          */
	unsigned int tpu_hold  : BFW_NX10_xmac_tpu_hold_pc_tpu_hold;  /* to hold TPU                                                       */
	unsigned int reserved2 : BFW_NX10_xmac_tpu_hold_pc_reserved2; /* reserved                                                          */
} NX10_XMAC_TPU_HOLD_PC_BIT_T;

typedef union {
	unsigned int                val;
	NX10_XMAC_TPU_HOLD_PC_BIT_T bf;
} NX10_XMAC_TPU_HOLD_PC_T;


/* ===================================================================== */

/* AREA pointer_fifo */
/* Area of pointer_fifo, pointer_fifo_motion */

/* ===================================================================== */

#define Addr_NX10_pointer_fifo        0x101A4000U
#define NX10_NETX_PTR_FIFO_AREA       0x101A4000U
#define Addr_NX10_pointer_fifo_motion 0x10124000U

/* --------------------------------------------------------------------- */
/* Register pfifo_base */
/* => Pointer FIFO table: */
/*    Each of the following 16 addresses accesses a FIFO. */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX10_pfifo_base                 0x00000000U
#define Adr_NX10_pointer_fifo_pfifo_base        0x101A4000U
#define Adr_NX10_pointer_fifo_motion_pfifo_base 0x10124000U
#define DFLT_VAL_NX10_pfifo_base                0x00000000U

#define MSK_NX10_pfifo_base_fifo_data      0xffffffffU
#define SRT_NX10_pfifo_base_fifo_data      0
#define DFLT_VAL_NX10_pfifo_base_fifo_data 0x00000000U

enum {
	BFW_NX10_pfifo_base_fifo_data = 32  /* [31:0] */
};

typedef struct NX10_PFIFO_BASE_BIT_Ttag {
	unsigned int fifo_data : BFW_NX10_pfifo_base_fifo_data; /* In/output data to/from FIFO:     */
	                                                        /* write access: write data to FIFO */
} NX10_PFIFO_BASE_BIT_T;

typedef union {
	unsigned int          val;
	NX10_PFIFO_BASE_BIT_T bf;
} NX10_PFIFO_BASE_T;

/* --------------------------------------------------------------------- */
/* Register pfifo_border_base */
/* => Pointer FIFO Upper Borders table: */
/*    The sizes of all FIFOs are programmable. The total size of all FIFOs must not exceed 1024 dwords. \ */
/*    Each of the following 16 addresses accesses the upper border of the appropriate FIFO in a 1024x32 bit RAM. \ */
/*    All upper borders should be rising with number of FIFO. \ */
/*    Each FIFO starts at the upper border + 1 of the preceding FIFO and ends at its upper border. */
/*    If a border between two FIFOs is moved, the adjacent FIFOs should be reset first. */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX10_pfifo_border_base                 0x00000040U
#define Adr_NX10_pointer_fifo_pfifo_border_base        0x101A4040U
#define Adr_NX10_pointer_fifo_motion_pfifo_border_base 0x10124040U
#define DFLT_VAL_NX10_pfifo_border_base                0x00000000U

#define MSK_NX10_pfifo_border_base_border      0x000003ffU
#define SRT_NX10_pfifo_border_base_border      0
#define DFLT_VAL_NX10_pfifo_border_base_border 0x00000000U

enum {
	BFW_NX10_pfifo_border_base_border    = 10, /* [9:0] */
	BFW_NX10_pfifo_border_base_reserved1 = 22  /* [31:10] */
};

typedef struct NX10_PFIFO_BORDER_BASE_BIT_Ttag {
	unsigned int border    : BFW_NX10_pfifo_border_base_border;    /* last address of RAM used by appropriate FIFO, = (first address-1) of next FIFO. */
	                                                               /* FIFO 0 default depth:     512                                                   */
	unsigned int reserved1 : BFW_NX10_pfifo_border_base_reserved1; /* reserved                                                                        */
} NX10_PFIFO_BORDER_BASE_BIT_T;

typedef union {
	unsigned int                 val;
	NX10_PFIFO_BORDER_BASE_BIT_T bf;
} NX10_PFIFO_BORDER_BASE_T;

/* --------------------------------------------------------------------- */
/* Register pfifo_reset */
/* => Pointer FIFO Reset Vector: */
/*    This register allows to reset each of 16 FIFOs, \ */
/*    i.e. set read and write pointer to lower border of FIFO, reset full, overflow, underrun flag and set empty flag. */
/*    The reset flag of adjacent FIFOs should be set before resizing the FIFO. */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX10_pfifo_reset                 0x00000080U
#define Adr_NX10_pointer_fifo_pfifo_reset        0x101A4080U
#define Adr_NX10_pointer_fifo_motion_pfifo_reset 0x10124080U
#define DFLT_VAL_NX10_pfifo_reset                0x00000000U

#define MSK_NX10_pfifo_reset_reset_fifo      0x0000ffffU
#define SRT_NX10_pfifo_reset_reset_fifo      0
#define DFLT_VAL_NX10_pfifo_reset_reset_fifo 0x00000000U

enum {
	BFW_NX10_pfifo_reset_reset_fifo = 16, /* [15:0] */
	BFW_NX10_pfifo_reset_reserved1  = 16  /* [31:16] */
};

typedef struct NX10_PFIFO_RESET_BIT_Ttag {
	unsigned int reset_fifo : BFW_NX10_pfifo_reset_reset_fifo; /* Reset Vector, 1 bit per FIFO: */
	                                                           /* 1: reset FIFO                 */
	unsigned int reserved1  : BFW_NX10_pfifo_reset_reserved1;  /* reserved                      */
} NX10_PFIFO_RESET_BIT_T;

typedef union {
	unsigned int           val;
	NX10_PFIFO_RESET_BIT_T bf;
} NX10_PFIFO_RESET_T;

/* --------------------------------------------------------------------- */
/* Register pfifo_full */
/* => Pointer FIFO Full Vector: */
/*    This read only address shows the fifo_full flag of each FIFO. */
/* => Mode: R */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX10_pfifo_full                 0x00000084U
#define Adr_NX10_pointer_fifo_pfifo_full        0x101A4084U
#define Adr_NX10_pointer_fifo_motion_pfifo_full 0x10124084U

#define MSK_NX10_pfifo_full_fifo_full 0x0000ffffU
#define SRT_NX10_pfifo_full_fifo_full 0

enum {
	BFW_NX10_pfifo_full_fifo_full = 16, /* [15:0] */
	BFW_NX10_pfifo_full_reserved1 = 16  /* [31:16] */
};

typedef struct NX10_PFIFO_FULL_BIT_Ttag {
	unsigned int fifo_full : BFW_NX10_pfifo_full_fifo_full; /* FIFO full vector, 1 bit per FIFO */
	unsigned int reserved1 : BFW_NX10_pfifo_full_reserved1; /* reserved                         */
} NX10_PFIFO_FULL_BIT_T;

typedef union {
	unsigned int          val;
	NX10_PFIFO_FULL_BIT_T bf;
} NX10_PFIFO_FULL_T;

/* --------------------------------------------------------------------- */
/* Register pfifo_empty */
/* => Pointer FIFO Empty Vector: */
/*    This read only address shows the fifo_empty flag of each FIFO. */
/* => Mode: R */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX10_pfifo_empty                 0x00000088U
#define Adr_NX10_pointer_fifo_pfifo_empty        0x101A4088U
#define Adr_NX10_pointer_fifo_motion_pfifo_empty 0x10124088U

#define MSK_NX10_pfifo_empty_fifo_empty 0x0000ffffU
#define SRT_NX10_pfifo_empty_fifo_empty 0

enum {
	BFW_NX10_pfifo_empty_fifo_empty = 16, /* [15:0] */
	BFW_NX10_pfifo_empty_reserved1  = 16  /* [31:16] */
};

typedef struct NX10_PFIFO_EMPTY_BIT_Ttag {
	unsigned int fifo_empty : BFW_NX10_pfifo_empty_fifo_empty; /* FIFO empty vector, 1 bit per FIFO */
	unsigned int reserved1  : BFW_NX10_pfifo_empty_reserved1;  /* reserved                          */
} NX10_PFIFO_EMPTY_BIT_T;

typedef union {
	unsigned int           val;
	NX10_PFIFO_EMPTY_BIT_T bf;
} NX10_PFIFO_EMPTY_T;

/* --------------------------------------------------------------------- */
/* Register pfifo_overflow */
/* => Pointer FIFO Overflow Vector: */
/*    This read only address shows the fifo_overflow flag of each FIFO. */
/*    If the FIFO had an overflow, it should be reset. */
/* => Mode: R */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX10_pfifo_overflow                 0x0000008CU
#define Adr_NX10_pointer_fifo_pfifo_overflow        0x101A408CU
#define Adr_NX10_pointer_fifo_motion_pfifo_overflow 0x1012408CU

#define MSK_NX10_pfifo_overflow_fifo_overflow 0x0000ffffU
#define SRT_NX10_pfifo_overflow_fifo_overflow 0

enum {
	BFW_NX10_pfifo_overflow_fifo_overflow = 16, /* [15:0] */
	BFW_NX10_pfifo_overflow_reserved1     = 16  /* [31:16] */
};

typedef struct NX10_PFIFO_OVERFLOW_BIT_Ttag {
	unsigned int fifo_overflow : BFW_NX10_pfifo_overflow_fifo_overflow; /* FIFO overflow vector, 1 bit per FIFO */
	unsigned int reserved1     : BFW_NX10_pfifo_overflow_reserved1;     /* reserved                             */
} NX10_PFIFO_OVERFLOW_BIT_T;

typedef union {
	unsigned int              val;
	NX10_PFIFO_OVERFLOW_BIT_T bf;
} NX10_PFIFO_OVERFLOW_T;

/* --------------------------------------------------------------------- */
/* Register pfifo_underrun */
/* => Pointer FIFO Underrun Vector: */
/*    This read only address shows the fifo_underrun flag of each FIFO. */
/*    If the FIFO had an underrun, it should be reset. */
/* => Mode: R */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX10_pfifo_underrun                 0x00000090U
#define Adr_NX10_pointer_fifo_pfifo_underrun        0x101A4090U
#define Adr_NX10_pointer_fifo_motion_pfifo_underrun 0x10124090U

#define MSK_NX10_pfifo_underrun_fifo_underrun 0x0000ffffU
#define SRT_NX10_pfifo_underrun_fifo_underrun 0

enum {
	BFW_NX10_pfifo_underrun_fifo_underrun = 16, /* [15:0] */
	BFW_NX10_pfifo_underrun_reserved1     = 16  /* [31:16] */
};

typedef struct NX10_PFIFO_UNDERRUN_BIT_Ttag {
	unsigned int fifo_underrun : BFW_NX10_pfifo_underrun_fifo_underrun; /* FIFO underrun vector, 1 bit per FIFO */
	unsigned int reserved1     : BFW_NX10_pfifo_underrun_reserved1;     /* reserved                             */
} NX10_PFIFO_UNDERRUN_BIT_T;

typedef union {
	unsigned int              val;
	NX10_PFIFO_UNDERRUN_BIT_T bf;
} NX10_PFIFO_UNDERRUN_T;

/* --------------------------------------------------------------------- */
/* Register pfifo_fill_level_base */
/* => Pointer FIFO Fill-Level table: */
/*    Each of the following 16 addresses reads the fill-level of the appropriate FIFO. */
/* => Mode: R */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX10_pfifo_fill_level_base                 0x000000C0U
#define Adr_NX10_pointer_fifo_pfifo_fill_level_base        0x101A40C0U
#define Adr_NX10_pointer_fifo_motion_pfifo_fill_level_base 0x101240C0U

#define MSK_NX10_pfifo_fill_level_base_fill_level 0x000003ffU
#define SRT_NX10_pfifo_fill_level_base_fill_level 0

enum {
	BFW_NX10_pfifo_fill_level_base_fill_level = 10, /* [9:0] */
	BFW_NX10_pfifo_fill_level_base_reserved1  = 22  /* [31:10] */
};

typedef struct NX10_PFIFO_FILL_LEVEL_BASE_BIT_Ttag {
	unsigned int fill_level : BFW_NX10_pfifo_fill_level_base_fill_level; /* actual number of words in appropriate FIFO       */
	                                                                     /* (not valid, if FIFO had an overflow or underrun) */
	unsigned int reserved1  : BFW_NX10_pfifo_fill_level_base_reserved1;  /* reserved                                         */
} NX10_PFIFO_FILL_LEVEL_BASE_BIT_T;

typedef union {
	unsigned int                     val;
	NX10_PFIFO_FILL_LEVEL_BASE_BIT_T bf;
} NX10_PFIFO_FILL_LEVEL_BASE_T;


/* ===================================================================== */

/* Area of xpec_irq_registers */

/* ===================================================================== */

#define Addr_NX10_xpec_irq_registers 0x101A4400U
#define NX10_NETX_XP_IRQ_AREA        0x101A4400U

/* --------------------------------------------------------------------- */
/* Register irq_xpec0 */
/* => IRQ_XPEC 0 */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX10_irq_xpec0                0x00000000U
#define Adr_NX10_xpec_irq_registers_irq_xpec0 0x101A4400U
#define Adr_NX10_irq_xpec0                    0x101A4400U
#define DFLT_VAL_NX10_irq_xpec0               0x00000000U

#define MSK_NX10_irq_xpec0_xpec_irq      0x0000ffffU
#define SRT_NX10_irq_xpec0_xpec_irq      0
#define DFLT_VAL_NX10_irq_xpec0_xpec_irq 0x00000000U
#define MSK_NX10_irq_xpec0_arm_irq       0xffff0000U
#define SRT_NX10_irq_xpec0_arm_irq       16
#define DFLT_VAL_NX10_irq_xpec0_arm_irq  0x00000000U

enum {
	BFW_NX10_irq_xpec0_xpec_irq = 16, /* [15:0] */
	BFW_NX10_irq_xpec0_arm_irq  = 16  /* [31:16] */
};

typedef struct NX10_IRQ_XPEC0_BIT_Ttag {
	unsigned int xpec_irq : BFW_NX10_irq_xpec0_xpec_irq; /* set by xpec ; reset by arm  */
	unsigned int arm_irq  : BFW_NX10_irq_xpec0_arm_irq;  /* set by arm  ; reset by xpec */
} NX10_IRQ_XPEC0_BIT_T;

typedef union {
	unsigned int         val;
	NX10_IRQ_XPEC0_BIT_T bf;
} NX10_IRQ_XPEC0_T;


/* ===================================================================== */

/* Area of xc_mem_prot */

/* ===================================================================== */

#define Addr_NX10_xc_mem_prot 0x101A4800U
#define NX10_NETX_XC_MEM_PROT 0x101A4800U

/* --------------------------------------------------------------------- */
/* Register xpec0_ram_low */
/* => not protected memory area (lower border) */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX10_xpec0_ram_low         0x00000000U
#define Adr_NX10_xc_mem_prot_xpec0_ram_low 0x101A4800U
#define Adr_NX10_xpec0_ram_low             0x101A4800U
#define DFLT_VAL_NX10_xpec0_ram_low        0x00000000U

#define MSK_NX10_xpec0_ram_low_xpec0_ram_low      0x00001fffU
#define SRT_NX10_xpec0_ram_low_xpec0_ram_low      0
#define DFLT_VAL_NX10_xpec0_ram_low_xpec0_ram_low 0x00000000U

enum {
	BFW_NX10_xpec0_ram_low_xpec0_ram_low = 13, /* [12:0] */
	BFW_NX10_xpec0_ram_low_reserved1     = 19  /* [31:13] */
};

typedef struct NX10_XPEC0_RAM_LOW_BIT_Ttag {
	unsigned int xpec0_ram_low : BFW_NX10_xpec0_ram_low_xpec0_ram_low; /* lower border (include) of not protected memory area */
	unsigned int reserved1     : BFW_NX10_xpec0_ram_low_reserved1;     /* reserved                                            */
} NX10_XPEC0_RAM_LOW_BIT_T;

typedef union {
	unsigned int             val;
	NX10_XPEC0_RAM_LOW_BIT_T bf;
} NX10_XPEC0_RAM_LOW_T;

/* --------------------------------------------------------------------- */
/* Register xpec0_ram_high */
/* => not protected memory area (higher border) */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX10_xpec0_ram_high         0x00000010U
#define Adr_NX10_xc_mem_prot_xpec0_ram_high 0x101A4810U
#define Adr_NX10_xpec0_ram_high             0x101A4810U
#define DFLT_VAL_NX10_xpec0_ram_high        0x00000000U

#define MSK_NX10_xpec0_ram_high_xpec0_ram_high      0x00001fffU
#define SRT_NX10_xpec0_ram_high_xpec0_ram_high      0
#define DFLT_VAL_NX10_xpec0_ram_high_xpec0_ram_high 0x00000000U

enum {
	BFW_NX10_xpec0_ram_high_xpec0_ram_high = 13, /* [12:0] */
	BFW_NX10_xpec0_ram_high_reserved1      = 19  /* [31:13] */
};

typedef struct NX10_XPEC0_RAM_HIGH_BIT_Ttag {
	unsigned int xpec0_ram_high : BFW_NX10_xpec0_ram_high_xpec0_ram_high; /* higher border(include) of not protected memory area */
	unsigned int reserved1      : BFW_NX10_xpec0_ram_high_reserved1;      /* reserved                                            */
} NX10_XPEC0_RAM_HIGH_BIT_T;

typedef union {
	unsigned int              val;
	NX10_XPEC0_RAM_HIGH_BIT_T bf;
} NX10_XPEC0_RAM_HIGH_T;

/* --------------------------------------------------------------------- */
/* Register prot_key_enable */
/* => protection key enable */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX10_prot_key_enable         0x00000100U
#define Adr_NX10_xc_mem_prot_prot_key_enable 0x101A4900U
#define Adr_NX10_prot_key_enable             0x101A4900U
#define DFLT_VAL_NX10_prot_key_enable        0x00000000U

#define MSK_NX10_prot_key_enable_prot_key_enable      0xffffffffU
#define SRT_NX10_prot_key_enable_prot_key_enable      0
#define DFLT_VAL_NX10_prot_key_enable_prot_key_enable 0x00000000U

enum {
	BFW_NX10_prot_key_enable_prot_key_enable = 32  /* [31:0] */
};

typedef struct NX10_PROT_KEY_ENABLE_BIT_Ttag {
	unsigned int prot_key_enable : BFW_NX10_prot_key_enable_prot_key_enable; /* 1. Read out the access key from this register. 2. Write back this access key to this register. 3. Memory protection is enable. */
} NX10_PROT_KEY_ENABLE_BIT_T;

typedef union {
	unsigned int               val;
	NX10_PROT_KEY_ENABLE_BIT_T bf;
} NX10_PROT_KEY_ENABLE_T;

/* --------------------------------------------------------------------- */
/* Register prot_key_disable */
/* => protection key disable */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX10_prot_key_disable         0x00000104U
#define Adr_NX10_xc_mem_prot_prot_key_disable 0x101A4904U
#define Adr_NX10_prot_key_disable             0x101A4904U
#define DFLT_VAL_NX10_prot_key_disable        0x00000000U

#define MSK_NX10_prot_key_disable_prot_key_disable      0xffffffffU
#define SRT_NX10_prot_key_disable_prot_key_disable      0
#define DFLT_VAL_NX10_prot_key_disable_prot_key_disable 0x00000000U

enum {
	BFW_NX10_prot_key_disable_prot_key_disable = 32  /* [31:0] */
};

typedef struct NX10_PROT_KEY_DISABLE_BIT_Ttag {
	unsigned int prot_key_disable : BFW_NX10_prot_key_disable_prot_key_disable; /* 1. Read out the access key from this register. 2. Write back this access key to this register. 3. Memory protection is disable. */
} NX10_PROT_KEY_DISABLE_BIT_T;

typedef union {
	unsigned int                val;
	NX10_PROT_KEY_DISABLE_BIT_T bf;
} NX10_PROT_KEY_DISABLE_T;

/* --------------------------------------------------------------------- */
/* Register prot_status */
/* => protection status */
/* => Mode: R */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX10_prot_status         0x00000108U
#define Adr_NX10_xc_mem_prot_prot_status 0x101A4908U
#define Adr_NX10_prot_status             0x101A4908U

#define MSK_NX10_prot_status_prot_stauts 0x00000001U
#define SRT_NX10_prot_status_prot_stauts 0

enum {
	BFW_NX10_prot_status_prot_stauts = 1,  /* [0] */
	BFW_NX10_prot_status_reserved1   = 31  /* [31:1] */
};

typedef struct NX10_PROT_STATUS_BIT_Ttag {
	unsigned int prot_stauts : BFW_NX10_prot_status_prot_stauts; /* Protection Status (read only) 1: protection mode 0: not protected */
	unsigned int reserved1   : BFW_NX10_prot_status_reserved1;   /* reserved                                                          */
} NX10_PROT_STATUS_BIT_T;

typedef union {
	unsigned int           val;
	NX10_PROT_STATUS_BIT_T bf;
} NX10_PROT_STATUS_T;


/* ===================================================================== */

/* AREA buf_man */
/* Area of buf_man, buf_man_motion */

/* ===================================================================== */

#define Addr_NX10_buf_man        0x101A5600U
#define NX10_NETX_BUF_MAN_AREA   0x101A5600U
#define Addr_NX10_buf_man_motion 0x10125600U

/* --------------------------------------------------------------------- */
/* Register buf_man */
/* => BMU can be accessed via 3 ports (xPEC, Adr_buf_man, Adr_buf_man_motion): */
/*    This register address allows to access 8 buffer controllers, where each one handles buffer numbers (0..3) between up */
/*    to three processors. Due to the complex functionality in one register address, bits have different meaning depending on */
/*    request type and mode. */
/*    Getting a new buffer always happens with two command accesses: */
/*    1st: Write access: Tell the buf_manager the channel(s) (0..7) and whether you request read or write buffer. */
/*         Wait for two clock cycles, until new buffer number is calculated after any write access. */
/*    2nd: Read access: Read the buffer number (0..3). */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX10_buf_man            0x00000000U
#define Adr_NX10_buf_man_buf_man        0x101A5600U
#define Adr_NX10_buf_man_motion_buf_man 0x10125600U
#define DFLT_VAL_NX10_buf_man           0x00000007U

#define MSK_NX10_buf_man_buf_nr              0x00000007U
#define SRT_NX10_buf_man_buf_nr              0
#define DFLT_VAL_NX10_buf_man_buf_nr         0x00000007U
#define MSK_NX10_buf_man_req_type            0x00000060U
#define SRT_NX10_buf_man_req_type            5
#define DFLT_VAL_NX10_buf_man_req_type       0x00000000U
#define MSK_NX10_buf_man_semaphore_mode      0x00000080U
#define SRT_NX10_buf_man_semaphore_mode      7
#define DFLT_VAL_NX10_buf_man_semaphore_mode 0x00000000U
#define MSK_NX10_buf_man_parallel_mode       0x00000100U
#define SRT_NX10_buf_man_parallel_mode       8
#define DFLT_VAL_NX10_buf_man_parallel_mode  0x00000000U
#define MSK_NX10_buf_man_reset               0x00000200U
#define SRT_NX10_buf_man_reset               9
#define DFLT_VAL_NX10_buf_man_reset          0x00000000U

enum {
	BFW_NX10_buf_man_buf_nr         = 3,  /* [2:0] */
	BFW_NX10_buf_man_reserved1      = 2,  /* [4:3] */
	BFW_NX10_buf_man_req_type       = 2,  /* [6:5] */
	BFW_NX10_buf_man_semaphore_mode = 1,  /* [7] */
	BFW_NX10_buf_man_parallel_mode  = 1,  /* [8] */
	BFW_NX10_buf_man_reset          = 1,  /* [9] */
	BFW_NX10_buf_man_reserved2      = 22  /* [31:10] */
};

typedef struct NX10_BUF_MAN_BIT_Ttag {
	unsigned int buf_nr         : BFW_NX10_buf_man_buf_nr;         /* Write access: number of buf_manager controller (0..7)                                            */
	                                                               /* Read access:  number of buffer (0..m+1), where m is the number of masters using this buf_manager */
	unsigned int reserved1      : BFW_NX10_buf_man_reserved1;      /* reserved                                                                                         */
	unsigned int req_type       : BFW_NX10_buf_man_req_type;       /* Request type bits are write-only:                                                                */
	                                                               /* 00: request read buffer (or semaphore)                                                           */
	unsigned int semaphore_mode : BFW_NX10_buf_man_semaphore_mode; /* Activate 'semaphore mode' for this buf_nr by writing 1 to this bit.                              */
	                                                               /* To return from semaphore-mode reset this channel.                                                */
	unsigned int parallel_mode  : BFW_NX10_buf_man_parallel_mode;  /* Activate parallel mode by writing 1 to this bit (other bits are ignored).                        */
	                                                               /* To return to normal mode, write 0x0000ff00 to this register.                                     */
	unsigned int reset          : BFW_NX10_buf_man_reset;          /* Reset channel.                                                                                   */
	unsigned int reserved2      : BFW_NX10_buf_man_reserved2;      /* reserved                                                                                         */
} NX10_BUF_MAN_BIT_T;

typedef union {
	unsigned int       val;
	NX10_BUF_MAN_BIT_T bf;
} NX10_BUF_MAN_T;


/* ===================================================================== */

/* Area of asic_ctrl */

/* ===================================================================== */

#define Addr_NX10_asic_ctrl 0x101C0000U
#define NX10_NETX_CTRL_AREA 0x101C0000U

/* --------------------------------------------------------------------- */
/* Register io_status */
/* => IO Status Register. */
/* => Mode: R */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX10_io_status       0x00000000U
#define Adr_NX10_asic_ctrl_io_status 0x101C0000U
#define Adr_NX10_io_status           0x101C0000U

#define MSK_NX10_io_status_bond_option     0x00000007U
#define SRT_NX10_io_status_bond_option     0
#define MSK_NX10_io_status_quick_count     0x00000008U
#define SRT_NX10_io_status_quick_count     3
#define MSK_NX10_io_status_pll_bypass      0x00000020U
#define SRT_NX10_io_status_pll_bypass      5
#define MSK_NX10_io_status_arm_crashdetect 0x00000040U
#define SRT_NX10_io_status_arm_crashdetect 6
#define MSK_NX10_io_status_TEST            0x00000080U
#define SRT_NX10_io_status_TEST            7

enum {
	BFW_NX10_io_status_bond_option     = 3,  /* [2:0] */
	BFW_NX10_io_status_quick_count     = 1,  /* [3] */
	BFW_NX10_io_status_reserved1       = 1,  /* [4] */
	BFW_NX10_io_status_pll_bypass      = 1,  /* [5] */
	BFW_NX10_io_status_arm_crashdetect = 1,  /* [6] */
	BFW_NX10_io_status_TEST            = 1,  /* [7] */
	BFW_NX10_io_status_reserved2       = 24  /* [31:8] */
};

typedef struct NX10_IO_STATUS_BIT_Ttag {
	unsigned int bond_option     : BFW_NX10_io_status_bond_option;     /* fixed to 3'b101 in netX10                                                                                              */
	unsigned int quick_count     : BFW_NX10_io_status_quick_count;     /* Testmode 'quick_count' is activated by external pins                                                                   */
	                                                                   /* -> diverse internal counters count faster (RTC-clock-divider, PLL-stby-controller,...)                                 */
	unsigned int reserved1       : BFW_NX10_io_status_reserved1;       /* reserved                                                                                                               */
	unsigned int pll_bypass      : BFW_NX10_io_status_pll_bypass;      /* Testmode 'pll_bypass' is activated by external pins                                                                    */
	                                                                   /* -> 400MHz-PLL is bypassed, PLL output is unused, 400MHz-Clocks (clk400, clk400_2sdram) is directly connected to XTALIN */
	unsigned int arm_crashdetect : BFW_NX10_io_status_arm_crashdetect; /* arm_crashdetect_cpclken. For HSoCT Simulation purpose only!!!                                                          */
	unsigned int TEST            : BFW_NX10_io_status_TEST;            /* sampled netx TEST input for Productiontest purpose                                                                     */
	unsigned int reserved2       : BFW_NX10_io_status_reserved2;       /* reserved                                                                                                               */
} NX10_IO_STATUS_BIT_T;

typedef union {
	unsigned int         val;
	NX10_IO_STATUS_BIT_T bf;
} NX10_IO_STATUS_T;

/* --------------------------------------------------------------------- */
/* Register io_config */
/* => IO Config Register: */
/*    Selects of output pin multiplexing. */
/*    See Excel pinning sheet for details. */
/*    Selects can only be activated, if appropriate bit of io_config_mask is set. */
/*    Bits will be reset according to the io_config_mask-register register if a new mask is correctly written (netX locking algorithm). */
/*    This register is protected by the netX access key mechanism; changing this register is only possible by the following sequence: */
/*    1.: read out access key from ACCESS_KEY register */
/*    2.: write back access key to ACCESS_KEY register */
/*    3.: write desired value to this register */
/*    Note: */
/*    HIF IO configuration must be done in hif_io_cfg-register (area HIF_IO_CTRL). */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX10_io_config       0x00000004U
#define Adr_NX10_asic_ctrl_io_config 0x101C0004U
#define Adr_NX10_io_config           0x101C0004U
#define DFLT_VAL_NX10_io_config      0x00000000U

#define MSK_NX10_io_config_sel_xm0_tx                 0x00000001U
#define SRT_NX10_io_config_sel_xm0_tx                 0
#define DFLT_VAL_NX10_io_config_sel_xm0_tx            0x00000000U
#define MSK_NX10_io_config_sel_xm0_txoe               0x00000002U
#define SRT_NX10_io_config_sel_xm0_txoe               1
#define DFLT_VAL_NX10_io_config_sel_xm0_txoe          0x00000000U
#define MSK_NX10_io_config_sel_xm0_eclk               0x00000004U
#define SRT_NX10_io_config_sel_xm0_eclk               2
#define DFLT_VAL_NX10_io_config_sel_xm0_eclk          0x00000000U
#define MSK_NX10_io_config_sel_fb0clk                 0x00000008U
#define SRT_NX10_io_config_sel_fb0clk                 3
#define DFLT_VAL_NX10_io_config_sel_fb0clk            0x00000000U
#define MSK_NX10_io_config_sel_rxclk_from_intphy      0x00000010U
#define SRT_NX10_io_config_sel_rxclk_from_intphy      4
#define DFLT_VAL_NX10_io_config_sel_rxclk_from_intphy 0x00000000U
#define MSK_NX10_io_config_sel_fo0                    0x00000020U
#define SRT_NX10_io_config_sel_fo0                    5
#define DFLT_VAL_NX10_io_config_sel_fo0               0x00000000U
#define MSK_NX10_io_config_sel_mii0                   0x00000040U
#define SRT_NX10_io_config_sel_mii0                   6
#define DFLT_VAL_NX10_io_config_sel_mii0              0x00000000U
#define MSK_NX10_io_config_sel_mii1                   0x00000080U
#define SRT_NX10_io_config_sel_mii1                   7
#define DFLT_VAL_NX10_io_config_sel_mii1              0x00000000U
#define MSK_NX10_io_config_sel_mii2                   0x00000100U
#define SRT_NX10_io_config_sel_mii2                   8
#define DFLT_VAL_NX10_io_config_sel_mii2              0x00000000U
#define MSK_NX10_io_config_sel_mii3                   0x00000200U
#define SRT_NX10_io_config_sel_mii3                   9
#define DFLT_VAL_NX10_io_config_sel_mii3              0x00000000U
#define MSK_NX10_io_config_sel_mii4                   0x00000400U
#define SRT_NX10_io_config_sel_mii4                   10
#define DFLT_VAL_NX10_io_config_sel_mii4              0x00000000U
#define MSK_NX10_io_config_sel_mii5                   0x00000800U
#define SRT_NX10_io_config_sel_mii5                   11
#define DFLT_VAL_NX10_io_config_sel_mii5              0x00000000U
#define MSK_NX10_io_config_sel_mii6                   0x00001000U
#define SRT_NX10_io_config_sel_mii6                   12
#define DFLT_VAL_NX10_io_config_sel_mii6              0x00000000U
#define MSK_NX10_io_config_sel_mii7                   0x00002000U
#define SRT_NX10_io_config_sel_mii7                   13
#define DFLT_VAL_NX10_io_config_sel_mii7              0x00000000U
#define MSK_NX10_io_config_sel_pwm0                   0x00004000U
#define SRT_NX10_io_config_sel_pwm0                   14
#define DFLT_VAL_NX10_io_config_sel_pwm0              0x00000000U
#define MSK_NX10_io_config_sel_pwm1                   0x00008000U
#define SRT_NX10_io_config_sel_pwm1                   15
#define DFLT_VAL_NX10_io_config_sel_pwm1              0x00000000U
#define MSK_NX10_io_config_sel_pwm2                   0x00010000U
#define SRT_NX10_io_config_sel_pwm2                   16
#define DFLT_VAL_NX10_io_config_sel_pwm2              0x00000000U
#define MSK_NX10_io_config_sel_pwm3                   0x00020000U
#define SRT_NX10_io_config_sel_pwm3                   17
#define DFLT_VAL_NX10_io_config_sel_pwm3              0x00000000U
#define MSK_NX10_io_config_sel_pwm4                   0x00040000U
#define SRT_NX10_io_config_sel_pwm4                   18
#define DFLT_VAL_NX10_io_config_sel_pwm4              0x00000000U
#define MSK_NX10_io_config_sel_pwm5                   0x00080000U
#define SRT_NX10_io_config_sel_pwm5                   19
#define DFLT_VAL_NX10_io_config_sel_pwm5              0x00000000U
#define MSK_NX10_io_config_sel_pwm6                   0x00100000U
#define SRT_NX10_io_config_sel_pwm6                   20
#define DFLT_VAL_NX10_io_config_sel_pwm6              0x00000000U
#define MSK_NX10_io_config_sel_pwm7                   0x00200000U
#define SRT_NX10_io_config_sel_pwm7                   21
#define DFLT_VAL_NX10_io_config_sel_pwm7              0x00000000U
#define MSK_NX10_io_config_usb2jtag_en                0x00400000U
#define SRT_NX10_io_config_usb2jtag_en                22
#define DFLT_VAL_NX10_io_config_usb2jtag_en           0x00000000U
#define MSK_NX10_io_config_sel_etm                    0x00800000U
#define SRT_NX10_io_config_sel_etm                    23
#define DFLT_VAL_NX10_io_config_sel_etm               0x00000000U

enum {
	BFW_NX10_io_config_sel_xm0_tx            = 1, /* [0] */
	BFW_NX10_io_config_sel_xm0_txoe          = 1, /* [1] */
	BFW_NX10_io_config_sel_xm0_eclk          = 1, /* [2] */
	BFW_NX10_io_config_sel_fb0clk            = 1, /* [3] */
	BFW_NX10_io_config_sel_rxclk_from_intphy = 1, /* [4] */
	BFW_NX10_io_config_sel_fo0               = 1, /* [5] */
	BFW_NX10_io_config_sel_mii0              = 1, /* [6] */
	BFW_NX10_io_config_sel_mii1              = 1, /* [7] */
	BFW_NX10_io_config_sel_mii2              = 1, /* [8] */
	BFW_NX10_io_config_sel_mii3              = 1, /* [9] */
	BFW_NX10_io_config_sel_mii4              = 1, /* [10] */
	BFW_NX10_io_config_sel_mii5              = 1, /* [11] */
	BFW_NX10_io_config_sel_mii6              = 1, /* [12] */
	BFW_NX10_io_config_sel_mii7              = 1, /* [13] */
	BFW_NX10_io_config_sel_pwm0              = 1, /* [14] */
	BFW_NX10_io_config_sel_pwm1              = 1, /* [15] */
	BFW_NX10_io_config_sel_pwm2              = 1, /* [16] */
	BFW_NX10_io_config_sel_pwm3              = 1, /* [17] */
	BFW_NX10_io_config_sel_pwm4              = 1, /* [18] */
	BFW_NX10_io_config_sel_pwm5              = 1, /* [19] */
	BFW_NX10_io_config_sel_pwm6              = 1, /* [20] */
	BFW_NX10_io_config_sel_pwm7              = 1, /* [21] */
	BFW_NX10_io_config_usb2jtag_en           = 1, /* [22] */
	BFW_NX10_io_config_sel_etm               = 1, /* [23] */
	BFW_NX10_io_config_reserved1             = 8  /* [31:24] */
};

typedef struct NX10_IO_CONFIG_BIT_Ttag {
	unsigned int sel_xm0_tx            : BFW_NX10_io_config_sel_xm0_tx;            /* select pad for xMAC0 tx-bitstream direct output (s. pinning table)        */
	unsigned int sel_xm0_txoe          : BFW_NX10_io_config_sel_xm0_txoe;          /* select pad for xMAC0 tx-bitstream direct output enable (s. pinning table) */
	unsigned int sel_xm0_eclk          : BFW_NX10_io_config_sel_xm0_eclk;          /* select pad for xMAC0 eclk (s. pinning table)                              */
	unsigned int sel_fb0clk            : BFW_NX10_io_config_sel_fb0clk;            /* select pad for fieldbus-clk0 (s. pinning table)                           */
	unsigned int sel_rxclk_from_intphy : BFW_NX10_io_config_sel_rxclk_from_intphy; /* select rxclk/eclk input to xMAC                                           */
	                                                                               /* 0: xMAC gets rxclk/eclk from multiplexmatrix                              */
	unsigned int sel_fo0               : BFW_NX10_io_config_sel_fo0;               /* select Fiber Optics of PHY0 (s. pinning table):                           */
	                                                                               /* 1: use Fiber Optics of PHY0                                               */
	unsigned int sel_mii0              : BFW_NX10_io_config_sel_mii0;              /* select pads for xMAC0 external MII receive data (s. pinning table)        */
	unsigned int sel_mii1              : BFW_NX10_io_config_sel_mii1;              /* select pads for xMAC0 external MII transmit data (s. pinning table)       */
	unsigned int sel_mii2              : BFW_NX10_io_config_sel_mii2;              /* select pad  for xMAC0 external MII rx-error (s. pinning table)            */
	unsigned int sel_mii3              : BFW_NX10_io_config_sel_mii3;              /* select pad  for xMAC0 external MII tx-enable (s. pinning table)           */
	unsigned int sel_mii4              : BFW_NX10_io_config_sel_mii4;              /* select pad  for xMAC0 external MII tx-error (s. pinning table)            */
	unsigned int sel_mii5              : BFW_NX10_io_config_sel_mii5;              /* select pads for xMAC0 external MII col and crs (s. pinning table)         */
	unsigned int sel_mii6              : BFW_NX10_io_config_sel_mii6;              /* select pad  for xMAC0 external MII interrupt (s. pinning table)           */
	unsigned int sel_mii7              : BFW_NX10_io_config_sel_mii7;              /* select pad  for MDIO interfase (s. pinning table)                         */
	unsigned int sel_pwm0              : BFW_NX10_io_config_sel_pwm0;              /* select pad  for PWM output (s. pinning table)                             */
	unsigned int sel_pwm1              : BFW_NX10_io_config_sel_pwm1;              /* select pad  for PWM output (s. pinning table)                             */
	unsigned int sel_pwm2              : BFW_NX10_io_config_sel_pwm2;              /* select pad  for PWM output (s. pinning table)                             */
	unsigned int sel_pwm3              : BFW_NX10_io_config_sel_pwm3;              /* select pad  for PWM output (s. pinning table)                             */
	unsigned int sel_pwm4              : BFW_NX10_io_config_sel_pwm4;              /* select pad  for PWM output (s. pinning table)                             */
	unsigned int sel_pwm5              : BFW_NX10_io_config_sel_pwm5;              /* select pad  for PWM output (s. pinning table)                             */
	unsigned int sel_pwm6              : BFW_NX10_io_config_sel_pwm6;              /* select pad  for PWM output (s. pinning table)                             */
	unsigned int sel_pwm7              : BFW_NX10_io_config_sel_pwm7;              /* select pad  for PWM output (s. pinning table)                             */
	unsigned int usb2jtag_en           : BFW_NX10_io_config_usb2jtag_en;           /* Enable USB JTAG debug feature                                             */
	unsigned int sel_etm               : BFW_NX10_io_config_sel_etm;               /* select pins for ETM9 (s. pinning table)                                   */
	unsigned int reserved1             : BFW_NX10_io_config_reserved1;             /* reserved                                                                  */
} NX10_IO_CONFIG_BIT_T;

typedef union {
	unsigned int         val;
	NX10_IO_CONFIG_BIT_T bf;
} NX10_IO_CONFIG_T;

/* --------------------------------------------------------------------- */
/* Register io_config_mask */
/* => IO Config Mask Register: */
/*    The IO_CFG_MASK register might be used to lock special IO configurations for restricted netX devices. \ */
/*    Any bit of the IO_CFG register can only be set, if the corresponding mask bit in the IO_CFG_MSK register is set either. */
/*    This register is lockable by netX locking algorithm. It will be only reset on Power on, not on normal system nres. */
/*    The io_config-register will change according to this register if a new mask is correctly written (netX locking algorithm). */
/*    This register is protected by the netX access key mechanism; changing this register is only possible by the following sequence: */
/*    1.: read out access key from ACCESS_KEY register */
/*    2.: write back access key to ACCESS_KEY register */
/*    3.: write desired value to this register */
/*    Note: */
/*    HIF IO configuration must be done ins hif_io_cfg-register (area HIF_IO_CTRL). */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX10_io_config_mask       0x00000008U
#define Adr_NX10_asic_ctrl_io_config_mask 0x101C0008U
#define Adr_NX10_io_config_mask           0x101C0008U
#define DFLT_VAL_NX10_io_config_mask      0x00ffffffU

#define MSK_NX10_io_config_mask_sel_xm0_tx                 0x00000001U
#define SRT_NX10_io_config_mask_sel_xm0_tx                 0
#define DFLT_VAL_NX10_io_config_mask_sel_xm0_tx            0x00000001U
#define MSK_NX10_io_config_mask_sel_xm0_txoe               0x00000002U
#define SRT_NX10_io_config_mask_sel_xm0_txoe               1
#define DFLT_VAL_NX10_io_config_mask_sel_xm0_txoe          0x00000002U
#define MSK_NX10_io_config_mask_sel_xm0_eclk               0x00000004U
#define SRT_NX10_io_config_mask_sel_xm0_eclk               2
#define DFLT_VAL_NX10_io_config_mask_sel_xm0_eclk          0x00000004U
#define MSK_NX10_io_config_mask_sel_fb0clk                 0x00000008U
#define SRT_NX10_io_config_mask_sel_fb0clk                 3
#define DFLT_VAL_NX10_io_config_mask_sel_fb0clk            0x00000008U
#define MSK_NX10_io_config_mask_sel_rxclk_from_intphy      0x00000010U
#define SRT_NX10_io_config_mask_sel_rxclk_from_intphy      4
#define DFLT_VAL_NX10_io_config_mask_sel_rxclk_from_intphy 0x00000010U
#define MSK_NX10_io_config_mask_sel_fo0                    0x00000020U
#define SRT_NX10_io_config_mask_sel_fo0                    5
#define DFLT_VAL_NX10_io_config_mask_sel_fo0               0x00000020U
#define MSK_NX10_io_config_mask_sel_mii0                   0x00000040U
#define SRT_NX10_io_config_mask_sel_mii0                   6
#define DFLT_VAL_NX10_io_config_mask_sel_mii0              0x00000040U
#define MSK_NX10_io_config_mask_sel_mii1                   0x00000080U
#define SRT_NX10_io_config_mask_sel_mii1                   7
#define DFLT_VAL_NX10_io_config_mask_sel_mii1              0x00000080U
#define MSK_NX10_io_config_mask_sel_mii2                   0x00000100U
#define SRT_NX10_io_config_mask_sel_mii2                   8
#define DFLT_VAL_NX10_io_config_mask_sel_mii2              0x00000100U
#define MSK_NX10_io_config_mask_sel_mii3                   0x00000200U
#define SRT_NX10_io_config_mask_sel_mii3                   9
#define DFLT_VAL_NX10_io_config_mask_sel_mii3              0x00000200U
#define MSK_NX10_io_config_mask_sel_mii4                   0x00000400U
#define SRT_NX10_io_config_mask_sel_mii4                   10
#define DFLT_VAL_NX10_io_config_mask_sel_mii4              0x00000400U
#define MSK_NX10_io_config_mask_sel_mii5                   0x00000800U
#define SRT_NX10_io_config_mask_sel_mii5                   11
#define DFLT_VAL_NX10_io_config_mask_sel_mii5              0x00000800U
#define MSK_NX10_io_config_mask_sel_mii6                   0x00001000U
#define SRT_NX10_io_config_mask_sel_mii6                   12
#define DFLT_VAL_NX10_io_config_mask_sel_mii6              0x00001000U
#define MSK_NX10_io_config_mask_sel_mii7                   0x00002000U
#define SRT_NX10_io_config_mask_sel_mii7                   13
#define DFLT_VAL_NX10_io_config_mask_sel_mii7              0x00002000U
#define MSK_NX10_io_config_mask_sel_pwm0                   0x00004000U
#define SRT_NX10_io_config_mask_sel_pwm0                   14
#define DFLT_VAL_NX10_io_config_mask_sel_pwm0              0x00004000U
#define MSK_NX10_io_config_mask_sel_pwm1                   0x00008000U
#define SRT_NX10_io_config_mask_sel_pwm1                   15
#define DFLT_VAL_NX10_io_config_mask_sel_pwm1              0x00008000U
#define MSK_NX10_io_config_mask_sel_pwm2                   0x00010000U
#define SRT_NX10_io_config_mask_sel_pwm2                   16
#define DFLT_VAL_NX10_io_config_mask_sel_pwm2              0x00010000U
#define MSK_NX10_io_config_mask_sel_pwm3                   0x00020000U
#define SRT_NX10_io_config_mask_sel_pwm3                   17
#define DFLT_VAL_NX10_io_config_mask_sel_pwm3              0x00020000U
#define MSK_NX10_io_config_mask_sel_pwm4                   0x00040000U
#define SRT_NX10_io_config_mask_sel_pwm4                   18
#define DFLT_VAL_NX10_io_config_mask_sel_pwm4              0x00040000U
#define MSK_NX10_io_config_mask_sel_pwm5                   0x00080000U
#define SRT_NX10_io_config_mask_sel_pwm5                   19
#define DFLT_VAL_NX10_io_config_mask_sel_pwm5              0x00080000U
#define MSK_NX10_io_config_mask_sel_pwm6                   0x00100000U
#define SRT_NX10_io_config_mask_sel_pwm6                   20
#define DFLT_VAL_NX10_io_config_mask_sel_pwm6              0x00100000U
#define MSK_NX10_io_config_mask_sel_pwm7                   0x00200000U
#define SRT_NX10_io_config_mask_sel_pwm7                   21
#define DFLT_VAL_NX10_io_config_mask_sel_pwm7              0x00200000U
#define MSK_NX10_io_config_mask_usb2jtag_en                0x00400000U
#define SRT_NX10_io_config_mask_usb2jtag_en                22
#define DFLT_VAL_NX10_io_config_mask_usb2jtag_en           0x00400000U
#define MSK_NX10_io_config_mask_sel_etm                    0x00800000U
#define SRT_NX10_io_config_mask_sel_etm                    23
#define DFLT_VAL_NX10_io_config_mask_sel_etm               0x00800000U

enum {
	BFW_NX10_io_config_mask_sel_xm0_tx            = 1, /* [0] */
	BFW_NX10_io_config_mask_sel_xm0_txoe          = 1, /* [1] */
	BFW_NX10_io_config_mask_sel_xm0_eclk          = 1, /* [2] */
	BFW_NX10_io_config_mask_sel_fb0clk            = 1, /* [3] */
	BFW_NX10_io_config_mask_sel_rxclk_from_intphy = 1, /* [4] */
	BFW_NX10_io_config_mask_sel_fo0               = 1, /* [5] */
	BFW_NX10_io_config_mask_sel_mii0              = 1, /* [6] */
	BFW_NX10_io_config_mask_sel_mii1              = 1, /* [7] */
	BFW_NX10_io_config_mask_sel_mii2              = 1, /* [8] */
	BFW_NX10_io_config_mask_sel_mii3              = 1, /* [9] */
	BFW_NX10_io_config_mask_sel_mii4              = 1, /* [10] */
	BFW_NX10_io_config_mask_sel_mii5              = 1, /* [11] */
	BFW_NX10_io_config_mask_sel_mii6              = 1, /* [12] */
	BFW_NX10_io_config_mask_sel_mii7              = 1, /* [13] */
	BFW_NX10_io_config_mask_sel_pwm0              = 1, /* [14] */
	BFW_NX10_io_config_mask_sel_pwm1              = 1, /* [15] */
	BFW_NX10_io_config_mask_sel_pwm2              = 1, /* [16] */
	BFW_NX10_io_config_mask_sel_pwm3              = 1, /* [17] */
	BFW_NX10_io_config_mask_sel_pwm4              = 1, /* [18] */
	BFW_NX10_io_config_mask_sel_pwm5              = 1, /* [19] */
	BFW_NX10_io_config_mask_sel_pwm6              = 1, /* [20] */
	BFW_NX10_io_config_mask_sel_pwm7              = 1, /* [21] */
	BFW_NX10_io_config_mask_usb2jtag_en           = 1, /* [22] */
	BFW_NX10_io_config_mask_sel_etm               = 1, /* [23] */
	BFW_NX10_io_config_mask_reserved1             = 8  /* [31:24] */
};

typedef struct NX10_IO_CONFIG_MASK_BIT_Ttag {
	unsigned int sel_xm0_tx            : BFW_NX10_io_config_mask_sel_xm0_tx;            /* select pad for xMAC0 tx-bitstream direct output (s. pinning table)        */
	unsigned int sel_xm0_txoe          : BFW_NX10_io_config_mask_sel_xm0_txoe;          /* select pad for xMAC0 tx-bitstream direct output enable (s. pinning table) */
	unsigned int sel_xm0_eclk          : BFW_NX10_io_config_mask_sel_xm0_eclk;          /* select pad for xMAC0 eclk (s. pinning table)                              */
	unsigned int sel_fb0clk            : BFW_NX10_io_config_mask_sel_fb0clk;            /* select pad for fieldbus-clk0 (s. pinning table)                           */
	unsigned int sel_rxclk_from_intphy : BFW_NX10_io_config_mask_sel_rxclk_from_intphy; /* select rxclk/eclk input to xMAC                                           */
	unsigned int sel_fo0               : BFW_NX10_io_config_mask_sel_fo0;               /* select Fiber Optics of PHY0 (s. pinning table):                           */
	unsigned int sel_mii0              : BFW_NX10_io_config_mask_sel_mii0;              /* select pads for xMAC0 external MII receive data (s. pinning table)        */
	unsigned int sel_mii1              : BFW_NX10_io_config_mask_sel_mii1;              /* select pads for xMAC0 external MII transmit data (s. pinning table)       */
	unsigned int sel_mii2              : BFW_NX10_io_config_mask_sel_mii2;              /* select pad  for xMAC0 external MII rx-error (s. pinning table)            */
	unsigned int sel_mii3              : BFW_NX10_io_config_mask_sel_mii3;              /* select pad  for xMAC0 external MII tx-enable (s. pinning table)           */
	unsigned int sel_mii4              : BFW_NX10_io_config_mask_sel_mii4;              /* select pad  for xMAC0 external MII tx-error (s. pinning table)            */
	unsigned int sel_mii5              : BFW_NX10_io_config_mask_sel_mii5;              /* select pads for xMAC0 external MII col and crs (s. pinning table)         */
	unsigned int sel_mii6              : BFW_NX10_io_config_mask_sel_mii6;              /* select pad  for xMAC0 external MII interrupt (s. pinning table)           */
	unsigned int sel_mii7              : BFW_NX10_io_config_mask_sel_mii7;              /* select pad  for MDIO interfase (s. pinning table)                         */
	unsigned int sel_pwm0              : BFW_NX10_io_config_mask_sel_pwm0;              /* select pad  for PWM output (s. pinning table)                             */
	unsigned int sel_pwm1              : BFW_NX10_io_config_mask_sel_pwm1;              /* select pad  for PWM output (s. pinning table)                             */
	unsigned int sel_pwm2              : BFW_NX10_io_config_mask_sel_pwm2;              /* select pad  for PWM output (s. pinning table)                             */
	unsigned int sel_pwm3              : BFW_NX10_io_config_mask_sel_pwm3;              /* select pad  for PWM output (s. pinning table)                             */
	unsigned int sel_pwm4              : BFW_NX10_io_config_mask_sel_pwm4;              /* select pad  for PWM output (s. pinning table)                             */
	unsigned int sel_pwm5              : BFW_NX10_io_config_mask_sel_pwm5;              /* select pad  for PWM output (s. pinning table)                             */
	unsigned int sel_pwm6              : BFW_NX10_io_config_mask_sel_pwm6;              /* select pad  for PWM output (s. pinning table)                             */
	unsigned int sel_pwm7              : BFW_NX10_io_config_mask_sel_pwm7;              /* select pad  for PWM output (s. pinning table)                             */
	unsigned int usb2jtag_en           : BFW_NX10_io_config_mask_usb2jtag_en;           /* Enable USB JTAG debug feature                                             */
	unsigned int sel_etm               : BFW_NX10_io_config_mask_sel_etm;               /* select pins for ETM9 (s. pinning table)                                   */
	unsigned int reserved1             : BFW_NX10_io_config_mask_reserved1;             /* reserved                                                                  */
} NX10_IO_CONFIG_MASK_BIT_T;

typedef union {
	unsigned int              val;
	NX10_IO_CONFIG_MASK_BIT_T bf;
} NX10_IO_CONFIG_MASK_T;

/* --------------------------------------------------------------------- */
/* Register reset_ctrl */
/* => Reset Control Register: */
/*    This register controls the reset functions of the netX chip and indicates the reset state. The reset state */
/*    shows which resets have occurred, allowing the firmware to detect which resets were active. In order to */
/*    determine the source of the last reset, the firmware should evaluate and reset these bits during its start */
/*    sequence. After a power on reset, the RESET_CTRL register is cleared completely. */
/*    This register is protected by the netX access key mechanism; changing this register is only possible by the following sequence: */
/*    1.: read out access key from ACCESS_KEY register */
/*    2.: write back access key to ACCESS_KEY register */
/*    3.: write desired value to this register */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX10_reset_ctrl       0x0000000CU
#define Adr_NX10_asic_ctrl_reset_ctrl 0x101C000CU
#define Adr_NX10_reset_ctrl           0x101C000CU
#define DFLT_VAL_NX10_reset_ctrl      0x00000000U

#define MSK_NX10_reset_ctrl_RES_WDOG              0x00000002U
#define SRT_NX10_reset_ctrl_RES_WDOG              1
#define DFLT_VAL_NX10_reset_ctrl_RES_WDOG         0x00000000U
#define MSK_NX10_reset_ctrl_RES_HOST              0x00000004U
#define SRT_NX10_reset_ctrl_RES_HOST              2
#define DFLT_VAL_NX10_reset_ctrl_RES_HOST         0x00000000U
#define MSK_NX10_reset_ctrl_RES_FIRMWARE          0x00000008U
#define SRT_NX10_reset_ctrl_RES_FIRMWARE          3
#define DFLT_VAL_NX10_reset_ctrl_RES_FIRMWARE     0x00000000U
#define MSK_NX10_reset_ctrl_RES_XPEC0             0x00000010U
#define SRT_NX10_reset_ctrl_RES_XPEC0             4
#define DFLT_VAL_NX10_reset_ctrl_RES_XPEC0        0x00000000U
#define MSK_NX10_reset_ctrl_DIS_RES_XPEC0         0x00010000U
#define SRT_NX10_reset_ctrl_DIS_RES_XPEC0         16
#define DFLT_VAL_NX10_reset_ctrl_DIS_RES_XPEC0    0x00000000U
#define MSK_NX10_reset_ctrl_FIRMWARE_STATUS0      0x00100000U
#define SRT_NX10_reset_ctrl_FIRMWARE_STATUS0      20
#define DFLT_VAL_NX10_reset_ctrl_FIRMWARE_STATUS0 0x00000000U
#define MSK_NX10_reset_ctrl_FIRMWARE_STATUS1      0x00200000U
#define SRT_NX10_reset_ctrl_FIRMWARE_STATUS1      21
#define DFLT_VAL_NX10_reset_ctrl_FIRMWARE_STATUS1 0x00000000U
#define MSK_NX10_reset_ctrl_FIRMWARE_STATUS2      0x00400000U
#define SRT_NX10_reset_ctrl_FIRMWARE_STATUS2      22
#define DFLT_VAL_NX10_reset_ctrl_FIRMWARE_STATUS2 0x00000000U
#define MSK_NX10_reset_ctrl_FIRMWARE_STATUS3      0x00800000U
#define SRT_NX10_reset_ctrl_FIRMWARE_STATUS3      23
#define DFLT_VAL_NX10_reset_ctrl_FIRMWARE_STATUS3 0x00000000U
#define MSK_NX10_reset_ctrl_RES_REQ_FIRMWARE      0x01000000U
#define SRT_NX10_reset_ctrl_RES_REQ_FIRMWARE      24
#define DFLT_VAL_NX10_reset_ctrl_RES_REQ_FIRMWARE 0x00000000U

enum {
	BFW_NX10_reset_ctrl_reserved1        = 1,  /* [0] */
	BFW_NX10_reset_ctrl_RES_WDOG         = 1,  /* [1] */
	BFW_NX10_reset_ctrl_RES_HOST         = 1,  /* [2] */
	BFW_NX10_reset_ctrl_RES_FIRMWARE     = 1,  /* [3] */
	BFW_NX10_reset_ctrl_RES_XPEC0        = 1,  /* [4] */
	BFW_NX10_reset_ctrl_reserved2        = 11, /* [15:5] */
	BFW_NX10_reset_ctrl_DIS_RES_XPEC0    = 1,  /* [16] */
	BFW_NX10_reset_ctrl_reserved3        = 3,  /* [19:17] */
	BFW_NX10_reset_ctrl_FIRMWARE_STATUS0 = 1,  /* [20] */
	BFW_NX10_reset_ctrl_FIRMWARE_STATUS1 = 1,  /* [21] */
	BFW_NX10_reset_ctrl_FIRMWARE_STATUS2 = 1,  /* [22] */
	BFW_NX10_reset_ctrl_FIRMWARE_STATUS3 = 1,  /* [23] */
	BFW_NX10_reset_ctrl_RES_REQ_FIRMWARE = 1,  /* [24] */
	BFW_NX10_reset_ctrl_reserved4        = 7   /* [31:25] */
};

typedef struct NX10_RESET_CTRL_BIT_Ttag {
	unsigned int reserved1        : BFW_NX10_reset_ctrl_reserved1;        /* reserved                                                                                        */
	unsigned int RES_WDOG         : BFW_NX10_reset_ctrl_RES_WDOG;         /* reset from System WDG, after reading write back a "1" to clear the status bit                   */
	unsigned int RES_HOST         : BFW_NX10_reset_ctrl_RES_HOST;         /* reset from Hostinterface/DPM, after reading write back a "1" to clear the status bit            */
	unsigned int RES_FIRMWARE     : BFW_NX10_reset_ctrl_RES_FIRMWARE;     /* reset from FIRMWARE (software reset), after reading write back a "1" to clear the status bit    */
	unsigned int RES_XPEC0        : BFW_NX10_reset_ctrl_RES_XPEC0;        /* reset from RES_XPEC0, after reading write back a "1" to clear the status bit                    */
	unsigned int reserved2        : BFW_NX10_reset_ctrl_reserved2;        /* reserved                                                                                        */
	unsigned int DIS_RES_XPEC0    : BFW_NX10_reset_ctrl_DIS_RES_XPEC0;    /* reset from RES_XPEC0 is disabled (read only)                                                    */
	unsigned int reserved3        : BFW_NX10_reset_ctrl_reserved3;        /* reserved                                                                                        */
	unsigned int FIRMWARE_STATUS0 : BFW_NX10_reset_ctrl_FIRMWARE_STATUS0; /* readable and writable bit to save the firmware status; only a PowerOn Reset will clear this bit */
	unsigned int FIRMWARE_STATUS1 : BFW_NX10_reset_ctrl_FIRMWARE_STATUS1; /* readable and writable bit to save the firmware status; only a PowerOn Reset will clear this bit */
	unsigned int FIRMWARE_STATUS2 : BFW_NX10_reset_ctrl_FIRMWARE_STATUS2; /* readable and writable bit to save the firmware status; only a PowerOn Reset will clear this bit */
	unsigned int FIRMWARE_STATUS3 : BFW_NX10_reset_ctrl_FIRMWARE_STATUS3; /* readable and writable bit to save the firmware status; only a PowerOn Reset will clear this bit */
	unsigned int RES_REQ_FIRMWARE : BFW_NX10_reset_ctrl_RES_REQ_FIRMWARE; /* (software reset) writing a "1" sets the reset request to reset the whole system (write only)    */
	unsigned int reserved4        : BFW_NX10_reset_ctrl_reserved4;        /* reserved                                                                                        */
} NX10_RESET_CTRL_BIT_T;

typedef union {
	unsigned int          val;
	NX10_RESET_CTRL_BIT_T bf;
} NX10_RESET_CTRL_T;

/* --------------------------------------------------------------------- */
/* Register phy_control */
/* => PHY Control Register: */
/*    This register contains all static connectors of the NEC Ethernet PHY. \ */
/*    Usually the PHY reads these values only during reset, which can be controlled by Bit31. \ */
/*    This register is protected by the netX access key mechanism; changing this register is only possible by the following sequence: */
/*    1.: read out access key from ACCESS_KEY register */
/*    2.: write back access key to ACCESS_KEY register */
/*    3.: write desired value to this register */
/*    In total the programming sequence should be: */
/*    a: read access key, write access key, write new value with bit phy_reset=1 */
/*    b: wait for proper reset of PHY(~100os) */
/*    c: read access key, write access key, write new value with bit phy_reset=0 */
/*    Note: */
/*       Bit field 'phy0_np_msg_code' was omitted. Related PHY inputs are only for test purpose. */
/*       PHY Next-Page features must be programmed in PHY registers if used. */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX10_phy_control       0x00000010U
#define Adr_NX10_asic_ctrl_phy_control 0x101C0010U
#define Adr_NX10_phy_control           0x101C0010U
#define DFLT_VAL_NX10_phy_control      0x00000060U

#define MSK_NX10_phy_control_phy_address        0x0000000fU
#define SRT_NX10_phy_control_phy_address        0
#define DFLT_VAL_NX10_phy_control_phy_address   0x00000000U
#define MSK_NX10_phy_control_phy0_mode          0x00000070U
#define SRT_NX10_phy_control_phy0_mode          4
#define DFLT_VAL_NX10_phy_control_phy0_mode     0x00000060U
#define MSK_NX10_phy_control_phy0_fxmode        0x00000080U
#define SRT_NX10_phy_control_phy0_fxmode        7
#define DFLT_VAL_NX10_phy_control_phy0_fxmode   0x00000000U
#define MSK_NX10_phy_control_phy0_automdix      0x00000100U
#define SRT_NX10_phy_control_phy0_automdix      8
#define DFLT_VAL_NX10_phy_control_phy0_automdix 0x00000000U
#define MSK_NX10_phy_control_phy0_enable        0x00001000U
#define SRT_NX10_phy_control_phy0_enable        12
#define DFLT_VAL_NX10_phy_control_phy0_enable   0x00000000U
#define MSK_NX10_phy_control_phy_sim_byp        0x40000000U
#define SRT_NX10_phy_control_phy_sim_byp        30
#define DFLT_VAL_NX10_phy_control_phy_sim_byp   0x00000000U
#define MSK_NX10_phy_control_phy_reset          0x80000000U
#define SRT_NX10_phy_control_phy_reset          31
#define DFLT_VAL_NX10_phy_control_phy_reset     0x00000000U

enum {
	BFW_NX10_phy_control_phy_address   = 4,  /* [3:0] */
	BFW_NX10_phy_control_phy0_mode     = 3,  /* [6:4] */
	BFW_NX10_phy_control_phy0_fxmode   = 1,  /* [7] */
	BFW_NX10_phy_control_phy0_automdix = 1,  /* [8] */
	BFW_NX10_phy_control_reserved1     = 3,  /* [11:9] */
	BFW_NX10_phy_control_phy0_enable   = 1,  /* [12] */
	BFW_NX10_phy_control_reserved2     = 17, /* [29:13] */
	BFW_NX10_phy_control_phy_sim_byp   = 1,  /* [30] */
	BFW_NX10_phy_control_phy_reset     = 1   /* [31] */
};

typedef struct NX10_PHY_CONTROL_BIT_Ttag {
	unsigned int phy_address   : BFW_NX10_phy_control_phy_address;   /* Bits 4:1 of PHY mdio-address.                         */
	                                                                 /* Bit0 defines 1st or 2nd internal PHY                  */
	unsigned int phy0_mode     : BFW_NX10_phy_control_phy0_mode;     /* PHY0 Mode:                                            */
	                                                                 /* 000: 10BASE-T Half Duplex, Auto Negotiation disabled. */
	unsigned int phy0_fxmode   : BFW_NX10_phy_control_phy0_fxmode;   /* PHY0 100BASE-FX mode (phy_mode must be 01x)           */
	unsigned int phy0_automdix : BFW_NX10_phy_control_phy0_automdix; /* PHY0 Enables AutoMDIX state machine                   */
	unsigned int reserved1     : BFW_NX10_phy_control_reserved1;     /* reserved                                              */
	unsigned int phy0_enable   : BFW_NX10_phy_control_phy0_enable;   /* PHY0 enable                                           */
	unsigned int reserved2     : BFW_NX10_phy_control_reserved2;     /* reserved                                              */
	unsigned int phy_sim_byp   : BFW_NX10_phy_control_phy_sim_byp;   /* PHY Power up Bypass (only used for simulation issues) */
	                                                                 /* 0: normal                                             */
	unsigned int phy_reset     : BFW_NX10_phy_control_phy_reset;     /* Hardware reset for PHY                                */
	                                                                 /* 1: reset                                              */
} NX10_PHY_CONTROL_BIT_T;

typedef union {
	unsigned int           val;
	NX10_PHY_CONTROL_BIT_T bf;
} NX10_PHY_CONTROL_T;

/* --------------------------------------------------------------------- */
/* Register armclk_rate_mul_add */
/* => Rate Multiplier Add Value of System Clock: */
/*    This register might be used to change internal system frequency (100MHz of ARM and system). */
/*    Be careful when changing this value, as proper netX functionality is only qualified for the default value. */
/*    This register is lockable by netX locking algorithm. It will be only reset on Power on, not on normal system nres. */
/*    This register is protected by the netX access key mechanism; changing this register is only possible by the following sequence: */
/*    1.: read out Locking Access Key */
/*    2.: write back Locking Access Key */
/*    3.: write desired value to this register */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX10_armclk_rate_mul_add       0x00000014U
#define Adr_NX10_asic_ctrl_armclk_rate_mul_add 0x101C0014U
#define Adr_NX10_armclk_rate_mul_add           0x101C0014U
#define DFLT_VAL_NX10_armclk_rate_mul_add      0x00000100U

#define MSK_NX10_armclk_rate_mul_add_armclk_rate_mul_add      0x000001ffU
#define SRT_NX10_armclk_rate_mul_add_armclk_rate_mul_add      0
#define DFLT_VAL_NX10_armclk_rate_mul_add_armclk_rate_mul_add 0x00000100U

enum {
	BFW_NX10_armclk_rate_mul_add_armclk_rate_mul_add = 9,  /* [8:0] */
	BFW_NX10_armclk_rate_mul_add_reserved1           = 23  /* [31:9] */
};

typedef struct NX10_ARMCLK_RATE_MUL_ADD_BIT_Ttag {
	unsigned int armclk_rate_mul_add : BFW_NX10_armclk_rate_mul_add_armclk_rate_mul_add; /* This value is added each clk400 cycle to armclk_rate_mul to generate armclk. */
	                                                                                     /* Change value according to formula:                                           */
	unsigned int reserved1           : BFW_NX10_armclk_rate_mul_add_reserved1;           /* reserved                                                                     */
} NX10_ARMCLK_RATE_MUL_ADD_BIT_T;

typedef union {
	unsigned int                   val;
	NX10_ARMCLK_RATE_MUL_ADD_BIT_T bf;
} NX10_ARMCLK_RATE_MUL_ADD_T;

/* --------------------------------------------------------------------- */
/* Register usb12clk_rate_mul_add */
/* => Rate Multiplier Add Value of 12MHz USB clock: */
/*    This register is protected by the netX access key mechanism; changing this register is only possible by the following sequence: */
/*    1.: read out Locking Access Key */
/*    2.: write back Locking Access Key */
/*    3.: write desired value to this register */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX10_usb12clk_rate_mul_add       0x00000018U
#define Adr_NX10_asic_ctrl_usb12clk_rate_mul_add 0x101C0018U
#define Adr_NX10_usb12clk_rate_mul_add           0x101C0018U
#define DFLT_VAL_NX10_usb12clk_rate_mul_add      0x000007aeU

#define MSK_NX10_usb12clk_rate_mul_add_usb12clk_rate_mul_add      0x0000ffffU
#define SRT_NX10_usb12clk_rate_mul_add_usb12clk_rate_mul_add      0
#define DFLT_VAL_NX10_usb12clk_rate_mul_add_usb12clk_rate_mul_add 0x000007aeU

enum {
	BFW_NX10_usb12clk_rate_mul_add_usb12clk_rate_mul_add = 16, /* [15:0] */
	BFW_NX10_usb12clk_rate_mul_add_reserved1             = 16  /* [31:16] */
};

typedef struct NX10_USB12CLK_RATE_MUL_ADD_BIT_Ttag {
	unsigned int usb12clk_rate_mul_add : BFW_NX10_usb12clk_rate_mul_add_usb12clk_rate_mul_add; /* This value is added each clk400 cycle to usb12clk_rate_mul to generate usb12clk. */
	                                                                                           /* Change value according to formula:                                               */
	unsigned int reserved1             : BFW_NX10_usb12clk_rate_mul_add_reserved1;             /* reserved                                                                         */
} NX10_USB12CLK_RATE_MUL_ADD_BIT_T;

typedef union {
	unsigned int                     val;
	NX10_USB12CLK_RATE_MUL_ADD_BIT_T bf;
} NX10_USB12CLK_RATE_MUL_ADD_T;

/* --------------------------------------------------------------------- */
/* Register adcclk_div */
/* => Divisor of clock divider for 16MHz ADC clock: */
/*    This register is protected by the netX access key mechanism; changing this register is only possible by the following sequence: */
/*    1.: read out Locking Access Key */
/*    2.: write back Locking Access Key */
/*    3.: write desired value to this register */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX10_adcclk_div       0x0000001CU
#define Adr_NX10_asic_ctrl_adcclk_div 0x101C001CU
#define Adr_NX10_adcclk_div           0x101C001CU
#define DFLT_VAL_NX10_adcclk_div      0x00000019U

#define MSK_NX10_adcclk_div_val      0x000001ffU
#define SRT_NX10_adcclk_div_val      0
#define DFLT_VAL_NX10_adcclk_div_val 0x00000019U

enum {
	BFW_NX10_adcclk_div_val       = 9,  /* [8:0] */
	BFW_NX10_adcclk_div_reserved1 = 23  /* [31:9] */
};

typedef struct NX10_ADCCLK_DIV_BIT_Ttag {
	unsigned int val       : BFW_NX10_adcclk_div_val;       /* Divisor for generating 16MHz adcclk out of clk400: */
	                                                        /* Change value according to formula:                 */
	unsigned int reserved1 : BFW_NX10_adcclk_div_reserved1; /* reserved                                           */
} NX10_ADCCLK_DIV_BIT_T;

typedef union {
	unsigned int          val;
	NX10_ADCCLK_DIV_BIT_T bf;
} NX10_ADCCLK_DIV_T;

/* --------------------------------------------------------------------- */
/* Register fb0clk_rate_mul_add */
/* => Rate Multiplier Add Value: */
/*    Fieldbus0 clock is generated by internal 400MHz rate multiplier. \ */
/*    At some fieldbus-frequencies, this clock has less jitter, than the xMAC generated output clock. \ */
/*    xMAC fieldbus outputs (xm0_tx_out, xm1_tx_oe) can optionally (io_config-sel_xm0_eclk) be sampled by an extra register running on this clock, */
/*    resulting in jitter less fieldbus outputs. */
/*    Alternatively to this internally generated clock, an external clock (xm0_eclk) can be used to make xMAC outputs jitter free (clock_enable-fb0). \ */
/*    Using external clocks to resample xMAC outputs requires modified xMAC software. */
/*    This register is protected by the netX access key mechanism; changing this register is only possible by the following sequence: */
/*    1.: read out Locking Access Key */
/*    2.: write back Locking Access Key */
/*    3.: write desired value to this register */
/*    ------------------------------------ */
/*    netX100/netX500 usage of this address: adcclk_rate_mul_add */
/*    ------------------------------------ */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX10_fb0clk_rate_mul_add       0x00000020U
#define Adr_NX10_asic_ctrl_fb0clk_rate_mul_add 0x101C0020U
#define Adr_NX10_fb0clk_rate_mul_add           0x101C0020U
#define DFLT_VAL_NX10_fb0clk_rate_mul_add      0x01000000U

#define MSK_NX10_fb0clk_rate_mul_add_fb0clk_rate_mul_add      0xffffffffU
#define SRT_NX10_fb0clk_rate_mul_add_fb0clk_rate_mul_add      0
#define DFLT_VAL_NX10_fb0clk_rate_mul_add_fb0clk_rate_mul_add 0x01000000U

enum {
	BFW_NX10_fb0clk_rate_mul_add_fb0clk_rate_mul_add = 32  /* [31:0] */
};

typedef struct NX10_FB0CLK_RATE_MUL_ADD_BIT_Ttag {
	unsigned int fb0clk_rate_mul_add : BFW_NX10_fb0clk_rate_mul_add_fb0clk_rate_mul_add; /* This value is added each clk400 cycle to fb0clk_rate_mul to generate fb0clk. */
	                                                                                     /* Values bigger 0x80000000 are not allowed for proper rate_mul functionality.  */
} NX10_FB0CLK_RATE_MUL_ADD_BIT_T;

typedef union {
	unsigned int                   val;
	NX10_FB0CLK_RATE_MUL_ADD_BIT_T bf;
} NX10_FB0CLK_RATE_MUL_ADD_T;

/* --------------------------------------------------------------------- */
/* Register fb0clk_div */
/* => Rate Multiplier Predivider: */
/*    Fieldbus0 clock is generated from internal 400MHz by a predivider combined with a rate multiplier. \ */
/*    At some fieldbus-frequencies, this clock has less jitter, than the xMAC generated output clock. \ */
/*    xMAC fieldbus output (xm0_tx_out) can optionally (io_config-sel_xm0_eclk) be sampled by an extra register running on this clock, */
/*    resulting in jitter less fieldbus outputs. */
/*    Alternatively to this internally generated clock, an external clock (xm0_eclk) can be used to make xMAC output jitter free (clock_enable-fb0). \ */
/*    Using external clocks to resample xMAC outputs requires modified xMAC software. */
/*    This register is protected by the netX access key mechanism; changing this register is only possible by the following sequence: */
/*    1.: read out Locking Access Key */
/*    2.: write back Locking Access Key */
/*    3.: write desired value to this register */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX10_fb0clk_div       0x00000024U
#define Adr_NX10_asic_ctrl_fb0clk_div 0x101C0024U
#define Adr_NX10_fb0clk_div           0x101C0024U
#define DFLT_VAL_NX10_fb0clk_div      0x00000000U

#define MSK_NX10_fb0clk_div_val      0x000000ffU
#define SRT_NX10_fb0clk_div_val      0
#define DFLT_VAL_NX10_fb0clk_div_val 0x00000000U

enum {
	BFW_NX10_fb0clk_div_val       = 8,  /* [7:0] */
	BFW_NX10_fb0clk_div_reserved1 = 24  /* [31:8] */
};

typedef struct NX10_FB0CLK_DIV_BIT_Ttag {
	unsigned int val       : BFW_NX10_fb0clk_div_val;       /* Fieldbus 0 Predivider value:                                         */
	                                                        /* The value + 1 must be programmed, i.e. val=0 leads to no predivision */
	unsigned int reserved1 : BFW_NX10_fb0clk_div_reserved1; /* reserved                                                             */
} NX10_FB0CLK_DIV_BIT_T;

typedef union {
	unsigned int          val;
	NX10_FB0CLK_DIV_BIT_T bf;
} NX10_FB0CLK_DIV_T;

/* --------------------------------------------------------------------- */
/* Register clock_enable */
/* => Global Clock Enable Register: */
/*    Use this registers to disable modules completely for power saving purposes. */
/*    Changes will only have effect if according bit in clock_enable_mask-register is set. \ */
/*    Bits will be reset according to the clock_enable_mask-register register, if a new mask is correctly written (netX locking algorithm). */
/*    This register is protected by the netX access key mechanism; changing this register is only possible by the following sequence: */
/*    Note: for low power consumption at power on, all switchable clocks are disabled after reset and mus be enabled before module usage. */
/*    1.: read out access key from ACCESS_KEY register */
/*    2.: write back access key to ACCESS_KEY register */
/*    3.: write desired value to this register */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX10_clock_enable       0x00000028U
#define Adr_NX10_asic_ctrl_clock_enable 0x101C0028U
#define Adr_NX10_clock_enable           0x101C0028U
#define DFLT_VAL_NX10_clock_enable      0x00000000U

#define MSK_NX10_clock_enable_xpec0        0x00000001U
#define SRT_NX10_clock_enable_xpec0        0
#define DFLT_VAL_NX10_clock_enable_xpec0   0x00000000U
#define MSK_NX10_clock_enable_xmac0        0x00000010U
#define SRT_NX10_clock_enable_xmac0        4
#define DFLT_VAL_NX10_clock_enable_xmac0   0x00000000U
#define MSK_NX10_clock_enable_dpm          0x00000100U
#define SRT_NX10_clock_enable_dpm          8
#define DFLT_VAL_NX10_clock_enable_dpm     0x00000000U
#define MSK_NX10_clock_enable_fb0          0x00000400U
#define SRT_NX10_clock_enable_fb0          10
#define DFLT_VAL_NX10_clock_enable_fb0     0x00000000U
#define MSK_NX10_clock_enable_dma          0x00001000U
#define SRT_NX10_clock_enable_dma          12
#define DFLT_VAL_NX10_clock_enable_dma     0x00000000U
#define MSK_NX10_clock_enable_xpic         0x00002000U
#define SRT_NX10_clock_enable_xpic         13
#define DFLT_VAL_NX10_clock_enable_xpic    0x00000000U
#define MSK_NX10_clock_enable_xc_misc      0x00004000U
#define SRT_NX10_clock_enable_xc_misc      14
#define DFLT_VAL_NX10_clock_enable_xc_misc 0x00000000U

enum {
	BFW_NX10_clock_enable_xpec0     = 1,  /* [0] */
	BFW_NX10_clock_enable_reserved1 = 3,  /* [3:1] */
	BFW_NX10_clock_enable_xmac0     = 1,  /* [4] */
	BFW_NX10_clock_enable_reserved2 = 3,  /* [7:5] */
	BFW_NX10_clock_enable_dpm       = 1,  /* [8] */
	BFW_NX10_clock_enable_reserved3 = 1,  /* [9] */
	BFW_NX10_clock_enable_fb0       = 1,  /* [10] */
	BFW_NX10_clock_enable_reserved4 = 1,  /* [11] */
	BFW_NX10_clock_enable_dma       = 1,  /* [12] */
	BFW_NX10_clock_enable_xpic      = 1,  /* [13] */
	BFW_NX10_clock_enable_xc_misc   = 1,  /* [14] */
	BFW_NX10_clock_enable_reserved5 = 17  /* [31:15] */
};

typedef struct NX10_CLOCK_ENABLE_BIT_Ttag {
	unsigned int xpec0     : BFW_NX10_clock_enable_xpec0;     /* enables clock for xPEC0                                          */
	unsigned int reserved1 : BFW_NX10_clock_enable_reserved1; /* reserved                                                         */
	unsigned int xmac0     : BFW_NX10_clock_enable_xmac0;     /* enables clock for xMAC0                                          */
	unsigned int reserved2 : BFW_NX10_clock_enable_reserved2; /* reserved                                                         */
	unsigned int dpm       : BFW_NX10_clock_enable_dpm;       /* enables clock for DPM                                            */
	unsigned int reserved3 : BFW_NX10_clock_enable_reserved3; /* reserved                                                         */
	unsigned int fb0       : BFW_NX10_clock_enable_fb0;       /* enables clock for fieldbus0:                                     */
	                                                          /* 1: use internally generated fb0clk to resample xMAC0 outputs     */
	unsigned int reserved4 : BFW_NX10_clock_enable_reserved4; /* reserved                                                         */
	unsigned int dma       : BFW_NX10_clock_enable_dma;       /* enables clock for DMA-Ctrl.                                      */
	unsigned int xpic      : BFW_NX10_clock_enable_xpic;      /* enables clock for XPIC                                           */
	unsigned int xc_misc   : BFW_NX10_clock_enable_xc_misc;   /* enables clock for misc. XC logic (XC-DMAC, XC-SR, XC-BUFMAN,...) */
	unsigned int reserved5 : BFW_NX10_clock_enable_reserved5; /* reserved                                                         */
} NX10_CLOCK_ENABLE_BIT_T;

typedef union {
	unsigned int            val;
	NX10_CLOCK_ENABLE_BIT_T bf;
} NX10_CLOCK_ENABLE_T;

/* --------------------------------------------------------------------- */
/* Register clock_enable_mask */
/* => Global Clock Enable Mask Register: */
/*    allows to disable modules for different netX-versions */
/*    This register is lockable by netX locking algorithm. It will be only reset on Power on, not on normal system nres. */
/*    The clock_enable-register will change according to this register if a new mask is correctly written (netX locking algorithm). */
/*    This register is protected by the netX access key mechanism; changing this register is only possible by the following sequence: */
/*    1.: read out access key from ACCESS_KEY register */
/*    2.: write back access key to ACCESS_KEY register */
/*    3.: write desired value to this register */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX10_clock_enable_mask       0x0000002CU
#define Adr_NX10_asic_ctrl_clock_enable_mask 0x101C002CU
#define Adr_NX10_clock_enable_mask           0x101C002CU
#define DFLT_VAL_NX10_clock_enable_mask      0x00007511U

#define MSK_NX10_clock_enable_mask_xpec0        0x00000001U
#define SRT_NX10_clock_enable_mask_xpec0        0
#define DFLT_VAL_NX10_clock_enable_mask_xpec0   0x00000001U
#define MSK_NX10_clock_enable_mask_xmac0        0x00000010U
#define SRT_NX10_clock_enable_mask_xmac0        4
#define DFLT_VAL_NX10_clock_enable_mask_xmac0   0x00000010U
#define MSK_NX10_clock_enable_mask_dpm          0x00000100U
#define SRT_NX10_clock_enable_mask_dpm          8
#define DFLT_VAL_NX10_clock_enable_mask_dpm     0x00000100U
#define MSK_NX10_clock_enable_mask_fb0          0x00000400U
#define SRT_NX10_clock_enable_mask_fb0          10
#define DFLT_VAL_NX10_clock_enable_mask_fb0     0x00000400U
#define MSK_NX10_clock_enable_mask_dma          0x00001000U
#define SRT_NX10_clock_enable_mask_dma          12
#define DFLT_VAL_NX10_clock_enable_mask_dma     0x00001000U
#define MSK_NX10_clock_enable_mask_xpic         0x00002000U
#define SRT_NX10_clock_enable_mask_xpic         13
#define DFLT_VAL_NX10_clock_enable_mask_xpic    0x00002000U
#define MSK_NX10_clock_enable_mask_xc_misc      0x00004000U
#define SRT_NX10_clock_enable_mask_xc_misc      14
#define DFLT_VAL_NX10_clock_enable_mask_xc_misc 0x00004000U

enum {
	BFW_NX10_clock_enable_mask_xpec0     = 1,  /* [0] */
	BFW_NX10_clock_enable_mask_reserved1 = 3,  /* [3:1] */
	BFW_NX10_clock_enable_mask_xmac0     = 1,  /* [4] */
	BFW_NX10_clock_enable_mask_reserved2 = 3,  /* [7:5] */
	BFW_NX10_clock_enable_mask_dpm       = 1,  /* [8] */
	BFW_NX10_clock_enable_mask_reserved3 = 1,  /* [9] */
	BFW_NX10_clock_enable_mask_fb0       = 1,  /* [10] */
	BFW_NX10_clock_enable_mask_reserved4 = 1,  /* [11] */
	BFW_NX10_clock_enable_mask_dma       = 1,  /* [12] */
	BFW_NX10_clock_enable_mask_xpic      = 1,  /* [13] */
	BFW_NX10_clock_enable_mask_xc_misc   = 1,  /* [14] */
	BFW_NX10_clock_enable_mask_reserved5 = 17  /* [31:15] */
};

typedef struct NX10_CLOCK_ENABLE_MASK_BIT_Ttag {
	unsigned int xpec0     : BFW_NX10_clock_enable_mask_xpec0;     /* 0: xPEC0 is disabled  1: clock can be enabled/disabled by clock_enable-register for xPEC0                     */
	unsigned int reserved1 : BFW_NX10_clock_enable_mask_reserved1; /* reserved                                                                                                      */
	unsigned int xmac0     : BFW_NX10_clock_enable_mask_xmac0;     /* 0: xMAC0 is disabled  1: clock can be enabled/disabled by clock_enable-register for xMAC0                     */
	unsigned int reserved2 : BFW_NX10_clock_enable_mask_reserved2; /* reserved                                                                                                      */
	unsigned int dpm       : BFW_NX10_clock_enable_mask_dpm;       /* 0: DPM is disabled  1: clock can be enabled/disabled by clock_enable-register for DPM                         */
	unsigned int reserved3 : BFW_NX10_clock_enable_mask_reserved3; /* reserved                                                                                                      */
	unsigned int fb0       : BFW_NX10_clock_enable_mask_fb0;       /* 0: fieldbus0 clock is disabled  1: clock can be enabled/disabled by clock_enable-register for fieldbus0 clock */
	unsigned int reserved4 : BFW_NX10_clock_enable_mask_reserved4; /* reserved                                                                                                      */
	unsigned int dma       : BFW_NX10_clock_enable_mask_dma;       /* 0: DMA-Ctrl. is disabled  1: clock can be enabled/disabled by clock_enable-register for DMA-Ctrl.             */
	unsigned int xpic      : BFW_NX10_clock_enable_mask_xpic;      /* 0: xPIC is disabled  1: clock can be enabled/disabled by clock_enable-register for xPIC                       */
	unsigned int xc_misc   : BFW_NX10_clock_enable_mask_xc_misc;   /* 0: misc. XC logic is disabled  1: clock can be enabled/disabled by clock_enable-register for misc. XC logic   */
	unsigned int reserved5 : BFW_NX10_clock_enable_mask_reserved5; /* reserved                                                                                                      */
} NX10_CLOCK_ENABLE_MASK_BIT_T;

typedef union {
	unsigned int                 val;
	NX10_CLOCK_ENABLE_MASK_BIT_T bf;
} NX10_CLOCK_ENABLE_MASK_T;

/* --------------------------------------------------------------------- */
/* Register misc_asic_ctrl */
/* => Miscellaneous ASIC Control Register: */
/*    This register is lockable by netX locking algorithm. It will be only reset on Power on, not on normal system nres. */
/*    This register is protected by the netX access key mechanism; changing this register is only possible by the following sequence: */
/*    1.: read out access key from ACCESS_KEY register */
/*    2.: write back access key to ACCESS_KEY register */
/*    3.: write desired value to this register */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX10_misc_asic_ctrl       0x00000030U
#define Adr_NX10_asic_ctrl_misc_asic_ctrl 0x101C0030U
#define Adr_NX10_misc_asic_ctrl           0x101C0030U
#define DFLT_VAL_NX10_misc_asic_ctrl      0x00000001U

#define MSK_NX10_misc_asic_ctrl_arm_dbgen             0x00000001U
#define SRT_NX10_misc_asic_ctrl_arm_dbgen             0
#define DFLT_VAL_NX10_misc_asic_ctrl_arm_dbgen        0x00000001U
#define MSK_NX10_misc_asic_ctrl_lic_err_taint_en      0x00000100U
#define SRT_NX10_misc_asic_ctrl_lic_err_taint_en      8
#define DFLT_VAL_NX10_misc_asic_ctrl_lic_err_taint_en 0x00000000U
#define MSK_NX10_misc_asic_ctrl_lic_err_abort_en      0x00000200U
#define SRT_NX10_misc_asic_ctrl_lic_err_abort_en      9
#define DFLT_VAL_NX10_misc_asic_ctrl_lic_err_abort_en 0x00000000U
#define MSK_NX10_misc_asic_ctrl_lic_err_irq_en        0x00000400U
#define SRT_NX10_misc_asic_ctrl_lic_err_irq_en        10
#define DFLT_VAL_NX10_misc_asic_ctrl_lic_err_irq_en   0x00000000U
#define MSK_NX10_misc_asic_ctrl_lic_err_delay_en      0x00000800U
#define SRT_NX10_misc_asic_ctrl_lic_err_delay_en      11
#define DFLT_VAL_NX10_misc_asic_ctrl_lic_err_delay_en 0x00000000U

enum {
	BFW_NX10_misc_asic_ctrl_arm_dbgen        = 1,  /* [0] */
	BFW_NX10_misc_asic_ctrl_reserved1        = 7,  /* [7:1] */
	BFW_NX10_misc_asic_ctrl_lic_err_taint_en = 1,  /* [8] */
	BFW_NX10_misc_asic_ctrl_lic_err_abort_en = 1,  /* [9] */
	BFW_NX10_misc_asic_ctrl_lic_err_irq_en   = 1,  /* [10] */
	BFW_NX10_misc_asic_ctrl_lic_err_delay_en = 1,  /* [11] */
	BFW_NX10_misc_asic_ctrl_reserved2        = 20  /* [31:12] */
};

typedef struct NX10_MISC_ASIC_CTRL_BIT_Ttag {
	unsigned int arm_dbgen        : BFW_NX10_misc_asic_ctrl_arm_dbgen;        /* ARM debug enable.                                                                                             */
	                                                                          /*   1: ARM debug features are enabled                                                                           */
	unsigned int reserved1        : BFW_NX10_misc_asic_ctrl_reserved1;        /* reserved                                                                                                      */
	unsigned int lic_err_taint_en : BFW_NX10_misc_asic_ctrl_lic_err_taint_en; /* In case of a detected license error, system clock will be reduced to 80MHz                                    */
	unsigned int lic_err_abort_en : BFW_NX10_misc_asic_ctrl_lic_err_abort_en; /* In case of a detected license error, ARM-Abort will be generated on the next data write (no data loss caused) */
	unsigned int lic_err_irq_en   : BFW_NX10_misc_asic_ctrl_lic_err_irq_en;   /* In case of a detected license error, ARM-IRQ will be generated                                                */
	unsigned int lic_err_delay_en : BFW_NX10_misc_asic_ctrl_lic_err_delay_en; /* Random Delay between a detected license error and abort-generation/change to tainted mode                     */
	unsigned int reserved2        : BFW_NX10_misc_asic_ctrl_reserved2;        /* reserved                                                                                                      */
} NX10_MISC_ASIC_CTRL_BIT_T;

typedef union {
	unsigned int              val;
	NX10_MISC_ASIC_CTRL_BIT_T bf;
} NX10_MISC_ASIC_CTRL_T;

/* --------------------------------------------------------------------- */
/* Register only_porn */
/* => Firmware Status register: */
/*    This register is not Reset by SW resets, only PORn will reset this register. */
/*    This register is protected by the netX access key mechanism; changing this register is only possible by the following sequence: */
/*    1.: read out access key from ACCESS_KEY register */
/*    2.: write back access key to ACCESS_KEY register */
/*    3.: write desired value to this register */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX10_only_porn       0x00000034U
#define Adr_NX10_asic_ctrl_only_porn 0x101C0034U
#define Adr_NX10_only_porn           0x101C0034U
#define DFLT_VAL_NX10_only_porn      0x00000000U

#define MSK_NX10_only_porn_only_porn      0xffffffffU
#define SRT_NX10_only_porn_only_porn      0
#define DFLT_VAL_NX10_only_porn_only_porn 0x00000000U

enum {
	BFW_NX10_only_porn_only_porn = 32  /* [31:0] */
};

typedef struct NX10_ONLY_PORN_BIT_Ttag {
	unsigned int only_porn : BFW_NX10_only_porn_only_porn; /* netX Firmware status */
} NX10_ONLY_PORN_BIT_T;

typedef union {
	unsigned int         val;
	NX10_ONLY_PORN_BIT_T bf;
} NX10_ONLY_PORN_T;

/* --------------------------------------------------------------------- */
/* Register netx_version */
/* => netX Revision Register: */
/*    This register contains information about netX hardware and bootloader revision. */
/*    This register is lockable by netX locking algorithm. It will be only reset on Power on, not on normal system nres. */
/*    This register is protected by the netX access key mechanism; changing this register is only possible by the following sequence: */
/*    1.: read out access key from ACCESS_KEY register */
/*    2.: write back access key to ACCESS_KEY register */
/*    3.: write desired value to this register */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX10_netx_version       0x00000038U
#define Adr_NX10_asic_ctrl_netx_version 0x101C0038U
#define Adr_NX10_netx_version           0x101C0038U
#define DFLT_VAL_NX10_netx_version      0x00000050U

#define MSK_NX10_netx_version_netx_version      0x000000ffU
#define SRT_NX10_netx_version_netx_version      0
#define DFLT_VAL_NX10_netx_version_netx_version 0x00000050U

enum {
	BFW_NX10_netx_version_netx_version = 8,  /* [7:0] */
	BFW_NX10_netx_version_reserved1    = 24  /* [31:8] */
};

typedef struct NX10_NETX_VERSION_BIT_Ttag {
	unsigned int netx_version : BFW_NX10_netx_version_netx_version; /* netX50 revision number:                        */
	                                                                /* netX50 revision number starts with "B" (0x42). */
	unsigned int reserved1    : BFW_NX10_netx_version_reserved1;    /* reserved                                       */
} NX10_NETX_VERSION_BIT_T;

typedef union {
	unsigned int            val;
	NX10_NETX_VERSION_BIT_T bf;
} NX10_NETX_VERSION_T;

/* --------------------------------------------------------------------- */
/* Register rom_wdg */
/* => netX ROM Watchdog: */
/*    Write to this register to reset rom-hide-watchdog, no access-key-protection. */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX10_rom_wdg       0x0000003CU
#define Adr_NX10_asic_ctrl_rom_wdg 0x101C003CU
#define Adr_NX10_rom_wdg           0x101C003CU
#define DFLT_VAL_NX10_rom_wdg      0x000001ffU

#define MSK_NX10_rom_wdg_rst_wdg      0xffffffffU
#define SRT_NX10_rom_wdg_rst_wdg      0
#define DFLT_VAL_NX10_rom_wdg_rst_wdg 0x000001ffU

enum {
	BFW_NX10_rom_wdg_rst_wdg = 32  /* [31:0] */
};

typedef struct NX10_ROM_WDG_BIT_Ttag {
	unsigned int rst_wdg : BFW_NX10_rom_wdg_rst_wdg; /* write here to reset rom-watchdog to 0x1ff                         */
	                                                 /* The watchdog will decrement with each positiv clk (100MHz) edge.  */
} NX10_ROM_WDG_BIT_T;

typedef union {
	unsigned int       val;
	NX10_ROM_WDG_BIT_T bf;
} NX10_ROM_WDG_T;

/* --------------------------------------------------------------------- */
/* Register sample_at_nres */
/* => IO Sampled at Reset Status Register. */
/*    Note: Configure sample_at_nres (sar_*)-IOs with pullups or down resistors to configure netX */
/*          environment (e.g. DPM enable, DPM serial mode selection,...). Related IOs are not driven by netX */
/*          by default. For correct funtionality ensure taht they are also  notdriven by external devices during */
/*          netx power up and reset. */
/*    Note: View ./README_power_on_cfg.txt for HSoCT reference simulation sample at reset configuration. */
/* => Mode: R */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX10_sample_at_nres       0x00000040U
#define Adr_NX10_asic_ctrl_sample_at_nres 0x101C0040U
#define Adr_NX10_sample_at_nres           0x101C0040U

#define MSK_NX10_sample_at_nres_sar_hif_d0    0x00000001U
#define SRT_NX10_sample_at_nres_sar_hif_d0    0
#define MSK_NX10_sample_at_nres_sar_hif_d1    0x00000002U
#define SRT_NX10_sample_at_nres_sar_hif_d1    1
#define MSK_NX10_sample_at_nres_sar_hif_d2    0x00000004U
#define SRT_NX10_sample_at_nres_sar_hif_d2    2
#define MSK_NX10_sample_at_nres_sar_hif_d3    0x00000008U
#define SRT_NX10_sample_at_nres_sar_hif_d3    3
#define MSK_NX10_sample_at_nres_sar_hif_d4    0x00000010U
#define SRT_NX10_sample_at_nres_sar_hif_d4    4
#define MSK_NX10_sample_at_nres_sar_hif_d5    0x00000020U
#define SRT_NX10_sample_at_nres_sar_hif_d5    5
#define MSK_NX10_sample_at_nres_sar_hif_d6    0x00000040U
#define SRT_NX10_sample_at_nres_sar_hif_d6    6
#define MSK_NX10_sample_at_nres_sar_hif_d7    0x00000080U
#define SRT_NX10_sample_at_nres_sar_hif_d7    7
#define MSK_NX10_sample_at_nres_sar_hif_d8    0x00000100U
#define SRT_NX10_sample_at_nres_sar_hif_d8    8
#define MSK_NX10_sample_at_nres_sar_hif_d9    0x00000200U
#define SRT_NX10_sample_at_nres_sar_hif_d9    9
#define MSK_NX10_sample_at_nres_sar_hif_d10   0x00000400U
#define SRT_NX10_sample_at_nres_sar_hif_d10   10
#define MSK_NX10_sample_at_nres_sar_hif_d11   0x00000800U
#define SRT_NX10_sample_at_nres_sar_hif_d11   11
#define MSK_NX10_sample_at_nres_sar_hif_d12   0x00001000U
#define SRT_NX10_sample_at_nres_sar_hif_d12   12
#define MSK_NX10_sample_at_nres_sar_hif_d13   0x00002000U
#define SRT_NX10_sample_at_nres_sar_hif_d13   13
#define MSK_NX10_sample_at_nres_sar_hif_d14   0x00004000U
#define SRT_NX10_sample_at_nres_sar_hif_d14   14
#define MSK_NX10_sample_at_nres_sar_hif_d15   0x00008000U
#define SRT_NX10_sample_at_nres_sar_hif_d15   15
#define MSK_NX10_sample_at_nres_sar_hif_a0    0x00010000U
#define SRT_NX10_sample_at_nres_sar_hif_a0    16
#define MSK_NX10_sample_at_nres_sar_hif_a1    0x00020000U
#define SRT_NX10_sample_at_nres_sar_hif_a1    17
#define MSK_NX10_sample_at_nres_sar_hif_a2    0x00040000U
#define SRT_NX10_sample_at_nres_sar_hif_a2    18
#define MSK_NX10_sample_at_nres_sar_hif_a3    0x00080000U
#define SRT_NX10_sample_at_nres_sar_hif_a3    19
#define MSK_NX10_sample_at_nres_sar_hif_a4    0x00100000U
#define SRT_NX10_sample_at_nres_sar_hif_a4    20
#define MSK_NX10_sample_at_nres_sar_hif_a5    0x00200000U
#define SRT_NX10_sample_at_nres_sar_hif_a5    21
#define MSK_NX10_sample_at_nres_sar_hif_a6    0x00400000U
#define SRT_NX10_sample_at_nres_sar_hif_a6    22
#define MSK_NX10_sample_at_nres_sar_hif_a7    0x00800000U
#define SRT_NX10_sample_at_nres_sar_hif_a7    23
#define MSK_NX10_sample_at_nres_sar_hif_a8    0x01000000U
#define SRT_NX10_sample_at_nres_sar_hif_a8    24
#define MSK_NX10_sample_at_nres_sar_hif_a9    0x02000000U
#define SRT_NX10_sample_at_nres_sar_hif_a9    25
#define MSK_NX10_sample_at_nres_sar_hif_a10   0x04000000U
#define SRT_NX10_sample_at_nres_sar_hif_a10   26
#define MSK_NX10_sample_at_nres_sar_spi0_sio3 0x08000000U
#define SRT_NX10_sample_at_nres_sar_spi0_sio3 27
#define MSK_NX10_sample_at_nres_sar_spi0_sio2 0x10000000U
#define SRT_NX10_sample_at_nres_sar_spi0_sio2 28
#define MSK_NX10_sample_at_nres_sar_spi0_mosi 0x20000000U
#define SRT_NX10_sample_at_nres_sar_spi0_mosi 29
#define MSK_NX10_sample_at_nres_sar_spi0_miso 0x40000000U
#define SRT_NX10_sample_at_nres_sar_spi0_miso 30
#define MSK_NX10_sample_at_nres_sar_spi0_clk  0x80000000U
#define SRT_NX10_sample_at_nres_sar_spi0_clk  31

enum {
	BFW_NX10_sample_at_nres_sar_hif_d0    = 1, /* [0] */
	BFW_NX10_sample_at_nres_sar_hif_d1    = 1, /* [1] */
	BFW_NX10_sample_at_nres_sar_hif_d2    = 1, /* [2] */
	BFW_NX10_sample_at_nres_sar_hif_d3    = 1, /* [3] */
	BFW_NX10_sample_at_nres_sar_hif_d4    = 1, /* [4] */
	BFW_NX10_sample_at_nres_sar_hif_d5    = 1, /* [5] */
	BFW_NX10_sample_at_nres_sar_hif_d6    = 1, /* [6] */
	BFW_NX10_sample_at_nres_sar_hif_d7    = 1, /* [7] */
	BFW_NX10_sample_at_nres_sar_hif_d8    = 1, /* [8] */
	BFW_NX10_sample_at_nres_sar_hif_d9    = 1, /* [9] */
	BFW_NX10_sample_at_nres_sar_hif_d10   = 1, /* [10] */
	BFW_NX10_sample_at_nres_sar_hif_d11   = 1, /* [11] */
	BFW_NX10_sample_at_nres_sar_hif_d12   = 1, /* [12] */
	BFW_NX10_sample_at_nres_sar_hif_d13   = 1, /* [13] */
	BFW_NX10_sample_at_nres_sar_hif_d14   = 1, /* [14] */
	BFW_NX10_sample_at_nres_sar_hif_d15   = 1, /* [15] */
	BFW_NX10_sample_at_nres_sar_hif_a0    = 1, /* [16] */
	BFW_NX10_sample_at_nres_sar_hif_a1    = 1, /* [17] */
	BFW_NX10_sample_at_nres_sar_hif_a2    = 1, /* [18] */
	BFW_NX10_sample_at_nres_sar_hif_a3    = 1, /* [19] */
	BFW_NX10_sample_at_nres_sar_hif_a4    = 1, /* [20] */
	BFW_NX10_sample_at_nres_sar_hif_a5    = 1, /* [21] */
	BFW_NX10_sample_at_nres_sar_hif_a6    = 1, /* [22] */
	BFW_NX10_sample_at_nres_sar_hif_a7    = 1, /* [23] */
	BFW_NX10_sample_at_nres_sar_hif_a8    = 1, /* [24] */
	BFW_NX10_sample_at_nres_sar_hif_a9    = 1, /* [25] */
	BFW_NX10_sample_at_nres_sar_hif_a10   = 1, /* [26] */
	BFW_NX10_sample_at_nres_sar_spi0_sio3 = 1, /* [27] */
	BFW_NX10_sample_at_nres_sar_spi0_sio2 = 1, /* [28] */
	BFW_NX10_sample_at_nres_sar_spi0_mosi = 1, /* [29] */
	BFW_NX10_sample_at_nres_sar_spi0_miso = 1, /* [30] */
	BFW_NX10_sample_at_nres_sar_spi0_clk  = 1  /* [31] */
};

typedef struct NX10_SAMPLE_AT_NRES_BIT_Ttag {
	unsigned int sar_hif_d0    : BFW_NX10_sample_at_nres_sar_hif_d0;    /* Sampled input level of IO 'sar_hif_d0' at power on reset  */
	unsigned int sar_hif_d1    : BFW_NX10_sample_at_nres_sar_hif_d1;    /* Sampled input level of IO 'sar_hif_d1' at power on reset  */
	unsigned int sar_hif_d2    : BFW_NX10_sample_at_nres_sar_hif_d2;    /* Sampled input level of IO 'sar_hif_d2' at power on reset  */
	unsigned int sar_hif_d3    : BFW_NX10_sample_at_nres_sar_hif_d3;    /* Sampled input level of IO 'sar_hif_d3' at power on reset  */
	unsigned int sar_hif_d4    : BFW_NX10_sample_at_nres_sar_hif_d4;    /* Sampled input level of IO 'sar_hif_d4' at power on reset  */
	unsigned int sar_hif_d5    : BFW_NX10_sample_at_nres_sar_hif_d5;    /* Sampled input level of IO 'sar_hif_d5' at power on reset  */
	unsigned int sar_hif_d6    : BFW_NX10_sample_at_nres_sar_hif_d6;    /* Sampled input level of IO 'sar_hif_d6' at power on reset  */
	unsigned int sar_hif_d7    : BFW_NX10_sample_at_nres_sar_hif_d7;    /* Sampled input level of IO 'sar_hif_d7' at power on reset  */
	unsigned int sar_hif_d8    : BFW_NX10_sample_at_nres_sar_hif_d8;    /* Sampled input level of IO 'sar_hif_d8' at power on reset  */
	unsigned int sar_hif_d9    : BFW_NX10_sample_at_nres_sar_hif_d9;    /* Sampled input level of IO 'sar_hif_d9' at power on reset  */
	unsigned int sar_hif_d10   : BFW_NX10_sample_at_nres_sar_hif_d10;   /* Sampled input level of IO 'sar_hif_d10' at power on reset */
	unsigned int sar_hif_d11   : BFW_NX10_sample_at_nres_sar_hif_d11;   /* Sampled input level of IO 'sar_hif_d11' at power on reset */
	unsigned int sar_hif_d12   : BFW_NX10_sample_at_nres_sar_hif_d12;   /* Sampled input level of IO 'sar_hif_d12' at power on reset */
	unsigned int sar_hif_d13   : BFW_NX10_sample_at_nres_sar_hif_d13;   /* Sampled input level of IO 'sar_hif_d13' at power on reset */
	unsigned int sar_hif_d14   : BFW_NX10_sample_at_nres_sar_hif_d14;   /* Sampled input level of IO 'sar_hif_d14' at power on reset */
	unsigned int sar_hif_d15   : BFW_NX10_sample_at_nres_sar_hif_d15;   /* Sampled input level of IO 'sar_hif_d15' at power on reset */
	unsigned int sar_hif_a0    : BFW_NX10_sample_at_nres_sar_hif_a0;    /* Sampled input level of IO 'hif_a0' at power on reset.     */
	unsigned int sar_hif_a1    : BFW_NX10_sample_at_nres_sar_hif_a1;    /* Sampled input level of IO 'hif_a1' at power on reset      */
	unsigned int sar_hif_a2    : BFW_NX10_sample_at_nres_sar_hif_a2;    /* Sampled input level of IO 'hif_a2' at power on reset      */
	unsigned int sar_hif_a3    : BFW_NX10_sample_at_nres_sar_hif_a3;    /* Sampled input level of IO 'hif_a3' at power on reset      */
	unsigned int sar_hif_a4    : BFW_NX10_sample_at_nres_sar_hif_a4;    /* Sampled input level of IO 'hif_a4' at power on reset      */
	unsigned int sar_hif_a5    : BFW_NX10_sample_at_nres_sar_hif_a5;    /* Sampled input level of IO 'hif_a5' at power on reset      */
	unsigned int sar_hif_a6    : BFW_NX10_sample_at_nres_sar_hif_a6;    /* Sampled input level of IO 'hif_a6' at power on reset      */
	unsigned int sar_hif_a7    : BFW_NX10_sample_at_nres_sar_hif_a7;    /* Sampled input level of IO 'hif_a7' at power on reset      */
	unsigned int sar_hif_a8    : BFW_NX10_sample_at_nres_sar_hif_a8;    /* Sampled input level of IO 'hif_a8' at power on reset      */
	unsigned int sar_hif_a9    : BFW_NX10_sample_at_nres_sar_hif_a9;    /* Sampled input level of IO 'hif_a9' at power on reset      */
	unsigned int sar_hif_a10   : BFW_NX10_sample_at_nres_sar_hif_a10;   /* Sampled input level of IO 'hif_a10' at power on reset     */
	unsigned int sar_spi0_sio3 : BFW_NX10_sample_at_nres_sar_spi0_sio3; /* Sampled input level of IO 'spi0_sio3' at power on reset.  */
	unsigned int sar_spi0_sio2 : BFW_NX10_sample_at_nres_sar_spi0_sio2; /* Sampled input level of IO 'spi0_sio2' at power on reset.  */
	unsigned int sar_spi0_mosi : BFW_NX10_sample_at_nres_sar_spi0_mosi; /* Sampled input level of IO 'spi0_mosi' at power on reset.  */
	unsigned int sar_spi0_miso : BFW_NX10_sample_at_nres_sar_spi0_miso; /* Sampled input level of IO 'spi0_miso' at power on reset.  */
	unsigned int sar_spi0_clk  : BFW_NX10_sample_at_nres_sar_spi0_clk;  /* Sampled input level of IO 'spi0_clk' at power on reset.   */
} NX10_SAMPLE_AT_NRES_BIT_T;

typedef union {
	unsigned int              val;
	NX10_SAMPLE_AT_NRES_BIT_T bf;
} NX10_SAMPLE_AT_NRES_T;

/* --------------------------------------------------------------------- */
/* Register netx_status */
/* => netX System Status Configuration Register. */
/*    This Register was implemented in Hilscher HIF module originally. */
/*    From Hilscher Program Reference Guide: The general status of a netX based system is usually indicated by the System LED, which can either */
/*    consist of a dual LED or two single LEDs. */
/*    Access to this register is not protected by any locking or access protection algorithm. */
/*    IMPORTANT: netX50/100/500 Change Note: */
/*       The netX50/100/500 SYS_STA register was byte acessible. This changed: This register is only 32bit accessible. */
/*       In netx50/100/500, write access to bits 0..15 of SYS_STA register can generated an IRQ to external host CPU. */
/*       As the register now is 32bit accessible only, this is changed to whole register access. I.e. any write */
/*       access to this register will generate an host IRQ if enabled. To change the upper 16 bits of this register without */
/*       host IRQ generation, use register rdy_run_cfg. */
/*    Note: */
/*       Changing bits here will also change rdy_run_cfg register bits. */
/*    Note: */
/*       Bits 0..3 and 8..15 are read-only-mirrored to DPM/Host Status register dpm_sys_sta (DPM_HOST_SYS_STAT) (Area DPM). */
/*       Read-only bits 4..7 can be programmed by DPM/Host Status register dpm_sys_sta (DPM_HOST_SYS_STAT) (Area DPM). */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX10_netx_status       0x00000044U
#define Adr_NX10_asic_ctrl_netx_status 0x101C0044U
#define Adr_NX10_netx_status           0x101C0044U
#define DFLT_VAL_NX10_netx_status      0x0000f000U

#define MSK_NX10_netx_status_RDY                0x00000001U
#define SRT_NX10_netx_status_RDY                0
#define DFLT_VAL_NX10_netx_status_RDY           0x00000000U
#define MSK_NX10_netx_status_RUN                0x00000002U
#define SRT_NX10_netx_status_RUN                1
#define DFLT_VAL_NX10_netx_status_RUN           0x00000000U
#define MSK_NX10_netx_status_NETX_STATE         0x0000000cU
#define SRT_NX10_netx_status_NETX_STATE         2
#define DFLT_VAL_NX10_netx_status_NETX_STATE    0x00000000U
#define MSK_NX10_netx_status_HOST_STATE_ro      0x000000f0U
#define SRT_NX10_netx_status_HOST_STATE_ro      4
#define DFLT_VAL_NX10_netx_status_HOST_STATE_ro 0x00000000U
#define MSK_NX10_netx_status_NETX_STA_CODE      0x0000ff00U
#define SRT_NX10_netx_status_NETX_STA_CODE      8
#define DFLT_VAL_NX10_netx_status_NETX_STA_CODE 0x0000f000U
#define MSK_NX10_netx_status_RDY_IN             0x00010000U
#define SRT_NX10_netx_status_RDY_IN             16
#define DFLT_VAL_NX10_netx_status_RDY_IN        0x00000000U
#define MSK_NX10_netx_status_RUN_IN             0x00020000U
#define SRT_NX10_netx_status_RUN_IN             17
#define DFLT_VAL_NX10_netx_status_RUN_IN        0x00000000U
#define MSK_NX10_netx_status_RDY_POL            0x00040000U
#define SRT_NX10_netx_status_RDY_POL            18
#define DFLT_VAL_NX10_netx_status_RDY_POL       0x00000000U
#define MSK_NX10_netx_status_RUN_POL            0x00080000U
#define SRT_NX10_netx_status_RUN_POL            19
#define DFLT_VAL_NX10_netx_status_RUN_POL       0x00000000U
#define MSK_NX10_netx_status_RDY_DRV            0x01000000U
#define SRT_NX10_netx_status_RDY_DRV            24
#define DFLT_VAL_NX10_netx_status_RDY_DRV       0x00000000U
#define MSK_NX10_netx_status_RUN_DRV            0x02000000U
#define SRT_NX10_netx_status_RUN_DRV            25
#define DFLT_VAL_NX10_netx_status_RUN_DRV       0x00000000U

enum {
	BFW_NX10_netx_status_RDY           = 1, /* [0] */
	BFW_NX10_netx_status_RUN           = 1, /* [1] */
	BFW_NX10_netx_status_NETX_STATE    = 2, /* [3:2] */
	BFW_NX10_netx_status_HOST_STATE_ro = 4, /* [7:4] */
	BFW_NX10_netx_status_NETX_STA_CODE = 8, /* [15:8] */
	BFW_NX10_netx_status_RDY_IN        = 1, /* [16] */
	BFW_NX10_netx_status_RUN_IN        = 1, /* [17] */
	BFW_NX10_netx_status_RDY_POL       = 1, /* [18] */
	BFW_NX10_netx_status_RUN_POL       = 1, /* [19] */
	BFW_NX10_netx_status_reserved1     = 4, /* [23:20] */
	BFW_NX10_netx_status_RDY_DRV       = 1, /* [24] */
	BFW_NX10_netx_status_RUN_DRV       = 1, /* [25] */
	BFW_NX10_netx_status_reserved2     = 6  /* [31:26] */
};

typedef struct NX10_NETX_STATUS_BIT_Ttag {
	unsigned int RDY           : BFW_NX10_netx_status_RDY;           /* Signal level of the RDY LED output.                                             */
	                                                                 /* Note:                                                                           */
	unsigned int RUN           : BFW_NX10_netx_status_RUN;           /* Signal Level of the RUN LED output.                                             */
	                                                                 /* Note:                                                                           */
	unsigned int NETX_STATE    : BFW_NX10_netx_status_NETX_STATE;    /* User defined status bits.                                                       */
	                                                                 /* Note:                                                                           */
	unsigned int HOST_STATE_ro : BFW_NX10_netx_status_HOST_STATE_ro; /* Host Status Code.                                                               */
	                                                                 /* User defined status is read only here. These bits can be programmed by DPM/Host */
	unsigned int NETX_STA_CODE : BFW_NX10_netx_status_NETX_STA_CODE; /* netX Status Code.                                                               */
	                                                                 /* The netX status codes are software defined.                                     */
	unsigned int RDY_IN        : BFW_NX10_netx_status_RDY_IN;        /* Physical input signal level at RDY pin (read-only).                             */
	unsigned int RUN_IN        : BFW_NX10_netx_status_RUN_IN;        /* Physical input signal level at RUN pin (read-only).                             */
	unsigned int RDY_POL       : BFW_NX10_netx_status_RDY_POL;       /* Output polarity RDY LED; outsig = RDY exor RDY_POL.                             */
	unsigned int RUN_POL       : BFW_NX10_netx_status_RUN_POL;       /* Output polarity RUN LED; outsig = RUN exor RUN_POL.                             */
	unsigned int reserved1     : BFW_NX10_netx_status_reserved1;     /* reserved                                                                        */
	unsigned int RDY_DRV       : BFW_NX10_netx_status_RDY_DRV;       /* Driver enable for RDY LED. Enables output driver when set.                      */
	unsigned int RUN_DRV       : BFW_NX10_netx_status_RUN_DRV;       /* Driver enable for RUN LED. Enables output driver when set.                      */
	unsigned int reserved2     : BFW_NX10_netx_status_reserved2;     /* reserved                                                                        */
} NX10_NETX_STATUS_BIT_T;

typedef union {
	unsigned int           val;
	NX10_NETX_STATUS_BIT_T bf;
} NX10_NETX_STATUS_T;

/* --------------------------------------------------------------------- */
/* Register rdy_run_cfg */
/* => netX RDY/RUN IO System Status Configuration Register. */
/*    RDY/RUN signal programming was implemented in Hilscher HIF module originally. */
/*    From Hilscher Program Reference Guide: The general status of a netX based system is usually indicated by the System LED, which can either */
/*    consist of a dual LED or two single LEDs. */
/*    Access to this register is not protected by any locking or access protection algorithm. */
/*    Note: */
/*       Use this register to change the upper 16 bits of sys_sta (SYS_STA) register witout */
/*       host IRQ generation. For further information see sys_sta register description. Changing bits here */
/*       will also change sys_sta register bits, however no host IRQ will be generated. */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX10_rdy_run_cfg       0x00000048U
#define Adr_NX10_asic_ctrl_rdy_run_cfg 0x101C0048U
#define Adr_NX10_rdy_run_cfg           0x101C0048U
#define DFLT_VAL_NX10_rdy_run_cfg      0x00000000U

#define MSK_NX10_rdy_run_cfg_RDY          0x00000001U
#define SRT_NX10_rdy_run_cfg_RDY          0
#define DFLT_VAL_NX10_rdy_run_cfg_RDY     0x00000000U
#define MSK_NX10_rdy_run_cfg_RUN          0x00000002U
#define SRT_NX10_rdy_run_cfg_RUN          1
#define DFLT_VAL_NX10_rdy_run_cfg_RUN     0x00000000U
#define MSK_NX10_rdy_run_cfg_RDY_IN       0x00010000U
#define SRT_NX10_rdy_run_cfg_RDY_IN       16
#define DFLT_VAL_NX10_rdy_run_cfg_RDY_IN  0x00000000U
#define MSK_NX10_rdy_run_cfg_RUN_IN       0x00020000U
#define SRT_NX10_rdy_run_cfg_RUN_IN       17
#define DFLT_VAL_NX10_rdy_run_cfg_RUN_IN  0x00000000U
#define MSK_NX10_rdy_run_cfg_RDY_POL      0x00040000U
#define SRT_NX10_rdy_run_cfg_RDY_POL      18
#define DFLT_VAL_NX10_rdy_run_cfg_RDY_POL 0x00000000U
#define MSK_NX10_rdy_run_cfg_RUN_POL      0x00080000U
#define SRT_NX10_rdy_run_cfg_RUN_POL      19
#define DFLT_VAL_NX10_rdy_run_cfg_RUN_POL 0x00000000U
#define MSK_NX10_rdy_run_cfg_RDY_DRV      0x01000000U
#define SRT_NX10_rdy_run_cfg_RDY_DRV      24
#define DFLT_VAL_NX10_rdy_run_cfg_RDY_DRV 0x00000000U
#define MSK_NX10_rdy_run_cfg_RUN_DRV      0x02000000U
#define SRT_NX10_rdy_run_cfg_RUN_DRV      25
#define DFLT_VAL_NX10_rdy_run_cfg_RUN_DRV 0x00000000U

enum {
	BFW_NX10_rdy_run_cfg_RDY       = 1,  /* [0] */
	BFW_NX10_rdy_run_cfg_RUN       = 1,  /* [1] */
	BFW_NX10_rdy_run_cfg_reserved1 = 14, /* [15:2] */
	BFW_NX10_rdy_run_cfg_RDY_IN    = 1,  /* [16] */
	BFW_NX10_rdy_run_cfg_RUN_IN    = 1,  /* [17] */
	BFW_NX10_rdy_run_cfg_RDY_POL   = 1,  /* [18] */
	BFW_NX10_rdy_run_cfg_RUN_POL   = 1,  /* [19] */
	BFW_NX10_rdy_run_cfg_reserved2 = 4,  /* [23:20] */
	BFW_NX10_rdy_run_cfg_RDY_DRV   = 1,  /* [24] */
	BFW_NX10_rdy_run_cfg_RUN_DRV   = 1,  /* [25] */
	BFW_NX10_rdy_run_cfg_reserved3 = 6   /* [31:26] */
};

typedef struct NX10_RDY_RUN_CFG_BIT_Ttag {
	unsigned int RDY       : BFW_NX10_rdy_run_cfg_RDY;       /* Signal level of the RDY LED output.                        */
	unsigned int RUN       : BFW_NX10_rdy_run_cfg_RUN;       /* Signal Level of the RUN LED output.                        */
	unsigned int reserved1 : BFW_NX10_rdy_run_cfg_reserved1; /* reserved                                                   */
	unsigned int RDY_IN    : BFW_NX10_rdy_run_cfg_RDY_IN;    /* Physical input signal level at RDY pin (read-only).        */
	unsigned int RUN_IN    : BFW_NX10_rdy_run_cfg_RUN_IN;    /* Physical input signal level at RUN pin (read-only).        */
	unsigned int RDY_POL   : BFW_NX10_rdy_run_cfg_RDY_POL;   /* Output polarity RDY LED; outsig = RDY exor RDY_POL.        */
	unsigned int RUN_POL   : BFW_NX10_rdy_run_cfg_RUN_POL;   /* Output polarity RUN LED; outsig = RUN exor RUN_POL.        */
	unsigned int reserved2 : BFW_NX10_rdy_run_cfg_reserved2; /* reserved                                                   */
	unsigned int RDY_DRV   : BFW_NX10_rdy_run_cfg_RDY_DRV;   /* Driver enable for RDY LED. Enables output driver when set. */
	unsigned int RUN_DRV   : BFW_NX10_rdy_run_cfg_RUN_DRV;   /* Driver enable for RUN LED. Enables output driver when set. */
	unsigned int reserved3 : BFW_NX10_rdy_run_cfg_reserved3; /* reserved                                                   */
} NX10_RDY_RUN_CFG_BIT_T;

typedef union {
	unsigned int           val;
	NX10_RDY_RUN_CFG_BIT_T bf;
} NX10_RDY_RUN_CFG_T;

/* --------------------------------------------------------------------- */
/* Register system_status */
/* => netX System Status Register. */
/*    This register provides information of special netX system events, e.g: System related interrupt activity, Abort activity. */
/*    Abort status flags can be cleared by writing a '1' to the according bits. */
/*    IRQ status flags can be cleared by writing a '1' to the according bits. */
/* => Mode: R */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX10_system_status       0x0000004CU
#define Adr_NX10_asic_ctrl_system_status 0x101C004CU
#define Adr_NX10_system_status           0x101C004CU

#define MSK_NX10_system_status_lic_err_irq_status   0x00000001U
#define SRT_NX10_system_status_lic_err_irq_status   0
#define MSK_NX10_system_status_extbus_to_irq_status 0x00000002U
#define SRT_NX10_system_status_extbus_to_irq_status 1
#define MSK_NX10_system_status_lic_err_abort_status 0x00010000U
#define SRT_NX10_system_status_lic_err_abort_status 16

enum {
	BFW_NX10_system_status_lic_err_irq_status   = 1,  /* [0] */
	BFW_NX10_system_status_extbus_to_irq_status = 1,  /* [1] */
	BFW_NX10_system_status_reserved1            = 14, /* [15:2] */
	BFW_NX10_system_status_lic_err_abort_status = 1,  /* [16] */
	BFW_NX10_system_status_reserved2            = 15  /* [31:17] */
};

typedef struct NX10_SYSTEM_STATUS_BIT_Ttag {
	unsigned int lic_err_irq_status   : BFW_NX10_system_status_lic_err_irq_status;   /* Current status of netX licence error IRQ.                                                                   */
	                                                                                 /* Note: This IRQ (bit) can only be cleared by running a valid netx licence check sequence.                    */
	unsigned int extbus_to_irq_status : BFW_NX10_system_status_extbus_to_irq_status; /* Current status of Extension Bus Ready Timeout IRQ.                                                          */
	                                                                                 /* Note: This IRQ is controlled/cleared by ext_rdy_cfg register (area ext_asyncmem_ctrl).                      */
	unsigned int reserved1            : BFW_NX10_system_status_reserved1;            /* reserved                                                                                                    */
	unsigned int lic_err_abort_status : BFW_NX10_system_status_lic_err_abort_status; /* Current status of netX licence abort.                                                                       */
	                                                                                 /* Note: This bit must be cleared by writing a '1'. It is not cleared automatically if ARM Abort mode is left. */
	unsigned int reserved2            : BFW_NX10_system_status_reserved2;            /* reserved                                                                                                    */
} NX10_SYSTEM_STATUS_BIT_T;

typedef union {
	unsigned int             val;
	NX10_SYSTEM_STATUS_BIT_T bf;
} NX10_SYSTEM_STATUS_T;

/* --------------------------------------------------------------------- */
/* Register netx_lic_id */
/* => netX License ID Register: */
/*    This register contains license information read from security memory during boot phase */
/*    This register is lockable by netX locking algorithm. It will be only reset on Power on, not on normal system nres. */
/*    This register is protected by the netX access key mechanism; changing this register is only possible by the following sequence: */
/*    1.: read out access key from ACCESS_KEY register */
/*    2.: write back access key to ACCESS_KEY register */
/*    3.: write desired value to this register */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX10_netx_lic_id       0x00000050U
#define Adr_NX10_asic_ctrl_netx_lic_id 0x101C0050U
#define Adr_NX10_netx_lic_id           0x101C0050U
#define DFLT_VAL_NX10_netx_lic_id      0x00000000U

#define MSK_NX10_netx_lic_id_id      0xffffffffU
#define SRT_NX10_netx_lic_id_id      0
#define DFLT_VAL_NX10_netx_lic_id_id 0x00000000U

enum {
	BFW_NX10_netx_lic_id_id = 32  /* [31:0] */
};

typedef struct NX10_NETX_LIC_ID_BIT_Ttag {
	unsigned int id : BFW_NX10_netx_lic_id_id; /* License ID from security memory */
} NX10_NETX_LIC_ID_BIT_T;

typedef union {
	unsigned int           val;
	NX10_NETX_LIC_ID_BIT_T bf;
} NX10_NETX_LIC_ID_T;

/* --------------------------------------------------------------------- */
/* Register netx_lic_flags0 */
/* => netX License Flags 0 Register: */
/*    This register is part of netX licence error detection mechanism. If netX software requested an unavailable licence, this */
/*    will be flagged in netx_lic_errors0 register. */
/*    This register contains license information read from security memory during boot phase */
/*    This register is lockable by netX locking algorithm. It will be only reset on Power on, not on normal system nres. */
/*    This register is protected by the netX access key mechanism; changing this register is only possible by the following sequence: */
/*    1.: read out access key from ACCESS_KEY register */
/*    2.: write back access key to ACCESS_KEY register */
/*    3.: write desired value to this register */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX10_netx_lic_flags0       0x00000054U
#define Adr_NX10_asic_ctrl_netx_lic_flags0 0x101C0054U
#define Adr_NX10_netx_lic_flags0           0x101C0054U
#define DFLT_VAL_NX10_netx_lic_flags0      0x00000000U

#define MSK_NX10_netx_lic_flags0_flags      0xffffffffU
#define SRT_NX10_netx_lic_flags0_flags      0
#define DFLT_VAL_NX10_netx_lic_flags0_flags 0x00000000U

enum {
	BFW_NX10_netx_lic_flags0_flags = 32  /* [31:0] */
};

typedef struct NX10_NETX_LIC_FLAGS0_BIT_Ttag {
	unsigned int flags : BFW_NX10_netx_lic_flags0_flags; /* License flag bits from security memory */
} NX10_NETX_LIC_FLAGS0_BIT_T;

typedef union {
	unsigned int               val;
	NX10_NETX_LIC_FLAGS0_BIT_T bf;
} NX10_NETX_LIC_FLAGS0_T;

/* --------------------------------------------------------------------- */
/* Register netx_lic_flags1 */
/* => netX License Flags 1 Register: */
/*    This register is part of netX licence error detection mechanism. If netX software requested an unavailable licence, this */
/*    will be flagged in netx_lic_errors1 register. */
/*    This register contains license information read from security memory during boot phase */
/*    This register is lockable by netX locking algorithm. It will be only reset on Power on, not on normal system nres. */
/*    This register is protected by the netX access key mechanism; changing this register is only possible by the following sequence: */
/*    1.: read out access key from ACCESS_KEY register */
/*    2.: write back access key to ACCESS_KEY register */
/*    3.: write desired value to this register */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX10_netx_lic_flags1       0x00000058U
#define Adr_NX10_asic_ctrl_netx_lic_flags1 0x101C0058U
#define Adr_NX10_netx_lic_flags1           0x101C0058U
#define DFLT_VAL_NX10_netx_lic_flags1      0x00000000U

#define MSK_NX10_netx_lic_flags1_flags      0xffffffffU
#define SRT_NX10_netx_lic_flags1_flags      0
#define DFLT_VAL_NX10_netx_lic_flags1_flags 0x00000000U

enum {
	BFW_NX10_netx_lic_flags1_flags = 32  /* [31:0] */
};

typedef struct NX10_NETX_LIC_FLAGS1_BIT_Ttag {
	unsigned int flags : BFW_NX10_netx_lic_flags1_flags; /* License flag bits from security memory */
} NX10_NETX_LIC_FLAGS1_BIT_T;

typedef union {
	unsigned int               val;
	NX10_NETX_LIC_FLAGS1_BIT_T bf;
} NX10_NETX_LIC_FLAGS1_T;

/* --------------------------------------------------------------------- */
/* Register netx_lic_errors0 */
/* => netX License Errors 0 Status Register: */
/*    This register is part of netX licence error detection mechanism. If netX software requested a licence not */
/*    provided by netx_lic_flags0, this will be flagged here. */
/*    This register contains 0 in case of no license error */
/* => Mode: R */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX10_netx_lic_errors0       0x0000005CU
#define Adr_NX10_asic_ctrl_netx_lic_errors0 0x101C005CU
#define Adr_NX10_netx_lic_errors0           0x101C005CU

#define MSK_NX10_netx_lic_errors0_err_ro 0xffffffffU
#define SRT_NX10_netx_lic_errors0_err_ro 0

enum {
	BFW_NX10_netx_lic_errors0_err_ro = 32  /* [31:0] */
};

typedef struct NX10_NETX_LIC_ERRORS0_BIT_Ttag {
	unsigned int err_ro : BFW_NX10_netx_lic_errors0_err_ro; /* License error bits set in case of license mismatch according to netx_lic_flags0 (OR of all occured errors) */
} NX10_NETX_LIC_ERRORS0_BIT_T;

typedef union {
	unsigned int                val;
	NX10_NETX_LIC_ERRORS0_BIT_T bf;
} NX10_NETX_LIC_ERRORS0_T;

/* --------------------------------------------------------------------- */
/* Register netx_lic_errors1 */
/* => netX License Errors 1 Status Register: */
/*    This register is part of netX licence error detection mechanism. If netX software requested a licence not */
/*    provided by netx_lic_flags1, this will be flagged here. */
/*    This register contains 0 in case of no license error */
/* => Mode: R */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX10_netx_lic_errors1       0x00000060U
#define Adr_NX10_asic_ctrl_netx_lic_errors1 0x101C0060U
#define Adr_NX10_netx_lic_errors1           0x101C0060U

#define MSK_NX10_netx_lic_errors1_err_ro 0xffffffffU
#define SRT_NX10_netx_lic_errors1_err_ro 0

enum {
	BFW_NX10_netx_lic_errors1_err_ro = 32  /* [31:0] */
};

typedef struct NX10_NETX_LIC_ERRORS1_BIT_Ttag {
	unsigned int err_ro : BFW_NX10_netx_lic_errors1_err_ro; /* License error bits set in case of license mismatch according to netx_lic_flags1 (OR of all occured errors) */
} NX10_NETX_LIC_ERRORS1_BIT_T;

typedef union {
	unsigned int                val;
	NX10_NETX_LIC_ERRORS1_BIT_T bf;
} NX10_NETX_LIC_ERRORS1_T;

/* --------------------------------------------------------------------- */
/* Register asic_ctrl_access_key */
/* => ASIC Control Locking Access Key Register: */
/*    Writing to any register in the asic_ctrl or mmio_ctrl address area is only possible after */
/*    setting the correct key here to avoid unmeant changes e.g. by crashed software. */
/*    ---- */
/*    Changing a control register in the asic_ctrl or mmio_ctrl address area is only possible by the following sequence: */
/*    1.: Read out the Locking Access Key from this register. */
/*    2.: Write back this Locking Access Key to this register. */
/*    3.: Write desired value to the control register. */
/*    ---- */
/*    The Locking Access Key will become invalid after each access to any register in the asic_ctrl or mmio_ctrl address area */
/*    and has to be read out and set again for sequent accesses. */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX10_asic_ctrl_access_key       0x00000070U
#define Adr_NX10_asic_ctrl_asic_ctrl_access_key 0x101C0070U
#define Adr_NX10_asic_ctrl_access_key           0x101C0070U
#define DFLT_VAL_NX10_asic_ctrl_access_key      0x00000000U

#define MSK_NX10_asic_ctrl_access_key_access_key      0x0000ffffU
#define SRT_NX10_asic_ctrl_access_key_access_key      0
#define DFLT_VAL_NX10_asic_ctrl_access_key_access_key 0x00000000U

enum {
	BFW_NX10_asic_ctrl_access_key_access_key = 16, /* [15:0] */
	BFW_NX10_asic_ctrl_access_key_reserved1  = 16  /* [31:16] */
};

typedef struct NX10_ASIC_CTRL_ACCESS_KEY_BIT_Ttag {
	unsigned int access_key : BFW_NX10_asic_ctrl_access_key_access_key; /* Locking Access Key for next write access. */
	unsigned int reserved1  : BFW_NX10_asic_ctrl_access_key_reserved1;  /* reserved                                  */
} NX10_ASIC_CTRL_ACCESS_KEY_BIT_T;

typedef union {
	unsigned int                    val;
	NX10_ASIC_CTRL_ACCESS_KEY_BIT_T bf;
} NX10_ASIC_CTRL_ACCESS_KEY_T;

/* --------------------------------------------------------------------- */
/* Register netx_lock_reserved00 */
/* => reserved address for netX locking purpose */
/* => Mode: R */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX10_netx_lock_reserved00       0x00000074U
#define Adr_NX10_asic_ctrl_netx_lock_reserved00 0x101C0074U
#define Adr_NX10_netx_lock_reserved00           0x101C0074U

#define MSK_NX10_netx_lock_reserved00_lock 0xffffffffU
#define SRT_NX10_netx_lock_reserved00_lock 0

enum {
	BFW_NX10_netx_lock_reserved00_lock = 32  /* [31:0] */
};

typedef struct NX10_NETX_LOCK_RESERVED00_BIT_Ttag {
	unsigned int lock : BFW_NX10_netx_lock_reserved00_lock; /* locking purpose */
} NX10_NETX_LOCK_RESERVED00_BIT_T;

typedef union {
	unsigned int                    val;
	NX10_NETX_LOCK_RESERVED00_BIT_T bf;
} NX10_NETX_LOCK_RESERVED00_T;

/* --------------------------------------------------------------------- */
/* Register netx_lock_reserved01 */
/* => reserved address for netX locking purpose */
/* => Mode: R */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX10_netx_lock_reserved01       0x00000078U
#define Adr_NX10_asic_ctrl_netx_lock_reserved01 0x101C0078U
#define Adr_NX10_netx_lock_reserved01           0x101C0078U

#define MSK_NX10_netx_lock_reserved01_lock 0xffffffffU
#define SRT_NX10_netx_lock_reserved01_lock 0

enum {
	BFW_NX10_netx_lock_reserved01_lock = 32  /* [31:0] */
};

typedef struct NX10_NETX_LOCK_RESERVED01_BIT_Ttag {
	unsigned int lock : BFW_NX10_netx_lock_reserved01_lock; /* locking purpose */
} NX10_NETX_LOCK_RESERVED01_BIT_T;

typedef union {
	unsigned int                    val;
	NX10_NETX_LOCK_RESERVED01_BIT_T bf;
} NX10_NETX_LOCK_RESERVED01_T;

/* --------------------------------------------------------------------- */
/* Register netx_lock_reserved_start */
/* => Reserved start address for netX locking purpose address area */
/*    Don't implement other registers at 0x80 .. 0xfc! */
/* => Mode: R */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX10_netx_lock_reserved_start       0x00000080U
#define Adr_NX10_asic_ctrl_netx_lock_reserved_start 0x101C0080U
#define Adr_NX10_netx_lock_reserved_start           0x101C0080U

#define MSK_NX10_netx_lock_reserved_start_lock 0xffffffffU
#define SRT_NX10_netx_lock_reserved_start_lock 0

enum {
	BFW_NX10_netx_lock_reserved_start_lock = 32  /* [31:0] */
};

typedef struct NX10_NETX_LOCK_RESERVED_START_BIT_Ttag {
	unsigned int lock : BFW_NX10_netx_lock_reserved_start_lock; /* locking purpose */
} NX10_NETX_LOCK_RESERVED_START_BIT_T;

typedef union {
	unsigned int                        val;
	NX10_NETX_LOCK_RESERVED_START_BIT_T bf;
} NX10_NETX_LOCK_RESERVED_START_T;

/* --------------------------------------------------------------------- */
/* Register netx_lock_reserved_end */
/* => Reserved end address for netX locking purpose address area */
/*    Don't implement other registers at 0x80 .. 0xfc! */
/* => Mode: R */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX10_netx_lock_reserved_end       0x000000FCU
#define Adr_NX10_asic_ctrl_netx_lock_reserved_end 0x101C00FCU
#define Adr_NX10_netx_lock_reserved_end           0x101C00FCU

#define MSK_NX10_netx_lock_reserved_end_lock 0xffffffffU
#define SRT_NX10_netx_lock_reserved_end_lock 0

enum {
	BFW_NX10_netx_lock_reserved_end_lock = 32  /* [31:0] */
};

typedef struct NX10_NETX_LOCK_RESERVED_END_BIT_Ttag {
	unsigned int lock : BFW_NX10_netx_lock_reserved_end_lock; /* locking purpose */
} NX10_NETX_LOCK_RESERVED_END_BIT_T;

typedef union {
	unsigned int                      val;
	NX10_NETX_LOCK_RESERVED_END_BIT_T bf;
} NX10_NETX_LOCK_RESERVED_END_T;


/* ===================================================================== */

/* Area of extmemctrl */

/* ===================================================================== */

#define Addr_NX10_extmemctrl 0x101C0100U

/* ===================================================================== */

/* Area of ext_asyncmem_ctrl */

/* ===================================================================== */

#define Addr_NX10_ext_asyncmem_ctrl  0x101C0100U
#define NX10_NETX_MEM_SRAM_CTRL_AREA 0x101C0100U

/* --------------------------------------------------------------------- */
/* Register extsram0_ctrl */
/* => Control Register for external bus interface and Waitstates for ExtMem0 chip select area. */
/*    External ExtMem0 chip select area is mapped to netX internal address area 0xC0000000 to 0xC7FFFFFF. */
/*    External addresses always be byte addresses. */
/*    For 16 bit memory devices, A0 is used as byte low enable. Byte high enable is provided on additional signal. */
/*    For 32 bit interfaces, A0 and A1 are used as byte enables. Additionally there are 2 further byte enable signals provided. */
/*    For additional byte-enables/DQM signals view netX pinout documentation. */
/*    For all wait state configuration 1 cycle is 1 netx system clock cycle, i.e. 10ns for netX running on 100MHz at normal operation. */
/*    Note: Pause and data width configuration is compatible to netx500/100 and netx50. */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX10_extsram0_ctrl               0x00000000U
#define Adr_NX10_ext_asyncmem_ctrl_extsram0_ctrl 0x101C0100U
#define Adr_NX10_extsram0_ctrl                   0x101C0100U
#define DFLT_VAL_NX10_extsram0_ctrl              0x0303033fU

#define MSK_NX10_extsram0_ctrl_ws                    0x0000003fU
#define SRT_NX10_extsram0_ctrl_ws                    0
#define DFLT_VAL_NX10_extsram0_ctrl_ws               0x0000003fU
#define MSK_NX10_extsram0_ctrl_p_pre                 0x00000300U
#define SRT_NX10_extsram0_ctrl_p_pre                 8
#define DFLT_VAL_NX10_extsram0_ctrl_p_pre            0x00000300U
#define MSK_NX10_extsram0_ctrl_p_post                0x00030000U
#define SRT_NX10_extsram0_ctrl_p_post                16
#define DFLT_VAL_NX10_extsram0_ctrl_p_post           0x00030000U
#define MSK_NX10_extsram0_ctrl_dwidth                0x03000000U
#define SRT_NX10_extsram0_ctrl_dwidth                24
#define DFLT_VAL_NX10_extsram0_ctrl_dwidth           0x03000000U
#define MSK_NX10_extsram0_ctrl_no_p_pre_seq_rd       0x10000000U
#define SRT_NX10_extsram0_ctrl_no_p_pre_seq_rd       28
#define DFLT_VAL_NX10_extsram0_ctrl_no_p_pre_seq_rd  0x00000000U
#define MSK_NX10_extsram0_ctrl_no_p_post_seq_rd      0x20000000U
#define SRT_NX10_extsram0_ctrl_no_p_post_seq_rd      29
#define DFLT_VAL_NX10_extsram0_ctrl_no_p_post_seq_rd 0x00000000U
#define MSK_NX10_extsram0_ctrl_ready_en              0x80000000U
#define SRT_NX10_extsram0_ctrl_ready_en              31
#define DFLT_VAL_NX10_extsram0_ctrl_ready_en         0x00000000U

enum {
	BFW_NX10_extsram0_ctrl_ws               = 6, /* [5:0] */
	BFW_NX10_extsram0_ctrl_reserved1        = 2, /* [7:6] */
	BFW_NX10_extsram0_ctrl_p_pre            = 2, /* [9:8] */
	BFW_NX10_extsram0_ctrl_reserved2        = 6, /* [15:10] */
	BFW_NX10_extsram0_ctrl_p_post           = 2, /* [17:16] */
	BFW_NX10_extsram0_ctrl_reserved3        = 6, /* [23:18] */
	BFW_NX10_extsram0_ctrl_dwidth           = 2, /* [25:24] */
	BFW_NX10_extsram0_ctrl_reserved4        = 2, /* [27:26] */
	BFW_NX10_extsram0_ctrl_no_p_pre_seq_rd  = 1, /* [28] */
	BFW_NX10_extsram0_ctrl_no_p_post_seq_rd = 1, /* [29] */
	BFW_NX10_extsram0_ctrl_reserved5        = 1, /* [30] */
	BFW_NX10_extsram0_ctrl_ready_en         = 1  /* [31] */
};

typedef struct NX10_EXTSRAM0_CTRL_BIT_Ttag {
	unsigned int ws               : BFW_NX10_extsram0_ctrl_ws;               /* Wait-States (0 - 63 cycles) of ExtMem0 area.                                              */
	                                                                         /* During read access this is nRD-signal active low phase.                                   */
	unsigned int reserved1        : BFW_NX10_extsram0_ctrl_reserved1;        /* reserved                                                                                  */
	unsigned int p_pre            : BFW_NX10_extsram0_ctrl_p_pre;            /* Pre-Pause (0 - 3 cycles) of ExtMem0 area.                                                 */
	                                                                         /* Additional wait-states to match memory device setup times.                                */
	unsigned int reserved2        : BFW_NX10_extsram0_ctrl_reserved2;        /* reserved                                                                                  */
	unsigned int p_post           : BFW_NX10_extsram0_ctrl_p_post;           /* Post-Pause (0 - 3 cycles) of ExtMem0 area.                                                */
	                                                                         /* Additional wait-states to match memory device Output-Disable or Address-Hold times.       */
	unsigned int reserved3        : BFW_NX10_extsram0_ctrl_reserved3;        /* reserved                                                                                  */
	unsigned int dwidth           : BFW_NX10_extsram0_ctrl_dwidth;           /* Datapath width of ExtMem0 area.                                                           */
	                                                                         /*  00 :  8bit memory device connected to this chip-select address area.                     */
	unsigned int reserved4        : BFW_NX10_extsram0_ctrl_reserved4;        /* reserved                                                                                  */
	unsigned int no_p_pre_seq_rd  : BFW_NX10_extsram0_ctrl_no_p_pre_seq_rd;  /* No Pre-Pause insertion between sequential reads.                                          */
	                                                                         /* 0: Pre-Pause will be inserted after each read access.                                     */
	unsigned int no_p_post_seq_rd : BFW_NX10_extsram0_ctrl_no_p_post_seq_rd; /* No Post-Pause insertion between sequential reads.                                         */
	                                                                         /* 0: Post-Pause will be inserted after each read access.                                    */
	unsigned int reserved5        : BFW_NX10_extsram0_ctrl_reserved5;        /* reserved                                                                                  */
	unsigned int ready_en         : BFW_NX10_extsram0_ctrl_ready_en;         /* Ready Signal Enable.                                                                      */
	                                                                         /* 0: Access timing is only controlled by Wait-State and Pre/Post-Pause configuration above. */
} NX10_EXTSRAM0_CTRL_BIT_T;

typedef union {
	unsigned int             val;
	NX10_EXTSRAM0_CTRL_BIT_T bf;
} NX10_EXTSRAM0_CTRL_T;

/* --------------------------------------------------------------------- */
/* Register extsram1_ctrl */
/* => Control Register for external bus interface and Waitstates for ExtMem1 chip select area. */
/*    External ExtMem1 chip select area is mapped to netX internal address area 0xC8000000 to 0xCFFFFFFF. */
/*    For detailled register description view extsram0_ctrl register. */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX10_extsram1_ctrl               0x00000004U
#define Adr_NX10_ext_asyncmem_ctrl_extsram1_ctrl 0x101C0104U
#define Adr_NX10_extsram1_ctrl                   0x101C0104U
#define DFLT_VAL_NX10_extsram1_ctrl              0x0303033fU

#define MSK_NX10_extsram1_ctrl_ws                    0x0000003fU
#define SRT_NX10_extsram1_ctrl_ws                    0
#define DFLT_VAL_NX10_extsram1_ctrl_ws               0x0000003fU
#define MSK_NX10_extsram1_ctrl_p_pre                 0x00000300U
#define SRT_NX10_extsram1_ctrl_p_pre                 8
#define DFLT_VAL_NX10_extsram1_ctrl_p_pre            0x00000300U
#define MSK_NX10_extsram1_ctrl_p_post                0x00030000U
#define SRT_NX10_extsram1_ctrl_p_post                16
#define DFLT_VAL_NX10_extsram1_ctrl_p_post           0x00030000U
#define MSK_NX10_extsram1_ctrl_dwidth                0x03000000U
#define SRT_NX10_extsram1_ctrl_dwidth                24
#define DFLT_VAL_NX10_extsram1_ctrl_dwidth           0x03000000U
#define MSK_NX10_extsram1_ctrl_no_p_pre_seq_rd       0x10000000U
#define SRT_NX10_extsram1_ctrl_no_p_pre_seq_rd       28
#define DFLT_VAL_NX10_extsram1_ctrl_no_p_pre_seq_rd  0x00000000U
#define MSK_NX10_extsram1_ctrl_no_p_post_seq_rd      0x20000000U
#define SRT_NX10_extsram1_ctrl_no_p_post_seq_rd      29
#define DFLT_VAL_NX10_extsram1_ctrl_no_p_post_seq_rd 0x00000000U
#define MSK_NX10_extsram1_ctrl_ready_en              0x80000000U
#define SRT_NX10_extsram1_ctrl_ready_en              31
#define DFLT_VAL_NX10_extsram1_ctrl_ready_en         0x00000000U

enum {
	BFW_NX10_extsram1_ctrl_ws               = 6, /* [5:0] */
	BFW_NX10_extsram1_ctrl_reserved1        = 2, /* [7:6] */
	BFW_NX10_extsram1_ctrl_p_pre            = 2, /* [9:8] */
	BFW_NX10_extsram1_ctrl_reserved2        = 6, /* [15:10] */
	BFW_NX10_extsram1_ctrl_p_post           = 2, /* [17:16] */
	BFW_NX10_extsram1_ctrl_reserved3        = 6, /* [23:18] */
	BFW_NX10_extsram1_ctrl_dwidth           = 2, /* [25:24] */
	BFW_NX10_extsram1_ctrl_reserved4        = 2, /* [27:26] */
	BFW_NX10_extsram1_ctrl_no_p_pre_seq_rd  = 1, /* [28] */
	BFW_NX10_extsram1_ctrl_no_p_post_seq_rd = 1, /* [29] */
	BFW_NX10_extsram1_ctrl_reserved5        = 1, /* [30] */
	BFW_NX10_extsram1_ctrl_ready_en         = 1  /* [31] */
};

typedef struct NX10_EXTSRAM1_CTRL_BIT_Ttag {
	unsigned int ws               : BFW_NX10_extsram1_ctrl_ws;               /* Wait-States (0 - 63 cycles) of ExtMem1 area.                                          */
	unsigned int reserved1        : BFW_NX10_extsram1_ctrl_reserved1;        /* reserved                                                                              */
	unsigned int p_pre            : BFW_NX10_extsram1_ctrl_p_pre;            /* Pre-Pause (0 - 3 cycles) of ExtMem1 area.                                             */
	unsigned int reserved2        : BFW_NX10_extsram1_ctrl_reserved2;        /* reserved                                                                              */
	unsigned int p_post           : BFW_NX10_extsram1_ctrl_p_post;           /* Post-Pause (0 - 3 cycles) of ExtMem1 area.                                            */
	unsigned int reserved3        : BFW_NX10_extsram1_ctrl_reserved3;        /* reserved                                                                              */
	unsigned int dwidth           : BFW_NX10_extsram1_ctrl_dwidth;           /* Datapath width of ExtMem1 area.                                                       */
	                                                                         /* Note: This chip select is disabled by default and may be shared with other functions. */
	unsigned int reserved4        : BFW_NX10_extsram1_ctrl_reserved4;        /* reserved                                                                              */
	unsigned int no_p_pre_seq_rd  : BFW_NX10_extsram1_ctrl_no_p_pre_seq_rd;  /* No Pre-Pause insertion between sequential reads.                                      */
	unsigned int no_p_post_seq_rd : BFW_NX10_extsram1_ctrl_no_p_post_seq_rd; /* No Post-Pause insertion between sequential reads.                                     */
	unsigned int reserved5        : BFW_NX10_extsram1_ctrl_reserved5;        /* reserved                                                                              */
	unsigned int ready_en         : BFW_NX10_extsram1_ctrl_ready_en;         /* Ready Signal Enable.                                                                  */
} NX10_EXTSRAM1_CTRL_BIT_T;

typedef union {
	unsigned int             val;
	NX10_EXTSRAM1_CTRL_BIT_T bf;
} NX10_EXTSRAM1_CTRL_T;

/* --------------------------------------------------------------------- */
/* Register extsram2_ctrl */
/* => Control Register for external bus interface and Waitstates for ExtMem1 chip select area. */
/*    External ExtMem2 chip select area is mapped to netX internal address area 0xD0000000 to 0xD7FFFFFF. */
/*    For detailled register description view extsram0_ctrl register. */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX10_extsram2_ctrl               0x00000008U
#define Adr_NX10_ext_asyncmem_ctrl_extsram2_ctrl 0x101C0108U
#define Adr_NX10_extsram2_ctrl                   0x101C0108U
#define DFLT_VAL_NX10_extsram2_ctrl              0x0303033fU

#define MSK_NX10_extsram2_ctrl_ws                    0x0000003fU
#define SRT_NX10_extsram2_ctrl_ws                    0
#define DFLT_VAL_NX10_extsram2_ctrl_ws               0x0000003fU
#define MSK_NX10_extsram2_ctrl_p_pre                 0x00000300U
#define SRT_NX10_extsram2_ctrl_p_pre                 8
#define DFLT_VAL_NX10_extsram2_ctrl_p_pre            0x00000300U
#define MSK_NX10_extsram2_ctrl_p_post                0x00030000U
#define SRT_NX10_extsram2_ctrl_p_post                16
#define DFLT_VAL_NX10_extsram2_ctrl_p_post           0x00030000U
#define MSK_NX10_extsram2_ctrl_dwidth                0x03000000U
#define SRT_NX10_extsram2_ctrl_dwidth                24
#define DFLT_VAL_NX10_extsram2_ctrl_dwidth           0x03000000U
#define MSK_NX10_extsram2_ctrl_no_p_pre_seq_rd       0x10000000U
#define SRT_NX10_extsram2_ctrl_no_p_pre_seq_rd       28
#define DFLT_VAL_NX10_extsram2_ctrl_no_p_pre_seq_rd  0x00000000U
#define MSK_NX10_extsram2_ctrl_no_p_post_seq_rd      0x20000000U
#define SRT_NX10_extsram2_ctrl_no_p_post_seq_rd      29
#define DFLT_VAL_NX10_extsram2_ctrl_no_p_post_seq_rd 0x00000000U
#define MSK_NX10_extsram2_ctrl_ready_en              0x80000000U
#define SRT_NX10_extsram2_ctrl_ready_en              31
#define DFLT_VAL_NX10_extsram2_ctrl_ready_en         0x00000000U

enum {
	BFW_NX10_extsram2_ctrl_ws               = 6, /* [5:0] */
	BFW_NX10_extsram2_ctrl_reserved1        = 2, /* [7:6] */
	BFW_NX10_extsram2_ctrl_p_pre            = 2, /* [9:8] */
	BFW_NX10_extsram2_ctrl_reserved2        = 6, /* [15:10] */
	BFW_NX10_extsram2_ctrl_p_post           = 2, /* [17:16] */
	BFW_NX10_extsram2_ctrl_reserved3        = 6, /* [23:18] */
	BFW_NX10_extsram2_ctrl_dwidth           = 2, /* [25:24] */
	BFW_NX10_extsram2_ctrl_reserved4        = 2, /* [27:26] */
	BFW_NX10_extsram2_ctrl_no_p_pre_seq_rd  = 1, /* [28] */
	BFW_NX10_extsram2_ctrl_no_p_post_seq_rd = 1, /* [29] */
	BFW_NX10_extsram2_ctrl_reserved5        = 1, /* [30] */
	BFW_NX10_extsram2_ctrl_ready_en         = 1  /* [31] */
};

typedef struct NX10_EXTSRAM2_CTRL_BIT_Ttag {
	unsigned int ws               : BFW_NX10_extsram2_ctrl_ws;               /* Wait-States (0 - 63 cycles) of ExtMem2 area.                                          */
	unsigned int reserved1        : BFW_NX10_extsram2_ctrl_reserved1;        /* reserved                                                                              */
	unsigned int p_pre            : BFW_NX10_extsram2_ctrl_p_pre;            /* Pre-Pause (0 - 3 cycles) of ExtMem2 area.                                             */
	unsigned int reserved2        : BFW_NX10_extsram2_ctrl_reserved2;        /* reserved                                                                              */
	unsigned int p_post           : BFW_NX10_extsram2_ctrl_p_post;           /* Post-Pause (0 - 3 cycles) of ExtMem2 area.                                            */
	unsigned int reserved3        : BFW_NX10_extsram2_ctrl_reserved3;        /* reserved                                                                              */
	unsigned int dwidth           : BFW_NX10_extsram2_ctrl_dwidth;           /* Datapath width of ExtMem2 area.                                                       */
	                                                                         /* Note: This chip select is disabled by default and may be shared with other functions. */
	unsigned int reserved4        : BFW_NX10_extsram2_ctrl_reserved4;        /* reserved                                                                              */
	unsigned int no_p_pre_seq_rd  : BFW_NX10_extsram2_ctrl_no_p_pre_seq_rd;  /* No Pre-Pause insertion between sequential reads.                                      */
	unsigned int no_p_post_seq_rd : BFW_NX10_extsram2_ctrl_no_p_post_seq_rd; /* No Post-Pause insertion between sequential reads.                                     */
	unsigned int reserved5        : BFW_NX10_extsram2_ctrl_reserved5;        /* reserved                                                                              */
	unsigned int ready_en         : BFW_NX10_extsram2_ctrl_ready_en;         /* Ready Signal Enable.                                                                  */
} NX10_EXTSRAM2_CTRL_BIT_T;

typedef union {
	unsigned int             val;
	NX10_EXTSRAM2_CTRL_BIT_T bf;
} NX10_EXTSRAM2_CTRL_T;

/* --------------------------------------------------------------------- */
/* Register extsram3_ctrl */
/* => Control Register for external bus interface and Waitstates for ExtMem1 chip select area. */
/*    External ExtMem3 chip select area is mapped to netX internal address area 0xD8000000 to 0xDFFFFFFF. */
/*    For detailled register description view extsram0_ctrl register. */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX10_extsram3_ctrl               0x0000000CU
#define Adr_NX10_ext_asyncmem_ctrl_extsram3_ctrl 0x101C010CU
#define Adr_NX10_extsram3_ctrl                   0x101C010CU
#define DFLT_VAL_NX10_extsram3_ctrl              0x0303033fU

#define MSK_NX10_extsram3_ctrl_ws                    0x0000003fU
#define SRT_NX10_extsram3_ctrl_ws                    0
#define DFLT_VAL_NX10_extsram3_ctrl_ws               0x0000003fU
#define MSK_NX10_extsram3_ctrl_p_pre                 0x00000300U
#define SRT_NX10_extsram3_ctrl_p_pre                 8
#define DFLT_VAL_NX10_extsram3_ctrl_p_pre            0x00000300U
#define MSK_NX10_extsram3_ctrl_p_post                0x00030000U
#define SRT_NX10_extsram3_ctrl_p_post                16
#define DFLT_VAL_NX10_extsram3_ctrl_p_post           0x00030000U
#define MSK_NX10_extsram3_ctrl_dwidth                0x03000000U
#define SRT_NX10_extsram3_ctrl_dwidth                24
#define DFLT_VAL_NX10_extsram3_ctrl_dwidth           0x03000000U
#define MSK_NX10_extsram3_ctrl_no_p_pre_seq_rd       0x10000000U
#define SRT_NX10_extsram3_ctrl_no_p_pre_seq_rd       28
#define DFLT_VAL_NX10_extsram3_ctrl_no_p_pre_seq_rd  0x00000000U
#define MSK_NX10_extsram3_ctrl_no_p_post_seq_rd      0x20000000U
#define SRT_NX10_extsram3_ctrl_no_p_post_seq_rd      29
#define DFLT_VAL_NX10_extsram3_ctrl_no_p_post_seq_rd 0x00000000U
#define MSK_NX10_extsram3_ctrl_ready_en              0x80000000U
#define SRT_NX10_extsram3_ctrl_ready_en              31
#define DFLT_VAL_NX10_extsram3_ctrl_ready_en         0x00000000U

enum {
	BFW_NX10_extsram3_ctrl_ws               = 6, /* [5:0] */
	BFW_NX10_extsram3_ctrl_reserved1        = 2, /* [7:6] */
	BFW_NX10_extsram3_ctrl_p_pre            = 2, /* [9:8] */
	BFW_NX10_extsram3_ctrl_reserved2        = 6, /* [15:10] */
	BFW_NX10_extsram3_ctrl_p_post           = 2, /* [17:16] */
	BFW_NX10_extsram3_ctrl_reserved3        = 6, /* [23:18] */
	BFW_NX10_extsram3_ctrl_dwidth           = 2, /* [25:24] */
	BFW_NX10_extsram3_ctrl_reserved4        = 2, /* [27:26] */
	BFW_NX10_extsram3_ctrl_no_p_pre_seq_rd  = 1, /* [28] */
	BFW_NX10_extsram3_ctrl_no_p_post_seq_rd = 1, /* [29] */
	BFW_NX10_extsram3_ctrl_reserved5        = 1, /* [30] */
	BFW_NX10_extsram3_ctrl_ready_en         = 1  /* [31] */
};

typedef struct NX10_EXTSRAM3_CTRL_BIT_Ttag {
	unsigned int ws               : BFW_NX10_extsram3_ctrl_ws;               /* Wait-States (0 - 63 cycles) of ExtMem3 area.                                          */
	unsigned int reserved1        : BFW_NX10_extsram3_ctrl_reserved1;        /* reserved                                                                              */
	unsigned int p_pre            : BFW_NX10_extsram3_ctrl_p_pre;            /* Pre-Pause (0 - 3 cycles) of ExtMem3 area.                                             */
	unsigned int reserved2        : BFW_NX10_extsram3_ctrl_reserved2;        /* reserved                                                                              */
	unsigned int p_post           : BFW_NX10_extsram3_ctrl_p_post;           /* Post-Pause (0 - 3 cycles) of ExtMem3 area.                                            */
	unsigned int reserved3        : BFW_NX10_extsram3_ctrl_reserved3;        /* reserved                                                                              */
	unsigned int dwidth           : BFW_NX10_extsram3_ctrl_dwidth;           /* Datapath width of ExtMem3 area.                                                       */
	                                                                         /* Note: This chip select is disabled by default and may be shared with other functions. */
	unsigned int reserved4        : BFW_NX10_extsram3_ctrl_reserved4;        /* reserved                                                                              */
	unsigned int no_p_pre_seq_rd  : BFW_NX10_extsram3_ctrl_no_p_pre_seq_rd;  /* No Pre-Pause insertion between sequential reads.                                      */
	unsigned int no_p_post_seq_rd : BFW_NX10_extsram3_ctrl_no_p_post_seq_rd; /* No Post-Pause insertion between sequential reads.                                     */
	unsigned int reserved5        : BFW_NX10_extsram3_ctrl_reserved5;        /* reserved                                                                              */
	unsigned int ready_en         : BFW_NX10_extsram3_ctrl_ready_en;         /* Ready Signal Enable.                                                                  */
} NX10_EXTSRAM3_CTRL_BIT_T;

typedef union {
	unsigned int             val;
	NX10_EXTSRAM3_CTRL_BIT_T bf;
} NX10_EXTSRAM3_CTRL_T;

/* --------------------------------------------------------------------- */
/* Register ext_cs0_apm_ctrl */
/* => Asynchronouse Page Mode Control Register for ExtMem0 chip select area. */
/*    Only ExtMem0 chip-select area supports fast Asynchronouse-Page-Mode (APM) Access. */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX10_ext_cs0_apm_ctrl               0x00000010U
#define Adr_NX10_ext_asyncmem_ctrl_ext_cs0_apm_ctrl 0x101C0110U
#define Adr_NX10_ext_cs0_apm_ctrl                   0x101C0110U
#define DFLT_VAL_NX10_ext_cs0_apm_ctrl              0x0000000fU

#define MSK_NX10_ext_cs0_apm_ctrl_ws_apm       0x0000000fU
#define SRT_NX10_ext_cs0_apm_ctrl_ws_apm       0
#define DFLT_VAL_NX10_ext_cs0_apm_ctrl_ws_apm  0x0000000fU
#define MSK_NX10_ext_cs0_apm_ctrl_apm_cfg      0x00000700U
#define SRT_NX10_ext_cs0_apm_ctrl_apm_cfg      8
#define DFLT_VAL_NX10_ext_cs0_apm_ctrl_apm_cfg 0x00000000U

enum {
	BFW_NX10_ext_cs0_apm_ctrl_ws_apm    = 4,  /* [3:0] */
	BFW_NX10_ext_cs0_apm_ctrl_reserved1 = 4,  /* [7:4] */
	BFW_NX10_ext_cs0_apm_ctrl_apm_cfg   = 3,  /* [10:8] */
	BFW_NX10_ext_cs0_apm_ctrl_reserved2 = 21  /* [31:11] */
};

typedef struct NX10_EXT_CS0_APM_CTRL_BIT_Ttag {
	unsigned int ws_apm    : BFW_NX10_ext_cs0_apm_ctrl_ws_apm;    /* APM read burst wait-states (0 - 15 cycles).                  */
	                                                              /* If APM is enabled by apm_cfg-bits, first read access is done */
	unsigned int reserved1 : BFW_NX10_ext_cs0_apm_ctrl_reserved1; /* reserved                                                     */
	unsigned int apm_cfg   : BFW_NX10_ext_cs0_apm_ctrl_apm_cfg;   /* APM configuration.                                           */
	                                                              /* 000 : read bursts are disabled                               */
	unsigned int reserved2 : BFW_NX10_ext_cs0_apm_ctrl_reserved2; /* reserved                                                     */
} NX10_EXT_CS0_APM_CTRL_BIT_T;

typedef union {
	unsigned int                val;
	NX10_EXT_CS0_APM_CTRL_BIT_T bf;
} NX10_EXT_CS0_APM_CTRL_T;

/* --------------------------------------------------------------------- */
/* Register ext_rdy_cfg */
/* => External Memory Ready Control Register. */
/*    Note: Timeout is generated if ready usage is enabled by the extsramX_ctrl registers and is not asserted to active state within 10us. */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX10_ext_rdy_cfg               0x00000020U
#define Adr_NX10_ext_asyncmem_ctrl_ext_rdy_cfg 0x101C0120U
#define Adr_NX10_ext_rdy_cfg                   0x101C0120U
#define DFLT_VAL_NX10_ext_rdy_cfg              0x00000001U

#define MSK_NX10_ext_rdy_cfg_rdy_act_level      0x00000001U
#define SRT_NX10_ext_rdy_cfg_rdy_act_level      0
#define DFLT_VAL_NX10_ext_rdy_cfg_rdy_act_level 0x00000001U
#define MSK_NX10_ext_rdy_cfg_rdy_filter         0x00000030U
#define SRT_NX10_ext_rdy_cfg_rdy_filter         4
#define DFLT_VAL_NX10_ext_rdy_cfg_rdy_filter    0x00000000U
#define MSK_NX10_ext_rdy_cfg_rdy_to_irq_en      0x00000100U
#define SRT_NX10_ext_rdy_cfg_rdy_to_irq_en      8
#define DFLT_VAL_NX10_ext_rdy_cfg_rdy_to_irq_en 0x00000000U
#define MSK_NX10_ext_rdy_cfg_rdy_to_dis         0x00000800U
#define SRT_NX10_ext_rdy_cfg_rdy_to_dis         11
#define DFLT_VAL_NX10_ext_rdy_cfg_rdy_to_dis    0x00000000U

enum {
	BFW_NX10_ext_rdy_cfg_rdy_act_level = 1,  /* [0] */
	BFW_NX10_ext_rdy_cfg_reserved1     = 3,  /* [3:1] */
	BFW_NX10_ext_rdy_cfg_rdy_filter    = 2,  /* [5:4] */
	BFW_NX10_ext_rdy_cfg_reserved2     = 2,  /* [7:6] */
	BFW_NX10_ext_rdy_cfg_rdy_to_irq_en = 1,  /* [8] */
	BFW_NX10_ext_rdy_cfg_reserved3     = 2,  /* [10:9] */
	BFW_NX10_ext_rdy_cfg_rdy_to_dis    = 1,  /* [11] */
	BFW_NX10_ext_rdy_cfg_reserved4     = 20  /* [31:12] */
};

typedef struct NX10_EXT_RDY_CFG_BIT_Ttag {
	unsigned int rdy_act_level : BFW_NX10_ext_rdy_cfg_rdy_act_level; /* Ready Active Level                                                                      */
	                                                                 /* 0: Ready is active low / stall access while ready input is high.                        */
	unsigned int reserved1     : BFW_NX10_ext_rdy_cfg_reserved1;     /* reserved                                                                                */
	unsigned int rdy_filter    : BFW_NX10_ext_rdy_cfg_rdy_filter;    /* Ready Input Filter.                                                                     */
	                                                                 /* Ready input filering is implemented to avoid false ready active detection especially if */
	unsigned int reserved2     : BFW_NX10_ext_rdy_cfg_reserved2;     /* reserved                                                                                */
	unsigned int rdy_to_irq_en : BFW_NX10_ext_rdy_cfg_rdy_to_irq_en; /* Ready Timeout IRQ Enable                                                                */
	                                                                 /* 0: No IRQ generation in case of ready timeout.                                          */
	unsigned int reserved3     : BFW_NX10_ext_rdy_cfg_reserved3;     /* reserved                                                                                */
	unsigned int rdy_to_dis    : BFW_NX10_ext_rdy_cfg_rdy_to_dis;    /* Ready Timeout Disable                                                                   */
	                                                                 /* By default ready timeout is enabled. Timeout is generated if ready usage is enabled     */
	unsigned int reserved4     : BFW_NX10_ext_rdy_cfg_reserved4;     /* reserved                                                                                */
} NX10_EXT_RDY_CFG_BIT_T;

typedef union {
	unsigned int           val;
	NX10_EXT_RDY_CFG_BIT_T bf;
} NX10_EXT_RDY_CFG_T;

/* --------------------------------------------------------------------- */
/* Register ext_rdy_status */
/* => External Memory Ready Status Register. */
/*    Note: Timeout is generated if ready usage is enabled by the extsramX_ctrl registers and is not asserted to active state within 10us. */
/* => Mode: R */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX10_ext_rdy_status               0x00000024U
#define Adr_NX10_ext_asyncmem_ctrl_ext_rdy_status 0x101C0124U
#define Adr_NX10_ext_rdy_status                   0x101C0124U

#define MSK_NX10_ext_rdy_status_rdy_to_err_adr 0x00ffffffU
#define SRT_NX10_ext_rdy_status_rdy_to_err_adr 0
#define MSK_NX10_ext_rdy_status_rdy_to_err_cs  0x03000000U
#define SRT_NX10_ext_rdy_status_rdy_to_err_cs  24
#define MSK_NX10_ext_rdy_status_rdy_to_err     0x80000000U
#define SRT_NX10_ext_rdy_status_rdy_to_err     31

enum {
	BFW_NX10_ext_rdy_status_rdy_to_err_adr = 24, /* [23:0] */
	BFW_NX10_ext_rdy_status_rdy_to_err_cs  = 2,  /* [25:24] */
	BFW_NX10_ext_rdy_status_reserved1      = 5,  /* [30:26] */
	BFW_NX10_ext_rdy_status_rdy_to_err     = 1   /* [31] */
};

typedef struct NX10_EXT_RDY_STATUS_BIT_Ttag {
	unsigned int rdy_to_err_adr : BFW_NX10_ext_rdy_status_rdy_to_err_adr; /* Ready timeout error address logging.                                       */
	unsigned int rdy_to_err_cs  : BFW_NX10_ext_rdy_status_rdy_to_err_cs;  /* Ready timeout error chip-select logging.                                   */
	unsigned int reserved1      : BFW_NX10_ext_rdy_status_reserved1;      /* reserved                                                                   */
	unsigned int rdy_to_err     : BFW_NX10_ext_rdy_status_rdy_to_err;     /* Ready Timeout Error.                                                       */
	                                                                      /* This bit is set if a ready timeout error is detected. The external address */
} NX10_EXT_RDY_STATUS_BIT_T;

typedef union {
	unsigned int              val;
	NX10_EXT_RDY_STATUS_BIT_T bf;
} NX10_EXT_RDY_STATUS_T;


/* ===================================================================== */

/* Area of ext_sdram_ctrl */

/* ===================================================================== */

#define Addr_NX10_ext_sdram_ctrl      0x101C0140U
#define NX10_NETX_MEM_SDRAM_CTRL_AREA 0x101C0140U

/* --------------------------------------------------------------------- */
/* Register sdram_general_ctrl */
/* => Control Register for external SDRAM access. */
/*    ---------------------------------------------------------- */
/*    No DDR/DDR2 support in netX! Don't regard DDR/DDR2 options */
/*    ---------------------------------------------------------- */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX10_sdram_general_ctrl            0x00000000U
#define Adr_NX10_ext_sdram_ctrl_sdram_general_ctrl 0x101C0140U
#define Adr_NX10_sdram_general_ctrl                0x101C0140U
#define DFLT_VAL_NX10_sdram_general_ctrl           0x01000001U

#define MSK_NX10_sdram_general_ctrl_banks               0x00000003U
#define SRT_NX10_sdram_general_ctrl_banks               0
#define DFLT_VAL_NX10_sdram_general_ctrl_banks          0x00000001U
#define MSK_NX10_sdram_general_ctrl_rows                0x00000070U
#define SRT_NX10_sdram_general_ctrl_rows                4
#define DFLT_VAL_NX10_sdram_general_ctrl_rows           0x00000000U
#define MSK_NX10_sdram_general_ctrl_columns             0x00000700U
#define SRT_NX10_sdram_general_ctrl_columns             8
#define DFLT_VAL_NX10_sdram_general_ctrl_columns        0x00000000U
#define MSK_NX10_sdram_general_ctrl_dbus16              0x00010000U
#define SRT_NX10_sdram_general_ctrl_dbus16              16
#define DFLT_VAL_NX10_sdram_general_ctrl_dbus16         0x00000000U
#define MSK_NX10_sdram_general_ctrl_sdram_pwdn          0x00020000U
#define SRT_NX10_sdram_general_ctrl_sdram_pwdn          17
#define DFLT_VAL_NX10_sdram_general_ctrl_sdram_pwdn     0x00000000U
#define MSK_NX10_sdram_general_ctrl_extclk_en           0x00040000U
#define SRT_NX10_sdram_general_ctrl_extclk_en           18
#define DFLT_VAL_NX10_sdram_general_ctrl_extclk_en      0x00000000U
#define MSK_NX10_sdram_general_ctrl_ctrl_en             0x00080000U
#define SRT_NX10_sdram_general_ctrl_ctrl_en             19
#define DFLT_VAL_NX10_sdram_general_ctrl_ctrl_en        0x00000000U
#define MSK_NX10_sdram_general_ctrl_refresh_mode        0x03000000U
#define SRT_NX10_sdram_general_ctrl_refresh_mode        24
#define DFLT_VAL_NX10_sdram_general_ctrl_refresh_mode   0x01000000U
#define MSK_NX10_sdram_general_ctrl_sdram_ready         0x40000000U
#define SRT_NX10_sdram_general_ctrl_sdram_ready         30
#define DFLT_VAL_NX10_sdram_general_ctrl_sdram_ready    0x00000000U
#define MSK_NX10_sdram_general_ctrl_refresh_status      0x80000000U
#define SRT_NX10_sdram_general_ctrl_refresh_status      31
#define DFLT_VAL_NX10_sdram_general_ctrl_refresh_status 0x00000000U

enum {
	BFW_NX10_sdram_general_ctrl_banks          = 2, /* [1:0] */
	BFW_NX10_sdram_general_ctrl_reserved1      = 2, /* [3:2] */
	BFW_NX10_sdram_general_ctrl_rows           = 3, /* [6:4] */
	BFW_NX10_sdram_general_ctrl_reserved2      = 1, /* [7] */
	BFW_NX10_sdram_general_ctrl_columns        = 3, /* [10:8] */
	BFW_NX10_sdram_general_ctrl_reserved3      = 5, /* [15:11] */
	BFW_NX10_sdram_general_ctrl_dbus16         = 1, /* [16] */
	BFW_NX10_sdram_general_ctrl_sdram_pwdn     = 1, /* [17] */
	BFW_NX10_sdram_general_ctrl_extclk_en      = 1, /* [18] */
	BFW_NX10_sdram_general_ctrl_ctrl_en        = 1, /* [19] */
	BFW_NX10_sdram_general_ctrl_reserved4      = 4, /* [23:20] */
	BFW_NX10_sdram_general_ctrl_refresh_mode   = 2, /* [25:24] */
	BFW_NX10_sdram_general_ctrl_reserved5      = 4, /* [29:26] */
	BFW_NX10_sdram_general_ctrl_sdram_ready    = 1, /* [30] */
	BFW_NX10_sdram_general_ctrl_refresh_status = 1  /* [31] */
};

typedef struct NX10_SDRAM_GENERAL_CTRL_BIT_Ttag {
	unsigned int banks          : BFW_NX10_sdram_general_ctrl_banks;          /* Bank address coding.                                                                                              */
	                                                                          /* 00 : 2                                                                                                            */
	unsigned int reserved1      : BFW_NX10_sdram_general_ctrl_reserved1;      /* reserved                                                                                                          */
	unsigned int rows           : BFW_NX10_sdram_general_ctrl_rows;           /* Row address coding.                                                                                               */
	                                                                          /* 000 : 2k  (A0..A10) (default)                                                                                     */
	unsigned int reserved2      : BFW_NX10_sdram_general_ctrl_reserved2;      /* reserved                                                                                                          */
	unsigned int columns        : BFW_NX10_sdram_general_ctrl_columns;        /* Column address coding.                                                                                            */
	                                                                          /* 000 : 256 (A0..A7) (default)                                                                                      */
	unsigned int reserved3      : BFW_NX10_sdram_general_ctrl_reserved3;      /* reserved                                                                                                          */
	unsigned int dbus16         : BFW_NX10_sdram_general_ctrl_dbus16;         /* SDRAM data bus width                                                                                              */
	                                                                          /* 0: SDRAM data bus is 8 bit wide.  (default)                                                                       */
	unsigned int sdram_pwdn     : BFW_NX10_sdram_general_ctrl_sdram_pwdn;     /* SDRAM power down                                                                                                  */
	                                                                          /* If this bit is set, the Controller will move SDRAM to power down self refresh mode (no data loss)                 */
	unsigned int extclk_en      : BFW_NX10_sdram_general_ctrl_extclk_en;      /* external SDRAM clock enable                                                                                       */
	                                                                          /* 0: SDRAM clock disabled.  (default)                                                                               */
	unsigned int ctrl_en        : BFW_NX10_sdram_general_ctrl_ctrl_en;        /*  SDRAM controller enable                                                                                          */
	                                                                          /*  The sdram_timing_ctrl-register can only be changed while this bit is 0.                                          */
	unsigned int reserved4      : BFW_NX10_sdram_general_ctrl_reserved4;      /* reserved                                                                                                          */
	unsigned int refresh_mode   : BFW_NX10_sdram_general_ctrl_refresh_mode;   /* Refresh request generation mode.                                                                                  */
	                                                                          /* Refresh generation has always lower priority than accesses on external memory interface.                          */
	unsigned int reserved5      : BFW_NX10_sdram_general_ctrl_reserved5;      /* reserved                                                                                                          */
	unsigned int sdram_ready    : BFW_NX10_sdram_general_ctrl_sdram_ready;    /* SDRAM ready.                                                                                                      */
	                                                                          /* This bit is set to 1 if SDRAM is ready for access. If sdram_general_ctrl.ctrl_en == 0 or                          */
	unsigned int refresh_status : BFW_NX10_sdram_general_ctrl_refresh_status; /* Refresh status flag.                                                                                              */
	                                                                          /* Refresh behaviour changed from netx100/500/50: SDRAM Controller now has an additional high priority refresh mode. */
} NX10_SDRAM_GENERAL_CTRL_BIT_T;

typedef union {
	unsigned int                  val;
	NX10_SDRAM_GENERAL_CTRL_BIT_T bf;
} NX10_SDRAM_GENERAL_CTRL_T;

/* --------------------------------------------------------------------- */
/* Register sdram_timing_ctrl */
/* => Control Register for external SDRAM access. */
/*    Changes can only be done, if the SDRAM-Controller is disabled (sdram_general_ctrl.ctrl_en == 0) */
/*    to avoid configuration problems. */
/*    ---------------------------------------------------------- */
/*    No DDR/DDR2 support in netX! Don't regard DDR/DDR2 options */
/*    ---------------------------------------------------------- */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX10_sdram_timing_ctrl            0x00000004U
#define Adr_NX10_ext_sdram_ctrl_sdram_timing_ctrl 0x101C0144U
#define Adr_NX10_sdram_timing_ctrl                0x101C0144U
#define DFLT_VAL_NX10_sdram_timing_ctrl           0x0381f7f3U

#define MSK_NX10_sdram_timing_ctrl_t_RCD                  0x00000003U
#define SRT_NX10_sdram_timing_ctrl_t_RCD                  0
#define DFLT_VAL_NX10_sdram_timing_ctrl_t_RCD             0x00000003U
#define MSK_NX10_sdram_timing_ctrl_t_WR                   0x00000030U
#define SRT_NX10_sdram_timing_ctrl_t_WR                   4
#define DFLT_VAL_NX10_sdram_timing_ctrl_t_WR              0x00000030U
#define MSK_NX10_sdram_timing_ctrl_t_RP                   0x000000c0U
#define SRT_NX10_sdram_timing_ctrl_t_RP                   6
#define DFLT_VAL_NX10_sdram_timing_ctrl_t_RP              0x000000c0U
#define MSK_NX10_sdram_timing_ctrl_t_RAS                  0x00000700U
#define SRT_NX10_sdram_timing_ctrl_t_RAS                  8
#define DFLT_VAL_NX10_sdram_timing_ctrl_t_RAS             0x00000700U
#define MSK_NX10_sdram_timing_ctrl_t_RFC                  0x0000f000U
#define SRT_NX10_sdram_timing_ctrl_t_RFC                  12
#define DFLT_VAL_NX10_sdram_timing_ctrl_t_RFC             0x0000f000U
#define MSK_NX10_sdram_timing_ctrl_t_REFI                 0x00030000U
#define SRT_NX10_sdram_timing_ctrl_t_REFI                 16
#define DFLT_VAL_NX10_sdram_timing_ctrl_t_REFI            0x00010000U
#define MSK_NX10_sdram_timing_ctrl_mem_sdclk_phase        0x00700000U
#define SRT_NX10_sdram_timing_ctrl_mem_sdclk_phase        20
#define DFLT_VAL_NX10_sdram_timing_ctrl_mem_sdclk_phase   0x00000000U
#define MSK_NX10_sdram_timing_ctrl_mem_sdclk_ssneg        0x00800000U
#define SRT_NX10_sdram_timing_ctrl_mem_sdclk_ssneg        23
#define DFLT_VAL_NX10_sdram_timing_ctrl_mem_sdclk_ssneg   0x00800000U
#define MSK_NX10_sdram_timing_ctrl_data_sample_phase      0x07000000U
#define SRT_NX10_sdram_timing_ctrl_data_sample_phase      24
#define DFLT_VAL_NX10_sdram_timing_ctrl_data_sample_phase 0x03000000U
#define MSK_NX10_sdram_timing_ctrl_bypass_neg_delay       0x10000000U
#define SRT_NX10_sdram_timing_ctrl_bypass_neg_delay       28
#define DFLT_VAL_NX10_sdram_timing_ctrl_bypass_neg_delay  0x00000000U

enum {
	BFW_NX10_sdram_timing_ctrl_t_RCD             = 2, /* [1:0] */
	BFW_NX10_sdram_timing_ctrl_reserved1         = 2, /* [3:2] */
	BFW_NX10_sdram_timing_ctrl_t_WR              = 2, /* [5:4] */
	BFW_NX10_sdram_timing_ctrl_t_RP              = 2, /* [7:6] */
	BFW_NX10_sdram_timing_ctrl_t_RAS             = 3, /* [10:8] */
	BFW_NX10_sdram_timing_ctrl_reserved2         = 1, /* [11] */
	BFW_NX10_sdram_timing_ctrl_t_RFC             = 4, /* [15:12] */
	BFW_NX10_sdram_timing_ctrl_t_REFI            = 2, /* [17:16] */
	BFW_NX10_sdram_timing_ctrl_reserved3         = 2, /* [19:18] */
	BFW_NX10_sdram_timing_ctrl_mem_sdclk_phase   = 3, /* [22:20] */
	BFW_NX10_sdram_timing_ctrl_mem_sdclk_ssneg   = 1, /* [23] */
	BFW_NX10_sdram_timing_ctrl_data_sample_phase = 3, /* [26:24] */
	BFW_NX10_sdram_timing_ctrl_reserved4         = 1, /* [27] */
	BFW_NX10_sdram_timing_ctrl_bypass_neg_delay  = 1, /* [28] */
	BFW_NX10_sdram_timing_ctrl_reserved5         = 3  /* [31:29] */
};

typedef struct NX10_SDRAM_TIMING_CTRL_BIT_Ttag {
	unsigned int t_RCD             : BFW_NX10_sdram_timing_ctrl_t_RCD;             /* ACTIVE to READ or WRITE time (RAS to CAS, clk = t_RCD)                                       */
	                                                                               /* This value will be also taken as t_RRD (ACTIVE bank A to ACTIVE bank B time)                 */
	unsigned int reserved1         : BFW_NX10_sdram_timing_ctrl_reserved1;         /* reserved                                                                                     */
	unsigned int t_WR              : BFW_NX10_sdram_timing_ctrl_t_WR;              /* Write recovery time (last write data to PRECHARGE)                                           */
	                                                                               /* 00 : 1 clk                                                                                   */
	unsigned int t_RP              : BFW_NX10_sdram_timing_ctrl_t_RP;              /* Precharge command period time (PRECHARGE to next command)                                    */
	                                                                               /* 00 : 1 clk                                                                                   */
	unsigned int t_RAS             : BFW_NX10_sdram_timing_ctrl_t_RAS;             /* ACTIVE to PRECHARGE command time (clk = t_RAS + 3)                                           */
	                                                                               /* 000 :  3 clks                                                                                */
	unsigned int reserved2         : BFW_NX10_sdram_timing_ctrl_reserved2;         /* reserved                                                                                     */
	unsigned int t_RFC             : BFW_NX10_sdram_timing_ctrl_t_RFC;             /* REFRESH to next command time (clk = tRFC + 4)                                                */
	                                                                               /* 0000 :  4 clks                                                                               */
	unsigned int t_REFI            : BFW_NX10_sdram_timing_ctrl_t_REFI;            /* Average periodic refresh interval (3.90 us * 2^t_REFI                                        */
	                                                                               /* 00 :   3.90 us                                                                               */
	unsigned int reserved3         : BFW_NX10_sdram_timing_ctrl_reserved3;         /* reserved                                                                                     */
	unsigned int mem_sdclk_phase   : BFW_NX10_sdram_timing_ctrl_mem_sdclk_phase;   /* MEM_SDCLK phase shift.                                                                       */
	                                                                               /* 0..5: adjustable phase-shift for external SDRAM clock depending on external capacitive       */
	unsigned int mem_sdclk_ssneg   : BFW_NX10_sdram_timing_ctrl_mem_sdclk_ssneg;   /* MEM_SDCLK start sample with negative clk400 edge for MEM_SDCLK phase shift                   */
	                                                                               /* 1: clk_memsig will be sampled for MEM_SDCLK-generation internally first on negedge of clk400 */
	unsigned int data_sample_phase : BFW_NX10_sdram_timing_ctrl_data_sample_phase; /* Data sample clock phase shift.                                                               */
	                                                                               /* 0..5: adjustable phase-shift for data sampling SDRAM loopback clock (clk_sdloopback)         */
	unsigned int reserved4         : BFW_NX10_sdram_timing_ctrl_reserved4;         /* reserved                                                                                     */
	unsigned int bypass_neg_delay  : BFW_NX10_sdram_timing_ctrl_bypass_neg_delay;  /* Bypass data sample clock phase shift.                                                        */
	                                                                               /* 0: use phase shifted (negative delayed) SDRAM loopback clock for data sampling.              */
	unsigned int reserved5         : BFW_NX10_sdram_timing_ctrl_reserved5;         /* reserved                                                                                     */
} NX10_SDRAM_TIMING_CTRL_BIT_T;

typedef union {
	unsigned int                 val;
	NX10_SDRAM_TIMING_CTRL_BIT_T bf;
} NX10_SDRAM_TIMING_CTRL_T;

/* --------------------------------------------------------------------- */
/* Register sdram_mr */
/* => Mode Register for all SDRAM device types and Extended Mode Register for DDR/DDR2-SDRAM-devices. */
/*    Changes can only be done, if the SDRAM-Controller is disabled (sdram_general_ctrl.ctrl_en == 0) */
/*    to avoid configuration problems. */
/*    The SDRAM Mode Registers will be set after enabling the SDRAM Controller in the 200us */
/*    SDRAM memory initialisation procedure. */
/*    ---------------------------------------------------------- */
/*    No DDR/DDR2 support in netX! Don't regard DDR/DDR2 options */
/*    ---------------------------------------------------------- */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX10_sdram_mr            0x00000008U
#define Adr_NX10_ext_sdram_ctrl_sdram_mr 0x101C0148U
#define Adr_NX10_sdram_mr                0x101C0148U
#define DFLT_VAL_NX10_sdram_mr           0x00000033U

#define MSK_NX10_sdram_mr_MR      0x00003fffU
#define SRT_NX10_sdram_mr_MR      0
#define DFLT_VAL_NX10_sdram_mr_MR 0x00000033U

enum {
	BFW_NX10_sdram_mr_MR        = 14, /* [13:0] */
	BFW_NX10_sdram_mr_reserved1 = 18  /* [31:14] */
};

typedef struct NX10_SDRAM_MR_BIT_Ttag {
	unsigned int MR        : BFW_NX10_sdram_mr_MR;        /* SDRAM Mode Register.                                                                 */
	                                                      /* CAS latency bits in MR[6:4], only CL2 and CL3 are supported, not CL1; default is CL3 */
	unsigned int reserved1 : BFW_NX10_sdram_mr_reserved1; /* reserved                                                                             */
} NX10_SDRAM_MR_BIT_T;

typedef union {
	unsigned int        val;
	NX10_SDRAM_MR_BIT_T bf;
} NX10_SDRAM_MR_T;


/* ===================================================================== */

/* Area of watchdog */

/* ===================================================================== */

#define Addr_NX10_watchdog 0x101C0200U
#define NX10_NETX_WDG_AREA 0x101C0200U

/* --------------------------------------------------------------------- */
/* Register netx_sys_wdg_ctrl */
/* => netX System Watchdog Trigger Register. */
/*    The watchdog access code is generated by a pseudo random generator. */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX10_netx_sys_wdg_ctrl      0x00000000U
#define Adr_NX10_watchdog_netx_sys_wdg_ctrl 0x101C0200U
#define Adr_NX10_netx_sys_wdg_ctrl          0x101C0200U
#define DFLT_VAL_NX10_netx_sys_wdg_ctrl     0x00000000U

#define MSK_NX10_netx_sys_wdg_ctrl_wdg_access_code            0x000fffffU
#define SRT_NX10_netx_sys_wdg_ctrl_wdg_access_code            0
#define DFLT_VAL_NX10_netx_sys_wdg_ctrl_wdg_access_code       0x00000000U
#define MSK_NX10_netx_sys_wdg_ctrl_irq_req_watchdog           0x01000000U
#define SRT_NX10_netx_sys_wdg_ctrl_irq_req_watchdog           24
#define DFLT_VAL_NX10_netx_sys_wdg_ctrl_irq_req_watchdog      0x00000000U
#define MSK_NX10_netx_sys_wdg_ctrl_wdg_counter_trigger_w      0x10000000U
#define SRT_NX10_netx_sys_wdg_ctrl_wdg_counter_trigger_w      28
#define DFLT_VAL_NX10_netx_sys_wdg_ctrl_wdg_counter_trigger_w 0x00000000U
#define MSK_NX10_netx_sys_wdg_ctrl_wdg_active_enable_w        0x20000000U
#define SRT_NX10_netx_sys_wdg_ctrl_wdg_active_enable_w        29
#define DFLT_VAL_NX10_netx_sys_wdg_ctrl_wdg_active_enable_w   0x00000000U
#define MSK_NX10_netx_sys_wdg_ctrl_write_enable               0x80000000U
#define SRT_NX10_netx_sys_wdg_ctrl_write_enable               31
#define DFLT_VAL_NX10_netx_sys_wdg_ctrl_write_enable          0x00000000U

enum {
	BFW_NX10_netx_sys_wdg_ctrl_wdg_access_code       = 20, /* [19:0] */
	BFW_NX10_netx_sys_wdg_ctrl_reserved1             = 4,  /* [23:20] */
	BFW_NX10_netx_sys_wdg_ctrl_irq_req_watchdog      = 1,  /* [24] */
	BFW_NX10_netx_sys_wdg_ctrl_reserved2             = 3,  /* [27:25] */
	BFW_NX10_netx_sys_wdg_ctrl_wdg_counter_trigger_w = 1,  /* [28] */
	BFW_NX10_netx_sys_wdg_ctrl_wdg_active_enable_w   = 1,  /* [29] */
	BFW_NX10_netx_sys_wdg_ctrl_reserved3             = 1,  /* [30] */
	BFW_NX10_netx_sys_wdg_ctrl_write_enable          = 1   /* [31] */
};

typedef struct NX10_NETX_SYS_WDG_CTRL_BIT_Ttag {
	unsigned int wdg_access_code       : BFW_NX10_netx_sys_wdg_ctrl_wdg_access_code;       /* Watchdog access code for triggering. A read access gives the next 16 bit code for trigger. */
	                                                                                       /* A write access with correct access code will trigger the watchdog counter.                 */
	unsigned int reserved1             : BFW_NX10_netx_sys_wdg_ctrl_reserved1;             /* reserved                                                                                   */
	unsigned int irq_req_watchdog      : BFW_NX10_netx_sys_wdg_ctrl_irq_req_watchdog;      /* IRQ request of watchdog, writing 1 deletes IRQ                                             */
	unsigned int reserved2             : BFW_NX10_netx_sys_wdg_ctrl_reserved2;             /* reserved                                                                                   */
	unsigned int wdg_counter_trigger_w : BFW_NX10_netx_sys_wdg_ctrl_wdg_counter_trigger_w; /* Watchdog trigger bit:                                                                      */
	                                                                                       /* Bit must be set to trigger the watchdog counter.                                           */
	unsigned int wdg_active_enable_w   : BFW_NX10_netx_sys_wdg_ctrl_wdg_active_enable_w;   /* Watchdog Active Enable:                                                                    */
	                                                                                       /* If this bit is set, the WDGACT output signal (PIN G17) is enabled.                         */
	unsigned int reserved3             : BFW_NX10_netx_sys_wdg_ctrl_reserved3;             /* reserved                                                                                   */
	unsigned int write_enable          : BFW_NX10_netx_sys_wdg_ctrl_write_enable;          /* Write enable bit for timeout register:                                                     */
	                                                                                       /* As long as this bit is not set all write accesses to the timeout register are ignored.     */
} NX10_NETX_SYS_WDG_CTRL_BIT_T;

typedef union {
	unsigned int                 val;
	NX10_NETX_SYS_WDG_CTRL_BIT_T bf;
} NX10_NETX_SYS_WDG_CTRL_T;

/* --------------------------------------------------------------------- */
/* Register netx_sys_wdg */
/* => netX System Watchdog Register */
/* => Mode: R */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX10_netx_sys_wdg      0x00000004U
#define Adr_NX10_watchdog_netx_sys_wdg 0x101C0204U
#define Adr_NX10_netx_sys_wdg          0x101C0204U

#define MSK_NX10_netx_sys_wdg_wdg_counter 0x0001ffffU
#define SRT_NX10_netx_sys_wdg_wdg_counter 0

enum {
	BFW_NX10_netx_sys_wdg_wdg_counter = 17, /* [16:0] */
	BFW_NX10_netx_sys_wdg_reserved1   = 15  /* [31:17] */
};

typedef struct NX10_NETX_SYS_WDG_BIT_Ttag {
	unsigned int wdg_counter : BFW_NX10_netx_sys_wdg_wdg_counter; /* Actual watchdog counter value */
	unsigned int reserved1   : BFW_NX10_netx_sys_wdg_reserved1;   /* reserved                      */
} NX10_NETX_SYS_WDG_BIT_T;

typedef union {
	unsigned int            val;
	NX10_NETX_SYS_WDG_BIT_T bf;
} NX10_NETX_SYS_WDG_T;

/* --------------------------------------------------------------------- */
/* Register netx_sys_wdg_irq_timeout */
/* => netX System Wachtdog Interrupt Timout Register */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX10_netx_sys_wdg_irq_timeout      0x00000008U
#define Adr_NX10_watchdog_netx_sys_wdg_irq_timeout 0x101C0208U
#define Adr_NX10_netx_sys_wdg_irq_timeout          0x101C0208U
#define DFLT_VAL_NX10_netx_sys_wdg_irq_timeout     0x00000000U

#define MSK_NX10_netx_sys_wdg_irq_timeout_wdg_irq_timeout      0x0000ffffU
#define SRT_NX10_netx_sys_wdg_irq_timeout_wdg_irq_timeout      0
#define DFLT_VAL_NX10_netx_sys_wdg_irq_timeout_wdg_irq_timeout 0x00000000U

enum {
	BFW_NX10_netx_sys_wdg_irq_timeout_wdg_irq_timeout = 16, /* [15:0] */
	BFW_NX10_netx_sys_wdg_irq_timeout_reserved1       = 16  /* [31:16] */
};

typedef struct NX10_NETX_SYS_WDG_IRQ_TIMEOUT_BIT_Ttag {
	unsigned int wdg_irq_timeout : BFW_NX10_netx_sys_wdg_irq_timeout_wdg_irq_timeout; /* Watchdog interrupt timeout */
	unsigned int reserved1       : BFW_NX10_netx_sys_wdg_irq_timeout_reserved1;       /* reserved                   */
} NX10_NETX_SYS_WDG_IRQ_TIMEOUT_BIT_T;

typedef union {
	unsigned int                        val;
	NX10_NETX_SYS_WDG_IRQ_TIMEOUT_BIT_T bf;
} NX10_NETX_SYS_WDG_IRQ_TIMEOUT_T;

/* --------------------------------------------------------------------- */
/* Register netx_sys_wdg_res_timeout */
/* => netX System Watchdog Reset Timeout Register */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX10_netx_sys_wdg_res_timeout      0x0000000CU
#define Adr_NX10_watchdog_netx_sys_wdg_res_timeout 0x101C020CU
#define Adr_NX10_netx_sys_wdg_res_timeout          0x101C020CU
#define DFLT_VAL_NX10_netx_sys_wdg_res_timeout     0x00000000U

#define MSK_NX10_netx_sys_wdg_res_timeout_wdg_res_timeout      0x0000ffffU
#define SRT_NX10_netx_sys_wdg_res_timeout_wdg_res_timeout      0
#define DFLT_VAL_NX10_netx_sys_wdg_res_timeout_wdg_res_timeout 0x00000000U

enum {
	BFW_NX10_netx_sys_wdg_res_timeout_wdg_res_timeout = 16, /* [15:0] */
	BFW_NX10_netx_sys_wdg_res_timeout_reserved1       = 16  /* [31:16] */
};

typedef struct NX10_NETX_SYS_WDG_RES_TIMEOUT_BIT_Ttag {
	unsigned int wdg_res_timeout : BFW_NX10_netx_sys_wdg_res_timeout_wdg_res_timeout; /* Watchdog Reset Request Timeout */
	unsigned int reserved1       : BFW_NX10_netx_sys_wdg_res_timeout_reserved1;       /* reserved                       */
} NX10_NETX_SYS_WDG_RES_TIMEOUT_BIT_T;

typedef union {
	unsigned int                        val;
	NX10_NETX_SYS_WDG_RES_TIMEOUT_BIT_T bf;
} NX10_NETX_SYS_WDG_RES_TIMEOUT_T;


/* ===================================================================== */

/* Area of abort */

/* ===================================================================== */

#define Addr_NX10_abort      0x101C0300U
#define NX10_NETX_ABORT_AREA 0x101C0300U

/* ===================================================================== */

/* AREA gpio */
/* Area of gpio, gpio_motion */

/* ===================================================================== */

#define Addr_NX10_gpio        0x101C0800U
#define NX10_NETX_GPIO_AREA   0x101C0800U
#define Addr_NX10_gpio_motion 0x10140400U

/* --------------------------------------------------------------------- */
/* Register gpio_cfg0 */
/* => GPIO pin 0 config register */
/*    This register is accessible via intlogic and intlogic_motion address area. */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX10_gpio_cfg0         0x00000000U
#define Adr_NX10_gpio_gpio_cfg0        0x101C0800U
#define Adr_NX10_gpio_motion_gpio_cfg0 0x10140400U
#define DFLT_VAL_NX10_gpio_cfg0        0x00000000U

#define MSK_NX10_gpio_cfg0_mode           0x0000000fU
#define SRT_NX10_gpio_cfg0_mode           0
#define DFLT_VAL_NX10_gpio_cfg0_mode      0x00000000U
#define MSK_NX10_gpio_cfg0_inv            0x00000010U
#define SRT_NX10_gpio_cfg0_inv            4
#define DFLT_VAL_NX10_gpio_cfg0_inv       0x00000000U
#define MSK_NX10_gpio_cfg0_count_ref      0x00000060U
#define SRT_NX10_gpio_cfg0_count_ref      5
#define DFLT_VAL_NX10_gpio_cfg0_count_ref 0x00000000U

enum {
	BFW_NX10_gpio_cfg0_mode      = 4,  /* [3:0] */
	BFW_NX10_gpio_cfg0_inv       = 1,  /* [4] */
	BFW_NX10_gpio_cfg0_count_ref = 2,  /* [6:5] */
	BFW_NX10_gpio_cfg0_reserved1 = 25  /* [31:7] */
};

typedef struct NX10_GPIO_CFG0_BIT_Ttag {
	unsigned int mode      : BFW_NX10_gpio_cfg0_mode;      /* defines the gp input or output mode - depends on iocfg */
	                                                       /* Input modi :                                           */
	unsigned int inv       : BFW_NX10_gpio_cfg0_inv;       /* 1: invert input/output value                           */
	                                                       /* 0: don't invert input/output                           */
	unsigned int count_ref : BFW_NX10_gpio_cfg0_count_ref; /* counter reference                                      */
	                                                       /*  00: counter 0                                         */
	unsigned int reserved1 : BFW_NX10_gpio_cfg0_reserved1; /* reserved                                               */
} NX10_GPIO_CFG0_BIT_T;

typedef union {
	unsigned int         val;
	NX10_GPIO_CFG0_BIT_T bf;
} NX10_GPIO_CFG0_T;

/* --------------------------------------------------------------------- */
/* Register gpio_cfg1 */
/* => GPIO pin 1 config register */
/*    This register is accessible via intlogic and intlogic_motion address area. */
/* => Mode: R/W */
/* --------------------------------------------------------------------- */

#define REL_Adr_NX10_gpio_cfg1         0x00000004U
#define Adr_NX10_gpio_gpio_cfg1        0x101C0804U
#define Adr_NX10_gpio_motion_gpio_cfg1 0x10140404U
#define DFLT_VAL_NX10_gpio_cfg1        0x00000000U

#define MSK_NX10_gpio_cfg1_mode           0x0000000fU
#define SRT_NX10_gpio_cfg1_mode           0
#define DFLT_VAL_NX10_gpio_cfg1_mode      0x00000000U
#define MSK_NX10_gpio_cfg1_inv            0x00000010U
#define SRT_NX10_gpio_cfg1_inv            4
#define DFLT_VAL_NX10_gpio_cfg1_inv       0x00000000U
#define MSK_NX10_gpio_cfg1_count_ref      0x00000060U
#define SRT_NX10_gpio_cfg1_count_ref      5
#define DFLT_VAL_NX10_gpio_cfg1_count_ref 0x00000000U

enum {
	BFW_NX10_gpio_cfg1_mode      = 4,  /* [3:0] */
	BFW_NX10_gpio_cfg1_inv       = 1,  /* [4] */
	BFW_NX10_gpio_cfg1_count_ref = 2,  /* [6:5] */
	BFW_NX10_gpio_cfg1_reserved1 = 25  /* [31:7] */
};

typedef struct NX10_GPIO_CFG1_BIT_Ttag {
	unsigned int mode      : BFW_NX10_gpio_cfg1_mode;      /* analog to gpio_cfg0 */
	unsigned int inv       : BFW_NX10_gpio_cfg1_inv;       /* analog to gpio_cfg0 */
	unsigned int count_ref : BFW_NX10_gpio_cfg1_count_ref; /* analog to gpio_cfg0 */
	unsigned int reserved1 : B